/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.properties;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.CharsetEncoder;

public class PropertiesFileHelper {
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String unescapeFromPropertiesFile(String text) {
        StringBuilder out = new StringBuilder();
        int offset = 0;
        int length = text.length();
        while (offset < length) {
            char c;
            if ((c = text.charAt(offset++)) == '\\') {
                if ((c = text.charAt(offset++)) == 'u') {
                    int value = 0;
                    block12: for (int i = 0; i < 4; ++i) {
                        c = text.charAt(offset++);
                        switch (c) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                value = (value << 4) + c - 48;
                                continue block12;
                            }
                            case 'a': 
                            case 'b': 
                            case 'c': 
                            case 'd': 
                            case 'e': 
                            case 'f': {
                                value = (value << 4) + 10 + c - 97;
                                continue block12;
                            }
                            case 'A': 
                            case 'B': 
                            case 'C': 
                            case 'D': 
                            case 'E': 
                            case 'F': {
                                value = (value << 4) + 10 + c - 65;
                                continue block12;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                    }
                    out.append((char)value);
                    continue;
                }
                switch (c) {
                    case 't': {
                        c = '\t';
                        break;
                    }
                    case 'r': {
                        c = '\r';
                        break;
                    }
                    case 'n': {
                        c = '\n';
                        break;
                    }
                    case 'f': {
                        c = '\f';
                    }
                }
                out.append(c);
                continue;
            }
            out.append(c);
        }
        return out.toString();
    }

    public static String escapeForPropertyFile(String text, boolean escapeKey, CharsetEncoder encoder, boolean regexpReplacement) {
        int length = text.length();
        StringBuilder out = new StringBuilder(length * 2);
        block8: for (int x = 0; x < length; ++x) {
            char c = text.charAt(x);
            if (c > '=' && c < '\u007f') {
                if (c == '\\') {
                    out.append('\\');
                    out.append('\\');
                    continue;
                }
                out.append(c);
                continue;
            }
            switch (c) {
                case ' ': {
                    if (x == 0 || escapeKey) {
                        out.append('\\');
                    }
                    out.append(' ');
                    continue block8;
                }
                case '\t': {
                    out.append('\\');
                    out.append('t');
                    continue block8;
                }
                case '\n': {
                    out.append('\\');
                    out.append('n');
                    continue block8;
                }
                case '\r': {
                    out.append('\\');
                    out.append('r');
                    continue block8;
                }
                case '\f': {
                    out.append('\\');
                    out.append('f');
                    continue block8;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': {
                    if (escapeKey || encoder == null) {
                        out.append('\\');
                    }
                    out.append(c);
                    continue block8;
                }
                default: {
                    if (!PropertiesFileHelper.canEncode(c, encoder)) {
                        if (regexpReplacement) {
                            out.append('\\');
                        }
                        out.append('\\');
                        out.append('u');
                        out.append(PropertiesFileHelper.toHex(c >> 12 & 0xF));
                        out.append(PropertiesFileHelper.toHex(c >> 8 & 0xF));
                        out.append(PropertiesFileHelper.toHex(c >> 4 & 0xF));
                        out.append(PropertiesFileHelper.toHex(c & 0xF));
                        continue block8;
                    }
                    out.append(c);
                }
            }
        }
        return out.toString();
    }

    private static boolean canEncode(char c, CharsetEncoder encoder) {
        if (encoder == null) {
            return c >= ' ' && c <= '~';
        }
        return c >= ' ' && encoder.canEncode(c);
    }

    public static void writeComments(String comments, BufferedWriter writer, CharsetEncoder encoder) throws IOException {
        int current;
        int length = comments.length();
        int last = 0;
        char[] uu = new char[6];
        uu[0] = 92;
        uu[1] = 117;
        for (current = 0; current < length; ++current) {
            char c = comments.charAt(current);
            if (PropertiesFileHelper.canEncodeForComments(c, encoder) && c != '\n' && c != '\r') continue;
            if (last != current) {
                writer.write(comments.substring(last, current));
            }
            if (c > '\u00ff') {
                uu[2] = PropertiesFileHelper.toHex(c >> 12 & 0xF);
                uu[3] = PropertiesFileHelper.toHex(c >> 8 & 0xF);
                uu[4] = PropertiesFileHelper.toHex(c >> 4 & 0xF);
                uu[5] = PropertiesFileHelper.toHex(c & 0xF);
                writer.write(new String(uu));
            } else {
                writer.newLine();
                if (c == '\r' && current != length - 1 && comments.charAt(current + 1) == '\n') {
                    ++current;
                }
            }
            last = current + 1;
        }
        if (last != current) {
            writer.write(comments.substring(last, current));
        }
        writer.newLine();
    }

    private static boolean canEncodeForComments(char c, CharsetEncoder encoder) {
        if (encoder == null) {
            return c >= ' ' && c <= '\u00ff';
        }
        return c >= ' ' && encoder.canEncode(c);
    }

    private static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }
}

