/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.adt;

import ca.odell.glazedlists.impl.adt.SparseList;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class SparseListNode {
    private SparseListNode parent;
    private SparseList host;
    private SparseListNode left = null;
    private SparseListNode right = null;
    private int totalRightSize = 0;
    private int totalLeftSize = 0;
    private int emptySpace = 0;
    private int height = 1;
    private Object value = null;

    SparseListNode(SparseList host, SparseListNode parent, Object value) {
        this.host = host;
        this.parent = parent;
        this.value = value;
    }

    SparseListNode(SparseList host, SparseListNode parent, Object value, int emptySpace) {
        this(host, parent, value);
        this.emptySpace = emptySpace;
    }

    int size() {
        return this.totalLeftSize + this.emptySpace + this.totalRightSize + 1;
    }

    void insert(int index, Object value) {
        int localizedIndex = index - this.totalLeftSize;
        if (localizedIndex < 0) {
            ++this.totalLeftSize;
            this.left.insert(index, value);
        } else if (localizedIndex > this.emptySpace) {
            ++this.totalRightSize;
            this.right.insert(localizedIndex - this.emptySpace - 1, value);
        } else if (localizedIndex < this.emptySpace) {
            this.emptySpace -= localizedIndex;
            this.totalLeftSize += localizedIndex + 1;
            if (this.left == null) {
                this.left = new SparseListNode(this.host, this, value, localizedIndex);
                this.ensureAVL();
            } else {
                this.left.insertAtEnd(value, localizedIndex);
            }
        } else {
            this.insertAtThisNode(value);
        }
    }

    private void insertAtThisNode(Object value) {
        SparseListNode replacement = new SparseListNode(this.host, this.parent, value, this.emptySpace);
        this.emptySpace = 0;
        replacement.height = this.height;
        this.height = 1;
        replacement.totalRightSize = this.totalRightSize + 1;
        replacement.left = this.left;
        if (this.left != null) {
            replacement.left.parent = replacement;
            replacement.totalLeftSize = this.totalLeftSize;
            this.totalLeftSize = 0;
            this.left = null;
        }
        if (this.parent == null) {
            this.host.setRootNode(replacement);
        } else {
            this.parent.replace(this, replacement);
        }
        if (this.right == null) {
            this.parent = replacement;
            replacement.right = this;
            replacement.ensureAVL();
        } else {
            replacement.right = this.right;
            replacement.right.parent = replacement;
            this.totalRightSize = 0;
            this.right = null;
            replacement.right.moveToSmallest(this);
        }
    }

    void insertAtEnd(Object value, int leadingNulls) {
        this.totalRightSize += leadingNulls + 1;
        if (this.right != null) {
            this.right.insertAtEnd(value, leadingNulls);
        } else {
            this.right = new SparseListNode(this.host, this, value, leadingNulls);
            this.ensureAVL();
        }
    }

    void insertEmptySpace(int index, int length) {
        int localizedIndex = index - this.totalLeftSize;
        if (localizedIndex < 0) {
            this.totalLeftSize += length;
            this.left.insertEmptySpace(index, length);
        } else if (localizedIndex > this.emptySpace) {
            this.totalRightSize += length;
            this.right.insertEmptySpace(localizedIndex - this.emptySpace - 1, length);
        } else {
            this.emptySpace += length;
        }
    }

    private void moveToSmallest(SparseListNode movingNode) {
        this.totalLeftSize += movingNode.emptySpace + 1;
        if (this.left != null) {
            this.left.moveToSmallest(movingNode);
        } else {
            movingNode.parent = this;
            this.left = movingNode;
            this.ensureAVL();
        }
    }

    public int getIndex() {
        if (this.parent != null) {
            return this.parent.getIndex(this) + this.totalLeftSize + this.emptySpace;
        }
        return this.totalLeftSize + this.emptySpace;
    }

    private int getIndex(SparseListNode child) {
        if (child == this.left) {
            if (this.parent != null) {
                return this.parent.getIndex(this);
            }
            return 0;
        }
        if (this.parent != null) {
            return this.parent.getIndex(this) + this.totalLeftSize + this.emptySpace + 1;
        }
        return this.totalLeftSize + this.emptySpace + 1;
    }

    SparseListNode getNode(int index) {
        int localizedIndex = index - this.totalLeftSize;
        if (localizedIndex < 0) {
            return this.left.getNode(index);
        }
        if (localizedIndex > this.emptySpace) {
            return this.right.getNode(localizedIndex - this.emptySpace - 1);
        }
        if (localizedIndex < this.emptySpace) {
            return null;
        }
        return this;
    }

    public Object getValue() {
        return this.value;
    }

    public Object setValue(Object value) {
        if (value != null) {
            Object oldValue = this.value;
            this.value = value;
            return oldValue;
        }
        ++this.emptySpace;
        return this.unlink();
    }

    Object set(int index, Object value) {
        int localizedIndex = index - this.totalLeftSize;
        if (localizedIndex < 0) {
            return this.left.set(index, value);
        }
        if (localizedIndex > this.emptySpace) {
            return this.right.set(localizedIndex - this.emptySpace - 1, value);
        }
        if (localizedIndex < this.emptySpace) {
            if (value == null) {
                return null;
            }
            --this.emptySpace;
            this.insert(index, value);
            return null;
        }
        return this.setValue(value);
    }

    Object remove(int index) {
        int localizedIndex = index - this.totalLeftSize;
        if (localizedIndex < 0) {
            --this.totalLeftSize;
            return this.left.remove(index);
        }
        if (localizedIndex > this.emptySpace) {
            --this.totalRightSize;
            return this.right.remove(localizedIndex - this.emptySpace - 1);
        }
        if (localizedIndex < this.emptySpace) {
            --this.emptySpace;
            return null;
        }
        return this.unlink();
    }

    private Object unlink() {
        int index = -1;
        SparseListNode replacement = null;
        boolean isLeftChild = false;
        if (this.right != null && this.left != null) {
            return this.unlinkFromTwoChildren();
        }
        if (this.right != null) {
            replacement = this.right;
            replacement.parent = this.parent;
            replacement.emptySpace += this.emptySpace;
        } else {
            if (this.left != null) {
                replacement = this.left;
                replacement.parent = this.parent;
            } else {
                replacement = null;
            }
            if (this.parent == null) {
                index = this.emptySpace == 0 ? -1 : this.host.size();
            } else if (this.parent.left == this) {
                isLeftChild = true;
                this.parent.emptySpace += this.emptySpace;
                this.parent.totalLeftSize -= this.emptySpace;
            } else if (this.emptySpace != 0) {
                index = this.getIndex() - this.emptySpace;
            }
        }
        if (this.parent != null) {
            this.parent.replace(this, replacement);
            this.parent.ensureAVL();
        } else {
            this.host.setRootNode(replacement);
        }
        if (index != -1) {
            if (this.parent != null) {
                this.parent.prepareForReinsert(isLeftChild, this.emptySpace);
            }
            this.host.addNulls(index, this.emptySpace);
        }
        return this.clear();
    }

    private Object unlinkFromTwoChildren() {
        SparseListNode replacement = this.right.pruneSmallestChild();
        SparseListNode repParent = replacement.parent;
        replacement.emptySpace += this.emptySpace;
        replacement.height = this.height;
        replacement.left = this.left;
        replacement.left.parent = replacement;
        replacement.totalLeftSize = this.totalLeftSize;
        replacement.parent = this.parent;
        if (this.parent == null) {
            this.host.setRootNode(replacement);
        } else {
            this.parent.replace(this, replacement);
        }
        if (repParent == this) {
            replacement.ensureAVL();
        } else {
            repParent.left = replacement.right;
            if (repParent.left != null) {
                repParent.left.parent = repParent;
            }
            repParent.totalLeftSize = replacement.totalRightSize;
            replacement.right = this.right;
            replacement.right.parent = replacement;
            replacement.totalRightSize = replacement.right.size();
            repParent.ensureAVL();
        }
        return this.clear();
    }

    private SparseListNode pruneSmallestChild() {
        if (this.left != null) {
            SparseListNode prunedNode = this.left.pruneSmallestChild();
            this.totalLeftSize -= prunedNode.emptySpace + 1;
            return prunedNode;
        }
        return this;
    }

    private void prepareForReinsert(boolean leftChild, int length) {
        if (leftChild) {
            this.totalLeftSize -= length;
        } else {
            this.totalRightSize -= length;
        }
        if (this.parent != null) {
            this.parent.prepareForReinsert(this.parent.left == this, length);
        } else {
            this.host.treeSizeChanged();
        }
    }

    private Object clear() {
        this.left = null;
        this.totalLeftSize = 0;
        this.right = null;
        this.totalRightSize = 0;
        this.host = null;
        this.parent = null;
        this.emptySpace = 0;
        this.height = -1;
        Object thisValue = this.value;
        this.value = null;
        return thisValue;
    }

    private void ensureAVL() {
        int oldHeight = this.height;
        this.recalculateHeight();
        this.avlRotate();
        if (this.height != oldHeight && this.parent != null) {
            this.parent.ensureAVL();
        }
    }

    private void replace(SparseListNode child, SparseListNode replacement) {
        if (child == this.left) {
            this.left = replacement;
        } else {
            this.right = replacement;
        }
    }

    private void recalculateHeight() {
        int leftHeight = this.left == null ? 0 : this.left.height;
        int rightHeight = this.right == null ? 0 : this.right.height;
        this.height = 1 + Math.max(leftHeight, rightHeight);
    }

    private void avlRotate() {
        int rightHeight;
        int leftHeight = this.left != null ? this.left.height : 0;
        int n = rightHeight = this.right != null ? this.right.height : 0;
        if (leftHeight - rightHeight >= 2) {
            int leftRightHeight;
            int leftLeftHeight = this.left.left != null ? this.left.left.height : 0;
            int n2 = leftRightHeight = this.left.right != null ? this.left.right.height : 0;
            if (leftRightHeight > leftLeftHeight) {
                this.left.rotateRight();
            }
            this.rotateLeft();
        } else if (rightHeight - leftHeight >= 2) {
            int rightRightHeight;
            int rightLeftHeight = this.right.left != null ? this.right.left.height : 0;
            int n3 = rightRightHeight = this.right.right != null ? this.right.right.height : 0;
            if (rightLeftHeight > rightRightHeight) {
                this.right.rotateLeft();
            }
            this.rotateRight();
        }
    }

    private void rotateLeft() {
        SparseListNode replacement = this.left;
        this.left = replacement.right;
        this.totalLeftSize = replacement.totalRightSize;
        if (replacement.right != null) {
            replacement.right.parent = this;
        }
        replacement.right = this;
        replacement.totalRightSize = this.size();
        if (this.parent != null) {
            this.parent.replace(this, replacement);
        } else {
            this.host.setRootNode(replacement);
        }
        replacement.parent = this.parent;
        this.parent = replacement;
        this.recalculateHeight();
        replacement.height = 0;
    }

    private void rotateRight() {
        SparseListNode replacement = this.right;
        this.right = replacement.left;
        this.totalRightSize = replacement.totalLeftSize;
        if (replacement.left != null) {
            replacement.left.parent = this;
        }
        replacement.left = this;
        replacement.totalLeftSize = this.size();
        if (this.parent != null) {
            this.parent.replace(this, replacement);
        } else {
            this.host.setRootNode(replacement);
        }
        replacement.parent = this.parent;
        this.parent = replacement;
        this.recalculateHeight();
        replacement.height = 0;
    }

    public String toString() {
        return "[ " + this.left + " <" + this.emptySpace + "> " + this.value + " <" + this.height + "> " + this.right + " ]";
    }

    private void correctSizes(int sizeChange) {
        if (this.parent != null) {
            if (this.parent.left == this) {
                this.totalLeftSize += sizeChange;
            } else {
                this.totalRightSize += sizeChange;
            }
            this.parent.correctSizes(sizeChange);
        } else {
            this.host.treeSizeChanged();
        }
    }

    static final class SparseListIterator
    implements Iterator {
        private SparseListNode currentNode = null;
        private int timesRequested = -1;
        private SparseList sparseList = null;
        private int treeSize = 0;
        private int size = 0;
        private int index = -1;

        SparseListIterator(SparseList sparseList, SparseListNode root) {
            if (root != null) {
                this.treeSize = root.size();
                this.currentNode = root;
                while (this.currentNode.left != null) {
                    this.currentNode = this.currentNode.left;
                }
            }
            this.sparseList = sparseList;
            this.size = sparseList.size();
        }

        @Override
        public boolean hasNext() {
            return this.index < this.treeSize - 1 || this.index != this.size - 1;
        }

        public Object next() {
            ++this.timesRequested;
            ++this.index;
            if (this.currentNode == null) {
                if (this.index < this.size) {
                    return null;
                }
                throw new NoSuchElementException();
            }
            if (this.timesRequested > this.currentNode.emptySpace) {
                if (this.index < this.treeSize) {
                    this.findNextNode();
                    this.timesRequested = 0;
                } else {
                    if (this.index < this.size) {
                        return null;
                    }
                    throw new NoSuchElementException();
                }
            }
            if (this.timesRequested < this.currentNode.emptySpace) {
                return null;
            }
            if (this.timesRequested == this.currentNode.emptySpace) {
                return this.currentNode.value;
            }
            throw new IllegalStateException();
        }

        @Override
        public void remove() {
            if (this.timesRequested == -1) {
                throw new IllegalStateException("Cannot remove() without a prior call to next()");
            }
            if (this.currentNode == null || this.index >= this.treeSize) {
                this.sparseList.remove(this.index);
            } else if (this.timesRequested < this.currentNode.emptySpace) {
                this.currentNode.correctSizes(-1);
                this.currentNode.emptySpace--;
            } else if (this.timesRequested == this.currentNode.emptySpace) {
                this.currentNode.correctSizes(-1);
                SparseListNode nodeToRemove = this.currentNode;
                this.findNextNode();
                this.timesRequested = -1;
                nodeToRemove.unlink();
            } else {
                throw new IllegalStateException();
            }
        }

        private void findNextNode() {
            if (this.currentNode.right != null) {
                this.currentNode = this.currentNode.right;
                while (this.currentNode.left != null) {
                    this.currentNode = this.currentNode.left;
                }
            } else if (this.currentNode.parent.left == this.currentNode) {
                this.currentNode = this.currentNode.parent;
            } else if (this.currentNode.parent.right == this.currentNode) {
                while (this.currentNode.parent.right == this.currentNode) {
                    this.currentNode = this.currentNode.parent;
                }
                this.currentNode = this.currentNode.parent;
            } else {
                throw new IllegalStateException();
            }
        }

        private void findPreviousNode() {
            throw new UnsupportedOperationException("Not implemented yet.");
        }

        public String toString() {
            return "Accessing " + this.currentNode + " for the " + this.timesRequested + " time.";
        }
    }
}

