/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.chunking;

import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.chunking.ChunkTag;

public class ChunkTaggedToken {
    private final String token;
    private final List<ChunkTag> chunkTags;
    private final AnalyzedTokenReadings readings;

    public ChunkTaggedToken(String token, List<ChunkTag> chunkTags, AnalyzedTokenReadings readings) {
        this.token = Objects.requireNonNull(token);
        this.chunkTags = Objects.requireNonNull(chunkTags);
        this.readings = readings;
    }

    public String getToken() {
        return this.token;
    }

    public List<ChunkTag> getChunkTags() {
        return this.chunkTags;
    }

    @Nullable
    public AnalyzedTokenReadings getReadings() {
        return this.readings;
    }

    public String toString() {
        return this.token + "/" + StringUtils.join(this.chunkTags, (String)",");
    }
}

