/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.bc;

import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.DSAPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import org.bouncycastle.crypto.params.Ed448PrivateKeyParameters;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.pqc.crypto.mldsa.MLDSAPrivateKeyParameters;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.DefaultTlsCredentialedSigner;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.SignatureScheme;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.TlsSigner;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsDSASigner;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsECDSA13Signer;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsECDSASigner;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsEd25519Signer;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsEd448Signer;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsMLDSASigner;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsRSAPSSSigner;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsRSASigner;

public class BcDefaultTlsCredentialedSigner
extends DefaultTlsCredentialedSigner {
    private static TlsSigner makeSigner(BcTlsCrypto bcTlsCrypto, AsymmetricKeyParameter asymmetricKeyParameter, Certificate certificate, SignatureAndHashAlgorithm signatureAndHashAlgorithm) {
        if (asymmetricKeyParameter instanceof RSAKeyParameters) {
            int n;
            RSAKeyParameters rSAKeyParameters = (RSAKeyParameters)asymmetricKeyParameter;
            if (signatureAndHashAlgorithm != null && SignatureScheme.isRSAPSS(n = SignatureScheme.from(signatureAndHashAlgorithm))) {
                return new BcTlsRSAPSSSigner(bcTlsCrypto, rSAKeyParameters, n);
            }
            return new BcTlsRSASigner(bcTlsCrypto, rSAKeyParameters);
        }
        if (asymmetricKeyParameter instanceof DSAPrivateKeyParameters) {
            return new BcTlsDSASigner(bcTlsCrypto, (DSAPrivateKeyParameters)asymmetricKeyParameter);
        }
        if (asymmetricKeyParameter instanceof ECPrivateKeyParameters) {
            int n;
            ECPrivateKeyParameters eCPrivateKeyParameters = (ECPrivateKeyParameters)asymmetricKeyParameter;
            if (signatureAndHashAlgorithm != null && SignatureScheme.isECDSA(n = SignatureScheme.from(signatureAndHashAlgorithm))) {
                return new BcTlsECDSA13Signer(bcTlsCrypto, eCPrivateKeyParameters, n);
            }
            return new BcTlsECDSASigner(bcTlsCrypto, eCPrivateKeyParameters);
        }
        if (asymmetricKeyParameter instanceof Ed25519PrivateKeyParameters) {
            return new BcTlsEd25519Signer(bcTlsCrypto, (Ed25519PrivateKeyParameters)asymmetricKeyParameter);
        }
        if (asymmetricKeyParameter instanceof Ed448PrivateKeyParameters) {
            return new BcTlsEd448Signer(bcTlsCrypto, (Ed448PrivateKeyParameters)asymmetricKeyParameter);
        }
        if (asymmetricKeyParameter instanceof MLDSAPrivateKeyParameters) {
            BcTlsMLDSASigner bcTlsMLDSASigner;
            if (signatureAndHashAlgorithm != null && (bcTlsMLDSASigner = BcTlsMLDSASigner.create(bcTlsCrypto, (MLDSAPrivateKeyParameters)asymmetricKeyParameter, SignatureScheme.from(signatureAndHashAlgorithm))) != null) {
                return bcTlsMLDSASigner;
            }
            throw new IllegalArgumentException("ML-DSA private key of wrong type for signature algorithm");
        }
        throw new IllegalArgumentException("'privateKey' type not supported: " + asymmetricKeyParameter.getClass().getName());
    }

    public BcDefaultTlsCredentialedSigner(TlsCryptoParameters tlsCryptoParameters, BcTlsCrypto bcTlsCrypto, AsymmetricKeyParameter asymmetricKeyParameter, Certificate certificate, SignatureAndHashAlgorithm signatureAndHashAlgorithm) {
        super(tlsCryptoParameters, BcDefaultTlsCredentialedSigner.makeSigner(bcTlsCrypto, asymmetricKeyParameter, certificate, signatureAndHashAlgorithm), certificate, signatureAndHashAlgorithm);
    }
}

