/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.encryptionsdk.kms;

import com.amazonaws.SdkClientException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.encryptionsdk.CryptoAlgorithm;
import com.amazonaws.encryptionsdk.DataKey;
import com.amazonaws.encryptionsdk.EncryptedDataKey;
import com.amazonaws.encryptionsdk.MasterKeyProvider;
import com.amazonaws.encryptionsdk.MasterKeyRequest;
import com.amazonaws.encryptionsdk.exception.AwsCryptoException;
import com.amazonaws.encryptionsdk.exception.NoSuchMasterKeyException;
import com.amazonaws.encryptionsdk.exception.UnsupportedProviderException;
import com.amazonaws.encryptionsdk.internal.AwsKmsCmkArnInfo;
import com.amazonaws.encryptionsdk.kms.AwsKmsMrkAwareMasterKey;
import com.amazonaws.encryptionsdk.kms.DiscoveryFilter;
import com.amazonaws.encryptionsdk.kms.KmsMasterKeyProvider;
import com.amazonaws.handlers.RequestHandler2;
import com.amazonaws.regions.DefaultAwsRegionProviderChain;
import com.amazonaws.services.kms.AWSKMS;
import com.amazonaws.services.kms.AWSKMSClient;
import com.amazonaws.services.kms.AWSKMSClientBuilder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public final class AwsKmsMrkAwareMasterKeyProvider
extends MasterKeyProvider<AwsKmsMrkAwareMasterKey> {
    private static final String PROVIDER_NAME = "aws-kms";
    private final List<String> keyIds_;
    private final List<String> grantTokens_;
    private final boolean isDiscovery_;
    private final DiscoveryFilter discoveryFilter_;
    private final String discoveryMrkRegion_;
    private final KmsMasterKeyProvider.RegionalClientSupplier regionalClientSupplier_;
    private final String defaultRegion_;

    public static Builder builder() {
        return new Builder();
    }

    private AwsKmsMrkAwareMasterKeyProvider(KmsMasterKeyProvider.RegionalClientSupplier supplier, String defaultRegion, List<String> keyIds, List<String> grantTokens, boolean isDiscovery, DiscoveryFilter discoveryFilter, String discoveryMrkRegion) {
        if (!isDiscovery && (keyIds == null || keyIds.isEmpty())) {
            throw new IllegalArgumentException("Strict mode must be configured with a non-empty list of keyIds.");
        }
        if (!isDiscovery && (keyIds.contains(null) || keyIds.contains(""))) {
            throw new IllegalArgumentException("Strict mode cannot be configured with a null key identifier.");
        }
        AwsKmsMrkAwareMasterKeyProvider.assertMrksAreUnique(keyIds);
        if (!isDiscovery && defaultRegion == null && keyIds.stream().map(identifier -> AwsKmsCmkArnInfo.parseInfoFromKeyArn(identifier)).anyMatch(info -> info == null)) {
            throw new AwsCryptoException("Can't use non-ARN key identifiers or aliases when no default region is set");
        }
        if (!isDiscovery && discoveryFilter != null) {
            throw new IllegalArgumentException("Strict mode cannot be configured with a discovery filter.");
        }
        if (isDiscovery && !keyIds.isEmpty()) {
            throw new IllegalArgumentException("Discovery mode can not be configured with keys.");
        }
        if (isDiscovery && discoveryMrkRegion == null) {
            throw new IllegalArgumentException("Discovery MRK region can not be null.");
        }
        this.regionalClientSupplier_ = supplier;
        this.defaultRegion_ = defaultRegion;
        this.keyIds_ = Collections.unmodifiableList(new ArrayList<String>(keyIds));
        this.isDiscovery_ = isDiscovery;
        this.discoveryFilter_ = discoveryFilter;
        this.discoveryMrkRegion_ = discoveryMrkRegion;
        this.grantTokens_ = grantTokens;
    }

    static void assertMrksAreUnique(List<String> keyIdentifiers) {
        List duplicateMultiRegionKeyIdentifiers = keyIdentifiers.stream().collect(Collectors.groupingBy(AwsKmsMrkAwareMasterKeyProvider::getResourceForResourceTypeKey)).entrySet().stream().filter(maybeDuplicate -> ((List)maybeDuplicate.getValue()).size() > 1).filter(maybeMrk -> AwsKmsCmkArnInfo.isMRK((String)maybeMrk.getKey())).flatMap(mrkEntry -> ((List)mrkEntry.getValue()).stream()).collect(Collectors.toList());
        if (duplicateMultiRegionKeyIdentifiers.size() > 1) {
            throw new IllegalArgumentException("Duplicate multi-region keys are not allowed:\n" + String.join((CharSequence)", ", duplicateMultiRegionKeyIdentifiers));
        }
    }

    static String getResourceForResourceTypeKey(String identifier) {
        AwsKmsCmkArnInfo info = AwsKmsCmkArnInfo.parseInfoFromKeyArn(identifier);
        if (info == null) {
            return identifier;
        }
        if (!info.getResourceType().equals("key")) {
            return identifier;
        }
        return info.getResource();
    }

    @Override
    public String getDefaultProviderId() {
        return PROVIDER_NAME;
    }

    @Override
    public AwsKmsMrkAwareMasterKey getMasterKey(String providerId, String requestedKeyArn) throws UnsupportedProviderException, NoSuchMasterKeyException {
        if (!this.canProvide(providerId)) {
            throw new UnsupportedProviderException();
        }
        Optional<String> matchedArn = this.keyIds_.stream().filter(t -> AwsKmsCmkArnInfo.awsKmsArnMatchForDecrypt(t, requestedKeyArn)).findFirst();
        if (!this.isDiscovery_ && !matchedArn.isPresent()) {
            throw new NoSuchMasterKeyException("Key must be in supplied list of keyIds.");
        }
        AwsKmsCmkArnInfo requestedKeyArnInfo = AwsKmsCmkArnInfo.parseInfoFromKeyArn(requestedKeyArn);
        if (this.isDiscovery_ && requestedKeyArnInfo == null) {
            throw new NoSuchMasterKeyException("Cannot use AWS KMS identifiers when in discovery mode.");
        }
        if (this.isDiscovery_ && this.discoveryFilter_ != null && !this.discoveryFilter_.allowsPartitionAndAccount(requestedKeyArnInfo.getPartition(), requestedKeyArnInfo.getAccountId())) {
            throw new NoSuchMasterKeyException("Cannot use key in partition " + requestedKeyArnInfo.getPartition() + " with account id " + requestedKeyArnInfo.getAccountId() + " with configured discovery filter.");
        }
        String regionName_ = AwsKmsMrkAwareMasterKeyProvider.extractRegion(this.defaultRegion_, this.discoveryMrkRegion_, matchedArn, requestedKeyArnInfo, this.isDiscovery_);
        AWSKMS kms = this.regionalClientSupplier_.getClient(regionName_);
        String keyIdentifier = this.isDiscovery_ ? requestedKeyArnInfo.toString(regionName_) : matchedArn.get();
        AwsKmsMrkAwareMasterKey result = AwsKmsMrkAwareMasterKey.getInstance(kms, keyIdentifier, this);
        result.setGrantTokens(this.grantTokens_);
        return result;
    }

    static String extractRegion(String defaultRegion, String discoveryMrkRegion, Optional<String> matchedArn, AwsKmsCmkArnInfo requestedKeyArnInfo, boolean isDiscovery) {
        if (requestedKeyArnInfo == null) {
            return defaultRegion;
        }
        if (!AwsKmsCmkArnInfo.isMRK(requestedKeyArnInfo.getResource()) || !requestedKeyArnInfo.getResourceType().equals("key")) {
            return requestedKeyArnInfo.getRegion();
        }
        if (isDiscovery) {
            return discoveryMrkRegion;
        }
        return AwsKmsCmkArnInfo.parseInfoFromKeyArn(matchedArn.get()).getRegion();
    }

    @Override
    public List<AwsKmsMrkAwareMasterKey> getMasterKeysForEncryption(MasterKeyRequest request) {
        if (this.isDiscovery_) {
            return Collections.emptyList();
        }
        ArrayList<AwsKmsMrkAwareMasterKey> result = new ArrayList<AwsKmsMrkAwareMasterKey>(this.keyIds_.size());
        for (String id : this.keyIds_) {
            result.add((AwsKmsMrkAwareMasterKey)this.getMasterKey(id));
        }
        return result;
    }

    @Override
    public DataKey<AwsKmsMrkAwareMasterKey> decryptDataKey(CryptoAlgorithm algorithm, Collection<? extends EncryptedDataKey> encryptedDataKeys, Map<String, String> encryptionContext) throws AwsCryptoException {
        ArrayList exceptions = new ArrayList();
        return encryptedDataKeys.stream().filter(edk -> {
            if (!this.canProvide(edk.getProviderId())) {
                return false;
            }
            String providerInfo = new String(edk.getProviderInformation(), StandardCharsets.UTF_8);
            AwsKmsCmkArnInfo providerArnInfo = AwsKmsCmkArnInfo.parseInfoFromKeyArn(providerInfo);
            if (providerArnInfo == null || !"key".equals(providerArnInfo.getResourceType())) {
                throw new IllegalStateException("Invalid provider info in message.");
            }
            return true;
        }).map(edk -> {
            try {
                String keyArn = new String(edk.getProviderInformation(), StandardCharsets.UTF_8);
                return this.getMasterKey(edk.getProviderId(), keyArn).decryptDataKey(algorithm, Collections.singletonList(edk), encryptionContext);
            }
            catch (Exception ex) {
                exceptions.add(ex);
                return null;
            }
        }).filter(Objects::nonNull).findFirst().orElseThrow(() -> this.buildCannotDecryptDksException(exceptions));
    }

    public List<String> getGrantTokens() {
        return new ArrayList<String>(this.grantTokens_);
    }

    public AwsKmsMrkAwareMasterKeyProvider withGrantTokens(List<String> grantTokens) {
        grantTokens = Collections.unmodifiableList(new ArrayList<String>(grantTokens));
        return new AwsKmsMrkAwareMasterKeyProvider(this.regionalClientSupplier_, this.defaultRegion_, this.keyIds_, grantTokens, this.isDiscovery_, this.discoveryFilter_, this.discoveryMrkRegion_);
    }

    public AwsKmsMrkAwareMasterKeyProvider withGrantTokens(String ... grantTokens) {
        return this.withGrantTokens(Arrays.asList(grantTokens));
    }

    public static class Builder
    implements Cloneable {
        private String defaultRegion_ = Builder.getSdkDefaultRegion();
        private Optional<KmsMasterKeyProvider.RegionalClientSupplier> regionalClientSupplier_ = Optional.empty();
        private AWSKMSClientBuilder templateBuilder_ = null;
        private DiscoveryFilter discoveryFilter_ = null;
        private String discoveryMrkRegion_ = this.defaultRegion_;

        Builder() {
        }

        public Builder clone() {
            try {
                Builder cloned = (Builder)super.clone();
                if (this.templateBuilder_ != null) {
                    cloned.templateBuilder_ = Builder.cloneClientBuilder(this.templateBuilder_);
                }
                return cloned;
            }
            catch (CloneNotSupportedException e) {
                throw new Error("Impossible: CloneNotSupportedException", e);
            }
        }

        public Builder withDefaultRegion(String defaultRegion) {
            this.defaultRegion_ = defaultRegion;
            return this;
        }

        public Builder withDiscoveryMrkRegion(String discoveryMrkRegion) {
            this.discoveryMrkRegion_ = discoveryMrkRegion;
            return this;
        }

        public Builder withCustomClientFactory(KmsMasterKeyProvider.RegionalClientSupplier regionalClientSupplier) {
            if (this.templateBuilder_ != null) {
                throw this.clientSupplierComboException();
            }
            this.regionalClientSupplier_ = Optional.of(regionalClientSupplier);
            return this;
        }

        private RuntimeException clientSupplierComboException() {
            return new IllegalStateException("withCustomClientFactory cannot be used in conjunction with withCredentials or withClientBuilder");
        }

        public Builder withCredentials(AWSCredentialsProvider credentialsProvider) {
            if (this.regionalClientSupplier_.isPresent()) {
                throw this.clientSupplierComboException();
            }
            if (this.templateBuilder_ == null) {
                this.templateBuilder_ = AWSKMSClientBuilder.standard();
            }
            this.templateBuilder_.setCredentials(credentialsProvider);
            return this;
        }

        public Builder withCredentials(AWSCredentials credentials) {
            return this.withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider(credentials));
        }

        public Builder withClientBuilder(AWSKMSClientBuilder builder) {
            AWSKMSClientBuilder newBuilder;
            if (this.regionalClientSupplier_.isPresent()) {
                throw this.clientSupplierComboException();
            }
            this.templateBuilder_ = newBuilder = Builder.cloneClientBuilder(builder);
            return this;
        }

        public AwsKmsMrkAwareMasterKeyProvider buildDiscovery() {
            boolean isDiscovery = true;
            return new AwsKmsMrkAwareMasterKeyProvider(this.regionalClientSupplier_.orElse(Builder.clientFactory(new ConcurrentHashMap<String, AWSKMS>(), this.templateBuilder_)), this.defaultRegion_, Collections.emptyList(), Collections.emptyList(), true, this.discoveryFilter_, this.discoveryMrkRegion_ == null ? this.defaultRegion_ : this.discoveryMrkRegion_);
        }

        public AwsKmsMrkAwareMasterKeyProvider buildDiscovery(DiscoveryFilter filter) {
            this.discoveryFilter_ = filter;
            return this.buildDiscovery();
        }

        public AwsKmsMrkAwareMasterKeyProvider buildStrict(List<String> keyIds) {
            boolean isDiscovery = false;
            return new AwsKmsMrkAwareMasterKeyProvider(this.regionalClientSupplier_.orElse(Builder.clientFactory(new ConcurrentHashMap<String, AWSKMS>(), this.templateBuilder_)), this.defaultRegion_, new ArrayList<String>(keyIds), Collections.emptyList(), false, null, null);
        }

        public AwsKmsMrkAwareMasterKeyProvider buildStrict(String ... keyIds) {
            return this.buildStrict(Arrays.asList(keyIds));
        }

        static KmsMasterKeyProvider.RegionalClientSupplier clientFactory(ConcurrentHashMap<String, AWSKMS> clientCache, AWSKMSClientBuilder templateBuilder) {
            AWSKMSClientBuilder builder = templateBuilder != null ? Builder.cloneClientBuilder(templateBuilder) : AWSKMSClientBuilder.standard();
            return region -> {
                if (clientCache.containsKey(region)) {
                    return (AWSKMS)clientCache.get(region);
                }
                KmsMasterKeyProvider.SuccessfulRequestCacher cacher = new KmsMasterKeyProvider.SuccessfulRequestCacher(clientCache, region);
                ArrayList<KmsMasterKeyProvider.SuccessfulRequestCacher> handlers = new ArrayList<KmsMasterKeyProvider.SuccessfulRequestCacher>();
                if (builder.getRequestHandlers() != null) {
                    handlers.addAll(builder.getRequestHandlers());
                }
                handlers.add(cacher);
                AWSKMS kms = (AWSKMS)((AWSKMSClientBuilder)((AWSKMSClientBuilder)Builder.cloneClientBuilder(builder).withRegion(region)).withRequestHandlers(handlers.toArray(new RequestHandler2[handlers.size()]))).build();
                return cacher.setClient(kms);
            };
        }

        static AWSKMSClientBuilder cloneClientBuilder(AWSKMSClientBuilder builder) {
            if (builder.getEndpoint() != null) {
                throw new IllegalArgumentException("Setting endpoint configuration is not compatible with passing a builder to the KmsMasterKeyProvider. Use withCustomClientFactory instead.");
            }
            AWSKMSClientBuilder newBuilder = AWSKMSClient.builder();
            newBuilder.setClientConfiguration(builder.getClientConfiguration());
            newBuilder.setCredentials(builder.getCredentials());
            newBuilder.setEndpointConfiguration(builder.getEndpoint());
            newBuilder.setMetricsCollector(builder.getMetricsCollector());
            if (builder.getRequestHandlers() != null) {
                newBuilder.setRequestHandlers(builder.getRequestHandlers().toArray(new RequestHandler2[0]));
            }
            return newBuilder;
        }

        private static String getSdkDefaultRegion() {
            try {
                return new DefaultAwsRegionProviderChain().getRegion();
            }
            catch (SdkClientException ex) {
                return null;
            }
        }
    }
}

