/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.ByteBuffer;
import java.util.zip.Checksum;
import org.apache.kafka.common.utils.Checksums;

public final class Crc32C {
    private static final MethodHandle CRC32C_CONSTRUCTOR;

    private Crc32C() {
    }

    public static long compute(byte[] bytes, int offset, int size) {
        Checksum crc = Crc32C.create();
        crc.update(bytes, offset, size);
        return crc.getValue();
    }

    public static long compute(ByteBuffer buffer, int offset, int size) {
        Checksum crc = Crc32C.create();
        Checksums.update(crc, buffer, offset, size);
        return crc.getValue();
    }

    public static Checksum create() {
        try {
            return CRC32C_CONSTRUCTOR.invoke();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    static {
        try {
            Class<?> cls = Class.forName("java.util.zip.CRC32C");
            CRC32C_CONSTRUCTOR = MethodHandles.publicLookup().findConstructor(cls, MethodType.methodType(Void.TYPE));
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }
}

