/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.security;

import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch.nodes.NodesResponseBase;
import org.opensearch.client.opensearch.security.CertificatesPerNode;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class GetAllCertificatesResponse
extends NodesResponseBase
implements ToCopyableBuilder<Builder, GetAllCertificatesResponse> {
    @Nullable
    private final String clusterName;
    @Nonnull
    private final Map<String, CertificatesPerNode> nodes;
    public static final JsonpDeserializer<GetAllCertificatesResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetAllCertificatesResponse::setupGetAllCertificatesResponseDeserializer);

    private GetAllCertificatesResponse(Builder builder) {
        super(builder);
        this.clusterName = builder.clusterName;
        this.nodes = ApiTypeHelper.unmodifiable(builder.nodes);
    }

    public static GetAllCertificatesResponse of(Function<Builder, ObjectBuilder<GetAllCertificatesResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String clusterName() {
        return this.clusterName;
    }

    @Nonnull
    public final Map<String, CertificatesPerNode> nodes() {
        return this.nodes;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.clusterName != null) {
            generator.writeKey("cluster_name");
            generator.write(this.clusterName);
        }
        if (ApiTypeHelper.isDefined(this.nodes)) {
            generator.writeKey("nodes");
            generator.writeStartObject();
            for (Map.Entry<String, CertificatesPerNode> item0 : this.nodes.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupGetAllCertificatesResponseDeserializer(ObjectDeserializer<Builder> op) {
        GetAllCertificatesResponse.setupNodesResponseBaseDeserializer(op);
        op.add(Builder::clusterName, JsonpDeserializer.stringDeserializer(), "cluster_name");
        op.add(Builder::nodes, JsonpDeserializer.stringMapDeserializer(CertificatesPerNode._DESERIALIZER), "nodes");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.clusterName);
        result = 31 * result + Objects.hashCode(this.nodes);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetAllCertificatesResponse other = (GetAllCertificatesResponse)o;
        return Objects.equals(this.clusterName, other.clusterName) && Objects.equals(this.nodes, other.nodes);
    }

    public static class Builder
    extends NodesResponseBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, GetAllCertificatesResponse> {
        @Nullable
        private String clusterName;
        @Nullable
        private Map<String, CertificatesPerNode> nodes;

        public Builder() {
        }

        private Builder(GetAllCertificatesResponse o) {
            super(o);
            this.clusterName = o.clusterName;
            this.nodes = Builder._mapCopy(o.nodes);
        }

        private Builder(Builder o) {
            super(o);
            this.clusterName = o.clusterName;
            this.nodes = Builder._mapCopy(o.nodes);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder clusterName(@Nullable String value) {
            this.clusterName = value;
            return this;
        }

        @Nonnull
        public final Builder nodes(Map<String, CertificatesPerNode> map) {
            this.nodes = Builder._mapPutAll(this.nodes, map);
            return this;
        }

        @Nonnull
        public final Builder nodes(String key, CertificatesPerNode value) {
            this.nodes = Builder._mapPut(this.nodes, key, value);
            return this;
        }

        @Nonnull
        public final Builder nodes(String key, Function<CertificatesPerNode.Builder, ObjectBuilder<CertificatesPerNode>> fn) {
            return this.nodes(key, fn.apply(new CertificatesPerNode.Builder()).build());
        }

        @Override
        @Nonnull
        public GetAllCertificatesResponse build() {
            this._checkSingleUse();
            return new GetAllCertificatesResponse(this);
        }
    }
}

