/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.spatial4j.context.jts;

import java.util.Map;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.impl.CoordinateArraySequenceFactory;
import org.locationtech.spatial4j.context.SpatialContextFactory;
import org.locationtech.spatial4j.context.jts.DatelineRule;
import org.locationtech.spatial4j.context.jts.JtsSpatialContext;
import org.locationtech.spatial4j.context.jts.ValidationRule;
import org.locationtech.spatial4j.io.GeoJSONReader;
import org.locationtech.spatial4j.io.LegacyShapeReader;
import org.locationtech.spatial4j.io.LegacyShapeWriter;
import org.locationtech.spatial4j.io.PolyshapeReader;
import org.locationtech.spatial4j.io.WKTReader;
import org.locationtech.spatial4j.io.jts.JtsBinaryCodec;
import org.locationtech.spatial4j.io.jts.JtsGeoJSONWriter;
import org.locationtech.spatial4j.io.jts.JtsPolyshapeWriter;
import org.locationtech.spatial4j.io.jts.JtsWKTWriter;
import org.locationtech.spatial4j.shape.jts.JtsShapeFactory;

public class JtsSpatialContextFactory
extends SpatialContextFactory {
    protected static final PrecisionModel defaultPrecisionModel = new PrecisionModel();
    public PrecisionModel precisionModel = defaultPrecisionModel;
    public int srid = 0;
    public CoordinateSequenceFactory coordinateSequenceFactory = CoordinateArraySequenceFactory.instance();
    public DatelineRule datelineRule = DatelineRule.width180;
    public ValidationRule validationRule = ValidationRule.error;
    public boolean autoIndex = false;
    public boolean allowMultiOverlap = false;
    public boolean useJtsPoint = true;
    public boolean useJtsLineString = true;
    public boolean useJtsMulti = true;

    public JtsSpatialContextFactory() {
        this.shapeFactoryClass = JtsShapeFactory.class;
        this.binaryCodecClass = JtsBinaryCodec.class;
    }

    @Override
    protected void checkDefaultFormats() {
        if (this.readers.isEmpty()) {
            this.addReaderIfNoggitExists(GeoJSONReader.class);
            this.readers.add(WKTReader.class);
            this.readers.add(PolyshapeReader.class);
            this.readers.add(LegacyShapeReader.class);
        }
        if (this.writers.isEmpty()) {
            this.writers.add(JtsGeoJSONWriter.class);
            this.writers.add(JtsWKTWriter.class);
            this.writers.add(JtsPolyshapeWriter.class);
            this.writers.add(LegacyShapeWriter.class);
        }
    }

    @Override
    protected void init(Map<String, String> args, ClassLoader classLoader) {
        super.init(args, classLoader);
        this.initField("datelineRule");
        this.initField("validationRule");
        this.initField("autoIndex");
        this.initField("allowMultiOverlap");
        this.initField("useJtsPoint");
        this.initField("useJtsLineString");
        this.initField("useJtsMulti");
        String scaleStr = args.get("precisionScale");
        String modelStr = args.get("precisionModel");
        if (scaleStr != null) {
            if (modelStr != null && !modelStr.equals("fixed")) {
                throw new RuntimeException("Since precisionScale was specified; precisionModel must be 'fixed' but got: " + modelStr);
            }
            this.precisionModel = new PrecisionModel(Double.parseDouble(scaleStr));
        } else if (modelStr != null) {
            if (modelStr.equals("floating")) {
                this.precisionModel = new PrecisionModel(PrecisionModel.FLOATING);
            } else if (modelStr.equals("floating_single")) {
                this.precisionModel = new PrecisionModel(PrecisionModel.FLOATING_SINGLE);
            } else {
                if (modelStr.equals("fixed")) {
                    throw new RuntimeException("For fixed model, must specifiy 'precisionScale'");
                }
                throw new RuntimeException("Unknown precisionModel: " + modelStr);
            }
        }
    }

    public GeometryFactory getGeometryFactory() {
        if (this.precisionModel == null || this.coordinateSequenceFactory == null) {
            throw new IllegalStateException("precision model or coord seq factory can't be null");
        }
        return new GeometryFactory(this.precisionModel, this.srid, this.coordinateSequenceFactory);
    }

    @Override
    public JtsSpatialContext newSpatialContext() {
        return new JtsSpatialContext(this);
    }
}

