/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.compiled;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.components.Service;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.ExtensionPointName;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.BinaryFileTypeDecompilers;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.FileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.compiled.ClsStubBuilder;

@Service
public final class ClassFileDecompilers {
    public final ExtensionPointName<Decompiler> EP_NAME = new ExtensionPointName("org.jetbrains.kotlin.com.intellij.psi.classFileDecompiler");

    public static ClassFileDecompilers getInstance() {
        return ApplicationManager.getApplication().getService(ClassFileDecompilers.class);
    }

    private ClassFileDecompilers() {
        this.EP_NAME.addChangeListener(() -> BinaryFileTypeDecompilers.getInstance().notifyDecompilerSetChange(), null);
    }

    public <D extends Decompiler> D find(@NotNull VirtualFile file, @NotNull Class<D> decompilerClass) {
        if (file == null) {
            ClassFileDecompilers.$$$reportNull$$$0(0);
        }
        if (decompilerClass == null) {
            ClassFileDecompilers.$$$reportNull$$$0(1);
        }
        return (D)this.EP_NAME.findFirstSafe(d2 -> decompilerClass.isInstance(d2) && d2.accepts(file));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "decompilerClass";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/kotlin/com/intellij/psi/compiled/ClassFileDecompilers";
        objectArray[2] = "find";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface Decompiler {
        public boolean accepts(@NotNull VirtualFile var1);
    }

    public static abstract class Full
    implements Decompiler {
        @NotNull
        public abstract ClsStubBuilder getStubBuilder();

        @NotNull
        public abstract FileViewProvider createFileViewProvider(@NotNull VirtualFile var1, @NotNull PsiManager var2, boolean var3);
    }

    public static abstract class Light
    implements Decompiler {
        @NotNull
        public abstract CharSequence getText(@NotNull VirtualFile var1) throws CannotDecompileException;

        public static class CannotDecompileException
        extends RuntimeException {
            public CannotDecompileException(String message2, Throwable cause) {
                super(message2, cause);
            }
        }
    }
}

