/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.LoweringContext;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBodyBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.IrElementBuilderKt;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrValueParameterBuilder;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrParameterKind;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRichFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrStatementOriginImpl;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrRichFunctionReferenceImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrRichPropertyReferenceImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrDeclarationWithAccessorsSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.AbstractIrTypeSubstitutor;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeSubstitutor;
import org.jetbrains.kotlin.ir.types.IrTypeSubstitutorKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.visitors.IrTransformer;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@PhaseDescription(name="UpgradeCallableReferences")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u0000 \u00182\u00020\u0001:\u0003\u0018\u0019\u001aB7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/UpgradeCallableReferences;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/common/LoweringContext;", "upgradeFunctionReferencesAndLambdas", "", "upgradePropertyReferences", "upgradeLocalDelegatedPropertyReferences", "upgradeSamConversions", "<init>", "(Lorg/jetbrains/kotlin/backend/common/LoweringContext;ZZZZ)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/LoweringContext;", "getUpgradeFunctionReferencesAndLambdas", "()Z", "getUpgradePropertyReferences", "getUpgradeLocalDelegatedPropertyReferences", "getUpgradeSamConversions", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "irFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "Companion", "AdaptedBlock", "UpgradeTransformer", "ir.backend.common"})
public class UpgradeCallableReferences
implements FileLoweringPass {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LoweringContext context;
    private final boolean upgradeFunctionReferencesAndLambdas;
    private final boolean upgradePropertyReferences;
    private final boolean upgradeLocalDelegatedPropertyReferences;
    private final boolean upgradeSamConversions;

    public UpgradeCallableReferences(@NotNull LoweringContext context2, boolean upgradeFunctionReferencesAndLambdas, boolean upgradePropertyReferences, boolean upgradeLocalDelegatedPropertyReferences, boolean upgradeSamConversions) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
        this.upgradeFunctionReferencesAndLambdas = upgradeFunctionReferencesAndLambdas;
        this.upgradePropertyReferences = upgradePropertyReferences;
        this.upgradeLocalDelegatedPropertyReferences = upgradeLocalDelegatedPropertyReferences;
        this.upgradeSamConversions = upgradeSamConversions;
    }

    public /* synthetic */ UpgradeCallableReferences(LoweringContext loweringContext, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            bl = true;
        }
        if ((n2 & 4) != 0) {
            bl2 = true;
        }
        if ((n2 & 8) != 0) {
            bl3 = true;
        }
        if ((n2 & 0x10) != 0) {
            bl4 = true;
        }
        this(loweringContext, bl, bl2, bl3, bl4);
    }

    @NotNull
    public final LoweringContext getContext() {
        return this.context;
    }

    public final boolean getUpgradeFunctionReferencesAndLambdas() {
        return this.upgradeFunctionReferencesAndLambdas;
    }

    public final boolean getUpgradePropertyReferences() {
        return this.upgradePropertyReferences;
    }

    public final boolean getUpgradeLocalDelegatedPropertyReferences() {
        return this.upgradeLocalDelegatedPropertyReferences;
    }

    public final boolean getUpgradeSamConversions() {
        return this.upgradeSamConversions;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        irFile.transform((IrTransformer)new UpgradeTransformer(), irFile);
    }

    public final void lower(@NotNull IrFunction irFunction) {
        Intrinsics.checkNotNullParameter((Object)irFunction, (String)"irFunction");
        irFunction.transform(new UpgradeTransformer(), irFunction);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0014\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00c6\u0003J3\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\b\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/UpgradeCallableReferences$AdaptedBlock;", "", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "reference", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "samConversionType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "referenceType", "<init>", "(Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;Lorg/jetbrains/kotlin/ir/types/IrType;Lorg/jetbrains/kotlin/ir/types/IrType;)V", "getFunction", "()Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "getReference", "()Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "getSamConversionType", "()Lorg/jetbrains/kotlin/ir/types/IrType;", "getReferenceType", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "ir.backend.common"})
    private static final class AdaptedBlock {
        @NotNull
        private final IrSimpleFunction function;
        @NotNull
        private final IrFunctionReference reference;
        @Nullable
        private final IrType samConversionType;
        @NotNull
        private final IrType referenceType;

        public AdaptedBlock(@NotNull IrSimpleFunction function2, @NotNull IrFunctionReference reference2, @Nullable IrType samConversionType, @NotNull IrType referenceType) {
            Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
            Intrinsics.checkNotNullParameter((Object)reference2, (String)"reference");
            Intrinsics.checkNotNullParameter((Object)referenceType, (String)"referenceType");
            this.function = function2;
            this.reference = reference2;
            this.samConversionType = samConversionType;
            this.referenceType = referenceType;
        }

        @NotNull
        public final IrSimpleFunction getFunction() {
            return this.function;
        }

        @NotNull
        public final IrFunctionReference getReference() {
            return this.reference;
        }

        @Nullable
        public final IrType getSamConversionType() {
            return this.samConversionType;
        }

        @NotNull
        public final IrType getReferenceType() {
            return this.referenceType;
        }

        @NotNull
        public final IrSimpleFunction component1() {
            return this.function;
        }

        @NotNull
        public final IrFunctionReference component2() {
            return this.reference;
        }

        @Nullable
        public final IrType component3() {
            return this.samConversionType;
        }

        @NotNull
        public final IrType component4() {
            return this.referenceType;
        }

        @NotNull
        public final AdaptedBlock copy(@NotNull IrSimpleFunction function2, @NotNull IrFunctionReference reference2, @Nullable IrType samConversionType, @NotNull IrType referenceType) {
            Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
            Intrinsics.checkNotNullParameter((Object)reference2, (String)"reference");
            Intrinsics.checkNotNullParameter((Object)referenceType, (String)"referenceType");
            return new AdaptedBlock(function2, reference2, samConversionType, referenceType);
        }

        public static /* synthetic */ AdaptedBlock copy$default(AdaptedBlock adaptedBlock, IrSimpleFunction irSimpleFunction, IrFunctionReference irFunctionReference, IrType irType, IrType irType2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                irSimpleFunction = adaptedBlock.function;
            }
            if ((n2 & 2) != 0) {
                irFunctionReference = adaptedBlock.reference;
            }
            if ((n2 & 4) != 0) {
                irType = adaptedBlock.samConversionType;
            }
            if ((n2 & 8) != 0) {
                irType2 = adaptedBlock.referenceType;
            }
            return adaptedBlock.copy(irSimpleFunction, irFunctionReference, irType, irType2);
        }

        @NotNull
        public String toString() {
            return "AdaptedBlock(function=" + this.function + ", reference=" + this.reference + ", samConversionType=" + this.samConversionType + ", referenceType=" + this.referenceType + ')';
        }

        public int hashCode() {
            int result2 = this.function.hashCode();
            result2 = result2 * 31 + this.reference.hashCode();
            result2 = result2 * 31 + (this.samConversionType == null ? 0 : this.samConversionType.hashCode());
            result2 = result2 * 31 + this.referenceType.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AdaptedBlock)) {
                return false;
            }
            AdaptedBlock adaptedBlock = (AdaptedBlock)other;
            if (!Intrinsics.areEqual((Object)this.function, (Object)adaptedBlock.function)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.reference, (Object)adaptedBlock.reference)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.samConversionType, (Object)adaptedBlock.samConversionType)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.referenceType, (Object)adaptedBlock.referenceType);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/UpgradeCallableReferences$Companion;", "", "<init>", "()V", "selectSAMOverriddenFunction", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "ir.backend.common"})
    @SourceDebugExtension(value={"SMAP\nUpgradeCallableReferences.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UpgradeCallableReferences.kt\norg/jetbrains/kotlin/backend/common/lower/UpgradeCallableReferences$Companion\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,436:1\n385#2,11:437\n385#2,11:448\n*S KotlinDebug\n*F\n+ 1 UpgradeCallableReferences.kt\norg/jetbrains/kotlin/backend/common/lower/UpgradeCallableReferences$Companion\n*L\n52#1:437,11\n54#1:448,11\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IrSimpleFunctionSymbol selectSAMOverriddenFunction(@NotNull IrType type) {
            IrSimpleFunctionSymbol irSimpleFunctionSymbol;
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            if (IrTypeUtilsKt.isFunctionOrKFunction(type) || IrTypeUtilsKt.isSuspendFunctionOrKFunction(type)) {
                Object v0;
                block7: {
                    Sequence<IrSimpleFunctionSymbol> $this$singleOrNull$iv = IrUtilsKt.getFunctions(IrTypesKt.getClassOrFail(type));
                    boolean $i$f$singleOrNull = false;
                    Object single$iv = null;
                    boolean found$iv = false;
                    for (Object element$iv : $this$singleOrNull$iv) {
                        IrSimpleFunctionSymbol it = (IrSimpleFunctionSymbol)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)((IrSimpleFunction)it.getOwner()).getName(), (Object)OperatorNameConventions.INVOKE)) continue;
                        if (found$iv) {
                            v0 = null;
                            break block7;
                        }
                        single$iv = element$iv;
                        found$iv = true;
                    }
                    v0 = !found$iv ? null : single$iv;
                }
                irSimpleFunctionSymbol = v0;
            } else {
                Object v2;
                block8: {
                    Sequence<IrSimpleFunctionSymbol> $this$singleOrNull$iv = IrUtilsKt.getFunctions(IrTypesKt.getClassOrFail(type));
                    boolean $i$f$singleOrNull = false;
                    Object single$iv = null;
                    boolean found$iv = false;
                    for (Object element$iv : $this$singleOrNull$iv) {
                        IrSimpleFunctionSymbol it = (IrSimpleFunctionSymbol)element$iv;
                        boolean bl = false;
                        if (!(((IrSimpleFunction)it.getOwner()).getModality() == Modality.ABSTRACT)) continue;
                        if (found$iv) {
                            v2 = null;
                            break block8;
                        }
                        single$iv = element$iv;
                        found$iv = true;
                    }
                    v2 = !found$iv ? null : single$iv;
                }
                irSimpleFunctionSymbol = v2;
            }
            if (irSimpleFunctionSymbol == null) {
                throw new IllegalStateException((RenderIrElementKt.render$default(type, null, 1, null) + " should have a single abstract method to be a type of function reference").toString());
            }
            return irSimpleFunctionSymbol;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00c2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u0006*\u0004\u0018\u00010\u0007H\u0002J\f\u0010\b\u001a\u00020\u0006*\u00020\tH\u0002J\f\u0010\n\u001a\u00020\u000b*\u00020\tH\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0018\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\f\u0010\u0019\u001a\u00020\u001a*\u00020\u001bH\u0002J\u0018\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0002J\u000e\u0010#\u001a\u0004\u0018\u00010$*\u00020%H\u0002J\u0018\u0010&\u001a\u00020'2\u0006\u0010\u000e\u001a\u00020%2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0018\u0010(\u001a\u00020'2\u0006\u0010\u000e\u001a\u00020)2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0018\u0010*\u001a\u00020'2\u0006\u0010\u000e\u001a\u00020+2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0018\u0010,\u001a\u00020'2\u0006\u0010\u000e\u001a\u00020-2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0018\u0010.\u001a\u00020'2\u0006\u0010\u000e\u001a\u00020/2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016JJ\u00100\u001a\u00020\u001e*\u0006\u0012\u0002\b\u0003012\u0018\u00102\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u00020'04032\u0006\u00106\u001a\u00020\u00022\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020\u00062\u0006\u0010:\u001a\u00020\u0006H\u0002Ju\u0010;\u001a\u00020\u001e*\u0006\u0012\u0002\b\u0003012\u0018\u00102\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u00020'04032\u0006\u00106\u001a\u00020\u00022\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020\u00062\u0006\u0010:\u001a\u00020\u00062)\u0010<\u001a%\u0012\u0004\u0012\u00020>\u0012\n\u0012\b\u0012\u0004\u0012\u00020503\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u000b0=\u00a2\u0006\u0002\b?H\u0002J>\u0010@\u001a\u00020\u001e*\u00020-2\u0018\u00102\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u00020'04032\u0006\u00106\u001a\u00020\u00022\u0006\u0010A\u001a\u00020B2\u0006\u0010:\u001a\u00020\u0006H\u0002JD\u0010C\u001a\u00020\u001e*\u0006\u0012\u0002\b\u0003012\u0018\u00102\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u00020'04032\u0006\u00106\u001a\u00020\u00022\u0006\u0010D\u001a\u00020\t2\b\b\u0002\u0010:\u001a\u00020\u0006H\u0002R\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/UpgradeCallableReferences$UpgradeTransformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrTransformer;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/lower/UpgradeCallableReferences;)V", "isRestrictedSuspension", "", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "isRestrictedSuspensionFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "flattenParameters", "", "visitFunctionExpression", "Lorg/jetbrains/kotlin/ir/IrElement;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionExpression;", "data", "visitElement", "element", "visitDeclaration", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationBase;", "visitFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "arrayDepth", "", "Lorg/jetbrains/kotlin/ir/types/IrType;", "hasVarargConversion", "wrapper", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "target", "blockReferenceOrigins", "", "Lorg/jetbrains/kotlin/ir/expressions/IrStatementOriginImpl;", "parseAdaptedBlock", "Lorg/jetbrains/kotlin/backend/common/lower/UpgradeCallableReferences$AdaptedBlock;", "Lorg/jetbrains/kotlin/ir/expressions/IrBlock;", "visitBlock", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "visitTypeOperator", "Lorg/jetbrains/kotlin/ir/expressions/IrTypeOperatorCall;", "visitFunctionReference", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "visitPropertyReference", "Lorg/jetbrains/kotlin/ir/expressions/IrPropertyReference;", "visitLocalDelegatedPropertyReference", "Lorg/jetbrains/kotlin/ir/expressions/IrLocalDelegatedPropertyReference;", "buildUnsupportedForLocalFunction", "Lorg/jetbrains/kotlin/ir/expressions/IrCallableReference;", "captured", "", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "parent", "name", "Lorg/jetbrains/kotlin/name/Name;", "isSuspend", "isPropertySetter", "buildWrapperFunction", "body", "Lkotlin/Function3;", "Lorg/jetbrains/kotlin/ir/builders/IrBlockBodyBuilder;", "Lkotlin/ExtensionFunctionType;", "wrapField", "field", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "wrapFunction", "referencedFunction", "ir.backend.common"})
    @SourceDebugExtension(value={"SMAP\nUpgradeCallableReferences.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UpgradeCallableReferences.kt\norg/jetbrains/kotlin/backend/common/lower/UpgradeCallableReferences$UpgradeTransformer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 5 declarationBuilders.kt\norg/jetbrains/kotlin/ir/builders/declarations/DeclarationBuildersKt\n+ 6 ExpressionHelpers.kt\norg/jetbrains/kotlin/ir/builders/ExpressionHelpersKt\n+ 7 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBlockBodyBuilder\n*L\n1#1,436:1\n1761#2,3:437\n1761#2,3:440\n967#2,7:444\n1761#2,3:451\n3301#2,10:454\n1563#2:464\n1634#2,3:465\n1563#2:470\n1634#2,3:471\n1563#2:474\n1634#2,3:475\n1563#2:508\n1634#2,3:509\n1193#2,2:512\n1267#2,4:514\n1563#2:518\n1634#2,3:519\n3301#2,10:522\n1056#2:532\n1634#2,3:533\n1#3:443\n233#4:468\n233#4:469\n269#5,4:478\n369#5,7:482\n369#5,7:489\n418#6,10:496\n76#7,2:506\n*S KotlinDebug\n*F\n+ 1 UpgradeCallableReferences.kt\norg/jetbrains/kotlin/backend/common/lower/UpgradeCallableReferences$UpgradeTransformer\n*L\n71#1:437,3\n75#1:440,3\n131#1:444,7\n132#1:451,3\n170#1:454,10\n231#1:464\n231#1:465,3\n266#1:470\n266#1:471,3\n310#1:474\n310#1:475,3\n389#1:508\n389#1:509,3\n390#1:512,2\n390#1:514,4\n398#1:518\n398#1:519,3\n399#1:522,10\n404#1:532\n405#1:533,3\n245#1:468\n253#1:469\n314#1:478,4\n324#1:482,7\n331#1:489,7\n337#1:496,10\n337#1:506,2\n*E\n"})
    private final class UpgradeTransformer
    extends IrTransformer<IrDeclarationParent> {
        @NotNull
        private final Set<IrStatementOriginImpl> blockReferenceOrigins;

        public UpgradeTransformer() {
            Object[] objectArray = new IrStatementOriginImpl[]{IrStatementOrigin.Companion.getADAPTED_FUNCTION_REFERENCE(), IrStatementOrigin.Companion.getSUSPEND_CONVERSION(), IrStatementOrigin.Companion.getLAMBDA(), IrStatementOrigin.Companion.getFUN_INTERFACE_CONSTRUCTOR_REFERENCE(), IrStatementOrigin.Companion.getANONYMOUS_FUNCTION()};
            this.blockReferenceOrigins = SetsKt.setOf((Object[])objectArray);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isRestrictedSuspension(IrClass $this$isRestrictedSuspension) {
            if ($this$isRestrictedSuspension == null) {
                return false;
            }
            if (IrUtilsKt.hasAnnotation((IrAnnotationContainer)$this$isRestrictedSuspension, StandardClassIds.Annotations.INSTANCE.getRestrictsSuspension())) return true;
            Iterable $this$any$iv = IrTypeUtilsKt.getAllSuperclasses($this$isRestrictedSuspension);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator2 = $this$any$iv.iterator();
            do {
                if (!iterator2.hasNext()) return false;
                Object element$iv = iterator2.next();
                IrClass it = (IrClass)element$iv;
                boolean bl = false;
            } while (!IrUtilsKt.hasAnnotation((IrAnnotationContainer)$this$isRestrictedSuspension, StandardClassIds.Annotations.INSTANCE.getRestrictsSuspension()));
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isRestrictedSuspensionFunction(IrFunction $this$isRestrictedSuspensionFunction) {
            Iterable $this$any$iv = $this$isRestrictedSuspensionFunction.getParameters();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator2 = $this$any$iv.iterator();
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            IrValueParameter it = (IrValueParameter)element$iv;
            boolean bl = false;
            if (it.getKind() != IrParameterKind.ExtensionReceiver) return false;
            IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(it.getType());
            if (!this.isRestrictedSuspension(irClassSymbol != null ? (IrClass)irClassSymbol.getOwner() : null)) return false;
            return true;
        }

        private final void flattenParameters(IrFunction $this$flattenParameters) {
            for (IrValueParameter parameter : $this$flattenParameters.getParameters()) {
                if (!(parameter.getKind() != IrParameterKind.DispatchReceiver)) {
                    boolean bl = false;
                    String string = "No dispatch receiver allowed in wrappers";
                    throw new IllegalArgumentException(string.toString());
                }
                parameter.setKind(IrParameterKind.Regular);
            }
        }

        @Override
        @NotNull
        public IrElement visitFunctionExpression(@NotNull IrFunctionExpression expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            expression2.transformChildren(this, data);
            if (!UpgradeCallableReferences.this.getUpgradeFunctionReferencesAndLambdas()) {
                return expression2;
            }
            boolean isRestrictedSuspension = this.isRestrictedSuspensionFunction(expression2.getFunction());
            this.flattenParameters(expression2.getFunction());
            return BuildersKt.IrRichFunctionReferenceImpl$default(expression2.getStartOffset(), expression2.getEndOffset(), expression2.getType(), null, Companion.selectSAMOverriddenFunction(expression2.getType()), expression2.getFunction(), expression2.getOrigin(), false, false, false, isRestrictedSuspension, 896, null);
        }

        @Override
        @NotNull
        public IrElement visitElement(@NotNull IrElement element, @NotNull IrDeclarationParent data) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            IrTransformer irTransformer = this;
            IrDeclarationParent irDeclarationParent = element instanceof IrDeclarationParent ? (IrDeclarationParent)element : null;
            if (irDeclarationParent == null) {
                irDeclarationParent = data;
            }
            element.transformChildren(irTransformer, irDeclarationParent);
            return element;
        }

        @Override
        @NotNull
        public IrStatement visitDeclaration(@NotNull IrDeclarationBase declaration, @NotNull IrDeclarationParent data) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return (IrStatement)UpgradeCallableReferences.this.getContext().getIrFactory().getStageController().restrictTo(declaration, () -> UpgradeTransformer.visitDeclaration$lambda$0(this, declaration, data));
        }

        @Override
        @NotNull
        public IrFile visitFile(@NotNull IrFile declaration, @NotNull IrDeclarationParent data) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            IrElement irElement = this.visitElement((IrElement)declaration, data);
            Intrinsics.checkNotNull((Object)irElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrFile");
            return (IrFile)irElement;
        }

        private final int arrayDepth(IrType $this$arrayDepth) {
            int n2;
            if (!($this$arrayDepth instanceof IrSimpleType)) {
                return 0;
            }
            IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull($this$arrayDepth);
            if (Intrinsics.areEqual((Object)irClassSymbol, (Object)UpgradeCallableReferences.this.getContext().getSymbols().getArray())) {
                IrType irType = IrTypesKt.getTypeOrNull(((IrSimpleType)$this$arrayDepth).getArguments().get(0));
                n2 = 1 + (irType != null ? this.arrayDepth(irType) : 0);
            } else {
                n2 = CollectionsKt.contains((Iterable)UpgradeCallableReferences.this.getContext().getSymbols().getArrays(), (Object)irClassSymbol) ? 1 : 0;
            }
            return n2;
        }

        private final boolean hasVarargConversion(IrSimpleFunction wrapper, IrSimpleFunction target) {
            boolean bl;
            block4: {
                Iterable $this$takeWhile$iv = CollectionsKt.zip((Iterable)target.getParameters(), (Iterable)wrapper.getParameters());
                boolean $i$f$takeWhile = false;
                ArrayList list$iv = new ArrayList();
                for (Object item$iv : $this$takeWhile$iv) {
                    Pair pair = (Pair)item$iv;
                    boolean bl2 = false;
                    IrValueParameter original = (IrValueParameter)pair.component1();
                    if (!(original.getDefaultValue() == null)) break;
                    list$iv.add(item$iv);
                }
                Iterable $this$any$iv = list$iv;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Pair pair = (Pair)element$iv;
                        boolean bl3 = false;
                        IrValueParameter original = (IrValueParameter)pair.component1();
                        IrValueParameter adapted = (IrValueParameter)pair.component2();
                        if (!(AdditionalIrUtilsKt.isVararg(original) && this.arrayDepth(original.getType()) == this.arrayDepth(adapted.getType()) + 1)) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        private final AdaptedBlock parseAdaptedBlock(IrBlock $this$parseAdaptedBlock) {
            AdaptedBlock adaptedBlock;
            if (!CollectionsKt.contains((Iterable)this.blockReferenceOrigins, (Object)$this$parseAdaptedBlock.getOrigin())) {
                return null;
            }
            if ($this$parseAdaptedBlock.getStatements().size() != 2) {
                return null;
            }
            List<IrStatement> list = $this$parseAdaptedBlock.getStatements();
            IrStatement function2 = list.get(0);
            IrStatement reference2 = list.get(1);
            if (!(function2 instanceof IrSimpleFunction)) {
                return null;
            }
            IrStatement irStatement = reference2;
            if (irStatement instanceof IrFunctionReference) {
                adaptedBlock = new AdaptedBlock((IrSimpleFunction)function2, (IrFunctionReference)reference2, null, ((IrFunctionReference)reference2).getType());
            } else if (irStatement instanceof IrTypeOperatorCall) {
                if (((IrTypeOperatorCall)reference2).getOperator() != IrTypeOperator.SAM_CONVERSION) {
                    return null;
                }
                IrExpression irExpression = ((IrTypeOperatorCall)reference2).getArgument();
                IrFunctionReference irFunctionReference = irExpression instanceof IrFunctionReference ? (IrFunctionReference)irExpression : null;
                if (irFunctionReference == null) {
                    return null;
                }
                IrFunctionReference argument = irFunctionReference;
                adaptedBlock = UpgradeCallableReferences.this.getUpgradeSamConversions() ? new AdaptedBlock((IrSimpleFunction)function2, argument, null, ((IrTypeOperatorCall)reference2).getTypeOperand()) : new AdaptedBlock((IrSimpleFunction)function2, argument, ((IrTypeOperatorCall)reference2).getTypeOperand(), argument.getType());
            } else {
                adaptedBlock = null;
            }
            return adaptedBlock;
        }

        @Override
        @NotNull
        public IrExpression visitBlock(@NotNull IrBlock expression2, @NotNull IrDeclarationParent data) {
            IrRichFunctionReferenceImpl irRichFunctionReferenceImpl;
            IrFunctionSymbol irFunctionSymbol;
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            if (!UpgradeCallableReferences.this.getUpgradeFunctionReferencesAndLambdas()) {
                return super.visitBlock(expression2, data);
            }
            AdaptedBlock adaptedBlock = this.parseAdaptedBlock(expression2);
            if (adaptedBlock == null) {
                return super.visitBlock(expression2, data);
            }
            AdaptedBlock adaptedBlock2 = adaptedBlock;
            IrSimpleFunction function2 = adaptedBlock2.component1();
            IrFunctionReference reference2 = adaptedBlock2.component2();
            IrType samType = adaptedBlock2.component3();
            IrType referenceType = adaptedBlock2.component4();
            function2.transformChildren(this, function2);
            reference2.transformChildren(this, data);
            boolean isRestrictedSuspension = this.isRestrictedSuspensionFunction(function2);
            this.flattenParameters(function2);
            Iterable $this$partition$iv = function2.getParameters();
            boolean $i$f$partition = false;
            ArrayList first$iv = new ArrayList();
            ArrayList second$iv = new ArrayList();
            for (Object element$iv : $this$partition$iv) {
                IrValueParameter it = (IrValueParameter)element$iv;
                boolean bl = false;
                boolean bl2 = reference2.getArguments().get(it.getIndexInParameters()) != null ? first$iv.add(element$iv) : second$iv.add(element$iv);
            }
            Pair pair = new Pair(first$iv, second$iv);
            List boundParameters = (List)pair.component1();
            List unboundParameters = (List)pair.component2();
            function2.setParameters(CollectionsKt.plus((Collection)boundParameters, (Iterable)unboundParameters));
            IrFunctionSymbol it22 = irFunctionSymbol = reference2.getReflectionTarget();
            boolean $i$a$-takeUnless-UpgradeCallableReferences$UpgradeTransformer$visitBlock$reflectionTarget$22 = false;
            IrFunctionSymbol reflectionTarget = !IrUtilsKt.isLambda(expression2.getOrigin()) ? irFunctionSymbol : null;
            int n2 = expression2.getStartOffset();
            int it22 = expression2.getEndOffset();
            IrSimpleFunctionSymbol $i$a$-takeUnless-UpgradeCallableReferences$UpgradeTransformer$visitBlock$reflectionTarget$22 = Companion.selectSAMOverriddenFunction(referenceType);
            IrStatementOrigin irStatementOrigin = expression2.getOrigin();
            boolean bl = reflectionTarget != null && !IrUtilsKt.isSuspend(reflectionTarget) && function2.isSuspend();
            boolean bl3 = reflectionTarget != null && !IrTypePredicatesKt.isUnit(reflectionTarget.getOwner().getReturnType()) && IrTypePredicatesKt.isUnit(function2.getReturnType());
            boolean bl4 = reflectionTarget instanceof IrSimpleFunctionSymbol && this.hasVarargConversion(function2, (IrSimpleFunction)((IrSimpleFunctionSymbol)reflectionTarget).getOwner());
            IrRichFunctionReferenceImpl $this$visitBlock_u24lambda_u242 = irRichFunctionReferenceImpl = BuildersKt.IrRichFunctionReferenceImpl(n2, it22, referenceType, reflectionTarget, $i$a$-takeUnless-UpgradeCallableReferences$UpgradeTransformer$visitBlock$reflectionTarget$22, function2, irStatementOrigin, bl3, bl, bl4, isRestrictedSuspension);
            boolean bl5 = false;
            $this$visitBlock_u24lambda_u242.getBoundValues().addAll(CollectionsKt.filterNotNull((Iterable)reference2.getArguments()));
            IrRichFunctionReferenceImpl it = irRichFunctionReferenceImpl;
            boolean bl6 = false;
            return samType != null ? (IrExpression)BuildersKt.IrTypeOperatorCallImpl(expression2.getStartOffset(), expression2.getEndOffset(), samType, IrTypeOperator.SAM_CONVERSION, samType, it) : (IrExpression)it;
        }

        @Override
        @NotNull
        public IrExpression visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            if (UpgradeCallableReferences.this.getUpgradeSamConversions() && expression2.getOperator() == IrTypeOperator.SAM_CONVERSION) {
                expression2.transformChildren(this, data);
                IrExpression argument = expression2.getArgument();
                if (!(argument instanceof IrRichFunctionReference)) {
                    return expression2;
                }
                IrExpression irExpression = argument;
                IrRichFunctionReference $this$visitTypeOperator_u24lambda_u240 = (IrRichFunctionReference)irExpression;
                boolean bl = false;
                $this$visitTypeOperator_u24lambda_u240.setStartOffset(expression2.getStartOffset());
                $this$visitTypeOperator_u24lambda_u240.setEndOffset(expression2.getEndOffset());
                $this$visitTypeOperator_u24lambda_u240.setType(expression2.getTypeOperand());
                $this$visitTypeOperator_u24lambda_u240.setOverriddenFunctionSymbol(Companion.selectSAMOverriddenFunction(expression2.getTypeOperand()));
                return irExpression;
            }
            return super.visitTypeOperator(expression2, data);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public IrExpression visitFunctionReference(@NotNull IrFunctionReference expression2, @NotNull IrDeclarationParent data) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            expression2.transformChildren(this, data);
            if (!UpgradeCallableReferences.this.getUpgradeFunctionReferencesAndLambdas()) {
                return expression2;
            }
            List<Pair<IrValueParameter, IrExpression>> arguments = IrUtilsKt.getArgumentsWithIr(expression2);
            int n2 = expression2.getStartOffset();
            int n3 = expression2.getEndOffset();
            IrType irType = expression2.getType();
            IrFunctionSymbol irFunctionSymbol = expression2.getReflectionTarget();
            if (irFunctionSymbol == null) {
                irFunctionSymbol = (IrFunctionSymbol)expression2.getSymbol();
            }
            Object object = irFunctionSymbol;
            IrFunctionSymbol irFunctionSymbol2 = object;
            IrType irType2 = irType;
            int n4 = n3;
            int n5 = n2;
            boolean bl = false;
            boolean bl2 = IrUtilsKt.isLambda(expression2.getOrigin());
            Object $this$visitFunctionReference_u24lambda_u241 = object = BuildersKt.IrRichFunctionReferenceImpl$default(n5, n4, irType2, (IrFunctionSymbol)(!bl2 ? object : null), Companion.selectSAMOverriddenFunction(expression2.getType()), UpgradeTransformer.wrapFunction$default(this, expression2, arguments, data, ((IrFunctionSymbol)expression2.getSymbol()).getOwner(), false, 8, null), expression2.getOrigin(), false, false, false, this.isRestrictedSuspensionFunction(((IrFunctionSymbol)expression2.getSymbol()).getOwner()), 896, null);
            boolean bl3 = false;
            Collection collection = ((IrRichFunctionReferenceImpl)$this$visitFunctionReference_u24lambda_u241).getBoundValues();
            Iterable $this$map$iv = arguments;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Pair pair = (Pair)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl4 = false;
                collection2.add((IrExpression)it.getSecond());
            }
            Iterable iterable2 = (List)destination$iv$iv;
            CollectionsKt.addAll((Collection)collection, (Iterable)iterable2);
            return (IrExpression)object;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public IrExpression visitPropertyReference(@NotNull IrPropertyReference expression2, @NotNull IrDeclarationParent data) {
            void $this$mapTo$iv$iv;
            IrRichPropertyReferenceImpl irRichPropertyReferenceImpl;
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            expression2.transformChildren(this, data);
            if (!UpgradeCallableReferences.this.getUpgradePropertyReferences()) {
                return expression2;
            }
            IrSimpleFunctionSymbol irSimpleFunctionSymbol = expression2.getGetter();
            IrSimpleFunction getter2 = irSimpleFunctionSymbol != null ? (IrSimpleFunction)irSimpleFunctionSymbol.getOwner() : null;
            List<Pair<IrValueParameter, IrExpression>> arguments = IrUtilsKt.getArgumentsWithIr(expression2);
            IrSimpleFunction getterFun = null;
            IrSimpleFunction setterFun = null;
            if (getter2 != null) {
                IrSimpleFunction irSimpleFunction;
                getterFun = this.wrapFunction(expression2, arguments, data, getter2, false);
                boolean condition$iv = IrTypeUtilsKt.isKMutableProperty(expression2.getType());
                boolean $i$f$runIf = false;
                if (condition$iv) {
                    boolean bl = false;
                    IrSimpleFunctionSymbol irSimpleFunctionSymbol2 = expression2.getSetter();
                    if (irSimpleFunctionSymbol2 != null) {
                        IrSimpleFunctionSymbol it = irSimpleFunctionSymbol2;
                        boolean bl2 = false;
                        irSimpleFunction = this.wrapFunction(expression2, (List<? extends Pair<? extends IrValueParameter, ? extends IrExpression>>)arguments, data, (IrFunction)it.getOwner(), true);
                    } else {
                        irSimpleFunction = null;
                    }
                } else {
                    irSimpleFunction = null;
                }
                setterFun = irSimpleFunction;
            } else {
                IrSimpleFunction irSimpleFunction;
                IrFieldSymbol irFieldSymbol = expression2.getField();
                Intrinsics.checkNotNull((Object)irFieldSymbol);
                IrField field = (IrField)irFieldSymbol.getOwner();
                getterFun = this.wrapField(expression2, arguments, data, field, false);
                boolean condition$iv = IrTypeUtilsKt.isKMutableProperty(expression2.getType());
                boolean $i$f$runIf = false;
                if (condition$iv) {
                    boolean bl = false;
                    irSimpleFunction = this.wrapField(expression2, arguments, data, field, true);
                } else {
                    irSimpleFunction = null;
                }
                setterFun = irSimpleFunction;
            }
            IrRichPropertyReferenceImpl $this$visitPropertyReference_u24lambda_u242 = irRichPropertyReferenceImpl = BuildersKt.IrRichPropertyReferenceImpl(expression2.getStartOffset(), expression2.getEndOffset(), expression2.getType(), (IrDeclarationWithAccessorsSymbol)expression2.getSymbol(), getterFun, setterFun, expression2.getOrigin());
            boolean bl = false;
            Collection collection = $this$visitPropertyReference_u24lambda_u242.getBoundValues();
            Iterable $this$map$iv = arguments;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Pair pair = (Pair)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl3 = false;
                collection2.add((IrExpression)it.getSecond());
            }
            Iterable iterable2 = (List)destination$iv$iv;
            CollectionsKt.addAll((Collection)collection, (Iterable)iterable2);
            return irRichPropertyReferenceImpl;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public IrExpression visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @NotNull IrDeclarationParent data) {
            IrSimpleFunction irSimpleFunction;
            void it;
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            expression2.transformChildren(this, data);
            if (!UpgradeCallableReferences.this.getUpgradeLocalDelegatedPropertyReferences()) {
                return expression2;
            }
            IrSimpleFunction irSimpleFunction2 = (IrSimpleFunction)expression2.getGetter().getOwner();
            IrDeclarationWithAccessorsSymbol irDeclarationWithAccessorsSymbol = (IrDeclarationWithAccessorsSymbol)expression2.getSymbol();
            IrType irType = expression2.getType();
            int n2 = expression2.getEndOffset();
            int n3 = expression2.getStartOffset();
            boolean bl = false;
            IrSimpleFunction irSimpleFunction3 = this.buildUnsupportedForLocalFunction(expression2, CollectionsKt.emptyList(), data, it.getName(), it.isSuspend(), false);
            int n4 = n3;
            int n5 = n2;
            IrType irType2 = irType;
            IrDeclarationWithAccessorsSymbol irDeclarationWithAccessorsSymbol2 = irDeclarationWithAccessorsSymbol;
            IrSimpleFunction irSimpleFunction4 = irSimpleFunction3;
            Object object = expression2.getSetter();
            if (object != null && (object = (IrSimpleFunction)object.getOwner()) != null) {
                void it2;
                Object object2 = object;
                irSimpleFunction3 = irSimpleFunction4;
                irDeclarationWithAccessorsSymbol = irDeclarationWithAccessorsSymbol2;
                irType = irType2;
                n2 = n5;
                n3 = n4;
                boolean bl2 = false;
                IrSimpleFunction irSimpleFunction5 = this.buildUnsupportedForLocalFunction(expression2, CollectionsKt.emptyList(), data, it2.getName(), it2.isSuspend(), true);
                n4 = n3;
                n5 = n2;
                irType2 = irType;
                irDeclarationWithAccessorsSymbol2 = irDeclarationWithAccessorsSymbol;
                irSimpleFunction4 = irSimpleFunction3;
                irSimpleFunction = irSimpleFunction5;
            } else {
                irSimpleFunction = null;
            }
            return BuildersKt.IrRichPropertyReferenceImpl(n4, n5, irType2, irDeclarationWithAccessorsSymbol2, irSimpleFunction4, irSimpleFunction, expression2.getOrigin());
        }

        private final IrSimpleFunction buildUnsupportedForLocalFunction(IrCallableReference<?> $this$buildUnsupportedForLocalFunction, List<? extends Pair<? extends IrValueParameter, ? extends IrExpression>> captured, IrDeclarationParent parent2, Name name2, boolean isSuspend, boolean isPropertySetter) {
            IrSimpleFunction irSimpleFunction = this.buildWrapperFunction($this$buildUnsupportedForLocalFunction, captured, parent2, name2, isSuspend, isPropertySetter, (Function3<? super IrBlockBodyBuilder, ? super List<? extends IrValueParameter>, ? super IrType, Unit>)((Function3)(arg_0, arg_1, arg_2) -> UpgradeTransformer.buildUnsupportedForLocalFunction$lambda$0(UpgradeCallableReferences.this, arg_0, arg_1, arg_2)));
            UpgradeCallableReferences upgradeCallableReferences = UpgradeCallableReferences.this;
            IrSimpleFunction $this$buildUnsupportedForLocalFunction_u24lambda_u241 = irSimpleFunction;
            boolean bl = false;
            $this$buildUnsupportedForLocalFunction_u24lambda_u241.setReturnType(upgradeCallableReferences.getContext().getIrBuiltIns().getNothingType());
            return irSimpleFunction;
        }

        /*
         * WARNING - void declaration
         */
        private final IrSimpleFunction buildWrapperFunction(IrCallableReference<?> $this$buildWrapperFunction, List<? extends Pair<? extends IrValueParameter, ? extends IrExpression>> captured, IrDeclarationParent parent2, Name name2, boolean isSuspend, boolean isPropertySetter, Function3<? super IrBlockBodyBuilder, ? super List<? extends IrValueParameter>, ? super IrType, Unit> body) {
            void this_$iv$iv;
            void $this$buildWrapperFunction_u24lambda_u242_u242;
            IrType irType;
            List unboundArgTypes;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            IrType irType2 = $this$buildWrapperFunction.getType();
            Intrinsics.checkNotNull((Object)irType2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrSimpleType");
            IrSimpleType referenceType = (IrSimpleType)irType2;
            Iterable iterable = referenceType.getArguments();
            UpgradeCallableReferences upgradeCallableReferences = UpgradeCallableReferences.this;
            boolean $i$f$map = false;
            IrSimpleFunction irSimpleFunction = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                IrTypeArgument irTypeArgument = (IrTypeArgument)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                IrType irType3 = IrTypesKt.getTypeOrNull(irTypeArgument);
                if (irType3 == null) {
                    irType3 = upgradeCallableReferences.getContext().getIrBuiltIns().getAnyNType();
                }
                collection.add(irType3);
            }
            List referenceTypeArgs = (List)destination$iv$iv;
            List list = unboundArgTypes = isPropertySetter ? referenceTypeArgs : CollectionsKt.dropLast((List)referenceTypeArgs, (int)1);
            if (isPropertySetter) {
                irType = UpgradeCallableReferences.this.getContext().getIrBuiltIns().getUnitType();
            } else {
                irType = (IrType)CollectionsKt.lastOrNull((List)referenceTypeArgs);
                if (irType == null) {
                    irType = UpgradeCallableReferences.this.getContext().getIrBuiltIns().getAnyNType();
                }
            }
            IrType returnType = irType;
            IrFactory $this$buildFun$iv = UpgradeCallableReferences.this.getContext().getIrFactory();
            boolean $i$f$buildFun = false;
            IrFunctionBuilder $this$buildFun_u24lambda_u240$iv = new IrFunctionBuilder();
            boolean bl = false;
            IrFunctionBuilder $this$buildWrapperFunction_u24lambda_u241 = $this$buildFun_u24lambda_u240$iv;
            boolean bl2 = false;
            IrElementBuilderKt.setSourceRange($this$buildWrapperFunction_u24lambda_u241, $this$buildWrapperFunction);
            $this$buildWrapperFunction_u24lambda_u241.setOrigin(IrDeclarationOrigin.Companion.getLOCAL_FUNCTION_FOR_LAMBDA());
            $this$buildWrapperFunction_u24lambda_u241.setName(name2);
            DescriptorVisibility descriptorVisibility = DescriptorVisibilities.LOCAL;
            Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"LOCAL");
            $this$buildWrapperFunction_u24lambda_u241.setVisibility(descriptorVisibility);
            $this$buildWrapperFunction_u24lambda_u241.setReturnType(returnType);
            $this$buildWrapperFunction_u24lambda_u241.setSuspend(isSuspend);
            irSimpleFunction = DeclarationBuildersKt.buildFunction($this$buildFun$iv, $this$buildFun_u24lambda_u240$iv);
            UpgradeCallableReferences upgradeCallableReferences2 = UpgradeCallableReferences.this;
            IrSimpleFunction $this$buildWrapperFunction_u24lambda_u242 = irSimpleFunction;
            boolean bl3 = false;
            $this$buildWrapperFunction_u24lambda_u242.setParent(parent2);
            for (Pair pair : captured) {
                IrValueParameter irValueParameter;
                IrFunction $this$addValueParameter$iv = $this$buildWrapperFunction_u24lambda_u242;
                boolean $i$f$addValueParameter = false;
                IrValueParameterBuilder $this$addValueParameter_u24lambda_u240$iv = new IrValueParameterBuilder();
                boolean bl4 = false;
                IrValueParameterBuilder $this$buildWrapperFunction_u24lambda_u242_u240 = $this$addValueParameter_u24lambda_u240$iv;
                boolean bl5 = false;
                $this$buildWrapperFunction_u24lambda_u242_u240.setName(((IrValueParameter)pair.getFirst()).getName());
                $this$buildWrapperFunction_u24lambda_u242_u240.setType(((IrExpression)pair.getSecond()).getType());
                $this$addValueParameter_u24lambda_u240$iv.setKind(IrParameterKind.Regular);
                IrValueParameter valueParameter$iv = irValueParameter = DeclarationBuildersKt.buildValueParameter($this$addValueParameter$iv.getFactory(), $this$addValueParameter_u24lambda_u240$iv, $this$addValueParameter$iv);
                boolean bl6 = false;
                $this$addValueParameter$iv.setParameters(CollectionsKt.plus((Collection)$this$addValueParameter$iv.getParameters(), (Object)valueParameter$iv));
            }
            int index = 0;
            for (IrType type : unboundArgTypes) {
                IrValueParameter bl6;
                IrFunction $this$addValueParameter$iv = $this$buildWrapperFunction_u24lambda_u242;
                boolean $i$f$addValueParameter = false;
                IrValueParameterBuilder $this$addValueParameter_u24lambda_u240$iv = new IrValueParameterBuilder();
                boolean bl7 = false;
                IrValueParameterBuilder $this$buildWrapperFunction_u24lambda_u242_u241 = $this$addValueParameter_u24lambda_u240$iv;
                boolean bl8 = false;
                int valueParameter$iv = index;
                index = valueParameter$iv + 1;
                Name name3 = Name.identifier("" + 'p' + valueParameter$iv);
                Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"identifier(...)");
                $this$buildWrapperFunction_u24lambda_u242_u241.setName(name3);
                $this$buildWrapperFunction_u24lambda_u242_u241.setType(type);
                $this$addValueParameter_u24lambda_u240$iv.setKind(IrParameterKind.Regular);
                IrValueParameter valueParameter$iv2 = bl6 = DeclarationBuildersKt.buildValueParameter($this$addValueParameter$iv.getFactory(), $this$addValueParameter_u24lambda_u240$iv, $this$addValueParameter$iv);
                boolean $i$a$-also-DeclarationBuildersKt$addValueParameter$1$1$iv2 = false;
                $this$addValueParameter$iv.setParameters(CollectionsKt.plus((Collection)$this$addValueParameter$iv.getParameters(), (Object)valueParameter$iv2));
            }
            DeclarationIrBuilder type = LowerUtilsKt.createIrBuilder$default(upgradeCallableReferences2.getContext(), (IrSymbol)$this$buildWrapperFunction_u24lambda_u242.getSymbol(), 0, 0, 6, null);
            IrSimpleFunction irSimpleFunction2 = $this$buildWrapperFunction_u24lambda_u242;
            boolean bl9 = false;
            IrBuilderWithScope $this$irBlockBody_u24default$iv = (IrBuilderWithScope)$this$buildWrapperFunction_u24lambda_u242_u242;
            int startOffset$iv = $this$irBlockBody_u24default$iv.getStartOffset();
            int endOffset$iv = $this$irBlockBody_u24default$iv.getEndOffset();
            boolean $i$f$irBlockBody = false;
            IrBlockBodyBuilder bl8 = new IrBlockBodyBuilder($this$irBlockBody_u24default$iv.getContext(), $this$irBlockBody_u24default$iv.getScope(), startOffset$iv, endOffset$iv);
            boolean $i$f$blockBody = false;
            void $this$buildWrapperFunction_u24lambda_u242_u242_u240 = this_$iv$iv;
            boolean bl10 = false;
            body.invoke((Object)$this$buildWrapperFunction_u24lambda_u242_u242_u240, $this$buildWrapperFunction_u24lambda_u242.getParameters(), (Object)returnType);
            irSimpleFunction2.setBody(this_$iv$iv.doBuild());
            IrSimpleFunction func = irSimpleFunction;
            return func;
        }

        private final IrSimpleFunction wrapField(IrPropertyReference $this$wrapField, List<? extends Pair<? extends IrValueParameter, ? extends IrExpression>> captured, IrDeclarationParent parent2, IrField field, boolean isPropertySetter) {
            IrCallableReference irCallableReference = $this$wrapField;
            Name name2 = Name.special('<' + (isPropertySetter ? "set-" : "get-") + ((IrProperty)((IrPropertySymbol)$this$wrapField.getSymbol()).getOwner()).getName() + '>');
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"special(...)");
            return this.buildWrapperFunction(irCallableReference, captured, parent2, name2, false, isPropertySetter, (Function3<? super IrBlockBodyBuilder, ? super List<? extends IrValueParameter>, ? super IrType, Unit>)((Function3)(arg_0, arg_1, arg_2) -> UpgradeTransformer.wrapField$lambda$0(field, isPropertySetter, arg_0, arg_1, arg_2)));
        }

        private final IrSimpleFunction wrapFunction(IrCallableReference<?> $this$wrapFunction, List<? extends Pair<? extends IrValueParameter, ? extends IrExpression>> captured, IrDeclarationParent parent2, IrFunction referencedFunction, boolean isPropertySetter) {
            return this.buildWrapperFunction($this$wrapFunction, captured, parent2, referencedFunction.getName(), AdditionalIrUtilsKt.isSuspend(referencedFunction), isPropertySetter, (Function3<? super IrBlockBodyBuilder, ? super List<? extends IrValueParameter>, ? super IrType, Unit>)((Function3)(arg_0, arg_1, arg_2) -> UpgradeTransformer.wrapFunction$lambda$0(referencedFunction, UpgradeCallableReferences.this, $this$wrapFunction, captured, arg_0, arg_1, arg_2)));
        }

        static /* synthetic */ IrSimpleFunction wrapFunction$default(UpgradeTransformer upgradeTransformer, IrCallableReference irCallableReference, List list, IrDeclarationParent irDeclarationParent, IrFunction irFunction, boolean bl, int n2, Object object) {
            if ((n2 & 8) != 0) {
                bl = false;
            }
            return upgradeTransformer.wrapFunction(irCallableReference, list, irDeclarationParent, irFunction, bl);
        }

        private static final IrStatement visitDeclaration$lambda$0(UpgradeTransformer this$0, IrDeclarationBase $declaration, IrDeclarationParent $data) {
            IrElement irElement = this$0.visitElement((IrElement)$declaration, $data);
            Intrinsics.checkNotNull((Object)irElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.IrStatement");
            return (IrStatement)irElement;
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit buildUnsupportedForLocalFunction$lambda$0(UpgradeCallableReferences this$0, IrBlockBodyBuilder $this$buildWrapperFunction, List list, IrType irType) {
            void $this$buildUnsupportedForLocalFunction_u24lambda_u240_u240;
            IrCall irCall;
            Intrinsics.checkNotNullParameter((Object)$this$buildWrapperFunction, (String)"$this$buildWrapperFunction");
            Intrinsics.checkNotNullParameter((Object)list, (String)"<unused var>");
            Intrinsics.checkNotNullParameter((Object)irType, (String)"<unused var>");
            IrCall irCall2 = irCall = ExpressionHelpersKt.irCall((IrBuilder)$this$buildWrapperFunction, this$0.getContext().getSymbols().getThrowUnsupportedOperationException());
            IrBlockBodyBuilder irBlockBodyBuilder = $this$buildWrapperFunction;
            boolean bl = false;
            $this$buildUnsupportedForLocalFunction_u24lambda_u240_u240.getArguments().set(0, ExpressionHelpersKt.irString($this$buildWrapperFunction, "Not supported for local property reference."));
            irBlockBodyBuilder.unaryPlus(irCall);
            return Unit.INSTANCE;
        }

        private static final Unit wrapField$lambda$0(IrField $field, boolean $isPropertySetter, IrBlockBodyBuilder $this$buildWrapperFunction, List params, IrType expectedReturnType) {
            Intrinsics.checkNotNullParameter((Object)$this$buildWrapperFunction, (String)"$this$buildWrapperFunction");
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            Intrinsics.checkNotNullParameter((Object)expectedReturnType, (String)"expectedReturnType");
            int index = 0;
            IrGetValueImpl fieldReceiver = $field.isStatic() ? null : ExpressionHelpersKt.irGet($this$buildWrapperFunction, (IrValueDeclaration)params.get(index++));
            IrExpression exprToReturn = IrUtilsKt.implicitCastIfNeededTo($isPropertySetter ? (IrFieldAccessExpression)ExpressionHelpersKt.irSetField$default($this$buildWrapperFunction, fieldReceiver, $field, ExpressionHelpersKt.irGet($this$buildWrapperFunction, (IrValueDeclaration)params.get(index++)), null, 8, null) : (IrFieldAccessExpression)ExpressionHelpersKt.irGetField$default($this$buildWrapperFunction, fieldReceiver, $field, null, 4, null), expectedReturnType);
            if (!(index == params.size())) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            $this$buildWrapperFunction.unaryPlus(ExpressionHelpersKt.irReturn($this$buildWrapperFunction, exprToReturn));
            return Unit.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit wrapFunction$lambda$0(IrFunction $referencedFunction, UpgradeCallableReferences this$0, IrCallableReference $this_wrapFunction, List $captured, IrBlockBodyBuilder $this$buildWrapperFunction, List parameters, IrType expectedReturnType) {
            IrMemberAccessExpression<?> irMemberAccessExpression;
            AbstractIrTypeSubstitutor abstractIrTypeSubstitutor;
            void destination$iv;
            Object object;
            void $this$mapTo$iv;
            Iterable $this$sortedBy$iv;
            void $this$mapTo$iv$iv;
            Object it22;
            void $this$associateTo$iv$iv;
            Object object2;
            void $this$mapTo$iv$iv2;
            Intrinsics.checkNotNullParameter((Object)$this$buildWrapperFunction, (String)"$this$buildWrapperFunction");
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            Intrinsics.checkNotNullParameter((Object)expectedReturnType, (String)"expectedReturnType");
            List<IrTypeParameter> allTypeParameters = IrUtilsKt.getAllTypeParameters($referencedFunction);
            Iterable $this$map$iv = (Iterable)CollectionsKt.getIndices((Collection)allTypeParameters);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo22 = false;
            Iterator iterator2 = $this$mapTo$iv$iv2.iterator();
            while (iterator2.hasNext()) {
                void it;
                int item$iv$iv;
                int n2 = item$iv$iv = ((IntIterator)iterator2).nextInt();
                object2 = destination$iv$iv;
                boolean bl = false;
                IrType irType = (IrType)CollectionsKt.getOrNull($this_wrapFunction.getTypeArguments(), (int)it);
                if (irType == null) {
                    irType = $this$buildWrapperFunction.getContext().getIrBuiltIns().getAnyNType();
                }
                object2.add(irType);
            }
            List cleanedTypeArguments = (List)destination$iv$iv;
            Iterable $this$associate$iv = (Iterable)CollectionsKt.getIndices((Collection)allTypeParameters);
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable $i$f$mapTo22 = $this$associate$iv;
            Object destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            Iterator it = $this$associateTo$iv$iv.iterator();
            while (it.hasNext()) {
                int element$iv$iv = ((IntIterator)it).nextInt();
                Map map = destination$iv$iv2;
                int it22 = element$iv$iv;
                boolean bl = false;
                it22 = TuplesKt.to((Object)allTypeParameters.get(it22).getSymbol(), cleanedTypeArguments.get(it22));
                map.put(it22.getFirst(), it22.getSecond());
            }
            Map typeArgumentsMap = destination$iv$iv2;
            DeclarationIrBuilder builder = (DeclarationIrBuilder)LowerUtilsKt.at((IrBuilder)LowerUtilsKt.createIrBuilder$default(this$0.getContext(), $this_wrapFunction.getSymbol(), 0, 0, 6, null), $this_wrapFunction);
            Iterable $this$map$iv2 = $captured;
            boolean $i$f$map2 = false;
            destination$iv$iv2 = $this$map$iv2;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it22 = (Pair)item$iv$iv;
                object2 = destination$iv$iv3;
                boolean bl = false;
                object2.add((IrValueParameter)it22.getFirst());
            }
            Set bound = CollectionsKt.toSet((Iterable)((List)destination$iv$iv3));
            Iterable $this$partition$iv = $referencedFunction.getParameters();
            boolean $i$f$partition = false;
            ArrayList first$iv = new ArrayList();
            ArrayList second$iv = new ArrayList();
            for (Object element$iv : $this$partition$iv) {
                it22 = (IrValueParameter)element$iv;
                boolean bl = false;
                boolean bl2 = bound.contains(it22) ? first$iv.add(element$iv) : second$iv.add(element$iv);
            }
            Pair pair = new Pair(first$iv, second$iv);
            List boundParameters = (List)pair.component1();
            List unboundParameters = (List)pair.component2();
            if (!(boundParameters.size() + unboundParameters.size() == parameters.size())) {
                boolean $i$a$-require-UpgradeCallableReferences$UpgradeTransformer$wrapFunction$1$32 = false;
                String $i$a$-require-UpgradeCallableReferences$UpgradeTransformer$wrapFunction$1$32 = "Wrong number of parameters in wrapper: expected: " + boundParameters.size() + " bound and " + unboundParameters.size() + " unbound, but " + parameters.size() + " found";
                throw new IllegalArgumentException($i$a$-require-UpgradeCallableReferences$UpgradeTransformer$wrapFunction$1$32.toString());
            }
            Iterable $i$a$-require-UpgradeCallableReferences$UpgradeTransformer$wrapFunction$1$32 = CollectionsKt.zip((Iterable)CollectionsKt.plus((Collection)boundParameters, (Iterable)unboundParameters), (Iterable)parameters);
            boolean $i$f$sortedBy22 = false;
            $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a2, T b2) {
                    Pair it = (Pair)a2;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(((IrValueParameter)it.getFirst()).getIndexInParameters());
                    it = (Pair)b2;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(((IrValueParameter)it.getFirst()).getIndexInParameters()));
                }
            });
            Collection $i$f$sortedBy22 = new ArrayList();
            boolean $i$f$mapTo32 = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it3;
                object = (Pair)item$iv;
                object2 = destination$iv;
                boolean bl = false;
                object2.add(ExpressionHelpersKt.irGet(builder, (IrValueDeclaration)it3.getSecond()));
            }
            List uncheckedArguments = (List)destination$iv;
            IrBlockBodyBuilder $i$f$mapTo32 = $this$buildWrapperFunction;
            object2 = new IrTypeSubstitutor(typeArgumentsMap, true);
            boolean bl = false;
            Object object3 = $referencedFunction.getDispatchReceiverParameter();
            if (object3 == null || (object3 = object3.getType()) == null || (object3 = IrTypesKt.getClassOrNull((IrType)object3)) == null) {
                abstractIrTypeSubstitutor = null;
            } else {
                IrSimpleType irSimpleType;
                Object dispatchReceiverParameterClass = object3;
                object = ((IrExpression)uncheckedArguments.get(0)).getType();
                IrSimpleType dispatchReceiverType = object instanceof IrSimpleType ? (IrSimpleType)object : null;
                Object object4 = dispatchReceiverType;
                if (!(object4 != null && (object4 = ((IrSimpleType)object4).getClassifier()) != null ? IrTypeUtilsKt.isSubtypeOfClass((IrClassifierSymbol)object4, (IrClassSymbol)dispatchReceiverParameterClass) : false)) {
                    irSimpleType = IrTypesKt.getStarProjectedType((IrClassSymbol)dispatchReceiverParameterClass);
                } else {
                    IrType irType = ((IrExpression)uncheckedArguments.get(0)).getType();
                    Intrinsics.checkNotNull((Object)irType, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrSimpleType");
                    irSimpleType = (IrSimpleType)irType;
                }
                abstractIrTypeSubstitutor = AbstractIrTypeSubstitutor.Companion.forSuperClass((IrClassSymbol)dispatchReceiverParameterClass, irSimpleType);
            }
            AbstractIrTypeSubstitutor typeSubstitutor2 = IrTypeSubstitutorKt.chainedWith((AbstractIrTypeSubstitutor)object2, abstractIrTypeSubstitutor);
            IrMemberAccessExpression<?> $this$wrapFunction_u24lambda_u240_u248 = irMemberAccessExpression = ExpressionHelpersKt.irCall((IrBuilder)builder, $referencedFunction.getSymbol(), typeSubstitutor2.substitute($referencedFunction.getReturnType()), cleanedTypeArguments);
            boolean bl3 = false;
            for (IrValueParameter parameter : $referencedFunction.getParameters()) {
                $this$wrapFunction_u24lambda_u240_u248.getArguments().set(parameter, IrUtilsKt.implicitCastIfNeededTo((IrExpression)uncheckedArguments.get(parameter.getIndexInParameters()), typeSubstitutor2.substitute(parameter.getType())));
            }
            IrExpression exprToReturn = IrUtilsKt.implicitCastIfNeededTo(irMemberAccessExpression, expectedReturnType);
            $this$buildWrapperFunction.unaryPlus(ExpressionHelpersKt.irReturn($this$buildWrapperFunction, exprToReturn));
            return Unit.INSTANCE;
        }
    }
}

