#!/bin/sh
set -xue
anadir=$(realpath $(dirname $0)/analyses)
mkdir -p $anadir
podman pull fedora:rawhide
branch=$(git rev-parse --abbrev-ref HEAD)
comppkg=gcc ; compiler=gcc; pfx=
# comppkg=clang-analyzer ; compiler=clang; pfx="scan-build -o /ana"
exec podman run --rm -it \
	--security-opt label=disable \
	-v "$(git rev-parse --path-format=absolute --git-common-dir):/gitrepo/.git":ro \
	-v ~/.cache/dnfcache-rawhide:/var/cache/libdnf5 \
	-v "$anadir":/ana \
	fedora:rawhide \
	sh -c "
	dnf --setopt=keepcache=1 upgrade -y &&
	dnf --setopt=keepcache=1 install automake awk bison flex $comppkg gettext-devel git openssl-devel -y &&
	git clone --single-branch --branch '$branch' /gitrepo fetchmail &&
	cd fetchmail &&
	autoreconf -svi &&
	./configure -C CC=$compiler CFLAGS='-Wall -Wextra -g -O2' &&
	$pfx make -j$(nproc) check V=1 &&
	./fetchmail -V"
