# clang++

> C++ 소스 파일을 컴파일합니다.
> LLVM의 일부.
> 더 많은 정보: <https://clang.llvm.org/docs/UsersManual.html#command-line-options>.

- 소스 코드를 실행 가능한 바이너리 파일로 컴파일합니다:

`clang++ {{입력/파일/경로.cpp}} {{[-o|--output]}} {{출력/파일/경로}}`

- (거의) 모든 에러와 경고 메시지를 표시합니다:

`clang++ {{입력/파일/경로.cpp}} -Wall {{[-o|--output]}} {{출력/파일/경로}}`

- 컴파일할 때 사용할 언어 표준을 지정합니다:

`clang++ {{입력/파일/경로.cpp}} -std={{c++20}} {{[-o|--output]}} {{출력/파일/경로}}`

- 소스 파일과 다른 경로에 있는 라이브러리를 포함합니다:

`clang++ {{입력/파일/경로.cpp}} {{[-o|--output]}} {{출력/파일/경로}} -I{{헤더/경로}} -L{{라이브러리/경로}} -l{{라이브러리/이름}}`

- 소스 코드를 LLVM Intermediate Representation(IR)로 컴파일 합니다:

`clang++ {{[-S|--assemble]}} -emit-llvm {{입력/파일/경로.cpp}} {{[-o|--output]}} {{출력/파일/경로.ll}}`
