---
title: Description of `mfront-query`
author: Thomas Helfer
date: 15/03/2022
lang: en-EN
geometry:
  - margin=2cm
papersize: a4
link-citations: true
colorlinks: true
figPrefixTemplate: "$$i$$"
tblPrefixTemplate: "$$i$$"
secPrefixTemplate: "$$i$$"
eqnPrefixTemplate: "($$i$$)"
---

# Introduction

`mfront-query` is a command line tool used to retrieve information from
an `MFront` file.

## Usage

`mfront-query` can be used as follows:

~~~~{.cxx}
$ mfront-query [queries] [input-files]
~~~~

> `madnex` files
>
> The support of madnex files is treated in depth in Section
> @msec:mfront_query:madnex_support.

The list of available queries depends on the kind of material knowledge
described by the input files. The list of available queries can be
displayed using one the following command line arguments:

- `--help-material-property-queries-list`: lists the queries associated
  with material properties.
- `--help-behaviour-queries-list`: list all queries avaiable for mfront
  behaviour files. Section @sec:mfront_query:behaviour_queries describes
  some of those queries in depth.
- `--help-model-queries-list`: list all queries avaiable for mfront
  model files.

Section @sec:mfront_query:general_queries describes queries valid for
all `MFront` files.

# General queries {#sec:mfront_query:general_queries}

## List of dependencies of an `MFront` file

The `--list-dependencies` query lists all the dependencies of an
`MFront` file.

If a dependency is encoded in a `madnex` file, an internal representation of
the path to this dependency is returned (see example below).

### Example of usage

~~~~{.bash}
$ mfront-query --list-dependencies --search-path=generate   \
               --madnex-search-path=MaterialProperties.mdnx \
               Test.mfront 
madnex:generate/MaterialProperties.mdnx:MaterialProperty::YoungModulusTest
~~~~

## Querying information about parameters in `mfront-query`

### List of parameters

The list of parameters in an `mfront` file can be retrieved as follows:

~~~~{.bash}
$ mfront-query --parameters Rousselier.mfront
...
- safety_factor_for_the_upper_bound_of_the_porosity: a safety factor for the porosity upper bound
- safety_factor_for_the_upper_bound_of_the_porosity_for_fracture_detection: a safety factor for the porosity upper bound
- staggered_scheme_porosity_criterion: stopping criterion value of the staggered scheme
- staggered_scheme_maximum_number_of_iterations: maximum number of iterations of the staggered scheme allowed
- minimal_time_step_scaling_factor: minimal value for the time step scaling factor
- maximal_time_step_scaling_factor: maximal value for the time step scaling factor
- numerical_jacobian_epsilon: perturbation value used to compute a numerical approximation of the jacobian
- iterMax: maximum number of iterations allowed
~~~~

### Querying the default value of a parameter

The default value of a parameter can be retrieved using the
`--parameter-default-value` query, as follows:

~~~~{.bash}
$ mfront-query --parameter-default-value=epsilon Rousselier.mfront 
1.e-14
$ mfront-query --parameter-default-value=iterMax Rousselier.mfront
100
~~~~

### Querying the type of a parameter

The type of a parameter can be retrieved through the `--parameter-type`
query, as follows:

~~~~{.bash}
$ mfront-query --parameter-type=iterMax Rousselier.mfront
ushort
~~~~

Here `ushort` means that the `iterMax` parameter is stored as unsigned
short integer.

## Querying the name of the parameters' file through `mfront-query`

The name of the file which can be used to modify the parameters' values
(see Section @sec:mfront:parameters:parameters_file) can be retrieved
with the `--parameters-file` query:

~~~~{.bash}
$ mfront-query --parameters-file Rousselier.mfront 
Rousseliertest-parameters.txt
~~~~

## The `--generated-sources` query

The `--generated-sources` query can now have an option:

- `sorted-by-libraries` (default): which returns the sources to be
  generated associated with each library
- `unsorted`: which returns all the sources to be generated

This option may be used in conjunction with the `--nomelt` option.

## Retrieve the sources associated with specific targets

`mfront-query` has two queries associated to specific targets:

- `--specific-target-generated-sources` which allows to retrieve the
  sources generated by a specific target
- `--all-specific-targets-generated-source`, which displays all the
  sources associated with specific targets

By default, all sources associated with libraries dependencies of the
specific targets are also displayed, unless the `--nomelt` command line
argument is used.

## The `--list-implementation-paths` query

The `--list-implementation-paths` query returns explicit paths to
material knowledge in a `madnex` file. This query has two options:

- `sorted-by-files` (default): the implementations paths are preceded by
  the `madnex` file name.
- `unsorted`: the implementations paths are not preceded by the `madnex`
  file name.

~~~~{.bash}
$ mfront-query --list-implementation-paths=unsorted --all-behaviours Plasticity.mdnx
madnex:Plasticity.mdnx:behaviour::Plasticity
~~~~

# Behaviour queries {#sec:mfront_query:behaviour_queries}

## List of initialize functions

The list of initialize functions defined by a behaviour can be retrieved
using the `--initialize functions` query, as follows:

~~~~{.bash}
 mfront-query --initialize-functions Plasticity.mfront 
- ElasticStrainFromInitialStress: no description available.
~~~~

## List of initialize function variables

The list of initialize function' variables defined by a behaviour can be
retrieved using the `--initialize function-variables` query.

## List of post-processings

The list of post-processings defined by a behaviour can be retrieved
using the `--post-processings` query, as follows:

~~~~{.bash}
$ mfront-query --post-processings Elasticity.mfront 
- PrincipalStrain: compute the principal strain. Modified post-processing variables are:
  - PrincipalStrain (εᵖ)
~~~~

## List of post-processing variables

The list of post-processing' variables defined by a behaviour can be
retrieved using the `--post-processing-variables` query, as follows:

~~~~{.bash}
$ mfront-query --post-processing-variables Elasticity.mfront 
- PrincipalStrain (εᵖ)
~~~~

### Getting information about the climb tensors

The following queries are available to retrieve information about climb tensors:

- `--climb-tensors`: list all the climb tensors, sorted by
  family".
- `--climb-tensors-by-index`: list all the climb tensors.
- `--climb-tensors-by-slip-system`: list all the climb
  tensors sorted by slip systems.

## Display information about a code block

The query `--code-block` returns the information about code block.

### Example of usage

~~~~{.bash}
$ mfront-query --code-block=Integrator UserDefinedViscoplasticityTest.mfront
- Integrator: 
  - code:
  feel -= this->deto;
  
  if(!perturbatedSystemEvaluation){
  }
  const auto& s = this->sig;
  const auto seq = sigmaeq(s);
  const auto iseq = 1/max(seq,(this->relative_value_for_the_equivalent_stress_lower_bound) * this->young);
  const auto dseq_ds = 3*deviator(s)*(iseq/2);
  const auto d2seq_dsds = (Stensor4::M()-(dseq_ds^dseq_ds))*iseq;
  const auto& n = dseq_ds;
  const auto& dn_ds = d2seq_dsds;
  feel += this->dp* n;
  dfeel_ddp = n;
  dfeel_ddeel += (2 * this->mu)*(this->theta) * ((this->dp) * dn_ds);
  const auto mfront_udvf_f = seq;
  const auto vp = [this, mfront_udvf_f] {
    if(mfront_udvf_f >= stress{0}){
     return strainrate{(this->A)*(std::pow(mfront_udvf_f,this->E))};
    }
    return strainrate{0};
  }();
  const auto dvp_dseqe = [this, mfront_udvf_f] {
    if(mfront_udvf_f >= stress{0}){
  return derivative_type<strainrate, stress>{(this->A)*((this->E)*(std::pow(mfront_udvf_f,(this->E)-(1))))};
    }
    return derivative_type<strainrate, stress>{0};
  }();
  fp -= (this->dt) * vp;
  dfp_ddeel += (2 * this->mu)*(this->theta) * (-(this->dt) * dvp_dseqe * dseq_ds);
~~~~

## List of `MTest` tests associated with a behaviour in a `madnex` file

The `--list-behaviour-mtest-tests` command line argument can be used to
display the list of tests associated with a behaviour in a `madnex`
file.

Optionnally, this command line argument accept the options
`sorted-by-behaviours` or `unsorted` (see the examples below).

### Examples of usage

~~~~{.cxx}
$ mfront-query --list-behaviour-mtest-tests --test=".+Tensile.+" Plasticity.mdnx
- tests associated with behaviour Plasticity
    - UniaxialTensileTest
~~~~

~~~~{.cxx}
$ mfront-query --list-behaviour-mtest-tests=unsorted --test=".+Tensile.+" Plasticity.mdnx
UniaxialTensileTest
~~~~

## List of `mfm-test-generator` tests associated with a behaviour in a `madnex` file

The `--list-behaviour-mfm-test-generator-tests` command line argument
can be used to display the list of tests associated with a behaviour in
a `madnex` file.

Optionnally, this command line argument accept the options
`sorted-by-behaviours` or `unsorted` (see the examples below).

### Examples of usage

~~~~{.cxx}
$ mfront-query --list-behaviour-mfm-test-generator-tests --test=".+Tensile.+" Plasticity.mdnx
~~~~

~~~~{.cxx}
$ mfront-query --list-behaviour-mfm-test-generator-tests=unsorted --test=".+Tensile.+" Plasticity.mdnx
~~~~

# `madnex` files support {#sec:mfront_query:madnex_support}

## Options specific to `madnex` files

Several options has been added to the `mfront-query` specifically for
`madnex` files.

Queries of the file itself (list of materials, behaviours, etc...) are
also provided by the `madnex-query` tool.

### Listing all material a `madnex` file

The `--list-materials` returns the list of all materials in a `MFront`
file:

~~~~{.bash}
$ mfront-query --list-materials file.madnex
~~~~

### Listing of all material properties, all behaviours or all models

The following options are available:

- `--list-material-properties`: list of material properties.
- `--list-behaviours`: list of all behaviours.
- `--list-models`: list of all models.

A typical call is as follows:

~~~~{.bash}
$ mfront-query --list-behaviours file.madnex
~~~~

The previous options are affected by the the definition of a material,
as follows:

~~~~{.bash}
$ mfront-query --material=<material_id> --list-behaviours file.madnex
~~~~

## Querying information about implementation, options specific to `madnex` files

For a behaviour, the selection of an implementation on which the queries
are made is done through the `--material` and `--behaviour` options. For
example:

~~~~{.bash}
$ mfront-query --obuild --interface=generic --material=<material_id> --behaviour=<behaviour_id> file.madnex --state-variables
~~~~

Here, `behaviour_id` can be a regular expression.

For material properties and models, the `--material-property` and
`--model` options have a similar role than the `--behaviour` option for
behaviours.

### List of `MTest` tests associated with a behaviour in a `madnex` file

The `--list-behaviour-mtest-tests` command line argument can be used to
display the list of tests associated with a behaviour in a `madnex`
file.

Optionnally, this command line argument accept the options
`sorted-by-behaviours` or `unsorted` (see the examples below).

#### Examples of usage

~~~~{.cxx}
$ mfront-query --list-behaviour-mtest-tests --test=".+Tensile.+" Plasticity.mdnx
- tests associated with behaviour Plasticity
    - UniaxialTensileTest
~~~~

~~~~{.cxx}
$ mfront-query --list-behaviour-mtest-tests=unsorted --test=".+Tensile.+" Plasticity.mdnx
UniaxialTensileTest
~~~~

### List of `mfm-test-generator` tests associated with a behaviour in a `madnex` file

The `--list-behaviour-mfm-test-generator-tests` command line argument
can be used to display the list of tests associated with a behaviour in
a `madnex` file.

Optionnally, this command line argument accept the options
`sorted-by-behaviours` or `unsorted` (see the examples below).
