# Модели Query-Параметров { #query-parameter-models }

Если у вас есть группа связанных **query-параметров**, то вы можете объединить их в одну **Pydantic-модель**.

Это позволит вам **переиспользовать модель** в **разных местах**, устанавливать валидаторы и метаданные, в том числе для сразу всех параметров, в одном месте. 😎

/// note | Заметка

Этот функционал доступен с версии `0.115.0`. 🤓

///

## Pydantic-Модель для Query-Параметров { #query-parameters-with-a-pydantic-model }

Объявите нужные **query-параметры** в **Pydantic-модели**, а после аннотируйте параметр как `Query`:

{* ../../docs_src/query_param_models/tutorial001_an_py310.py hl[9:13,17] *}

**FastAPI извлечёт** данные соответствующие **каждому полю модели** из **query-параметров** запроса и выдаст вам объявленную Pydantic-модель заполненную ими.

## Проверьте Сгенерированную Документацию { #check-the-docs }

Вы можете посмотреть query-параметры в графическом интерфейсе сгенерированной документации по пути `/docs`:

<div class="screenshot">
<img src="/img/tutorial/query-param-models/image01.png">
</div>

## Запретить Дополнительные Query-Параметры { #forbid-extra-query-parameters }

В некоторых случаях (не особо часто встречающихся) вам может понадобиться **ограничить** query-параметры, которые вы хотите получить.

Вы можете сконфигурировать Pydantic-модель так, чтобы запретить (`forbid`) все дополнительные (`extra`) поля.

{* ../../docs_src/query_param_models/tutorial002_an_py310.py hl[10] *}

Если клиент попробует отправить **дополнительные** данные в **query-параметрах**, то в ответ он получит **ошибку**.

Например, если клиент попытается отправить query-параметр `tool` с значением `plumbus`, в виде:

```http
https://example.com/items/?limit=10&tool=plumbus
```

То в ответ он получит **ошибку**, сообщающую ему, что query-параметр `tool` не разрешен:

```json
{
    "detail": [
        {
            "type": "extra_forbidden",
            "loc": ["query", "tool"],
            "msg": "Extra inputs are not permitted",
            "input": "plumbus"
        }
    ]
}
```

## Заключение { #summary }

Вы можете использовать **Pydantic-модели** для объявления **query-параметров** в **FastAPI**. 😎

/// tip | Совет

Спойлер: вы также можете использовать Pydantic-модели, чтобы объявлять cookies и HTTP-заголовки, но об этом вы прочитаете позже. 🤫

///
