; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-- -mattr=+sse2 | FileCheck %s --check-prefixes=SSE
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx  | FileCheck %s --check-prefixes=AVX
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2 | FileCheck %s --check-prefixes=AVX2
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX2-FP
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX2-FCP
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl | FileCheck %s --check-prefixes=AVX512
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX512-FCP
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq | FileCheck %s --check-prefixes=AVX512DQ
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX512DQ-FCP
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512bw | FileCheck %s --check-prefixes=AVX512BW
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512bw,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX512BW-FCP
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq,+avx512bw | FileCheck %s --check-prefixes=AVX512DQ-BW
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq,+avx512bw,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX512DQ-BW-FCP

; These patterns are produced by LoopVectorizer for interleaved stores.

define void @store_i16_stride4_vf2(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %in.vecptr3, ptr %out.vec) nounwind {
; SSE-LABEL: store_i16_stride4_vf2:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa (%rdi), %xmm0
; SSE-NEXT:    movdqa (%rdx), %xmm1
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[1],mem[1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[1],mem[1]
; SSE-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,1,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,2,1,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,6,5,7]
; SSE-NEXT:    movdqa %xmm0, (%r8)
; SSE-NEXT:    retq
;
; AVX-LABEL: store_i16_stride4_vf2:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovdqa (%rdi), %xmm0
; AVX-NEXT:    vmovdqa (%rdx), %xmm1
; AVX-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[1],mem[1]
; AVX-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[1],mem[1]
; AVX-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; AVX-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,1,8,9,2,3,10,11,4,5,12,13,6,7,14,15]
; AVX-NEXT:    vmovdqa %xmm0, (%r8)
; AVX-NEXT:    retq
;
; AVX2-LABEL: store_i16_stride4_vf2:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa (%rdi), %xmm0
; AVX2-NEXT:    vmovdqa (%rdx), %xmm1
; AVX2-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[1],mem[1]
; AVX2-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[1],mem[1]
; AVX2-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; AVX2-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,1,8,9,2,3,10,11,4,5,12,13,6,7,14,15]
; AVX2-NEXT:    vmovdqa %xmm0, (%r8)
; AVX2-NEXT:    retq
;
; AVX2-FP-LABEL: store_i16_stride4_vf2:
; AVX2-FP:       # %bb.0:
; AVX2-FP-NEXT:    vmovdqa (%rdi), %xmm0
; AVX2-FP-NEXT:    vmovdqa (%rdx), %xmm1
; AVX2-FP-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[1],mem[1]
; AVX2-FP-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[1],mem[1]
; AVX2-FP-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; AVX2-FP-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,1,8,9,2,3,10,11,4,5,12,13,6,7,14,15]
; AVX2-FP-NEXT:    vmovdqa %xmm0, (%r8)
; AVX2-FP-NEXT:    retq
;
; AVX2-FCP-LABEL: store_i16_stride4_vf2:
; AVX2-FCP:       # %bb.0:
; AVX2-FCP-NEXT:    vmovdqa (%rdi), %xmm0
; AVX2-FCP-NEXT:    vmovdqa (%rdx), %xmm1
; AVX2-FCP-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[1],mem[1]
; AVX2-FCP-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[1],mem[1]
; AVX2-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,1,8,9,2,3,10,11,4,5,12,13,6,7,14,15]
; AVX2-FCP-NEXT:    vmovdqa %xmm0, (%r8)
; AVX2-FCP-NEXT:    retq
;
; AVX512-LABEL: store_i16_stride4_vf2:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512-NEXT:    vmovdqa (%rdx), %xmm1
; AVX512-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[1],mem[1]
; AVX512-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[1],mem[1]
; AVX512-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; AVX512-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,1,8,9,2,3,10,11,4,5,12,13,6,7,14,15]
; AVX512-NEXT:    vmovdqa %xmm0, (%r8)
; AVX512-NEXT:    retq
;
; AVX512-FCP-LABEL: store_i16_stride4_vf2:
; AVX512-FCP:       # %bb.0:
; AVX512-FCP-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512-FCP-NEXT:    vmovdqa (%rdx), %xmm1
; AVX512-FCP-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[1],mem[1]
; AVX512-FCP-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[1],mem[1]
; AVX512-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,1,8,9,2,3,10,11,4,5,12,13,6,7,14,15]
; AVX512-FCP-NEXT:    vmovdqa %xmm0, (%r8)
; AVX512-FCP-NEXT:    retq
;
; AVX512DQ-LABEL: store_i16_stride4_vf2:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512DQ-NEXT:    vmovdqa (%rdx), %xmm1
; AVX512DQ-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[1],mem[1]
; AVX512DQ-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[1],mem[1]
; AVX512DQ-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,1,8,9,2,3,10,11,4,5,12,13,6,7,14,15]
; AVX512DQ-NEXT:    vmovdqa %xmm0, (%r8)
; AVX512DQ-NEXT:    retq
;
; AVX512DQ-FCP-LABEL: store_i16_stride4_vf2:
; AVX512DQ-FCP:       # %bb.0:
; AVX512DQ-FCP-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512DQ-FCP-NEXT:    vmovdqa (%rdx), %xmm1
; AVX512DQ-FCP-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[1],mem[1]
; AVX512DQ-FCP-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[1],mem[1]
; AVX512DQ-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,1,8,9,2,3,10,11,4,5,12,13,6,7,14,15]
; AVX512DQ-FCP-NEXT:    vmovdqa %xmm0, (%r8)
; AVX512DQ-FCP-NEXT:    retq
;
; AVX512BW-LABEL: store_i16_stride4_vf2:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512BW-NEXT:    vmovdqa (%rdx), %xmm1
; AVX512BW-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[1],mem[1]
; AVX512BW-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[1],mem[1]
; AVX512BW-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,1,8,9,2,3,10,11,4,5,12,13,6,7,14,15]
; AVX512BW-NEXT:    vmovdqa %xmm0, (%r8)
; AVX512BW-NEXT:    retq
;
; AVX512BW-FCP-LABEL: store_i16_stride4_vf2:
; AVX512BW-FCP:       # %bb.0:
; AVX512BW-FCP-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512BW-FCP-NEXT:    vmovdqa (%rdx), %xmm1
; AVX512BW-FCP-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[1],mem[1]
; AVX512BW-FCP-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[1],mem[1]
; AVX512BW-FCP-NEXT:    vpmovsxbw {{.*#+}} xmm2 = [0,2,8,10,1,3,9,11]
; AVX512BW-FCP-NEXT:    vpermi2w %xmm1, %xmm0, %xmm2
; AVX512BW-FCP-NEXT:    vmovdqa %xmm2, (%r8)
; AVX512BW-FCP-NEXT:    retq
;
; AVX512DQ-BW-LABEL: store_i16_stride4_vf2:
; AVX512DQ-BW:       # %bb.0:
; AVX512DQ-BW-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512DQ-BW-NEXT:    vmovdqa (%rdx), %xmm1
; AVX512DQ-BW-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[1],mem[1]
; AVX512DQ-BW-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[1],mem[1]
; AVX512DQ-BW-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,1,8,9,2,3,10,11,4,5,12,13,6,7,14,15]
; AVX512DQ-BW-NEXT:    vmovdqa %xmm0, (%r8)
; AVX512DQ-BW-NEXT:    retq
;
; AVX512DQ-BW-FCP-LABEL: store_i16_stride4_vf2:
; AVX512DQ-BW-FCP:       # %bb.0:
; AVX512DQ-BW-FCP-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqa (%rdx), %xmm1
; AVX512DQ-BW-FCP-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[1],mem[1]
; AVX512DQ-BW-FCP-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[1],mem[1]
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbw {{.*#+}} xmm2 = [0,2,8,10,1,3,9,11]
; AVX512DQ-BW-FCP-NEXT:    vpermi2w %xmm1, %xmm0, %xmm2
; AVX512DQ-BW-FCP-NEXT:    vmovdqa %xmm2, (%r8)
; AVX512DQ-BW-FCP-NEXT:    retq
  %in.vec0 = load <2 x i16>, ptr %in.vecptr0, align 64
  %in.vec1 = load <2 x i16>, ptr %in.vecptr1, align 64
  %in.vec2 = load <2 x i16>, ptr %in.vecptr2, align 64
  %in.vec3 = load <2 x i16>, ptr %in.vecptr3, align 64
  %1 = shufflevector <2 x i16> %in.vec0, <2 x i16> %in.vec1, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = shufflevector <2 x i16> %in.vec2, <2 x i16> %in.vec3, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %3 = shufflevector <4 x i16> %1, <4 x i16> %2, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %interleaved.vec = shufflevector <8 x i16> %3, <8 x i16> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 1, i32 3, i32 5, i32 7>
  store <8 x i16> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i16_stride4_vf4(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %in.vecptr3, ptr %out.vec) nounwind {
; SSE-LABEL: store_i16_stride4_vf4:
; SSE:       # %bb.0:
; SSE-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; SSE-NEXT:    movq {{.*#+}} xmm1 = mem[0],zero
; SSE-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; SSE-NEXT:    movq {{.*#+}} xmm1 = mem[0],zero
; SSE-NEXT:    movq {{.*#+}} xmm2 = mem[0],zero
; SSE-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1],xmm1[2],xmm2[2],xmm1[3],xmm2[3]
; SSE-NEXT:    movdqa %xmm0, %xmm2
; SSE-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm1[0],xmm2[1],xmm1[1]
; SSE-NEXT:    punpckhdq {{.*#+}} xmm0 = xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; SSE-NEXT:    movdqa %xmm0, 16(%r8)
; SSE-NEXT:    movdqa %xmm2, (%r8)
; SSE-NEXT:    retq
;
; AVX-LABEL: store_i16_stride4_vf4:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm1[0],xmm0[0]
; AVX-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX-NEXT:    vmovq {{.*#+}} xmm4 = mem[0],zero
; AVX-NEXT:    vpunpcklqdq {{.*#+}} xmm5 = xmm4[0],xmm3[0]
; AVX-NEXT:    vpunpcklwd {{.*#+}} xmm3 = xmm4[0],xmm3[0],xmm4[1],xmm3[1],xmm4[2],xmm3[2],xmm4[3],xmm3[3]
; AVX-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; AVX-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm0[0],xmm3[0],xmm0[1],xmm3[1]
; AVX-NEXT:    vpshufd {{.*#+}} xmm1 = xmm5[3,1,2,3]
; AVX-NEXT:    vpshuflw {{.*#+}} xmm1 = xmm1[2,0,3,1,4,5,6,7]
; AVX-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[3,1,2,3]
; AVX-NEXT:    vpshuflw {{.*#+}} xmm2 = xmm2[2,0,3,1,4,5,6,7]
; AVX-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm2[0],xmm1[0],xmm2[1],xmm1[1]
; AVX-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX-NEXT:    vmovaps %ymm0, (%r8)
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retq
;
; AVX2-LABEL: store_i16_stride4_vf4:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX2-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX2-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX2-NEXT:    vmovq {{.*#+}} xmm2 = mem[0],zero
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX2-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm2
; AVX2-NEXT:    vinserti128 $1, %xmm0, %ymm1, %ymm0
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm1 = [0,1,8,9,0,1,8,9,2,3,10,11,2,3,10,11,20,21,28,29,20,21,28,29,22,23,30,31,22,23,30,31]
; AVX2-NEXT:    vpshufb %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm1, %ymm2, %ymm1
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6],ymm1[7]
; AVX2-NEXT:    vmovdqa %ymm0, (%r8)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX2-FP-LABEL: store_i16_stride4_vf4:
; AVX2-FP:       # %bb.0:
; AVX2-FP-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX2-FP-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX2-FP-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX2-FP-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX2-FP-NEXT:    vmovq {{.*#+}} xmm2 = mem[0],zero
; AVX2-FP-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX2-FP-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm2
; AVX2-FP-NEXT:    vinserti128 $1, %xmm0, %ymm1, %ymm0
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} ymm1 = [0,1,8,9,0,1,8,9,2,3,10,11,2,3,10,11,20,21,28,29,20,21,28,29,22,23,30,31,22,23,30,31]
; AVX2-FP-NEXT:    vpshufb %ymm1, %ymm0, %ymm0
; AVX2-FP-NEXT:    vpshufb %ymm1, %ymm2, %ymm1
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6],ymm1[7]
; AVX2-FP-NEXT:    vmovdqa %ymm0, (%r8)
; AVX2-FP-NEXT:    vzeroupper
; AVX2-FP-NEXT:    retq
;
; AVX2-FCP-LABEL: store_i16_stride4_vf4:
; AVX2-FCP:       # %bb.0:
; AVX2-FCP-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX2-FCP-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX2-FCP-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX2-FCP-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX2-FCP-NEXT:    vmovq {{.*#+}} xmm2 = mem[0],zero
; AVX2-FCP-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX2-FCP-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX2-FCP-NEXT:    vpmovsxbd {{.*#+}} ymm1 = [0,2,4,6,1,3,5,7]
; AVX2-FCP-NEXT:    vpermd %ymm0, %ymm1, %ymm0
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[0,1,4,5,8,9,12,13,2,3,6,7,10,11,14,15,16,17,20,21,24,25,28,29,18,19,22,23,26,27,30,31]
; AVX2-FCP-NEXT:    vmovdqa %ymm0, (%r8)
; AVX2-FCP-NEXT:    vzeroupper
; AVX2-FCP-NEXT:    retq
;
; AVX512-LABEL: store_i16_stride4_vf4:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX512-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX512-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX512-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX512-NEXT:    vmovq {{.*#+}} xmm2 = mem[0],zero
; AVX512-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX512-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm2
; AVX512-NEXT:    vinserti128 $1, %xmm0, %ymm1, %ymm0
; AVX512-NEXT:    vmovdqa {{.*#+}} ymm1 = [0,1,8,9,0,1,8,9,2,3,10,11,2,3,10,11,20,21,28,29,20,21,28,29,22,23,30,31,22,23,30,31]
; AVX512-NEXT:    vpshufb %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    vpshufb %ymm1, %ymm2, %ymm1
; AVX512-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6],ymm1[7]
; AVX512-NEXT:    vmovdqa %ymm0, (%r8)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
;
; AVX512-FCP-LABEL: store_i16_stride4_vf4:
; AVX512-FCP:       # %bb.0:
; AVX512-FCP-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX512-FCP-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX512-FCP-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX512-FCP-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX512-FCP-NEXT:    vmovq {{.*#+}} xmm2 = mem[0],zero
; AVX512-FCP-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} ymm2 = [0,2,8,10,1,3,9,11]
; AVX512-FCP-NEXT:    vpermi2d %ymm1, %ymm0, %ymm2
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} ymm0 = ymm2[0,1,4,5,8,9,12,13,2,3,6,7,10,11,14,15,16,17,20,21,24,25,28,29,18,19,22,23,26,27,30,31]
; AVX512-FCP-NEXT:    vmovdqa %ymm0, (%r8)
; AVX512-FCP-NEXT:    vzeroupper
; AVX512-FCP-NEXT:    retq
;
; AVX512DQ-LABEL: store_i16_stride4_vf4:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX512DQ-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX512DQ-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX512DQ-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX512DQ-NEXT:    vmovq {{.*#+}} xmm2 = mem[0],zero
; AVX512DQ-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX512DQ-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm2
; AVX512DQ-NEXT:    vinserti128 $1, %xmm0, %ymm1, %ymm0
; AVX512DQ-NEXT:    vmovdqa {{.*#+}} ymm1 = [0,1,8,9,0,1,8,9,2,3,10,11,2,3,10,11,20,21,28,29,20,21,28,29,22,23,30,31,22,23,30,31]
; AVX512DQ-NEXT:    vpshufb %ymm1, %ymm0, %ymm0
; AVX512DQ-NEXT:    vpshufb %ymm1, %ymm2, %ymm1
; AVX512DQ-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6],ymm1[7]
; AVX512DQ-NEXT:    vmovdqa %ymm0, (%r8)
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512DQ-FCP-LABEL: store_i16_stride4_vf4:
; AVX512DQ-FCP:       # %bb.0:
; AVX512DQ-FCP-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX512DQ-FCP-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX512DQ-FCP-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX512DQ-FCP-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX512DQ-FCP-NEXT:    vmovq {{.*#+}} xmm2 = mem[0],zero
; AVX512DQ-FCP-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} ymm2 = [0,2,8,10,1,3,9,11]
; AVX512DQ-FCP-NEXT:    vpermi2d %ymm1, %ymm0, %ymm2
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} ymm0 = ymm2[0,1,4,5,8,9,12,13,2,3,6,7,10,11,14,15,16,17,20,21,24,25,28,29,18,19,22,23,26,27,30,31]
; AVX512DQ-FCP-NEXT:    vmovdqa %ymm0, (%r8)
; AVX512DQ-FCP-NEXT:    vzeroupper
; AVX512DQ-FCP-NEXT:    retq
;
; AVX512BW-LABEL: store_i16_stride4_vf4:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX512BW-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX512BW-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX512BW-NEXT:    vmovq {{.*#+}} xmm2 = mem[0],zero
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX512BW-NEXT:    vpmovsxbw {{.*#+}} ymm2 = [0,4,16,20,1,5,17,21,2,6,18,22,3,7,19,23]
; AVX512BW-NEXT:    vpermi2w %ymm1, %ymm0, %ymm2
; AVX512BW-NEXT:    vmovdqa %ymm2, (%r8)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BW-FCP-LABEL: store_i16_stride4_vf4:
; AVX512BW-FCP:       # %bb.0:
; AVX512BW-FCP-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX512BW-FCP-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX512BW-FCP-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX512BW-FCP-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX512BW-FCP-NEXT:    vmovq {{.*#+}} xmm2 = mem[0],zero
; AVX512BW-FCP-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX512BW-FCP-NEXT:    vpmovsxbw {{.*#+}} ymm2 = [0,4,16,20,1,5,17,21,2,6,18,22,3,7,19,23]
; AVX512BW-FCP-NEXT:    vpermi2w %ymm1, %ymm0, %ymm2
; AVX512BW-FCP-NEXT:    vmovdqa %ymm2, (%r8)
; AVX512BW-FCP-NEXT:    vzeroupper
; AVX512BW-FCP-NEXT:    retq
;
; AVX512DQ-BW-LABEL: store_i16_stride4_vf4:
; AVX512DQ-BW:       # %bb.0:
; AVX512DQ-BW-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX512DQ-BW-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX512DQ-BW-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX512DQ-BW-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX512DQ-BW-NEXT:    vmovq {{.*#+}} xmm2 = mem[0],zero
; AVX512DQ-BW-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX512DQ-BW-NEXT:    vpmovsxbw {{.*#+}} ymm2 = [0,4,16,20,1,5,17,21,2,6,18,22,3,7,19,23]
; AVX512DQ-BW-NEXT:    vpermi2w %ymm1, %ymm0, %ymm2
; AVX512DQ-BW-NEXT:    vmovdqa %ymm2, (%r8)
; AVX512DQ-BW-NEXT:    vzeroupper
; AVX512DQ-BW-NEXT:    retq
;
; AVX512DQ-BW-FCP-LABEL: store_i16_stride4_vf4:
; AVX512DQ-BW-FCP:       # %bb.0:
; AVX512DQ-BW-FCP-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX512DQ-BW-FCP-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX512DQ-BW-FCP-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX512DQ-BW-FCP-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX512DQ-BW-FCP-NEXT:    vmovq {{.*#+}} xmm2 = mem[0],zero
; AVX512DQ-BW-FCP-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbw {{.*#+}} ymm2 = [0,4,16,20,1,5,17,21,2,6,18,22,3,7,19,23]
; AVX512DQ-BW-FCP-NEXT:    vpermi2w %ymm1, %ymm0, %ymm2
; AVX512DQ-BW-FCP-NEXT:    vmovdqa %ymm2, (%r8)
; AVX512DQ-BW-FCP-NEXT:    vzeroupper
; AVX512DQ-BW-FCP-NEXT:    retq
  %in.vec0 = load <4 x i16>, ptr %in.vecptr0, align 64
  %in.vec1 = load <4 x i16>, ptr %in.vecptr1, align 64
  %in.vec2 = load <4 x i16>, ptr %in.vecptr2, align 64
  %in.vec3 = load <4 x i16>, ptr %in.vecptr3, align 64
  %1 = shufflevector <4 x i16> %in.vec0, <4 x i16> %in.vec1, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %2 = shufflevector <4 x i16> %in.vec2, <4 x i16> %in.vec3, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %3 = shufflevector <8 x i16> %1, <8 x i16> %2, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %interleaved.vec = shufflevector <16 x i16> %3, <16 x i16> poison, <16 x i32> <i32 0, i32 4, i32 8, i32 12, i32 1, i32 5, i32 9, i32 13, i32 2, i32 6, i32 10, i32 14, i32 3, i32 7, i32 11, i32 15>
  store <16 x i16> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i16_stride4_vf8(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %in.vecptr3, ptr %out.vec) nounwind {
; SSE-LABEL: store_i16_stride4_vf8:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa (%rdi), %xmm0
; SSE-NEXT:    movdqa (%rsi), %xmm1
; SSE-NEXT:    movdqa (%rdx), %xmm2
; SSE-NEXT:    movdqa (%rcx), %xmm3
; SSE-NEXT:    movdqa %xmm2, %xmm4
; SSE-NEXT:    punpcklwd {{.*#+}} xmm4 = xmm4[0],xmm3[0],xmm4[1],xmm3[1],xmm4[2],xmm3[2],xmm4[3],xmm3[3]
; SSE-NEXT:    movdqa %xmm0, %xmm5
; SSE-NEXT:    punpcklwd {{.*#+}} xmm5 = xmm5[0],xmm1[0],xmm5[1],xmm1[1],xmm5[2],xmm1[2],xmm5[3],xmm1[3]
; SSE-NEXT:    movdqa %xmm5, %xmm6
; SSE-NEXT:    punpckldq {{.*#+}} xmm6 = xmm6[0],xmm4[0],xmm6[1],xmm4[1]
; SSE-NEXT:    punpckhdq {{.*#+}} xmm5 = xmm5[2],xmm4[2],xmm5[3],xmm4[3]
; SSE-NEXT:    punpckhwd {{.*#+}} xmm2 = xmm2[4],xmm3[4],xmm2[5],xmm3[5],xmm2[6],xmm3[6],xmm2[7],xmm3[7]
; SSE-NEXT:    punpckhwd {{.*#+}} xmm0 = xmm0[4],xmm1[4],xmm0[5],xmm1[5],xmm0[6],xmm1[6],xmm0[7],xmm1[7]
; SSE-NEXT:    movdqa %xmm0, %xmm1
; SSE-NEXT:    punpckhdq {{.*#+}} xmm1 = xmm1[2],xmm2[2],xmm1[3],xmm2[3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1]
; SSE-NEXT:    movdqa %xmm0, 32(%r8)
; SSE-NEXT:    movdqa %xmm1, 48(%r8)
; SSE-NEXT:    movdqa %xmm5, 16(%r8)
; SSE-NEXT:    movdqa %xmm6, (%r8)
; SSE-NEXT:    retq
;
; AVX-LABEL: store_i16_stride4_vf8:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovdqa (%rdi), %xmm0
; AVX-NEXT:    vmovdqa (%rsi), %xmm1
; AVX-NEXT:    vmovdqa (%rdx), %xmm2
; AVX-NEXT:    vmovdqa (%rcx), %xmm3
; AVX-NEXT:    vpunpcklwd {{.*#+}} xmm4 = xmm2[0],xmm3[0],xmm2[1],xmm3[1],xmm2[2],xmm3[2],xmm2[3],xmm3[3]
; AVX-NEXT:    vpunpcklwd {{.*#+}} xmm5 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; AVX-NEXT:    vpunpckhdq {{.*#+}} xmm6 = xmm5[2],xmm4[2],xmm5[3],xmm4[3]
; AVX-NEXT:    vpunpckldq {{.*#+}} xmm4 = xmm5[0],xmm4[0],xmm5[1],xmm4[1]
; AVX-NEXT:    vinsertf128 $1, %xmm6, %ymm4, %ymm4
; AVX-NEXT:    vpunpckhwd {{.*#+}} xmm2 = xmm2[4],xmm3[4],xmm2[5],xmm3[5],xmm2[6],xmm3[6],xmm2[7],xmm3[7]
; AVX-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm0[4],xmm1[4],xmm0[5],xmm1[5],xmm0[6],xmm1[6],xmm0[7],xmm1[7]
; AVX-NEXT:    vpunpckhdq {{.*#+}} xmm1 = xmm0[2],xmm2[2],xmm0[3],xmm2[3]
; AVX-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1]
; AVX-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX-NEXT:    vmovaps %ymm0, 32(%r8)
; AVX-NEXT:    vmovaps %ymm4, (%r8)
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retq
;
; AVX2-LABEL: store_i16_stride4_vf8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa (%rdi), %xmm0
; AVX2-NEXT:    vmovdqa (%rdx), %xmm1
; AVX2-NEXT:    vinserti128 $1, (%rsi), %ymm0, %ymm0
; AVX2-NEXT:    vinserti128 $1, (%rcx), %ymm1, %ymm1
; AVX2-NEXT:    vpermq {{.*#+}} ymm2 = ymm1[0,2,0,2]
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm3 = [u,u,u,u,0,1,8,9,u,u,u,u,2,3,10,11,u,u,u,u,4,5,12,13,u,u,u,u,6,7,14,15]
; AVX2-NEXT:    vpshufb %ymm3, %ymm2, %ymm2
; AVX2-NEXT:    vpermq {{.*#+}} ymm4 = ymm0[0,2,0,2]
; AVX2-NEXT:    vpmovsxdq {{.*#+}} ymm5 = [151519488,185205506,218891524,252577542]
; AVX2-NEXT:    vpshufb %ymm5, %ymm4, %ymm4
; AVX2-NEXT:    vpblendd {{.*#+}} ymm2 = ymm4[0],ymm2[1],ymm4[2],ymm2[3],ymm4[4],ymm2[5],ymm4[6],ymm2[7]
; AVX2-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[1,3,1,3]
; AVX2-NEXT:    vpshufb %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[1,3,1,3]
; AVX2-NEXT:    vpshufb %ymm5, %ymm0, %ymm0
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2],ymm1[3],ymm0[4],ymm1[5],ymm0[6],ymm1[7]
; AVX2-NEXT:    vmovdqa %ymm0, 32(%r8)
; AVX2-NEXT:    vmovdqa %ymm2, (%r8)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX2-FP-LABEL: store_i16_stride4_vf8:
; AVX2-FP:       # %bb.0:
; AVX2-FP-NEXT:    vmovdqa (%rdi), %xmm0
; AVX2-FP-NEXT:    vmovdqa (%rdx), %xmm1
; AVX2-FP-NEXT:    vinserti128 $1, (%rsi), %ymm0, %ymm0
; AVX2-FP-NEXT:    vinserti128 $1, (%rcx), %ymm1, %ymm1
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm2 = ymm1[0,2,0,2]
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} ymm3 = [u,u,u,u,0,1,8,9,u,u,u,u,2,3,10,11,u,u,u,u,4,5,12,13,u,u,u,u,6,7,14,15]
; AVX2-FP-NEXT:    vpshufb %ymm3, %ymm2, %ymm2
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm4 = ymm0[0,2,0,2]
; AVX2-FP-NEXT:    vpmovsxdq {{.*#+}} ymm5 = [151519488,185205506,218891524,252577542]
; AVX2-FP-NEXT:    vpshufb %ymm5, %ymm4, %ymm4
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm2 = ymm4[0],ymm2[1],ymm4[2],ymm2[3],ymm4[4],ymm2[5],ymm4[6],ymm2[7]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[1,3,1,3]
; AVX2-FP-NEXT:    vpshufb %ymm3, %ymm1, %ymm1
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[1,3,1,3]
; AVX2-FP-NEXT:    vpshufb %ymm5, %ymm0, %ymm0
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2],ymm1[3],ymm0[4],ymm1[5],ymm0[6],ymm1[7]
; AVX2-FP-NEXT:    vmovdqa %ymm0, 32(%r8)
; AVX2-FP-NEXT:    vmovdqa %ymm2, (%r8)
; AVX2-FP-NEXT:    vzeroupper
; AVX2-FP-NEXT:    retq
;
; AVX2-FCP-LABEL: store_i16_stride4_vf8:
; AVX2-FCP:       # %bb.0:
; AVX2-FCP-NEXT:    vmovdqa (%rdi), %xmm0
; AVX2-FCP-NEXT:    vmovdqa (%rdx), %xmm1
; AVX2-FCP-NEXT:    vinserti128 $1, (%rsi), %ymm0, %ymm0
; AVX2-FCP-NEXT:    vinserti128 $1, (%rcx), %ymm1, %ymm1
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm2 = ymm1[0,2,0,2]
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} ymm3 = [u,u,u,u,0,1,8,9,u,u,u,u,2,3,10,11,u,u,u,u,4,5,12,13,u,u,u,u,6,7,14,15]
; AVX2-FCP-NEXT:    vpshufb %ymm3, %ymm2, %ymm2
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm4 = ymm0[0,2,0,2]
; AVX2-FCP-NEXT:    vpmovsxdq {{.*#+}} ymm5 = [151519488,185205506,218891524,252577542]
; AVX2-FCP-NEXT:    vpshufb %ymm5, %ymm4, %ymm4
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm2 = ymm4[0],ymm2[1],ymm4[2],ymm2[3],ymm4[4],ymm2[5],ymm4[6],ymm2[7]
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[1,3,1,3]
; AVX2-FCP-NEXT:    vpshufb %ymm3, %ymm1, %ymm1
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[1,3,1,3]
; AVX2-FCP-NEXT:    vpshufb %ymm5, %ymm0, %ymm0
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2],ymm1[3],ymm0[4],ymm1[5],ymm0[6],ymm1[7]
; AVX2-FCP-NEXT:    vmovdqa %ymm0, 32(%r8)
; AVX2-FCP-NEXT:    vmovdqa %ymm2, (%r8)
; AVX2-FCP-NEXT:    vzeroupper
; AVX2-FCP-NEXT:    retq
;
; AVX512-LABEL: store_i16_stride4_vf8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512-NEXT:    vmovdqa (%rdx), %xmm1
; AVX512-NEXT:    vinserti128 $1, (%rcx), %ymm1, %ymm1
; AVX512-NEXT:    vpermq {{.*#+}} ymm2 = ymm1[1,3,1,3]
; AVX512-NEXT:    vmovdqa {{.*#+}} ymm3 = [u,u,u,u,0,1,8,9,u,u,u,u,2,3,10,11,u,u,u,u,4,5,12,13,u,u,u,u,6,7,14,15]
; AVX512-NEXT:    vpshufb %ymm3, %ymm2, %ymm2
; AVX512-NEXT:    vinserti128 $1, (%rsi), %ymm0, %ymm0
; AVX512-NEXT:    vpermq {{.*#+}} ymm4 = ymm0[1,3,1,3]
; AVX512-NEXT:    vpmovsxdq {{.*#+}} ymm5 = [151519488,185205506,218891524,252577542]
; AVX512-NEXT:    vpshufb %ymm5, %ymm4, %ymm4
; AVX512-NEXT:    vpblendd {{.*#+}} ymm2 = ymm4[0],ymm2[1],ymm4[2],ymm2[3],ymm4[4],ymm2[5],ymm4[6],ymm2[7]
; AVX512-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,2,0,2]
; AVX512-NEXT:    vpshufb %ymm3, %ymm1, %ymm1
; AVX512-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,0,2]
; AVX512-NEXT:    vpshufb %ymm5, %ymm0, %ymm0
; AVX512-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2],ymm1[3],ymm0[4],ymm1[5],ymm0[6],ymm1[7]
; AVX512-NEXT:    vinserti64x4 $1, %ymm2, %zmm0, %zmm0
; AVX512-NEXT:    vmovdqa64 %zmm0, (%r8)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
;
; AVX512-FCP-LABEL: store_i16_stride4_vf8:
; AVX512-FCP:       # %bb.0:
; AVX512-FCP-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512-FCP-NEXT:    vmovdqa (%rdx), %xmm1
; AVX512-FCP-NEXT:    vinserti128 $1, (%rcx), %ymm1, %ymm1
; AVX512-FCP-NEXT:    vpermq {{.*#+}} ymm2 = ymm1[1,3,1,3]
; AVX512-FCP-NEXT:    vmovdqa {{.*#+}} ymm3 = [u,u,u,u,0,1,8,9,u,u,u,u,2,3,10,11,u,u,u,u,4,5,12,13,u,u,u,u,6,7,14,15]
; AVX512-FCP-NEXT:    vpshufb %ymm3, %ymm2, %ymm2
; AVX512-FCP-NEXT:    vinserti128 $1, (%rsi), %ymm0, %ymm0
; AVX512-FCP-NEXT:    vpermq {{.*#+}} ymm4 = ymm0[1,3,1,3]
; AVX512-FCP-NEXT:    vpmovsxdq {{.*#+}} ymm5 = [151519488,185205506,218891524,252577542]
; AVX512-FCP-NEXT:    vpshufb %ymm5, %ymm4, %ymm4
; AVX512-FCP-NEXT:    vpblendd {{.*#+}} ymm2 = ymm4[0],ymm2[1],ymm4[2],ymm2[3],ymm4[4],ymm2[5],ymm4[6],ymm2[7]
; AVX512-FCP-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,2,0,2]
; AVX512-FCP-NEXT:    vpshufb %ymm3, %ymm1, %ymm1
; AVX512-FCP-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,0,2]
; AVX512-FCP-NEXT:    vpshufb %ymm5, %ymm0, %ymm0
; AVX512-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2],ymm1[3],ymm0[4],ymm1[5],ymm0[6],ymm1[7]
; AVX512-FCP-NEXT:    vinserti64x4 $1, %ymm2, %zmm0, %zmm0
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, (%r8)
; AVX512-FCP-NEXT:    vzeroupper
; AVX512-FCP-NEXT:    retq
;
; AVX512DQ-LABEL: store_i16_stride4_vf8:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512DQ-NEXT:    vmovdqa (%rdx), %xmm1
; AVX512DQ-NEXT:    vinserti128 $1, (%rcx), %ymm1, %ymm1
; AVX512DQ-NEXT:    vpermq {{.*#+}} ymm2 = ymm1[1,3,1,3]
; AVX512DQ-NEXT:    vmovdqa {{.*#+}} ymm3 = [u,u,u,u,0,1,8,9,u,u,u,u,2,3,10,11,u,u,u,u,4,5,12,13,u,u,u,u,6,7,14,15]
; AVX512DQ-NEXT:    vpshufb %ymm3, %ymm2, %ymm2
; AVX512DQ-NEXT:    vinserti128 $1, (%rsi), %ymm0, %ymm0
; AVX512DQ-NEXT:    vpermq {{.*#+}} ymm4 = ymm0[1,3,1,3]
; AVX512DQ-NEXT:    vpmovsxdq {{.*#+}} ymm5 = [151519488,185205506,218891524,252577542]
; AVX512DQ-NEXT:    vpshufb %ymm5, %ymm4, %ymm4
; AVX512DQ-NEXT:    vpblendd {{.*#+}} ymm2 = ymm4[0],ymm2[1],ymm4[2],ymm2[3],ymm4[4],ymm2[5],ymm4[6],ymm2[7]
; AVX512DQ-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,2,0,2]
; AVX512DQ-NEXT:    vpshufb %ymm3, %ymm1, %ymm1
; AVX512DQ-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,0,2]
; AVX512DQ-NEXT:    vpshufb %ymm5, %ymm0, %ymm0
; AVX512DQ-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2],ymm1[3],ymm0[4],ymm1[5],ymm0[6],ymm1[7]
; AVX512DQ-NEXT:    vinserti64x4 $1, %ymm2, %zmm0, %zmm0
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, (%r8)
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512DQ-FCP-LABEL: store_i16_stride4_vf8:
; AVX512DQ-FCP:       # %bb.0:
; AVX512DQ-FCP-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512DQ-FCP-NEXT:    vmovdqa (%rdx), %xmm1
; AVX512DQ-FCP-NEXT:    vinserti128 $1, (%rcx), %ymm1, %ymm1
; AVX512DQ-FCP-NEXT:    vpermq {{.*#+}} ymm2 = ymm1[1,3,1,3]
; AVX512DQ-FCP-NEXT:    vmovdqa {{.*#+}} ymm3 = [u,u,u,u,0,1,8,9,u,u,u,u,2,3,10,11,u,u,u,u,4,5,12,13,u,u,u,u,6,7,14,15]
; AVX512DQ-FCP-NEXT:    vpshufb %ymm3, %ymm2, %ymm2
; AVX512DQ-FCP-NEXT:    vinserti128 $1, (%rsi), %ymm0, %ymm0
; AVX512DQ-FCP-NEXT:    vpermq {{.*#+}} ymm4 = ymm0[1,3,1,3]
; AVX512DQ-FCP-NEXT:    vpmovsxdq {{.*#+}} ymm5 = [151519488,185205506,218891524,252577542]
; AVX512DQ-FCP-NEXT:    vpshufb %ymm5, %ymm4, %ymm4
; AVX512DQ-FCP-NEXT:    vpblendd {{.*#+}} ymm2 = ymm4[0],ymm2[1],ymm4[2],ymm2[3],ymm4[4],ymm2[5],ymm4[6],ymm2[7]
; AVX512DQ-FCP-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,2,0,2]
; AVX512DQ-FCP-NEXT:    vpshufb %ymm3, %ymm1, %ymm1
; AVX512DQ-FCP-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,0,2]
; AVX512DQ-FCP-NEXT:    vpshufb %ymm5, %ymm0, %ymm0
; AVX512DQ-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2],ymm1[3],ymm0[4],ymm1[5],ymm0[6],ymm1[7]
; AVX512DQ-FCP-NEXT:    vinserti64x4 $1, %ymm2, %zmm0, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, (%r8)
; AVX512DQ-FCP-NEXT:    vzeroupper
; AVX512DQ-FCP-NEXT:    retq
;
; AVX512BW-LABEL: store_i16_stride4_vf8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512BW-NEXT:    vmovdqa (%rdx), %xmm1
; AVX512BW-NEXT:    vinserti128 $1, (%rcx), %ymm1, %ymm1
; AVX512BW-NEXT:    vinserti128 $1, (%rsi), %ymm0, %ymm0
; AVX512BW-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpmovsxbw {{.*#+}} zmm1 = [0,8,16,24,1,9,17,25,2,10,18,26,3,11,19,27,4,12,20,28,5,13,21,29,6,14,22,30,7,15,23,31]
; AVX512BW-NEXT:    vpermw %zmm0, %zmm1, %zmm0
; AVX512BW-NEXT:    vmovdqa64 %zmm0, (%r8)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BW-FCP-LABEL: store_i16_stride4_vf8:
; AVX512BW-FCP:       # %bb.0:
; AVX512BW-FCP-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512BW-FCP-NEXT:    vmovdqa (%rdx), %xmm1
; AVX512BW-FCP-NEXT:    vinserti128 $1, (%rcx), %ymm1, %ymm1
; AVX512BW-FCP-NEXT:    vinserti128 $1, (%rsi), %ymm0, %ymm0
; AVX512BW-FCP-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512BW-FCP-NEXT:    vpmovsxbw {{.*#+}} zmm1 = [0,8,16,24,1,9,17,25,2,10,18,26,3,11,19,27,4,12,20,28,5,13,21,29,6,14,22,30,7,15,23,31]
; AVX512BW-FCP-NEXT:    vpermw %zmm0, %zmm1, %zmm0
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, (%r8)
; AVX512BW-FCP-NEXT:    vzeroupper
; AVX512BW-FCP-NEXT:    retq
;
; AVX512DQ-BW-LABEL: store_i16_stride4_vf8:
; AVX512DQ-BW:       # %bb.0:
; AVX512DQ-BW-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512DQ-BW-NEXT:    vmovdqa (%rdx), %xmm1
; AVX512DQ-BW-NEXT:    vinserti128 $1, (%rcx), %ymm1, %ymm1
; AVX512DQ-BW-NEXT:    vinserti128 $1, (%rsi), %ymm0, %ymm0
; AVX512DQ-BW-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512DQ-BW-NEXT:    vpmovsxbw {{.*#+}} zmm1 = [0,8,16,24,1,9,17,25,2,10,18,26,3,11,19,27,4,12,20,28,5,13,21,29,6,14,22,30,7,15,23,31]
; AVX512DQ-BW-NEXT:    vpermw %zmm0, %zmm1, %zmm0
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, (%r8)
; AVX512DQ-BW-NEXT:    vzeroupper
; AVX512DQ-BW-NEXT:    retq
;
; AVX512DQ-BW-FCP-LABEL: store_i16_stride4_vf8:
; AVX512DQ-BW-FCP:       # %bb.0:
; AVX512DQ-BW-FCP-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqa (%rdx), %xmm1
; AVX512DQ-BW-FCP-NEXT:    vinserti128 $1, (%rcx), %ymm1, %ymm1
; AVX512DQ-BW-FCP-NEXT:    vinserti128 $1, (%rsi), %ymm0, %ymm0
; AVX512DQ-BW-FCP-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbw {{.*#+}} zmm1 = [0,8,16,24,1,9,17,25,2,10,18,26,3,11,19,27,4,12,20,28,5,13,21,29,6,14,22,30,7,15,23,31]
; AVX512DQ-BW-FCP-NEXT:    vpermw %zmm0, %zmm1, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, (%r8)
; AVX512DQ-BW-FCP-NEXT:    vzeroupper
; AVX512DQ-BW-FCP-NEXT:    retq
  %in.vec0 = load <8 x i16>, ptr %in.vecptr0, align 64
  %in.vec1 = load <8 x i16>, ptr %in.vecptr1, align 64
  %in.vec2 = load <8 x i16>, ptr %in.vecptr2, align 64
  %in.vec3 = load <8 x i16>, ptr %in.vecptr3, align 64
  %1 = shufflevector <8 x i16> %in.vec0, <8 x i16> %in.vec1, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %2 = shufflevector <8 x i16> %in.vec2, <8 x i16> %in.vec3, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %3 = shufflevector <16 x i16> %1, <16 x i16> %2, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %interleaved.vec = shufflevector <32 x i16> %3, <32 x i16> poison, <32 x i32> <i32 0, i32 8, i32 16, i32 24, i32 1, i32 9, i32 17, i32 25, i32 2, i32 10, i32 18, i32 26, i32 3, i32 11, i32 19, i32 27, i32 4, i32 12, i32 20, i32 28, i32 5, i32 13, i32 21, i32 29, i32 6, i32 14, i32 22, i32 30, i32 7, i32 15, i32 23, i32 31>
  store <32 x i16> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i16_stride4_vf16(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %in.vecptr3, ptr %out.vec) nounwind {
; SSE-LABEL: store_i16_stride4_vf16:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa (%rdi), %xmm0
; SSE-NEXT:    movdqa 16(%rdi), %xmm1
; SSE-NEXT:    movdqa (%rsi), %xmm5
; SSE-NEXT:    movdqa 16(%rsi), %xmm6
; SSE-NEXT:    movdqa (%rdx), %xmm7
; SSE-NEXT:    movdqa 16(%rdx), %xmm4
; SSE-NEXT:    movdqa (%rcx), %xmm8
; SSE-NEXT:    movdqa 16(%rcx), %xmm9
; SSE-NEXT:    movdqa %xmm7, %xmm10
; SSE-NEXT:    punpcklwd {{.*#+}} xmm10 = xmm10[0],xmm8[0],xmm10[1],xmm8[1],xmm10[2],xmm8[2],xmm10[3],xmm8[3]
; SSE-NEXT:    movdqa %xmm0, %xmm2
; SSE-NEXT:    punpcklwd {{.*#+}} xmm2 = xmm2[0],xmm5[0],xmm2[1],xmm5[1],xmm2[2],xmm5[2],xmm2[3],xmm5[3]
; SSE-NEXT:    movdqa %xmm2, %xmm3
; SSE-NEXT:    punpckhdq {{.*#+}} xmm3 = xmm3[2],xmm10[2],xmm3[3],xmm10[3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm10[0],xmm2[1],xmm10[1]
; SSE-NEXT:    punpckhwd {{.*#+}} xmm7 = xmm7[4],xmm8[4],xmm7[5],xmm8[5],xmm7[6],xmm8[6],xmm7[7],xmm8[7]
; SSE-NEXT:    punpckhwd {{.*#+}} xmm0 = xmm0[4],xmm5[4],xmm0[5],xmm5[5],xmm0[6],xmm5[6],xmm0[7],xmm5[7]
; SSE-NEXT:    movdqa %xmm0, %xmm5
; SSE-NEXT:    punpckhdq {{.*#+}} xmm5 = xmm5[2],xmm7[2],xmm5[3],xmm7[3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm7[0],xmm0[1],xmm7[1]
; SSE-NEXT:    movdqa %xmm4, %xmm7
; SSE-NEXT:    punpcklwd {{.*#+}} xmm7 = xmm7[0],xmm9[0],xmm7[1],xmm9[1],xmm7[2],xmm9[2],xmm7[3],xmm9[3]
; SSE-NEXT:    movdqa %xmm1, %xmm8
; SSE-NEXT:    punpcklwd {{.*#+}} xmm8 = xmm8[0],xmm6[0],xmm8[1],xmm6[1],xmm8[2],xmm6[2],xmm8[3],xmm6[3]
; SSE-NEXT:    movdqa %xmm8, %xmm10
; SSE-NEXT:    punpckhdq {{.*#+}} xmm10 = xmm10[2],xmm7[2],xmm10[3],xmm7[3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm8 = xmm8[0],xmm7[0],xmm8[1],xmm7[1]
; SSE-NEXT:    punpckhwd {{.*#+}} xmm4 = xmm4[4],xmm9[4],xmm4[5],xmm9[5],xmm4[6],xmm9[6],xmm4[7],xmm9[7]
; SSE-NEXT:    punpckhwd {{.*#+}} xmm1 = xmm1[4],xmm6[4],xmm1[5],xmm6[5],xmm1[6],xmm6[6],xmm1[7],xmm6[7]
; SSE-NEXT:    movdqa %xmm1, %xmm6
; SSE-NEXT:    punpckhdq {{.*#+}} xmm6 = xmm6[2],xmm4[2],xmm6[3],xmm4[3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm4[0],xmm1[1],xmm4[1]
; SSE-NEXT:    movdqa %xmm1, 96(%r8)
; SSE-NEXT:    movdqa %xmm6, 112(%r8)
; SSE-NEXT:    movdqa %xmm8, 64(%r8)
; SSE-NEXT:    movdqa %xmm10, 80(%r8)
; SSE-NEXT:    movdqa %xmm0, 32(%r8)
; SSE-NEXT:    movdqa %xmm5, 48(%r8)
; SSE-NEXT:    movdqa %xmm2, (%r8)
; SSE-NEXT:    movdqa %xmm3, 16(%r8)
; SSE-NEXT:    retq
;
; AVX-LABEL: store_i16_stride4_vf16:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovdqa (%rcx), %xmm5
; AVX-NEXT:    vmovdqa 16(%rcx), %xmm0
; AVX-NEXT:    vmovdqa (%rdx), %xmm6
; AVX-NEXT:    vmovdqa 16(%rdx), %xmm1
; AVX-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm6[0],xmm5[0],xmm6[1],xmm5[1],xmm6[2],xmm5[2],xmm6[3],xmm5[3]
; AVX-NEXT:    vpshufd {{.*#+}} xmm3 = xmm2[0,0,1,1]
; AVX-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[2,2,3,3]
; AVX-NEXT:    vinsertf128 $1, %xmm2, %ymm3, %ymm2
; AVX-NEXT:    vmovdqa (%rsi), %xmm7
; AVX-NEXT:    vmovdqa 16(%rsi), %xmm3
; AVX-NEXT:    vmovdqa (%rdi), %xmm8
; AVX-NEXT:    vmovdqa 16(%rdi), %xmm4
; AVX-NEXT:    vpunpcklwd {{.*#+}} xmm9 = xmm8[0],xmm7[0],xmm8[1],xmm7[1],xmm8[2],xmm7[2],xmm8[3],xmm7[3]
; AVX-NEXT:    vpmovzxdq {{.*#+}} xmm10 = xmm9[0],zero,xmm9[1],zero
; AVX-NEXT:    vpshufd {{.*#+}} xmm9 = xmm9[2,2,3,3]
; AVX-NEXT:    vinsertf128 $1, %xmm9, %ymm10, %ymm9
; AVX-NEXT:    vblendps {{.*#+}} ymm2 = ymm9[0],ymm2[1],ymm9[2],ymm2[3],ymm9[4],ymm2[5],ymm9[6],ymm2[7]
; AVX-NEXT:    vpunpckhwd {{.*#+}} xmm5 = xmm6[4],xmm5[4],xmm6[5],xmm5[5],xmm6[6],xmm5[6],xmm6[7],xmm5[7]
; AVX-NEXT:    vpshufd {{.*#+}} xmm6 = xmm5[0,0,1,1]
; AVX-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[2,2,3,3]
; AVX-NEXT:    vinsertf128 $1, %xmm5, %ymm6, %ymm5
; AVX-NEXT:    vpunpckhwd {{.*#+}} xmm6 = xmm8[4],xmm7[4],xmm8[5],xmm7[5],xmm8[6],xmm7[6],xmm8[7],xmm7[7]
; AVX-NEXT:    vpmovzxdq {{.*#+}} xmm7 = xmm6[0],zero,xmm6[1],zero
; AVX-NEXT:    vpshufd {{.*#+}} xmm6 = xmm6[2,2,3,3]
; AVX-NEXT:    vinsertf128 $1, %xmm6, %ymm7, %ymm6
; AVX-NEXT:    vblendps {{.*#+}} ymm5 = ymm6[0],ymm5[1],ymm6[2],ymm5[3],ymm6[4],ymm5[5],ymm6[6],ymm5[7]
; AVX-NEXT:    vpunpckhwd {{.*#+}} xmm6 = xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; AVX-NEXT:    vpshufd {{.*#+}} xmm7 = xmm6[0,0,1,1]
; AVX-NEXT:    vpshufd {{.*#+}} xmm6 = xmm6[2,2,3,3]
; AVX-NEXT:    vinsertf128 $1, %xmm6, %ymm7, %ymm6
; AVX-NEXT:    vpunpckhwd {{.*#+}} xmm7 = xmm4[4],xmm3[4],xmm4[5],xmm3[5],xmm4[6],xmm3[6],xmm4[7],xmm3[7]
; AVX-NEXT:    vpmovzxdq {{.*#+}} xmm8 = xmm7[0],zero,xmm7[1],zero
; AVX-NEXT:    vpshufd {{.*#+}} xmm7 = xmm7[2,2,3,3]
; AVX-NEXT:    vinsertf128 $1, %xmm7, %ymm8, %ymm7
; AVX-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0],ymm6[1],ymm7[2],ymm6[3],ymm7[4],ymm6[5],ymm7[6],ymm6[7]
; AVX-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; AVX-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[0,0,1,1]
; AVX-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm4[0],xmm3[0],xmm4[1],xmm3[1],xmm4[2],xmm3[2],xmm4[3],xmm3[3]
; AVX-NEXT:    vpmovzxdq {{.*#+}} xmm3 = xmm1[0],zero,xmm1[1],zero
; AVX-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,2,3,3]
; AVX-NEXT:    vinsertf128 $1, %xmm1, %ymm3, %ymm1
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2],ymm0[3],ymm1[4],ymm0[5],ymm1[6],ymm0[7]
; AVX-NEXT:    vmovaps %ymm0, 64(%r8)
; AVX-NEXT:    vmovaps %ymm6, 96(%r8)
; AVX-NEXT:    vmovaps %ymm5, 32(%r8)
; AVX-NEXT:    vmovaps %ymm2, (%r8)
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retq
;
; AVX2-LABEL: store_i16_stride4_vf16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa (%rcx), %xmm5
; AVX2-NEXT:    vmovdqa 16(%rcx), %xmm0
; AVX2-NEXT:    vmovdqa (%rdx), %xmm6
; AVX2-NEXT:    vmovdqa 16(%rdx), %xmm1
; AVX2-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm6[0],xmm5[0],xmm6[1],xmm5[1],xmm6[2],xmm5[2],xmm6[3],xmm5[3]
; AVX2-NEXT:    vpshufd {{.*#+}} xmm3 = xmm2[0,0,1,1]
; AVX2-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[2,2,3,3]
; AVX2-NEXT:    vinserti128 $1, %xmm2, %ymm3, %ymm2
; AVX2-NEXT:    vmovdqa (%rsi), %xmm7
; AVX2-NEXT:    vmovdqa 16(%rsi), %xmm3
; AVX2-NEXT:    vmovdqa (%rdi), %xmm8
; AVX2-NEXT:    vmovdqa 16(%rdi), %xmm4
; AVX2-NEXT:    vpunpcklwd {{.*#+}} xmm9 = xmm8[0],xmm7[0],xmm8[1],xmm7[1],xmm8[2],xmm7[2],xmm8[3],xmm7[3]
; AVX2-NEXT:    vpmovzxdq {{.*#+}} xmm10 = xmm9[0],zero,xmm9[1],zero
; AVX2-NEXT:    vpshufd {{.*#+}} xmm9 = xmm9[2,2,3,3]
; AVX2-NEXT:    vinserti128 $1, %xmm9, %ymm10, %ymm9
; AVX2-NEXT:    vpblendd {{.*#+}} ymm2 = ymm9[0],ymm2[1],ymm9[2],ymm2[3],ymm9[4],ymm2[5],ymm9[6],ymm2[7]
; AVX2-NEXT:    vpunpckhwd {{.*#+}} xmm5 = xmm6[4],xmm5[4],xmm6[5],xmm5[5],xmm6[6],xmm5[6],xmm6[7],xmm5[7]
; AVX2-NEXT:    vpshufd {{.*#+}} xmm6 = xmm5[0,0,1,1]
; AVX2-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[2,2,3,3]
; AVX2-NEXT:    vinserti128 $1, %xmm5, %ymm6, %ymm5
; AVX2-NEXT:    vpunpckhwd {{.*#+}} xmm6 = xmm8[4],xmm7[4],xmm8[5],xmm7[5],xmm8[6],xmm7[6],xmm8[7],xmm7[7]
; AVX2-NEXT:    vpmovzxdq {{.*#+}} xmm7 = xmm6[0],zero,xmm6[1],zero
; AVX2-NEXT:    vpshufd {{.*#+}} xmm6 = xmm6[2,2,3,3]
; AVX2-NEXT:    vinserti128 $1, %xmm6, %ymm7, %ymm6
; AVX2-NEXT:    vpblendd {{.*#+}} ymm5 = ymm6[0],ymm5[1],ymm6[2],ymm5[3],ymm6[4],ymm5[5],ymm6[6],ymm5[7]
; AVX2-NEXT:    vpunpckhwd {{.*#+}} xmm6 = xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; AVX2-NEXT:    vpshufd {{.*#+}} xmm7 = xmm6[0,0,1,1]
; AVX2-NEXT:    vpshufd {{.*#+}} xmm6 = xmm6[2,2,3,3]
; AVX2-NEXT:    vinserti128 $1, %xmm6, %ymm7, %ymm6
; AVX2-NEXT:    vpunpckhwd {{.*#+}} xmm7 = xmm4[4],xmm3[4],xmm4[5],xmm3[5],xmm4[6],xmm3[6],xmm4[7],xmm3[7]
; AVX2-NEXT:    vpmovzxdq {{.*#+}} xmm8 = xmm7[0],zero,xmm7[1],zero
; AVX2-NEXT:    vpshufd {{.*#+}} xmm7 = xmm7[2,2,3,3]
; AVX2-NEXT:    vinserti128 $1, %xmm7, %ymm8, %ymm7
; AVX2-NEXT:    vpblendd {{.*#+}} ymm6 = ymm7[0],ymm6[1],ymm7[2],ymm6[3],ymm7[4],ymm6[5],ymm7[6],ymm6[7]
; AVX2-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; AVX2-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[0,0,1,1]
; AVX2-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX2-NEXT:    vinserti128 $1, %xmm0, %ymm1, %ymm0
; AVX2-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm4[0],xmm3[0],xmm4[1],xmm3[1],xmm4[2],xmm3[2],xmm4[3],xmm3[3]
; AVX2-NEXT:    vpmovzxdq {{.*#+}} xmm3 = xmm1[0],zero,xmm1[1],zero
; AVX2-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,2,3,3]
; AVX2-NEXT:    vinserti128 $1, %xmm1, %ymm3, %ymm1
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2],ymm0[3],ymm1[4],ymm0[5],ymm1[6],ymm0[7]
; AVX2-NEXT:    vmovdqa %ymm0, 64(%r8)
; AVX2-NEXT:    vmovdqa %ymm6, 96(%r8)
; AVX2-NEXT:    vmovdqa %ymm5, 32(%r8)
; AVX2-NEXT:    vmovdqa %ymm2, (%r8)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX2-FP-LABEL: store_i16_stride4_vf16:
; AVX2-FP:       # %bb.0:
; AVX2-FP-NEXT:    vmovdqa (%rcx), %xmm5
; AVX2-FP-NEXT:    vmovdqa 16(%rcx), %xmm0
; AVX2-FP-NEXT:    vmovdqa (%rdx), %xmm6
; AVX2-FP-NEXT:    vmovdqa 16(%rdx), %xmm1
; AVX2-FP-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm6[0],xmm5[0],xmm6[1],xmm5[1],xmm6[2],xmm5[2],xmm6[3],xmm5[3]
; AVX2-FP-NEXT:    vpshufd {{.*#+}} xmm3 = xmm2[0,0,1,1]
; AVX2-FP-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[2,2,3,3]
; AVX2-FP-NEXT:    vinserti128 $1, %xmm2, %ymm3, %ymm2
; AVX2-FP-NEXT:    vmovdqa (%rsi), %xmm7
; AVX2-FP-NEXT:    vmovdqa 16(%rsi), %xmm3
; AVX2-FP-NEXT:    vmovdqa (%rdi), %xmm8
; AVX2-FP-NEXT:    vmovdqa 16(%rdi), %xmm4
; AVX2-FP-NEXT:    vpunpcklwd {{.*#+}} xmm9 = xmm8[0],xmm7[0],xmm8[1],xmm7[1],xmm8[2],xmm7[2],xmm8[3],xmm7[3]
; AVX2-FP-NEXT:    vpmovzxdq {{.*#+}} xmm10 = xmm9[0],zero,xmm9[1],zero
; AVX2-FP-NEXT:    vpshufd {{.*#+}} xmm9 = xmm9[2,2,3,3]
; AVX2-FP-NEXT:    vinserti128 $1, %xmm9, %ymm10, %ymm9
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm2 = ymm9[0],ymm2[1],ymm9[2],ymm2[3],ymm9[4],ymm2[5],ymm9[6],ymm2[7]
; AVX2-FP-NEXT:    vpunpckhwd {{.*#+}} xmm5 = xmm6[4],xmm5[4],xmm6[5],xmm5[5],xmm6[6],xmm5[6],xmm6[7],xmm5[7]
; AVX2-FP-NEXT:    vpshufd {{.*#+}} xmm6 = xmm5[0,0,1,1]
; AVX2-FP-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[2,2,3,3]
; AVX2-FP-NEXT:    vinserti128 $1, %xmm5, %ymm6, %ymm5
; AVX2-FP-NEXT:    vpunpckhwd {{.*#+}} xmm6 = xmm8[4],xmm7[4],xmm8[5],xmm7[5],xmm8[6],xmm7[6],xmm8[7],xmm7[7]
; AVX2-FP-NEXT:    vpmovzxdq {{.*#+}} xmm7 = xmm6[0],zero,xmm6[1],zero
; AVX2-FP-NEXT:    vpshufd {{.*#+}} xmm6 = xmm6[2,2,3,3]
; AVX2-FP-NEXT:    vinserti128 $1, %xmm6, %ymm7, %ymm6
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm5 = ymm6[0],ymm5[1],ymm6[2],ymm5[3],ymm6[4],ymm5[5],ymm6[6],ymm5[7]
; AVX2-FP-NEXT:    vpunpckhwd {{.*#+}} xmm6 = xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; AVX2-FP-NEXT:    vpshufd {{.*#+}} xmm7 = xmm6[0,0,1,1]
; AVX2-FP-NEXT:    vpshufd {{.*#+}} xmm6 = xmm6[2,2,3,3]
; AVX2-FP-NEXT:    vinserti128 $1, %xmm6, %ymm7, %ymm6
; AVX2-FP-NEXT:    vpunpckhwd {{.*#+}} xmm7 = xmm4[4],xmm3[4],xmm4[5],xmm3[5],xmm4[6],xmm3[6],xmm4[7],xmm3[7]
; AVX2-FP-NEXT:    vpmovzxdq {{.*#+}} xmm8 = xmm7[0],zero,xmm7[1],zero
; AVX2-FP-NEXT:    vpshufd {{.*#+}} xmm7 = xmm7[2,2,3,3]
; AVX2-FP-NEXT:    vinserti128 $1, %xmm7, %ymm8, %ymm7
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm6 = ymm7[0],ymm6[1],ymm7[2],ymm6[3],ymm7[4],ymm6[5],ymm7[6],ymm6[7]
; AVX2-FP-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; AVX2-FP-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[0,0,1,1]
; AVX2-FP-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX2-FP-NEXT:    vinserti128 $1, %xmm0, %ymm1, %ymm0
; AVX2-FP-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm4[0],xmm3[0],xmm4[1],xmm3[1],xmm4[2],xmm3[2],xmm4[3],xmm3[3]
; AVX2-FP-NEXT:    vpmovzxdq {{.*#+}} xmm3 = xmm1[0],zero,xmm1[1],zero
; AVX2-FP-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,2,3,3]
; AVX2-FP-NEXT:    vinserti128 $1, %xmm1, %ymm3, %ymm1
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2],ymm0[3],ymm1[4],ymm0[5],ymm1[6],ymm0[7]
; AVX2-FP-NEXT:    vmovdqa %ymm0, 64(%r8)
; AVX2-FP-NEXT:    vmovdqa %ymm6, 96(%r8)
; AVX2-FP-NEXT:    vmovdqa %ymm5, 32(%r8)
; AVX2-FP-NEXT:    vmovdqa %ymm2, (%r8)
; AVX2-FP-NEXT:    vzeroupper
; AVX2-FP-NEXT:    retq
;
; AVX2-FCP-LABEL: store_i16_stride4_vf16:
; AVX2-FCP:       # %bb.0:
; AVX2-FCP-NEXT:    vmovdqa (%rsi), %xmm2
; AVX2-FCP-NEXT:    vmovdqa 16(%rsi), %xmm0
; AVX2-FCP-NEXT:    vmovdqa (%rdi), %xmm3
; AVX2-FCP-NEXT:    vmovdqa 16(%rdi), %xmm1
; AVX2-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm4 = xmm3[0],xmm2[0],xmm3[1],xmm2[1],xmm3[2],xmm2[2],xmm3[3],xmm2[3]
; AVX2-FCP-NEXT:    vpmovzxdq {{.*#+}} xmm5 = xmm4[0],zero,xmm4[1],zero
; AVX2-FCP-NEXT:    vpshufd {{.*#+}} xmm4 = xmm4[2,2,3,3]
; AVX2-FCP-NEXT:    vinserti128 $1, %xmm4, %ymm5, %ymm4
; AVX2-FCP-NEXT:    vmovdqa (%rcx), %xmm5
; AVX2-FCP-NEXT:    vmovdqa 16(%rcx), %xmm6
; AVX2-FCP-NEXT:    vmovdqa (%rdx), %xmm7
; AVX2-FCP-NEXT:    vmovdqa 16(%rdx), %xmm8
; AVX2-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm9 = xmm7[0],xmm5[0],xmm7[1],xmm5[1],xmm7[2],xmm5[2],xmm7[3],xmm5[3]
; AVX2-FCP-NEXT:    vpmovsxbd {{.*#+}} ymm10 = [0,0,1,1,2,2,3,3]
; AVX2-FCP-NEXT:    vpermd %ymm9, %ymm10, %ymm9
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm4 = ymm4[0],ymm9[1],ymm4[2],ymm9[3],ymm4[4],ymm9[5],ymm4[6],ymm9[7]
; AVX2-FCP-NEXT:    vpunpckhwd {{.*#+}} xmm2 = xmm3[4],xmm2[4],xmm3[5],xmm2[5],xmm3[6],xmm2[6],xmm3[7],xmm2[7]
; AVX2-FCP-NEXT:    vpmovzxdq {{.*#+}} xmm3 = xmm2[0],zero,xmm2[1],zero
; AVX2-FCP-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[2,2,3,3]
; AVX2-FCP-NEXT:    vinserti128 $1, %xmm2, %ymm3, %ymm2
; AVX2-FCP-NEXT:    vpunpckhwd {{.*#+}} xmm3 = xmm7[4],xmm5[4],xmm7[5],xmm5[5],xmm7[6],xmm5[6],xmm7[7],xmm5[7]
; AVX2-FCP-NEXT:    vpermd %ymm3, %ymm10, %ymm3
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm2 = ymm2[0],ymm3[1],ymm2[2],ymm3[3],ymm2[4],ymm3[5],ymm2[6],ymm3[7]
; AVX2-FCP-NEXT:    vpunpckhwd {{.*#+}} xmm3 = xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; AVX2-FCP-NEXT:    vpmovzxdq {{.*#+}} xmm5 = xmm3[0],zero,xmm3[1],zero
; AVX2-FCP-NEXT:    vpshufd {{.*#+}} xmm3 = xmm3[2,2,3,3]
; AVX2-FCP-NEXT:    vinserti128 $1, %xmm3, %ymm5, %ymm3
; AVX2-FCP-NEXT:    vpunpckhwd {{.*#+}} xmm5 = xmm8[4],xmm6[4],xmm8[5],xmm6[5],xmm8[6],xmm6[6],xmm8[7],xmm6[7]
; AVX2-FCP-NEXT:    vpermd %ymm5, %ymm10, %ymm5
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0],ymm5[1],ymm3[2],ymm5[3],ymm3[4],ymm5[5],ymm3[6],ymm5[7]
; AVX2-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; AVX2-FCP-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm0[0],zero,xmm0[1],zero
; AVX2-FCP-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX2-FCP-NEXT:    vinserti128 $1, %xmm0, %ymm1, %ymm0
; AVX2-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm8[0],xmm6[0],xmm8[1],xmm6[1],xmm8[2],xmm6[2],xmm8[3],xmm6[3]
; AVX2-FCP-NEXT:    vpermd %ymm1, %ymm10, %ymm1
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2],ymm1[3],ymm0[4],ymm1[5],ymm0[6],ymm1[7]
; AVX2-FCP-NEXT:    vmovdqa %ymm0, 64(%r8)
; AVX2-FCP-NEXT:    vmovdqa %ymm3, 96(%r8)
; AVX2-FCP-NEXT:    vmovdqa %ymm2, 32(%r8)
; AVX2-FCP-NEXT:    vmovdqa %ymm4, (%r8)
; AVX2-FCP-NEXT:    vzeroupper
; AVX2-FCP-NEXT:    retq
;
; AVX512-LABEL: store_i16_stride4_vf16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa (%rcx), %xmm0
; AVX512-NEXT:    vmovdqa 16(%rcx), %xmm1
; AVX512-NEXT:    vmovdqa (%rdx), %xmm2
; AVX512-NEXT:    vmovdqa 16(%rdx), %xmm3
; AVX512-NEXT:    vpunpckhwd {{.*#+}} xmm4 = xmm3[4],xmm1[4],xmm3[5],xmm1[5],xmm3[6],xmm1[6],xmm3[7],xmm1[7]
; AVX512-NEXT:    vmovdqa (%rsi), %xmm5
; AVX512-NEXT:    vmovdqa 16(%rsi), %xmm6
; AVX512-NEXT:    vmovdqa (%rdi), %xmm7
; AVX512-NEXT:    vmovdqa 16(%rdi), %xmm8
; AVX512-NEXT:    vpunpckhwd {{.*#+}} xmm9 = xmm8[4],xmm6[4],xmm8[5],xmm6[5],xmm8[6],xmm6[6],xmm8[7],xmm6[7]
; AVX512-NEXT:    vpmovsxbd {{.*#+}} ymm10 = [0,8,1,9,2,10,3,11]
; AVX512-NEXT:    vpermt2d %ymm4, %ymm10, %ymm9
; AVX512-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm3[0],xmm1[0],xmm3[1],xmm1[1],xmm3[2],xmm1[2],xmm3[3],xmm1[3]
; AVX512-NEXT:    vpunpcklwd {{.*#+}} xmm3 = xmm8[0],xmm6[0],xmm8[1],xmm6[1],xmm8[2],xmm6[2],xmm8[3],xmm6[3]
; AVX512-NEXT:    vpermt2d %ymm1, %ymm10, %ymm3
; AVX512-NEXT:    vinserti64x4 $1, %ymm9, %zmm3, %zmm1
; AVX512-NEXT:    vpunpckhwd {{.*#+}} xmm3 = xmm2[4],xmm0[4],xmm2[5],xmm0[5],xmm2[6],xmm0[6],xmm2[7],xmm0[7]
; AVX512-NEXT:    vpunpckhwd {{.*#+}} xmm4 = xmm7[4],xmm5[4],xmm7[5],xmm5[5],xmm7[6],xmm5[6],xmm7[7],xmm5[7]
; AVX512-NEXT:    vpermt2d %ymm3, %ymm10, %ymm4
; AVX512-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm2[0],xmm0[0],xmm2[1],xmm0[1],xmm2[2],xmm0[2],xmm2[3],xmm0[3]
; AVX512-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm7[0],xmm5[0],xmm7[1],xmm5[1],xmm7[2],xmm5[2],xmm7[3],xmm5[3]
; AVX512-NEXT:    vpermt2d %ymm0, %ymm10, %ymm2
; AVX512-NEXT:    vinserti64x4 $1, %ymm4, %zmm2, %zmm0
; AVX512-NEXT:    vmovdqa64 %zmm0, (%r8)
; AVX512-NEXT:    vmovdqa64 %zmm1, 64(%r8)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
;
; AVX512-FCP-LABEL: store_i16_stride4_vf16:
; AVX512-FCP:       # %bb.0:
; AVX512-FCP-NEXT:    vmovdqa (%rcx), %xmm0
; AVX512-FCP-NEXT:    vmovdqa 16(%rcx), %xmm1
; AVX512-FCP-NEXT:    vmovdqa (%rdx), %xmm2
; AVX512-FCP-NEXT:    vmovdqa 16(%rdx), %xmm3
; AVX512-FCP-NEXT:    vpunpckhwd {{.*#+}} xmm4 = xmm3[4],xmm1[4],xmm3[5],xmm1[5],xmm3[6],xmm1[6],xmm3[7],xmm1[7]
; AVX512-FCP-NEXT:    vmovdqa (%rsi), %xmm5
; AVX512-FCP-NEXT:    vmovdqa 16(%rsi), %xmm6
; AVX512-FCP-NEXT:    vmovdqa (%rdi), %xmm7
; AVX512-FCP-NEXT:    vmovdqa 16(%rdi), %xmm8
; AVX512-FCP-NEXT:    vpunpckhwd {{.*#+}} xmm9 = xmm8[4],xmm6[4],xmm8[5],xmm6[5],xmm8[6],xmm6[6],xmm8[7],xmm6[7]
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} ymm10 = [0,8,1,9,2,10,3,11]
; AVX512-FCP-NEXT:    vpermt2d %ymm4, %ymm10, %ymm9
; AVX512-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm3[0],xmm1[0],xmm3[1],xmm1[1],xmm3[2],xmm1[2],xmm3[3],xmm1[3]
; AVX512-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm3 = xmm8[0],xmm6[0],xmm8[1],xmm6[1],xmm8[2],xmm6[2],xmm8[3],xmm6[3]
; AVX512-FCP-NEXT:    vpermt2d %ymm1, %ymm10, %ymm3
; AVX512-FCP-NEXT:    vinserti64x4 $1, %ymm9, %zmm3, %zmm1
; AVX512-FCP-NEXT:    vpunpckhwd {{.*#+}} xmm3 = xmm2[4],xmm0[4],xmm2[5],xmm0[5],xmm2[6],xmm0[6],xmm2[7],xmm0[7]
; AVX512-FCP-NEXT:    vpunpckhwd {{.*#+}} xmm4 = xmm7[4],xmm5[4],xmm7[5],xmm5[5],xmm7[6],xmm5[6],xmm7[7],xmm5[7]
; AVX512-FCP-NEXT:    vpermt2d %ymm3, %ymm10, %ymm4
; AVX512-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm2[0],xmm0[0],xmm2[1],xmm0[1],xmm2[2],xmm0[2],xmm2[3],xmm0[3]
; AVX512-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm7[0],xmm5[0],xmm7[1],xmm5[1],xmm7[2],xmm5[2],xmm7[3],xmm5[3]
; AVX512-FCP-NEXT:    vpermt2d %ymm0, %ymm10, %ymm2
; AVX512-FCP-NEXT:    vinserti64x4 $1, %ymm4, %zmm2, %zmm0
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, (%r8)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm1, 64(%r8)
; AVX512-FCP-NEXT:    vzeroupper
; AVX512-FCP-NEXT:    retq
;
; AVX512DQ-LABEL: store_i16_stride4_vf16:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vmovdqa (%rcx), %xmm0
; AVX512DQ-NEXT:    vmovdqa 16(%rcx), %xmm1
; AVX512DQ-NEXT:    vmovdqa (%rdx), %xmm2
; AVX512DQ-NEXT:    vmovdqa 16(%rdx), %xmm3
; AVX512DQ-NEXT:    vpunpckhwd {{.*#+}} xmm4 = xmm3[4],xmm1[4],xmm3[5],xmm1[5],xmm3[6],xmm1[6],xmm3[7],xmm1[7]
; AVX512DQ-NEXT:    vmovdqa (%rsi), %xmm5
; AVX512DQ-NEXT:    vmovdqa 16(%rsi), %xmm6
; AVX512DQ-NEXT:    vmovdqa (%rdi), %xmm7
; AVX512DQ-NEXT:    vmovdqa 16(%rdi), %xmm8
; AVX512DQ-NEXT:    vpunpckhwd {{.*#+}} xmm9 = xmm8[4],xmm6[4],xmm8[5],xmm6[5],xmm8[6],xmm6[6],xmm8[7],xmm6[7]
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} ymm10 = [0,8,1,9,2,10,3,11]
; AVX512DQ-NEXT:    vpermt2d %ymm4, %ymm10, %ymm9
; AVX512DQ-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm3[0],xmm1[0],xmm3[1],xmm1[1],xmm3[2],xmm1[2],xmm3[3],xmm1[3]
; AVX512DQ-NEXT:    vpunpcklwd {{.*#+}} xmm3 = xmm8[0],xmm6[0],xmm8[1],xmm6[1],xmm8[2],xmm6[2],xmm8[3],xmm6[3]
; AVX512DQ-NEXT:    vpermt2d %ymm1, %ymm10, %ymm3
; AVX512DQ-NEXT:    vinserti64x4 $1, %ymm9, %zmm3, %zmm1
; AVX512DQ-NEXT:    vpunpckhwd {{.*#+}} xmm3 = xmm2[4],xmm0[4],xmm2[5],xmm0[5],xmm2[6],xmm0[6],xmm2[7],xmm0[7]
; AVX512DQ-NEXT:    vpunpckhwd {{.*#+}} xmm4 = xmm7[4],xmm5[4],xmm7[5],xmm5[5],xmm7[6],xmm5[6],xmm7[7],xmm5[7]
; AVX512DQ-NEXT:    vpermt2d %ymm3, %ymm10, %ymm4
; AVX512DQ-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm2[0],xmm0[0],xmm2[1],xmm0[1],xmm2[2],xmm0[2],xmm2[3],xmm0[3]
; AVX512DQ-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm7[0],xmm5[0],xmm7[1],xmm5[1],xmm7[2],xmm5[2],xmm7[3],xmm5[3]
; AVX512DQ-NEXT:    vpermt2d %ymm0, %ymm10, %ymm2
; AVX512DQ-NEXT:    vinserti64x4 $1, %ymm4, %zmm2, %zmm0
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, (%r8)
; AVX512DQ-NEXT:    vmovdqa64 %zmm1, 64(%r8)
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512DQ-FCP-LABEL: store_i16_stride4_vf16:
; AVX512DQ-FCP:       # %bb.0:
; AVX512DQ-FCP-NEXT:    vmovdqa (%rcx), %xmm0
; AVX512DQ-FCP-NEXT:    vmovdqa 16(%rcx), %xmm1
; AVX512DQ-FCP-NEXT:    vmovdqa (%rdx), %xmm2
; AVX512DQ-FCP-NEXT:    vmovdqa 16(%rdx), %xmm3
; AVX512DQ-FCP-NEXT:    vpunpckhwd {{.*#+}} xmm4 = xmm3[4],xmm1[4],xmm3[5],xmm1[5],xmm3[6],xmm1[6],xmm3[7],xmm1[7]
; AVX512DQ-FCP-NEXT:    vmovdqa (%rsi), %xmm5
; AVX512DQ-FCP-NEXT:    vmovdqa 16(%rsi), %xmm6
; AVX512DQ-FCP-NEXT:    vmovdqa (%rdi), %xmm7
; AVX512DQ-FCP-NEXT:    vmovdqa 16(%rdi), %xmm8
; AVX512DQ-FCP-NEXT:    vpunpckhwd {{.*#+}} xmm9 = xmm8[4],xmm6[4],xmm8[5],xmm6[5],xmm8[6],xmm6[6],xmm8[7],xmm6[7]
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} ymm10 = [0,8,1,9,2,10,3,11]
; AVX512DQ-FCP-NEXT:    vpermt2d %ymm4, %ymm10, %ymm9
; AVX512DQ-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm3[0],xmm1[0],xmm3[1],xmm1[1],xmm3[2],xmm1[2],xmm3[3],xmm1[3]
; AVX512DQ-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm3 = xmm8[0],xmm6[0],xmm8[1],xmm6[1],xmm8[2],xmm6[2],xmm8[3],xmm6[3]
; AVX512DQ-FCP-NEXT:    vpermt2d %ymm1, %ymm10, %ymm3
; AVX512DQ-FCP-NEXT:    vinserti64x4 $1, %ymm9, %zmm3, %zmm1
; AVX512DQ-FCP-NEXT:    vpunpckhwd {{.*#+}} xmm3 = xmm2[4],xmm0[4],xmm2[5],xmm0[5],xmm2[6],xmm0[6],xmm2[7],xmm0[7]
; AVX512DQ-FCP-NEXT:    vpunpckhwd {{.*#+}} xmm4 = xmm7[4],xmm5[4],xmm7[5],xmm5[5],xmm7[6],xmm5[6],xmm7[7],xmm5[7]
; AVX512DQ-FCP-NEXT:    vpermt2d %ymm3, %ymm10, %ymm4
; AVX512DQ-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm2[0],xmm0[0],xmm2[1],xmm0[1],xmm2[2],xmm0[2],xmm2[3],xmm0[3]
; AVX512DQ-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm7[0],xmm5[0],xmm7[1],xmm5[1],xmm7[2],xmm5[2],xmm7[3],xmm5[3]
; AVX512DQ-FCP-NEXT:    vpermt2d %ymm0, %ymm10, %ymm2
; AVX512DQ-FCP-NEXT:    vinserti64x4 $1, %ymm4, %zmm2, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, (%r8)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm1, 64(%r8)
; AVX512DQ-FCP-NEXT:    vzeroupper
; AVX512DQ-FCP-NEXT:    retq
;
; AVX512BW-LABEL: store_i16_stride4_vf16:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512BW-NEXT:    vmovdqa (%rdx), %ymm1
; AVX512BW-NEXT:    vinserti64x4 $1, (%rsi), %zmm0, %zmm0
; AVX512BW-NEXT:    vinserti64x4 $1, (%rcx), %zmm1, %zmm1
; AVX512BW-NEXT:    vpmovsxbw {{.*#+}} zmm2 = [0,16,32,48,1,17,33,49,2,18,34,50,3,19,35,51,4,20,36,52,5,21,37,53,6,22,38,54,7,23,39,55]
; AVX512BW-NEXT:    vpermi2w %zmm1, %zmm0, %zmm2
; AVX512BW-NEXT:    vpmovsxbw {{.*#+}} zmm3 = [8,24,40,56,9,25,41,57,10,26,42,58,11,27,43,59,12,28,44,60,13,29,45,61,14,30,46,62,15,31,47,63]
; AVX512BW-NEXT:    vpermi2w %zmm1, %zmm0, %zmm3
; AVX512BW-NEXT:    vmovdqa64 %zmm3, 64(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm2, (%r8)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BW-FCP-LABEL: store_i16_stride4_vf16:
; AVX512BW-FCP:       # %bb.0:
; AVX512BW-FCP-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512BW-FCP-NEXT:    vmovdqa (%rdx), %ymm1
; AVX512BW-FCP-NEXT:    vinserti64x4 $1, (%rsi), %zmm0, %zmm0
; AVX512BW-FCP-NEXT:    vinserti64x4 $1, (%rcx), %zmm1, %zmm1
; AVX512BW-FCP-NEXT:    vpmovsxbw {{.*#+}} zmm2 = [0,16,32,48,1,17,33,49,2,18,34,50,3,19,35,51,4,20,36,52,5,21,37,53,6,22,38,54,7,23,39,55]
; AVX512BW-FCP-NEXT:    vpermi2w %zmm1, %zmm0, %zmm2
; AVX512BW-FCP-NEXT:    vpmovsxbw {{.*#+}} zmm3 = [8,24,40,56,9,25,41,57,10,26,42,58,11,27,43,59,12,28,44,60,13,29,45,61,14,30,46,62,15,31,47,63]
; AVX512BW-FCP-NEXT:    vpermi2w %zmm1, %zmm0, %zmm3
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm3, 64(%r8)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm2, (%r8)
; AVX512BW-FCP-NEXT:    vzeroupper
; AVX512BW-FCP-NEXT:    retq
;
; AVX512DQ-BW-LABEL: store_i16_stride4_vf16:
; AVX512DQ-BW:       # %bb.0:
; AVX512DQ-BW-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512DQ-BW-NEXT:    vmovdqa (%rdx), %ymm1
; AVX512DQ-BW-NEXT:    vinserti64x4 $1, (%rsi), %zmm0, %zmm0
; AVX512DQ-BW-NEXT:    vinserti64x4 $1, (%rcx), %zmm1, %zmm1
; AVX512DQ-BW-NEXT:    vpmovsxbw {{.*#+}} zmm2 = [0,16,32,48,1,17,33,49,2,18,34,50,3,19,35,51,4,20,36,52,5,21,37,53,6,22,38,54,7,23,39,55]
; AVX512DQ-BW-NEXT:    vpermi2w %zmm1, %zmm0, %zmm2
; AVX512DQ-BW-NEXT:    vpmovsxbw {{.*#+}} zmm3 = [8,24,40,56,9,25,41,57,10,26,42,58,11,27,43,59,12,28,44,60,13,29,45,61,14,30,46,62,15,31,47,63]
; AVX512DQ-BW-NEXT:    vpermi2w %zmm1, %zmm0, %zmm3
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm3, 64(%r8)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm2, (%r8)
; AVX512DQ-BW-NEXT:    vzeroupper
; AVX512DQ-BW-NEXT:    retq
;
; AVX512DQ-BW-FCP-LABEL: store_i16_stride4_vf16:
; AVX512DQ-BW-FCP:       # %bb.0:
; AVX512DQ-BW-FCP-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqa (%rdx), %ymm1
; AVX512DQ-BW-FCP-NEXT:    vinserti64x4 $1, (%rsi), %zmm0, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vinserti64x4 $1, (%rcx), %zmm1, %zmm1
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbw {{.*#+}} zmm2 = [0,16,32,48,1,17,33,49,2,18,34,50,3,19,35,51,4,20,36,52,5,21,37,53,6,22,38,54,7,23,39,55]
; AVX512DQ-BW-FCP-NEXT:    vpermi2w %zmm1, %zmm0, %zmm2
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbw {{.*#+}} zmm3 = [8,24,40,56,9,25,41,57,10,26,42,58,11,27,43,59,12,28,44,60,13,29,45,61,14,30,46,62,15,31,47,63]
; AVX512DQ-BW-FCP-NEXT:    vpermi2w %zmm1, %zmm0, %zmm3
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm3, 64(%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm2, (%r8)
; AVX512DQ-BW-FCP-NEXT:    vzeroupper
; AVX512DQ-BW-FCP-NEXT:    retq
  %in.vec0 = load <16 x i16>, ptr %in.vecptr0, align 64
  %in.vec1 = load <16 x i16>, ptr %in.vecptr1, align 64
  %in.vec2 = load <16 x i16>, ptr %in.vecptr2, align 64
  %in.vec3 = load <16 x i16>, ptr %in.vecptr3, align 64
  %1 = shufflevector <16 x i16> %in.vec0, <16 x i16> %in.vec1, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %2 = shufflevector <16 x i16> %in.vec2, <16 x i16> %in.vec3, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %3 = shufflevector <32 x i16> %1, <32 x i16> %2, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %interleaved.vec = shufflevector <64 x i16> %3, <64 x i16> poison, <64 x i32> <i32 0, i32 16, i32 32, i32 48, i32 1, i32 17, i32 33, i32 49, i32 2, i32 18, i32 34, i32 50, i32 3, i32 19, i32 35, i32 51, i32 4, i32 20, i32 36, i32 52, i32 5, i32 21, i32 37, i32 53, i32 6, i32 22, i32 38, i32 54, i32 7, i32 23, i32 39, i32 55, i32 8, i32 24, i32 40, i32 56, i32 9, i32 25, i32 41, i32 57, i32 10, i32 26, i32 42, i32 58, i32 11, i32 27, i32 43, i32 59, i32 12, i32 28, i32 44, i32 60, i32 13, i32 29, i32 45, i32 61, i32 14, i32 30, i32 46, i32 62, i32 15, i32 31, i32 47, i32 63>
  store <64 x i16> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i16_stride4_vf32(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %in.vecptr3, ptr %out.vec) nounwind {
; SSE-LABEL: store_i16_stride4_vf32:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa (%rdi), %xmm5
; SSE-NEXT:    movdqa 16(%rdi), %xmm11
; SSE-NEXT:    movdqa 32(%rdi), %xmm4
; SSE-NEXT:    movdqa 48(%rdi), %xmm2
; SSE-NEXT:    movdqa (%rsi), %xmm0
; SSE-NEXT:    movdqa 16(%rsi), %xmm3
; SSE-NEXT:    movdqa 32(%rsi), %xmm9
; SSE-NEXT:    movdqa (%rdx), %xmm7
; SSE-NEXT:    movdqa 16(%rdx), %xmm13
; SSE-NEXT:    movdqa 32(%rdx), %xmm10
; SSE-NEXT:    movdqa (%rcx), %xmm8
; SSE-NEXT:    movdqa 16(%rcx), %xmm14
; SSE-NEXT:    movdqa 32(%rcx), %xmm12
; SSE-NEXT:    movdqa %xmm7, %xmm15
; SSE-NEXT:    punpcklwd {{.*#+}} xmm15 = xmm15[0],xmm8[0],xmm15[1],xmm8[1],xmm15[2],xmm8[2],xmm15[3],xmm8[3]
; SSE-NEXT:    movdqa %xmm5, %xmm6
; SSE-NEXT:    punpcklwd {{.*#+}} xmm6 = xmm6[0],xmm0[0],xmm6[1],xmm0[1],xmm6[2],xmm0[2],xmm6[3],xmm0[3]
; SSE-NEXT:    movdqa %xmm6, %xmm1
; SSE-NEXT:    punpckhdq {{.*#+}} xmm1 = xmm1[2],xmm15[2],xmm1[3],xmm15[3]
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckldq {{.*#+}} xmm6 = xmm6[0],xmm15[0],xmm6[1],xmm15[1]
; SSE-NEXT:    punpckhwd {{.*#+}} xmm7 = xmm7[4],xmm8[4],xmm7[5],xmm8[5],xmm7[6],xmm8[6],xmm7[7],xmm8[7]
; SSE-NEXT:    punpckhwd {{.*#+}} xmm5 = xmm5[4],xmm0[4],xmm5[5],xmm0[5],xmm5[6],xmm0[6],xmm5[7],xmm0[7]
; SSE-NEXT:    movdqa %xmm5, %xmm0
; SSE-NEXT:    punpckhdq {{.*#+}} xmm0 = xmm0[2],xmm7[2],xmm0[3],xmm7[3]
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckldq {{.*#+}} xmm5 = xmm5[0],xmm7[0],xmm5[1],xmm7[1]
; SSE-NEXT:    movdqa %xmm13, %xmm15
; SSE-NEXT:    punpcklwd {{.*#+}} xmm15 = xmm15[0],xmm14[0],xmm15[1],xmm14[1],xmm15[2],xmm14[2],xmm15[3],xmm14[3]
; SSE-NEXT:    movdqa %xmm11, %xmm7
; SSE-NEXT:    punpcklwd {{.*#+}} xmm7 = xmm7[0],xmm3[0],xmm7[1],xmm3[1],xmm7[2],xmm3[2],xmm7[3],xmm3[3]
; SSE-NEXT:    movdqa %xmm7, %xmm0
; SSE-NEXT:    punpckhdq {{.*#+}} xmm0 = xmm0[2],xmm15[2],xmm0[3],xmm15[3]
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckldq {{.*#+}} xmm7 = xmm7[0],xmm15[0],xmm7[1],xmm15[1]
; SSE-NEXT:    punpckhwd {{.*#+}} xmm13 = xmm13[4],xmm14[4],xmm13[5],xmm14[5],xmm13[6],xmm14[6],xmm13[7],xmm14[7]
; SSE-NEXT:    punpckhwd {{.*#+}} xmm11 = xmm11[4],xmm3[4],xmm11[5],xmm3[5],xmm11[6],xmm3[6],xmm11[7],xmm3[7]
; SSE-NEXT:    movdqa %xmm11, %xmm8
; SSE-NEXT:    punpckhdq {{.*#+}} xmm8 = xmm8[2],xmm13[2],xmm8[3],xmm13[3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm11 = xmm11[0],xmm13[0],xmm11[1],xmm13[1]
; SSE-NEXT:    movdqa %xmm10, %xmm15
; SSE-NEXT:    punpcklwd {{.*#+}} xmm15 = xmm15[0],xmm12[0],xmm15[1],xmm12[1],xmm15[2],xmm12[2],xmm15[3],xmm12[3]
; SSE-NEXT:    movdqa %xmm4, %xmm13
; SSE-NEXT:    punpcklwd {{.*#+}} xmm13 = xmm13[0],xmm9[0],xmm13[1],xmm9[1],xmm13[2],xmm9[2],xmm13[3],xmm9[3]
; SSE-NEXT:    movdqa %xmm13, %xmm14
; SSE-NEXT:    punpckhdq {{.*#+}} xmm14 = xmm14[2],xmm15[2],xmm14[3],xmm15[3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm13 = xmm13[0],xmm15[0],xmm13[1],xmm15[1]
; SSE-NEXT:    movdqa 48(%rdx), %xmm15
; SSE-NEXT:    punpckhwd {{.*#+}} xmm10 = xmm10[4],xmm12[4],xmm10[5],xmm12[5],xmm10[6],xmm12[6],xmm10[7],xmm12[7]
; SSE-NEXT:    movdqa 48(%rcx), %xmm12
; SSE-NEXT:    punpckhwd {{.*#+}} xmm4 = xmm4[4],xmm9[4],xmm4[5],xmm9[5],xmm4[6],xmm9[6],xmm4[7],xmm9[7]
; SSE-NEXT:    movdqa %xmm4, %xmm9
; SSE-NEXT:    punpckhdq {{.*#+}} xmm9 = xmm9[2],xmm10[2],xmm9[3],xmm10[3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm10[0],xmm4[1],xmm10[1]
; SSE-NEXT:    movdqa %xmm15, %xmm10
; SSE-NEXT:    punpcklwd {{.*#+}} xmm10 = xmm10[0],xmm12[0],xmm10[1],xmm12[1],xmm10[2],xmm12[2],xmm10[3],xmm12[3]
; SSE-NEXT:    movdqa 48(%rsi), %xmm1
; SSE-NEXT:    movdqa %xmm2, %xmm3
; SSE-NEXT:    punpcklwd {{.*#+}} xmm3 = xmm3[0],xmm1[0],xmm3[1],xmm1[1],xmm3[2],xmm1[2],xmm3[3],xmm1[3]
; SSE-NEXT:    movdqa %xmm3, %xmm0
; SSE-NEXT:    punpckhdq {{.*#+}} xmm0 = xmm0[2],xmm10[2],xmm0[3],xmm10[3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm3 = xmm3[0],xmm10[0],xmm3[1],xmm10[1]
; SSE-NEXT:    punpckhwd {{.*#+}} xmm15 = xmm15[4],xmm12[4],xmm15[5],xmm12[5],xmm15[6],xmm12[6],xmm15[7],xmm12[7]
; SSE-NEXT:    punpckhwd {{.*#+}} xmm2 = xmm2[4],xmm1[4],xmm2[5],xmm1[5],xmm2[6],xmm1[6],xmm2[7],xmm1[7]
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    punpckhdq {{.*#+}} xmm1 = xmm1[2],xmm15[2],xmm1[3],xmm15[3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm15[0],xmm2[1],xmm15[1]
; SSE-NEXT:    movdqa %xmm2, 224(%r8)
; SSE-NEXT:    movdqa %xmm1, 240(%r8)
; SSE-NEXT:    movdqa %xmm3, 192(%r8)
; SSE-NEXT:    movdqa %xmm0, 208(%r8)
; SSE-NEXT:    movdqa %xmm4, 160(%r8)
; SSE-NEXT:    movdqa %xmm9, 176(%r8)
; SSE-NEXT:    movdqa %xmm13, 128(%r8)
; SSE-NEXT:    movdqa %xmm14, 144(%r8)
; SSE-NEXT:    movdqa %xmm11, 96(%r8)
; SSE-NEXT:    movdqa %xmm8, 112(%r8)
; SSE-NEXT:    movdqa %xmm7, 64(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 80(%r8)
; SSE-NEXT:    movdqa %xmm5, 32(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 48(%r8)
; SSE-NEXT:    movdqa %xmm6, (%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%r8)
; SSE-NEXT:    retq
;
; AVX-LABEL: store_i16_stride4_vf32:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovdqa (%rcx), %xmm3
; AVX-NEXT:    vmovdqa 16(%rcx), %xmm0
; AVX-NEXT:    vmovdqa 32(%rcx), %xmm4
; AVX-NEXT:    vmovdqa 48(%rcx), %xmm7
; AVX-NEXT:    vmovdqa (%rdx), %xmm6
; AVX-NEXT:    vmovdqa 16(%rdx), %xmm1
; AVX-NEXT:    vmovdqa 32(%rdx), %xmm5
; AVX-NEXT:    vmovdqa 48(%rdx), %xmm8
; AVX-NEXT:    vpunpckhwd {{.*#+}} xmm2 = xmm6[4],xmm3[4],xmm6[5],xmm3[5],xmm6[6],xmm3[6],xmm6[7],xmm3[7]
; AVX-NEXT:    vpshufd {{.*#+}} xmm9 = xmm2[0,0,1,1]
; AVX-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[2,2,3,3]
; AVX-NEXT:    vinsertf128 $1, %xmm2, %ymm9, %ymm2
; AVX-NEXT:    vmovdqa (%rsi), %xmm9
; AVX-NEXT:    vmovdqa (%rdi), %xmm10
; AVX-NEXT:    vpunpckhwd {{.*#+}} xmm11 = xmm10[4],xmm9[4],xmm10[5],xmm9[5],xmm10[6],xmm9[6],xmm10[7],xmm9[7]
; AVX-NEXT:    vpmovzxdq {{.*#+}} xmm12 = xmm11[0],zero,xmm11[1],zero
; AVX-NEXT:    vpshufd {{.*#+}} xmm11 = xmm11[2,2,3,3]
; AVX-NEXT:    vinsertf128 $1, %xmm11, %ymm12, %ymm11
; AVX-NEXT:    vmovdqa 48(%rsi), %xmm12
; AVX-NEXT:    vblendps {{.*#+}} ymm2 = ymm11[0],ymm2[1],ymm11[2],ymm2[3],ymm11[4],ymm2[5],ymm11[6],ymm2[7]
; AVX-NEXT:    vmovdqa 48(%rdi), %xmm11
; AVX-NEXT:    vpunpcklwd {{.*#+}} xmm3 = xmm6[0],xmm3[0],xmm6[1],xmm3[1],xmm6[2],xmm3[2],xmm6[3],xmm3[3]
; AVX-NEXT:    vpshufd {{.*#+}} xmm6 = xmm3[0,0,1,1]
; AVX-NEXT:    vpshufd {{.*#+}} xmm3 = xmm3[2,2,3,3]
; AVX-NEXT:    vinsertf128 $1, %xmm3, %ymm6, %ymm3
; AVX-NEXT:    vpunpcklwd {{.*#+}} xmm6 = xmm10[0],xmm9[0],xmm10[1],xmm9[1],xmm10[2],xmm9[2],xmm10[3],xmm9[3]
; AVX-NEXT:    vpmovzxdq {{.*#+}} xmm9 = xmm6[0],zero,xmm6[1],zero
; AVX-NEXT:    vpshufd {{.*#+}} xmm6 = xmm6[2,2,3,3]
; AVX-NEXT:    vinsertf128 $1, %xmm6, %ymm9, %ymm6
; AVX-NEXT:    vblendps {{.*#+}} ymm3 = ymm6[0],ymm3[1],ymm6[2],ymm3[3],ymm6[4],ymm3[5],ymm6[6],ymm3[7]
; AVX-NEXT:    vpunpcklwd {{.*#+}} xmm6 = xmm8[0],xmm7[0],xmm8[1],xmm7[1],xmm8[2],xmm7[2],xmm8[3],xmm7[3]
; AVX-NEXT:    vpshufd {{.*#+}} xmm9 = xmm6[0,0,1,1]
; AVX-NEXT:    vpshufd {{.*#+}} xmm6 = xmm6[2,2,3,3]
; AVX-NEXT:    vinsertf128 $1, %xmm6, %ymm9, %ymm6
; AVX-NEXT:    vpunpcklwd {{.*#+}} xmm9 = xmm11[0],xmm12[0],xmm11[1],xmm12[1],xmm11[2],xmm12[2],xmm11[3],xmm12[3]
; AVX-NEXT:    vpmovzxdq {{.*#+}} xmm10 = xmm9[0],zero,xmm9[1],zero
; AVX-NEXT:    vpshufd {{.*#+}} xmm9 = xmm9[2,2,3,3]
; AVX-NEXT:    vinsertf128 $1, %xmm9, %ymm10, %ymm9
; AVX-NEXT:    vmovdqa 32(%rsi), %xmm10
; AVX-NEXT:    vblendps {{.*#+}} ymm6 = ymm9[0],ymm6[1],ymm9[2],ymm6[3],ymm9[4],ymm6[5],ymm9[6],ymm6[7]
; AVX-NEXT:    vmovdqa 32(%rdi), %xmm9
; AVX-NEXT:    vpunpckhwd {{.*#+}} xmm7 = xmm8[4],xmm7[4],xmm8[5],xmm7[5],xmm8[6],xmm7[6],xmm8[7],xmm7[7]
; AVX-NEXT:    vpshufd {{.*#+}} xmm8 = xmm7[0,0,1,1]
; AVX-NEXT:    vpshufd {{.*#+}} xmm7 = xmm7[2,2,3,3]
; AVX-NEXT:    vinsertf128 $1, %xmm7, %ymm8, %ymm7
; AVX-NEXT:    vpunpckhwd {{.*#+}} xmm8 = xmm11[4],xmm12[4],xmm11[5],xmm12[5],xmm11[6],xmm12[6],xmm11[7],xmm12[7]
; AVX-NEXT:    vpmovzxdq {{.*#+}} xmm11 = xmm8[0],zero,xmm8[1],zero
; AVX-NEXT:    vpshufd {{.*#+}} xmm8 = xmm8[2,2,3,3]
; AVX-NEXT:    vinsertf128 $1, %xmm8, %ymm11, %ymm8
; AVX-NEXT:    vblendps {{.*#+}} ymm7 = ymm8[0],ymm7[1],ymm8[2],ymm7[3],ymm8[4],ymm7[5],ymm8[6],ymm7[7]
; AVX-NEXT:    vpunpcklwd {{.*#+}} xmm8 = xmm5[0],xmm4[0],xmm5[1],xmm4[1],xmm5[2],xmm4[2],xmm5[3],xmm4[3]
; AVX-NEXT:    vpshufd {{.*#+}} xmm11 = xmm8[0,0,1,1]
; AVX-NEXT:    vpshufd {{.*#+}} xmm8 = xmm8[2,2,3,3]
; AVX-NEXT:    vinsertf128 $1, %xmm8, %ymm11, %ymm8
; AVX-NEXT:    vpunpcklwd {{.*#+}} xmm11 = xmm9[0],xmm10[0],xmm9[1],xmm10[1],xmm9[2],xmm10[2],xmm9[3],xmm10[3]
; AVX-NEXT:    vpmovzxdq {{.*#+}} xmm12 = xmm11[0],zero,xmm11[1],zero
; AVX-NEXT:    vpshufd {{.*#+}} xmm11 = xmm11[2,2,3,3]
; AVX-NEXT:    vinsertf128 $1, %xmm11, %ymm12, %ymm11
; AVX-NEXT:    vmovdqa 16(%rsi), %xmm12
; AVX-NEXT:    vblendps {{.*#+}} ymm8 = ymm11[0],ymm8[1],ymm11[2],ymm8[3],ymm11[4],ymm8[5],ymm11[6],ymm8[7]
; AVX-NEXT:    vmovdqa 16(%rdi), %xmm11
; AVX-NEXT:    vpunpckhwd {{.*#+}} xmm4 = xmm5[4],xmm4[4],xmm5[5],xmm4[5],xmm5[6],xmm4[6],xmm5[7],xmm4[7]
; AVX-NEXT:    vpshufd {{.*#+}} xmm5 = xmm4[0,0,1,1]
; AVX-NEXT:    vpshufd {{.*#+}} xmm4 = xmm4[2,2,3,3]
; AVX-NEXT:    vinsertf128 $1, %xmm4, %ymm5, %ymm4
; AVX-NEXT:    vpunpckhwd {{.*#+}} xmm5 = xmm9[4],xmm10[4],xmm9[5],xmm10[5],xmm9[6],xmm10[6],xmm9[7],xmm10[7]
; AVX-NEXT:    vpmovzxdq {{.*#+}} xmm9 = xmm5[0],zero,xmm5[1],zero
; AVX-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[2,2,3,3]
; AVX-NEXT:    vinsertf128 $1, %xmm5, %ymm9, %ymm5
; AVX-NEXT:    vblendps {{.*#+}} ymm4 = ymm5[0],ymm4[1],ymm5[2],ymm4[3],ymm5[4],ymm4[5],ymm5[6],ymm4[7]
; AVX-NEXT:    vpunpcklwd {{.*#+}} xmm5 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; AVX-NEXT:    vpshufd {{.*#+}} xmm9 = xmm5[0,0,1,1]
; AVX-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[2,2,3,3]
; AVX-NEXT:    vinsertf128 $1, %xmm5, %ymm9, %ymm5
; AVX-NEXT:    vpunpcklwd {{.*#+}} xmm9 = xmm11[0],xmm12[0],xmm11[1],xmm12[1],xmm11[2],xmm12[2],xmm11[3],xmm12[3]
; AVX-NEXT:    vpmovzxdq {{.*#+}} xmm10 = xmm9[0],zero,xmm9[1],zero
; AVX-NEXT:    vpshufd {{.*#+}} xmm9 = xmm9[2,2,3,3]
; AVX-NEXT:    vinsertf128 $1, %xmm9, %ymm10, %ymm9
; AVX-NEXT:    vblendps {{.*#+}} ymm5 = ymm9[0],ymm5[1],ymm9[2],ymm5[3],ymm9[4],ymm5[5],ymm9[6],ymm5[7]
; AVX-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; AVX-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[0,0,1,1]
; AVX-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX-NEXT:    vpunpckhwd {{.*#+}} xmm1 = xmm11[4],xmm12[4],xmm11[5],xmm12[5],xmm11[6],xmm12[6],xmm11[7],xmm12[7]
; AVX-NEXT:    vpmovzxdq {{.*#+}} xmm9 = xmm1[0],zero,xmm1[1],zero
; AVX-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,2,3,3]
; AVX-NEXT:    vinsertf128 $1, %xmm1, %ymm9, %ymm1
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2],ymm0[3],ymm1[4],ymm0[5],ymm1[6],ymm0[7]
; AVX-NEXT:    vmovaps %ymm0, 96(%r8)
; AVX-NEXT:    vmovaps %ymm5, 64(%r8)
; AVX-NEXT:    vmovaps %ymm4, 160(%r8)
; AVX-NEXT:    vmovaps %ymm8, 128(%r8)
; AVX-NEXT:    vmovaps %ymm7, 224(%r8)
; AVX-NEXT:    vmovaps %ymm6, 192(%r8)
; AVX-NEXT:    vmovaps %ymm3, (%r8)
; AVX-NEXT:    vmovaps %ymm2, 32(%r8)
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retq
;
; AVX2-LABEL: store_i16_stride4_vf32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa (%rcx), %xmm3
; AVX2-NEXT:    vmovdqa 16(%rcx), %xmm0
; AVX2-NEXT:    vmovdqa 32(%rcx), %xmm4
; AVX2-NEXT:    vmovdqa 48(%rcx), %xmm7
; AVX2-NEXT:    vmovdqa (%rdx), %xmm6
; AVX2-NEXT:    vmovdqa 16(%rdx), %xmm1
; AVX2-NEXT:    vmovdqa 32(%rdx), %xmm5
; AVX2-NEXT:    vmovdqa 48(%rdx), %xmm8
; AVX2-NEXT:    vpunpckhwd {{.*#+}} xmm2 = xmm6[4],xmm3[4],xmm6[5],xmm3[5],xmm6[6],xmm3[6],xmm6[7],xmm3[7]
; AVX2-NEXT:    vpshufd {{.*#+}} xmm9 = xmm2[0,0,1,1]
; AVX2-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[2,2,3,3]
; AVX2-NEXT:    vinserti128 $1, %xmm2, %ymm9, %ymm2
; AVX2-NEXT:    vmovdqa (%rsi), %xmm9
; AVX2-NEXT:    vmovdqa (%rdi), %xmm10
; AVX2-NEXT:    vpunpckhwd {{.*#+}} xmm11 = xmm10[4],xmm9[4],xmm10[5],xmm9[5],xmm10[6],xmm9[6],xmm10[7],xmm9[7]
; AVX2-NEXT:    vpmovzxdq {{.*#+}} xmm12 = xmm11[0],zero,xmm11[1],zero
; AVX2-NEXT:    vpshufd {{.*#+}} xmm11 = xmm11[2,2,3,3]
; AVX2-NEXT:    vinserti128 $1, %xmm11, %ymm12, %ymm11
; AVX2-NEXT:    vmovdqa 48(%rsi), %xmm12
; AVX2-NEXT:    vpblendd {{.*#+}} ymm2 = ymm11[0],ymm2[1],ymm11[2],ymm2[3],ymm11[4],ymm2[5],ymm11[6],ymm2[7]
; AVX2-NEXT:    vmovdqa 48(%rdi), %xmm11
; AVX2-NEXT:    vpunpcklwd {{.*#+}} xmm3 = xmm6[0],xmm3[0],xmm6[1],xmm3[1],xmm6[2],xmm3[2],xmm6[3],xmm3[3]
; AVX2-NEXT:    vpshufd {{.*#+}} xmm6 = xmm3[0,0,1,1]
; AVX2-NEXT:    vpshufd {{.*#+}} xmm3 = xmm3[2,2,3,3]
; AVX2-NEXT:    vinserti128 $1, %xmm3, %ymm6, %ymm3
; AVX2-NEXT:    vpunpcklwd {{.*#+}} xmm6 = xmm10[0],xmm9[0],xmm10[1],xmm9[1],xmm10[2],xmm9[2],xmm10[3],xmm9[3]
; AVX2-NEXT:    vpmovzxdq {{.*#+}} xmm9 = xmm6[0],zero,xmm6[1],zero
; AVX2-NEXT:    vpshufd {{.*#+}} xmm6 = xmm6[2,2,3,3]
; AVX2-NEXT:    vinserti128 $1, %xmm6, %ymm9, %ymm6
; AVX2-NEXT:    vpblendd {{.*#+}} ymm3 = ymm6[0],ymm3[1],ymm6[2],ymm3[3],ymm6[4],ymm3[5],ymm6[6],ymm3[7]
; AVX2-NEXT:    vpunpcklwd {{.*#+}} xmm6 = xmm8[0],xmm7[0],xmm8[1],xmm7[1],xmm8[2],xmm7[2],xmm8[3],xmm7[3]
; AVX2-NEXT:    vpshufd {{.*#+}} xmm9 = xmm6[0,0,1,1]
; AVX2-NEXT:    vpshufd {{.*#+}} xmm6 = xmm6[2,2,3,3]
; AVX2-NEXT:    vinserti128 $1, %xmm6, %ymm9, %ymm6
; AVX2-NEXT:    vpunpcklwd {{.*#+}} xmm9 = xmm11[0],xmm12[0],xmm11[1],xmm12[1],xmm11[2],xmm12[2],xmm11[3],xmm12[3]
; AVX2-NEXT:    vpmovzxdq {{.*#+}} xmm10 = xmm9[0],zero,xmm9[1],zero
; AVX2-NEXT:    vpshufd {{.*#+}} xmm9 = xmm9[2,2,3,3]
; AVX2-NEXT:    vinserti128 $1, %xmm9, %ymm10, %ymm9
; AVX2-NEXT:    vmovdqa 32(%rsi), %xmm10
; AVX2-NEXT:    vpblendd {{.*#+}} ymm6 = ymm9[0],ymm6[1],ymm9[2],ymm6[3],ymm9[4],ymm6[5],ymm9[6],ymm6[7]
; AVX2-NEXT:    vmovdqa 32(%rdi), %xmm9
; AVX2-NEXT:    vpunpckhwd {{.*#+}} xmm7 = xmm8[4],xmm7[4],xmm8[5],xmm7[5],xmm8[6],xmm7[6],xmm8[7],xmm7[7]
; AVX2-NEXT:    vpshufd {{.*#+}} xmm8 = xmm7[0,0,1,1]
; AVX2-NEXT:    vpshufd {{.*#+}} xmm7 = xmm7[2,2,3,3]
; AVX2-NEXT:    vinserti128 $1, %xmm7, %ymm8, %ymm7
; AVX2-NEXT:    vpunpckhwd {{.*#+}} xmm8 = xmm11[4],xmm12[4],xmm11[5],xmm12[5],xmm11[6],xmm12[6],xmm11[7],xmm12[7]
; AVX2-NEXT:    vpmovzxdq {{.*#+}} xmm11 = xmm8[0],zero,xmm8[1],zero
; AVX2-NEXT:    vpshufd {{.*#+}} xmm8 = xmm8[2,2,3,3]
; AVX2-NEXT:    vinserti128 $1, %xmm8, %ymm11, %ymm8
; AVX2-NEXT:    vpblendd {{.*#+}} ymm7 = ymm8[0],ymm7[1],ymm8[2],ymm7[3],ymm8[4],ymm7[5],ymm8[6],ymm7[7]
; AVX2-NEXT:    vpunpcklwd {{.*#+}} xmm8 = xmm5[0],xmm4[0],xmm5[1],xmm4[1],xmm5[2],xmm4[2],xmm5[3],xmm4[3]
; AVX2-NEXT:    vpshufd {{.*#+}} xmm11 = xmm8[0,0,1,1]
; AVX2-NEXT:    vpshufd {{.*#+}} xmm8 = xmm8[2,2,3,3]
; AVX2-NEXT:    vinserti128 $1, %xmm8, %ymm11, %ymm8
; AVX2-NEXT:    vpunpcklwd {{.*#+}} xmm11 = xmm9[0],xmm10[0],xmm9[1],xmm10[1],xmm9[2],xmm10[2],xmm9[3],xmm10[3]
; AVX2-NEXT:    vpmovzxdq {{.*#+}} xmm12 = xmm11[0],zero,xmm11[1],zero
; AVX2-NEXT:    vpshufd {{.*#+}} xmm11 = xmm11[2,2,3,3]
; AVX2-NEXT:    vinserti128 $1, %xmm11, %ymm12, %ymm11
; AVX2-NEXT:    vmovdqa 16(%rsi), %xmm12
; AVX2-NEXT:    vpblendd {{.*#+}} ymm8 = ymm11[0],ymm8[1],ymm11[2],ymm8[3],ymm11[4],ymm8[5],ymm11[6],ymm8[7]
; AVX2-NEXT:    vmovdqa 16(%rdi), %xmm11
; AVX2-NEXT:    vpunpckhwd {{.*#+}} xmm4 = xmm5[4],xmm4[4],xmm5[5],xmm4[5],xmm5[6],xmm4[6],xmm5[7],xmm4[7]
; AVX2-NEXT:    vpshufd {{.*#+}} xmm5 = xmm4[0,0,1,1]
; AVX2-NEXT:    vpshufd {{.*#+}} xmm4 = xmm4[2,2,3,3]
; AVX2-NEXT:    vinserti128 $1, %xmm4, %ymm5, %ymm4
; AVX2-NEXT:    vpunpckhwd {{.*#+}} xmm5 = xmm9[4],xmm10[4],xmm9[5],xmm10[5],xmm9[6],xmm10[6],xmm9[7],xmm10[7]
; AVX2-NEXT:    vpmovzxdq {{.*#+}} xmm9 = xmm5[0],zero,xmm5[1],zero
; AVX2-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[2,2,3,3]
; AVX2-NEXT:    vinserti128 $1, %xmm5, %ymm9, %ymm5
; AVX2-NEXT:    vpblendd {{.*#+}} ymm4 = ymm5[0],ymm4[1],ymm5[2],ymm4[3],ymm5[4],ymm4[5],ymm5[6],ymm4[7]
; AVX2-NEXT:    vpunpcklwd {{.*#+}} xmm5 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; AVX2-NEXT:    vpshufd {{.*#+}} xmm9 = xmm5[0,0,1,1]
; AVX2-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[2,2,3,3]
; AVX2-NEXT:    vinserti128 $1, %xmm5, %ymm9, %ymm5
; AVX2-NEXT:    vpunpcklwd {{.*#+}} xmm9 = xmm11[0],xmm12[0],xmm11[1],xmm12[1],xmm11[2],xmm12[2],xmm11[3],xmm12[3]
; AVX2-NEXT:    vpmovzxdq {{.*#+}} xmm10 = xmm9[0],zero,xmm9[1],zero
; AVX2-NEXT:    vpshufd {{.*#+}} xmm9 = xmm9[2,2,3,3]
; AVX2-NEXT:    vinserti128 $1, %xmm9, %ymm10, %ymm9
; AVX2-NEXT:    vpblendd {{.*#+}} ymm5 = ymm9[0],ymm5[1],ymm9[2],ymm5[3],ymm9[4],ymm5[5],ymm9[6],ymm5[7]
; AVX2-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; AVX2-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[0,0,1,1]
; AVX2-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX2-NEXT:    vinserti128 $1, %xmm0, %ymm1, %ymm0
; AVX2-NEXT:    vpunpckhwd {{.*#+}} xmm1 = xmm11[4],xmm12[4],xmm11[5],xmm12[5],xmm11[6],xmm12[6],xmm11[7],xmm12[7]
; AVX2-NEXT:    vpmovzxdq {{.*#+}} xmm9 = xmm1[0],zero,xmm1[1],zero
; AVX2-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,2,3,3]
; AVX2-NEXT:    vinserti128 $1, %xmm1, %ymm9, %ymm1
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2],ymm0[3],ymm1[4],ymm0[5],ymm1[6],ymm0[7]
; AVX2-NEXT:    vmovdqa %ymm0, 96(%r8)
; AVX2-NEXT:    vmovdqa %ymm5, 64(%r8)
; AVX2-NEXT:    vmovdqa %ymm4, 160(%r8)
; AVX2-NEXT:    vmovdqa %ymm8, 128(%r8)
; AVX2-NEXT:    vmovdqa %ymm7, 224(%r8)
; AVX2-NEXT:    vmovdqa %ymm6, 192(%r8)
; AVX2-NEXT:    vmovdqa %ymm3, (%r8)
; AVX2-NEXT:    vmovdqa %ymm2, 32(%r8)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX2-FP-LABEL: store_i16_stride4_vf32:
; AVX2-FP:       # %bb.0:
; AVX2-FP-NEXT:    vmovdqa (%rcx), %xmm3
; AVX2-FP-NEXT:    vmovdqa 16(%rcx), %xmm0
; AVX2-FP-NEXT:    vmovdqa 32(%rcx), %xmm4
; AVX2-FP-NEXT:    vmovdqa 48(%rcx), %xmm7
; AVX2-FP-NEXT:    vmovdqa (%rdx), %xmm6
; AVX2-FP-NEXT:    vmovdqa 16(%rdx), %xmm1
; AVX2-FP-NEXT:    vmovdqa 32(%rdx), %xmm5
; AVX2-FP-NEXT:    vmovdqa 48(%rdx), %xmm8
; AVX2-FP-NEXT:    vpunpckhwd {{.*#+}} xmm2 = xmm6[4],xmm3[4],xmm6[5],xmm3[5],xmm6[6],xmm3[6],xmm6[7],xmm3[7]
; AVX2-FP-NEXT:    vpshufd {{.*#+}} xmm9 = xmm2[0,0,1,1]
; AVX2-FP-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[2,2,3,3]
; AVX2-FP-NEXT:    vinserti128 $1, %xmm2, %ymm9, %ymm2
; AVX2-FP-NEXT:    vmovdqa (%rsi), %xmm9
; AVX2-FP-NEXT:    vmovdqa (%rdi), %xmm10
; AVX2-FP-NEXT:    vpunpckhwd {{.*#+}} xmm11 = xmm10[4],xmm9[4],xmm10[5],xmm9[5],xmm10[6],xmm9[6],xmm10[7],xmm9[7]
; AVX2-FP-NEXT:    vpmovzxdq {{.*#+}} xmm12 = xmm11[0],zero,xmm11[1],zero
; AVX2-FP-NEXT:    vpshufd {{.*#+}} xmm11 = xmm11[2,2,3,3]
; AVX2-FP-NEXT:    vinserti128 $1, %xmm11, %ymm12, %ymm11
; AVX2-FP-NEXT:    vmovdqa 48(%rsi), %xmm12
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm2 = ymm11[0],ymm2[1],ymm11[2],ymm2[3],ymm11[4],ymm2[5],ymm11[6],ymm2[7]
; AVX2-FP-NEXT:    vmovdqa 48(%rdi), %xmm11
; AVX2-FP-NEXT:    vpunpcklwd {{.*#+}} xmm3 = xmm6[0],xmm3[0],xmm6[1],xmm3[1],xmm6[2],xmm3[2],xmm6[3],xmm3[3]
; AVX2-FP-NEXT:    vpshufd {{.*#+}} xmm6 = xmm3[0,0,1,1]
; AVX2-FP-NEXT:    vpshufd {{.*#+}} xmm3 = xmm3[2,2,3,3]
; AVX2-FP-NEXT:    vinserti128 $1, %xmm3, %ymm6, %ymm3
; AVX2-FP-NEXT:    vpunpcklwd {{.*#+}} xmm6 = xmm10[0],xmm9[0],xmm10[1],xmm9[1],xmm10[2],xmm9[2],xmm10[3],xmm9[3]
; AVX2-FP-NEXT:    vpmovzxdq {{.*#+}} xmm9 = xmm6[0],zero,xmm6[1],zero
; AVX2-FP-NEXT:    vpshufd {{.*#+}} xmm6 = xmm6[2,2,3,3]
; AVX2-FP-NEXT:    vinserti128 $1, %xmm6, %ymm9, %ymm6
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm3 = ymm6[0],ymm3[1],ymm6[2],ymm3[3],ymm6[4],ymm3[5],ymm6[6],ymm3[7]
; AVX2-FP-NEXT:    vpunpcklwd {{.*#+}} xmm6 = xmm8[0],xmm7[0],xmm8[1],xmm7[1],xmm8[2],xmm7[2],xmm8[3],xmm7[3]
; AVX2-FP-NEXT:    vpshufd {{.*#+}} xmm9 = xmm6[0,0,1,1]
; AVX2-FP-NEXT:    vpshufd {{.*#+}} xmm6 = xmm6[2,2,3,3]
; AVX2-FP-NEXT:    vinserti128 $1, %xmm6, %ymm9, %ymm6
; AVX2-FP-NEXT:    vpunpcklwd {{.*#+}} xmm9 = xmm11[0],xmm12[0],xmm11[1],xmm12[1],xmm11[2],xmm12[2],xmm11[3],xmm12[3]
; AVX2-FP-NEXT:    vpmovzxdq {{.*#+}} xmm10 = xmm9[0],zero,xmm9[1],zero
; AVX2-FP-NEXT:    vpshufd {{.*#+}} xmm9 = xmm9[2,2,3,3]
; AVX2-FP-NEXT:    vinserti128 $1, %xmm9, %ymm10, %ymm9
; AVX2-FP-NEXT:    vmovdqa 32(%rsi), %xmm10
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm6 = ymm9[0],ymm6[1],ymm9[2],ymm6[3],ymm9[4],ymm6[5],ymm9[6],ymm6[7]
; AVX2-FP-NEXT:    vmovdqa 32(%rdi), %xmm9
; AVX2-FP-NEXT:    vpunpckhwd {{.*#+}} xmm7 = xmm8[4],xmm7[4],xmm8[5],xmm7[5],xmm8[6],xmm7[6],xmm8[7],xmm7[7]
; AVX2-FP-NEXT:    vpshufd {{.*#+}} xmm8 = xmm7[0,0,1,1]
; AVX2-FP-NEXT:    vpshufd {{.*#+}} xmm7 = xmm7[2,2,3,3]
; AVX2-FP-NEXT:    vinserti128 $1, %xmm7, %ymm8, %ymm7
; AVX2-FP-NEXT:    vpunpckhwd {{.*#+}} xmm8 = xmm11[4],xmm12[4],xmm11[5],xmm12[5],xmm11[6],xmm12[6],xmm11[7],xmm12[7]
; AVX2-FP-NEXT:    vpmovzxdq {{.*#+}} xmm11 = xmm8[0],zero,xmm8[1],zero
; AVX2-FP-NEXT:    vpshufd {{.*#+}} xmm8 = xmm8[2,2,3,3]
; AVX2-FP-NEXT:    vinserti128 $1, %xmm8, %ymm11, %ymm8
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm7 = ymm8[0],ymm7[1],ymm8[2],ymm7[3],ymm8[4],ymm7[5],ymm8[6],ymm7[7]
; AVX2-FP-NEXT:    vpunpcklwd {{.*#+}} xmm8 = xmm5[0],xmm4[0],xmm5[1],xmm4[1],xmm5[2],xmm4[2],xmm5[3],xmm4[3]
; AVX2-FP-NEXT:    vpshufd {{.*#+}} xmm11 = xmm8[0,0,1,1]
; AVX2-FP-NEXT:    vpshufd {{.*#+}} xmm8 = xmm8[2,2,3,3]
; AVX2-FP-NEXT:    vinserti128 $1, %xmm8, %ymm11, %ymm8
; AVX2-FP-NEXT:    vpunpcklwd {{.*#+}} xmm11 = xmm9[0],xmm10[0],xmm9[1],xmm10[1],xmm9[2],xmm10[2],xmm9[3],xmm10[3]
; AVX2-FP-NEXT:    vpmovzxdq {{.*#+}} xmm12 = xmm11[0],zero,xmm11[1],zero
; AVX2-FP-NEXT:    vpshufd {{.*#+}} xmm11 = xmm11[2,2,3,3]
; AVX2-FP-NEXT:    vinserti128 $1, %xmm11, %ymm12, %ymm11
; AVX2-FP-NEXT:    vmovdqa 16(%rsi), %xmm12
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm8 = ymm11[0],ymm8[1],ymm11[2],ymm8[3],ymm11[4],ymm8[5],ymm11[6],ymm8[7]
; AVX2-FP-NEXT:    vmovdqa 16(%rdi), %xmm11
; AVX2-FP-NEXT:    vpunpckhwd {{.*#+}} xmm4 = xmm5[4],xmm4[4],xmm5[5],xmm4[5],xmm5[6],xmm4[6],xmm5[7],xmm4[7]
; AVX2-FP-NEXT:    vpshufd {{.*#+}} xmm5 = xmm4[0,0,1,1]
; AVX2-FP-NEXT:    vpshufd {{.*#+}} xmm4 = xmm4[2,2,3,3]
; AVX2-FP-NEXT:    vinserti128 $1, %xmm4, %ymm5, %ymm4
; AVX2-FP-NEXT:    vpunpckhwd {{.*#+}} xmm5 = xmm9[4],xmm10[4],xmm9[5],xmm10[5],xmm9[6],xmm10[6],xmm9[7],xmm10[7]
; AVX2-FP-NEXT:    vpmovzxdq {{.*#+}} xmm9 = xmm5[0],zero,xmm5[1],zero
; AVX2-FP-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[2,2,3,3]
; AVX2-FP-NEXT:    vinserti128 $1, %xmm5, %ymm9, %ymm5
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm4 = ymm5[0],ymm4[1],ymm5[2],ymm4[3],ymm5[4],ymm4[5],ymm5[6],ymm4[7]
; AVX2-FP-NEXT:    vpunpcklwd {{.*#+}} xmm5 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; AVX2-FP-NEXT:    vpshufd {{.*#+}} xmm9 = xmm5[0,0,1,1]
; AVX2-FP-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[2,2,3,3]
; AVX2-FP-NEXT:    vinserti128 $1, %xmm5, %ymm9, %ymm5
; AVX2-FP-NEXT:    vpunpcklwd {{.*#+}} xmm9 = xmm11[0],xmm12[0],xmm11[1],xmm12[1],xmm11[2],xmm12[2],xmm11[3],xmm12[3]
; AVX2-FP-NEXT:    vpmovzxdq {{.*#+}} xmm10 = xmm9[0],zero,xmm9[1],zero
; AVX2-FP-NEXT:    vpshufd {{.*#+}} xmm9 = xmm9[2,2,3,3]
; AVX2-FP-NEXT:    vinserti128 $1, %xmm9, %ymm10, %ymm9
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm5 = ymm9[0],ymm5[1],ymm9[2],ymm5[3],ymm9[4],ymm5[5],ymm9[6],ymm5[7]
; AVX2-FP-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; AVX2-FP-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[0,0,1,1]
; AVX2-FP-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX2-FP-NEXT:    vinserti128 $1, %xmm0, %ymm1, %ymm0
; AVX2-FP-NEXT:    vpunpckhwd {{.*#+}} xmm1 = xmm11[4],xmm12[4],xmm11[5],xmm12[5],xmm11[6],xmm12[6],xmm11[7],xmm12[7]
; AVX2-FP-NEXT:    vpmovzxdq {{.*#+}} xmm9 = xmm1[0],zero,xmm1[1],zero
; AVX2-FP-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,2,3,3]
; AVX2-FP-NEXT:    vinserti128 $1, %xmm1, %ymm9, %ymm1
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2],ymm0[3],ymm1[4],ymm0[5],ymm1[6],ymm0[7]
; AVX2-FP-NEXT:    vmovdqa %ymm0, 96(%r8)
; AVX2-FP-NEXT:    vmovdqa %ymm5, 64(%r8)
; AVX2-FP-NEXT:    vmovdqa %ymm4, 160(%r8)
; AVX2-FP-NEXT:    vmovdqa %ymm8, 128(%r8)
; AVX2-FP-NEXT:    vmovdqa %ymm7, 224(%r8)
; AVX2-FP-NEXT:    vmovdqa %ymm6, 192(%r8)
; AVX2-FP-NEXT:    vmovdqa %ymm3, (%r8)
; AVX2-FP-NEXT:    vmovdqa %ymm2, 32(%r8)
; AVX2-FP-NEXT:    vzeroupper
; AVX2-FP-NEXT:    retq
;
; AVX2-FCP-LABEL: store_i16_stride4_vf32:
; AVX2-FCP:       # %bb.0:
; AVX2-FCP-NEXT:    vmovdqa (%rsi), %xmm5
; AVX2-FCP-NEXT:    vmovdqa 16(%rsi), %xmm0
; AVX2-FCP-NEXT:    vmovdqa 32(%rsi), %xmm4
; AVX2-FCP-NEXT:    vmovdqa 48(%rsi), %xmm8
; AVX2-FCP-NEXT:    vmovdqa (%rdi), %xmm7
; AVX2-FCP-NEXT:    vmovdqa 16(%rdi), %xmm1
; AVX2-FCP-NEXT:    vmovdqa 32(%rdi), %xmm6
; AVX2-FCP-NEXT:    vmovdqa 48(%rdi), %xmm9
; AVX2-FCP-NEXT:    vpunpckhwd {{.*#+}} xmm2 = xmm7[4],xmm5[4],xmm7[5],xmm5[5],xmm7[6],xmm5[6],xmm7[7],xmm5[7]
; AVX2-FCP-NEXT:    vpmovzxdq {{.*#+}} xmm3 = xmm2[0],zero,xmm2[1],zero
; AVX2-FCP-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[2,2,3,3]
; AVX2-FCP-NEXT:    vinserti128 $1, %xmm2, %ymm3, %ymm2
; AVX2-FCP-NEXT:    vmovdqa (%rcx), %xmm10
; AVX2-FCP-NEXT:    vmovdqa (%rdx), %xmm11
; AVX2-FCP-NEXT:    vpunpckhwd {{.*#+}} xmm12 = xmm11[4],xmm10[4],xmm11[5],xmm10[5],xmm11[6],xmm10[6],xmm11[7],xmm10[7]
; AVX2-FCP-NEXT:    vpmovsxbd {{.*#+}} ymm3 = [0,0,1,1,2,2,3,3]
; AVX2-FCP-NEXT:    vpermd %ymm12, %ymm3, %ymm12
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm2 = ymm2[0],ymm12[1],ymm2[2],ymm12[3],ymm2[4],ymm12[5],ymm2[6],ymm12[7]
; AVX2-FCP-NEXT:    vmovdqa 48(%rcx), %xmm12
; AVX2-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm5 = xmm7[0],xmm5[0],xmm7[1],xmm5[1],xmm7[2],xmm5[2],xmm7[3],xmm5[3]
; AVX2-FCP-NEXT:    vpmovzxdq {{.*#+}} xmm7 = xmm5[0],zero,xmm5[1],zero
; AVX2-FCP-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[2,2,3,3]
; AVX2-FCP-NEXT:    vinserti128 $1, %xmm5, %ymm7, %ymm5
; AVX2-FCP-NEXT:    vmovdqa 48(%rdx), %xmm13
; AVX2-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm7 = xmm11[0],xmm10[0],xmm11[1],xmm10[1],xmm11[2],xmm10[2],xmm11[3],xmm10[3]
; AVX2-FCP-NEXT:    vpermd %ymm7, %ymm3, %ymm7
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm5 = ymm5[0],ymm7[1],ymm5[2],ymm7[3],ymm5[4],ymm7[5],ymm5[6],ymm7[7]
; AVX2-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm7 = xmm9[0],xmm8[0],xmm9[1],xmm8[1],xmm9[2],xmm8[2],xmm9[3],xmm8[3]
; AVX2-FCP-NEXT:    vpmovzxdq {{.*#+}} xmm10 = xmm7[0],zero,xmm7[1],zero
; AVX2-FCP-NEXT:    vpshufd {{.*#+}} xmm7 = xmm7[2,2,3,3]
; AVX2-FCP-NEXT:    vinserti128 $1, %xmm7, %ymm10, %ymm7
; AVX2-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm10 = xmm13[0],xmm12[0],xmm13[1],xmm12[1],xmm13[2],xmm12[2],xmm13[3],xmm12[3]
; AVX2-FCP-NEXT:    vpermd %ymm10, %ymm3, %ymm10
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm7 = ymm7[0],ymm10[1],ymm7[2],ymm10[3],ymm7[4],ymm10[5],ymm7[6],ymm10[7]
; AVX2-FCP-NEXT:    vmovdqa 32(%rcx), %xmm10
; AVX2-FCP-NEXT:    vpunpckhwd {{.*#+}} xmm8 = xmm9[4],xmm8[4],xmm9[5],xmm8[5],xmm9[6],xmm8[6],xmm9[7],xmm8[7]
; AVX2-FCP-NEXT:    vpmovzxdq {{.*#+}} xmm9 = xmm8[0],zero,xmm8[1],zero
; AVX2-FCP-NEXT:    vpshufd {{.*#+}} xmm8 = xmm8[2,2,3,3]
; AVX2-FCP-NEXT:    vinserti128 $1, %xmm8, %ymm9, %ymm8
; AVX2-FCP-NEXT:    vmovdqa 32(%rdx), %xmm11
; AVX2-FCP-NEXT:    vpunpckhwd {{.*#+}} xmm9 = xmm13[4],xmm12[4],xmm13[5],xmm12[5],xmm13[6],xmm12[6],xmm13[7],xmm12[7]
; AVX2-FCP-NEXT:    vpermd %ymm9, %ymm3, %ymm9
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm8 = ymm8[0],ymm9[1],ymm8[2],ymm9[3],ymm8[4],ymm9[5],ymm8[6],ymm9[7]
; AVX2-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm9 = xmm6[0],xmm4[0],xmm6[1],xmm4[1],xmm6[2],xmm4[2],xmm6[3],xmm4[3]
; AVX2-FCP-NEXT:    vpmovzxdq {{.*#+}} xmm12 = xmm9[0],zero,xmm9[1],zero
; AVX2-FCP-NEXT:    vpshufd {{.*#+}} xmm9 = xmm9[2,2,3,3]
; AVX2-FCP-NEXT:    vinserti128 $1, %xmm9, %ymm12, %ymm9
; AVX2-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm12 = xmm11[0],xmm10[0],xmm11[1],xmm10[1],xmm11[2],xmm10[2],xmm11[3],xmm10[3]
; AVX2-FCP-NEXT:    vpermd %ymm12, %ymm3, %ymm12
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm9 = ymm9[0],ymm12[1],ymm9[2],ymm12[3],ymm9[4],ymm12[5],ymm9[6],ymm12[7]
; AVX2-FCP-NEXT:    vmovdqa 16(%rcx), %xmm12
; AVX2-FCP-NEXT:    vpunpckhwd {{.*#+}} xmm4 = xmm6[4],xmm4[4],xmm6[5],xmm4[5],xmm6[6],xmm4[6],xmm6[7],xmm4[7]
; AVX2-FCP-NEXT:    vpmovzxdq {{.*#+}} xmm6 = xmm4[0],zero,xmm4[1],zero
; AVX2-FCP-NEXT:    vpshufd {{.*#+}} xmm4 = xmm4[2,2,3,3]
; AVX2-FCP-NEXT:    vinserti128 $1, %xmm4, %ymm6, %ymm4
; AVX2-FCP-NEXT:    vmovdqa 16(%rdx), %xmm6
; AVX2-FCP-NEXT:    vpunpckhwd {{.*#+}} xmm10 = xmm11[4],xmm10[4],xmm11[5],xmm10[5],xmm11[6],xmm10[6],xmm11[7],xmm10[7]
; AVX2-FCP-NEXT:    vpermd %ymm10, %ymm3, %ymm10
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm4 = ymm4[0],ymm10[1],ymm4[2],ymm10[3],ymm4[4],ymm10[5],ymm4[6],ymm10[7]
; AVX2-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm10 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; AVX2-FCP-NEXT:    vpmovzxdq {{.*#+}} xmm11 = xmm10[0],zero,xmm10[1],zero
; AVX2-FCP-NEXT:    vpshufd {{.*#+}} xmm10 = xmm10[2,2,3,3]
; AVX2-FCP-NEXT:    vinserti128 $1, %xmm10, %ymm11, %ymm10
; AVX2-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm11 = xmm6[0],xmm12[0],xmm6[1],xmm12[1],xmm6[2],xmm12[2],xmm6[3],xmm12[3]
; AVX2-FCP-NEXT:    vpermd %ymm11, %ymm3, %ymm11
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm10 = ymm10[0],ymm11[1],ymm10[2],ymm11[3],ymm10[4],ymm11[5],ymm10[6],ymm11[7]
; AVX2-FCP-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; AVX2-FCP-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm0[0],zero,xmm0[1],zero
; AVX2-FCP-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX2-FCP-NEXT:    vinserti128 $1, %xmm0, %ymm1, %ymm0
; AVX2-FCP-NEXT:    vpunpckhwd {{.*#+}} xmm1 = xmm6[4],xmm12[4],xmm6[5],xmm12[5],xmm6[6],xmm12[6],xmm6[7],xmm12[7]
; AVX2-FCP-NEXT:    vpermd %ymm1, %ymm3, %ymm1
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2],ymm1[3],ymm0[4],ymm1[5],ymm0[6],ymm1[7]
; AVX2-FCP-NEXT:    vmovdqa %ymm0, 96(%r8)
; AVX2-FCP-NEXT:    vmovdqa %ymm10, 64(%r8)
; AVX2-FCP-NEXT:    vmovdqa %ymm4, 160(%r8)
; AVX2-FCP-NEXT:    vmovdqa %ymm9, 128(%r8)
; AVX2-FCP-NEXT:    vmovdqa %ymm8, 224(%r8)
; AVX2-FCP-NEXT:    vmovdqa %ymm7, 192(%r8)
; AVX2-FCP-NEXT:    vmovdqa %ymm5, (%r8)
; AVX2-FCP-NEXT:    vmovdqa %ymm2, 32(%r8)
; AVX2-FCP-NEXT:    vzeroupper
; AVX2-FCP-NEXT:    retq
;
; AVX512-LABEL: store_i16_stride4_vf32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa (%rsi), %xmm0
; AVX512-NEXT:    vmovdqa 16(%rsi), %xmm1
; AVX512-NEXT:    vmovdqa 32(%rsi), %xmm10
; AVX512-NEXT:    vmovdqa 48(%rsi), %xmm6
; AVX512-NEXT:    vmovdqa (%rdi), %xmm2
; AVX512-NEXT:    vmovdqa 16(%rdi), %xmm3
; AVX512-NEXT:    vmovdqa 32(%rdi), %xmm11
; AVX512-NEXT:    vmovdqa 48(%rdi), %xmm7
; AVX512-NEXT:    vpunpckhwd {{.*#+}} xmm4 = xmm3[4],xmm1[4],xmm3[5],xmm1[5],xmm3[6],xmm1[6],xmm3[7],xmm1[7]
; AVX512-NEXT:    vpmovzxdq {{.*#+}} xmm5 = xmm4[0],zero,xmm4[1],zero
; AVX512-NEXT:    vpshufd {{.*#+}} xmm4 = xmm4[2,2,3,3]
; AVX512-NEXT:    vinserti128 $1, %xmm4, %ymm5, %ymm4
; AVX512-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm3[0],xmm1[0],xmm3[1],xmm1[1],xmm3[2],xmm1[2],xmm3[3],xmm1[3]
; AVX512-NEXT:    vpmovzxdq {{.*#+}} xmm3 = xmm1[0],zero,xmm1[1],zero
; AVX512-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,2,3,3]
; AVX512-NEXT:    vinserti128 $1, %xmm1, %ymm3, %ymm1
; AVX512-NEXT:    vinserti64x4 $1, %ymm4, %zmm1, %zmm1
; AVX512-NEXT:    vmovdqa (%rcx), %xmm3
; AVX512-NEXT:    vmovdqa 16(%rcx), %xmm5
; AVX512-NEXT:    vmovdqa 32(%rcx), %xmm12
; AVX512-NEXT:    vmovdqa 48(%rcx), %xmm8
; AVX512-NEXT:    vmovdqa (%rdx), %xmm4
; AVX512-NEXT:    vmovdqa 16(%rdx), %xmm13
; AVX512-NEXT:    vmovdqa 32(%rdx), %xmm14
; AVX512-NEXT:    vmovdqa 48(%rdx), %xmm9
; AVX512-NEXT:    vpunpckhwd {{.*#+}} xmm15 = xmm13[4],xmm5[4],xmm13[5],xmm5[5],xmm13[6],xmm5[6],xmm13[7],xmm5[7]
; AVX512-NEXT:    vpunpcklwd {{.*#+}} xmm13 = xmm13[0],xmm5[0],xmm13[1],xmm5[1],xmm13[2],xmm5[2],xmm13[3],xmm5[3]
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm5 = [0,0,1,1,2,2,3,3,16,16,17,17,18,18,19,19]
; AVX512-NEXT:    vpermt2d %zmm15, %zmm5, %zmm13
; AVX512-NEXT:    movw $-21846, %ax # imm = 0xAAAA
; AVX512-NEXT:    kmovw %eax, %k1
; AVX512-NEXT:    vmovdqa32 %zmm13, %zmm1 {%k1}
; AVX512-NEXT:    vpunpckhwd {{.*#+}} xmm13 = xmm11[4],xmm10[4],xmm11[5],xmm10[5],xmm11[6],xmm10[6],xmm11[7],xmm10[7]
; AVX512-NEXT:    vpmovzxdq {{.*#+}} xmm15 = xmm13[0],zero,xmm13[1],zero
; AVX512-NEXT:    vpshufd {{.*#+}} xmm13 = xmm13[2,2,3,3]
; AVX512-NEXT:    vinserti128 $1, %xmm13, %ymm15, %ymm13
; AVX512-NEXT:    vpunpcklwd {{.*#+}} xmm10 = xmm11[0],xmm10[0],xmm11[1],xmm10[1],xmm11[2],xmm10[2],xmm11[3],xmm10[3]
; AVX512-NEXT:    vpmovzxdq {{.*#+}} xmm11 = xmm10[0],zero,xmm10[1],zero
; AVX512-NEXT:    vpshufd {{.*#+}} xmm10 = xmm10[2,2,3,3]
; AVX512-NEXT:    vinserti128 $1, %xmm10, %ymm11, %ymm10
; AVX512-NEXT:    vinserti64x4 $1, %ymm13, %zmm10, %zmm10
; AVX512-NEXT:    vpunpckhwd {{.*#+}} xmm11 = xmm14[4],xmm12[4],xmm14[5],xmm12[5],xmm14[6],xmm12[6],xmm14[7],xmm12[7]
; AVX512-NEXT:    vpunpcklwd {{.*#+}} xmm12 = xmm14[0],xmm12[0],xmm14[1],xmm12[1],xmm14[2],xmm12[2],xmm14[3],xmm12[3]
; AVX512-NEXT:    vpermt2d %zmm11, %zmm5, %zmm12
; AVX512-NEXT:    vmovdqa32 %zmm12, %zmm10 {%k1}
; AVX512-NEXT:    vpunpckhwd {{.*#+}} xmm11 = xmm7[4],xmm6[4],xmm7[5],xmm6[5],xmm7[6],xmm6[6],xmm7[7],xmm6[7]
; AVX512-NEXT:    vpmovzxdq {{.*#+}} xmm12 = xmm11[0],zero,xmm11[1],zero
; AVX512-NEXT:    vpshufd {{.*#+}} xmm11 = xmm11[2,2,3,3]
; AVX512-NEXT:    vinserti128 $1, %xmm11, %ymm12, %ymm11
; AVX512-NEXT:    vpunpcklwd {{.*#+}} xmm6 = xmm7[0],xmm6[0],xmm7[1],xmm6[1],xmm7[2],xmm6[2],xmm7[3],xmm6[3]
; AVX512-NEXT:    vpmovzxdq {{.*#+}} xmm7 = xmm6[0],zero,xmm6[1],zero
; AVX512-NEXT:    vpshufd {{.*#+}} xmm6 = xmm6[2,2,3,3]
; AVX512-NEXT:    vinserti128 $1, %xmm6, %ymm7, %ymm6
; AVX512-NEXT:    vinserti64x4 $1, %ymm11, %zmm6, %zmm6
; AVX512-NEXT:    vpunpckhwd {{.*#+}} xmm7 = xmm9[4],xmm8[4],xmm9[5],xmm8[5],xmm9[6],xmm8[6],xmm9[7],xmm8[7]
; AVX512-NEXT:    vpunpcklwd {{.*#+}} xmm8 = xmm9[0],xmm8[0],xmm9[1],xmm8[1],xmm9[2],xmm8[2],xmm9[3],xmm8[3]
; AVX512-NEXT:    vpermt2d %zmm7, %zmm5, %zmm8
; AVX512-NEXT:    vmovdqa32 %zmm8, %zmm6 {%k1}
; AVX512-NEXT:    vpunpckhwd {{.*#+}} xmm7 = xmm2[4],xmm0[4],xmm2[5],xmm0[5],xmm2[6],xmm0[6],xmm2[7],xmm0[7]
; AVX512-NEXT:    vpmovzxdq {{.*#+}} xmm8 = xmm7[0],zero,xmm7[1],zero
; AVX512-NEXT:    vpshufd {{.*#+}} xmm7 = xmm7[2,2,3,3]
; AVX512-NEXT:    vinserti128 $1, %xmm7, %ymm8, %ymm7
; AVX512-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm2[0],xmm0[0],xmm2[1],xmm0[1],xmm2[2],xmm0[2],xmm2[3],xmm0[3]
; AVX512-NEXT:    vpmovzxdq {{.*#+}} xmm2 = xmm0[0],zero,xmm0[1],zero
; AVX512-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX512-NEXT:    vinserti128 $1, %xmm0, %ymm2, %ymm0
; AVX512-NEXT:    vinserti64x4 $1, %ymm7, %zmm0, %zmm0
; AVX512-NEXT:    vpunpckhwd {{.*#+}} xmm2 = xmm4[4],xmm3[4],xmm4[5],xmm3[5],xmm4[6],xmm3[6],xmm4[7],xmm3[7]
; AVX512-NEXT:    vpunpcklwd {{.*#+}} xmm3 = xmm4[0],xmm3[0],xmm4[1],xmm3[1],xmm4[2],xmm3[2],xmm4[3],xmm3[3]
; AVX512-NEXT:    vpermt2d %zmm2, %zmm5, %zmm3
; AVX512-NEXT:    vmovdqa32 %zmm3, %zmm0 {%k1}
; AVX512-NEXT:    vmovdqa64 %zmm0, (%r8)
; AVX512-NEXT:    vmovdqa64 %zmm6, 192(%r8)
; AVX512-NEXT:    vmovdqa64 %zmm10, 128(%r8)
; AVX512-NEXT:    vmovdqa64 %zmm1, 64(%r8)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
;
; AVX512-FCP-LABEL: store_i16_stride4_vf32:
; AVX512-FCP:       # %bb.0:
; AVX512-FCP-NEXT:    vmovdqa (%rsi), %xmm0
; AVX512-FCP-NEXT:    vmovdqa 16(%rsi), %xmm1
; AVX512-FCP-NEXT:    vmovdqa 32(%rsi), %xmm10
; AVX512-FCP-NEXT:    vmovdqa 48(%rsi), %xmm6
; AVX512-FCP-NEXT:    vmovdqa (%rdi), %xmm2
; AVX512-FCP-NEXT:    vmovdqa 16(%rdi), %xmm3
; AVX512-FCP-NEXT:    vmovdqa 32(%rdi), %xmm11
; AVX512-FCP-NEXT:    vmovdqa 48(%rdi), %xmm7
; AVX512-FCP-NEXT:    vpunpckhwd {{.*#+}} xmm4 = xmm3[4],xmm1[4],xmm3[5],xmm1[5],xmm3[6],xmm1[6],xmm3[7],xmm1[7]
; AVX512-FCP-NEXT:    vpmovzxdq {{.*#+}} xmm5 = xmm4[0],zero,xmm4[1],zero
; AVX512-FCP-NEXT:    vpshufd {{.*#+}} xmm4 = xmm4[2,2,3,3]
; AVX512-FCP-NEXT:    vinserti128 $1, %xmm4, %ymm5, %ymm4
; AVX512-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm3[0],xmm1[0],xmm3[1],xmm1[1],xmm3[2],xmm1[2],xmm3[3],xmm1[3]
; AVX512-FCP-NEXT:    vpmovzxdq {{.*#+}} xmm3 = xmm1[0],zero,xmm1[1],zero
; AVX512-FCP-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,2,3,3]
; AVX512-FCP-NEXT:    vinserti128 $1, %xmm1, %ymm3, %ymm1
; AVX512-FCP-NEXT:    vinserti64x4 $1, %ymm4, %zmm1, %zmm1
; AVX512-FCP-NEXT:    vmovdqa (%rcx), %xmm3
; AVX512-FCP-NEXT:    vmovdqa 16(%rcx), %xmm5
; AVX512-FCP-NEXT:    vmovdqa 32(%rcx), %xmm12
; AVX512-FCP-NEXT:    vmovdqa 48(%rcx), %xmm8
; AVX512-FCP-NEXT:    vmovdqa (%rdx), %xmm4
; AVX512-FCP-NEXT:    vmovdqa 16(%rdx), %xmm13
; AVX512-FCP-NEXT:    vmovdqa 32(%rdx), %xmm14
; AVX512-FCP-NEXT:    vmovdqa 48(%rdx), %xmm9
; AVX512-FCP-NEXT:    vpunpckhwd {{.*#+}} xmm15 = xmm13[4],xmm5[4],xmm13[5],xmm5[5],xmm13[6],xmm5[6],xmm13[7],xmm5[7]
; AVX512-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm13 = xmm13[0],xmm5[0],xmm13[1],xmm5[1],xmm13[2],xmm5[2],xmm13[3],xmm5[3]
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm5 = [0,0,1,1,2,2,3,3,16,16,17,17,18,18,19,19]
; AVX512-FCP-NEXT:    vpermt2d %zmm15, %zmm5, %zmm13
; AVX512-FCP-NEXT:    movw $-21846, %ax # imm = 0xAAAA
; AVX512-FCP-NEXT:    kmovw %eax, %k1
; AVX512-FCP-NEXT:    vmovdqa32 %zmm13, %zmm1 {%k1}
; AVX512-FCP-NEXT:    vpunpckhwd {{.*#+}} xmm13 = xmm11[4],xmm10[4],xmm11[5],xmm10[5],xmm11[6],xmm10[6],xmm11[7],xmm10[7]
; AVX512-FCP-NEXT:    vpmovzxdq {{.*#+}} xmm15 = xmm13[0],zero,xmm13[1],zero
; AVX512-FCP-NEXT:    vpshufd {{.*#+}} xmm13 = xmm13[2,2,3,3]
; AVX512-FCP-NEXT:    vinserti128 $1, %xmm13, %ymm15, %ymm13
; AVX512-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm10 = xmm11[0],xmm10[0],xmm11[1],xmm10[1],xmm11[2],xmm10[2],xmm11[3],xmm10[3]
; AVX512-FCP-NEXT:    vpmovzxdq {{.*#+}} xmm11 = xmm10[0],zero,xmm10[1],zero
; AVX512-FCP-NEXT:    vpshufd {{.*#+}} xmm10 = xmm10[2,2,3,3]
; AVX512-FCP-NEXT:    vinserti128 $1, %xmm10, %ymm11, %ymm10
; AVX512-FCP-NEXT:    vinserti64x4 $1, %ymm13, %zmm10, %zmm10
; AVX512-FCP-NEXT:    vpunpckhwd {{.*#+}} xmm11 = xmm14[4],xmm12[4],xmm14[5],xmm12[5],xmm14[6],xmm12[6],xmm14[7],xmm12[7]
; AVX512-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm12 = xmm14[0],xmm12[0],xmm14[1],xmm12[1],xmm14[2],xmm12[2],xmm14[3],xmm12[3]
; AVX512-FCP-NEXT:    vpermt2d %zmm11, %zmm5, %zmm12
; AVX512-FCP-NEXT:    vmovdqa32 %zmm12, %zmm10 {%k1}
; AVX512-FCP-NEXT:    vpunpckhwd {{.*#+}} xmm11 = xmm7[4],xmm6[4],xmm7[5],xmm6[5],xmm7[6],xmm6[6],xmm7[7],xmm6[7]
; AVX512-FCP-NEXT:    vpmovzxdq {{.*#+}} xmm12 = xmm11[0],zero,xmm11[1],zero
; AVX512-FCP-NEXT:    vpshufd {{.*#+}} xmm11 = xmm11[2,2,3,3]
; AVX512-FCP-NEXT:    vinserti128 $1, %xmm11, %ymm12, %ymm11
; AVX512-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm6 = xmm7[0],xmm6[0],xmm7[1],xmm6[1],xmm7[2],xmm6[2],xmm7[3],xmm6[3]
; AVX512-FCP-NEXT:    vpmovzxdq {{.*#+}} xmm7 = xmm6[0],zero,xmm6[1],zero
; AVX512-FCP-NEXT:    vpshufd {{.*#+}} xmm6 = xmm6[2,2,3,3]
; AVX512-FCP-NEXT:    vinserti128 $1, %xmm6, %ymm7, %ymm6
; AVX512-FCP-NEXT:    vinserti64x4 $1, %ymm11, %zmm6, %zmm6
; AVX512-FCP-NEXT:    vpunpckhwd {{.*#+}} xmm7 = xmm9[4],xmm8[4],xmm9[5],xmm8[5],xmm9[6],xmm8[6],xmm9[7],xmm8[7]
; AVX512-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm8 = xmm9[0],xmm8[0],xmm9[1],xmm8[1],xmm9[2],xmm8[2],xmm9[3],xmm8[3]
; AVX512-FCP-NEXT:    vpermt2d %zmm7, %zmm5, %zmm8
; AVX512-FCP-NEXT:    vmovdqa32 %zmm8, %zmm6 {%k1}
; AVX512-FCP-NEXT:    vpunpckhwd {{.*#+}} xmm7 = xmm2[4],xmm0[4],xmm2[5],xmm0[5],xmm2[6],xmm0[6],xmm2[7],xmm0[7]
; AVX512-FCP-NEXT:    vpmovzxdq {{.*#+}} xmm8 = xmm7[0],zero,xmm7[1],zero
; AVX512-FCP-NEXT:    vpshufd {{.*#+}} xmm7 = xmm7[2,2,3,3]
; AVX512-FCP-NEXT:    vinserti128 $1, %xmm7, %ymm8, %ymm7
; AVX512-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm2[0],xmm0[0],xmm2[1],xmm0[1],xmm2[2],xmm0[2],xmm2[3],xmm0[3]
; AVX512-FCP-NEXT:    vpmovzxdq {{.*#+}} xmm2 = xmm0[0],zero,xmm0[1],zero
; AVX512-FCP-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX512-FCP-NEXT:    vinserti128 $1, %xmm0, %ymm2, %ymm0
; AVX512-FCP-NEXT:    vinserti64x4 $1, %ymm7, %zmm0, %zmm0
; AVX512-FCP-NEXT:    vpunpckhwd {{.*#+}} xmm2 = xmm4[4],xmm3[4],xmm4[5],xmm3[5],xmm4[6],xmm3[6],xmm4[7],xmm3[7]
; AVX512-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm3 = xmm4[0],xmm3[0],xmm4[1],xmm3[1],xmm4[2],xmm3[2],xmm4[3],xmm3[3]
; AVX512-FCP-NEXT:    vpermt2d %zmm2, %zmm5, %zmm3
; AVX512-FCP-NEXT:    vmovdqa32 %zmm3, %zmm0 {%k1}
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, (%r8)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm6, 192(%r8)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm10, 128(%r8)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm1, 64(%r8)
; AVX512-FCP-NEXT:    vzeroupper
; AVX512-FCP-NEXT:    retq
;
; AVX512DQ-LABEL: store_i16_stride4_vf32:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vmovdqa (%rsi), %xmm0
; AVX512DQ-NEXT:    vmovdqa 16(%rsi), %xmm1
; AVX512DQ-NEXT:    vmovdqa 32(%rsi), %xmm10
; AVX512DQ-NEXT:    vmovdqa 48(%rsi), %xmm6
; AVX512DQ-NEXT:    vmovdqa (%rdi), %xmm2
; AVX512DQ-NEXT:    vmovdqa 16(%rdi), %xmm3
; AVX512DQ-NEXT:    vmovdqa 32(%rdi), %xmm11
; AVX512DQ-NEXT:    vmovdqa 48(%rdi), %xmm7
; AVX512DQ-NEXT:    vpunpckhwd {{.*#+}} xmm4 = xmm3[4],xmm1[4],xmm3[5],xmm1[5],xmm3[6],xmm1[6],xmm3[7],xmm1[7]
; AVX512DQ-NEXT:    vpmovzxdq {{.*#+}} xmm5 = xmm4[0],zero,xmm4[1],zero
; AVX512DQ-NEXT:    vpshufd {{.*#+}} xmm4 = xmm4[2,2,3,3]
; AVX512DQ-NEXT:    vinserti128 $1, %xmm4, %ymm5, %ymm4
; AVX512DQ-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm3[0],xmm1[0],xmm3[1],xmm1[1],xmm3[2],xmm1[2],xmm3[3],xmm1[3]
; AVX512DQ-NEXT:    vpmovzxdq {{.*#+}} xmm3 = xmm1[0],zero,xmm1[1],zero
; AVX512DQ-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,2,3,3]
; AVX512DQ-NEXT:    vinserti128 $1, %xmm1, %ymm3, %ymm1
; AVX512DQ-NEXT:    vinserti64x4 $1, %ymm4, %zmm1, %zmm1
; AVX512DQ-NEXT:    vmovdqa (%rcx), %xmm3
; AVX512DQ-NEXT:    vmovdqa 16(%rcx), %xmm5
; AVX512DQ-NEXT:    vmovdqa 32(%rcx), %xmm12
; AVX512DQ-NEXT:    vmovdqa 48(%rcx), %xmm8
; AVX512DQ-NEXT:    vmovdqa (%rdx), %xmm4
; AVX512DQ-NEXT:    vmovdqa 16(%rdx), %xmm13
; AVX512DQ-NEXT:    vmovdqa 32(%rdx), %xmm14
; AVX512DQ-NEXT:    vmovdqa 48(%rdx), %xmm9
; AVX512DQ-NEXT:    vpunpckhwd {{.*#+}} xmm15 = xmm13[4],xmm5[4],xmm13[5],xmm5[5],xmm13[6],xmm5[6],xmm13[7],xmm5[7]
; AVX512DQ-NEXT:    vpunpcklwd {{.*#+}} xmm13 = xmm13[0],xmm5[0],xmm13[1],xmm5[1],xmm13[2],xmm5[2],xmm13[3],xmm5[3]
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm5 = [0,0,1,1,2,2,3,3,16,16,17,17,18,18,19,19]
; AVX512DQ-NEXT:    vpermt2d %zmm15, %zmm5, %zmm13
; AVX512DQ-NEXT:    movw $-21846, %ax # imm = 0xAAAA
; AVX512DQ-NEXT:    kmovw %eax, %k1
; AVX512DQ-NEXT:    vmovdqa32 %zmm13, %zmm1 {%k1}
; AVX512DQ-NEXT:    vpunpckhwd {{.*#+}} xmm13 = xmm11[4],xmm10[4],xmm11[5],xmm10[5],xmm11[6],xmm10[6],xmm11[7],xmm10[7]
; AVX512DQ-NEXT:    vpmovzxdq {{.*#+}} xmm15 = xmm13[0],zero,xmm13[1],zero
; AVX512DQ-NEXT:    vpshufd {{.*#+}} xmm13 = xmm13[2,2,3,3]
; AVX512DQ-NEXT:    vinserti128 $1, %xmm13, %ymm15, %ymm13
; AVX512DQ-NEXT:    vpunpcklwd {{.*#+}} xmm10 = xmm11[0],xmm10[0],xmm11[1],xmm10[1],xmm11[2],xmm10[2],xmm11[3],xmm10[3]
; AVX512DQ-NEXT:    vpmovzxdq {{.*#+}} xmm11 = xmm10[0],zero,xmm10[1],zero
; AVX512DQ-NEXT:    vpshufd {{.*#+}} xmm10 = xmm10[2,2,3,3]
; AVX512DQ-NEXT:    vinserti128 $1, %xmm10, %ymm11, %ymm10
; AVX512DQ-NEXT:    vinserti64x4 $1, %ymm13, %zmm10, %zmm10
; AVX512DQ-NEXT:    vpunpckhwd {{.*#+}} xmm11 = xmm14[4],xmm12[4],xmm14[5],xmm12[5],xmm14[6],xmm12[6],xmm14[7],xmm12[7]
; AVX512DQ-NEXT:    vpunpcklwd {{.*#+}} xmm12 = xmm14[0],xmm12[0],xmm14[1],xmm12[1],xmm14[2],xmm12[2],xmm14[3],xmm12[3]
; AVX512DQ-NEXT:    vpermt2d %zmm11, %zmm5, %zmm12
; AVX512DQ-NEXT:    vmovdqa32 %zmm12, %zmm10 {%k1}
; AVX512DQ-NEXT:    vpunpckhwd {{.*#+}} xmm11 = xmm7[4],xmm6[4],xmm7[5],xmm6[5],xmm7[6],xmm6[6],xmm7[7],xmm6[7]
; AVX512DQ-NEXT:    vpmovzxdq {{.*#+}} xmm12 = xmm11[0],zero,xmm11[1],zero
; AVX512DQ-NEXT:    vpshufd {{.*#+}} xmm11 = xmm11[2,2,3,3]
; AVX512DQ-NEXT:    vinserti128 $1, %xmm11, %ymm12, %ymm11
; AVX512DQ-NEXT:    vpunpcklwd {{.*#+}} xmm6 = xmm7[0],xmm6[0],xmm7[1],xmm6[1],xmm7[2],xmm6[2],xmm7[3],xmm6[3]
; AVX512DQ-NEXT:    vpmovzxdq {{.*#+}} xmm7 = xmm6[0],zero,xmm6[1],zero
; AVX512DQ-NEXT:    vpshufd {{.*#+}} xmm6 = xmm6[2,2,3,3]
; AVX512DQ-NEXT:    vinserti128 $1, %xmm6, %ymm7, %ymm6
; AVX512DQ-NEXT:    vinserti64x4 $1, %ymm11, %zmm6, %zmm6
; AVX512DQ-NEXT:    vpunpckhwd {{.*#+}} xmm7 = xmm9[4],xmm8[4],xmm9[5],xmm8[5],xmm9[6],xmm8[6],xmm9[7],xmm8[7]
; AVX512DQ-NEXT:    vpunpcklwd {{.*#+}} xmm8 = xmm9[0],xmm8[0],xmm9[1],xmm8[1],xmm9[2],xmm8[2],xmm9[3],xmm8[3]
; AVX512DQ-NEXT:    vpermt2d %zmm7, %zmm5, %zmm8
; AVX512DQ-NEXT:    vmovdqa32 %zmm8, %zmm6 {%k1}
; AVX512DQ-NEXT:    vpunpckhwd {{.*#+}} xmm7 = xmm2[4],xmm0[4],xmm2[5],xmm0[5],xmm2[6],xmm0[6],xmm2[7],xmm0[7]
; AVX512DQ-NEXT:    vpmovzxdq {{.*#+}} xmm8 = xmm7[0],zero,xmm7[1],zero
; AVX512DQ-NEXT:    vpshufd {{.*#+}} xmm7 = xmm7[2,2,3,3]
; AVX512DQ-NEXT:    vinserti128 $1, %xmm7, %ymm8, %ymm7
; AVX512DQ-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm2[0],xmm0[0],xmm2[1],xmm0[1],xmm2[2],xmm0[2],xmm2[3],xmm0[3]
; AVX512DQ-NEXT:    vpmovzxdq {{.*#+}} xmm2 = xmm0[0],zero,xmm0[1],zero
; AVX512DQ-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX512DQ-NEXT:    vinserti128 $1, %xmm0, %ymm2, %ymm0
; AVX512DQ-NEXT:    vinserti64x4 $1, %ymm7, %zmm0, %zmm0
; AVX512DQ-NEXT:    vpunpckhwd {{.*#+}} xmm2 = xmm4[4],xmm3[4],xmm4[5],xmm3[5],xmm4[6],xmm3[6],xmm4[7],xmm3[7]
; AVX512DQ-NEXT:    vpunpcklwd {{.*#+}} xmm3 = xmm4[0],xmm3[0],xmm4[1],xmm3[1],xmm4[2],xmm3[2],xmm4[3],xmm3[3]
; AVX512DQ-NEXT:    vpermt2d %zmm2, %zmm5, %zmm3
; AVX512DQ-NEXT:    vmovdqa32 %zmm3, %zmm0 {%k1}
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, (%r8)
; AVX512DQ-NEXT:    vmovdqa64 %zmm6, 192(%r8)
; AVX512DQ-NEXT:    vmovdqa64 %zmm10, 128(%r8)
; AVX512DQ-NEXT:    vmovdqa64 %zmm1, 64(%r8)
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512DQ-FCP-LABEL: store_i16_stride4_vf32:
; AVX512DQ-FCP:       # %bb.0:
; AVX512DQ-FCP-NEXT:    vmovdqa (%rsi), %xmm0
; AVX512DQ-FCP-NEXT:    vmovdqa 16(%rsi), %xmm1
; AVX512DQ-FCP-NEXT:    vmovdqa 32(%rsi), %xmm10
; AVX512DQ-FCP-NEXT:    vmovdqa 48(%rsi), %xmm6
; AVX512DQ-FCP-NEXT:    vmovdqa (%rdi), %xmm2
; AVX512DQ-FCP-NEXT:    vmovdqa 16(%rdi), %xmm3
; AVX512DQ-FCP-NEXT:    vmovdqa 32(%rdi), %xmm11
; AVX512DQ-FCP-NEXT:    vmovdqa 48(%rdi), %xmm7
; AVX512DQ-FCP-NEXT:    vpunpckhwd {{.*#+}} xmm4 = xmm3[4],xmm1[4],xmm3[5],xmm1[5],xmm3[6],xmm1[6],xmm3[7],xmm1[7]
; AVX512DQ-FCP-NEXT:    vpmovzxdq {{.*#+}} xmm5 = xmm4[0],zero,xmm4[1],zero
; AVX512DQ-FCP-NEXT:    vpshufd {{.*#+}} xmm4 = xmm4[2,2,3,3]
; AVX512DQ-FCP-NEXT:    vinserti128 $1, %xmm4, %ymm5, %ymm4
; AVX512DQ-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm3[0],xmm1[0],xmm3[1],xmm1[1],xmm3[2],xmm1[2],xmm3[3],xmm1[3]
; AVX512DQ-FCP-NEXT:    vpmovzxdq {{.*#+}} xmm3 = xmm1[0],zero,xmm1[1],zero
; AVX512DQ-FCP-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,2,3,3]
; AVX512DQ-FCP-NEXT:    vinserti128 $1, %xmm1, %ymm3, %ymm1
; AVX512DQ-FCP-NEXT:    vinserti64x4 $1, %ymm4, %zmm1, %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqa (%rcx), %xmm3
; AVX512DQ-FCP-NEXT:    vmovdqa 16(%rcx), %xmm5
; AVX512DQ-FCP-NEXT:    vmovdqa 32(%rcx), %xmm12
; AVX512DQ-FCP-NEXT:    vmovdqa 48(%rcx), %xmm8
; AVX512DQ-FCP-NEXT:    vmovdqa (%rdx), %xmm4
; AVX512DQ-FCP-NEXT:    vmovdqa 16(%rdx), %xmm13
; AVX512DQ-FCP-NEXT:    vmovdqa 32(%rdx), %xmm14
; AVX512DQ-FCP-NEXT:    vmovdqa 48(%rdx), %xmm9
; AVX512DQ-FCP-NEXT:    vpunpckhwd {{.*#+}} xmm15 = xmm13[4],xmm5[4],xmm13[5],xmm5[5],xmm13[6],xmm5[6],xmm13[7],xmm5[7]
; AVX512DQ-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm13 = xmm13[0],xmm5[0],xmm13[1],xmm5[1],xmm13[2],xmm5[2],xmm13[3],xmm5[3]
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm5 = [0,0,1,1,2,2,3,3,16,16,17,17,18,18,19,19]
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm15, %zmm5, %zmm13
; AVX512DQ-FCP-NEXT:    movw $-21846, %ax # imm = 0xAAAA
; AVX512DQ-FCP-NEXT:    kmovw %eax, %k1
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm13, %zmm1 {%k1}
; AVX512DQ-FCP-NEXT:    vpunpckhwd {{.*#+}} xmm13 = xmm11[4],xmm10[4],xmm11[5],xmm10[5],xmm11[6],xmm10[6],xmm11[7],xmm10[7]
; AVX512DQ-FCP-NEXT:    vpmovzxdq {{.*#+}} xmm15 = xmm13[0],zero,xmm13[1],zero
; AVX512DQ-FCP-NEXT:    vpshufd {{.*#+}} xmm13 = xmm13[2,2,3,3]
; AVX512DQ-FCP-NEXT:    vinserti128 $1, %xmm13, %ymm15, %ymm13
; AVX512DQ-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm10 = xmm11[0],xmm10[0],xmm11[1],xmm10[1],xmm11[2],xmm10[2],xmm11[3],xmm10[3]
; AVX512DQ-FCP-NEXT:    vpmovzxdq {{.*#+}} xmm11 = xmm10[0],zero,xmm10[1],zero
; AVX512DQ-FCP-NEXT:    vpshufd {{.*#+}} xmm10 = xmm10[2,2,3,3]
; AVX512DQ-FCP-NEXT:    vinserti128 $1, %xmm10, %ymm11, %ymm10
; AVX512DQ-FCP-NEXT:    vinserti64x4 $1, %ymm13, %zmm10, %zmm10
; AVX512DQ-FCP-NEXT:    vpunpckhwd {{.*#+}} xmm11 = xmm14[4],xmm12[4],xmm14[5],xmm12[5],xmm14[6],xmm12[6],xmm14[7],xmm12[7]
; AVX512DQ-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm12 = xmm14[0],xmm12[0],xmm14[1],xmm12[1],xmm14[2],xmm12[2],xmm14[3],xmm12[3]
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm11, %zmm5, %zmm12
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm12, %zmm10 {%k1}
; AVX512DQ-FCP-NEXT:    vpunpckhwd {{.*#+}} xmm11 = xmm7[4],xmm6[4],xmm7[5],xmm6[5],xmm7[6],xmm6[6],xmm7[7],xmm6[7]
; AVX512DQ-FCP-NEXT:    vpmovzxdq {{.*#+}} xmm12 = xmm11[0],zero,xmm11[1],zero
; AVX512DQ-FCP-NEXT:    vpshufd {{.*#+}} xmm11 = xmm11[2,2,3,3]
; AVX512DQ-FCP-NEXT:    vinserti128 $1, %xmm11, %ymm12, %ymm11
; AVX512DQ-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm6 = xmm7[0],xmm6[0],xmm7[1],xmm6[1],xmm7[2],xmm6[2],xmm7[3],xmm6[3]
; AVX512DQ-FCP-NEXT:    vpmovzxdq {{.*#+}} xmm7 = xmm6[0],zero,xmm6[1],zero
; AVX512DQ-FCP-NEXT:    vpshufd {{.*#+}} xmm6 = xmm6[2,2,3,3]
; AVX512DQ-FCP-NEXT:    vinserti128 $1, %xmm6, %ymm7, %ymm6
; AVX512DQ-FCP-NEXT:    vinserti64x4 $1, %ymm11, %zmm6, %zmm6
; AVX512DQ-FCP-NEXT:    vpunpckhwd {{.*#+}} xmm7 = xmm9[4],xmm8[4],xmm9[5],xmm8[5],xmm9[6],xmm8[6],xmm9[7],xmm8[7]
; AVX512DQ-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm8 = xmm9[0],xmm8[0],xmm9[1],xmm8[1],xmm9[2],xmm8[2],xmm9[3],xmm8[3]
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm7, %zmm5, %zmm8
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm8, %zmm6 {%k1}
; AVX512DQ-FCP-NEXT:    vpunpckhwd {{.*#+}} xmm7 = xmm2[4],xmm0[4],xmm2[5],xmm0[5],xmm2[6],xmm0[6],xmm2[7],xmm0[7]
; AVX512DQ-FCP-NEXT:    vpmovzxdq {{.*#+}} xmm8 = xmm7[0],zero,xmm7[1],zero
; AVX512DQ-FCP-NEXT:    vpshufd {{.*#+}} xmm7 = xmm7[2,2,3,3]
; AVX512DQ-FCP-NEXT:    vinserti128 $1, %xmm7, %ymm8, %ymm7
; AVX512DQ-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm2[0],xmm0[0],xmm2[1],xmm0[1],xmm2[2],xmm0[2],xmm2[3],xmm0[3]
; AVX512DQ-FCP-NEXT:    vpmovzxdq {{.*#+}} xmm2 = xmm0[0],zero,xmm0[1],zero
; AVX512DQ-FCP-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX512DQ-FCP-NEXT:    vinserti128 $1, %xmm0, %ymm2, %ymm0
; AVX512DQ-FCP-NEXT:    vinserti64x4 $1, %ymm7, %zmm0, %zmm0
; AVX512DQ-FCP-NEXT:    vpunpckhwd {{.*#+}} xmm2 = xmm4[4],xmm3[4],xmm4[5],xmm3[5],xmm4[6],xmm3[6],xmm4[7],xmm3[7]
; AVX512DQ-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm3 = xmm4[0],xmm3[0],xmm4[1],xmm3[1],xmm4[2],xmm3[2],xmm4[3],xmm3[3]
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm2, %zmm5, %zmm3
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm3, %zmm0 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, (%r8)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm6, 192(%r8)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm10, 128(%r8)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm1, 64(%r8)
; AVX512DQ-FCP-NEXT:    vzeroupper
; AVX512DQ-FCP-NEXT:    retq
;
; AVX512BW-LABEL: store_i16_stride4_vf32:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512BW-NEXT:    vmovdqa64 (%rsi), %zmm1
; AVX512BW-NEXT:    vmovdqa64 (%rdx), %zmm2
; AVX512BW-NEXT:    vmovdqa64 (%rcx), %zmm3
; AVX512BW-NEXT:    vpmovsxbw {{.*#+}} zmm4 = [0,0,0,32,0,0,1,33,0,0,2,34,0,0,3,35,0,0,4,36,0,0,5,37,0,0,6,38,0,0,7,39]
; AVX512BW-NEXT:    vpermi2w %zmm3, %zmm2, %zmm4
; AVX512BW-NEXT:    vpmovsxbw {{.*#+}} zmm5 = [0,32,0,0,1,33,0,0,2,34,0,0,3,35,0,0,4,36,0,0,5,37,0,0,6,38,0,0,7,39,0,0]
; AVX512BW-NEXT:    vpermi2w %zmm1, %zmm0, %zmm5
; AVX512BW-NEXT:    movw $-21846, %ax # imm = 0xAAAA
; AVX512BW-NEXT:    kmovd %eax, %k1
; AVX512BW-NEXT:    vmovdqa32 %zmm4, %zmm5 {%k1}
; AVX512BW-NEXT:    vpmovsxbw {{.*#+}} zmm4 = [0,0,8,40,0,0,9,41,0,0,10,42,0,0,11,43,0,0,12,44,0,0,13,45,0,0,14,46,0,0,15,47]
; AVX512BW-NEXT:    vpermi2w %zmm3, %zmm2, %zmm4
; AVX512BW-NEXT:    vpmovsxbw {{.*#+}} zmm6 = [8,40,0,0,9,41,0,0,10,42,0,0,11,43,0,0,12,44,0,0,13,45,0,0,14,46,0,0,15,47,0,0]
; AVX512BW-NEXT:    vpermi2w %zmm1, %zmm0, %zmm6
; AVX512BW-NEXT:    vmovdqa32 %zmm4, %zmm6 {%k1}
; AVX512BW-NEXT:    vpmovsxbw {{.*#+}} zmm4 = [0,0,16,48,0,0,17,49,0,0,18,50,0,0,19,51,0,0,20,52,0,0,21,53,0,0,22,54,0,0,23,55]
; AVX512BW-NEXT:    vpermi2w %zmm3, %zmm2, %zmm4
; AVX512BW-NEXT:    vpmovsxbw {{.*#+}} zmm7 = [16,48,0,0,17,49,0,0,18,50,0,0,19,51,0,0,20,52,0,0,21,53,0,0,22,54,0,0,23,55,0,0]
; AVX512BW-NEXT:    vpermi2w %zmm1, %zmm0, %zmm7
; AVX512BW-NEXT:    vmovdqa32 %zmm4, %zmm7 {%k1}
; AVX512BW-NEXT:    vpmovsxbw {{.*#+}} zmm4 = [0,0,24,56,0,0,25,57,0,0,26,58,0,0,27,59,0,0,28,60,0,0,29,61,0,0,30,62,0,0,31,63]
; AVX512BW-NEXT:    vpermi2w %zmm3, %zmm2, %zmm4
; AVX512BW-NEXT:    vpmovsxbw {{.*#+}} zmm2 = [24,56,0,0,25,57,0,0,26,58,0,0,27,59,0,0,28,60,0,0,29,61,0,0,30,62,0,0,31,63,0,0]
; AVX512BW-NEXT:    vpermi2w %zmm1, %zmm0, %zmm2
; AVX512BW-NEXT:    vmovdqa32 %zmm4, %zmm2 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm2, 192(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm7, 128(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm6, 64(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm5, (%r8)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BW-FCP-LABEL: store_i16_stride4_vf32:
; AVX512BW-FCP:       # %bb.0:
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rsi), %zmm1
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rdx), %zmm2
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rcx), %zmm3
; AVX512BW-FCP-NEXT:    vpmovsxbw {{.*#+}} zmm4 = [0,0,0,32,0,0,1,33,0,0,2,34,0,0,3,35,0,0,4,36,0,0,5,37,0,0,6,38,0,0,7,39]
; AVX512BW-FCP-NEXT:    vpermi2w %zmm3, %zmm2, %zmm4
; AVX512BW-FCP-NEXT:    vpmovsxbw {{.*#+}} zmm5 = [0,32,0,0,1,33,0,0,2,34,0,0,3,35,0,0,4,36,0,0,5,37,0,0,6,38,0,0,7,39,0,0]
; AVX512BW-FCP-NEXT:    vpermi2w %zmm1, %zmm0, %zmm5
; AVX512BW-FCP-NEXT:    movw $-21846, %ax # imm = 0xAAAA
; AVX512BW-FCP-NEXT:    kmovd %eax, %k1
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm4, %zmm5 {%k1}
; AVX512BW-FCP-NEXT:    vpmovsxbw {{.*#+}} zmm4 = [0,0,8,40,0,0,9,41,0,0,10,42,0,0,11,43,0,0,12,44,0,0,13,45,0,0,14,46,0,0,15,47]
; AVX512BW-FCP-NEXT:    vpermi2w %zmm3, %zmm2, %zmm4
; AVX512BW-FCP-NEXT:    vpmovsxbw {{.*#+}} zmm6 = [8,40,0,0,9,41,0,0,10,42,0,0,11,43,0,0,12,44,0,0,13,45,0,0,14,46,0,0,15,47,0,0]
; AVX512BW-FCP-NEXT:    vpermi2w %zmm1, %zmm0, %zmm6
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm4, %zmm6 {%k1}
; AVX512BW-FCP-NEXT:    vpmovsxbw {{.*#+}} zmm4 = [0,0,16,48,0,0,17,49,0,0,18,50,0,0,19,51,0,0,20,52,0,0,21,53,0,0,22,54,0,0,23,55]
; AVX512BW-FCP-NEXT:    vpermi2w %zmm3, %zmm2, %zmm4
; AVX512BW-FCP-NEXT:    vpmovsxbw {{.*#+}} zmm7 = [16,48,0,0,17,49,0,0,18,50,0,0,19,51,0,0,20,52,0,0,21,53,0,0,22,54,0,0,23,55,0,0]
; AVX512BW-FCP-NEXT:    vpermi2w %zmm1, %zmm0, %zmm7
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm4, %zmm7 {%k1}
; AVX512BW-FCP-NEXT:    vpmovsxbw {{.*#+}} zmm4 = [0,0,24,56,0,0,25,57,0,0,26,58,0,0,27,59,0,0,28,60,0,0,29,61,0,0,30,62,0,0,31,63]
; AVX512BW-FCP-NEXT:    vpermi2w %zmm3, %zmm2, %zmm4
; AVX512BW-FCP-NEXT:    vpmovsxbw {{.*#+}} zmm2 = [24,56,0,0,25,57,0,0,26,58,0,0,27,59,0,0,28,60,0,0,29,61,0,0,30,62,0,0,31,63,0,0]
; AVX512BW-FCP-NEXT:    vpermi2w %zmm1, %zmm0, %zmm2
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm4, %zmm2 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm2, 192(%r8)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm7, 128(%r8)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm6, 64(%r8)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm5, (%r8)
; AVX512BW-FCP-NEXT:    vzeroupper
; AVX512BW-FCP-NEXT:    retq
;
; AVX512DQ-BW-LABEL: store_i16_stride4_vf32:
; AVX512DQ-BW:       # %bb.0:
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rsi), %zmm1
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rdx), %zmm2
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rcx), %zmm3
; AVX512DQ-BW-NEXT:    vpmovsxbw {{.*#+}} zmm4 = [0,0,0,32,0,0,1,33,0,0,2,34,0,0,3,35,0,0,4,36,0,0,5,37,0,0,6,38,0,0,7,39]
; AVX512DQ-BW-NEXT:    vpermi2w %zmm3, %zmm2, %zmm4
; AVX512DQ-BW-NEXT:    vpmovsxbw {{.*#+}} zmm5 = [0,32,0,0,1,33,0,0,2,34,0,0,3,35,0,0,4,36,0,0,5,37,0,0,6,38,0,0,7,39,0,0]
; AVX512DQ-BW-NEXT:    vpermi2w %zmm1, %zmm0, %zmm5
; AVX512DQ-BW-NEXT:    movw $-21846, %ax # imm = 0xAAAA
; AVX512DQ-BW-NEXT:    kmovd %eax, %k1
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm4, %zmm5 {%k1}
; AVX512DQ-BW-NEXT:    vpmovsxbw {{.*#+}} zmm4 = [0,0,8,40,0,0,9,41,0,0,10,42,0,0,11,43,0,0,12,44,0,0,13,45,0,0,14,46,0,0,15,47]
; AVX512DQ-BW-NEXT:    vpermi2w %zmm3, %zmm2, %zmm4
; AVX512DQ-BW-NEXT:    vpmovsxbw {{.*#+}} zmm6 = [8,40,0,0,9,41,0,0,10,42,0,0,11,43,0,0,12,44,0,0,13,45,0,0,14,46,0,0,15,47,0,0]
; AVX512DQ-BW-NEXT:    vpermi2w %zmm1, %zmm0, %zmm6
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm4, %zmm6 {%k1}
; AVX512DQ-BW-NEXT:    vpmovsxbw {{.*#+}} zmm4 = [0,0,16,48,0,0,17,49,0,0,18,50,0,0,19,51,0,0,20,52,0,0,21,53,0,0,22,54,0,0,23,55]
; AVX512DQ-BW-NEXT:    vpermi2w %zmm3, %zmm2, %zmm4
; AVX512DQ-BW-NEXT:    vpmovsxbw {{.*#+}} zmm7 = [16,48,0,0,17,49,0,0,18,50,0,0,19,51,0,0,20,52,0,0,21,53,0,0,22,54,0,0,23,55,0,0]
; AVX512DQ-BW-NEXT:    vpermi2w %zmm1, %zmm0, %zmm7
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm4, %zmm7 {%k1}
; AVX512DQ-BW-NEXT:    vpmovsxbw {{.*#+}} zmm4 = [0,0,24,56,0,0,25,57,0,0,26,58,0,0,27,59,0,0,28,60,0,0,29,61,0,0,30,62,0,0,31,63]
; AVX512DQ-BW-NEXT:    vpermi2w %zmm3, %zmm2, %zmm4
; AVX512DQ-BW-NEXT:    vpmovsxbw {{.*#+}} zmm2 = [24,56,0,0,25,57,0,0,26,58,0,0,27,59,0,0,28,60,0,0,29,61,0,0,30,62,0,0,31,63,0,0]
; AVX512DQ-BW-NEXT:    vpermi2w %zmm1, %zmm0, %zmm2
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm4, %zmm2 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm2, 192(%r8)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm7, 128(%r8)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm6, 64(%r8)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm5, (%r8)
; AVX512DQ-BW-NEXT:    vzeroupper
; AVX512DQ-BW-NEXT:    retq
;
; AVX512DQ-BW-FCP-LABEL: store_i16_stride4_vf32:
; AVX512DQ-BW-FCP:       # %bb.0:
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rsi), %zmm1
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rdx), %zmm2
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rcx), %zmm3
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbw {{.*#+}} zmm4 = [0,0,0,32,0,0,1,33,0,0,2,34,0,0,3,35,0,0,4,36,0,0,5,37,0,0,6,38,0,0,7,39]
; AVX512DQ-BW-FCP-NEXT:    vpermi2w %zmm3, %zmm2, %zmm4
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbw {{.*#+}} zmm5 = [0,32,0,0,1,33,0,0,2,34,0,0,3,35,0,0,4,36,0,0,5,37,0,0,6,38,0,0,7,39,0,0]
; AVX512DQ-BW-FCP-NEXT:    vpermi2w %zmm1, %zmm0, %zmm5
; AVX512DQ-BW-FCP-NEXT:    movw $-21846, %ax # imm = 0xAAAA
; AVX512DQ-BW-FCP-NEXT:    kmovd %eax, %k1
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm4, %zmm5 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbw {{.*#+}} zmm4 = [0,0,8,40,0,0,9,41,0,0,10,42,0,0,11,43,0,0,12,44,0,0,13,45,0,0,14,46,0,0,15,47]
; AVX512DQ-BW-FCP-NEXT:    vpermi2w %zmm3, %zmm2, %zmm4
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbw {{.*#+}} zmm6 = [8,40,0,0,9,41,0,0,10,42,0,0,11,43,0,0,12,44,0,0,13,45,0,0,14,46,0,0,15,47,0,0]
; AVX512DQ-BW-FCP-NEXT:    vpermi2w %zmm1, %zmm0, %zmm6
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm4, %zmm6 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbw {{.*#+}} zmm4 = [0,0,16,48,0,0,17,49,0,0,18,50,0,0,19,51,0,0,20,52,0,0,21,53,0,0,22,54,0,0,23,55]
; AVX512DQ-BW-FCP-NEXT:    vpermi2w %zmm3, %zmm2, %zmm4
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbw {{.*#+}} zmm7 = [16,48,0,0,17,49,0,0,18,50,0,0,19,51,0,0,20,52,0,0,21,53,0,0,22,54,0,0,23,55,0,0]
; AVX512DQ-BW-FCP-NEXT:    vpermi2w %zmm1, %zmm0, %zmm7
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm4, %zmm7 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbw {{.*#+}} zmm4 = [0,0,24,56,0,0,25,57,0,0,26,58,0,0,27,59,0,0,28,60,0,0,29,61,0,0,30,62,0,0,31,63]
; AVX512DQ-BW-FCP-NEXT:    vpermi2w %zmm3, %zmm2, %zmm4
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbw {{.*#+}} zmm2 = [24,56,0,0,25,57,0,0,26,58,0,0,27,59,0,0,28,60,0,0,29,61,0,0,30,62,0,0,31,63,0,0]
; AVX512DQ-BW-FCP-NEXT:    vpermi2w %zmm1, %zmm0, %zmm2
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm4, %zmm2 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm2, 192(%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm7, 128(%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm6, 64(%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm5, (%r8)
; AVX512DQ-BW-FCP-NEXT:    vzeroupper
; AVX512DQ-BW-FCP-NEXT:    retq
  %in.vec0 = load <32 x i16>, ptr %in.vecptr0, align 64
  %in.vec1 = load <32 x i16>, ptr %in.vecptr1, align 64
  %in.vec2 = load <32 x i16>, ptr %in.vecptr2, align 64
  %in.vec3 = load <32 x i16>, ptr %in.vecptr3, align 64
  %1 = shufflevector <32 x i16> %in.vec0, <32 x i16> %in.vec1, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %2 = shufflevector <32 x i16> %in.vec2, <32 x i16> %in.vec3, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %3 = shufflevector <64 x i16> %1, <64 x i16> %2, <128 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127>
  %interleaved.vec = shufflevector <128 x i16> %3, <128 x i16> poison, <128 x i32> <i32 0, i32 32, i32 64, i32 96, i32 1, i32 33, i32 65, i32 97, i32 2, i32 34, i32 66, i32 98, i32 3, i32 35, i32 67, i32 99, i32 4, i32 36, i32 68, i32 100, i32 5, i32 37, i32 69, i32 101, i32 6, i32 38, i32 70, i32 102, i32 7, i32 39, i32 71, i32 103, i32 8, i32 40, i32 72, i32 104, i32 9, i32 41, i32 73, i32 105, i32 10, i32 42, i32 74, i32 106, i32 11, i32 43, i32 75, i32 107, i32 12, i32 44, i32 76, i32 108, i32 13, i32 45, i32 77, i32 109, i32 14, i32 46, i32 78, i32 110, i32 15, i32 47, i32 79, i32 111, i32 16, i32 48, i32 80, i32 112, i32 17, i32 49, i32 81, i32 113, i32 18, i32 50, i32 82, i32 114, i32 19, i32 51, i32 83, i32 115, i32 20, i32 52, i32 84, i32 116, i32 21, i32 53, i32 85, i32 117, i32 22, i32 54, i32 86, i32 118, i32 23, i32 55, i32 87, i32 119, i32 24, i32 56, i32 88, i32 120, i32 25, i32 57, i32 89, i32 121, i32 26, i32 58, i32 90, i32 122, i32 27, i32 59, i32 91, i32 123, i32 28, i32 60, i32 92, i32 124, i32 29, i32 61, i32 93, i32 125, i32 30, i32 62, i32 94, i32 126, i32 31, i32 63, i32 95, i32 127>
  store <128 x i16> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i16_stride4_vf64(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %in.vecptr3, ptr %out.vec) nounwind {
; SSE-LABEL: store_i16_stride4_vf64:
; SSE:       # %bb.0:
; SSE-NEXT:    subq $184, %rsp
; SSE-NEXT:    movdqa (%rdi), %xmm10
; SSE-NEXT:    movdqa 16(%rdi), %xmm11
; SSE-NEXT:    movdqa 32(%rdi), %xmm12
; SSE-NEXT:    movdqa 48(%rdi), %xmm13
; SSE-NEXT:    movdqa (%rsi), %xmm5
; SSE-NEXT:    movdqa 16(%rsi), %xmm2
; SSE-NEXT:    movdqa 32(%rsi), %xmm0
; SSE-NEXT:    movdqa (%rdx), %xmm6
; SSE-NEXT:    movdqa 16(%rdx), %xmm4
; SSE-NEXT:    movdqa 32(%rdx), %xmm1
; SSE-NEXT:    movdqa (%rcx), %xmm7
; SSE-NEXT:    movdqa 16(%rcx), %xmm8
; SSE-NEXT:    movdqa 32(%rcx), %xmm3
; SSE-NEXT:    movdqa %xmm6, %xmm9
; SSE-NEXT:    punpcklwd {{.*#+}} xmm9 = xmm9[0],xmm7[0],xmm9[1],xmm7[1],xmm9[2],xmm7[2],xmm9[3],xmm7[3]
; SSE-NEXT:    movdqa %xmm10, %xmm14
; SSE-NEXT:    punpcklwd {{.*#+}} xmm14 = xmm14[0],xmm5[0],xmm14[1],xmm5[1],xmm14[2],xmm5[2],xmm14[3],xmm5[3]
; SSE-NEXT:    movdqa %xmm14, %xmm15
; SSE-NEXT:    punpckldq {{.*#+}} xmm15 = xmm15[0],xmm9[0],xmm15[1],xmm9[1]
; SSE-NEXT:    movdqa %xmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckhdq {{.*#+}} xmm14 = xmm14[2],xmm9[2],xmm14[3],xmm9[3]
; SSE-NEXT:    movdqa %xmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckhwd {{.*#+}} xmm6 = xmm6[4],xmm7[4],xmm6[5],xmm7[5],xmm6[6],xmm7[6],xmm6[7],xmm7[7]
; SSE-NEXT:    punpckhwd {{.*#+}} xmm10 = xmm10[4],xmm5[4],xmm10[5],xmm5[5],xmm10[6],xmm5[6],xmm10[7],xmm5[7]
; SSE-NEXT:    movdqa %xmm10, %xmm5
; SSE-NEXT:    punpckldq {{.*#+}} xmm5 = xmm5[0],xmm6[0],xmm5[1],xmm6[1]
; SSE-NEXT:    movdqa %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckhdq {{.*#+}} xmm10 = xmm10[2],xmm6[2],xmm10[3],xmm6[3]
; SSE-NEXT:    movdqa %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm4, %xmm5
; SSE-NEXT:    punpcklwd {{.*#+}} xmm5 = xmm5[0],xmm8[0],xmm5[1],xmm8[1],xmm5[2],xmm8[2],xmm5[3],xmm8[3]
; SSE-NEXT:    movdqa %xmm11, %xmm6
; SSE-NEXT:    punpcklwd {{.*#+}} xmm6 = xmm6[0],xmm2[0],xmm6[1],xmm2[1],xmm6[2],xmm2[2],xmm6[3],xmm2[3]
; SSE-NEXT:    movdqa %xmm6, %xmm7
; SSE-NEXT:    punpckldq {{.*#+}} xmm7 = xmm7[0],xmm5[0],xmm7[1],xmm5[1]
; SSE-NEXT:    movdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckhdq {{.*#+}} xmm6 = xmm6[2],xmm5[2],xmm6[3],xmm5[3]
; SSE-NEXT:    movdqa %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckhwd {{.*#+}} xmm4 = xmm4[4],xmm8[4],xmm4[5],xmm8[5],xmm4[6],xmm8[6],xmm4[7],xmm8[7]
; SSE-NEXT:    punpckhwd {{.*#+}} xmm11 = xmm11[4],xmm2[4],xmm11[5],xmm2[5],xmm11[6],xmm2[6],xmm11[7],xmm2[7]
; SSE-NEXT:    movdqa %xmm11, %xmm2
; SSE-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm4[0],xmm2[1],xmm4[1]
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckhdq {{.*#+}} xmm11 = xmm11[2],xmm4[2],xmm11[3],xmm4[3]
; SSE-NEXT:    movdqa %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    punpcklwd {{.*#+}} xmm2 = xmm2[0],xmm3[0],xmm2[1],xmm3[1],xmm2[2],xmm3[2],xmm2[3],xmm3[3]
; SSE-NEXT:    movdqa %xmm12, %xmm4
; SSE-NEXT:    punpcklwd {{.*#+}} xmm4 = xmm4[0],xmm0[0],xmm4[1],xmm0[1],xmm4[2],xmm0[2],xmm4[3],xmm0[3]
; SSE-NEXT:    movdqa %xmm4, %xmm5
; SSE-NEXT:    punpckldq {{.*#+}} xmm5 = xmm5[0],xmm2[0],xmm5[1],xmm2[1]
; SSE-NEXT:    movdqa %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckhdq {{.*#+}} xmm4 = xmm4[2],xmm2[2],xmm4[3],xmm2[3]
; SSE-NEXT:    movdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 48(%rdx), %xmm2
; SSE-NEXT:    punpckhwd {{.*#+}} xmm1 = xmm1[4],xmm3[4],xmm1[5],xmm3[5],xmm1[6],xmm3[6],xmm1[7],xmm3[7]
; SSE-NEXT:    movdqa 48(%rcx), %xmm3
; SSE-NEXT:    punpckhwd {{.*#+}} xmm12 = xmm12[4],xmm0[4],xmm12[5],xmm0[5],xmm12[6],xmm0[6],xmm12[7],xmm0[7]
; SSE-NEXT:    movdqa %xmm12, %xmm0
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE-NEXT:    movdqa %xmm0, (%rsp) # 16-byte Spill
; SSE-NEXT:    punpckhdq {{.*#+}} xmm12 = xmm12[2],xmm1[2],xmm12[3],xmm1[3]
; SSE-NEXT:    movdqa %xmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm2, %xmm0
; SSE-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm3[0],xmm0[1],xmm3[1],xmm0[2],xmm3[2],xmm0[3],xmm3[3]
; SSE-NEXT:    movdqa 48(%rsi), %xmm1
; SSE-NEXT:    movdqa %xmm13, %xmm4
; SSE-NEXT:    punpcklwd {{.*#+}} xmm4 = xmm4[0],xmm1[0],xmm4[1],xmm1[1],xmm4[2],xmm1[2],xmm4[3],xmm1[3]
; SSE-NEXT:    movdqa %xmm4, %xmm5
; SSE-NEXT:    punpckldq {{.*#+}} xmm5 = xmm5[0],xmm0[0],xmm5[1],xmm0[1]
; SSE-NEXT:    movdqa %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckhdq {{.*#+}} xmm4 = xmm4[2],xmm0[2],xmm4[3],xmm0[3]
; SSE-NEXT:    movdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckhwd {{.*#+}} xmm2 = xmm2[4],xmm3[4],xmm2[5],xmm3[5],xmm2[6],xmm3[6],xmm2[7],xmm3[7]
; SSE-NEXT:    punpckhwd {{.*#+}} xmm13 = xmm13[4],xmm1[4],xmm13[5],xmm1[5],xmm13[6],xmm1[6],xmm13[7],xmm1[7]
; SSE-NEXT:    movdqa %xmm13, %xmm0
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1]
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckhdq {{.*#+}} xmm13 = xmm13[2],xmm2[2],xmm13[3],xmm2[3]
; SSE-NEXT:    movdqa %xmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 64(%rdx), %xmm0
; SSE-NEXT:    movdqa 64(%rcx), %xmm1
; SSE-NEXT:    movdqa %xmm0, %xmm2
; SSE-NEXT:    punpcklwd {{.*#+}} xmm2 = xmm2[0],xmm1[0],xmm2[1],xmm1[1],xmm2[2],xmm1[2],xmm2[3],xmm1[3]
; SSE-NEXT:    movdqa 64(%rdi), %xmm13
; SSE-NEXT:    movdqa 64(%rsi), %xmm3
; SSE-NEXT:    movdqa %xmm13, %xmm14
; SSE-NEXT:    punpcklwd {{.*#+}} xmm14 = xmm14[0],xmm3[0],xmm14[1],xmm3[1],xmm14[2],xmm3[2],xmm14[3],xmm3[3]
; SSE-NEXT:    movdqa %xmm14, %xmm4
; SSE-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm2[0],xmm4[1],xmm2[1]
; SSE-NEXT:    movdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckhdq {{.*#+}} xmm14 = xmm14[2],xmm2[2],xmm14[3],xmm2[3]
; SSE-NEXT:    punpckhwd {{.*#+}} xmm0 = xmm0[4],xmm1[4],xmm0[5],xmm1[5],xmm0[6],xmm1[6],xmm0[7],xmm1[7]
; SSE-NEXT:    punpckhwd {{.*#+}} xmm13 = xmm13[4],xmm3[4],xmm13[5],xmm3[5],xmm13[6],xmm3[6],xmm13[7],xmm3[7]
; SSE-NEXT:    movdqa %xmm13, %xmm1
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckhdq {{.*#+}} xmm13 = xmm13[2],xmm0[2],xmm13[3],xmm0[3]
; SSE-NEXT:    movdqa 80(%rdx), %xmm0
; SSE-NEXT:    movdqa 80(%rcx), %xmm1
; SSE-NEXT:    movdqa %xmm0, %xmm2
; SSE-NEXT:    punpcklwd {{.*#+}} xmm2 = xmm2[0],xmm1[0],xmm2[1],xmm1[1],xmm2[2],xmm1[2],xmm2[3],xmm1[3]
; SSE-NEXT:    movdqa 80(%rdi), %xmm11
; SSE-NEXT:    movdqa 80(%rsi), %xmm7
; SSE-NEXT:    movdqa %xmm11, %xmm8
; SSE-NEXT:    punpcklwd {{.*#+}} xmm8 = xmm8[0],xmm7[0],xmm8[1],xmm7[1],xmm8[2],xmm7[2],xmm8[3],xmm7[3]
; SSE-NEXT:    movdqa %xmm8, %xmm3
; SSE-NEXT:    punpckldq {{.*#+}} xmm3 = xmm3[0],xmm2[0],xmm3[1],xmm2[1]
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckhdq {{.*#+}} xmm8 = xmm8[2],xmm2[2],xmm8[3],xmm2[3]
; SSE-NEXT:    punpckhwd {{.*#+}} xmm0 = xmm0[4],xmm1[4],xmm0[5],xmm1[5],xmm0[6],xmm1[6],xmm0[7],xmm1[7]
; SSE-NEXT:    punpckhwd {{.*#+}} xmm11 = xmm11[4],xmm7[4],xmm11[5],xmm7[5],xmm11[6],xmm7[6],xmm11[7],xmm7[7]
; SSE-NEXT:    movdqa %xmm11, %xmm15
; SSE-NEXT:    punpckldq {{.*#+}} xmm15 = xmm15[0],xmm0[0],xmm15[1],xmm0[1]
; SSE-NEXT:    punpckhdq {{.*#+}} xmm11 = xmm11[2],xmm0[2],xmm11[3],xmm0[3]
; SSE-NEXT:    movdqa 96(%rdx), %xmm1
; SSE-NEXT:    movdqa 96(%rcx), %xmm6
; SSE-NEXT:    movdqa %xmm1, %xmm0
; SSE-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm6[0],xmm0[1],xmm6[1],xmm0[2],xmm6[2],xmm0[3],xmm6[3]
; SSE-NEXT:    movdqa 96(%rdi), %xmm5
; SSE-NEXT:    movdqa 96(%rsi), %xmm4
; SSE-NEXT:    movdqa %xmm5, %xmm9
; SSE-NEXT:    punpcklwd {{.*#+}} xmm9 = xmm9[0],xmm4[0],xmm9[1],xmm4[1],xmm9[2],xmm4[2],xmm9[3],xmm4[3]
; SSE-NEXT:    movdqa %xmm9, %xmm12
; SSE-NEXT:    punpckldq {{.*#+}} xmm12 = xmm12[0],xmm0[0],xmm12[1],xmm0[1]
; SSE-NEXT:    punpckhdq {{.*#+}} xmm9 = xmm9[2],xmm0[2],xmm9[3],xmm0[3]
; SSE-NEXT:    punpckhwd {{.*#+}} xmm1 = xmm1[4],xmm6[4],xmm1[5],xmm6[5],xmm1[6],xmm6[6],xmm1[7],xmm6[7]
; SSE-NEXT:    punpckhwd {{.*#+}} xmm5 = xmm5[4],xmm4[4],xmm5[5],xmm4[5],xmm5[6],xmm4[6],xmm5[7],xmm4[7]
; SSE-NEXT:    movdqa %xmm5, %xmm10
; SSE-NEXT:    punpckldq {{.*#+}} xmm10 = xmm10[0],xmm1[0],xmm10[1],xmm1[1]
; SSE-NEXT:    punpckhdq {{.*#+}} xmm5 = xmm5[2],xmm1[2],xmm5[3],xmm1[3]
; SSE-NEXT:    movdqa 112(%rdx), %xmm2
; SSE-NEXT:    movdqa 112(%rcx), %xmm7
; SSE-NEXT:    movdqa %xmm2, %xmm6
; SSE-NEXT:    punpcklwd {{.*#+}} xmm6 = xmm6[0],xmm7[0],xmm6[1],xmm7[1],xmm6[2],xmm7[2],xmm6[3],xmm7[3]
; SSE-NEXT:    movdqa 112(%rdi), %xmm0
; SSE-NEXT:    movdqa 112(%rsi), %xmm4
; SSE-NEXT:    movdqa %xmm0, %xmm1
; SSE-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm4[0],xmm1[1],xmm4[1],xmm1[2],xmm4[2],xmm1[3],xmm4[3]
; SSE-NEXT:    movdqa %xmm1, %xmm3
; SSE-NEXT:    punpckldq {{.*#+}} xmm3 = xmm3[0],xmm6[0],xmm3[1],xmm6[1]
; SSE-NEXT:    punpckhdq {{.*#+}} xmm1 = xmm1[2],xmm6[2],xmm1[3],xmm6[3]
; SSE-NEXT:    punpckhwd {{.*#+}} xmm2 = xmm2[4],xmm7[4],xmm2[5],xmm7[5],xmm2[6],xmm7[6],xmm2[7],xmm7[7]
; SSE-NEXT:    punpckhwd {{.*#+}} xmm0 = xmm0[4],xmm4[4],xmm0[5],xmm4[5],xmm0[6],xmm4[6],xmm0[7],xmm4[7]
; SSE-NEXT:    movdqa %xmm0, %xmm4
; SSE-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm2[0],xmm4[1],xmm2[1]
; SSE-NEXT:    punpckhdq {{.*#+}} xmm0 = xmm0[2],xmm2[2],xmm0[3],xmm2[3]
; SSE-NEXT:    movdqa %xmm0, 496(%r8)
; SSE-NEXT:    movdqa %xmm4, 480(%r8)
; SSE-NEXT:    movdqa %xmm1, 464(%r8)
; SSE-NEXT:    movdqa %xmm3, 448(%r8)
; SSE-NEXT:    movdqa %xmm5, 432(%r8)
; SSE-NEXT:    movdqa %xmm10, 416(%r8)
; SSE-NEXT:    movdqa %xmm9, 400(%r8)
; SSE-NEXT:    movdqa %xmm12, 384(%r8)
; SSE-NEXT:    movdqa %xmm11, 368(%r8)
; SSE-NEXT:    movdqa %xmm15, 352(%r8)
; SSE-NEXT:    movdqa %xmm8, 336(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 320(%r8)
; SSE-NEXT:    movdqa %xmm13, 304(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 288(%r8)
; SSE-NEXT:    movdqa %xmm14, 272(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 256(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 240(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 224(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 208(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 192(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 176(%r8)
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 160(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 144(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 128(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 112(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 96(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 80(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 64(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 48(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 32(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, (%r8)
; SSE-NEXT:    addq $184, %rsp
; SSE-NEXT:    retq
;
; AVX-LABEL: store_i16_stride4_vf64:
; AVX:       # %bb.0:
; AVX-NEXT:    subq $40, %rsp
; AVX-NEXT:    vmovdqa 16(%rcx), %xmm1
; AVX-NEXT:    vmovdqa 32(%rcx), %xmm9
; AVX-NEXT:    vmovdqa 48(%rcx), %xmm6
; AVX-NEXT:    vmovdqa 16(%rdx), %xmm2
; AVX-NEXT:    vmovdqa 32(%rdx), %xmm10
; AVX-NEXT:    vmovdqa 48(%rdx), %xmm8
; AVX-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm2[4],xmm1[4],xmm2[5],xmm1[5],xmm2[6],xmm1[6],xmm2[7],xmm1[7]
; AVX-NEXT:    vpshufd {{.*#+}} xmm3 = xmm0[0,0,1,1]
; AVX-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm3, %ymm0
; AVX-NEXT:    vmovdqa 16(%rsi), %xmm3
; AVX-NEXT:    vmovdqa 32(%rsi), %xmm11
; AVX-NEXT:    vmovdqa 16(%rdi), %xmm4
; AVX-NEXT:    vpunpckhwd {{.*#+}} xmm5 = xmm4[4],xmm3[4],xmm4[5],xmm3[5],xmm4[6],xmm3[6],xmm4[7],xmm3[7]
; AVX-NEXT:    vpmovzxdq {{.*#+}} xmm7 = xmm5[0],zero,xmm5[1],zero
; AVX-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[2,2,3,3]
; AVX-NEXT:    vinsertf128 $1, %xmm5, %ymm7, %ymm5
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm5[0],ymm0[1],ymm5[2],ymm0[3],ymm5[4],ymm0[5],ymm5[6],ymm0[7]
; AVX-NEXT:    vmovups %ymm0, (%rsp) # 32-byte Spill
; AVX-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm2[0],xmm1[0],xmm2[1],xmm1[1],xmm2[2],xmm1[2],xmm2[3],xmm1[3]
; AVX-NEXT:    vpshufd {{.*#+}} xmm2 = xmm1[0,0,1,1]
; AVX-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,2,3,3]
; AVX-NEXT:    vinsertf128 $1, %xmm1, %ymm2, %ymm1
; AVX-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm4[0],xmm3[0],xmm4[1],xmm3[1],xmm4[2],xmm3[2],xmm4[3],xmm3[3]
; AVX-NEXT:    vpmovzxdq {{.*#+}} xmm3 = xmm2[0],zero,xmm2[1],zero
; AVX-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[2,2,3,3]
; AVX-NEXT:    vinsertf128 $1, %xmm2, %ymm3, %ymm2
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0],ymm1[1],ymm2[2],ymm1[3],ymm2[4],ymm1[5],ymm2[6],ymm1[7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovdqa 64(%rcx), %xmm3
; AVX-NEXT:    vmovdqa 64(%rdx), %xmm4
; AVX-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm4[0],xmm3[0],xmm4[1],xmm3[1],xmm4[2],xmm3[2],xmm4[3],xmm3[3]
; AVX-NEXT:    vpshufd {{.*#+}} xmm5 = xmm2[0,0,1,1]
; AVX-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[2,2,3,3]
; AVX-NEXT:    vinsertf128 $1, %xmm2, %ymm5, %ymm2
; AVX-NEXT:    vmovdqa 64(%rsi), %xmm5
; AVX-NEXT:    vmovdqa 64(%rdi), %xmm7
; AVX-NEXT:    vpunpcklwd {{.*#+}} xmm12 = xmm7[0],xmm5[0],xmm7[1],xmm5[1],xmm7[2],xmm5[2],xmm7[3],xmm5[3]
; AVX-NEXT:    vpmovzxdq {{.*#+}} xmm13 = xmm12[0],zero,xmm12[1],zero
; AVX-NEXT:    vpshufd {{.*#+}} xmm12 = xmm12[2,2,3,3]
; AVX-NEXT:    vinsertf128 $1, %xmm12, %ymm13, %ymm12
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm12[0],ymm2[1],ymm12[2],ymm2[3],ymm12[4],ymm2[5],ymm12[6],ymm2[7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vpunpckhwd {{.*#+}} xmm3 = xmm4[4],xmm3[4],xmm4[5],xmm3[5],xmm4[6],xmm3[6],xmm4[7],xmm3[7]
; AVX-NEXT:    vpshufd {{.*#+}} xmm4 = xmm3[0,0,1,1]
; AVX-NEXT:    vpshufd {{.*#+}} xmm3 = xmm3[2,2,3,3]
; AVX-NEXT:    vinsertf128 $1, %xmm3, %ymm4, %ymm3
; AVX-NEXT:    vpunpckhwd {{.*#+}} xmm4 = xmm7[4],xmm5[4],xmm7[5],xmm5[5],xmm7[6],xmm5[6],xmm7[7],xmm5[7]
; AVX-NEXT:    vpmovzxdq {{.*#+}} xmm5 = xmm4[0],zero,xmm4[1],zero
; AVX-NEXT:    vpshufd {{.*#+}} xmm4 = xmm4[2,2,3,3]
; AVX-NEXT:    vinsertf128 $1, %xmm4, %ymm5, %ymm4
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm4[0],ymm3[1],ymm4[2],ymm3[3],ymm4[4],ymm3[5],ymm4[6],ymm3[7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovdqa 80(%rcx), %xmm5
; AVX-NEXT:    vmovdqa 80(%rdx), %xmm7
; AVX-NEXT:    vpunpcklwd {{.*#+}} xmm4 = xmm7[0],xmm5[0],xmm7[1],xmm5[1],xmm7[2],xmm5[2],xmm7[3],xmm5[3]
; AVX-NEXT:    vpshufd {{.*#+}} xmm12 = xmm4[0,0,1,1]
; AVX-NEXT:    vpshufd {{.*#+}} xmm4 = xmm4[2,2,3,3]
; AVX-NEXT:    vinsertf128 $1, %xmm4, %ymm12, %ymm4
; AVX-NEXT:    vmovdqa 80(%rsi), %xmm13
; AVX-NEXT:    vmovdqa 80(%rdi), %xmm14
; AVX-NEXT:    vpunpcklwd {{.*#+}} xmm12 = xmm14[0],xmm13[0],xmm14[1],xmm13[1],xmm14[2],xmm13[2],xmm14[3],xmm13[3]
; AVX-NEXT:    vpmovzxdq {{.*#+}} xmm15 = xmm12[0],zero,xmm12[1],zero
; AVX-NEXT:    vpshufd {{.*#+}} xmm12 = xmm12[2,2,3,3]
; AVX-NEXT:    vinsertf128 $1, %xmm12, %ymm15, %ymm15
; AVX-NEXT:    vmovdqa 48(%rsi), %xmm12
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm15[0],ymm4[1],ymm15[2],ymm4[3],ymm15[4],ymm4[5],ymm15[6],ymm4[7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovdqa 32(%rdi), %xmm15
; AVX-NEXT:    vpunpckhwd {{.*#+}} xmm5 = xmm7[4],xmm5[4],xmm7[5],xmm5[5],xmm7[6],xmm5[6],xmm7[7],xmm5[7]
; AVX-NEXT:    vpshufd {{.*#+}} xmm7 = xmm5[0,0,1,1]
; AVX-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[2,2,3,3]
; AVX-NEXT:    vinsertf128 $1, %xmm5, %ymm7, %ymm5
; AVX-NEXT:    vpunpckhwd {{.*#+}} xmm7 = xmm14[4],xmm13[4],xmm14[5],xmm13[5],xmm14[6],xmm13[6],xmm14[7],xmm13[7]
; AVX-NEXT:    vpmovzxdq {{.*#+}} xmm13 = xmm7[0],zero,xmm7[1],zero
; AVX-NEXT:    vpshufd {{.*#+}} xmm7 = xmm7[2,2,3,3]
; AVX-NEXT:    vinsertf128 $1, %xmm7, %ymm13, %ymm7
; AVX-NEXT:    vblendps {{.*#+}} ymm5 = ymm7[0],ymm5[1],ymm7[2],ymm5[3],ymm7[4],ymm5[5],ymm7[6],ymm5[7]
; AVX-NEXT:    vpunpcklwd {{.*#+}} xmm7 = xmm10[0],xmm9[0],xmm10[1],xmm9[1],xmm10[2],xmm9[2],xmm10[3],xmm9[3]
; AVX-NEXT:    vpshufd {{.*#+}} xmm13 = xmm7[0,0,1,1]
; AVX-NEXT:    vpshufd {{.*#+}} xmm7 = xmm7[2,2,3,3]
; AVX-NEXT:    vinsertf128 $1, %xmm7, %ymm13, %ymm7
; AVX-NEXT:    vpunpcklwd {{.*#+}} xmm13 = xmm15[0],xmm11[0],xmm15[1],xmm11[1],xmm15[2],xmm11[2],xmm15[3],xmm11[3]
; AVX-NEXT:    vpmovzxdq {{.*#+}} xmm14 = xmm13[0],zero,xmm13[1],zero
; AVX-NEXT:    vpshufd {{.*#+}} xmm13 = xmm13[2,2,3,3]
; AVX-NEXT:    vinsertf128 $1, %xmm13, %ymm14, %ymm13
; AVX-NEXT:    vmovdqa 48(%rdi), %xmm14
; AVX-NEXT:    vblendps {{.*#+}} ymm7 = ymm13[0],ymm7[1],ymm13[2],ymm7[3],ymm13[4],ymm7[5],ymm13[6],ymm7[7]
; AVX-NEXT:    vpunpckhwd {{.*#+}} xmm9 = xmm10[4],xmm9[4],xmm10[5],xmm9[5],xmm10[6],xmm9[6],xmm10[7],xmm9[7]
; AVX-NEXT:    vpshufd {{.*#+}} xmm10 = xmm9[0,0,1,1]
; AVX-NEXT:    vpshufd {{.*#+}} xmm9 = xmm9[2,2,3,3]
; AVX-NEXT:    vinsertf128 $1, %xmm9, %ymm10, %ymm9
; AVX-NEXT:    vpunpckhwd {{.*#+}} xmm10 = xmm15[4],xmm11[4],xmm15[5],xmm11[5],xmm15[6],xmm11[6],xmm15[7],xmm11[7]
; AVX-NEXT:    vpmovzxdq {{.*#+}} xmm11 = xmm10[0],zero,xmm10[1],zero
; AVX-NEXT:    vpshufd {{.*#+}} xmm10 = xmm10[2,2,3,3]
; AVX-NEXT:    vinsertf128 $1, %xmm10, %ymm11, %ymm10
; AVX-NEXT:    vblendps {{.*#+}} ymm9 = ymm10[0],ymm9[1],ymm10[2],ymm9[3],ymm10[4],ymm9[5],ymm10[6],ymm9[7]
; AVX-NEXT:    vpunpcklwd {{.*#+}} xmm10 = xmm8[0],xmm6[0],xmm8[1],xmm6[1],xmm8[2],xmm6[2],xmm8[3],xmm6[3]
; AVX-NEXT:    vpshufd {{.*#+}} xmm11 = xmm10[0,0,1,1]
; AVX-NEXT:    vpshufd {{.*#+}} xmm10 = xmm10[2,2,3,3]
; AVX-NEXT:    vinsertf128 $1, %xmm10, %ymm11, %ymm10
; AVX-NEXT:    vpunpcklwd {{.*#+}} xmm11 = xmm14[0],xmm12[0],xmm14[1],xmm12[1],xmm14[2],xmm12[2],xmm14[3],xmm12[3]
; AVX-NEXT:    vpmovzxdq {{.*#+}} xmm13 = xmm11[0],zero,xmm11[1],zero
; AVX-NEXT:    vpshufd {{.*#+}} xmm11 = xmm11[2,2,3,3]
; AVX-NEXT:    vinsertf128 $1, %xmm11, %ymm13, %ymm11
; AVX-NEXT:    vblendps {{.*#+}} ymm10 = ymm11[0],ymm10[1],ymm11[2],ymm10[3],ymm11[4],ymm10[5],ymm11[6],ymm10[7]
; AVX-NEXT:    vpunpckhwd {{.*#+}} xmm6 = xmm8[4],xmm6[4],xmm8[5],xmm6[5],xmm8[6],xmm6[6],xmm8[7],xmm6[7]
; AVX-NEXT:    vpshufd {{.*#+}} xmm8 = xmm6[0,0,1,1]
; AVX-NEXT:    vpshufd {{.*#+}} xmm6 = xmm6[2,2,3,3]
; AVX-NEXT:    vinsertf128 $1, %xmm6, %ymm8, %ymm6
; AVX-NEXT:    vpunpckhwd {{.*#+}} xmm8 = xmm14[4],xmm12[4],xmm14[5],xmm12[5],xmm14[6],xmm12[6],xmm14[7],xmm12[7]
; AVX-NEXT:    vpmovzxdq {{.*#+}} xmm11 = xmm8[0],zero,xmm8[1],zero
; AVX-NEXT:    vpshufd {{.*#+}} xmm8 = xmm8[2,2,3,3]
; AVX-NEXT:    vinsertf128 $1, %xmm8, %ymm11, %ymm8
; AVX-NEXT:    vblendps {{.*#+}} ymm6 = ymm8[0],ymm6[1],ymm8[2],ymm6[3],ymm8[4],ymm6[5],ymm8[6],ymm6[7]
; AVX-NEXT:    vmovdqa 96(%rcx), %xmm11
; AVX-NEXT:    vmovdqa 96(%rdx), %xmm12
; AVX-NEXT:    vpunpcklwd {{.*#+}} xmm8 = xmm12[0],xmm11[0],xmm12[1],xmm11[1],xmm12[2],xmm11[2],xmm12[3],xmm11[3]
; AVX-NEXT:    vpshufd {{.*#+}} xmm13 = xmm8[0,0,1,1]
; AVX-NEXT:    vpshufd {{.*#+}} xmm8 = xmm8[2,2,3,3]
; AVX-NEXT:    vinsertf128 $1, %xmm8, %ymm13, %ymm8
; AVX-NEXT:    vmovdqa 96(%rsi), %xmm13
; AVX-NEXT:    vmovdqa 96(%rdi), %xmm14
; AVX-NEXT:    vpunpcklwd {{.*#+}} xmm15 = xmm14[0],xmm13[0],xmm14[1],xmm13[1],xmm14[2],xmm13[2],xmm14[3],xmm13[3]
; AVX-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm15[0],zero,xmm15[1],zero
; AVX-NEXT:    vpshufd {{.*#+}} xmm15 = xmm15[2,2,3,3]
; AVX-NEXT:    vinsertf128 $1, %xmm15, %ymm0, %ymm0
; AVX-NEXT:    vblendps {{.*#+}} ymm8 = ymm0[0],ymm8[1],ymm0[2],ymm8[3],ymm0[4],ymm8[5],ymm0[6],ymm8[7]
; AVX-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm12[4],xmm11[4],xmm12[5],xmm11[5],xmm12[6],xmm11[6],xmm12[7],xmm11[7]
; AVX-NEXT:    vpshufd {{.*#+}} xmm11 = xmm0[0,0,1,1]
; AVX-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm11, %ymm0
; AVX-NEXT:    vpunpckhwd {{.*#+}} xmm11 = xmm14[4],xmm13[4],xmm14[5],xmm13[5],xmm14[6],xmm13[6],xmm14[7],xmm13[7]
; AVX-NEXT:    vpmovzxdq {{.*#+}} xmm12 = xmm11[0],zero,xmm11[1],zero
; AVX-NEXT:    vpshufd {{.*#+}} xmm11 = xmm11[2,2,3,3]
; AVX-NEXT:    vinsertf128 $1, %xmm11, %ymm12, %ymm11
; AVX-NEXT:    vblendps {{.*#+}} ymm11 = ymm11[0],ymm0[1],ymm11[2],ymm0[3],ymm11[4],ymm0[5],ymm11[6],ymm0[7]
; AVX-NEXT:    vmovdqa 112(%rcx), %xmm1
; AVX-NEXT:    vmovdqa 112(%rdx), %xmm13
; AVX-NEXT:    vpunpcklwd {{.*#+}} xmm12 = xmm13[0],xmm1[0],xmm13[1],xmm1[1],xmm13[2],xmm1[2],xmm13[3],xmm1[3]
; AVX-NEXT:    vpshufd {{.*#+}} xmm14 = xmm12[0,0,1,1]
; AVX-NEXT:    vpshufd {{.*#+}} xmm12 = xmm12[2,2,3,3]
; AVX-NEXT:    vinsertf128 $1, %xmm12, %ymm14, %ymm12
; AVX-NEXT:    vmovdqa 112(%rsi), %xmm14
; AVX-NEXT:    vmovdqa 112(%rdi), %xmm15
; AVX-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm15[0],xmm14[0],xmm15[1],xmm14[1],xmm15[2],xmm14[2],xmm15[3],xmm14[3]
; AVX-NEXT:    vpmovzxdq {{.*#+}} xmm2 = xmm0[0],zero,xmm0[1],zero
; AVX-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm2, %ymm0
; AVX-NEXT:    vblendps {{.*#+}} ymm12 = ymm0[0],ymm12[1],ymm0[2],ymm12[3],ymm0[4],ymm12[5],ymm0[6],ymm12[7]
; AVX-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm13[4],xmm1[4],xmm13[5],xmm1[5],xmm13[6],xmm1[6],xmm13[7],xmm1[7]
; AVX-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[0,0,1,1]
; AVX-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX-NEXT:    vpunpckhwd {{.*#+}} xmm1 = xmm15[4],xmm14[4],xmm15[5],xmm14[5],xmm15[6],xmm14[6],xmm15[7],xmm14[7]
; AVX-NEXT:    vpmovzxdq {{.*#+}} xmm2 = xmm1[0],zero,xmm1[1],zero
; AVX-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,2,3,3]
; AVX-NEXT:    vinsertf128 $1, %xmm1, %ymm2, %ymm1
; AVX-NEXT:    vmovdqa (%rcx), %xmm2
; AVX-NEXT:    vblendps {{.*#+}} ymm4 = ymm1[0],ymm0[1],ymm1[2],ymm0[3],ymm1[4],ymm0[5],ymm1[6],ymm0[7]
; AVX-NEXT:    vmovdqa (%rdx), %xmm1
; AVX-NEXT:    vpunpcklwd {{.*#+}} xmm13 = xmm1[0],xmm2[0],xmm1[1],xmm2[1],xmm1[2],xmm2[2],xmm1[3],xmm2[3]
; AVX-NEXT:    vpshufd {{.*#+}} xmm14 = xmm13[0,0,1,1]
; AVX-NEXT:    vpshufd {{.*#+}} xmm13 = xmm13[2,2,3,3]
; AVX-NEXT:    vinsertf128 $1, %xmm13, %ymm14, %ymm13
; AVX-NEXT:    vmovdqa (%rsi), %xmm14
; AVX-NEXT:    vmovdqa (%rdi), %xmm15
; AVX-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm15[0],xmm14[0],xmm15[1],xmm14[1],xmm15[2],xmm14[2],xmm15[3],xmm14[3]
; AVX-NEXT:    vpmovzxdq {{.*#+}} xmm3 = xmm0[0],zero,xmm0[1],zero
; AVX-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm3, %ymm0
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm13[1],ymm0[2],ymm13[3],ymm0[4],ymm13[5],ymm0[6],ymm13[7]
; AVX-NEXT:    vpunpckhwd {{.*#+}} xmm1 = xmm1[4],xmm2[4],xmm1[5],xmm2[5],xmm1[6],xmm2[6],xmm1[7],xmm2[7]
; AVX-NEXT:    vpshufd {{.*#+}} xmm2 = xmm1[0,0,1,1]
; AVX-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,2,3,3]
; AVX-NEXT:    vinsertf128 $1, %xmm1, %ymm2, %ymm1
; AVX-NEXT:    vpunpckhwd {{.*#+}} xmm2 = xmm15[4],xmm14[4],xmm15[5],xmm14[5],xmm15[6],xmm14[6],xmm15[7],xmm14[7]
; AVX-NEXT:    vpmovzxdq {{.*#+}} xmm3 = xmm2[0],zero,xmm2[1],zero
; AVX-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[2,2,3,3]
; AVX-NEXT:    vinsertf128 $1, %xmm2, %ymm3, %ymm2
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0],ymm1[1],ymm2[2],ymm1[3],ymm2[4],ymm1[5],ymm2[6],ymm1[7]
; AVX-NEXT:    vmovaps %ymm1, 32(%r8)
; AVX-NEXT:    vmovaps %ymm0, (%r8)
; AVX-NEXT:    vmovaps %ymm4, 480(%r8)
; AVX-NEXT:    vmovaps %ymm12, 448(%r8)
; AVX-NEXT:    vmovaps %ymm11, 416(%r8)
; AVX-NEXT:    vmovaps %ymm8, 384(%r8)
; AVX-NEXT:    vmovaps %ymm6, 224(%r8)
; AVX-NEXT:    vmovaps %ymm10, 192(%r8)
; AVX-NEXT:    vmovaps %ymm9, 160(%r8)
; AVX-NEXT:    vmovaps %ymm7, 128(%r8)
; AVX-NEXT:    vmovaps %ymm5, 352(%r8)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 320(%r8)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 288(%r8)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 256(%r8)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 64(%r8)
; AVX-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 96(%r8)
; AVX-NEXT:    addq $40, %rsp
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retq
;
; AVX2-LABEL: store_i16_stride4_vf64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    subq $40, %rsp
; AVX2-NEXT:    vmovdqa 16(%rcx), %xmm1
; AVX2-NEXT:    vmovdqa 32(%rcx), %xmm9
; AVX2-NEXT:    vmovdqa 48(%rcx), %xmm6
; AVX2-NEXT:    vmovdqa 16(%rdx), %xmm2
; AVX2-NEXT:    vmovdqa 32(%rdx), %xmm10
; AVX2-NEXT:    vmovdqa 48(%rdx), %xmm8
; AVX2-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm2[4],xmm1[4],xmm2[5],xmm1[5],xmm2[6],xmm1[6],xmm2[7],xmm1[7]
; AVX2-NEXT:    vpshufd {{.*#+}} xmm3 = xmm0[0,0,1,1]
; AVX2-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX2-NEXT:    vinserti128 $1, %xmm0, %ymm3, %ymm0
; AVX2-NEXT:    vmovdqa 16(%rsi), %xmm3
; AVX2-NEXT:    vmovdqa 32(%rsi), %xmm11
; AVX2-NEXT:    vmovdqa 16(%rdi), %xmm4
; AVX2-NEXT:    vpunpckhwd {{.*#+}} xmm5 = xmm4[4],xmm3[4],xmm4[5],xmm3[5],xmm4[6],xmm3[6],xmm4[7],xmm3[7]
; AVX2-NEXT:    vpmovzxdq {{.*#+}} xmm7 = xmm5[0],zero,xmm5[1],zero
; AVX2-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[2,2,3,3]
; AVX2-NEXT:    vinserti128 $1, %xmm5, %ymm7, %ymm5
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm5[0],ymm0[1],ymm5[2],ymm0[3],ymm5[4],ymm0[5],ymm5[6],ymm0[7]
; AVX2-NEXT:    vmovdqu %ymm0, (%rsp) # 32-byte Spill
; AVX2-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm2[0],xmm1[0],xmm2[1],xmm1[1],xmm2[2],xmm1[2],xmm2[3],xmm1[3]
; AVX2-NEXT:    vpshufd {{.*#+}} xmm2 = xmm1[0,0,1,1]
; AVX2-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,2,3,3]
; AVX2-NEXT:    vinserti128 $1, %xmm1, %ymm2, %ymm1
; AVX2-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm4[0],xmm3[0],xmm4[1],xmm3[1],xmm4[2],xmm3[2],xmm4[3],xmm3[3]
; AVX2-NEXT:    vpmovzxdq {{.*#+}} xmm3 = xmm2[0],zero,xmm2[1],zero
; AVX2-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[2,2,3,3]
; AVX2-NEXT:    vinserti128 $1, %xmm2, %ymm3, %ymm2
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm2[0],ymm1[1],ymm2[2],ymm1[3],ymm2[4],ymm1[5],ymm2[6],ymm1[7]
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqa 64(%rcx), %xmm3
; AVX2-NEXT:    vmovdqa 64(%rdx), %xmm4
; AVX2-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm4[0],xmm3[0],xmm4[1],xmm3[1],xmm4[2],xmm3[2],xmm4[3],xmm3[3]
; AVX2-NEXT:    vpshufd {{.*#+}} xmm5 = xmm2[0,0,1,1]
; AVX2-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[2,2,3,3]
; AVX2-NEXT:    vinserti128 $1, %xmm2, %ymm5, %ymm2
; AVX2-NEXT:    vmovdqa 64(%rsi), %xmm5
; AVX2-NEXT:    vmovdqa 64(%rdi), %xmm7
; AVX2-NEXT:    vpunpcklwd {{.*#+}} xmm12 = xmm7[0],xmm5[0],xmm7[1],xmm5[1],xmm7[2],xmm5[2],xmm7[3],xmm5[3]
; AVX2-NEXT:    vpmovzxdq {{.*#+}} xmm13 = xmm12[0],zero,xmm12[1],zero
; AVX2-NEXT:    vpshufd {{.*#+}} xmm12 = xmm12[2,2,3,3]
; AVX2-NEXT:    vinserti128 $1, %xmm12, %ymm13, %ymm12
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm12[0],ymm2[1],ymm12[2],ymm2[3],ymm12[4],ymm2[5],ymm12[6],ymm2[7]
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpunpckhwd {{.*#+}} xmm3 = xmm4[4],xmm3[4],xmm4[5],xmm3[5],xmm4[6],xmm3[6],xmm4[7],xmm3[7]
; AVX2-NEXT:    vpshufd {{.*#+}} xmm4 = xmm3[0,0,1,1]
; AVX2-NEXT:    vpshufd {{.*#+}} xmm3 = xmm3[2,2,3,3]
; AVX2-NEXT:    vinserti128 $1, %xmm3, %ymm4, %ymm3
; AVX2-NEXT:    vpunpckhwd {{.*#+}} xmm4 = xmm7[4],xmm5[4],xmm7[5],xmm5[5],xmm7[6],xmm5[6],xmm7[7],xmm5[7]
; AVX2-NEXT:    vpmovzxdq {{.*#+}} xmm5 = xmm4[0],zero,xmm4[1],zero
; AVX2-NEXT:    vpshufd {{.*#+}} xmm4 = xmm4[2,2,3,3]
; AVX2-NEXT:    vinserti128 $1, %xmm4, %ymm5, %ymm4
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm4[0],ymm3[1],ymm4[2],ymm3[3],ymm4[4],ymm3[5],ymm4[6],ymm3[7]
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqa 80(%rcx), %xmm5
; AVX2-NEXT:    vmovdqa 80(%rdx), %xmm7
; AVX2-NEXT:    vpunpcklwd {{.*#+}} xmm4 = xmm7[0],xmm5[0],xmm7[1],xmm5[1],xmm7[2],xmm5[2],xmm7[3],xmm5[3]
; AVX2-NEXT:    vpshufd {{.*#+}} xmm12 = xmm4[0,0,1,1]
; AVX2-NEXT:    vpshufd {{.*#+}} xmm4 = xmm4[2,2,3,3]
; AVX2-NEXT:    vinserti128 $1, %xmm4, %ymm12, %ymm4
; AVX2-NEXT:    vmovdqa 80(%rsi), %xmm13
; AVX2-NEXT:    vmovdqa 80(%rdi), %xmm14
; AVX2-NEXT:    vpunpcklwd {{.*#+}} xmm12 = xmm14[0],xmm13[0],xmm14[1],xmm13[1],xmm14[2],xmm13[2],xmm14[3],xmm13[3]
; AVX2-NEXT:    vpmovzxdq {{.*#+}} xmm15 = xmm12[0],zero,xmm12[1],zero
; AVX2-NEXT:    vpshufd {{.*#+}} xmm12 = xmm12[2,2,3,3]
; AVX2-NEXT:    vinserti128 $1, %xmm12, %ymm15, %ymm15
; AVX2-NEXT:    vmovdqa 48(%rsi), %xmm12
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm15[0],ymm4[1],ymm15[2],ymm4[3],ymm15[4],ymm4[5],ymm15[6],ymm4[7]
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqa 32(%rdi), %xmm15
; AVX2-NEXT:    vpunpckhwd {{.*#+}} xmm5 = xmm7[4],xmm5[4],xmm7[5],xmm5[5],xmm7[6],xmm5[6],xmm7[7],xmm5[7]
; AVX2-NEXT:    vpshufd {{.*#+}} xmm7 = xmm5[0,0,1,1]
; AVX2-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[2,2,3,3]
; AVX2-NEXT:    vinserti128 $1, %xmm5, %ymm7, %ymm5
; AVX2-NEXT:    vpunpckhwd {{.*#+}} xmm7 = xmm14[4],xmm13[4],xmm14[5],xmm13[5],xmm14[6],xmm13[6],xmm14[7],xmm13[7]
; AVX2-NEXT:    vpmovzxdq {{.*#+}} xmm13 = xmm7[0],zero,xmm7[1],zero
; AVX2-NEXT:    vpshufd {{.*#+}} xmm7 = xmm7[2,2,3,3]
; AVX2-NEXT:    vinserti128 $1, %xmm7, %ymm13, %ymm7
; AVX2-NEXT:    vpblendd {{.*#+}} ymm5 = ymm7[0],ymm5[1],ymm7[2],ymm5[3],ymm7[4],ymm5[5],ymm7[6],ymm5[7]
; AVX2-NEXT:    vpunpcklwd {{.*#+}} xmm7 = xmm10[0],xmm9[0],xmm10[1],xmm9[1],xmm10[2],xmm9[2],xmm10[3],xmm9[3]
; AVX2-NEXT:    vpshufd {{.*#+}} xmm13 = xmm7[0,0,1,1]
; AVX2-NEXT:    vpshufd {{.*#+}} xmm7 = xmm7[2,2,3,3]
; AVX2-NEXT:    vinserti128 $1, %xmm7, %ymm13, %ymm7
; AVX2-NEXT:    vpunpcklwd {{.*#+}} xmm13 = xmm15[0],xmm11[0],xmm15[1],xmm11[1],xmm15[2],xmm11[2],xmm15[3],xmm11[3]
; AVX2-NEXT:    vpmovzxdq {{.*#+}} xmm14 = xmm13[0],zero,xmm13[1],zero
; AVX2-NEXT:    vpshufd {{.*#+}} xmm13 = xmm13[2,2,3,3]
; AVX2-NEXT:    vinserti128 $1, %xmm13, %ymm14, %ymm13
; AVX2-NEXT:    vmovdqa 48(%rdi), %xmm14
; AVX2-NEXT:    vpblendd {{.*#+}} ymm7 = ymm13[0],ymm7[1],ymm13[2],ymm7[3],ymm13[4],ymm7[5],ymm13[6],ymm7[7]
; AVX2-NEXT:    vpunpckhwd {{.*#+}} xmm9 = xmm10[4],xmm9[4],xmm10[5],xmm9[5],xmm10[6],xmm9[6],xmm10[7],xmm9[7]
; AVX2-NEXT:    vpshufd {{.*#+}} xmm10 = xmm9[0,0,1,1]
; AVX2-NEXT:    vpshufd {{.*#+}} xmm9 = xmm9[2,2,3,3]
; AVX2-NEXT:    vinserti128 $1, %xmm9, %ymm10, %ymm9
; AVX2-NEXT:    vpunpckhwd {{.*#+}} xmm10 = xmm15[4],xmm11[4],xmm15[5],xmm11[5],xmm15[6],xmm11[6],xmm15[7],xmm11[7]
; AVX2-NEXT:    vpmovzxdq {{.*#+}} xmm11 = xmm10[0],zero,xmm10[1],zero
; AVX2-NEXT:    vpshufd {{.*#+}} xmm10 = xmm10[2,2,3,3]
; AVX2-NEXT:    vinserti128 $1, %xmm10, %ymm11, %ymm10
; AVX2-NEXT:    vpblendd {{.*#+}} ymm9 = ymm10[0],ymm9[1],ymm10[2],ymm9[3],ymm10[4],ymm9[5],ymm10[6],ymm9[7]
; AVX2-NEXT:    vpunpcklwd {{.*#+}} xmm10 = xmm8[0],xmm6[0],xmm8[1],xmm6[1],xmm8[2],xmm6[2],xmm8[3],xmm6[3]
; AVX2-NEXT:    vpshufd {{.*#+}} xmm11 = xmm10[0,0,1,1]
; AVX2-NEXT:    vpshufd {{.*#+}} xmm10 = xmm10[2,2,3,3]
; AVX2-NEXT:    vinserti128 $1, %xmm10, %ymm11, %ymm10
; AVX2-NEXT:    vpunpcklwd {{.*#+}} xmm11 = xmm14[0],xmm12[0],xmm14[1],xmm12[1],xmm14[2],xmm12[2],xmm14[3],xmm12[3]
; AVX2-NEXT:    vpmovzxdq {{.*#+}} xmm13 = xmm11[0],zero,xmm11[1],zero
; AVX2-NEXT:    vpshufd {{.*#+}} xmm11 = xmm11[2,2,3,3]
; AVX2-NEXT:    vinserti128 $1, %xmm11, %ymm13, %ymm11
; AVX2-NEXT:    vpblendd {{.*#+}} ymm10 = ymm11[0],ymm10[1],ymm11[2],ymm10[3],ymm11[4],ymm10[5],ymm11[6],ymm10[7]
; AVX2-NEXT:    vpunpckhwd {{.*#+}} xmm6 = xmm8[4],xmm6[4],xmm8[5],xmm6[5],xmm8[6],xmm6[6],xmm8[7],xmm6[7]
; AVX2-NEXT:    vpshufd {{.*#+}} xmm8 = xmm6[0,0,1,1]
; AVX2-NEXT:    vpshufd {{.*#+}} xmm6 = xmm6[2,2,3,3]
; AVX2-NEXT:    vinserti128 $1, %xmm6, %ymm8, %ymm6
; AVX2-NEXT:    vpunpckhwd {{.*#+}} xmm8 = xmm14[4],xmm12[4],xmm14[5],xmm12[5],xmm14[6],xmm12[6],xmm14[7],xmm12[7]
; AVX2-NEXT:    vpmovzxdq {{.*#+}} xmm11 = xmm8[0],zero,xmm8[1],zero
; AVX2-NEXT:    vpshufd {{.*#+}} xmm8 = xmm8[2,2,3,3]
; AVX2-NEXT:    vinserti128 $1, %xmm8, %ymm11, %ymm8
; AVX2-NEXT:    vpblendd {{.*#+}} ymm6 = ymm8[0],ymm6[1],ymm8[2],ymm6[3],ymm8[4],ymm6[5],ymm8[6],ymm6[7]
; AVX2-NEXT:    vmovdqa 96(%rcx), %xmm11
; AVX2-NEXT:    vmovdqa 96(%rdx), %xmm12
; AVX2-NEXT:    vpunpcklwd {{.*#+}} xmm8 = xmm12[0],xmm11[0],xmm12[1],xmm11[1],xmm12[2],xmm11[2],xmm12[3],xmm11[3]
; AVX2-NEXT:    vpshufd {{.*#+}} xmm13 = xmm8[0,0,1,1]
; AVX2-NEXT:    vpshufd {{.*#+}} xmm8 = xmm8[2,2,3,3]
; AVX2-NEXT:    vinserti128 $1, %xmm8, %ymm13, %ymm8
; AVX2-NEXT:    vmovdqa 96(%rsi), %xmm13
; AVX2-NEXT:    vmovdqa 96(%rdi), %xmm14
; AVX2-NEXT:    vpunpcklwd {{.*#+}} xmm15 = xmm14[0],xmm13[0],xmm14[1],xmm13[1],xmm14[2],xmm13[2],xmm14[3],xmm13[3]
; AVX2-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm15[0],zero,xmm15[1],zero
; AVX2-NEXT:    vpshufd {{.*#+}} xmm15 = xmm15[2,2,3,3]
; AVX2-NEXT:    vinserti128 $1, %xmm15, %ymm0, %ymm0
; AVX2-NEXT:    vpblendd {{.*#+}} ymm8 = ymm0[0],ymm8[1],ymm0[2],ymm8[3],ymm0[4],ymm8[5],ymm0[6],ymm8[7]
; AVX2-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm12[4],xmm11[4],xmm12[5],xmm11[5],xmm12[6],xmm11[6],xmm12[7],xmm11[7]
; AVX2-NEXT:    vpshufd {{.*#+}} xmm11 = xmm0[0,0,1,1]
; AVX2-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX2-NEXT:    vinserti128 $1, %xmm0, %ymm11, %ymm0
; AVX2-NEXT:    vpunpckhwd {{.*#+}} xmm11 = xmm14[4],xmm13[4],xmm14[5],xmm13[5],xmm14[6],xmm13[6],xmm14[7],xmm13[7]
; AVX2-NEXT:    vpmovzxdq {{.*#+}} xmm12 = xmm11[0],zero,xmm11[1],zero
; AVX2-NEXT:    vpshufd {{.*#+}} xmm11 = xmm11[2,2,3,3]
; AVX2-NEXT:    vinserti128 $1, %xmm11, %ymm12, %ymm11
; AVX2-NEXT:    vpblendd {{.*#+}} ymm11 = ymm11[0],ymm0[1],ymm11[2],ymm0[3],ymm11[4],ymm0[5],ymm11[6],ymm0[7]
; AVX2-NEXT:    vmovdqa 112(%rcx), %xmm1
; AVX2-NEXT:    vmovdqa 112(%rdx), %xmm13
; AVX2-NEXT:    vpunpcklwd {{.*#+}} xmm12 = xmm13[0],xmm1[0],xmm13[1],xmm1[1],xmm13[2],xmm1[2],xmm13[3],xmm1[3]
; AVX2-NEXT:    vpshufd {{.*#+}} xmm14 = xmm12[0,0,1,1]
; AVX2-NEXT:    vpshufd {{.*#+}} xmm12 = xmm12[2,2,3,3]
; AVX2-NEXT:    vinserti128 $1, %xmm12, %ymm14, %ymm12
; AVX2-NEXT:    vmovdqa 112(%rsi), %xmm14
; AVX2-NEXT:    vmovdqa 112(%rdi), %xmm15
; AVX2-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm15[0],xmm14[0],xmm15[1],xmm14[1],xmm15[2],xmm14[2],xmm15[3],xmm14[3]
; AVX2-NEXT:    vpmovzxdq {{.*#+}} xmm2 = xmm0[0],zero,xmm0[1],zero
; AVX2-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX2-NEXT:    vinserti128 $1, %xmm0, %ymm2, %ymm0
; AVX2-NEXT:    vpblendd {{.*#+}} ymm12 = ymm0[0],ymm12[1],ymm0[2],ymm12[3],ymm0[4],ymm12[5],ymm0[6],ymm12[7]
; AVX2-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm13[4],xmm1[4],xmm13[5],xmm1[5],xmm13[6],xmm1[6],xmm13[7],xmm1[7]
; AVX2-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[0,0,1,1]
; AVX2-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX2-NEXT:    vinserti128 $1, %xmm0, %ymm1, %ymm0
; AVX2-NEXT:    vpunpckhwd {{.*#+}} xmm1 = xmm15[4],xmm14[4],xmm15[5],xmm14[5],xmm15[6],xmm14[6],xmm15[7],xmm14[7]
; AVX2-NEXT:    vpmovzxdq {{.*#+}} xmm2 = xmm1[0],zero,xmm1[1],zero
; AVX2-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,2,3,3]
; AVX2-NEXT:    vinserti128 $1, %xmm1, %ymm2, %ymm1
; AVX2-NEXT:    vmovdqa (%rcx), %xmm2
; AVX2-NEXT:    vpblendd {{.*#+}} ymm4 = ymm1[0],ymm0[1],ymm1[2],ymm0[3],ymm1[4],ymm0[5],ymm1[6],ymm0[7]
; AVX2-NEXT:    vmovdqa (%rdx), %xmm1
; AVX2-NEXT:    vpunpcklwd {{.*#+}} xmm13 = xmm1[0],xmm2[0],xmm1[1],xmm2[1],xmm1[2],xmm2[2],xmm1[3],xmm2[3]
; AVX2-NEXT:    vpshufd {{.*#+}} xmm14 = xmm13[0,0,1,1]
; AVX2-NEXT:    vpshufd {{.*#+}} xmm13 = xmm13[2,2,3,3]
; AVX2-NEXT:    vinserti128 $1, %xmm13, %ymm14, %ymm13
; AVX2-NEXT:    vmovdqa (%rsi), %xmm14
; AVX2-NEXT:    vmovdqa (%rdi), %xmm15
; AVX2-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm15[0],xmm14[0],xmm15[1],xmm14[1],xmm15[2],xmm14[2],xmm15[3],xmm14[3]
; AVX2-NEXT:    vpmovzxdq {{.*#+}} xmm3 = xmm0[0],zero,xmm0[1],zero
; AVX2-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX2-NEXT:    vinserti128 $1, %xmm0, %ymm3, %ymm0
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0],ymm13[1],ymm0[2],ymm13[3],ymm0[4],ymm13[5],ymm0[6],ymm13[7]
; AVX2-NEXT:    vpunpckhwd {{.*#+}} xmm1 = xmm1[4],xmm2[4],xmm1[5],xmm2[5],xmm1[6],xmm2[6],xmm1[7],xmm2[7]
; AVX2-NEXT:    vpshufd {{.*#+}} xmm2 = xmm1[0,0,1,1]
; AVX2-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,2,3,3]
; AVX2-NEXT:    vinserti128 $1, %xmm1, %ymm2, %ymm1
; AVX2-NEXT:    vpunpckhwd {{.*#+}} xmm2 = xmm15[4],xmm14[4],xmm15[5],xmm14[5],xmm15[6],xmm14[6],xmm15[7],xmm14[7]
; AVX2-NEXT:    vpmovzxdq {{.*#+}} xmm3 = xmm2[0],zero,xmm2[1],zero
; AVX2-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[2,2,3,3]
; AVX2-NEXT:    vinserti128 $1, %xmm2, %ymm3, %ymm2
; AVX2-NEXT:    vpblendd {{.*#+}} ymm1 = ymm2[0],ymm1[1],ymm2[2],ymm1[3],ymm2[4],ymm1[5],ymm2[6],ymm1[7]
; AVX2-NEXT:    vmovdqa %ymm1, 32(%r8)
; AVX2-NEXT:    vmovdqa %ymm0, (%r8)
; AVX2-NEXT:    vmovdqa %ymm4, 480(%r8)
; AVX2-NEXT:    vmovdqa %ymm12, 448(%r8)
; AVX2-NEXT:    vmovdqa %ymm11, 416(%r8)
; AVX2-NEXT:    vmovdqa %ymm8, 384(%r8)
; AVX2-NEXT:    vmovdqa %ymm6, 224(%r8)
; AVX2-NEXT:    vmovdqa %ymm10, 192(%r8)
; AVX2-NEXT:    vmovdqa %ymm9, 160(%r8)
; AVX2-NEXT:    vmovdqa %ymm7, 128(%r8)
; AVX2-NEXT:    vmovdqa %ymm5, 352(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 320(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 288(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 256(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 64(%r8)
; AVX2-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 96(%r8)
; AVX2-NEXT:    addq $40, %rsp
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX2-FP-LABEL: store_i16_stride4_vf64:
; AVX2-FP:       # %bb.0:
; AVX2-FP-NEXT:    subq $40, %rsp
; AVX2-FP-NEXT:    vmovdqa 16(%rcx), %xmm1
; AVX2-FP-NEXT:    vmovdqa 32(%rcx), %xmm9
; AVX2-FP-NEXT:    vmovdqa 48(%rcx), %xmm6
; AVX2-FP-NEXT:    vmovdqa 16(%rdx), %xmm2
; AVX2-FP-NEXT:    vmovdqa 32(%rdx), %xmm10
; AVX2-FP-NEXT:    vmovdqa 48(%rdx), %xmm8
; AVX2-FP-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm2[4],xmm1[4],xmm2[5],xmm1[5],xmm2[6],xmm1[6],xmm2[7],xmm1[7]
; AVX2-FP-NEXT:    vpshufd {{.*#+}} xmm3 = xmm0[0,0,1,1]
; AVX2-FP-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX2-FP-NEXT:    vinserti128 $1, %xmm0, %ymm3, %ymm0
; AVX2-FP-NEXT:    vmovdqa 16(%rsi), %xmm3
; AVX2-FP-NEXT:    vmovdqa 32(%rsi), %xmm11
; AVX2-FP-NEXT:    vmovdqa 16(%rdi), %xmm4
; AVX2-FP-NEXT:    vpunpckhwd {{.*#+}} xmm5 = xmm4[4],xmm3[4],xmm4[5],xmm3[5],xmm4[6],xmm3[6],xmm4[7],xmm3[7]
; AVX2-FP-NEXT:    vpmovzxdq {{.*#+}} xmm7 = xmm5[0],zero,xmm5[1],zero
; AVX2-FP-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[2,2,3,3]
; AVX2-FP-NEXT:    vinserti128 $1, %xmm5, %ymm7, %ymm5
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm5[0],ymm0[1],ymm5[2],ymm0[3],ymm5[4],ymm0[5],ymm5[6],ymm0[7]
; AVX2-FP-NEXT:    vmovdqu %ymm0, (%rsp) # 32-byte Spill
; AVX2-FP-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm2[0],xmm1[0],xmm2[1],xmm1[1],xmm2[2],xmm1[2],xmm2[3],xmm1[3]
; AVX2-FP-NEXT:    vpshufd {{.*#+}} xmm2 = xmm1[0,0,1,1]
; AVX2-FP-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,2,3,3]
; AVX2-FP-NEXT:    vinserti128 $1, %xmm1, %ymm2, %ymm1
; AVX2-FP-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm4[0],xmm3[0],xmm4[1],xmm3[1],xmm4[2],xmm3[2],xmm4[3],xmm3[3]
; AVX2-FP-NEXT:    vpmovzxdq {{.*#+}} xmm3 = xmm2[0],zero,xmm2[1],zero
; AVX2-FP-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[2,2,3,3]
; AVX2-FP-NEXT:    vinserti128 $1, %xmm2, %ymm3, %ymm2
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm2[0],ymm1[1],ymm2[2],ymm1[3],ymm2[4],ymm1[5],ymm2[6],ymm1[7]
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqa 64(%rcx), %xmm3
; AVX2-FP-NEXT:    vmovdqa 64(%rdx), %xmm4
; AVX2-FP-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm4[0],xmm3[0],xmm4[1],xmm3[1],xmm4[2],xmm3[2],xmm4[3],xmm3[3]
; AVX2-FP-NEXT:    vpshufd {{.*#+}} xmm5 = xmm2[0,0,1,1]
; AVX2-FP-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[2,2,3,3]
; AVX2-FP-NEXT:    vinserti128 $1, %xmm2, %ymm5, %ymm2
; AVX2-FP-NEXT:    vmovdqa 64(%rsi), %xmm5
; AVX2-FP-NEXT:    vmovdqa 64(%rdi), %xmm7
; AVX2-FP-NEXT:    vpunpcklwd {{.*#+}} xmm12 = xmm7[0],xmm5[0],xmm7[1],xmm5[1],xmm7[2],xmm5[2],xmm7[3],xmm5[3]
; AVX2-FP-NEXT:    vpmovzxdq {{.*#+}} xmm13 = xmm12[0],zero,xmm12[1],zero
; AVX2-FP-NEXT:    vpshufd {{.*#+}} xmm12 = xmm12[2,2,3,3]
; AVX2-FP-NEXT:    vinserti128 $1, %xmm12, %ymm13, %ymm12
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm12[0],ymm2[1],ymm12[2],ymm2[3],ymm12[4],ymm2[5],ymm12[6],ymm2[7]
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpunpckhwd {{.*#+}} xmm3 = xmm4[4],xmm3[4],xmm4[5],xmm3[5],xmm4[6],xmm3[6],xmm4[7],xmm3[7]
; AVX2-FP-NEXT:    vpshufd {{.*#+}} xmm4 = xmm3[0,0,1,1]
; AVX2-FP-NEXT:    vpshufd {{.*#+}} xmm3 = xmm3[2,2,3,3]
; AVX2-FP-NEXT:    vinserti128 $1, %xmm3, %ymm4, %ymm3
; AVX2-FP-NEXT:    vpunpckhwd {{.*#+}} xmm4 = xmm7[4],xmm5[4],xmm7[5],xmm5[5],xmm7[6],xmm5[6],xmm7[7],xmm5[7]
; AVX2-FP-NEXT:    vpmovzxdq {{.*#+}} xmm5 = xmm4[0],zero,xmm4[1],zero
; AVX2-FP-NEXT:    vpshufd {{.*#+}} xmm4 = xmm4[2,2,3,3]
; AVX2-FP-NEXT:    vinserti128 $1, %xmm4, %ymm5, %ymm4
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm4[0],ymm3[1],ymm4[2],ymm3[3],ymm4[4],ymm3[5],ymm4[6],ymm3[7]
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqa 80(%rcx), %xmm5
; AVX2-FP-NEXT:    vmovdqa 80(%rdx), %xmm7
; AVX2-FP-NEXT:    vpunpcklwd {{.*#+}} xmm4 = xmm7[0],xmm5[0],xmm7[1],xmm5[1],xmm7[2],xmm5[2],xmm7[3],xmm5[3]
; AVX2-FP-NEXT:    vpshufd {{.*#+}} xmm12 = xmm4[0,0,1,1]
; AVX2-FP-NEXT:    vpshufd {{.*#+}} xmm4 = xmm4[2,2,3,3]
; AVX2-FP-NEXT:    vinserti128 $1, %xmm4, %ymm12, %ymm4
; AVX2-FP-NEXT:    vmovdqa 80(%rsi), %xmm13
; AVX2-FP-NEXT:    vmovdqa 80(%rdi), %xmm14
; AVX2-FP-NEXT:    vpunpcklwd {{.*#+}} xmm12 = xmm14[0],xmm13[0],xmm14[1],xmm13[1],xmm14[2],xmm13[2],xmm14[3],xmm13[3]
; AVX2-FP-NEXT:    vpmovzxdq {{.*#+}} xmm15 = xmm12[0],zero,xmm12[1],zero
; AVX2-FP-NEXT:    vpshufd {{.*#+}} xmm12 = xmm12[2,2,3,3]
; AVX2-FP-NEXT:    vinserti128 $1, %xmm12, %ymm15, %ymm15
; AVX2-FP-NEXT:    vmovdqa 48(%rsi), %xmm12
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm15[0],ymm4[1],ymm15[2],ymm4[3],ymm15[4],ymm4[5],ymm15[6],ymm4[7]
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqa 32(%rdi), %xmm15
; AVX2-FP-NEXT:    vpunpckhwd {{.*#+}} xmm5 = xmm7[4],xmm5[4],xmm7[5],xmm5[5],xmm7[6],xmm5[6],xmm7[7],xmm5[7]
; AVX2-FP-NEXT:    vpshufd {{.*#+}} xmm7 = xmm5[0,0,1,1]
; AVX2-FP-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[2,2,3,3]
; AVX2-FP-NEXT:    vinserti128 $1, %xmm5, %ymm7, %ymm5
; AVX2-FP-NEXT:    vpunpckhwd {{.*#+}} xmm7 = xmm14[4],xmm13[4],xmm14[5],xmm13[5],xmm14[6],xmm13[6],xmm14[7],xmm13[7]
; AVX2-FP-NEXT:    vpmovzxdq {{.*#+}} xmm13 = xmm7[0],zero,xmm7[1],zero
; AVX2-FP-NEXT:    vpshufd {{.*#+}} xmm7 = xmm7[2,2,3,3]
; AVX2-FP-NEXT:    vinserti128 $1, %xmm7, %ymm13, %ymm7
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm5 = ymm7[0],ymm5[1],ymm7[2],ymm5[3],ymm7[4],ymm5[5],ymm7[6],ymm5[7]
; AVX2-FP-NEXT:    vpunpcklwd {{.*#+}} xmm7 = xmm10[0],xmm9[0],xmm10[1],xmm9[1],xmm10[2],xmm9[2],xmm10[3],xmm9[3]
; AVX2-FP-NEXT:    vpshufd {{.*#+}} xmm13 = xmm7[0,0,1,1]
; AVX2-FP-NEXT:    vpshufd {{.*#+}} xmm7 = xmm7[2,2,3,3]
; AVX2-FP-NEXT:    vinserti128 $1, %xmm7, %ymm13, %ymm7
; AVX2-FP-NEXT:    vpunpcklwd {{.*#+}} xmm13 = xmm15[0],xmm11[0],xmm15[1],xmm11[1],xmm15[2],xmm11[2],xmm15[3],xmm11[3]
; AVX2-FP-NEXT:    vpmovzxdq {{.*#+}} xmm14 = xmm13[0],zero,xmm13[1],zero
; AVX2-FP-NEXT:    vpshufd {{.*#+}} xmm13 = xmm13[2,2,3,3]
; AVX2-FP-NEXT:    vinserti128 $1, %xmm13, %ymm14, %ymm13
; AVX2-FP-NEXT:    vmovdqa 48(%rdi), %xmm14
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm7 = ymm13[0],ymm7[1],ymm13[2],ymm7[3],ymm13[4],ymm7[5],ymm13[6],ymm7[7]
; AVX2-FP-NEXT:    vpunpckhwd {{.*#+}} xmm9 = xmm10[4],xmm9[4],xmm10[5],xmm9[5],xmm10[6],xmm9[6],xmm10[7],xmm9[7]
; AVX2-FP-NEXT:    vpshufd {{.*#+}} xmm10 = xmm9[0,0,1,1]
; AVX2-FP-NEXT:    vpshufd {{.*#+}} xmm9 = xmm9[2,2,3,3]
; AVX2-FP-NEXT:    vinserti128 $1, %xmm9, %ymm10, %ymm9
; AVX2-FP-NEXT:    vpunpckhwd {{.*#+}} xmm10 = xmm15[4],xmm11[4],xmm15[5],xmm11[5],xmm15[6],xmm11[6],xmm15[7],xmm11[7]
; AVX2-FP-NEXT:    vpmovzxdq {{.*#+}} xmm11 = xmm10[0],zero,xmm10[1],zero
; AVX2-FP-NEXT:    vpshufd {{.*#+}} xmm10 = xmm10[2,2,3,3]
; AVX2-FP-NEXT:    vinserti128 $1, %xmm10, %ymm11, %ymm10
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm9 = ymm10[0],ymm9[1],ymm10[2],ymm9[3],ymm10[4],ymm9[5],ymm10[6],ymm9[7]
; AVX2-FP-NEXT:    vpunpcklwd {{.*#+}} xmm10 = xmm8[0],xmm6[0],xmm8[1],xmm6[1],xmm8[2],xmm6[2],xmm8[3],xmm6[3]
; AVX2-FP-NEXT:    vpshufd {{.*#+}} xmm11 = xmm10[0,0,1,1]
; AVX2-FP-NEXT:    vpshufd {{.*#+}} xmm10 = xmm10[2,2,3,3]
; AVX2-FP-NEXT:    vinserti128 $1, %xmm10, %ymm11, %ymm10
; AVX2-FP-NEXT:    vpunpcklwd {{.*#+}} xmm11 = xmm14[0],xmm12[0],xmm14[1],xmm12[1],xmm14[2],xmm12[2],xmm14[3],xmm12[3]
; AVX2-FP-NEXT:    vpmovzxdq {{.*#+}} xmm13 = xmm11[0],zero,xmm11[1],zero
; AVX2-FP-NEXT:    vpshufd {{.*#+}} xmm11 = xmm11[2,2,3,3]
; AVX2-FP-NEXT:    vinserti128 $1, %xmm11, %ymm13, %ymm11
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm10 = ymm11[0],ymm10[1],ymm11[2],ymm10[3],ymm11[4],ymm10[5],ymm11[6],ymm10[7]
; AVX2-FP-NEXT:    vpunpckhwd {{.*#+}} xmm6 = xmm8[4],xmm6[4],xmm8[5],xmm6[5],xmm8[6],xmm6[6],xmm8[7],xmm6[7]
; AVX2-FP-NEXT:    vpshufd {{.*#+}} xmm8 = xmm6[0,0,1,1]
; AVX2-FP-NEXT:    vpshufd {{.*#+}} xmm6 = xmm6[2,2,3,3]
; AVX2-FP-NEXT:    vinserti128 $1, %xmm6, %ymm8, %ymm6
; AVX2-FP-NEXT:    vpunpckhwd {{.*#+}} xmm8 = xmm14[4],xmm12[4],xmm14[5],xmm12[5],xmm14[6],xmm12[6],xmm14[7],xmm12[7]
; AVX2-FP-NEXT:    vpmovzxdq {{.*#+}} xmm11 = xmm8[0],zero,xmm8[1],zero
; AVX2-FP-NEXT:    vpshufd {{.*#+}} xmm8 = xmm8[2,2,3,3]
; AVX2-FP-NEXT:    vinserti128 $1, %xmm8, %ymm11, %ymm8
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm6 = ymm8[0],ymm6[1],ymm8[2],ymm6[3],ymm8[4],ymm6[5],ymm8[6],ymm6[7]
; AVX2-FP-NEXT:    vmovdqa 96(%rcx), %xmm11
; AVX2-FP-NEXT:    vmovdqa 96(%rdx), %xmm12
; AVX2-FP-NEXT:    vpunpcklwd {{.*#+}} xmm8 = xmm12[0],xmm11[0],xmm12[1],xmm11[1],xmm12[2],xmm11[2],xmm12[3],xmm11[3]
; AVX2-FP-NEXT:    vpshufd {{.*#+}} xmm13 = xmm8[0,0,1,1]
; AVX2-FP-NEXT:    vpshufd {{.*#+}} xmm8 = xmm8[2,2,3,3]
; AVX2-FP-NEXT:    vinserti128 $1, %xmm8, %ymm13, %ymm8
; AVX2-FP-NEXT:    vmovdqa 96(%rsi), %xmm13
; AVX2-FP-NEXT:    vmovdqa 96(%rdi), %xmm14
; AVX2-FP-NEXT:    vpunpcklwd {{.*#+}} xmm15 = xmm14[0],xmm13[0],xmm14[1],xmm13[1],xmm14[2],xmm13[2],xmm14[3],xmm13[3]
; AVX2-FP-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm15[0],zero,xmm15[1],zero
; AVX2-FP-NEXT:    vpshufd {{.*#+}} xmm15 = xmm15[2,2,3,3]
; AVX2-FP-NEXT:    vinserti128 $1, %xmm15, %ymm0, %ymm0
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm8 = ymm0[0],ymm8[1],ymm0[2],ymm8[3],ymm0[4],ymm8[5],ymm0[6],ymm8[7]
; AVX2-FP-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm12[4],xmm11[4],xmm12[5],xmm11[5],xmm12[6],xmm11[6],xmm12[7],xmm11[7]
; AVX2-FP-NEXT:    vpshufd {{.*#+}} xmm11 = xmm0[0,0,1,1]
; AVX2-FP-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX2-FP-NEXT:    vinserti128 $1, %xmm0, %ymm11, %ymm0
; AVX2-FP-NEXT:    vpunpckhwd {{.*#+}} xmm11 = xmm14[4],xmm13[4],xmm14[5],xmm13[5],xmm14[6],xmm13[6],xmm14[7],xmm13[7]
; AVX2-FP-NEXT:    vpmovzxdq {{.*#+}} xmm12 = xmm11[0],zero,xmm11[1],zero
; AVX2-FP-NEXT:    vpshufd {{.*#+}} xmm11 = xmm11[2,2,3,3]
; AVX2-FP-NEXT:    vinserti128 $1, %xmm11, %ymm12, %ymm11
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm11 = ymm11[0],ymm0[1],ymm11[2],ymm0[3],ymm11[4],ymm0[5],ymm11[6],ymm0[7]
; AVX2-FP-NEXT:    vmovdqa 112(%rcx), %xmm1
; AVX2-FP-NEXT:    vmovdqa 112(%rdx), %xmm13
; AVX2-FP-NEXT:    vpunpcklwd {{.*#+}} xmm12 = xmm13[0],xmm1[0],xmm13[1],xmm1[1],xmm13[2],xmm1[2],xmm13[3],xmm1[3]
; AVX2-FP-NEXT:    vpshufd {{.*#+}} xmm14 = xmm12[0,0,1,1]
; AVX2-FP-NEXT:    vpshufd {{.*#+}} xmm12 = xmm12[2,2,3,3]
; AVX2-FP-NEXT:    vinserti128 $1, %xmm12, %ymm14, %ymm12
; AVX2-FP-NEXT:    vmovdqa 112(%rsi), %xmm14
; AVX2-FP-NEXT:    vmovdqa 112(%rdi), %xmm15
; AVX2-FP-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm15[0],xmm14[0],xmm15[1],xmm14[1],xmm15[2],xmm14[2],xmm15[3],xmm14[3]
; AVX2-FP-NEXT:    vpmovzxdq {{.*#+}} xmm2 = xmm0[0],zero,xmm0[1],zero
; AVX2-FP-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX2-FP-NEXT:    vinserti128 $1, %xmm0, %ymm2, %ymm0
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm12 = ymm0[0],ymm12[1],ymm0[2],ymm12[3],ymm0[4],ymm12[5],ymm0[6],ymm12[7]
; AVX2-FP-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm13[4],xmm1[4],xmm13[5],xmm1[5],xmm13[6],xmm1[6],xmm13[7],xmm1[7]
; AVX2-FP-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[0,0,1,1]
; AVX2-FP-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX2-FP-NEXT:    vinserti128 $1, %xmm0, %ymm1, %ymm0
; AVX2-FP-NEXT:    vpunpckhwd {{.*#+}} xmm1 = xmm15[4],xmm14[4],xmm15[5],xmm14[5],xmm15[6],xmm14[6],xmm15[7],xmm14[7]
; AVX2-FP-NEXT:    vpmovzxdq {{.*#+}} xmm2 = xmm1[0],zero,xmm1[1],zero
; AVX2-FP-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,2,3,3]
; AVX2-FP-NEXT:    vinserti128 $1, %xmm1, %ymm2, %ymm1
; AVX2-FP-NEXT:    vmovdqa (%rcx), %xmm2
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm4 = ymm1[0],ymm0[1],ymm1[2],ymm0[3],ymm1[4],ymm0[5],ymm1[6],ymm0[7]
; AVX2-FP-NEXT:    vmovdqa (%rdx), %xmm1
; AVX2-FP-NEXT:    vpunpcklwd {{.*#+}} xmm13 = xmm1[0],xmm2[0],xmm1[1],xmm2[1],xmm1[2],xmm2[2],xmm1[3],xmm2[3]
; AVX2-FP-NEXT:    vpshufd {{.*#+}} xmm14 = xmm13[0,0,1,1]
; AVX2-FP-NEXT:    vpshufd {{.*#+}} xmm13 = xmm13[2,2,3,3]
; AVX2-FP-NEXT:    vinserti128 $1, %xmm13, %ymm14, %ymm13
; AVX2-FP-NEXT:    vmovdqa (%rsi), %xmm14
; AVX2-FP-NEXT:    vmovdqa (%rdi), %xmm15
; AVX2-FP-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm15[0],xmm14[0],xmm15[1],xmm14[1],xmm15[2],xmm14[2],xmm15[3],xmm14[3]
; AVX2-FP-NEXT:    vpmovzxdq {{.*#+}} xmm3 = xmm0[0],zero,xmm0[1],zero
; AVX2-FP-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX2-FP-NEXT:    vinserti128 $1, %xmm0, %ymm3, %ymm0
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0],ymm13[1],ymm0[2],ymm13[3],ymm0[4],ymm13[5],ymm0[6],ymm13[7]
; AVX2-FP-NEXT:    vpunpckhwd {{.*#+}} xmm1 = xmm1[4],xmm2[4],xmm1[5],xmm2[5],xmm1[6],xmm2[6],xmm1[7],xmm2[7]
; AVX2-FP-NEXT:    vpshufd {{.*#+}} xmm2 = xmm1[0,0,1,1]
; AVX2-FP-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,2,3,3]
; AVX2-FP-NEXT:    vinserti128 $1, %xmm1, %ymm2, %ymm1
; AVX2-FP-NEXT:    vpunpckhwd {{.*#+}} xmm2 = xmm15[4],xmm14[4],xmm15[5],xmm14[5],xmm15[6],xmm14[6],xmm15[7],xmm14[7]
; AVX2-FP-NEXT:    vpmovzxdq {{.*#+}} xmm3 = xmm2[0],zero,xmm2[1],zero
; AVX2-FP-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[2,2,3,3]
; AVX2-FP-NEXT:    vinserti128 $1, %xmm2, %ymm3, %ymm2
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm1 = ymm2[0],ymm1[1],ymm2[2],ymm1[3],ymm2[4],ymm1[5],ymm2[6],ymm1[7]
; AVX2-FP-NEXT:    vmovdqa %ymm1, 32(%r8)
; AVX2-FP-NEXT:    vmovdqa %ymm0, (%r8)
; AVX2-FP-NEXT:    vmovdqa %ymm4, 480(%r8)
; AVX2-FP-NEXT:    vmovdqa %ymm12, 448(%r8)
; AVX2-FP-NEXT:    vmovdqa %ymm11, 416(%r8)
; AVX2-FP-NEXT:    vmovdqa %ymm8, 384(%r8)
; AVX2-FP-NEXT:    vmovdqa %ymm6, 224(%r8)
; AVX2-FP-NEXT:    vmovdqa %ymm10, 192(%r8)
; AVX2-FP-NEXT:    vmovdqa %ymm9, 160(%r8)
; AVX2-FP-NEXT:    vmovdqa %ymm7, 128(%r8)
; AVX2-FP-NEXT:    vmovdqa %ymm5, 352(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 320(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 288(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 256(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 64(%r8)
; AVX2-FP-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 96(%r8)
; AVX2-FP-NEXT:    addq $40, %rsp
; AVX2-FP-NEXT:    vzeroupper
; AVX2-FP-NEXT:    retq
;
; AVX2-FCP-LABEL: store_i16_stride4_vf64:
; AVX2-FCP:       # %bb.0:
; AVX2-FCP-NEXT:    subq $40, %rsp
; AVX2-FCP-NEXT:    vmovdqa 16(%rsi), %xmm1
; AVX2-FCP-NEXT:    vmovdqa 32(%rsi), %xmm10
; AVX2-FCP-NEXT:    vmovdqa 48(%rsi), %xmm7
; AVX2-FCP-NEXT:    vmovdqa 16(%rdi), %xmm3
; AVX2-FCP-NEXT:    vmovdqa 32(%rdi), %xmm11
; AVX2-FCP-NEXT:    vmovdqa 48(%rdi), %xmm9
; AVX2-FCP-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm3[4],xmm1[4],xmm3[5],xmm1[5],xmm3[6],xmm1[6],xmm3[7],xmm1[7]
; AVX2-FCP-NEXT:    vpmovzxdq {{.*#+}} xmm2 = xmm0[0],zero,xmm0[1],zero
; AVX2-FCP-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX2-FCP-NEXT:    vinserti128 $1, %xmm0, %ymm2, %ymm0
; AVX2-FCP-NEXT:    vmovdqa 16(%rcx), %xmm4
; AVX2-FCP-NEXT:    vmovdqa 32(%rcx), %xmm12
; AVX2-FCP-NEXT:    vmovdqa 16(%rdx), %xmm5
; AVX2-FCP-NEXT:    vpunpckhwd {{.*#+}} xmm6 = xmm5[4],xmm4[4],xmm5[5],xmm4[5],xmm5[6],xmm4[6],xmm5[7],xmm4[7]
; AVX2-FCP-NEXT:    vpmovsxbd {{.*#+}} ymm2 = [0,0,1,1,2,2,3,3]
; AVX2-FCP-NEXT:    vpermd %ymm6, %ymm2, %ymm6
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0],ymm6[1],ymm0[2],ymm6[3],ymm0[4],ymm6[5],ymm0[6],ymm6[7]
; AVX2-FCP-NEXT:    vmovdqu %ymm0, (%rsp) # 32-byte Spill
; AVX2-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm3[0],xmm1[0],xmm3[1],xmm1[1],xmm3[2],xmm1[2],xmm3[3],xmm1[3]
; AVX2-FCP-NEXT:    vpmovzxdq {{.*#+}} xmm3 = xmm1[0],zero,xmm1[1],zero
; AVX2-FCP-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,2,3,3]
; AVX2-FCP-NEXT:    vinserti128 $1, %xmm1, %ymm3, %ymm1
; AVX2-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm3 = xmm5[0],xmm4[0],xmm5[1],xmm4[1],xmm5[2],xmm4[2],xmm5[3],xmm4[3]
; AVX2-FCP-NEXT:    vpermd %ymm3, %ymm2, %ymm3
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0],ymm3[1],ymm1[2],ymm3[3],ymm1[4],ymm3[5],ymm1[6],ymm3[7]
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 64(%rsi), %xmm4
; AVX2-FCP-NEXT:    vmovdqa 64(%rdi), %xmm5
; AVX2-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm3 = xmm5[0],xmm4[0],xmm5[1],xmm4[1],xmm5[2],xmm4[2],xmm5[3],xmm4[3]
; AVX2-FCP-NEXT:    vpmovzxdq {{.*#+}} xmm6 = xmm3[0],zero,xmm3[1],zero
; AVX2-FCP-NEXT:    vpshufd {{.*#+}} xmm3 = xmm3[2,2,3,3]
; AVX2-FCP-NEXT:    vinserti128 $1, %xmm3, %ymm6, %ymm3
; AVX2-FCP-NEXT:    vmovdqa 64(%rcx), %xmm6
; AVX2-FCP-NEXT:    vmovdqa 64(%rdx), %xmm8
; AVX2-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm13 = xmm8[0],xmm6[0],xmm8[1],xmm6[1],xmm8[2],xmm6[2],xmm8[3],xmm6[3]
; AVX2-FCP-NEXT:    vpermd %ymm13, %ymm2, %ymm13
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm3[0],ymm13[1],ymm3[2],ymm13[3],ymm3[4],ymm13[5],ymm3[6],ymm13[7]
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpunpckhwd {{.*#+}} xmm4 = xmm5[4],xmm4[4],xmm5[5],xmm4[5],xmm5[6],xmm4[6],xmm5[7],xmm4[7]
; AVX2-FCP-NEXT:    vpmovzxdq {{.*#+}} xmm5 = xmm4[0],zero,xmm4[1],zero
; AVX2-FCP-NEXT:    vpshufd {{.*#+}} xmm4 = xmm4[2,2,3,3]
; AVX2-FCP-NEXT:    vinserti128 $1, %xmm4, %ymm5, %ymm4
; AVX2-FCP-NEXT:    vpunpckhwd {{.*#+}} xmm5 = xmm8[4],xmm6[4],xmm8[5],xmm6[5],xmm8[6],xmm6[6],xmm8[7],xmm6[7]
; AVX2-FCP-NEXT:    vpermd %ymm5, %ymm2, %ymm5
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm4[0],ymm5[1],ymm4[2],ymm5[3],ymm4[4],ymm5[5],ymm4[6],ymm5[7]
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 80(%rsi), %xmm6
; AVX2-FCP-NEXT:    vmovdqa 80(%rdi), %xmm8
; AVX2-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm5 = xmm8[0],xmm6[0],xmm8[1],xmm6[1],xmm8[2],xmm6[2],xmm8[3],xmm6[3]
; AVX2-FCP-NEXT:    vpmovzxdq {{.*#+}} xmm13 = xmm5[0],zero,xmm5[1],zero
; AVX2-FCP-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[2,2,3,3]
; AVX2-FCP-NEXT:    vinserti128 $1, %xmm5, %ymm13, %ymm5
; AVX2-FCP-NEXT:    vmovdqa 80(%rcx), %xmm14
; AVX2-FCP-NEXT:    vmovdqa 80(%rdx), %xmm15
; AVX2-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm13 = xmm15[0],xmm14[0],xmm15[1],xmm14[1],xmm15[2],xmm14[2],xmm15[3],xmm14[3]
; AVX2-FCP-NEXT:    vpermd %ymm13, %ymm2, %ymm13
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm5[0],ymm13[1],ymm5[2],ymm13[3],ymm5[4],ymm13[5],ymm5[6],ymm13[7]
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 48(%rcx), %xmm13
; AVX2-FCP-NEXT:    vpunpckhwd {{.*#+}} xmm6 = xmm8[4],xmm6[4],xmm8[5],xmm6[5],xmm8[6],xmm6[6],xmm8[7],xmm6[7]
; AVX2-FCP-NEXT:    vpmovzxdq {{.*#+}} xmm8 = xmm6[0],zero,xmm6[1],zero
; AVX2-FCP-NEXT:    vpshufd {{.*#+}} xmm6 = xmm6[2,2,3,3]
; AVX2-FCP-NEXT:    vinserti128 $1, %xmm6, %ymm8, %ymm6
; AVX2-FCP-NEXT:    vmovdqa 32(%rdx), %xmm0
; AVX2-FCP-NEXT:    vpunpckhwd {{.*#+}} xmm8 = xmm15[4],xmm14[4],xmm15[5],xmm14[5],xmm15[6],xmm14[6],xmm15[7],xmm14[7]
; AVX2-FCP-NEXT:    vpermd %ymm8, %ymm2, %ymm8
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm6 = ymm6[0],ymm8[1],ymm6[2],ymm8[3],ymm6[4],ymm8[5],ymm6[6],ymm8[7]
; AVX2-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm8 = xmm11[0],xmm10[0],xmm11[1],xmm10[1],xmm11[2],xmm10[2],xmm11[3],xmm10[3]
; AVX2-FCP-NEXT:    vpmovzxdq {{.*#+}} xmm14 = xmm8[0],zero,xmm8[1],zero
; AVX2-FCP-NEXT:    vpshufd {{.*#+}} xmm8 = xmm8[2,2,3,3]
; AVX2-FCP-NEXT:    vinserti128 $1, %xmm8, %ymm14, %ymm8
; AVX2-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm14 = xmm0[0],xmm12[0],xmm0[1],xmm12[1],xmm0[2],xmm12[2],xmm0[3],xmm12[3]
; AVX2-FCP-NEXT:    vpermd %ymm14, %ymm2, %ymm14
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm8 = ymm8[0],ymm14[1],ymm8[2],ymm14[3],ymm8[4],ymm14[5],ymm8[6],ymm14[7]
; AVX2-FCP-NEXT:    vmovdqa 48(%rdx), %xmm14
; AVX2-FCP-NEXT:    vpunpckhwd {{.*#+}} xmm10 = xmm11[4],xmm10[4],xmm11[5],xmm10[5],xmm11[6],xmm10[6],xmm11[7],xmm10[7]
; AVX2-FCP-NEXT:    vpmovzxdq {{.*#+}} xmm11 = xmm10[0],zero,xmm10[1],zero
; AVX2-FCP-NEXT:    vpshufd {{.*#+}} xmm10 = xmm10[2,2,3,3]
; AVX2-FCP-NEXT:    vinserti128 $1, %xmm10, %ymm11, %ymm10
; AVX2-FCP-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm0[4],xmm12[4],xmm0[5],xmm12[5],xmm0[6],xmm12[6],xmm0[7],xmm12[7]
; AVX2-FCP-NEXT:    vpermd %ymm0, %ymm2, %ymm0
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm10 = ymm10[0],ymm0[1],ymm10[2],ymm0[3],ymm10[4],ymm0[5],ymm10[6],ymm0[7]
; AVX2-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm9[0],xmm7[0],xmm9[1],xmm7[1],xmm9[2],xmm7[2],xmm9[3],xmm7[3]
; AVX2-FCP-NEXT:    vpmovzxdq {{.*#+}} xmm11 = xmm0[0],zero,xmm0[1],zero
; AVX2-FCP-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX2-FCP-NEXT:    vinserti128 $1, %xmm0, %ymm11, %ymm0
; AVX2-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm11 = xmm14[0],xmm13[0],xmm14[1],xmm13[1],xmm14[2],xmm13[2],xmm14[3],xmm13[3]
; AVX2-FCP-NEXT:    vpermd %ymm11, %ymm2, %ymm11
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm11 = ymm0[0],ymm11[1],ymm0[2],ymm11[3],ymm0[4],ymm11[5],ymm0[6],ymm11[7]
; AVX2-FCP-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm9[4],xmm7[4],xmm9[5],xmm7[5],xmm9[6],xmm7[6],xmm9[7],xmm7[7]
; AVX2-FCP-NEXT:    vpmovzxdq {{.*#+}} xmm7 = xmm0[0],zero,xmm0[1],zero
; AVX2-FCP-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX2-FCP-NEXT:    vinserti128 $1, %xmm0, %ymm7, %ymm0
; AVX2-FCP-NEXT:    vpunpckhwd {{.*#+}} xmm7 = xmm14[4],xmm13[4],xmm14[5],xmm13[5],xmm14[6],xmm13[6],xmm14[7],xmm13[7]
; AVX2-FCP-NEXT:    vpermd %ymm7, %ymm2, %ymm7
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm7 = ymm0[0],ymm7[1],ymm0[2],ymm7[3],ymm0[4],ymm7[5],ymm0[6],ymm7[7]
; AVX2-FCP-NEXT:    vmovdqa 96(%rsi), %xmm0
; AVX2-FCP-NEXT:    vmovdqa 96(%rdi), %xmm12
; AVX2-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm9 = xmm12[0],xmm0[0],xmm12[1],xmm0[1],xmm12[2],xmm0[2],xmm12[3],xmm0[3]
; AVX2-FCP-NEXT:    vpmovzxdq {{.*#+}} xmm13 = xmm9[0],zero,xmm9[1],zero
; AVX2-FCP-NEXT:    vpshufd {{.*#+}} xmm9 = xmm9[2,2,3,3]
; AVX2-FCP-NEXT:    vinserti128 $1, %xmm9, %ymm13, %ymm9
; AVX2-FCP-NEXT:    vmovdqa 96(%rcx), %xmm13
; AVX2-FCP-NEXT:    vmovdqa 96(%rdx), %xmm14
; AVX2-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm15 = xmm14[0],xmm13[0],xmm14[1],xmm13[1],xmm14[2],xmm13[2],xmm14[3],xmm13[3]
; AVX2-FCP-NEXT:    vpermd %ymm15, %ymm2, %ymm15
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm9 = ymm9[0],ymm15[1],ymm9[2],ymm15[3],ymm9[4],ymm15[5],ymm9[6],ymm15[7]
; AVX2-FCP-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm12[4],xmm0[4],xmm12[5],xmm0[5],xmm12[6],xmm0[6],xmm12[7],xmm0[7]
; AVX2-FCP-NEXT:    vpmovzxdq {{.*#+}} xmm12 = xmm0[0],zero,xmm0[1],zero
; AVX2-FCP-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX2-FCP-NEXT:    vinserti128 $1, %xmm0, %ymm12, %ymm0
; AVX2-FCP-NEXT:    vpunpckhwd {{.*#+}} xmm12 = xmm14[4],xmm13[4],xmm14[5],xmm13[5],xmm14[6],xmm13[6],xmm14[7],xmm13[7]
; AVX2-FCP-NEXT:    vpermd %ymm12, %ymm2, %ymm12
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm12 = ymm0[0],ymm12[1],ymm0[2],ymm12[3],ymm0[4],ymm12[5],ymm0[6],ymm12[7]
; AVX2-FCP-NEXT:    vmovdqa 112(%rsi), %xmm1
; AVX2-FCP-NEXT:    vmovdqa 112(%rdi), %xmm14
; AVX2-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm13 = xmm14[0],xmm1[0],xmm14[1],xmm1[1],xmm14[2],xmm1[2],xmm14[3],xmm1[3]
; AVX2-FCP-NEXT:    vpmovzxdq {{.*#+}} xmm15 = xmm13[0],zero,xmm13[1],zero
; AVX2-FCP-NEXT:    vpshufd {{.*#+}} xmm13 = xmm13[2,2,3,3]
; AVX2-FCP-NEXT:    vinserti128 $1, %xmm13, %ymm15, %ymm13
; AVX2-FCP-NEXT:    vmovdqa 112(%rcx), %xmm15
; AVX2-FCP-NEXT:    vmovdqa 112(%rdx), %xmm0
; AVX2-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm3 = xmm0[0],xmm15[0],xmm0[1],xmm15[1],xmm0[2],xmm15[2],xmm0[3],xmm15[3]
; AVX2-FCP-NEXT:    vpermd %ymm3, %ymm2, %ymm3
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm13 = ymm13[0],ymm3[1],ymm13[2],ymm3[3],ymm13[4],ymm3[5],ymm13[6],ymm3[7]
; AVX2-FCP-NEXT:    vpunpckhwd {{.*#+}} xmm1 = xmm14[4],xmm1[4],xmm14[5],xmm1[5],xmm14[6],xmm1[6],xmm14[7],xmm1[7]
; AVX2-FCP-NEXT:    vpmovzxdq {{.*#+}} xmm3 = xmm1[0],zero,xmm1[1],zero
; AVX2-FCP-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,2,3,3]
; AVX2-FCP-NEXT:    vinserti128 $1, %xmm1, %ymm3, %ymm1
; AVX2-FCP-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm0[4],xmm15[4],xmm0[5],xmm15[5],xmm0[6],xmm15[6],xmm0[7],xmm15[7]
; AVX2-FCP-NEXT:    vpermd %ymm0, %ymm2, %ymm0
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm4 = ymm1[0],ymm0[1],ymm1[2],ymm0[3],ymm1[4],ymm0[5],ymm1[6],ymm0[7]
; AVX2-FCP-NEXT:    vmovdqa (%rsi), %xmm1
; AVX2-FCP-NEXT:    vmovdqa (%rdi), %xmm3
; AVX2-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm14 = xmm3[0],xmm1[0],xmm3[1],xmm1[1],xmm3[2],xmm1[2],xmm3[3],xmm1[3]
; AVX2-FCP-NEXT:    vpmovzxdq {{.*#+}} xmm15 = xmm14[0],zero,xmm14[1],zero
; AVX2-FCP-NEXT:    vpshufd {{.*#+}} xmm14 = xmm14[2,2,3,3]
; AVX2-FCP-NEXT:    vinserti128 $1, %xmm14, %ymm15, %ymm14
; AVX2-FCP-NEXT:    vmovdqa (%rcx), %xmm15
; AVX2-FCP-NEXT:    vmovdqa (%rdx), %xmm0
; AVX2-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm5 = xmm0[0],xmm15[0],xmm0[1],xmm15[1],xmm0[2],xmm15[2],xmm0[3],xmm15[3]
; AVX2-FCP-NEXT:    vpermd %ymm5, %ymm2, %ymm5
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm5 = ymm14[0],ymm5[1],ymm14[2],ymm5[3],ymm14[4],ymm5[5],ymm14[6],ymm5[7]
; AVX2-FCP-NEXT:    vpunpckhwd {{.*#+}} xmm1 = xmm3[4],xmm1[4],xmm3[5],xmm1[5],xmm3[6],xmm1[6],xmm3[7],xmm1[7]
; AVX2-FCP-NEXT:    vpmovzxdq {{.*#+}} xmm3 = xmm1[0],zero,xmm1[1],zero
; AVX2-FCP-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,2,3,3]
; AVX2-FCP-NEXT:    vinserti128 $1, %xmm1, %ymm3, %ymm1
; AVX2-FCP-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm0[4],xmm15[4],xmm0[5],xmm15[5],xmm0[6],xmm15[6],xmm0[7],xmm15[7]
; AVX2-FCP-NEXT:    vpermd %ymm0, %ymm2, %ymm0
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2],ymm0[3],ymm1[4],ymm0[5],ymm1[6],ymm0[7]
; AVX2-FCP-NEXT:    vmovdqa %ymm0, 32(%r8)
; AVX2-FCP-NEXT:    vmovdqa %ymm5, (%r8)
; AVX2-FCP-NEXT:    vmovdqa %ymm4, 480(%r8)
; AVX2-FCP-NEXT:    vmovdqa %ymm13, 448(%r8)
; AVX2-FCP-NEXT:    vmovdqa %ymm12, 416(%r8)
; AVX2-FCP-NEXT:    vmovdqa %ymm9, 384(%r8)
; AVX2-FCP-NEXT:    vmovdqa %ymm7, 224(%r8)
; AVX2-FCP-NEXT:    vmovdqa %ymm11, 192(%r8)
; AVX2-FCP-NEXT:    vmovdqa %ymm10, 160(%r8)
; AVX2-FCP-NEXT:    vmovdqa %ymm8, 128(%r8)
; AVX2-FCP-NEXT:    vmovdqa %ymm6, 352(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 320(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 288(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 256(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 64(%r8)
; AVX2-FCP-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 96(%r8)
; AVX2-FCP-NEXT:    addq $40, %rsp
; AVX2-FCP-NEXT:    vzeroupper
; AVX2-FCP-NEXT:    retq
;
; AVX512-LABEL: store_i16_stride4_vf64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa64 (%rsi), %xmm19
; AVX512-NEXT:    vmovdqa 16(%rsi), %xmm0
; AVX512-NEXT:    vmovdqa 32(%rsi), %xmm11
; AVX512-NEXT:    vmovdqa 48(%rsi), %xmm6
; AVX512-NEXT:    vmovdqa64 (%rdi), %xmm20
; AVX512-NEXT:    vmovdqa 16(%rdi), %xmm3
; AVX512-NEXT:    vmovdqa 32(%rdi), %xmm12
; AVX512-NEXT:    vmovdqa 48(%rdi), %xmm7
; AVX512-NEXT:    vpunpckhwd {{.*#+}} xmm4 = xmm3[4],xmm0[4],xmm3[5],xmm0[5],xmm3[6],xmm0[6],xmm3[7],xmm0[7]
; AVX512-NEXT:    vpmovzxdq {{.*#+}} xmm5 = xmm4[0],zero,xmm4[1],zero
; AVX512-NEXT:    vpshufd {{.*#+}} xmm4 = xmm4[2,2,3,3]
; AVX512-NEXT:    vinserti128 $1, %xmm4, %ymm5, %ymm4
; AVX512-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm3[0],xmm0[0],xmm3[1],xmm0[1],xmm3[2],xmm0[2],xmm3[3],xmm0[3]
; AVX512-NEXT:    vpmovzxdq {{.*#+}} xmm3 = xmm0[0],zero,xmm0[1],zero
; AVX512-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX512-NEXT:    vinserti128 $1, %xmm0, %ymm3, %ymm0
; AVX512-NEXT:    vinserti64x4 $1, %ymm4, %zmm0, %zmm18
; AVX512-NEXT:    vmovdqa (%rcx), %xmm3
; AVX512-NEXT:    vmovdqa 16(%rcx), %xmm5
; AVX512-NEXT:    vmovdqa 32(%rcx), %xmm13
; AVX512-NEXT:    vmovdqa 48(%rcx), %xmm9
; AVX512-NEXT:    vmovdqa (%rdx), %xmm4
; AVX512-NEXT:    vmovdqa 16(%rdx), %xmm8
; AVX512-NEXT:    vmovdqa 32(%rdx), %xmm14
; AVX512-NEXT:    vmovdqa 48(%rdx), %xmm10
; AVX512-NEXT:    vpunpckhwd {{.*#+}} xmm15 = xmm8[4],xmm5[4],xmm8[5],xmm5[5],xmm8[6],xmm5[6],xmm8[7],xmm5[7]
; AVX512-NEXT:    vpunpcklwd {{.*#+}} xmm8 = xmm8[0],xmm5[0],xmm8[1],xmm5[1],xmm8[2],xmm5[2],xmm8[3],xmm5[3]
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm5 = [0,0,1,1,2,2,3,3,16,16,17,17,18,18,19,19]
; AVX512-NEXT:    vpermt2d %zmm15, %zmm5, %zmm8
; AVX512-NEXT:    movw $-21846, %ax # imm = 0xAAAA
; AVX512-NEXT:    kmovw %eax, %k1
; AVX512-NEXT:    vmovdqa32 %zmm8, %zmm18 {%k1}
; AVX512-NEXT:    vmovdqa 96(%rsi), %xmm8
; AVX512-NEXT:    vmovdqa 96(%rdi), %xmm15
; AVX512-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm15[4],xmm8[4],xmm15[5],xmm8[5],xmm15[6],xmm8[6],xmm15[7],xmm8[7]
; AVX512-NEXT:    vpmovzxdq {{.*#+}} xmm16 = xmm0[0],zero,xmm0[1],zero
; AVX512-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX512-NEXT:    vinserti32x4 $1, %xmm0, %ymm16, %ymm0
; AVX512-NEXT:    vpunpcklwd {{.*#+}} xmm8 = xmm15[0],xmm8[0],xmm15[1],xmm8[1],xmm15[2],xmm8[2],xmm15[3],xmm8[3]
; AVX512-NEXT:    vpmovzxdq {{.*#+}} xmm15 = xmm8[0],zero,xmm8[1],zero
; AVX512-NEXT:    vpshufd {{.*#+}} xmm8 = xmm8[2,2,3,3]
; AVX512-NEXT:    vinserti128 $1, %xmm8, %ymm15, %ymm8
; AVX512-NEXT:    vinserti64x4 $1, %ymm0, %zmm8, %zmm8
; AVX512-NEXT:    vmovdqa 96(%rcx), %xmm0
; AVX512-NEXT:    vmovdqa 96(%rdx), %xmm15
; AVX512-NEXT:    vpunpckhwd {{.*#+}} xmm1 = xmm15[4],xmm0[4],xmm15[5],xmm0[5],xmm15[6],xmm0[6],xmm15[7],xmm0[7]
; AVX512-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm15[0],xmm0[0],xmm15[1],xmm0[1],xmm15[2],xmm0[2],xmm15[3],xmm0[3]
; AVX512-NEXT:    vpermt2d %zmm1, %zmm5, %zmm0
; AVX512-NEXT:    vmovdqa32 %zmm0, %zmm8 {%k1}
; AVX512-NEXT:    vmovdqa 112(%rsi), %xmm0
; AVX512-NEXT:    vmovdqa 112(%rdi), %xmm1
; AVX512-NEXT:    vpunpckhwd {{.*#+}} xmm15 = xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; AVX512-NEXT:    vpmovzxdq {{.*#+}} xmm16 = xmm15[0],zero,xmm15[1],zero
; AVX512-NEXT:    vpshufd {{.*#+}} xmm15 = xmm15[2,2,3,3]
; AVX512-NEXT:    vinserti32x4 $1, %xmm15, %ymm16, %ymm15
; AVX512-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; AVX512-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm0[0],zero,xmm0[1],zero
; AVX512-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX512-NEXT:    vinserti128 $1, %xmm0, %ymm1, %ymm0
; AVX512-NEXT:    vinserti64x4 $1, %ymm15, %zmm0, %zmm15
; AVX512-NEXT:    vmovdqa 112(%rcx), %xmm0
; AVX512-NEXT:    vmovdqa 112(%rdx), %xmm1
; AVX512-NEXT:    vpunpckhwd {{.*#+}} xmm2 = xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; AVX512-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; AVX512-NEXT:    vpermt2d %zmm2, %zmm5, %zmm0
; AVX512-NEXT:    vmovdqa32 %zmm0, %zmm15 {%k1}
; AVX512-NEXT:    vmovdqa 64(%rsi), %xmm0
; AVX512-NEXT:    vmovdqa 64(%rdi), %xmm1
; AVX512-NEXT:    vpunpckhwd {{.*#+}} xmm2 = xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; AVX512-NEXT:    vpmovzxdq {{.*#+}} xmm16 = xmm2[0],zero,xmm2[1],zero
; AVX512-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[2,2,3,3]
; AVX512-NEXT:    vinserti32x4 $1, %xmm2, %ymm16, %ymm2
; AVX512-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; AVX512-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm0[0],zero,xmm0[1],zero
; AVX512-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX512-NEXT:    vinserti128 $1, %xmm0, %ymm1, %ymm0
; AVX512-NEXT:    vinserti64x4 $1, %ymm2, %zmm0, %zmm16
; AVX512-NEXT:    vmovdqa 64(%rcx), %xmm0
; AVX512-NEXT:    vmovdqa 64(%rdx), %xmm1
; AVX512-NEXT:    vpunpckhwd {{.*#+}} xmm2 = xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; AVX512-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; AVX512-NEXT:    vpermt2d %zmm2, %zmm5, %zmm0
; AVX512-NEXT:    vmovdqa32 %zmm0, %zmm16 {%k1}
; AVX512-NEXT:    vmovdqa 80(%rsi), %xmm0
; AVX512-NEXT:    vmovdqa 80(%rdi), %xmm1
; AVX512-NEXT:    vpunpckhwd {{.*#+}} xmm2 = xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; AVX512-NEXT:    vpmovzxdq {{.*#+}} xmm17 = xmm2[0],zero,xmm2[1],zero
; AVX512-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[2,2,3,3]
; AVX512-NEXT:    vinserti32x4 $1, %xmm2, %ymm17, %ymm2
; AVX512-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; AVX512-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm0[0],zero,xmm0[1],zero
; AVX512-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX512-NEXT:    vinserti128 $1, %xmm0, %ymm1, %ymm0
; AVX512-NEXT:    vinserti64x4 $1, %ymm2, %zmm0, %zmm17
; AVX512-NEXT:    vmovdqa 80(%rcx), %xmm0
; AVX512-NEXT:    vmovdqa 80(%rdx), %xmm1
; AVX512-NEXT:    vpunpckhwd {{.*#+}} xmm2 = xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; AVX512-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; AVX512-NEXT:    vpermt2d %zmm2, %zmm5, %zmm0
; AVX512-NEXT:    vmovdqa32 %zmm0, %zmm17 {%k1}
; AVX512-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm12[4],xmm11[4],xmm12[5],xmm11[5],xmm12[6],xmm11[6],xmm12[7],xmm11[7]
; AVX512-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm0[0],zero,xmm0[1],zero
; AVX512-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX512-NEXT:    vinserti128 $1, %xmm0, %ymm1, %ymm0
; AVX512-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm12[0],xmm11[0],xmm12[1],xmm11[1],xmm12[2],xmm11[2],xmm12[3],xmm11[3]
; AVX512-NEXT:    vpmovzxdq {{.*#+}} xmm2 = xmm1[0],zero,xmm1[1],zero
; AVX512-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,2,3,3]
; AVX512-NEXT:    vinserti128 $1, %xmm1, %ymm2, %ymm1
; AVX512-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512-NEXT:    vpunpckhwd {{.*#+}} xmm1 = xmm14[4],xmm13[4],xmm14[5],xmm13[5],xmm14[6],xmm13[6],xmm14[7],xmm13[7]
; AVX512-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm14[0],xmm13[0],xmm14[1],xmm13[1],xmm14[2],xmm13[2],xmm14[3],xmm13[3]
; AVX512-NEXT:    vpermt2d %zmm1, %zmm5, %zmm2
; AVX512-NEXT:    vmovdqa32 %zmm2, %zmm0 {%k1}
; AVX512-NEXT:    vpunpckhwd {{.*#+}} xmm1 = xmm7[4],xmm6[4],xmm7[5],xmm6[5],xmm7[6],xmm6[6],xmm7[7],xmm6[7]
; AVX512-NEXT:    vpmovzxdq {{.*#+}} xmm2 = xmm1[0],zero,xmm1[1],zero
; AVX512-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,2,3,3]
; AVX512-NEXT:    vinserti128 $1, %xmm1, %ymm2, %ymm1
; AVX512-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm7[0],xmm6[0],xmm7[1],xmm6[1],xmm7[2],xmm6[2],xmm7[3],xmm6[3]
; AVX512-NEXT:    vpmovzxdq {{.*#+}} xmm6 = xmm2[0],zero,xmm2[1],zero
; AVX512-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[2,2,3,3]
; AVX512-NEXT:    vinserti128 $1, %xmm2, %ymm6, %ymm2
; AVX512-NEXT:    vinserti64x4 $1, %ymm1, %zmm2, %zmm1
; AVX512-NEXT:    vpunpckhwd {{.*#+}} xmm2 = xmm10[4],xmm9[4],xmm10[5],xmm9[5],xmm10[6],xmm9[6],xmm10[7],xmm9[7]
; AVX512-NEXT:    vpunpcklwd {{.*#+}} xmm6 = xmm10[0],xmm9[0],xmm10[1],xmm9[1],xmm10[2],xmm9[2],xmm10[3],xmm9[3]
; AVX512-NEXT:    vpermt2d %zmm2, %zmm5, %zmm6
; AVX512-NEXT:    vmovdqa32 %zmm6, %zmm1 {%k1}
; AVX512-NEXT:    vmovdqa64 %xmm19, %xmm7
; AVX512-NEXT:    vmovdqa64 %xmm20, %xmm9
; AVX512-NEXT:    vpunpckhwd {{.*#+}} xmm2 = xmm9[4],xmm7[4],xmm9[5],xmm7[5],xmm9[6],xmm7[6],xmm9[7],xmm7[7]
; AVX512-NEXT:    vpmovzxdq {{.*#+}} xmm6 = xmm2[0],zero,xmm2[1],zero
; AVX512-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[2,2,3,3]
; AVX512-NEXT:    vinserti128 $1, %xmm2, %ymm6, %ymm2
; AVX512-NEXT:    vpunpcklwd {{.*#+}} xmm6 = xmm9[0],xmm7[0],xmm9[1],xmm7[1],xmm9[2],xmm7[2],xmm9[3],xmm7[3]
; AVX512-NEXT:    vpmovzxdq {{.*#+}} xmm7 = xmm6[0],zero,xmm6[1],zero
; AVX512-NEXT:    vpshufd {{.*#+}} xmm6 = xmm6[2,2,3,3]
; AVX512-NEXT:    vinserti128 $1, %xmm6, %ymm7, %ymm6
; AVX512-NEXT:    vinserti64x4 $1, %ymm2, %zmm6, %zmm2
; AVX512-NEXT:    vpunpckhwd {{.*#+}} xmm6 = xmm4[4],xmm3[4],xmm4[5],xmm3[5],xmm4[6],xmm3[6],xmm4[7],xmm3[7]
; AVX512-NEXT:    vpunpcklwd {{.*#+}} xmm3 = xmm4[0],xmm3[0],xmm4[1],xmm3[1],xmm4[2],xmm3[2],xmm4[3],xmm3[3]
; AVX512-NEXT:    vpermt2d %zmm6, %zmm5, %zmm3
; AVX512-NEXT:    vmovdqa32 %zmm3, %zmm2 {%k1}
; AVX512-NEXT:    vmovdqa64 %zmm2, (%r8)
; AVX512-NEXT:    vmovdqa64 %zmm1, 192(%r8)
; AVX512-NEXT:    vmovdqa64 %zmm0, 128(%r8)
; AVX512-NEXT:    vmovdqa64 %zmm17, 320(%r8)
; AVX512-NEXT:    vmovdqa64 %zmm16, 256(%r8)
; AVX512-NEXT:    vmovdqa64 %zmm15, 448(%r8)
; AVX512-NEXT:    vmovdqa64 %zmm8, 384(%r8)
; AVX512-NEXT:    vmovdqa64 %zmm18, 64(%r8)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
;
; AVX512-FCP-LABEL: store_i16_stride4_vf64:
; AVX512-FCP:       # %bb.0:
; AVX512-FCP-NEXT:    vmovdqa64 (%rsi), %xmm19
; AVX512-FCP-NEXT:    vmovdqa 16(%rsi), %xmm0
; AVX512-FCP-NEXT:    vmovdqa 32(%rsi), %xmm11
; AVX512-FCP-NEXT:    vmovdqa 48(%rsi), %xmm6
; AVX512-FCP-NEXT:    vmovdqa64 (%rdi), %xmm20
; AVX512-FCP-NEXT:    vmovdqa 16(%rdi), %xmm3
; AVX512-FCP-NEXT:    vmovdqa 32(%rdi), %xmm12
; AVX512-FCP-NEXT:    vmovdqa 48(%rdi), %xmm7
; AVX512-FCP-NEXT:    vpunpckhwd {{.*#+}} xmm4 = xmm3[4],xmm0[4],xmm3[5],xmm0[5],xmm3[6],xmm0[6],xmm3[7],xmm0[7]
; AVX512-FCP-NEXT:    vpmovzxdq {{.*#+}} xmm5 = xmm4[0],zero,xmm4[1],zero
; AVX512-FCP-NEXT:    vpshufd {{.*#+}} xmm4 = xmm4[2,2,3,3]
; AVX512-FCP-NEXT:    vinserti128 $1, %xmm4, %ymm5, %ymm4
; AVX512-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm3[0],xmm0[0],xmm3[1],xmm0[1],xmm3[2],xmm0[2],xmm3[3],xmm0[3]
; AVX512-FCP-NEXT:    vpmovzxdq {{.*#+}} xmm3 = xmm0[0],zero,xmm0[1],zero
; AVX512-FCP-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX512-FCP-NEXT:    vinserti128 $1, %xmm0, %ymm3, %ymm0
; AVX512-FCP-NEXT:    vinserti64x4 $1, %ymm4, %zmm0, %zmm18
; AVX512-FCP-NEXT:    vmovdqa (%rcx), %xmm3
; AVX512-FCP-NEXT:    vmovdqa 16(%rcx), %xmm5
; AVX512-FCP-NEXT:    vmovdqa 32(%rcx), %xmm13
; AVX512-FCP-NEXT:    vmovdqa 48(%rcx), %xmm9
; AVX512-FCP-NEXT:    vmovdqa (%rdx), %xmm4
; AVX512-FCP-NEXT:    vmovdqa 16(%rdx), %xmm8
; AVX512-FCP-NEXT:    vmovdqa 32(%rdx), %xmm14
; AVX512-FCP-NEXT:    vmovdqa 48(%rdx), %xmm10
; AVX512-FCP-NEXT:    vpunpckhwd {{.*#+}} xmm15 = xmm8[4],xmm5[4],xmm8[5],xmm5[5],xmm8[6],xmm5[6],xmm8[7],xmm5[7]
; AVX512-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm8 = xmm8[0],xmm5[0],xmm8[1],xmm5[1],xmm8[2],xmm5[2],xmm8[3],xmm5[3]
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm5 = [0,0,1,1,2,2,3,3,16,16,17,17,18,18,19,19]
; AVX512-FCP-NEXT:    vpermt2d %zmm15, %zmm5, %zmm8
; AVX512-FCP-NEXT:    movw $-21846, %ax # imm = 0xAAAA
; AVX512-FCP-NEXT:    kmovw %eax, %k1
; AVX512-FCP-NEXT:    vmovdqa32 %zmm8, %zmm18 {%k1}
; AVX512-FCP-NEXT:    vmovdqa 96(%rsi), %xmm8
; AVX512-FCP-NEXT:    vmovdqa 96(%rdi), %xmm15
; AVX512-FCP-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm15[4],xmm8[4],xmm15[5],xmm8[5],xmm15[6],xmm8[6],xmm15[7],xmm8[7]
; AVX512-FCP-NEXT:    vpmovzxdq {{.*#+}} xmm16 = xmm0[0],zero,xmm0[1],zero
; AVX512-FCP-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX512-FCP-NEXT:    vinserti32x4 $1, %xmm0, %ymm16, %ymm0
; AVX512-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm8 = xmm15[0],xmm8[0],xmm15[1],xmm8[1],xmm15[2],xmm8[2],xmm15[3],xmm8[3]
; AVX512-FCP-NEXT:    vpmovzxdq {{.*#+}} xmm15 = xmm8[0],zero,xmm8[1],zero
; AVX512-FCP-NEXT:    vpshufd {{.*#+}} xmm8 = xmm8[2,2,3,3]
; AVX512-FCP-NEXT:    vinserti128 $1, %xmm8, %ymm15, %ymm8
; AVX512-FCP-NEXT:    vinserti64x4 $1, %ymm0, %zmm8, %zmm8
; AVX512-FCP-NEXT:    vmovdqa 96(%rcx), %xmm0
; AVX512-FCP-NEXT:    vmovdqa 96(%rdx), %xmm15
; AVX512-FCP-NEXT:    vpunpckhwd {{.*#+}} xmm1 = xmm15[4],xmm0[4],xmm15[5],xmm0[5],xmm15[6],xmm0[6],xmm15[7],xmm0[7]
; AVX512-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm15[0],xmm0[0],xmm15[1],xmm0[1],xmm15[2],xmm0[2],xmm15[3],xmm0[3]
; AVX512-FCP-NEXT:    vpermt2d %zmm1, %zmm5, %zmm0
; AVX512-FCP-NEXT:    vmovdqa32 %zmm0, %zmm8 {%k1}
; AVX512-FCP-NEXT:    vmovdqa 112(%rsi), %xmm0
; AVX512-FCP-NEXT:    vmovdqa 112(%rdi), %xmm1
; AVX512-FCP-NEXT:    vpunpckhwd {{.*#+}} xmm15 = xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; AVX512-FCP-NEXT:    vpmovzxdq {{.*#+}} xmm16 = xmm15[0],zero,xmm15[1],zero
; AVX512-FCP-NEXT:    vpshufd {{.*#+}} xmm15 = xmm15[2,2,3,3]
; AVX512-FCP-NEXT:    vinserti32x4 $1, %xmm15, %ymm16, %ymm15
; AVX512-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; AVX512-FCP-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm0[0],zero,xmm0[1],zero
; AVX512-FCP-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX512-FCP-NEXT:    vinserti128 $1, %xmm0, %ymm1, %ymm0
; AVX512-FCP-NEXT:    vinserti64x4 $1, %ymm15, %zmm0, %zmm15
; AVX512-FCP-NEXT:    vmovdqa 112(%rcx), %xmm0
; AVX512-FCP-NEXT:    vmovdqa 112(%rdx), %xmm1
; AVX512-FCP-NEXT:    vpunpckhwd {{.*#+}} xmm2 = xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; AVX512-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; AVX512-FCP-NEXT:    vpermt2d %zmm2, %zmm5, %zmm0
; AVX512-FCP-NEXT:    vmovdqa32 %zmm0, %zmm15 {%k1}
; AVX512-FCP-NEXT:    vmovdqa 64(%rsi), %xmm0
; AVX512-FCP-NEXT:    vmovdqa 64(%rdi), %xmm1
; AVX512-FCP-NEXT:    vpunpckhwd {{.*#+}} xmm2 = xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; AVX512-FCP-NEXT:    vpmovzxdq {{.*#+}} xmm16 = xmm2[0],zero,xmm2[1],zero
; AVX512-FCP-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[2,2,3,3]
; AVX512-FCP-NEXT:    vinserti32x4 $1, %xmm2, %ymm16, %ymm2
; AVX512-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; AVX512-FCP-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm0[0],zero,xmm0[1],zero
; AVX512-FCP-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX512-FCP-NEXT:    vinserti128 $1, %xmm0, %ymm1, %ymm0
; AVX512-FCP-NEXT:    vinserti64x4 $1, %ymm2, %zmm0, %zmm16
; AVX512-FCP-NEXT:    vmovdqa 64(%rcx), %xmm0
; AVX512-FCP-NEXT:    vmovdqa 64(%rdx), %xmm1
; AVX512-FCP-NEXT:    vpunpckhwd {{.*#+}} xmm2 = xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; AVX512-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; AVX512-FCP-NEXT:    vpermt2d %zmm2, %zmm5, %zmm0
; AVX512-FCP-NEXT:    vmovdqa32 %zmm0, %zmm16 {%k1}
; AVX512-FCP-NEXT:    vmovdqa 80(%rsi), %xmm0
; AVX512-FCP-NEXT:    vmovdqa 80(%rdi), %xmm1
; AVX512-FCP-NEXT:    vpunpckhwd {{.*#+}} xmm2 = xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; AVX512-FCP-NEXT:    vpmovzxdq {{.*#+}} xmm17 = xmm2[0],zero,xmm2[1],zero
; AVX512-FCP-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[2,2,3,3]
; AVX512-FCP-NEXT:    vinserti32x4 $1, %xmm2, %ymm17, %ymm2
; AVX512-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; AVX512-FCP-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm0[0],zero,xmm0[1],zero
; AVX512-FCP-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX512-FCP-NEXT:    vinserti128 $1, %xmm0, %ymm1, %ymm0
; AVX512-FCP-NEXT:    vinserti64x4 $1, %ymm2, %zmm0, %zmm17
; AVX512-FCP-NEXT:    vmovdqa 80(%rcx), %xmm0
; AVX512-FCP-NEXT:    vmovdqa 80(%rdx), %xmm1
; AVX512-FCP-NEXT:    vpunpckhwd {{.*#+}} xmm2 = xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; AVX512-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; AVX512-FCP-NEXT:    vpermt2d %zmm2, %zmm5, %zmm0
; AVX512-FCP-NEXT:    vmovdqa32 %zmm0, %zmm17 {%k1}
; AVX512-FCP-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm12[4],xmm11[4],xmm12[5],xmm11[5],xmm12[6],xmm11[6],xmm12[7],xmm11[7]
; AVX512-FCP-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm0[0],zero,xmm0[1],zero
; AVX512-FCP-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX512-FCP-NEXT:    vinserti128 $1, %xmm0, %ymm1, %ymm0
; AVX512-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm12[0],xmm11[0],xmm12[1],xmm11[1],xmm12[2],xmm11[2],xmm12[3],xmm11[3]
; AVX512-FCP-NEXT:    vpmovzxdq {{.*#+}} xmm2 = xmm1[0],zero,xmm1[1],zero
; AVX512-FCP-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,2,3,3]
; AVX512-FCP-NEXT:    vinserti128 $1, %xmm1, %ymm2, %ymm1
; AVX512-FCP-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512-FCP-NEXT:    vpunpckhwd {{.*#+}} xmm1 = xmm14[4],xmm13[4],xmm14[5],xmm13[5],xmm14[6],xmm13[6],xmm14[7],xmm13[7]
; AVX512-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm14[0],xmm13[0],xmm14[1],xmm13[1],xmm14[2],xmm13[2],xmm14[3],xmm13[3]
; AVX512-FCP-NEXT:    vpermt2d %zmm1, %zmm5, %zmm2
; AVX512-FCP-NEXT:    vmovdqa32 %zmm2, %zmm0 {%k1}
; AVX512-FCP-NEXT:    vpunpckhwd {{.*#+}} xmm1 = xmm7[4],xmm6[4],xmm7[5],xmm6[5],xmm7[6],xmm6[6],xmm7[7],xmm6[7]
; AVX512-FCP-NEXT:    vpmovzxdq {{.*#+}} xmm2 = xmm1[0],zero,xmm1[1],zero
; AVX512-FCP-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,2,3,3]
; AVX512-FCP-NEXT:    vinserti128 $1, %xmm1, %ymm2, %ymm1
; AVX512-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm7[0],xmm6[0],xmm7[1],xmm6[1],xmm7[2],xmm6[2],xmm7[3],xmm6[3]
; AVX512-FCP-NEXT:    vpmovzxdq {{.*#+}} xmm6 = xmm2[0],zero,xmm2[1],zero
; AVX512-FCP-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[2,2,3,3]
; AVX512-FCP-NEXT:    vinserti128 $1, %xmm2, %ymm6, %ymm2
; AVX512-FCP-NEXT:    vinserti64x4 $1, %ymm1, %zmm2, %zmm1
; AVX512-FCP-NEXT:    vpunpckhwd {{.*#+}} xmm2 = xmm10[4],xmm9[4],xmm10[5],xmm9[5],xmm10[6],xmm9[6],xmm10[7],xmm9[7]
; AVX512-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm6 = xmm10[0],xmm9[0],xmm10[1],xmm9[1],xmm10[2],xmm9[2],xmm10[3],xmm9[3]
; AVX512-FCP-NEXT:    vpermt2d %zmm2, %zmm5, %zmm6
; AVX512-FCP-NEXT:    vmovdqa32 %zmm6, %zmm1 {%k1}
; AVX512-FCP-NEXT:    vmovdqa64 %xmm19, %xmm7
; AVX512-FCP-NEXT:    vmovdqa64 %xmm20, %xmm9
; AVX512-FCP-NEXT:    vpunpckhwd {{.*#+}} xmm2 = xmm9[4],xmm7[4],xmm9[5],xmm7[5],xmm9[6],xmm7[6],xmm9[7],xmm7[7]
; AVX512-FCP-NEXT:    vpmovzxdq {{.*#+}} xmm6 = xmm2[0],zero,xmm2[1],zero
; AVX512-FCP-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[2,2,3,3]
; AVX512-FCP-NEXT:    vinserti128 $1, %xmm2, %ymm6, %ymm2
; AVX512-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm6 = xmm9[0],xmm7[0],xmm9[1],xmm7[1],xmm9[2],xmm7[2],xmm9[3],xmm7[3]
; AVX512-FCP-NEXT:    vpmovzxdq {{.*#+}} xmm7 = xmm6[0],zero,xmm6[1],zero
; AVX512-FCP-NEXT:    vpshufd {{.*#+}} xmm6 = xmm6[2,2,3,3]
; AVX512-FCP-NEXT:    vinserti128 $1, %xmm6, %ymm7, %ymm6
; AVX512-FCP-NEXT:    vinserti64x4 $1, %ymm2, %zmm6, %zmm2
; AVX512-FCP-NEXT:    vpunpckhwd {{.*#+}} xmm6 = xmm4[4],xmm3[4],xmm4[5],xmm3[5],xmm4[6],xmm3[6],xmm4[7],xmm3[7]
; AVX512-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm3 = xmm4[0],xmm3[0],xmm4[1],xmm3[1],xmm4[2],xmm3[2],xmm4[3],xmm3[3]
; AVX512-FCP-NEXT:    vpermt2d %zmm6, %zmm5, %zmm3
; AVX512-FCP-NEXT:    vmovdqa32 %zmm3, %zmm2 {%k1}
; AVX512-FCP-NEXT:    vmovdqa64 %zmm2, (%r8)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm1, 192(%r8)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, 128(%r8)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm17, 320(%r8)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm16, 256(%r8)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm15, 448(%r8)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm8, 384(%r8)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm18, 64(%r8)
; AVX512-FCP-NEXT:    vzeroupper
; AVX512-FCP-NEXT:    retq
;
; AVX512DQ-LABEL: store_i16_stride4_vf64:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vmovdqa64 (%rsi), %xmm19
; AVX512DQ-NEXT:    vmovdqa 16(%rsi), %xmm0
; AVX512DQ-NEXT:    vmovdqa 32(%rsi), %xmm11
; AVX512DQ-NEXT:    vmovdqa 48(%rsi), %xmm6
; AVX512DQ-NEXT:    vmovdqa64 (%rdi), %xmm20
; AVX512DQ-NEXT:    vmovdqa 16(%rdi), %xmm3
; AVX512DQ-NEXT:    vmovdqa 32(%rdi), %xmm12
; AVX512DQ-NEXT:    vmovdqa 48(%rdi), %xmm7
; AVX512DQ-NEXT:    vpunpckhwd {{.*#+}} xmm4 = xmm3[4],xmm0[4],xmm3[5],xmm0[5],xmm3[6],xmm0[6],xmm3[7],xmm0[7]
; AVX512DQ-NEXT:    vpmovzxdq {{.*#+}} xmm5 = xmm4[0],zero,xmm4[1],zero
; AVX512DQ-NEXT:    vpshufd {{.*#+}} xmm4 = xmm4[2,2,3,3]
; AVX512DQ-NEXT:    vinserti128 $1, %xmm4, %ymm5, %ymm4
; AVX512DQ-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm3[0],xmm0[0],xmm3[1],xmm0[1],xmm3[2],xmm0[2],xmm3[3],xmm0[3]
; AVX512DQ-NEXT:    vpmovzxdq {{.*#+}} xmm3 = xmm0[0],zero,xmm0[1],zero
; AVX512DQ-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX512DQ-NEXT:    vinserti128 $1, %xmm0, %ymm3, %ymm0
; AVX512DQ-NEXT:    vinserti64x4 $1, %ymm4, %zmm0, %zmm18
; AVX512DQ-NEXT:    vmovdqa (%rcx), %xmm3
; AVX512DQ-NEXT:    vmovdqa 16(%rcx), %xmm5
; AVX512DQ-NEXT:    vmovdqa 32(%rcx), %xmm13
; AVX512DQ-NEXT:    vmovdqa 48(%rcx), %xmm9
; AVX512DQ-NEXT:    vmovdqa (%rdx), %xmm4
; AVX512DQ-NEXT:    vmovdqa 16(%rdx), %xmm8
; AVX512DQ-NEXT:    vmovdqa 32(%rdx), %xmm14
; AVX512DQ-NEXT:    vmovdqa 48(%rdx), %xmm10
; AVX512DQ-NEXT:    vpunpckhwd {{.*#+}} xmm15 = xmm8[4],xmm5[4],xmm8[5],xmm5[5],xmm8[6],xmm5[6],xmm8[7],xmm5[7]
; AVX512DQ-NEXT:    vpunpcklwd {{.*#+}} xmm8 = xmm8[0],xmm5[0],xmm8[1],xmm5[1],xmm8[2],xmm5[2],xmm8[3],xmm5[3]
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm5 = [0,0,1,1,2,2,3,3,16,16,17,17,18,18,19,19]
; AVX512DQ-NEXT:    vpermt2d %zmm15, %zmm5, %zmm8
; AVX512DQ-NEXT:    movw $-21846, %ax # imm = 0xAAAA
; AVX512DQ-NEXT:    kmovw %eax, %k1
; AVX512DQ-NEXT:    vmovdqa32 %zmm8, %zmm18 {%k1}
; AVX512DQ-NEXT:    vmovdqa 96(%rsi), %xmm8
; AVX512DQ-NEXT:    vmovdqa 96(%rdi), %xmm15
; AVX512DQ-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm15[4],xmm8[4],xmm15[5],xmm8[5],xmm15[6],xmm8[6],xmm15[7],xmm8[7]
; AVX512DQ-NEXT:    vpmovzxdq {{.*#+}} xmm16 = xmm0[0],zero,xmm0[1],zero
; AVX512DQ-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX512DQ-NEXT:    vinserti32x4 $1, %xmm0, %ymm16, %ymm0
; AVX512DQ-NEXT:    vpunpcklwd {{.*#+}} xmm8 = xmm15[0],xmm8[0],xmm15[1],xmm8[1],xmm15[2],xmm8[2],xmm15[3],xmm8[3]
; AVX512DQ-NEXT:    vpmovzxdq {{.*#+}} xmm15 = xmm8[0],zero,xmm8[1],zero
; AVX512DQ-NEXT:    vpshufd {{.*#+}} xmm8 = xmm8[2,2,3,3]
; AVX512DQ-NEXT:    vinserti128 $1, %xmm8, %ymm15, %ymm8
; AVX512DQ-NEXT:    vinserti64x4 $1, %ymm0, %zmm8, %zmm8
; AVX512DQ-NEXT:    vmovdqa 96(%rcx), %xmm0
; AVX512DQ-NEXT:    vmovdqa 96(%rdx), %xmm15
; AVX512DQ-NEXT:    vpunpckhwd {{.*#+}} xmm1 = xmm15[4],xmm0[4],xmm15[5],xmm0[5],xmm15[6],xmm0[6],xmm15[7],xmm0[7]
; AVX512DQ-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm15[0],xmm0[0],xmm15[1],xmm0[1],xmm15[2],xmm0[2],xmm15[3],xmm0[3]
; AVX512DQ-NEXT:    vpermt2d %zmm1, %zmm5, %zmm0
; AVX512DQ-NEXT:    vmovdqa32 %zmm0, %zmm8 {%k1}
; AVX512DQ-NEXT:    vmovdqa 112(%rsi), %xmm0
; AVX512DQ-NEXT:    vmovdqa 112(%rdi), %xmm1
; AVX512DQ-NEXT:    vpunpckhwd {{.*#+}} xmm15 = xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; AVX512DQ-NEXT:    vpmovzxdq {{.*#+}} xmm16 = xmm15[0],zero,xmm15[1],zero
; AVX512DQ-NEXT:    vpshufd {{.*#+}} xmm15 = xmm15[2,2,3,3]
; AVX512DQ-NEXT:    vinserti32x4 $1, %xmm15, %ymm16, %ymm15
; AVX512DQ-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; AVX512DQ-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm0[0],zero,xmm0[1],zero
; AVX512DQ-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX512DQ-NEXT:    vinserti128 $1, %xmm0, %ymm1, %ymm0
; AVX512DQ-NEXT:    vinserti64x4 $1, %ymm15, %zmm0, %zmm15
; AVX512DQ-NEXT:    vmovdqa 112(%rcx), %xmm0
; AVX512DQ-NEXT:    vmovdqa 112(%rdx), %xmm1
; AVX512DQ-NEXT:    vpunpckhwd {{.*#+}} xmm2 = xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; AVX512DQ-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; AVX512DQ-NEXT:    vpermt2d %zmm2, %zmm5, %zmm0
; AVX512DQ-NEXT:    vmovdqa32 %zmm0, %zmm15 {%k1}
; AVX512DQ-NEXT:    vmovdqa 64(%rsi), %xmm0
; AVX512DQ-NEXT:    vmovdqa 64(%rdi), %xmm1
; AVX512DQ-NEXT:    vpunpckhwd {{.*#+}} xmm2 = xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; AVX512DQ-NEXT:    vpmovzxdq {{.*#+}} xmm16 = xmm2[0],zero,xmm2[1],zero
; AVX512DQ-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[2,2,3,3]
; AVX512DQ-NEXT:    vinserti32x4 $1, %xmm2, %ymm16, %ymm2
; AVX512DQ-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; AVX512DQ-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm0[0],zero,xmm0[1],zero
; AVX512DQ-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX512DQ-NEXT:    vinserti128 $1, %xmm0, %ymm1, %ymm0
; AVX512DQ-NEXT:    vinserti64x4 $1, %ymm2, %zmm0, %zmm16
; AVX512DQ-NEXT:    vmovdqa 64(%rcx), %xmm0
; AVX512DQ-NEXT:    vmovdqa 64(%rdx), %xmm1
; AVX512DQ-NEXT:    vpunpckhwd {{.*#+}} xmm2 = xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; AVX512DQ-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; AVX512DQ-NEXT:    vpermt2d %zmm2, %zmm5, %zmm0
; AVX512DQ-NEXT:    vmovdqa32 %zmm0, %zmm16 {%k1}
; AVX512DQ-NEXT:    vmovdqa 80(%rsi), %xmm0
; AVX512DQ-NEXT:    vmovdqa 80(%rdi), %xmm1
; AVX512DQ-NEXT:    vpunpckhwd {{.*#+}} xmm2 = xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; AVX512DQ-NEXT:    vpmovzxdq {{.*#+}} xmm17 = xmm2[0],zero,xmm2[1],zero
; AVX512DQ-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[2,2,3,3]
; AVX512DQ-NEXT:    vinserti32x4 $1, %xmm2, %ymm17, %ymm2
; AVX512DQ-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; AVX512DQ-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm0[0],zero,xmm0[1],zero
; AVX512DQ-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX512DQ-NEXT:    vinserti128 $1, %xmm0, %ymm1, %ymm0
; AVX512DQ-NEXT:    vinserti64x4 $1, %ymm2, %zmm0, %zmm17
; AVX512DQ-NEXT:    vmovdqa 80(%rcx), %xmm0
; AVX512DQ-NEXT:    vmovdqa 80(%rdx), %xmm1
; AVX512DQ-NEXT:    vpunpckhwd {{.*#+}} xmm2 = xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; AVX512DQ-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; AVX512DQ-NEXT:    vpermt2d %zmm2, %zmm5, %zmm0
; AVX512DQ-NEXT:    vmovdqa32 %zmm0, %zmm17 {%k1}
; AVX512DQ-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm12[4],xmm11[4],xmm12[5],xmm11[5],xmm12[6],xmm11[6],xmm12[7],xmm11[7]
; AVX512DQ-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm0[0],zero,xmm0[1],zero
; AVX512DQ-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX512DQ-NEXT:    vinserti128 $1, %xmm0, %ymm1, %ymm0
; AVX512DQ-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm12[0],xmm11[0],xmm12[1],xmm11[1],xmm12[2],xmm11[2],xmm12[3],xmm11[3]
; AVX512DQ-NEXT:    vpmovzxdq {{.*#+}} xmm2 = xmm1[0],zero,xmm1[1],zero
; AVX512DQ-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,2,3,3]
; AVX512DQ-NEXT:    vinserti128 $1, %xmm1, %ymm2, %ymm1
; AVX512DQ-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512DQ-NEXT:    vpunpckhwd {{.*#+}} xmm1 = xmm14[4],xmm13[4],xmm14[5],xmm13[5],xmm14[6],xmm13[6],xmm14[7],xmm13[7]
; AVX512DQ-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm14[0],xmm13[0],xmm14[1],xmm13[1],xmm14[2],xmm13[2],xmm14[3],xmm13[3]
; AVX512DQ-NEXT:    vpermt2d %zmm1, %zmm5, %zmm2
; AVX512DQ-NEXT:    vmovdqa32 %zmm2, %zmm0 {%k1}
; AVX512DQ-NEXT:    vpunpckhwd {{.*#+}} xmm1 = xmm7[4],xmm6[4],xmm7[5],xmm6[5],xmm7[6],xmm6[6],xmm7[7],xmm6[7]
; AVX512DQ-NEXT:    vpmovzxdq {{.*#+}} xmm2 = xmm1[0],zero,xmm1[1],zero
; AVX512DQ-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,2,3,3]
; AVX512DQ-NEXT:    vinserti128 $1, %xmm1, %ymm2, %ymm1
; AVX512DQ-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm7[0],xmm6[0],xmm7[1],xmm6[1],xmm7[2],xmm6[2],xmm7[3],xmm6[3]
; AVX512DQ-NEXT:    vpmovzxdq {{.*#+}} xmm6 = xmm2[0],zero,xmm2[1],zero
; AVX512DQ-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[2,2,3,3]
; AVX512DQ-NEXT:    vinserti128 $1, %xmm2, %ymm6, %ymm2
; AVX512DQ-NEXT:    vinserti64x4 $1, %ymm1, %zmm2, %zmm1
; AVX512DQ-NEXT:    vpunpckhwd {{.*#+}} xmm2 = xmm10[4],xmm9[4],xmm10[5],xmm9[5],xmm10[6],xmm9[6],xmm10[7],xmm9[7]
; AVX512DQ-NEXT:    vpunpcklwd {{.*#+}} xmm6 = xmm10[0],xmm9[0],xmm10[1],xmm9[1],xmm10[2],xmm9[2],xmm10[3],xmm9[3]
; AVX512DQ-NEXT:    vpermt2d %zmm2, %zmm5, %zmm6
; AVX512DQ-NEXT:    vmovdqa32 %zmm6, %zmm1 {%k1}
; AVX512DQ-NEXT:    vmovdqa64 %xmm19, %xmm7
; AVX512DQ-NEXT:    vmovdqa64 %xmm20, %xmm9
; AVX512DQ-NEXT:    vpunpckhwd {{.*#+}} xmm2 = xmm9[4],xmm7[4],xmm9[5],xmm7[5],xmm9[6],xmm7[6],xmm9[7],xmm7[7]
; AVX512DQ-NEXT:    vpmovzxdq {{.*#+}} xmm6 = xmm2[0],zero,xmm2[1],zero
; AVX512DQ-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[2,2,3,3]
; AVX512DQ-NEXT:    vinserti128 $1, %xmm2, %ymm6, %ymm2
; AVX512DQ-NEXT:    vpunpcklwd {{.*#+}} xmm6 = xmm9[0],xmm7[0],xmm9[1],xmm7[1],xmm9[2],xmm7[2],xmm9[3],xmm7[3]
; AVX512DQ-NEXT:    vpmovzxdq {{.*#+}} xmm7 = xmm6[0],zero,xmm6[1],zero
; AVX512DQ-NEXT:    vpshufd {{.*#+}} xmm6 = xmm6[2,2,3,3]
; AVX512DQ-NEXT:    vinserti128 $1, %xmm6, %ymm7, %ymm6
; AVX512DQ-NEXT:    vinserti64x4 $1, %ymm2, %zmm6, %zmm2
; AVX512DQ-NEXT:    vpunpckhwd {{.*#+}} xmm6 = xmm4[4],xmm3[4],xmm4[5],xmm3[5],xmm4[6],xmm3[6],xmm4[7],xmm3[7]
; AVX512DQ-NEXT:    vpunpcklwd {{.*#+}} xmm3 = xmm4[0],xmm3[0],xmm4[1],xmm3[1],xmm4[2],xmm3[2],xmm4[3],xmm3[3]
; AVX512DQ-NEXT:    vpermt2d %zmm6, %zmm5, %zmm3
; AVX512DQ-NEXT:    vmovdqa32 %zmm3, %zmm2 {%k1}
; AVX512DQ-NEXT:    vmovdqa64 %zmm2, (%r8)
; AVX512DQ-NEXT:    vmovdqa64 %zmm1, 192(%r8)
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, 128(%r8)
; AVX512DQ-NEXT:    vmovdqa64 %zmm17, 320(%r8)
; AVX512DQ-NEXT:    vmovdqa64 %zmm16, 256(%r8)
; AVX512DQ-NEXT:    vmovdqa64 %zmm15, 448(%r8)
; AVX512DQ-NEXT:    vmovdqa64 %zmm8, 384(%r8)
; AVX512DQ-NEXT:    vmovdqa64 %zmm18, 64(%r8)
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512DQ-FCP-LABEL: store_i16_stride4_vf64:
; AVX512DQ-FCP:       # %bb.0:
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rsi), %xmm19
; AVX512DQ-FCP-NEXT:    vmovdqa 16(%rsi), %xmm0
; AVX512DQ-FCP-NEXT:    vmovdqa 32(%rsi), %xmm11
; AVX512DQ-FCP-NEXT:    vmovdqa 48(%rsi), %xmm6
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rdi), %xmm20
; AVX512DQ-FCP-NEXT:    vmovdqa 16(%rdi), %xmm3
; AVX512DQ-FCP-NEXT:    vmovdqa 32(%rdi), %xmm12
; AVX512DQ-FCP-NEXT:    vmovdqa 48(%rdi), %xmm7
; AVX512DQ-FCP-NEXT:    vpunpckhwd {{.*#+}} xmm4 = xmm3[4],xmm0[4],xmm3[5],xmm0[5],xmm3[6],xmm0[6],xmm3[7],xmm0[7]
; AVX512DQ-FCP-NEXT:    vpmovzxdq {{.*#+}} xmm5 = xmm4[0],zero,xmm4[1],zero
; AVX512DQ-FCP-NEXT:    vpshufd {{.*#+}} xmm4 = xmm4[2,2,3,3]
; AVX512DQ-FCP-NEXT:    vinserti128 $1, %xmm4, %ymm5, %ymm4
; AVX512DQ-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm3[0],xmm0[0],xmm3[1],xmm0[1],xmm3[2],xmm0[2],xmm3[3],xmm0[3]
; AVX512DQ-FCP-NEXT:    vpmovzxdq {{.*#+}} xmm3 = xmm0[0],zero,xmm0[1],zero
; AVX512DQ-FCP-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX512DQ-FCP-NEXT:    vinserti128 $1, %xmm0, %ymm3, %ymm0
; AVX512DQ-FCP-NEXT:    vinserti64x4 $1, %ymm4, %zmm0, %zmm18
; AVX512DQ-FCP-NEXT:    vmovdqa (%rcx), %xmm3
; AVX512DQ-FCP-NEXT:    vmovdqa 16(%rcx), %xmm5
; AVX512DQ-FCP-NEXT:    vmovdqa 32(%rcx), %xmm13
; AVX512DQ-FCP-NEXT:    vmovdqa 48(%rcx), %xmm9
; AVX512DQ-FCP-NEXT:    vmovdqa (%rdx), %xmm4
; AVX512DQ-FCP-NEXT:    vmovdqa 16(%rdx), %xmm8
; AVX512DQ-FCP-NEXT:    vmovdqa 32(%rdx), %xmm14
; AVX512DQ-FCP-NEXT:    vmovdqa 48(%rdx), %xmm10
; AVX512DQ-FCP-NEXT:    vpunpckhwd {{.*#+}} xmm15 = xmm8[4],xmm5[4],xmm8[5],xmm5[5],xmm8[6],xmm5[6],xmm8[7],xmm5[7]
; AVX512DQ-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm8 = xmm8[0],xmm5[0],xmm8[1],xmm5[1],xmm8[2],xmm5[2],xmm8[3],xmm5[3]
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm5 = [0,0,1,1,2,2,3,3,16,16,17,17,18,18,19,19]
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm15, %zmm5, %zmm8
; AVX512DQ-FCP-NEXT:    movw $-21846, %ax # imm = 0xAAAA
; AVX512DQ-FCP-NEXT:    kmovw %eax, %k1
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm8, %zmm18 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqa 96(%rsi), %xmm8
; AVX512DQ-FCP-NEXT:    vmovdqa 96(%rdi), %xmm15
; AVX512DQ-FCP-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm15[4],xmm8[4],xmm15[5],xmm8[5],xmm15[6],xmm8[6],xmm15[7],xmm8[7]
; AVX512DQ-FCP-NEXT:    vpmovzxdq {{.*#+}} xmm16 = xmm0[0],zero,xmm0[1],zero
; AVX512DQ-FCP-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX512DQ-FCP-NEXT:    vinserti32x4 $1, %xmm0, %ymm16, %ymm0
; AVX512DQ-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm8 = xmm15[0],xmm8[0],xmm15[1],xmm8[1],xmm15[2],xmm8[2],xmm15[3],xmm8[3]
; AVX512DQ-FCP-NEXT:    vpmovzxdq {{.*#+}} xmm15 = xmm8[0],zero,xmm8[1],zero
; AVX512DQ-FCP-NEXT:    vpshufd {{.*#+}} xmm8 = xmm8[2,2,3,3]
; AVX512DQ-FCP-NEXT:    vinserti128 $1, %xmm8, %ymm15, %ymm8
; AVX512DQ-FCP-NEXT:    vinserti64x4 $1, %ymm0, %zmm8, %zmm8
; AVX512DQ-FCP-NEXT:    vmovdqa 96(%rcx), %xmm0
; AVX512DQ-FCP-NEXT:    vmovdqa 96(%rdx), %xmm15
; AVX512DQ-FCP-NEXT:    vpunpckhwd {{.*#+}} xmm1 = xmm15[4],xmm0[4],xmm15[5],xmm0[5],xmm15[6],xmm0[6],xmm15[7],xmm0[7]
; AVX512DQ-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm15[0],xmm0[0],xmm15[1],xmm0[1],xmm15[2],xmm0[2],xmm15[3],xmm0[3]
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm1, %zmm5, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm0, %zmm8 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqa 112(%rsi), %xmm0
; AVX512DQ-FCP-NEXT:    vmovdqa 112(%rdi), %xmm1
; AVX512DQ-FCP-NEXT:    vpunpckhwd {{.*#+}} xmm15 = xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; AVX512DQ-FCP-NEXT:    vpmovzxdq {{.*#+}} xmm16 = xmm15[0],zero,xmm15[1],zero
; AVX512DQ-FCP-NEXT:    vpshufd {{.*#+}} xmm15 = xmm15[2,2,3,3]
; AVX512DQ-FCP-NEXT:    vinserti32x4 $1, %xmm15, %ymm16, %ymm15
; AVX512DQ-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; AVX512DQ-FCP-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm0[0],zero,xmm0[1],zero
; AVX512DQ-FCP-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX512DQ-FCP-NEXT:    vinserti128 $1, %xmm0, %ymm1, %ymm0
; AVX512DQ-FCP-NEXT:    vinserti64x4 $1, %ymm15, %zmm0, %zmm15
; AVX512DQ-FCP-NEXT:    vmovdqa 112(%rcx), %xmm0
; AVX512DQ-FCP-NEXT:    vmovdqa 112(%rdx), %xmm1
; AVX512DQ-FCP-NEXT:    vpunpckhwd {{.*#+}} xmm2 = xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; AVX512DQ-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm2, %zmm5, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm0, %zmm15 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqa 64(%rsi), %xmm0
; AVX512DQ-FCP-NEXT:    vmovdqa 64(%rdi), %xmm1
; AVX512DQ-FCP-NEXT:    vpunpckhwd {{.*#+}} xmm2 = xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; AVX512DQ-FCP-NEXT:    vpmovzxdq {{.*#+}} xmm16 = xmm2[0],zero,xmm2[1],zero
; AVX512DQ-FCP-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[2,2,3,3]
; AVX512DQ-FCP-NEXT:    vinserti32x4 $1, %xmm2, %ymm16, %ymm2
; AVX512DQ-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; AVX512DQ-FCP-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm0[0],zero,xmm0[1],zero
; AVX512DQ-FCP-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX512DQ-FCP-NEXT:    vinserti128 $1, %xmm0, %ymm1, %ymm0
; AVX512DQ-FCP-NEXT:    vinserti64x4 $1, %ymm2, %zmm0, %zmm16
; AVX512DQ-FCP-NEXT:    vmovdqa 64(%rcx), %xmm0
; AVX512DQ-FCP-NEXT:    vmovdqa 64(%rdx), %xmm1
; AVX512DQ-FCP-NEXT:    vpunpckhwd {{.*#+}} xmm2 = xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; AVX512DQ-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm2, %zmm5, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm0, %zmm16 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqa 80(%rsi), %xmm0
; AVX512DQ-FCP-NEXT:    vmovdqa 80(%rdi), %xmm1
; AVX512DQ-FCP-NEXT:    vpunpckhwd {{.*#+}} xmm2 = xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; AVX512DQ-FCP-NEXT:    vpmovzxdq {{.*#+}} xmm17 = xmm2[0],zero,xmm2[1],zero
; AVX512DQ-FCP-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[2,2,3,3]
; AVX512DQ-FCP-NEXT:    vinserti32x4 $1, %xmm2, %ymm17, %ymm2
; AVX512DQ-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; AVX512DQ-FCP-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm0[0],zero,xmm0[1],zero
; AVX512DQ-FCP-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX512DQ-FCP-NEXT:    vinserti128 $1, %xmm0, %ymm1, %ymm0
; AVX512DQ-FCP-NEXT:    vinserti64x4 $1, %ymm2, %zmm0, %zmm17
; AVX512DQ-FCP-NEXT:    vmovdqa 80(%rcx), %xmm0
; AVX512DQ-FCP-NEXT:    vmovdqa 80(%rdx), %xmm1
; AVX512DQ-FCP-NEXT:    vpunpckhwd {{.*#+}} xmm2 = xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; AVX512DQ-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm2, %zmm5, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm0, %zmm17 {%k1}
; AVX512DQ-FCP-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm12[4],xmm11[4],xmm12[5],xmm11[5],xmm12[6],xmm11[6],xmm12[7],xmm11[7]
; AVX512DQ-FCP-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm0[0],zero,xmm0[1],zero
; AVX512DQ-FCP-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX512DQ-FCP-NEXT:    vinserti128 $1, %xmm0, %ymm1, %ymm0
; AVX512DQ-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm12[0],xmm11[0],xmm12[1],xmm11[1],xmm12[2],xmm11[2],xmm12[3],xmm11[3]
; AVX512DQ-FCP-NEXT:    vpmovzxdq {{.*#+}} xmm2 = xmm1[0],zero,xmm1[1],zero
; AVX512DQ-FCP-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,2,3,3]
; AVX512DQ-FCP-NEXT:    vinserti128 $1, %xmm1, %ymm2, %ymm1
; AVX512DQ-FCP-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512DQ-FCP-NEXT:    vpunpckhwd {{.*#+}} xmm1 = xmm14[4],xmm13[4],xmm14[5],xmm13[5],xmm14[6],xmm13[6],xmm14[7],xmm13[7]
; AVX512DQ-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm14[0],xmm13[0],xmm14[1],xmm13[1],xmm14[2],xmm13[2],xmm14[3],xmm13[3]
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm1, %zmm5, %zmm2
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm2, %zmm0 {%k1}
; AVX512DQ-FCP-NEXT:    vpunpckhwd {{.*#+}} xmm1 = xmm7[4],xmm6[4],xmm7[5],xmm6[5],xmm7[6],xmm6[6],xmm7[7],xmm6[7]
; AVX512DQ-FCP-NEXT:    vpmovzxdq {{.*#+}} xmm2 = xmm1[0],zero,xmm1[1],zero
; AVX512DQ-FCP-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,2,3,3]
; AVX512DQ-FCP-NEXT:    vinserti128 $1, %xmm1, %ymm2, %ymm1
; AVX512DQ-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm7[0],xmm6[0],xmm7[1],xmm6[1],xmm7[2],xmm6[2],xmm7[3],xmm6[3]
; AVX512DQ-FCP-NEXT:    vpmovzxdq {{.*#+}} xmm6 = xmm2[0],zero,xmm2[1],zero
; AVX512DQ-FCP-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[2,2,3,3]
; AVX512DQ-FCP-NEXT:    vinserti128 $1, %xmm2, %ymm6, %ymm2
; AVX512DQ-FCP-NEXT:    vinserti64x4 $1, %ymm1, %zmm2, %zmm1
; AVX512DQ-FCP-NEXT:    vpunpckhwd {{.*#+}} xmm2 = xmm10[4],xmm9[4],xmm10[5],xmm9[5],xmm10[6],xmm9[6],xmm10[7],xmm9[7]
; AVX512DQ-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm6 = xmm10[0],xmm9[0],xmm10[1],xmm9[1],xmm10[2],xmm9[2],xmm10[3],xmm9[3]
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm2, %zmm5, %zmm6
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm6, %zmm1 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqa64 %xmm19, %xmm7
; AVX512DQ-FCP-NEXT:    vmovdqa64 %xmm20, %xmm9
; AVX512DQ-FCP-NEXT:    vpunpckhwd {{.*#+}} xmm2 = xmm9[4],xmm7[4],xmm9[5],xmm7[5],xmm9[6],xmm7[6],xmm9[7],xmm7[7]
; AVX512DQ-FCP-NEXT:    vpmovzxdq {{.*#+}} xmm6 = xmm2[0],zero,xmm2[1],zero
; AVX512DQ-FCP-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[2,2,3,3]
; AVX512DQ-FCP-NEXT:    vinserti128 $1, %xmm2, %ymm6, %ymm2
; AVX512DQ-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm6 = xmm9[0],xmm7[0],xmm9[1],xmm7[1],xmm9[2],xmm7[2],xmm9[3],xmm7[3]
; AVX512DQ-FCP-NEXT:    vpmovzxdq {{.*#+}} xmm7 = xmm6[0],zero,xmm6[1],zero
; AVX512DQ-FCP-NEXT:    vpshufd {{.*#+}} xmm6 = xmm6[2,2,3,3]
; AVX512DQ-FCP-NEXT:    vinserti128 $1, %xmm6, %ymm7, %ymm6
; AVX512DQ-FCP-NEXT:    vinserti64x4 $1, %ymm2, %zmm6, %zmm2
; AVX512DQ-FCP-NEXT:    vpunpckhwd {{.*#+}} xmm6 = xmm4[4],xmm3[4],xmm4[5],xmm3[5],xmm4[6],xmm3[6],xmm4[7],xmm3[7]
; AVX512DQ-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm3 = xmm4[0],xmm3[0],xmm4[1],xmm3[1],xmm4[2],xmm3[2],xmm4[3],xmm3[3]
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm6, %zmm5, %zmm3
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm3, %zmm2 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm2, (%r8)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm1, 192(%r8)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, 128(%r8)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm17, 320(%r8)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm16, 256(%r8)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm15, 448(%r8)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm8, 384(%r8)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm18, 64(%r8)
; AVX512DQ-FCP-NEXT:    vzeroupper
; AVX512DQ-FCP-NEXT:    retq
;
; AVX512BW-LABEL: store_i16_stride4_vf64:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512BW-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512BW-NEXT:    vmovdqa64 (%rsi), %zmm2
; AVX512BW-NEXT:    vmovdqa64 64(%rsi), %zmm3
; AVX512BW-NEXT:    vmovdqa64 (%rdx), %zmm4
; AVX512BW-NEXT:    vmovdqa64 64(%rdx), %zmm5
; AVX512BW-NEXT:    vmovdqa64 (%rcx), %zmm6
; AVX512BW-NEXT:    vmovdqa64 64(%rcx), %zmm7
; AVX512BW-NEXT:    vpmovsxbw {{.*#+}} zmm8 = [0,0,8,40,0,0,9,41,0,0,10,42,0,0,11,43,0,0,12,44,0,0,13,45,0,0,14,46,0,0,15,47]
; AVX512BW-NEXT:    vmovdqa64 %zmm4, %zmm9
; AVX512BW-NEXT:    vpermt2w %zmm6, %zmm8, %zmm9
; AVX512BW-NEXT:    vpmovsxbw {{.*#+}} zmm10 = [8,40,0,0,9,41,0,0,10,42,0,0,11,43,0,0,12,44,0,0,13,45,0,0,14,46,0,0,15,47,0,0]
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm11
; AVX512BW-NEXT:    vpermt2w %zmm2, %zmm10, %zmm11
; AVX512BW-NEXT:    movw $-21846, %ax # imm = 0xAAAA
; AVX512BW-NEXT:    kmovd %eax, %k1
; AVX512BW-NEXT:    vmovdqa32 %zmm9, %zmm11 {%k1}
; AVX512BW-NEXT:    vpmovsxbw {{.*#+}} zmm9 = [0,0,0,32,0,0,1,33,0,0,2,34,0,0,3,35,0,0,4,36,0,0,5,37,0,0,6,38,0,0,7,39]
; AVX512BW-NEXT:    vmovdqa64 %zmm4, %zmm12
; AVX512BW-NEXT:    vpermt2w %zmm6, %zmm9, %zmm12
; AVX512BW-NEXT:    vpmovsxbw {{.*#+}} zmm13 = [0,32,0,0,1,33,0,0,2,34,0,0,3,35,0,0,4,36,0,0,5,37,0,0,6,38,0,0,7,39,0,0]
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm14
; AVX512BW-NEXT:    vpermt2w %zmm2, %zmm13, %zmm14
; AVX512BW-NEXT:    vmovdqa32 %zmm12, %zmm14 {%k1}
; AVX512BW-NEXT:    vpmovsxbw {{.*#+}} zmm12 = [0,0,24,56,0,0,25,57,0,0,26,58,0,0,27,59,0,0,28,60,0,0,29,61,0,0,30,62,0,0,31,63]
; AVX512BW-NEXT:    vmovdqa64 %zmm4, %zmm15
; AVX512BW-NEXT:    vpermt2w %zmm6, %zmm12, %zmm15
; AVX512BW-NEXT:    vpmovsxbw {{.*#+}} zmm16 = [24,56,0,0,25,57,0,0,26,58,0,0,27,59,0,0,28,60,0,0,29,61,0,0,30,62,0,0,31,63,0,0]
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm17
; AVX512BW-NEXT:    vpermt2w %zmm2, %zmm16, %zmm17
; AVX512BW-NEXT:    vmovdqa32 %zmm15, %zmm17 {%k1}
; AVX512BW-NEXT:    vpmovsxbw {{.*#+}} zmm15 = [0,0,16,48,0,0,17,49,0,0,18,50,0,0,19,51,0,0,20,52,0,0,21,53,0,0,22,54,0,0,23,55]
; AVX512BW-NEXT:    vpermt2w %zmm6, %zmm15, %zmm4
; AVX512BW-NEXT:    vpmovsxbw {{.*#+}} zmm6 = [16,48,0,0,17,49,0,0,18,50,0,0,19,51,0,0,20,52,0,0,21,53,0,0,22,54,0,0,23,55,0,0]
; AVX512BW-NEXT:    vpermt2w %zmm2, %zmm6, %zmm0
; AVX512BW-NEXT:    vmovdqa32 %zmm4, %zmm0 {%k1}
; AVX512BW-NEXT:    vpermi2w %zmm7, %zmm5, %zmm8
; AVX512BW-NEXT:    vpermi2w %zmm3, %zmm1, %zmm10
; AVX512BW-NEXT:    vmovdqa32 %zmm8, %zmm10 {%k1}
; AVX512BW-NEXT:    vpermi2w %zmm7, %zmm5, %zmm9
; AVX512BW-NEXT:    vpermi2w %zmm3, %zmm1, %zmm13
; AVX512BW-NEXT:    vmovdqa32 %zmm9, %zmm13 {%k1}
; AVX512BW-NEXT:    vpermi2w %zmm7, %zmm5, %zmm12
; AVX512BW-NEXT:    vpermi2w %zmm3, %zmm1, %zmm16
; AVX512BW-NEXT:    vmovdqa32 %zmm12, %zmm16 {%k1}
; AVX512BW-NEXT:    vpermt2w %zmm7, %zmm15, %zmm5
; AVX512BW-NEXT:    vpermt2w %zmm3, %zmm6, %zmm1
; AVX512BW-NEXT:    vmovdqa32 %zmm5, %zmm1 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm1, 384(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm16, 448(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm13, 256(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm10, 320(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm0, 128(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm17, 192(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm14, (%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm11, 64(%r8)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BW-FCP-LABEL: store_i16_stride4_vf64:
; AVX512BW-FCP:       # %bb.0:
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512BW-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rsi), %zmm2
; AVX512BW-FCP-NEXT:    vmovdqa64 64(%rsi), %zmm3
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rdx), %zmm4
; AVX512BW-FCP-NEXT:    vmovdqa64 64(%rdx), %zmm5
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rcx), %zmm6
; AVX512BW-FCP-NEXT:    vmovdqa64 64(%rcx), %zmm7
; AVX512BW-FCP-NEXT:    vpmovsxbw {{.*#+}} zmm8 = [0,0,8,40,0,0,9,41,0,0,10,42,0,0,11,43,0,0,12,44,0,0,13,45,0,0,14,46,0,0,15,47]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm4, %zmm9
; AVX512BW-FCP-NEXT:    vpermt2w %zmm6, %zmm8, %zmm9
; AVX512BW-FCP-NEXT:    vpmovsxbw {{.*#+}} zmm10 = [8,40,0,0,9,41,0,0,10,42,0,0,11,43,0,0,12,44,0,0,13,45,0,0,14,46,0,0,15,47,0,0]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm11
; AVX512BW-FCP-NEXT:    vpermt2w %zmm2, %zmm10, %zmm11
; AVX512BW-FCP-NEXT:    movw $-21846, %ax # imm = 0xAAAA
; AVX512BW-FCP-NEXT:    kmovd %eax, %k1
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm9, %zmm11 {%k1}
; AVX512BW-FCP-NEXT:    vpmovsxbw {{.*#+}} zmm9 = [0,0,0,32,0,0,1,33,0,0,2,34,0,0,3,35,0,0,4,36,0,0,5,37,0,0,6,38,0,0,7,39]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm4, %zmm12
; AVX512BW-FCP-NEXT:    vpermt2w %zmm6, %zmm9, %zmm12
; AVX512BW-FCP-NEXT:    vpmovsxbw {{.*#+}} zmm13 = [0,32,0,0,1,33,0,0,2,34,0,0,3,35,0,0,4,36,0,0,5,37,0,0,6,38,0,0,7,39,0,0]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm14
; AVX512BW-FCP-NEXT:    vpermt2w %zmm2, %zmm13, %zmm14
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm12, %zmm14 {%k1}
; AVX512BW-FCP-NEXT:    vpmovsxbw {{.*#+}} zmm12 = [0,0,24,56,0,0,25,57,0,0,26,58,0,0,27,59,0,0,28,60,0,0,29,61,0,0,30,62,0,0,31,63]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm4, %zmm15
; AVX512BW-FCP-NEXT:    vpermt2w %zmm6, %zmm12, %zmm15
; AVX512BW-FCP-NEXT:    vpmovsxbw {{.*#+}} zmm16 = [24,56,0,0,25,57,0,0,26,58,0,0,27,59,0,0,28,60,0,0,29,61,0,0,30,62,0,0,31,63,0,0]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm17
; AVX512BW-FCP-NEXT:    vpermt2w %zmm2, %zmm16, %zmm17
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm15, %zmm17 {%k1}
; AVX512BW-FCP-NEXT:    vpmovsxbw {{.*#+}} zmm15 = [0,0,16,48,0,0,17,49,0,0,18,50,0,0,19,51,0,0,20,52,0,0,21,53,0,0,22,54,0,0,23,55]
; AVX512BW-FCP-NEXT:    vpermt2w %zmm6, %zmm15, %zmm4
; AVX512BW-FCP-NEXT:    vpmovsxbw {{.*#+}} zmm6 = [16,48,0,0,17,49,0,0,18,50,0,0,19,51,0,0,20,52,0,0,21,53,0,0,22,54,0,0,23,55,0,0]
; AVX512BW-FCP-NEXT:    vpermt2w %zmm2, %zmm6, %zmm0
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm4, %zmm0 {%k1}
; AVX512BW-FCP-NEXT:    vpermi2w %zmm7, %zmm5, %zmm8
; AVX512BW-FCP-NEXT:    vpermi2w %zmm3, %zmm1, %zmm10
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm8, %zmm10 {%k1}
; AVX512BW-FCP-NEXT:    vpermi2w %zmm7, %zmm5, %zmm9
; AVX512BW-FCP-NEXT:    vpermi2w %zmm3, %zmm1, %zmm13
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm9, %zmm13 {%k1}
; AVX512BW-FCP-NEXT:    vpermi2w %zmm7, %zmm5, %zmm12
; AVX512BW-FCP-NEXT:    vpermi2w %zmm3, %zmm1, %zmm16
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm12, %zmm16 {%k1}
; AVX512BW-FCP-NEXT:    vpermt2w %zmm7, %zmm15, %zmm5
; AVX512BW-FCP-NEXT:    vpermt2w %zmm3, %zmm6, %zmm1
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm5, %zmm1 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm1, 384(%r8)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm16, 448(%r8)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm13, 256(%r8)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm10, 320(%r8)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, 128(%r8)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm17, 192(%r8)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm14, (%r8)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm11, 64(%r8)
; AVX512BW-FCP-NEXT:    vzeroupper
; AVX512BW-FCP-NEXT:    retq
;
; AVX512DQ-BW-LABEL: store_i16_stride4_vf64:
; AVX512DQ-BW:       # %bb.0:
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512DQ-BW-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rsi), %zmm2
; AVX512DQ-BW-NEXT:    vmovdqa64 64(%rsi), %zmm3
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rdx), %zmm4
; AVX512DQ-BW-NEXT:    vmovdqa64 64(%rdx), %zmm5
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rcx), %zmm6
; AVX512DQ-BW-NEXT:    vmovdqa64 64(%rcx), %zmm7
; AVX512DQ-BW-NEXT:    vpmovsxbw {{.*#+}} zmm8 = [0,0,8,40,0,0,9,41,0,0,10,42,0,0,11,43,0,0,12,44,0,0,13,45,0,0,14,46,0,0,15,47]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm4, %zmm9
; AVX512DQ-BW-NEXT:    vpermt2w %zmm6, %zmm8, %zmm9
; AVX512DQ-BW-NEXT:    vpmovsxbw {{.*#+}} zmm10 = [8,40,0,0,9,41,0,0,10,42,0,0,11,43,0,0,12,44,0,0,13,45,0,0,14,46,0,0,15,47,0,0]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, %zmm11
; AVX512DQ-BW-NEXT:    vpermt2w %zmm2, %zmm10, %zmm11
; AVX512DQ-BW-NEXT:    movw $-21846, %ax # imm = 0xAAAA
; AVX512DQ-BW-NEXT:    kmovd %eax, %k1
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm9, %zmm11 {%k1}
; AVX512DQ-BW-NEXT:    vpmovsxbw {{.*#+}} zmm9 = [0,0,0,32,0,0,1,33,0,0,2,34,0,0,3,35,0,0,4,36,0,0,5,37,0,0,6,38,0,0,7,39]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm4, %zmm12
; AVX512DQ-BW-NEXT:    vpermt2w %zmm6, %zmm9, %zmm12
; AVX512DQ-BW-NEXT:    vpmovsxbw {{.*#+}} zmm13 = [0,32,0,0,1,33,0,0,2,34,0,0,3,35,0,0,4,36,0,0,5,37,0,0,6,38,0,0,7,39,0,0]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, %zmm14
; AVX512DQ-BW-NEXT:    vpermt2w %zmm2, %zmm13, %zmm14
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm12, %zmm14 {%k1}
; AVX512DQ-BW-NEXT:    vpmovsxbw {{.*#+}} zmm12 = [0,0,24,56,0,0,25,57,0,0,26,58,0,0,27,59,0,0,28,60,0,0,29,61,0,0,30,62,0,0,31,63]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm4, %zmm15
; AVX512DQ-BW-NEXT:    vpermt2w %zmm6, %zmm12, %zmm15
; AVX512DQ-BW-NEXT:    vpmovsxbw {{.*#+}} zmm16 = [24,56,0,0,25,57,0,0,26,58,0,0,27,59,0,0,28,60,0,0,29,61,0,0,30,62,0,0,31,63,0,0]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, %zmm17
; AVX512DQ-BW-NEXT:    vpermt2w %zmm2, %zmm16, %zmm17
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm15, %zmm17 {%k1}
; AVX512DQ-BW-NEXT:    vpmovsxbw {{.*#+}} zmm15 = [0,0,16,48,0,0,17,49,0,0,18,50,0,0,19,51,0,0,20,52,0,0,21,53,0,0,22,54,0,0,23,55]
; AVX512DQ-BW-NEXT:    vpermt2w %zmm6, %zmm15, %zmm4
; AVX512DQ-BW-NEXT:    vpmovsxbw {{.*#+}} zmm6 = [16,48,0,0,17,49,0,0,18,50,0,0,19,51,0,0,20,52,0,0,21,53,0,0,22,54,0,0,23,55,0,0]
; AVX512DQ-BW-NEXT:    vpermt2w %zmm2, %zmm6, %zmm0
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm4, %zmm0 {%k1}
; AVX512DQ-BW-NEXT:    vpermi2w %zmm7, %zmm5, %zmm8
; AVX512DQ-BW-NEXT:    vpermi2w %zmm3, %zmm1, %zmm10
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm8, %zmm10 {%k1}
; AVX512DQ-BW-NEXT:    vpermi2w %zmm7, %zmm5, %zmm9
; AVX512DQ-BW-NEXT:    vpermi2w %zmm3, %zmm1, %zmm13
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm9, %zmm13 {%k1}
; AVX512DQ-BW-NEXT:    vpermi2w %zmm7, %zmm5, %zmm12
; AVX512DQ-BW-NEXT:    vpermi2w %zmm3, %zmm1, %zmm16
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm12, %zmm16 {%k1}
; AVX512DQ-BW-NEXT:    vpermt2w %zmm7, %zmm15, %zmm5
; AVX512DQ-BW-NEXT:    vpermt2w %zmm3, %zmm6, %zmm1
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm5, %zmm1 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm1, 384(%r8)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm16, 448(%r8)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm13, 256(%r8)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm10, 320(%r8)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, 128(%r8)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm17, 192(%r8)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm14, (%r8)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm11, 64(%r8)
; AVX512DQ-BW-NEXT:    vzeroupper
; AVX512DQ-BW-NEXT:    retq
;
; AVX512DQ-BW-FCP-LABEL: store_i16_stride4_vf64:
; AVX512DQ-BW-FCP:       # %bb.0:
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rsi), %zmm2
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 64(%rsi), %zmm3
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rdx), %zmm4
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 64(%rdx), %zmm5
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rcx), %zmm6
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 64(%rcx), %zmm7
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbw {{.*#+}} zmm8 = [0,0,8,40,0,0,9,41,0,0,10,42,0,0,11,43,0,0,12,44,0,0,13,45,0,0,14,46,0,0,15,47]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm4, %zmm9
; AVX512DQ-BW-FCP-NEXT:    vpermt2w %zmm6, %zmm8, %zmm9
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbw {{.*#+}} zmm10 = [8,40,0,0,9,41,0,0,10,42,0,0,11,43,0,0,12,44,0,0,13,45,0,0,14,46,0,0,15,47,0,0]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm11
; AVX512DQ-BW-FCP-NEXT:    vpermt2w %zmm2, %zmm10, %zmm11
; AVX512DQ-BW-FCP-NEXT:    movw $-21846, %ax # imm = 0xAAAA
; AVX512DQ-BW-FCP-NEXT:    kmovd %eax, %k1
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm9, %zmm11 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbw {{.*#+}} zmm9 = [0,0,0,32,0,0,1,33,0,0,2,34,0,0,3,35,0,0,4,36,0,0,5,37,0,0,6,38,0,0,7,39]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm4, %zmm12
; AVX512DQ-BW-FCP-NEXT:    vpermt2w %zmm6, %zmm9, %zmm12
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbw {{.*#+}} zmm13 = [0,32,0,0,1,33,0,0,2,34,0,0,3,35,0,0,4,36,0,0,5,37,0,0,6,38,0,0,7,39,0,0]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm14
; AVX512DQ-BW-FCP-NEXT:    vpermt2w %zmm2, %zmm13, %zmm14
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm12, %zmm14 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbw {{.*#+}} zmm12 = [0,0,24,56,0,0,25,57,0,0,26,58,0,0,27,59,0,0,28,60,0,0,29,61,0,0,30,62,0,0,31,63]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm4, %zmm15
; AVX512DQ-BW-FCP-NEXT:    vpermt2w %zmm6, %zmm12, %zmm15
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbw {{.*#+}} zmm16 = [24,56,0,0,25,57,0,0,26,58,0,0,27,59,0,0,28,60,0,0,29,61,0,0,30,62,0,0,31,63,0,0]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm17
; AVX512DQ-BW-FCP-NEXT:    vpermt2w %zmm2, %zmm16, %zmm17
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm15, %zmm17 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbw {{.*#+}} zmm15 = [0,0,16,48,0,0,17,49,0,0,18,50,0,0,19,51,0,0,20,52,0,0,21,53,0,0,22,54,0,0,23,55]
; AVX512DQ-BW-FCP-NEXT:    vpermt2w %zmm6, %zmm15, %zmm4
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbw {{.*#+}} zmm6 = [16,48,0,0,17,49,0,0,18,50,0,0,19,51,0,0,20,52,0,0,21,53,0,0,22,54,0,0,23,55,0,0]
; AVX512DQ-BW-FCP-NEXT:    vpermt2w %zmm2, %zmm6, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm4, %zmm0 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpermi2w %zmm7, %zmm5, %zmm8
; AVX512DQ-BW-FCP-NEXT:    vpermi2w %zmm3, %zmm1, %zmm10
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm8, %zmm10 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpermi2w %zmm7, %zmm5, %zmm9
; AVX512DQ-BW-FCP-NEXT:    vpermi2w %zmm3, %zmm1, %zmm13
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm9, %zmm13 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpermi2w %zmm7, %zmm5, %zmm12
; AVX512DQ-BW-FCP-NEXT:    vpermi2w %zmm3, %zmm1, %zmm16
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm12, %zmm16 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpermt2w %zmm7, %zmm15, %zmm5
; AVX512DQ-BW-FCP-NEXT:    vpermt2w %zmm3, %zmm6, %zmm1
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm5, %zmm1 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm1, 384(%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm16, 448(%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm13, 256(%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm10, 320(%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, 128(%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm17, 192(%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm14, (%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm11, 64(%r8)
; AVX512DQ-BW-FCP-NEXT:    vzeroupper
; AVX512DQ-BW-FCP-NEXT:    retq
  %in.vec0 = load <64 x i16>, ptr %in.vecptr0, align 64
  %in.vec1 = load <64 x i16>, ptr %in.vecptr1, align 64
  %in.vec2 = load <64 x i16>, ptr %in.vecptr2, align 64
  %in.vec3 = load <64 x i16>, ptr %in.vecptr3, align 64
  %1 = shufflevector <64 x i16> %in.vec0, <64 x i16> %in.vec1, <128 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127>
  %2 = shufflevector <64 x i16> %in.vec2, <64 x i16> %in.vec3, <128 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127>
  %3 = shufflevector <128 x i16> %1, <128 x i16> %2, <256 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127, i32 128, i32 129, i32 130, i32 131, i32 132, i32 133, i32 134, i32 135, i32 136, i32 137, i32 138, i32 139, i32 140, i32 141, i32 142, i32 143, i32 144, i32 145, i32 146, i32 147, i32 148, i32 149, i32 150, i32 151, i32 152, i32 153, i32 154, i32 155, i32 156, i32 157, i32 158, i32 159, i32 160, i32 161, i32 162, i32 163, i32 164, i32 165, i32 166, i32 167, i32 168, i32 169, i32 170, i32 171, i32 172, i32 173, i32 174, i32 175, i32 176, i32 177, i32 178, i32 179, i32 180, i32 181, i32 182, i32 183, i32 184, i32 185, i32 186, i32 187, i32 188, i32 189, i32 190, i32 191, i32 192, i32 193, i32 194, i32 195, i32 196, i32 197, i32 198, i32 199, i32 200, i32 201, i32 202, i32 203, i32 204, i32 205, i32 206, i32 207, i32 208, i32 209, i32 210, i32 211, i32 212, i32 213, i32 214, i32 215, i32 216, i32 217, i32 218, i32 219, i32 220, i32 221, i32 222, i32 223, i32 224, i32 225, i32 226, i32 227, i32 228, i32 229, i32 230, i32 231, i32 232, i32 233, i32 234, i32 235, i32 236, i32 237, i32 238, i32 239, i32 240, i32 241, i32 242, i32 243, i32 244, i32 245, i32 246, i32 247, i32 248, i32 249, i32 250, i32 251, i32 252, i32 253, i32 254, i32 255>
  %interleaved.vec = shufflevector <256 x i16> %3, <256 x i16> poison, <256 x i32> <i32 0, i32 64, i32 128, i32 192, i32 1, i32 65, i32 129, i32 193, i32 2, i32 66, i32 130, i32 194, i32 3, i32 67, i32 131, i32 195, i32 4, i32 68, i32 132, i32 196, i32 5, i32 69, i32 133, i32 197, i32 6, i32 70, i32 134, i32 198, i32 7, i32 71, i32 135, i32 199, i32 8, i32 72, i32 136, i32 200, i32 9, i32 73, i32 137, i32 201, i32 10, i32 74, i32 138, i32 202, i32 11, i32 75, i32 139, i32 203, i32 12, i32 76, i32 140, i32 204, i32 13, i32 77, i32 141, i32 205, i32 14, i32 78, i32 142, i32 206, i32 15, i32 79, i32 143, i32 207, i32 16, i32 80, i32 144, i32 208, i32 17, i32 81, i32 145, i32 209, i32 18, i32 82, i32 146, i32 210, i32 19, i32 83, i32 147, i32 211, i32 20, i32 84, i32 148, i32 212, i32 21, i32 85, i32 149, i32 213, i32 22, i32 86, i32 150, i32 214, i32 23, i32 87, i32 151, i32 215, i32 24, i32 88, i32 152, i32 216, i32 25, i32 89, i32 153, i32 217, i32 26, i32 90, i32 154, i32 218, i32 27, i32 91, i32 155, i32 219, i32 28, i32 92, i32 156, i32 220, i32 29, i32 93, i32 157, i32 221, i32 30, i32 94, i32 158, i32 222, i32 31, i32 95, i32 159, i32 223, i32 32, i32 96, i32 160, i32 224, i32 33, i32 97, i32 161, i32 225, i32 34, i32 98, i32 162, i32 226, i32 35, i32 99, i32 163, i32 227, i32 36, i32 100, i32 164, i32 228, i32 37, i32 101, i32 165, i32 229, i32 38, i32 102, i32 166, i32 230, i32 39, i32 103, i32 167, i32 231, i32 40, i32 104, i32 168, i32 232, i32 41, i32 105, i32 169, i32 233, i32 42, i32 106, i32 170, i32 234, i32 43, i32 107, i32 171, i32 235, i32 44, i32 108, i32 172, i32 236, i32 45, i32 109, i32 173, i32 237, i32 46, i32 110, i32 174, i32 238, i32 47, i32 111, i32 175, i32 239, i32 48, i32 112, i32 176, i32 240, i32 49, i32 113, i32 177, i32 241, i32 50, i32 114, i32 178, i32 242, i32 51, i32 115, i32 179, i32 243, i32 52, i32 116, i32 180, i32 244, i32 53, i32 117, i32 181, i32 245, i32 54, i32 118, i32 182, i32 246, i32 55, i32 119, i32 183, i32 247, i32 56, i32 120, i32 184, i32 248, i32 57, i32 121, i32 185, i32 249, i32 58, i32 122, i32 186, i32 250, i32 59, i32 123, i32 187, i32 251, i32 60, i32 124, i32 188, i32 252, i32 61, i32 125, i32 189, i32 253, i32 62, i32 126, i32 190, i32 254, i32 63, i32 127, i32 191, i32 255>
  store <256 x i16> %interleaved.vec, ptr %out.vec, align 64
  ret void
}
