; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=aarch64-none-eabi -verify-machineinstrs %s -o - | FileCheck %s --check-prefixes=CHECK,CHECK-SD
; RUN: llc -mtriple=aarch64-none-eabi -global-isel -verify-machineinstrs %s -o - | FileCheck %s --check-prefixes=CHECK,CHECK-GI

define i8 @and_i8(i8 %a, i8 %b) {
; CHECK-LABEL: and_i8:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    and w0, w0, w1
; CHECK-NEXT:    ret
entry:
  %s = and i8 %a, %b
  ret i8 %s
}

define i8 @or_i8(i8 %a, i8 %b) {
; CHECK-LABEL: or_i8:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    orr w0, w0, w1
; CHECK-NEXT:    ret
entry:
  %s = or i8 %a, %b
  ret i8 %s
}

define i8 @xor_i8(i8 %a, i8 %b) {
; CHECK-LABEL: xor_i8:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    eor w0, w0, w1
; CHECK-NEXT:    ret
entry:
  %s = xor i8 %a, %b
  ret i8 %s
}

define i16 @and_i16(i16 %a, i16 %b) {
; CHECK-LABEL: and_i16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    and w0, w0, w1
; CHECK-NEXT:    ret
entry:
  %s = and i16 %a, %b
  ret i16 %s
}

define i16 @or_i16(i16 %a, i16 %b) {
; CHECK-LABEL: or_i16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    orr w0, w0, w1
; CHECK-NEXT:    ret
entry:
  %s = or i16 %a, %b
  ret i16 %s
}

define i16 @xor_i16(i16 %a, i16 %b) {
; CHECK-LABEL: xor_i16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    eor w0, w0, w1
; CHECK-NEXT:    ret
entry:
  %s = xor i16 %a, %b
  ret i16 %s
}

define i32 @and_i32(i32 %a, i32 %b) {
; CHECK-LABEL: and_i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    and w0, w0, w1
; CHECK-NEXT:    ret
entry:
  %s = and i32 %a, %b
  ret i32 %s
}

define i32 @or_i32(i32 %a, i32 %b) {
; CHECK-LABEL: or_i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    orr w0, w0, w1
; CHECK-NEXT:    ret
entry:
  %s = or i32 %a, %b
  ret i32 %s
}

define i32 @xor_i32(i32 %a, i32 %b) {
; CHECK-LABEL: xor_i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    eor w0, w0, w1
; CHECK-NEXT:    ret
entry:
  %s = xor i32 %a, %b
  ret i32 %s
}

define i64 @and_i64(i64 %a, i64 %b) {
; CHECK-LABEL: and_i64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    and x0, x0, x1
; CHECK-NEXT:    ret
entry:
  %s = and i64 %a, %b
  ret i64 %s
}

define i64 @or_i64(i64 %a, i64 %b) {
; CHECK-LABEL: or_i64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    orr x0, x0, x1
; CHECK-NEXT:    ret
entry:
  %s = or i64 %a, %b
  ret i64 %s
}

define i64 @xor_i64(i64 %a, i64 %b) {
; CHECK-LABEL: xor_i64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    eor x0, x0, x1
; CHECK-NEXT:    ret
entry:
  %s = xor i64 %a, %b
  ret i64 %s
}

define i128 @and_i128(i128 %a, i128 %b) {
; CHECK-SD-LABEL: and_i128:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    and x1, x1, x3
; CHECK-SD-NEXT:    and x0, x0, x2
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: and_i128:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    and x0, x0, x2
; CHECK-GI-NEXT:    and x1, x1, x3
; CHECK-GI-NEXT:    ret
entry:
  %s = and i128 %a, %b
  ret i128 %s
}

define i128 @or_i128(i128 %a, i128 %b) {
; CHECK-SD-LABEL: or_i128:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    orr x1, x1, x3
; CHECK-SD-NEXT:    orr x0, x0, x2
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: or_i128:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    orr x0, x0, x2
; CHECK-GI-NEXT:    orr x1, x1, x3
; CHECK-GI-NEXT:    ret
entry:
  %s = or i128 %a, %b
  ret i128 %s
}

define i128 @xor_i128(i128 %a, i128 %b) {
; CHECK-SD-LABEL: xor_i128:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    eor x1, x1, x3
; CHECK-SD-NEXT:    eor x0, x0, x2
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: xor_i128:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    eor x0, x0, x2
; CHECK-GI-NEXT:    eor x1, x1, x3
; CHECK-GI-NEXT:    ret
entry:
  %s = xor i128 %a, %b
  ret i128 %s
}

define void @and_v2i8(ptr %p1, ptr %p2) {
; CHECK-SD-LABEL: and_v2i8:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    ld1 { v0.b }[0], [x0]
; CHECK-SD-NEXT:    ld1 { v1.b }[0], [x1]
; CHECK-SD-NEXT:    add x8, x0, #1
; CHECK-SD-NEXT:    add x9, x1, #1
; CHECK-SD-NEXT:    ld1 { v0.b }[4], [x8]
; CHECK-SD-NEXT:    ld1 { v1.b }[4], [x9]
; CHECK-SD-NEXT:    and v0.8b, v0.8b, v1.8b
; CHECK-SD-NEXT:    mov s1, v0.s[1]
; CHECK-SD-NEXT:    str b0, [x0]
; CHECK-SD-NEXT:    stur b1, [x0, #1]
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: and_v2i8:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    ld1 { v0.b }[0], [x0]
; CHECK-GI-NEXT:    ld1 { v1.b }[0], [x1]
; CHECK-GI-NEXT:    ldr b2, [x0, #1]
; CHECK-GI-NEXT:    ldr b3, [x1, #1]
; CHECK-GI-NEXT:    mov v0.s[1], v2.s[0]
; CHECK-GI-NEXT:    mov v1.s[1], v3.s[0]
; CHECK-GI-NEXT:    and v0.8b, v0.8b, v1.8b
; CHECK-GI-NEXT:    mov s1, v0.s[1]
; CHECK-GI-NEXT:    str b0, [x0]
; CHECK-GI-NEXT:    str b1, [x0, #1]
; CHECK-GI-NEXT:    ret
entry:
  %d = load <2 x i8>, ptr %p1
  %e = load <2 x i8>, ptr %p2
  %s = and <2 x i8> %d, %e
  store <2 x i8> %s, ptr %p1
  ret void
}

define void @or_v2i8(ptr %p1, ptr %p2) {
; CHECK-SD-LABEL: or_v2i8:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    ld1 { v0.b }[0], [x0]
; CHECK-SD-NEXT:    ld1 { v1.b }[0], [x1]
; CHECK-SD-NEXT:    add x8, x0, #1
; CHECK-SD-NEXT:    add x9, x1, #1
; CHECK-SD-NEXT:    ld1 { v0.b }[4], [x8]
; CHECK-SD-NEXT:    ld1 { v1.b }[4], [x9]
; CHECK-SD-NEXT:    orr v0.8b, v0.8b, v1.8b
; CHECK-SD-NEXT:    mov s1, v0.s[1]
; CHECK-SD-NEXT:    str b0, [x0]
; CHECK-SD-NEXT:    stur b1, [x0, #1]
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: or_v2i8:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    ld1 { v0.b }[0], [x0]
; CHECK-GI-NEXT:    ld1 { v1.b }[0], [x1]
; CHECK-GI-NEXT:    ldr b2, [x0, #1]
; CHECK-GI-NEXT:    ldr b3, [x1, #1]
; CHECK-GI-NEXT:    mov v0.s[1], v2.s[0]
; CHECK-GI-NEXT:    mov v1.s[1], v3.s[0]
; CHECK-GI-NEXT:    orr v0.8b, v0.8b, v1.8b
; CHECK-GI-NEXT:    mov s1, v0.s[1]
; CHECK-GI-NEXT:    str b0, [x0]
; CHECK-GI-NEXT:    str b1, [x0, #1]
; CHECK-GI-NEXT:    ret
entry:
  %d = load <2 x i8>, ptr %p1
  %e = load <2 x i8>, ptr %p2
  %s = or <2 x i8> %d, %e
  store <2 x i8> %s, ptr %p1
  ret void
}

define void @xor_v2i8(ptr %p1, ptr %p2) {
; CHECK-SD-LABEL: xor_v2i8:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    ld1 { v0.b }[0], [x0]
; CHECK-SD-NEXT:    ld1 { v1.b }[0], [x1]
; CHECK-SD-NEXT:    add x8, x0, #1
; CHECK-SD-NEXT:    add x9, x1, #1
; CHECK-SD-NEXT:    ld1 { v0.b }[4], [x8]
; CHECK-SD-NEXT:    ld1 { v1.b }[4], [x9]
; CHECK-SD-NEXT:    eor v0.8b, v0.8b, v1.8b
; CHECK-SD-NEXT:    mov s1, v0.s[1]
; CHECK-SD-NEXT:    str b0, [x0]
; CHECK-SD-NEXT:    stur b1, [x0, #1]
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: xor_v2i8:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    ld1 { v0.b }[0], [x0]
; CHECK-GI-NEXT:    ld1 { v1.b }[0], [x1]
; CHECK-GI-NEXT:    ldr b2, [x0, #1]
; CHECK-GI-NEXT:    ldr b3, [x1, #1]
; CHECK-GI-NEXT:    mov v0.s[1], v2.s[0]
; CHECK-GI-NEXT:    mov v1.s[1], v3.s[0]
; CHECK-GI-NEXT:    eor v0.8b, v0.8b, v1.8b
; CHECK-GI-NEXT:    mov s1, v0.s[1]
; CHECK-GI-NEXT:    str b0, [x0]
; CHECK-GI-NEXT:    str b1, [x0, #1]
; CHECK-GI-NEXT:    ret
entry:
  %d = load <2 x i8>, ptr %p1
  %e = load <2 x i8>, ptr %p2
  %s = xor <2 x i8> %d, %e
  store <2 x i8> %s, ptr %p1
  ret void
}

define void @and_v3i8(ptr %p1, ptr %p2) {
; CHECK-SD-LABEL: and_v3i8:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sub sp, sp, #16
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 16
; CHECK-SD-NEXT:    ldr s0, [x0]
; CHECK-SD-NEXT:    ldr s1, [x1]
; CHECK-SD-NEXT:    zip1 v0.8b, v0.8b, v0.8b
; CHECK-SD-NEXT:    zip1 v1.8b, v1.8b, v0.8b
; CHECK-SD-NEXT:    and v0.8b, v0.8b, v1.8b
; CHECK-SD-NEXT:    uzp1 v1.8b, v0.8b, v0.8b
; CHECK-SD-NEXT:    mov h0, v0.h[2]
; CHECK-SD-NEXT:    str s1, [sp, #12]
; CHECK-SD-NEXT:    ldrh w8, [sp, #12]
; CHECK-SD-NEXT:    stur b0, [x0, #2]
; CHECK-SD-NEXT:    strh w8, [x0]
; CHECK-SD-NEXT:    add sp, sp, #16
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: and_v3i8:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    ldr w8, [x0]
; CHECK-GI-NEXT:    ldr w9, [x1]
; CHECK-GI-NEXT:    fmov s0, w8
; CHECK-GI-NEXT:    fmov s1, w9
; CHECK-GI-NEXT:    mov b2, v0.b[1]
; CHECK-GI-NEXT:    mov b3, v1.b[1]
; CHECK-GI-NEXT:    mov b4, v0.b[2]
; CHECK-GI-NEXT:    mov b5, v1.b[2]
; CHECK-GI-NEXT:    fmov w8, s2
; CHECK-GI-NEXT:    fmov w9, s3
; CHECK-GI-NEXT:    mov v0.h[1], w8
; CHECK-GI-NEXT:    mov v1.h[1], w9
; CHECK-GI-NEXT:    fmov w8, s4
; CHECK-GI-NEXT:    fmov w9, s5
; CHECK-GI-NEXT:    mov v0.h[2], w8
; CHECK-GI-NEXT:    mov v1.h[2], w9
; CHECK-GI-NEXT:    and v0.8b, v0.8b, v1.8b
; CHECK-GI-NEXT:    mov h1, v0.h[1]
; CHECK-GI-NEXT:    mov h2, v0.h[2]
; CHECK-GI-NEXT:    str b0, [x0]
; CHECK-GI-NEXT:    str b1, [x0, #1]
; CHECK-GI-NEXT:    str b2, [x0, #2]
; CHECK-GI-NEXT:    ret
entry:
  %d = load <3 x i8>, ptr %p1
  %e = load <3 x i8>, ptr %p2
  %s = and <3 x i8> %d, %e
  store <3 x i8> %s, ptr %p1
  ret void
}

define void @or_v3i8(ptr %p1, ptr %p2) {
; CHECK-SD-LABEL: or_v3i8:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sub sp, sp, #16
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 16
; CHECK-SD-NEXT:    ldr s0, [x0]
; CHECK-SD-NEXT:    ldr s1, [x1]
; CHECK-SD-NEXT:    zip1 v0.8b, v0.8b, v0.8b
; CHECK-SD-NEXT:    zip1 v1.8b, v1.8b, v0.8b
; CHECK-SD-NEXT:    orr v0.8b, v0.8b, v1.8b
; CHECK-SD-NEXT:    uzp1 v1.8b, v0.8b, v0.8b
; CHECK-SD-NEXT:    mov h0, v0.h[2]
; CHECK-SD-NEXT:    str s1, [sp, #12]
; CHECK-SD-NEXT:    ldrh w8, [sp, #12]
; CHECK-SD-NEXT:    stur b0, [x0, #2]
; CHECK-SD-NEXT:    strh w8, [x0]
; CHECK-SD-NEXT:    add sp, sp, #16
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: or_v3i8:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    ldr w8, [x0]
; CHECK-GI-NEXT:    ldr w9, [x1]
; CHECK-GI-NEXT:    fmov s0, w8
; CHECK-GI-NEXT:    fmov s1, w9
; CHECK-GI-NEXT:    mov b2, v0.b[1]
; CHECK-GI-NEXT:    mov b3, v1.b[1]
; CHECK-GI-NEXT:    mov b4, v0.b[2]
; CHECK-GI-NEXT:    mov b5, v1.b[2]
; CHECK-GI-NEXT:    fmov w8, s2
; CHECK-GI-NEXT:    fmov w9, s3
; CHECK-GI-NEXT:    mov v0.h[1], w8
; CHECK-GI-NEXT:    mov v1.h[1], w9
; CHECK-GI-NEXT:    fmov w8, s4
; CHECK-GI-NEXT:    fmov w9, s5
; CHECK-GI-NEXT:    mov v0.h[2], w8
; CHECK-GI-NEXT:    mov v1.h[2], w9
; CHECK-GI-NEXT:    orr v0.8b, v0.8b, v1.8b
; CHECK-GI-NEXT:    mov h1, v0.h[1]
; CHECK-GI-NEXT:    mov h2, v0.h[2]
; CHECK-GI-NEXT:    str b0, [x0]
; CHECK-GI-NEXT:    str b1, [x0, #1]
; CHECK-GI-NEXT:    str b2, [x0, #2]
; CHECK-GI-NEXT:    ret
entry:
  %d = load <3 x i8>, ptr %p1
  %e = load <3 x i8>, ptr %p2
  %s = or <3 x i8> %d, %e
  store <3 x i8> %s, ptr %p1
  ret void
}

define void @xor_v3i8(ptr %p1, ptr %p2) {
; CHECK-SD-LABEL: xor_v3i8:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sub sp, sp, #16
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 16
; CHECK-SD-NEXT:    ldr s0, [x0]
; CHECK-SD-NEXT:    ldr s1, [x1]
; CHECK-SD-NEXT:    zip1 v0.8b, v0.8b, v0.8b
; CHECK-SD-NEXT:    zip1 v1.8b, v1.8b, v0.8b
; CHECK-SD-NEXT:    eor v0.8b, v0.8b, v1.8b
; CHECK-SD-NEXT:    uzp1 v1.8b, v0.8b, v0.8b
; CHECK-SD-NEXT:    mov h0, v0.h[2]
; CHECK-SD-NEXT:    str s1, [sp, #12]
; CHECK-SD-NEXT:    ldrh w8, [sp, #12]
; CHECK-SD-NEXT:    stur b0, [x0, #2]
; CHECK-SD-NEXT:    strh w8, [x0]
; CHECK-SD-NEXT:    add sp, sp, #16
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: xor_v3i8:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    ldr w8, [x0]
; CHECK-GI-NEXT:    ldr w9, [x1]
; CHECK-GI-NEXT:    fmov s0, w8
; CHECK-GI-NEXT:    fmov s1, w9
; CHECK-GI-NEXT:    mov b2, v0.b[1]
; CHECK-GI-NEXT:    mov b3, v1.b[1]
; CHECK-GI-NEXT:    mov b4, v0.b[2]
; CHECK-GI-NEXT:    mov b5, v1.b[2]
; CHECK-GI-NEXT:    fmov w8, s2
; CHECK-GI-NEXT:    fmov w9, s3
; CHECK-GI-NEXT:    mov v0.h[1], w8
; CHECK-GI-NEXT:    mov v1.h[1], w9
; CHECK-GI-NEXT:    fmov w8, s4
; CHECK-GI-NEXT:    fmov w9, s5
; CHECK-GI-NEXT:    mov v0.h[2], w8
; CHECK-GI-NEXT:    mov v1.h[2], w9
; CHECK-GI-NEXT:    eor v0.8b, v0.8b, v1.8b
; CHECK-GI-NEXT:    mov h1, v0.h[1]
; CHECK-GI-NEXT:    mov h2, v0.h[2]
; CHECK-GI-NEXT:    str b0, [x0]
; CHECK-GI-NEXT:    str b1, [x0, #1]
; CHECK-GI-NEXT:    str b2, [x0, #2]
; CHECK-GI-NEXT:    ret
entry:
  %d = load <3 x i8>, ptr %p1
  %e = load <3 x i8>, ptr %p2
  %s = xor <3 x i8> %d, %e
  store <3 x i8> %s, ptr %p1
  ret void
}

define void @and_v4i8(ptr %p1, ptr %p2) {
; CHECK-SD-LABEL: and_v4i8:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    ldr s0, [x0]
; CHECK-SD-NEXT:    ldr s1, [x1]
; CHECK-SD-NEXT:    zip1 v0.8b, v0.8b, v0.8b
; CHECK-SD-NEXT:    zip1 v1.8b, v1.8b, v1.8b
; CHECK-SD-NEXT:    and v0.8b, v0.8b, v1.8b
; CHECK-SD-NEXT:    uzp1 v0.8b, v0.8b, v0.8b
; CHECK-SD-NEXT:    str s0, [x0]
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: and_v4i8:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    ldr w8, [x0]
; CHECK-GI-NEXT:    ldr w9, [x1]
; CHECK-GI-NEXT:    fmov s0, w8
; CHECK-GI-NEXT:    fmov s1, w9
; CHECK-GI-NEXT:    mov b2, v0.b[1]
; CHECK-GI-NEXT:    mov b3, v1.b[1]
; CHECK-GI-NEXT:    mov b4, v0.b[2]
; CHECK-GI-NEXT:    mov b5, v0.b[3]
; CHECK-GI-NEXT:    fmov w8, s2
; CHECK-GI-NEXT:    mov b2, v1.b[2]
; CHECK-GI-NEXT:    fmov w9, s3
; CHECK-GI-NEXT:    mov b3, v1.b[3]
; CHECK-GI-NEXT:    mov v0.h[1], w8
; CHECK-GI-NEXT:    mov v1.h[1], w9
; CHECK-GI-NEXT:    fmov w8, s4
; CHECK-GI-NEXT:    fmov w9, s2
; CHECK-GI-NEXT:    mov v0.h[2], w8
; CHECK-GI-NEXT:    mov v1.h[2], w9
; CHECK-GI-NEXT:    fmov w8, s5
; CHECK-GI-NEXT:    fmov w9, s3
; CHECK-GI-NEXT:    mov v0.h[3], w8
; CHECK-GI-NEXT:    mov v1.h[3], w9
; CHECK-GI-NEXT:    and v0.8b, v0.8b, v1.8b
; CHECK-GI-NEXT:    uzp1 v0.8b, v0.8b, v0.8b
; CHECK-GI-NEXT:    fmov w8, s0
; CHECK-GI-NEXT:    str w8, [x0]
; CHECK-GI-NEXT:    ret
entry:
  %d = load <4 x i8>, ptr %p1
  %e = load <4 x i8>, ptr %p2
  %s = and <4 x i8> %d, %e
  store <4 x i8> %s, ptr %p1
  ret void
}

define void @or_v4i8(ptr %p1, ptr %p2) {
; CHECK-SD-LABEL: or_v4i8:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    ldr s0, [x0]
; CHECK-SD-NEXT:    ldr s1, [x1]
; CHECK-SD-NEXT:    zip1 v0.8b, v0.8b, v0.8b
; CHECK-SD-NEXT:    zip1 v1.8b, v1.8b, v1.8b
; CHECK-SD-NEXT:    orr v0.8b, v0.8b, v1.8b
; CHECK-SD-NEXT:    uzp1 v0.8b, v0.8b, v0.8b
; CHECK-SD-NEXT:    str s0, [x0]
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: or_v4i8:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    ldr w8, [x0]
; CHECK-GI-NEXT:    ldr w9, [x1]
; CHECK-GI-NEXT:    fmov s0, w8
; CHECK-GI-NEXT:    fmov s1, w9
; CHECK-GI-NEXT:    mov b2, v0.b[1]
; CHECK-GI-NEXT:    mov b3, v1.b[1]
; CHECK-GI-NEXT:    mov b4, v0.b[2]
; CHECK-GI-NEXT:    mov b5, v0.b[3]
; CHECK-GI-NEXT:    fmov w8, s2
; CHECK-GI-NEXT:    mov b2, v1.b[2]
; CHECK-GI-NEXT:    fmov w9, s3
; CHECK-GI-NEXT:    mov b3, v1.b[3]
; CHECK-GI-NEXT:    mov v0.h[1], w8
; CHECK-GI-NEXT:    mov v1.h[1], w9
; CHECK-GI-NEXT:    fmov w8, s4
; CHECK-GI-NEXT:    fmov w9, s2
; CHECK-GI-NEXT:    mov v0.h[2], w8
; CHECK-GI-NEXT:    mov v1.h[2], w9
; CHECK-GI-NEXT:    fmov w8, s5
; CHECK-GI-NEXT:    fmov w9, s3
; CHECK-GI-NEXT:    mov v0.h[3], w8
; CHECK-GI-NEXT:    mov v1.h[3], w9
; CHECK-GI-NEXT:    orr v0.8b, v0.8b, v1.8b
; CHECK-GI-NEXT:    uzp1 v0.8b, v0.8b, v0.8b
; CHECK-GI-NEXT:    fmov w8, s0
; CHECK-GI-NEXT:    str w8, [x0]
; CHECK-GI-NEXT:    ret
entry:
  %d = load <4 x i8>, ptr %p1
  %e = load <4 x i8>, ptr %p2
  %s = or <4 x i8> %d, %e
  store <4 x i8> %s, ptr %p1
  ret void
}

define void @xor_v4i8(ptr %p1, ptr %p2) {
; CHECK-SD-LABEL: xor_v4i8:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    ldr s0, [x0]
; CHECK-SD-NEXT:    ldr s1, [x1]
; CHECK-SD-NEXT:    zip1 v0.8b, v0.8b, v0.8b
; CHECK-SD-NEXT:    zip1 v1.8b, v1.8b, v1.8b
; CHECK-SD-NEXT:    eor v0.8b, v0.8b, v1.8b
; CHECK-SD-NEXT:    uzp1 v0.8b, v0.8b, v0.8b
; CHECK-SD-NEXT:    str s0, [x0]
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: xor_v4i8:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    ldr w8, [x0]
; CHECK-GI-NEXT:    ldr w9, [x1]
; CHECK-GI-NEXT:    fmov s0, w8
; CHECK-GI-NEXT:    fmov s1, w9
; CHECK-GI-NEXT:    mov b2, v0.b[1]
; CHECK-GI-NEXT:    mov b3, v1.b[1]
; CHECK-GI-NEXT:    mov b4, v0.b[2]
; CHECK-GI-NEXT:    mov b5, v0.b[3]
; CHECK-GI-NEXT:    fmov w8, s2
; CHECK-GI-NEXT:    mov b2, v1.b[2]
; CHECK-GI-NEXT:    fmov w9, s3
; CHECK-GI-NEXT:    mov b3, v1.b[3]
; CHECK-GI-NEXT:    mov v0.h[1], w8
; CHECK-GI-NEXT:    mov v1.h[1], w9
; CHECK-GI-NEXT:    fmov w8, s4
; CHECK-GI-NEXT:    fmov w9, s2
; CHECK-GI-NEXT:    mov v0.h[2], w8
; CHECK-GI-NEXT:    mov v1.h[2], w9
; CHECK-GI-NEXT:    fmov w8, s5
; CHECK-GI-NEXT:    fmov w9, s3
; CHECK-GI-NEXT:    mov v0.h[3], w8
; CHECK-GI-NEXT:    mov v1.h[3], w9
; CHECK-GI-NEXT:    eor v0.8b, v0.8b, v1.8b
; CHECK-GI-NEXT:    uzp1 v0.8b, v0.8b, v0.8b
; CHECK-GI-NEXT:    fmov w8, s0
; CHECK-GI-NEXT:    str w8, [x0]
; CHECK-GI-NEXT:    ret
entry:
  %d = load <4 x i8>, ptr %p1
  %e = load <4 x i8>, ptr %p2
  %s = xor <4 x i8> %d, %e
  store <4 x i8> %s, ptr %p1
  ret void
}

define <8 x i8> @and_v8i8(<8 x i8> %d, <8 x i8> %e) {
; CHECK-LABEL: and_v8i8:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    and v0.8b, v0.8b, v1.8b
; CHECK-NEXT:    ret
entry:
  %s = and <8 x i8> %d, %e
  ret <8 x i8> %s
}

define <8 x i8> @or_v8i8(<8 x i8> %d, <8 x i8> %e) {
; CHECK-LABEL: or_v8i8:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    orr v0.8b, v0.8b, v1.8b
; CHECK-NEXT:    ret
entry:
  %s = or <8 x i8> %d, %e
  ret <8 x i8> %s
}

define <8 x i8> @xor_v8i8(<8 x i8> %d, <8 x i8> %e) {
; CHECK-LABEL: xor_v8i8:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    eor v0.8b, v0.8b, v1.8b
; CHECK-NEXT:    ret
entry:
  %s = xor <8 x i8> %d, %e
  ret <8 x i8> %s
}

define <16 x i8> @and_v16i8(<16 x i8> %d, <16 x i8> %e) {
; CHECK-LABEL: and_v16i8:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ret
entry:
  %s = and <16 x i8> %d, %e
  ret <16 x i8> %s
}

define <16 x i8> @or_v16i8(<16 x i8> %d, <16 x i8> %e) {
; CHECK-LABEL: or_v16i8:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    orr v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ret
entry:
  %s = or <16 x i8> %d, %e
  ret <16 x i8> %s
}

define <16 x i8> @xor_v16i8(<16 x i8> %d, <16 x i8> %e) {
; CHECK-LABEL: xor_v16i8:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    eor v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ret
entry:
  %s = xor <16 x i8> %d, %e
  ret <16 x i8> %s
}

define <32 x i8> @and_v32i8(<32 x i8> %d, <32 x i8> %e) {
; CHECK-SD-LABEL: and_v32i8:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    and v1.16b, v1.16b, v3.16b
; CHECK-SD-NEXT:    and v0.16b, v0.16b, v2.16b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: and_v32i8:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    and v0.16b, v0.16b, v2.16b
; CHECK-GI-NEXT:    and v1.16b, v1.16b, v3.16b
; CHECK-GI-NEXT:    ret
entry:
  %s = and <32 x i8> %d, %e
  ret <32 x i8> %s
}

define <32 x i8> @or_v32i8(<32 x i8> %d, <32 x i8> %e) {
; CHECK-SD-LABEL: or_v32i8:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    orr v1.16b, v1.16b, v3.16b
; CHECK-SD-NEXT:    orr v0.16b, v0.16b, v2.16b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: or_v32i8:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    orr v0.16b, v0.16b, v2.16b
; CHECK-GI-NEXT:    orr v1.16b, v1.16b, v3.16b
; CHECK-GI-NEXT:    ret
entry:
  %s = or <32 x i8> %d, %e
  ret <32 x i8> %s
}

define <32 x i8> @xor_v32i8(<32 x i8> %d, <32 x i8> %e) {
; CHECK-SD-LABEL: xor_v32i8:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    eor v1.16b, v1.16b, v3.16b
; CHECK-SD-NEXT:    eor v0.16b, v0.16b, v2.16b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: xor_v32i8:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    eor v0.16b, v0.16b, v2.16b
; CHECK-GI-NEXT:    eor v1.16b, v1.16b, v3.16b
; CHECK-GI-NEXT:    ret
entry:
  %s = xor <32 x i8> %d, %e
  ret <32 x i8> %s
}

define void @and_v2i16(ptr %p1, ptr %p2) {
; CHECK-SD-LABEL: and_v2i16:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    ld1 { v0.h }[0], [x0]
; CHECK-SD-NEXT:    ld1 { v1.h }[0], [x1]
; CHECK-SD-NEXT:    add x8, x0, #2
; CHECK-SD-NEXT:    add x9, x1, #2
; CHECK-SD-NEXT:    ld1 { v0.h }[2], [x8]
; CHECK-SD-NEXT:    ld1 { v1.h }[2], [x9]
; CHECK-SD-NEXT:    and v0.8b, v0.8b, v1.8b
; CHECK-SD-NEXT:    mov s1, v0.s[1]
; CHECK-SD-NEXT:    str h0, [x0]
; CHECK-SD-NEXT:    str h1, [x0, #2]
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: and_v2i16:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    ld1 { v0.h }[0], [x0]
; CHECK-GI-NEXT:    ld1 { v1.h }[0], [x1]
; CHECK-GI-NEXT:    ldr h2, [x0, #2]
; CHECK-GI-NEXT:    ldr h3, [x1, #2]
; CHECK-GI-NEXT:    mov v0.s[1], v2.s[0]
; CHECK-GI-NEXT:    mov v1.s[1], v3.s[0]
; CHECK-GI-NEXT:    and v0.8b, v0.8b, v1.8b
; CHECK-GI-NEXT:    mov s1, v0.s[1]
; CHECK-GI-NEXT:    str h0, [x0]
; CHECK-GI-NEXT:    str h1, [x0, #2]
; CHECK-GI-NEXT:    ret
entry:
  %d = load <2 x i16>, ptr %p1
  %e = load <2 x i16>, ptr %p2
  %s = and <2 x i16> %d, %e
  store <2 x i16> %s, ptr %p1
  ret void
}

define void @or_v2i16(ptr %p1, ptr %p2) {
; CHECK-SD-LABEL: or_v2i16:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    ld1 { v0.h }[0], [x0]
; CHECK-SD-NEXT:    ld1 { v1.h }[0], [x1]
; CHECK-SD-NEXT:    add x8, x0, #2
; CHECK-SD-NEXT:    add x9, x1, #2
; CHECK-SD-NEXT:    ld1 { v0.h }[2], [x8]
; CHECK-SD-NEXT:    ld1 { v1.h }[2], [x9]
; CHECK-SD-NEXT:    orr v0.8b, v0.8b, v1.8b
; CHECK-SD-NEXT:    mov s1, v0.s[1]
; CHECK-SD-NEXT:    str h0, [x0]
; CHECK-SD-NEXT:    str h1, [x0, #2]
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: or_v2i16:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    ld1 { v0.h }[0], [x0]
; CHECK-GI-NEXT:    ld1 { v1.h }[0], [x1]
; CHECK-GI-NEXT:    ldr h2, [x0, #2]
; CHECK-GI-NEXT:    ldr h3, [x1, #2]
; CHECK-GI-NEXT:    mov v0.s[1], v2.s[0]
; CHECK-GI-NEXT:    mov v1.s[1], v3.s[0]
; CHECK-GI-NEXT:    orr v0.8b, v0.8b, v1.8b
; CHECK-GI-NEXT:    mov s1, v0.s[1]
; CHECK-GI-NEXT:    str h0, [x0]
; CHECK-GI-NEXT:    str h1, [x0, #2]
; CHECK-GI-NEXT:    ret
entry:
  %d = load <2 x i16>, ptr %p1
  %e = load <2 x i16>, ptr %p2
  %s = or <2 x i16> %d, %e
  store <2 x i16> %s, ptr %p1
  ret void
}

define void @xor_v2i16(ptr %p1, ptr %p2) {
; CHECK-SD-LABEL: xor_v2i16:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    ld1 { v0.h }[0], [x0]
; CHECK-SD-NEXT:    ld1 { v1.h }[0], [x1]
; CHECK-SD-NEXT:    add x8, x0, #2
; CHECK-SD-NEXT:    add x9, x1, #2
; CHECK-SD-NEXT:    ld1 { v0.h }[2], [x8]
; CHECK-SD-NEXT:    ld1 { v1.h }[2], [x9]
; CHECK-SD-NEXT:    eor v0.8b, v0.8b, v1.8b
; CHECK-SD-NEXT:    mov s1, v0.s[1]
; CHECK-SD-NEXT:    str h0, [x0]
; CHECK-SD-NEXT:    str h1, [x0, #2]
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: xor_v2i16:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    ld1 { v0.h }[0], [x0]
; CHECK-GI-NEXT:    ld1 { v1.h }[0], [x1]
; CHECK-GI-NEXT:    ldr h2, [x0, #2]
; CHECK-GI-NEXT:    ldr h3, [x1, #2]
; CHECK-GI-NEXT:    mov v0.s[1], v2.s[0]
; CHECK-GI-NEXT:    mov v1.s[1], v3.s[0]
; CHECK-GI-NEXT:    eor v0.8b, v0.8b, v1.8b
; CHECK-GI-NEXT:    mov s1, v0.s[1]
; CHECK-GI-NEXT:    str h0, [x0]
; CHECK-GI-NEXT:    str h1, [x0, #2]
; CHECK-GI-NEXT:    ret
entry:
  %d = load <2 x i16>, ptr %p1
  %e = load <2 x i16>, ptr %p2
  %s = xor <2 x i16> %d, %e
  store <2 x i16> %s, ptr %p1
  ret void
}

define void @and_v3i16(ptr %p1, ptr %p2) {
; CHECK-SD-LABEL: and_v3i16:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    ldr x8, [x0]
; CHECK-SD-NEXT:    ldr x9, [x1]
; CHECK-SD-NEXT:    and x8, x8, x9
; CHECK-SD-NEXT:    fmov d0, x8
; CHECK-SD-NEXT:    str w8, [x0]
; CHECK-SD-NEXT:    mov h0, v0.h[2]
; CHECK-SD-NEXT:    str h0, [x0, #4]
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: and_v3i16:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    ldr d0, [x0]
; CHECK-GI-NEXT:    ldr d1, [x1]
; CHECK-GI-NEXT:    add x8, x0, #2
; CHECK-GI-NEXT:    add x9, x0, #4
; CHECK-GI-NEXT:    and v0.8b, v0.8b, v1.8b
; CHECK-GI-NEXT:    str h0, [x0]
; CHECK-GI-NEXT:    st1 { v0.h }[1], [x8]
; CHECK-GI-NEXT:    st1 { v0.h }[2], [x9]
; CHECK-GI-NEXT:    ret
entry:
  %d = load <3 x i16>, ptr %p1
  %e = load <3 x i16>, ptr %p2
  %s = and <3 x i16> %d, %e
  store <3 x i16> %s, ptr %p1
  ret void
}

define void @or_v3i16(ptr %p1, ptr %p2) {
; CHECK-SD-LABEL: or_v3i16:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    ldr x8, [x0]
; CHECK-SD-NEXT:    ldr x9, [x1]
; CHECK-SD-NEXT:    orr x8, x8, x9
; CHECK-SD-NEXT:    fmov d0, x8
; CHECK-SD-NEXT:    str w8, [x0]
; CHECK-SD-NEXT:    mov h0, v0.h[2]
; CHECK-SD-NEXT:    str h0, [x0, #4]
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: or_v3i16:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    ldr d0, [x0]
; CHECK-GI-NEXT:    ldr d1, [x1]
; CHECK-GI-NEXT:    add x8, x0, #2
; CHECK-GI-NEXT:    add x9, x0, #4
; CHECK-GI-NEXT:    orr v0.8b, v0.8b, v1.8b
; CHECK-GI-NEXT:    str h0, [x0]
; CHECK-GI-NEXT:    st1 { v0.h }[1], [x8]
; CHECK-GI-NEXT:    st1 { v0.h }[2], [x9]
; CHECK-GI-NEXT:    ret
entry:
  %d = load <3 x i16>, ptr %p1
  %e = load <3 x i16>, ptr %p2
  %s = or <3 x i16> %d, %e
  store <3 x i16> %s, ptr %p1
  ret void
}

define void @xor_v3i16(ptr %p1, ptr %p2) {
; CHECK-SD-LABEL: xor_v3i16:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    ldr x8, [x0]
; CHECK-SD-NEXT:    ldr x9, [x1]
; CHECK-SD-NEXT:    eor x8, x8, x9
; CHECK-SD-NEXT:    fmov d0, x8
; CHECK-SD-NEXT:    str w8, [x0]
; CHECK-SD-NEXT:    mov h0, v0.h[2]
; CHECK-SD-NEXT:    str h0, [x0, #4]
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: xor_v3i16:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    ldr d0, [x0]
; CHECK-GI-NEXT:    ldr d1, [x1]
; CHECK-GI-NEXT:    add x8, x0, #2
; CHECK-GI-NEXT:    add x9, x0, #4
; CHECK-GI-NEXT:    eor v0.8b, v0.8b, v1.8b
; CHECK-GI-NEXT:    str h0, [x0]
; CHECK-GI-NEXT:    st1 { v0.h }[1], [x8]
; CHECK-GI-NEXT:    st1 { v0.h }[2], [x9]
; CHECK-GI-NEXT:    ret
entry:
  %d = load <3 x i16>, ptr %p1
  %e = load <3 x i16>, ptr %p2
  %s = xor <3 x i16> %d, %e
  store <3 x i16> %s, ptr %p1
  ret void
}

define <4 x i16> @and_v4i16(<4 x i16> %d, <4 x i16> %e) {
; CHECK-LABEL: and_v4i16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    and v0.8b, v0.8b, v1.8b
; CHECK-NEXT:    ret
entry:
  %s = and <4 x i16> %d, %e
  ret <4 x i16> %s
}

define <4 x i16> @or_v4i16(<4 x i16> %d, <4 x i16> %e) {
; CHECK-LABEL: or_v4i16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    orr v0.8b, v0.8b, v1.8b
; CHECK-NEXT:    ret
entry:
  %s = or <4 x i16> %d, %e
  ret <4 x i16> %s
}

define <4 x i16> @xor_v4i16(<4 x i16> %d, <4 x i16> %e) {
; CHECK-LABEL: xor_v4i16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    eor v0.8b, v0.8b, v1.8b
; CHECK-NEXT:    ret
entry:
  %s = xor <4 x i16> %d, %e
  ret <4 x i16> %s
}

define <8 x i16> @and_v8i16(<8 x i16> %d, <8 x i16> %e) {
; CHECK-LABEL: and_v8i16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ret
entry:
  %s = and <8 x i16> %d, %e
  ret <8 x i16> %s
}

define <8 x i16> @or_v8i16(<8 x i16> %d, <8 x i16> %e) {
; CHECK-LABEL: or_v8i16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    orr v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ret
entry:
  %s = or <8 x i16> %d, %e
  ret <8 x i16> %s
}

define <8 x i16> @xor_v8i16(<8 x i16> %d, <8 x i16> %e) {
; CHECK-LABEL: xor_v8i16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    eor v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ret
entry:
  %s = xor <8 x i16> %d, %e
  ret <8 x i16> %s
}

define <16 x i16> @and_v16i16(<16 x i16> %d, <16 x i16> %e) {
; CHECK-SD-LABEL: and_v16i16:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    and v1.16b, v1.16b, v3.16b
; CHECK-SD-NEXT:    and v0.16b, v0.16b, v2.16b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: and_v16i16:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    and v0.16b, v0.16b, v2.16b
; CHECK-GI-NEXT:    and v1.16b, v1.16b, v3.16b
; CHECK-GI-NEXT:    ret
entry:
  %s = and <16 x i16> %d, %e
  ret <16 x i16> %s
}

define <16 x i16> @or_v16i16(<16 x i16> %d, <16 x i16> %e) {
; CHECK-SD-LABEL: or_v16i16:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    orr v1.16b, v1.16b, v3.16b
; CHECK-SD-NEXT:    orr v0.16b, v0.16b, v2.16b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: or_v16i16:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    orr v0.16b, v0.16b, v2.16b
; CHECK-GI-NEXT:    orr v1.16b, v1.16b, v3.16b
; CHECK-GI-NEXT:    ret
entry:
  %s = or <16 x i16> %d, %e
  ret <16 x i16> %s
}

define <16 x i16> @xor_v16i16(<16 x i16> %d, <16 x i16> %e) {
; CHECK-SD-LABEL: xor_v16i16:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    eor v1.16b, v1.16b, v3.16b
; CHECK-SD-NEXT:    eor v0.16b, v0.16b, v2.16b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: xor_v16i16:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    eor v0.16b, v0.16b, v2.16b
; CHECK-GI-NEXT:    eor v1.16b, v1.16b, v3.16b
; CHECK-GI-NEXT:    ret
entry:
  %s = xor <16 x i16> %d, %e
  ret <16 x i16> %s
}

define <2 x i32> @and_v2i32(<2 x i32> %d, <2 x i32> %e) {
; CHECK-LABEL: and_v2i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    and v0.8b, v0.8b, v1.8b
; CHECK-NEXT:    ret
entry:
  %s = and <2 x i32> %d, %e
  ret <2 x i32> %s
}

define <2 x i32> @or_v2i32(<2 x i32> %d, <2 x i32> %e) {
; CHECK-LABEL: or_v2i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    orr v0.8b, v0.8b, v1.8b
; CHECK-NEXT:    ret
entry:
  %s = or <2 x i32> %d, %e
  ret <2 x i32> %s
}

define <2 x i32> @xor_v2i32(<2 x i32> %d, <2 x i32> %e) {
; CHECK-LABEL: xor_v2i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    eor v0.8b, v0.8b, v1.8b
; CHECK-NEXT:    ret
entry:
  %s = xor <2 x i32> %d, %e
  ret <2 x i32> %s
}

define <3 x i32> @and_v3i32(<3 x i32> %d, <3 x i32> %e) {
; CHECK-LABEL: and_v3i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ret
entry:
  %s = and <3 x i32> %d, %e
  ret <3 x i32> %s
}

define <3 x i32> @or_v3i32(<3 x i32> %d, <3 x i32> %e) {
; CHECK-LABEL: or_v3i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    orr v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ret
entry:
  %s = or <3 x i32> %d, %e
  ret <3 x i32> %s
}

define <3 x i32> @xor_v3i32(<3 x i32> %d, <3 x i32> %e) {
; CHECK-LABEL: xor_v3i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    eor v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ret
entry:
  %s = xor <3 x i32> %d, %e
  ret <3 x i32> %s
}

define <4 x i32> @and_v4i32(<4 x i32> %d, <4 x i32> %e) {
; CHECK-LABEL: and_v4i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ret
entry:
  %s = and <4 x i32> %d, %e
  ret <4 x i32> %s
}

define <4 x i32> @or_v4i32(<4 x i32> %d, <4 x i32> %e) {
; CHECK-LABEL: or_v4i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    orr v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ret
entry:
  %s = or <4 x i32> %d, %e
  ret <4 x i32> %s
}

define <4 x i32> @xor_v4i32(<4 x i32> %d, <4 x i32> %e) {
; CHECK-LABEL: xor_v4i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    eor v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ret
entry:
  %s = xor <4 x i32> %d, %e
  ret <4 x i32> %s
}

define <8 x i32> @and_v8i32(<8 x i32> %d, <8 x i32> %e) {
; CHECK-SD-LABEL: and_v8i32:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    and v1.16b, v1.16b, v3.16b
; CHECK-SD-NEXT:    and v0.16b, v0.16b, v2.16b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: and_v8i32:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    and v0.16b, v0.16b, v2.16b
; CHECK-GI-NEXT:    and v1.16b, v1.16b, v3.16b
; CHECK-GI-NEXT:    ret
entry:
  %s = and <8 x i32> %d, %e
  ret <8 x i32> %s
}

define <8 x i32> @or_v8i32(<8 x i32> %d, <8 x i32> %e) {
; CHECK-SD-LABEL: or_v8i32:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    orr v1.16b, v1.16b, v3.16b
; CHECK-SD-NEXT:    orr v0.16b, v0.16b, v2.16b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: or_v8i32:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    orr v0.16b, v0.16b, v2.16b
; CHECK-GI-NEXT:    orr v1.16b, v1.16b, v3.16b
; CHECK-GI-NEXT:    ret
entry:
  %s = or <8 x i32> %d, %e
  ret <8 x i32> %s
}

define <8 x i32> @xor_v8i32(<8 x i32> %d, <8 x i32> %e) {
; CHECK-SD-LABEL: xor_v8i32:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    eor v1.16b, v1.16b, v3.16b
; CHECK-SD-NEXT:    eor v0.16b, v0.16b, v2.16b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: xor_v8i32:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    eor v0.16b, v0.16b, v2.16b
; CHECK-GI-NEXT:    eor v1.16b, v1.16b, v3.16b
; CHECK-GI-NEXT:    ret
entry:
  %s = xor <8 x i32> %d, %e
  ret <8 x i32> %s
}

define <2 x i64> @and_v2i64(<2 x i64> %d, <2 x i64> %e) {
; CHECK-LABEL: and_v2i64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ret
entry:
  %s = and <2 x i64> %d, %e
  ret <2 x i64> %s
}

define <2 x i64> @or_v2i64(<2 x i64> %d, <2 x i64> %e) {
; CHECK-LABEL: or_v2i64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    orr v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ret
entry:
  %s = or <2 x i64> %d, %e
  ret <2 x i64> %s
}

define <2 x i64> @xor_v2i64(<2 x i64> %d, <2 x i64> %e) {
; CHECK-LABEL: xor_v2i64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    eor v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ret
entry:
  %s = xor <2 x i64> %d, %e
  ret <2 x i64> %s
}

define <3 x i64> @and_v3i64(<3 x i64> %d, <3 x i64> %e) {
; CHECK-SD-LABEL: and_v3i64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    and v0.8b, v0.8b, v3.8b
; CHECK-SD-NEXT:    and v1.8b, v1.8b, v4.8b
; CHECK-SD-NEXT:    and v2.8b, v2.8b, v5.8b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: and_v3i64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-NEXT:    // kill: def $d3 killed $d3 def $q3
; CHECK-GI-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-GI-NEXT:    // kill: def $d4 killed $d4 def $q4
; CHECK-GI-NEXT:    fmov x8, d2
; CHECK-GI-NEXT:    fmov x9, d5
; CHECK-GI-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-GI-NEXT:    mov v3.d[1], v4.d[0]
; CHECK-GI-NEXT:    and x8, x8, x9
; CHECK-GI-NEXT:    fmov d2, x8
; CHECK-GI-NEXT:    and v0.16b, v0.16b, v3.16b
; CHECK-GI-NEXT:    mov d1, v0.d[1]
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-GI-NEXT:    ret
entry:
  %s = and <3 x i64> %d, %e
  ret <3 x i64> %s
}

define <3 x i64> @or_v3i64(<3 x i64> %d, <3 x i64> %e) {
; CHECK-SD-LABEL: or_v3i64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    orr v0.8b, v0.8b, v3.8b
; CHECK-SD-NEXT:    orr v1.8b, v1.8b, v4.8b
; CHECK-SD-NEXT:    orr v2.8b, v2.8b, v5.8b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: or_v3i64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-NEXT:    // kill: def $d3 killed $d3 def $q3
; CHECK-GI-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-GI-NEXT:    // kill: def $d4 killed $d4 def $q4
; CHECK-GI-NEXT:    fmov x8, d2
; CHECK-GI-NEXT:    fmov x9, d5
; CHECK-GI-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-GI-NEXT:    mov v3.d[1], v4.d[0]
; CHECK-GI-NEXT:    orr x8, x8, x9
; CHECK-GI-NEXT:    fmov d2, x8
; CHECK-GI-NEXT:    orr v0.16b, v0.16b, v3.16b
; CHECK-GI-NEXT:    mov d1, v0.d[1]
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-GI-NEXT:    ret
entry:
  %s = or <3 x i64> %d, %e
  ret <3 x i64> %s
}

define <3 x i64> @xor_v3i64(<3 x i64> %d, <3 x i64> %e) {
; CHECK-SD-LABEL: xor_v3i64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    eor v0.8b, v0.8b, v3.8b
; CHECK-SD-NEXT:    eor v1.8b, v1.8b, v4.8b
; CHECK-SD-NEXT:    eor v2.8b, v2.8b, v5.8b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: xor_v3i64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-NEXT:    // kill: def $d3 killed $d3 def $q3
; CHECK-GI-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-GI-NEXT:    // kill: def $d4 killed $d4 def $q4
; CHECK-GI-NEXT:    fmov x8, d2
; CHECK-GI-NEXT:    fmov x9, d5
; CHECK-GI-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-GI-NEXT:    mov v3.d[1], v4.d[0]
; CHECK-GI-NEXT:    eor x8, x8, x9
; CHECK-GI-NEXT:    fmov d2, x8
; CHECK-GI-NEXT:    eor v0.16b, v0.16b, v3.16b
; CHECK-GI-NEXT:    mov d1, v0.d[1]
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-GI-NEXT:    ret
entry:
  %s = xor <3 x i64> %d, %e
  ret <3 x i64> %s
}

define <4 x i64> @and_v4i64(<4 x i64> %d, <4 x i64> %e) {
; CHECK-SD-LABEL: and_v4i64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    and v1.16b, v1.16b, v3.16b
; CHECK-SD-NEXT:    and v0.16b, v0.16b, v2.16b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: and_v4i64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    and v0.16b, v0.16b, v2.16b
; CHECK-GI-NEXT:    and v1.16b, v1.16b, v3.16b
; CHECK-GI-NEXT:    ret
entry:
  %s = and <4 x i64> %d, %e
  ret <4 x i64> %s
}

define <4 x i64> @or_v4i64(<4 x i64> %d, <4 x i64> %e) {
; CHECK-SD-LABEL: or_v4i64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    orr v1.16b, v1.16b, v3.16b
; CHECK-SD-NEXT:    orr v0.16b, v0.16b, v2.16b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: or_v4i64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    orr v0.16b, v0.16b, v2.16b
; CHECK-GI-NEXT:    orr v1.16b, v1.16b, v3.16b
; CHECK-GI-NEXT:    ret
entry:
  %s = or <4 x i64> %d, %e
  ret <4 x i64> %s
}

define <4 x i64> @xor_v4i64(<4 x i64> %d, <4 x i64> %e) {
; CHECK-SD-LABEL: xor_v4i64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    eor v1.16b, v1.16b, v3.16b
; CHECK-SD-NEXT:    eor v0.16b, v0.16b, v2.16b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: xor_v4i64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    eor v0.16b, v0.16b, v2.16b
; CHECK-GI-NEXT:    eor v1.16b, v1.16b, v3.16b
; CHECK-GI-NEXT:    ret
entry:
  %s = xor <4 x i64> %d, %e
  ret <4 x i64> %s
}

define <2 x i128> @and_v2i128(<2 x i128> %d, <2 x i128> %e) {
; CHECK-SD-LABEL: and_v2i128:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    and x2, x2, x6
; CHECK-SD-NEXT:    and x0, x0, x4
; CHECK-SD-NEXT:    and x1, x1, x5
; CHECK-SD-NEXT:    and x3, x3, x7
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: and_v2i128:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    and x0, x0, x4
; CHECK-GI-NEXT:    and x1, x1, x5
; CHECK-GI-NEXT:    and x2, x2, x6
; CHECK-GI-NEXT:    and x3, x3, x7
; CHECK-GI-NEXT:    ret
entry:
  %s = and <2 x i128> %d, %e
  ret <2 x i128> %s
}

define <2 x i128> @or_v2i128(<2 x i128> %d, <2 x i128> %e) {
; CHECK-SD-LABEL: or_v2i128:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    orr x2, x2, x6
; CHECK-SD-NEXT:    orr x0, x0, x4
; CHECK-SD-NEXT:    orr x1, x1, x5
; CHECK-SD-NEXT:    orr x3, x3, x7
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: or_v2i128:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    orr x0, x0, x4
; CHECK-GI-NEXT:    orr x1, x1, x5
; CHECK-GI-NEXT:    orr x2, x2, x6
; CHECK-GI-NEXT:    orr x3, x3, x7
; CHECK-GI-NEXT:    ret
entry:
  %s = or <2 x i128> %d, %e
  ret <2 x i128> %s
}

define <2 x i128> @xor_v2i128(<2 x i128> %d, <2 x i128> %e) {
; CHECK-SD-LABEL: xor_v2i128:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    eor x2, x2, x6
; CHECK-SD-NEXT:    eor x0, x0, x4
; CHECK-SD-NEXT:    eor x1, x1, x5
; CHECK-SD-NEXT:    eor x3, x3, x7
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: xor_v2i128:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    eor x0, x0, x4
; CHECK-GI-NEXT:    eor x1, x1, x5
; CHECK-GI-NEXT:    eor x2, x2, x6
; CHECK-GI-NEXT:    eor x3, x3, x7
; CHECK-GI-NEXT:    ret
entry:
  %s = xor <2 x i128> %d, %e
  ret <2 x i128> %s
}

define <3 x i128> @and_v3i128(<3 x i128> %d, <3 x i128> %e) {
; CHECK-SD-LABEL: and_v3i128:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    ldp x8, x9, [sp]
; CHECK-SD-NEXT:    and x0, x0, x6
; CHECK-SD-NEXT:    ldp x11, x10, [sp, #16]
; CHECK-SD-NEXT:    and x1, x1, x7
; CHECK-SD-NEXT:    and x2, x2, x8
; CHECK-SD-NEXT:    and x3, x3, x9
; CHECK-SD-NEXT:    and x4, x4, x11
; CHECK-SD-NEXT:    and x5, x5, x10
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: and_v3i128:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    ldp x8, x9, [sp]
; CHECK-GI-NEXT:    and x0, x0, x6
; CHECK-GI-NEXT:    ldp x10, x11, [sp, #16]
; CHECK-GI-NEXT:    and x1, x1, x7
; CHECK-GI-NEXT:    and x2, x2, x8
; CHECK-GI-NEXT:    and x3, x3, x9
; CHECK-GI-NEXT:    and x4, x4, x10
; CHECK-GI-NEXT:    and x5, x5, x11
; CHECK-GI-NEXT:    ret
entry:
  %s = and <3 x i128> %d, %e
  ret <3 x i128> %s
}

define <3 x i128> @or_v3i128(<3 x i128> %d, <3 x i128> %e) {
; CHECK-SD-LABEL: or_v3i128:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    ldp x8, x9, [sp]
; CHECK-SD-NEXT:    orr x0, x0, x6
; CHECK-SD-NEXT:    ldp x11, x10, [sp, #16]
; CHECK-SD-NEXT:    orr x1, x1, x7
; CHECK-SD-NEXT:    orr x2, x2, x8
; CHECK-SD-NEXT:    orr x3, x3, x9
; CHECK-SD-NEXT:    orr x4, x4, x11
; CHECK-SD-NEXT:    orr x5, x5, x10
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: or_v3i128:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    ldp x8, x9, [sp]
; CHECK-GI-NEXT:    orr x0, x0, x6
; CHECK-GI-NEXT:    ldp x10, x11, [sp, #16]
; CHECK-GI-NEXT:    orr x1, x1, x7
; CHECK-GI-NEXT:    orr x2, x2, x8
; CHECK-GI-NEXT:    orr x3, x3, x9
; CHECK-GI-NEXT:    orr x4, x4, x10
; CHECK-GI-NEXT:    orr x5, x5, x11
; CHECK-GI-NEXT:    ret
entry:
  %s = or <3 x i128> %d, %e
  ret <3 x i128> %s
}

define <3 x i128> @xor_v3i128(<3 x i128> %d, <3 x i128> %e) {
; CHECK-SD-LABEL: xor_v3i128:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    ldp x8, x9, [sp]
; CHECK-SD-NEXT:    eor x0, x0, x6
; CHECK-SD-NEXT:    ldp x11, x10, [sp, #16]
; CHECK-SD-NEXT:    eor x1, x1, x7
; CHECK-SD-NEXT:    eor x2, x2, x8
; CHECK-SD-NEXT:    eor x3, x3, x9
; CHECK-SD-NEXT:    eor x4, x4, x11
; CHECK-SD-NEXT:    eor x5, x5, x10
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: xor_v3i128:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    ldp x8, x9, [sp]
; CHECK-GI-NEXT:    eor x0, x0, x6
; CHECK-GI-NEXT:    ldp x10, x11, [sp, #16]
; CHECK-GI-NEXT:    eor x1, x1, x7
; CHECK-GI-NEXT:    eor x2, x2, x8
; CHECK-GI-NEXT:    eor x3, x3, x9
; CHECK-GI-NEXT:    eor x4, x4, x10
; CHECK-GI-NEXT:    eor x5, x5, x11
; CHECK-GI-NEXT:    ret
entry:
  %s = xor <3 x i128> %d, %e
  ret <3 x i128> %s
}

define <4 x i128> @and_v4i128(<4 x i128> %d, <4 x i128> %e) {
; CHECK-SD-LABEL: and_v4i128:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    ldp x9, x8, [sp, #32]
; CHECK-SD-NEXT:    ldp x11, x10, [sp]
; CHECK-SD-NEXT:    ldp x13, x12, [sp, #16]
; CHECK-SD-NEXT:    ldp x15, x14, [sp, #48]
; CHECK-SD-NEXT:    and x4, x4, x9
; CHECK-SD-NEXT:    and x0, x0, x11
; CHECK-SD-NEXT:    and x1, x1, x10
; CHECK-SD-NEXT:    and x5, x5, x8
; CHECK-SD-NEXT:    and x2, x2, x13
; CHECK-SD-NEXT:    and x3, x3, x12
; CHECK-SD-NEXT:    and x6, x6, x15
; CHECK-SD-NEXT:    and x7, x7, x14
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: and_v4i128:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    ldp x8, x9, [sp]
; CHECK-GI-NEXT:    ldp x10, x11, [sp, #16]
; CHECK-GI-NEXT:    ldp x12, x13, [sp, #32]
; CHECK-GI-NEXT:    ldp x14, x15, [sp, #48]
; CHECK-GI-NEXT:    and x0, x0, x8
; CHECK-GI-NEXT:    and x1, x1, x9
; CHECK-GI-NEXT:    and x2, x2, x10
; CHECK-GI-NEXT:    and x3, x3, x11
; CHECK-GI-NEXT:    and x4, x4, x12
; CHECK-GI-NEXT:    and x5, x5, x13
; CHECK-GI-NEXT:    and x6, x6, x14
; CHECK-GI-NEXT:    and x7, x7, x15
; CHECK-GI-NEXT:    ret
entry:
  %s = and <4 x i128> %d, %e
  ret <4 x i128> %s
}

define <4 x i128> @or_v4i128(<4 x i128> %d, <4 x i128> %e) {
; CHECK-SD-LABEL: or_v4i128:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    ldp x9, x8, [sp, #32]
; CHECK-SD-NEXT:    ldp x11, x10, [sp]
; CHECK-SD-NEXT:    ldp x13, x12, [sp, #16]
; CHECK-SD-NEXT:    ldp x15, x14, [sp, #48]
; CHECK-SD-NEXT:    orr x4, x4, x9
; CHECK-SD-NEXT:    orr x0, x0, x11
; CHECK-SD-NEXT:    orr x1, x1, x10
; CHECK-SD-NEXT:    orr x5, x5, x8
; CHECK-SD-NEXT:    orr x2, x2, x13
; CHECK-SD-NEXT:    orr x3, x3, x12
; CHECK-SD-NEXT:    orr x6, x6, x15
; CHECK-SD-NEXT:    orr x7, x7, x14
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: or_v4i128:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    ldp x8, x9, [sp]
; CHECK-GI-NEXT:    ldp x10, x11, [sp, #16]
; CHECK-GI-NEXT:    ldp x12, x13, [sp, #32]
; CHECK-GI-NEXT:    ldp x14, x15, [sp, #48]
; CHECK-GI-NEXT:    orr x0, x0, x8
; CHECK-GI-NEXT:    orr x1, x1, x9
; CHECK-GI-NEXT:    orr x2, x2, x10
; CHECK-GI-NEXT:    orr x3, x3, x11
; CHECK-GI-NEXT:    orr x4, x4, x12
; CHECK-GI-NEXT:    orr x5, x5, x13
; CHECK-GI-NEXT:    orr x6, x6, x14
; CHECK-GI-NEXT:    orr x7, x7, x15
; CHECK-GI-NEXT:    ret
entry:
  %s = or <4 x i128> %d, %e
  ret <4 x i128> %s
}

define <4 x i128> @xor_v4i128(<4 x i128> %d, <4 x i128> %e) {
; CHECK-SD-LABEL: xor_v4i128:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    ldp x9, x8, [sp, #32]
; CHECK-SD-NEXT:    ldp x11, x10, [sp]
; CHECK-SD-NEXT:    ldp x13, x12, [sp, #16]
; CHECK-SD-NEXT:    ldp x15, x14, [sp, #48]
; CHECK-SD-NEXT:    eor x4, x4, x9
; CHECK-SD-NEXT:    eor x0, x0, x11
; CHECK-SD-NEXT:    eor x1, x1, x10
; CHECK-SD-NEXT:    eor x5, x5, x8
; CHECK-SD-NEXT:    eor x2, x2, x13
; CHECK-SD-NEXT:    eor x3, x3, x12
; CHECK-SD-NEXT:    eor x6, x6, x15
; CHECK-SD-NEXT:    eor x7, x7, x14
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: xor_v4i128:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    ldp x8, x9, [sp]
; CHECK-GI-NEXT:    ldp x10, x11, [sp, #16]
; CHECK-GI-NEXT:    ldp x12, x13, [sp, #32]
; CHECK-GI-NEXT:    ldp x14, x15, [sp, #48]
; CHECK-GI-NEXT:    eor x0, x0, x8
; CHECK-GI-NEXT:    eor x1, x1, x9
; CHECK-GI-NEXT:    eor x2, x2, x10
; CHECK-GI-NEXT:    eor x3, x3, x11
; CHECK-GI-NEXT:    eor x4, x4, x12
; CHECK-GI-NEXT:    eor x5, x5, x13
; CHECK-GI-NEXT:    eor x6, x6, x14
; CHECK-GI-NEXT:    eor x7, x7, x15
; CHECK-GI-NEXT:    ret
entry:
  %s = xor <4 x i128> %d, %e
  ret <4 x i128> %s
}
