; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mcpu=btver2 %s -o - | FileCheck %s
; Test desc: two functions (foo, bar) with byval arguments, should not have
; reads/writes from/to byval storage re-ordered.
; When broken, five "1" constants are written into the byval %struct.face,
; but the subsequent byval read of that struct (call to bar) gets re-ordered
; before those writes, illegally.
source_filename = "test.c"
target datalayout = "e-m:e-i64:64-f80:128-n8:16:32:64-S128"
target triple = "x86_64-pc-linux-gnu"

%struct.face = type { [7 x i32] }

; Function Attrs: noinline nounwind uwtable
declare void @bar(ptr byval(%struct.face) nocapture readonly align 8);

; Function Attrs: noinline nounwind uwtable
define void @foo(ptr byval(%struct.face) nocapture align 8) local_unnamed_addr {
; CHECK-LABEL: foo:
; CHECK:       # %bb.0:
; CHECK-NEXT:    subq $40, %rsp
; CHECK-NEXT:    .cfi_def_cfa_offset 48
; CHECK-NEXT:    vmovaps {{.*#+}} xmm0 = [1,1,1,1]
; CHECK-NEXT:    vmovaps %xmm0, {{[0-9]+}}(%rsp)
; CHECK-NEXT:    movl $1, {{[0-9]+}}(%rsp)
; CHECK-NEXT:    vmovups {{[0-9]+}}(%rsp), %xmm0
; CHECK-NEXT:    vmovups %xmm0, {{[0-9]+}}(%rsp)
; CHECK-NEXT:    vmovaps {{[0-9]+}}(%rsp), %xmm0
; CHECK-NEXT:    vmovups %xmm0, (%rsp)
; CHECK-NEXT:    callq bar@PLT
; CHECK-NEXT:    addq $40, %rsp
; CHECK-NEXT:    .cfi_def_cfa_offset 8
; CHECK-NEXT:    retq
  store <4 x i32> <i32 1, i32 1, i32 1, i32 1>, ptr %0, align 8
  %2 = getelementptr inbounds %struct.face, ptr %0, i64 0, i32 0, i64 4
  store i32 1, ptr %2, align 8
  call void @bar(ptr byval(%struct.face) nonnull align 8 %0)
  ret void
}
