; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -O2 -mtriple=x86_64-linux-android \
; RUN:     -enable-legalize-types-checking \
; RUN:     | FileCheck %s --check-prefix=ANDROID
; RUN: llc < %s -O2 -mtriple=x86_64-linux-gnu \
; RUN:     -enable-legalize-types-checking \
; RUN:     | FileCheck %s --check-prefix=GNU
; RUN: llc < %s -O2 -mtriple=i686-linux-gnu -mattr=+sse2 \
; RUN:     -enable-legalize-types-checking \
; RUN:     | FileCheck %s --check-prefix=X86
; RUN: llc < %s -O2 -mtriple=x86_64-pc-windows-msvc \
; RUN:     -enable-legalize-types-checking \
; RUN:     | FileCheck %s --check-prefix=WIN
; RUN: llc < %s -O2 -mtriple=i686-pc-windows-msvc \
; RUN:     -enable-legalize-types-checking \
; RUN:     | FileCheck %s --check-prefix=WIN-X86

; Check all soft floating point library function calls.

define fp128 @add(fp128 %x, fp128 %y) nounwind strictfp {
; CHECK-LABEL: add:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    pushq %rax
; CHECK-NEXT:    callq __addtf3@PLT
; CHECK-NEXT:    popq %rax
; CHECK-NEXT:    retq
;
; ANDROID-LABEL: add:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq __addtf3@PLT
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: add:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq __addtf3@PLT
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: add:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %ebp
; X86-NEXT:    pushl %ebx
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $76, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ebp, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ebx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, (%esp)
; X86-NEXT:    calll __addtf3
; X86-NEXT:    subl $4, %esp
; X86-NEXT:    movaps {{[0-9]+}}(%esp), %xmm0
; X86-NEXT:    movaps %xmm0, (%esi)
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    addl $76, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    popl %ebx
; X86-NEXT:    popl %ebp
; X86-NEXT:    retl $4
;
; WIN-LABEL: add:
; WIN:       # %bb.0: # %entry
; WIN-NEXT:    subq $72, %rsp
; WIN-NEXT:    movaps (%rcx), %xmm0
; WIN-NEXT:    movaps (%rdx), %xmm1
; WIN-NEXT:    movaps %xmm1, {{[0-9]+}}(%rsp)
; WIN-NEXT:    movaps %xmm0, {{[0-9]+}}(%rsp)
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rdx
; WIN-NEXT:    callq __addtf3
; WIN-NEXT:    addq $72, %rsp
; WIN-NEXT:    retq
;
; WIN-X86-LABEL: add:
; WIN-X86:       # %bb.0: # %entry
; WIN-X86-NEXT:    pushl %ebp
; WIN-X86-NEXT:    movl %esp, %ebp
; WIN-X86-NEXT:    pushl %ebx
; WIN-X86-NEXT:    pushl %edi
; WIN-X86-NEXT:    pushl %esi
; WIN-X86-NEXT:    andl $-16, %esp
; WIN-X86-NEXT:    subl $80, %esp
; WIN-X86-NEXT:    movl 8(%ebp), %esi
; WIN-X86-NEXT:    movl 36(%ebp), %edi
; WIN-X86-NEXT:    movl 40(%ebp), %ebx
; WIN-X86-NEXT:    movl 44(%ebp), %edx
; WIN-X86-NEXT:    movl 48(%ebp), %ecx
; WIN-X86-NEXT:    movl 52(%ebp), %eax
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %ebx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl 32(%ebp), %eax
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl 28(%ebp), %eax
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl 24(%ebp), %eax
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl %eax, (%esp)
; WIN-X86-NEXT:    calll ___addtf3
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; WIN-X86-NEXT:    movl %edi, 8(%esi)
; WIN-X86-NEXT:    movl %edx, 12(%esi)
; WIN-X86-NEXT:    movl %eax, (%esi)
; WIN-X86-NEXT:    movl %ecx, 4(%esi)
; WIN-X86-NEXT:    movl %esi, %eax
; WIN-X86-NEXT:    leal -12(%ebp), %esp
; WIN-X86-NEXT:    popl %esi
; WIN-X86-NEXT:    popl %edi
; WIN-X86-NEXT:    popl %ebx
; WIN-X86-NEXT:    popl %ebp
; WIN-X86-NEXT:    retl
entry:
  %add = call fp128 @llvm.experimental.constrained.fadd.f128(fp128 %x, fp128 %y,  metadata !"round.dynamic", metadata !"fpexcept.strict") #0
  ret fp128 %add
}

define fp128 @sub(fp128 %x, fp128 %y) nounwind strictfp {
; CHECK-LABEL: sub:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    pushq %rax
; CHECK-NEXT:    callq __subtf3@PLT
; CHECK-NEXT:    popq %rax
; CHECK-NEXT:    retq
;
; ANDROID-LABEL: sub:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq __subtf3@PLT
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: sub:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq __subtf3@PLT
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: sub:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %ebp
; X86-NEXT:    pushl %ebx
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $76, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ebp, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ebx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, (%esp)
; X86-NEXT:    calll __subtf3
; X86-NEXT:    subl $4, %esp
; X86-NEXT:    movaps {{[0-9]+}}(%esp), %xmm0
; X86-NEXT:    movaps %xmm0, (%esi)
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    addl $76, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    popl %ebx
; X86-NEXT:    popl %ebp
; X86-NEXT:    retl $4
;
; WIN-LABEL: sub:
; WIN:       # %bb.0: # %entry
; WIN-NEXT:    subq $72, %rsp
; WIN-NEXT:    movaps (%rcx), %xmm0
; WIN-NEXT:    movaps (%rdx), %xmm1
; WIN-NEXT:    movaps %xmm1, {{[0-9]+}}(%rsp)
; WIN-NEXT:    movaps %xmm0, {{[0-9]+}}(%rsp)
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rdx
; WIN-NEXT:    callq __subtf3
; WIN-NEXT:    addq $72, %rsp
; WIN-NEXT:    retq
;
; WIN-X86-LABEL: sub:
; WIN-X86:       # %bb.0: # %entry
; WIN-X86-NEXT:    pushl %ebp
; WIN-X86-NEXT:    movl %esp, %ebp
; WIN-X86-NEXT:    pushl %ebx
; WIN-X86-NEXT:    pushl %edi
; WIN-X86-NEXT:    pushl %esi
; WIN-X86-NEXT:    andl $-16, %esp
; WIN-X86-NEXT:    subl $80, %esp
; WIN-X86-NEXT:    movl 8(%ebp), %esi
; WIN-X86-NEXT:    movl 36(%ebp), %edi
; WIN-X86-NEXT:    movl 40(%ebp), %ebx
; WIN-X86-NEXT:    movl 44(%ebp), %edx
; WIN-X86-NEXT:    movl 48(%ebp), %ecx
; WIN-X86-NEXT:    movl 52(%ebp), %eax
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %ebx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl 32(%ebp), %eax
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl 28(%ebp), %eax
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl 24(%ebp), %eax
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl %eax, (%esp)
; WIN-X86-NEXT:    calll ___subtf3
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; WIN-X86-NEXT:    movl %edi, 8(%esi)
; WIN-X86-NEXT:    movl %edx, 12(%esi)
; WIN-X86-NEXT:    movl %eax, (%esi)
; WIN-X86-NEXT:    movl %ecx, 4(%esi)
; WIN-X86-NEXT:    movl %esi, %eax
; WIN-X86-NEXT:    leal -12(%ebp), %esp
; WIN-X86-NEXT:    popl %esi
; WIN-X86-NEXT:    popl %edi
; WIN-X86-NEXT:    popl %ebx
; WIN-X86-NEXT:    popl %ebp
; WIN-X86-NEXT:    retl
entry:
  %sub = call fp128 @llvm.experimental.constrained.fsub.f128(fp128 %x, fp128 %y,  metadata !"round.dynamic", metadata !"fpexcept.strict") #0
  ret fp128 %sub
}

define fp128 @mul(fp128 %x, fp128 %y) nounwind strictfp {
; CHECK-LABEL: mul:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    pushq %rax
; CHECK-NEXT:    callq __multf3@PLT
; CHECK-NEXT:    popq %rax
; CHECK-NEXT:    retq
;
; ANDROID-LABEL: mul:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq __multf3@PLT
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: mul:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq __multf3@PLT
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: mul:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %ebp
; X86-NEXT:    pushl %ebx
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $76, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ebp, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ebx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, (%esp)
; X86-NEXT:    calll __multf3
; X86-NEXT:    subl $4, %esp
; X86-NEXT:    movaps {{[0-9]+}}(%esp), %xmm0
; X86-NEXT:    movaps %xmm0, (%esi)
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    addl $76, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    popl %ebx
; X86-NEXT:    popl %ebp
; X86-NEXT:    retl $4
;
; WIN-LABEL: mul:
; WIN:       # %bb.0: # %entry
; WIN-NEXT:    subq $72, %rsp
; WIN-NEXT:    movaps (%rcx), %xmm0
; WIN-NEXT:    movaps (%rdx), %xmm1
; WIN-NEXT:    movaps %xmm1, {{[0-9]+}}(%rsp)
; WIN-NEXT:    movaps %xmm0, {{[0-9]+}}(%rsp)
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rdx
; WIN-NEXT:    callq __multf3
; WIN-NEXT:    addq $72, %rsp
; WIN-NEXT:    retq
;
; WIN-X86-LABEL: mul:
; WIN-X86:       # %bb.0: # %entry
; WIN-X86-NEXT:    pushl %ebp
; WIN-X86-NEXT:    movl %esp, %ebp
; WIN-X86-NEXT:    pushl %ebx
; WIN-X86-NEXT:    pushl %edi
; WIN-X86-NEXT:    pushl %esi
; WIN-X86-NEXT:    andl $-16, %esp
; WIN-X86-NEXT:    subl $80, %esp
; WIN-X86-NEXT:    movl 8(%ebp), %esi
; WIN-X86-NEXT:    movl 36(%ebp), %edi
; WIN-X86-NEXT:    movl 40(%ebp), %ebx
; WIN-X86-NEXT:    movl 44(%ebp), %edx
; WIN-X86-NEXT:    movl 48(%ebp), %ecx
; WIN-X86-NEXT:    movl 52(%ebp), %eax
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %ebx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl 32(%ebp), %eax
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl 28(%ebp), %eax
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl 24(%ebp), %eax
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl %eax, (%esp)
; WIN-X86-NEXT:    calll ___multf3
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; WIN-X86-NEXT:    movl %edi, 8(%esi)
; WIN-X86-NEXT:    movl %edx, 12(%esi)
; WIN-X86-NEXT:    movl %eax, (%esi)
; WIN-X86-NEXT:    movl %ecx, 4(%esi)
; WIN-X86-NEXT:    movl %esi, %eax
; WIN-X86-NEXT:    leal -12(%ebp), %esp
; WIN-X86-NEXT:    popl %esi
; WIN-X86-NEXT:    popl %edi
; WIN-X86-NEXT:    popl %ebx
; WIN-X86-NEXT:    popl %ebp
; WIN-X86-NEXT:    retl
entry:
  %mul = call fp128 @llvm.experimental.constrained.fmul.f128(fp128 %x, fp128 %y,  metadata !"round.dynamic", metadata !"fpexcept.strict") #0
  ret fp128 %mul
}

define fp128 @div(fp128 %x, fp128 %y) nounwind strictfp {
; CHECK-LABEL: div:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    pushq %rax
; CHECK-NEXT:    callq __divtf3@PLT
; CHECK-NEXT:    popq %rax
; CHECK-NEXT:    retq
;
; ANDROID-LABEL: div:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq __divtf3@PLT
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: div:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq __divtf3@PLT
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: div:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %ebp
; X86-NEXT:    pushl %ebx
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $76, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ebp, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ebx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, (%esp)
; X86-NEXT:    calll __divtf3
; X86-NEXT:    subl $4, %esp
; X86-NEXT:    movaps {{[0-9]+}}(%esp), %xmm0
; X86-NEXT:    movaps %xmm0, (%esi)
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    addl $76, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    popl %ebx
; X86-NEXT:    popl %ebp
; X86-NEXT:    retl $4
;
; WIN-LABEL: div:
; WIN:       # %bb.0: # %entry
; WIN-NEXT:    subq $72, %rsp
; WIN-NEXT:    movaps (%rcx), %xmm0
; WIN-NEXT:    movaps (%rdx), %xmm1
; WIN-NEXT:    movaps %xmm1, {{[0-9]+}}(%rsp)
; WIN-NEXT:    movaps %xmm0, {{[0-9]+}}(%rsp)
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rdx
; WIN-NEXT:    callq __divtf3
; WIN-NEXT:    addq $72, %rsp
; WIN-NEXT:    retq
;
; WIN-X86-LABEL: div:
; WIN-X86:       # %bb.0: # %entry
; WIN-X86-NEXT:    pushl %ebp
; WIN-X86-NEXT:    movl %esp, %ebp
; WIN-X86-NEXT:    pushl %ebx
; WIN-X86-NEXT:    pushl %edi
; WIN-X86-NEXT:    pushl %esi
; WIN-X86-NEXT:    andl $-16, %esp
; WIN-X86-NEXT:    subl $80, %esp
; WIN-X86-NEXT:    movl 8(%ebp), %esi
; WIN-X86-NEXT:    movl 36(%ebp), %edi
; WIN-X86-NEXT:    movl 40(%ebp), %ebx
; WIN-X86-NEXT:    movl 44(%ebp), %edx
; WIN-X86-NEXT:    movl 48(%ebp), %ecx
; WIN-X86-NEXT:    movl 52(%ebp), %eax
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %ebx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl 32(%ebp), %eax
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl 28(%ebp), %eax
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl 24(%ebp), %eax
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl %eax, (%esp)
; WIN-X86-NEXT:    calll ___divtf3
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; WIN-X86-NEXT:    movl %edi, 8(%esi)
; WIN-X86-NEXT:    movl %edx, 12(%esi)
; WIN-X86-NEXT:    movl %eax, (%esi)
; WIN-X86-NEXT:    movl %ecx, 4(%esi)
; WIN-X86-NEXT:    movl %esi, %eax
; WIN-X86-NEXT:    leal -12(%ebp), %esp
; WIN-X86-NEXT:    popl %esi
; WIN-X86-NEXT:    popl %edi
; WIN-X86-NEXT:    popl %ebx
; WIN-X86-NEXT:    popl %ebp
; WIN-X86-NEXT:    retl
entry:
  %div = call fp128 @llvm.experimental.constrained.fdiv.f128(fp128 %x, fp128 %y,  metadata !"round.dynamic", metadata !"fpexcept.strict") #0
  ret fp128 %div
}

define fp128 @fma(fp128 %x, fp128 %y, fp128 %z) nounwind strictfp {
; ANDROID-LABEL: fma:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq fmal@PLT
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: fma:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq fmaf128@PLT
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: fma:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %ebp
; X86-NEXT:    pushl %ebx
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $92, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %esi, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ebx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, (%esp)
; X86-NEXT:    calll fmaf128
; X86-NEXT:    subl $4, %esp
; X86-NEXT:    movaps {{[0-9]+}}(%esp), %xmm0
; X86-NEXT:    movaps %xmm0, (%ebp)
; X86-NEXT:    movl %ebp, %eax
; X86-NEXT:    addl $92, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    popl %ebx
; X86-NEXT:    popl %ebp
; X86-NEXT:    retl $4
;
; WIN-LABEL: fma:
; WIN:       # %bb.0: # %entry
; WIN-NEXT:    subq $88, %rsp
; WIN-NEXT:    movaps (%r8), %xmm0
; WIN-NEXT:    movaps (%rcx), %xmm1
; WIN-NEXT:    movaps (%rdx), %xmm2
; WIN-NEXT:    movaps %xmm2, {{[0-9]+}}(%rsp)
; WIN-NEXT:    movaps %xmm1, {{[0-9]+}}(%rsp)
; WIN-NEXT:    movaps %xmm0, {{[0-9]+}}(%rsp)
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rdx
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %r8
; WIN-NEXT:    callq fmal
; WIN-NEXT:    addq $88, %rsp
; WIN-NEXT:    retq
;
; WIN-X86-LABEL: fma:
; WIN-X86:       # %bb.0: # %entry
; WIN-X86-NEXT:    pushl %ebp
; WIN-X86-NEXT:    movl %esp, %ebp
; WIN-X86-NEXT:    pushl %ebx
; WIN-X86-NEXT:    pushl %edi
; WIN-X86-NEXT:    pushl %esi
; WIN-X86-NEXT:    andl $-16, %esp
; WIN-X86-NEXT:    subl $96, %esp
; WIN-X86-NEXT:    movl 8(%ebp), %esi
; WIN-X86-NEXT:    movl 52(%ebp), %ebx
; WIN-X86-NEXT:    movl 56(%ebp), %edi
; WIN-X86-NEXT:    movl 60(%ebp), %edx
; WIN-X86-NEXT:    movl 64(%ebp), %ecx
; WIN-X86-NEXT:    movl 68(%ebp), %eax
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %ebx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl 48(%ebp), %eax
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl 44(%ebp), %eax
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl 40(%ebp), %eax
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl 36(%ebp), %eax
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl 32(%ebp), %eax
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl 28(%ebp), %eax
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl 24(%ebp), %eax
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl %eax, (%esp)
; WIN-X86-NEXT:    calll _fmal
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; WIN-X86-NEXT:    movl %edi, 8(%esi)
; WIN-X86-NEXT:    movl %edx, 12(%esi)
; WIN-X86-NEXT:    movl %eax, (%esi)
; WIN-X86-NEXT:    movl %ecx, 4(%esi)
; WIN-X86-NEXT:    movl %esi, %eax
; WIN-X86-NEXT:    leal -12(%ebp), %esp
; WIN-X86-NEXT:    popl %esi
; WIN-X86-NEXT:    popl %edi
; WIN-X86-NEXT:    popl %ebx
; WIN-X86-NEXT:    popl %ebp
; WIN-X86-NEXT:    retl
entry:
  %fma = call fp128 @llvm.experimental.constrained.fma.f128(fp128 %x, fp128 %y,  fp128 %z, metadata !"round.dynamic", metadata !"fpexcept.strict") #0
  ret fp128 %fma
}

define fp128 @frem(fp128 %x, fp128 %y) nounwind strictfp {
; ANDROID-LABEL: frem:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq fmodl@PLT
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: frem:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq fmodf128@PLT
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: frem:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %ebp
; X86-NEXT:    pushl %ebx
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $76, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ebp, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ebx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, (%esp)
; X86-NEXT:    calll fmodf128
; X86-NEXT:    subl $4, %esp
; X86-NEXT:    movaps {{[0-9]+}}(%esp), %xmm0
; X86-NEXT:    movaps %xmm0, (%esi)
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    addl $76, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    popl %ebx
; X86-NEXT:    popl %ebp
; X86-NEXT:    retl $4
;
; WIN-LABEL: frem:
; WIN:       # %bb.0: # %entry
; WIN-NEXT:    subq $72, %rsp
; WIN-NEXT:    movaps (%rcx), %xmm0
; WIN-NEXT:    movaps (%rdx), %xmm1
; WIN-NEXT:    movaps %xmm1, {{[0-9]+}}(%rsp)
; WIN-NEXT:    movaps %xmm0, {{[0-9]+}}(%rsp)
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rdx
; WIN-NEXT:    callq fmodl
; WIN-NEXT:    addq $72, %rsp
; WIN-NEXT:    retq
;
; WIN-X86-LABEL: frem:
; WIN-X86:       # %bb.0: # %entry
; WIN-X86-NEXT:    pushl %ebp
; WIN-X86-NEXT:    movl %esp, %ebp
; WIN-X86-NEXT:    pushl %ebx
; WIN-X86-NEXT:    pushl %edi
; WIN-X86-NEXT:    pushl %esi
; WIN-X86-NEXT:    andl $-16, %esp
; WIN-X86-NEXT:    subl $80, %esp
; WIN-X86-NEXT:    movl 8(%ebp), %esi
; WIN-X86-NEXT:    movl 36(%ebp), %edi
; WIN-X86-NEXT:    movl 40(%ebp), %ebx
; WIN-X86-NEXT:    movl 44(%ebp), %edx
; WIN-X86-NEXT:    movl 48(%ebp), %ecx
; WIN-X86-NEXT:    movl 52(%ebp), %eax
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %ebx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl 32(%ebp), %eax
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl 28(%ebp), %eax
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl 24(%ebp), %eax
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl %eax, (%esp)
; WIN-X86-NEXT:    calll _fmodl
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; WIN-X86-NEXT:    movl %edi, 8(%esi)
; WIN-X86-NEXT:    movl %edx, 12(%esi)
; WIN-X86-NEXT:    movl %eax, (%esi)
; WIN-X86-NEXT:    movl %ecx, 4(%esi)
; WIN-X86-NEXT:    movl %esi, %eax
; WIN-X86-NEXT:    leal -12(%ebp), %esp
; WIN-X86-NEXT:    popl %esi
; WIN-X86-NEXT:    popl %edi
; WIN-X86-NEXT:    popl %ebx
; WIN-X86-NEXT:    popl %ebp
; WIN-X86-NEXT:    retl
entry:
  %div = call fp128 @llvm.experimental.constrained.frem.f128(fp128 %x, fp128 %y,  metadata !"round.dynamic", metadata !"fpexcept.strict") #0
  ret fp128 %div
}

define fp128 @ceil(fp128 %x) nounwind strictfp {
; ANDROID-LABEL: ceil:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq ceill@PLT
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: ceil:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq ceilf128@PLT
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: ceil:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $52, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, (%esp)
; X86-NEXT:    calll ceilf128
; X86-NEXT:    subl $4, %esp
; X86-NEXT:    movaps {{[0-9]+}}(%esp), %xmm0
; X86-NEXT:    movaps %xmm0, (%esi)
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    addl $52, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    retl $4
;
; WIN-LABEL: ceil:
; WIN:       # %bb.0: # %entry
; WIN-NEXT:    subq $56, %rsp
; WIN-NEXT:    movaps (%rcx), %xmm0
; WIN-NEXT:    movaps %xmm0, {{[0-9]+}}(%rsp)
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; WIN-NEXT:    callq ceill
; WIN-NEXT:    addq $56, %rsp
; WIN-NEXT:    retq
;
; WIN-X86-LABEL: ceil:
; WIN-X86:       # %bb.0: # %entry
; WIN-X86-NEXT:    pushl %ebp
; WIN-X86-NEXT:    movl %esp, %ebp
; WIN-X86-NEXT:    pushl %edi
; WIN-X86-NEXT:    pushl %esi
; WIN-X86-NEXT:    andl $-16, %esp
; WIN-X86-NEXT:    subl $48, %esp
; WIN-X86-NEXT:    movl 8(%ebp), %esi
; WIN-X86-NEXT:    movl 24(%ebp), %eax
; WIN-X86-NEXT:    movl 28(%ebp), %ecx
; WIN-X86-NEXT:    movl 32(%ebp), %edx
; WIN-X86-NEXT:    movl 36(%ebp), %edi
; WIN-X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl %eax, (%esp)
; WIN-X86-NEXT:    calll _ceill
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; WIN-X86-NEXT:    movl %edi, 8(%esi)
; WIN-X86-NEXT:    movl %edx, 12(%esi)
; WIN-X86-NEXT:    movl %eax, (%esi)
; WIN-X86-NEXT:    movl %ecx, 4(%esi)
; WIN-X86-NEXT:    movl %esi, %eax
; WIN-X86-NEXT:    leal -8(%ebp), %esp
; WIN-X86-NEXT:    popl %esi
; WIN-X86-NEXT:    popl %edi
; WIN-X86-NEXT:    popl %ebp
; WIN-X86-NEXT:    retl
entry:
  %ceil = call fp128 @llvm.experimental.constrained.ceil.f128(fp128 %x, metadata !"fpexcept.strict") #0
  ret fp128 %ceil
}

define fp128 @acos(fp128 %x) nounwind strictfp {
; ANDROID-LABEL: acos:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq acosl@PLT
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: acos:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq acosf128@PLT
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: acos:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $52, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, (%esp)
; X86-NEXT:    calll acosf128
; X86-NEXT:    subl $4, %esp
; X86-NEXT:    movaps {{[0-9]+}}(%esp), %xmm0
; X86-NEXT:    movaps %xmm0, (%esi)
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    addl $52, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    retl $4
;
; WIN-LABEL: acos:
; WIN:       # %bb.0: # %entry
; WIN-NEXT:    subq $56, %rsp
; WIN-NEXT:    movaps (%rcx), %xmm0
; WIN-NEXT:    movaps %xmm0, {{[0-9]+}}(%rsp)
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; WIN-NEXT:    callq acosl
; WIN-NEXT:    addq $56, %rsp
; WIN-NEXT:    retq
;
; WIN-X86-LABEL: acos:
; WIN-X86:       # %bb.0: # %entry
; WIN-X86-NEXT:    pushl %ebp
; WIN-X86-NEXT:    movl %esp, %ebp
; WIN-X86-NEXT:    pushl %edi
; WIN-X86-NEXT:    pushl %esi
; WIN-X86-NEXT:    andl $-16, %esp
; WIN-X86-NEXT:    subl $48, %esp
; WIN-X86-NEXT:    movl 8(%ebp), %esi
; WIN-X86-NEXT:    movl 24(%ebp), %eax
; WIN-X86-NEXT:    movl 28(%ebp), %ecx
; WIN-X86-NEXT:    movl 32(%ebp), %edx
; WIN-X86-NEXT:    movl 36(%ebp), %edi
; WIN-X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl %eax, (%esp)
; WIN-X86-NEXT:    calll _acosl
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; WIN-X86-NEXT:    movl %edi, 8(%esi)
; WIN-X86-NEXT:    movl %edx, 12(%esi)
; WIN-X86-NEXT:    movl %eax, (%esi)
; WIN-X86-NEXT:    movl %ecx, 4(%esi)
; WIN-X86-NEXT:    movl %esi, %eax
; WIN-X86-NEXT:    leal -8(%ebp), %esp
; WIN-X86-NEXT:    popl %esi
; WIN-X86-NEXT:    popl %edi
; WIN-X86-NEXT:    popl %ebp
; WIN-X86-NEXT:    retl
entry:
  %acos = call fp128 @llvm.experimental.constrained.acos.f128(fp128 %x, metadata !"round.dynamic", metadata !"fpexcept.strict") #0
  ret fp128 %acos
}

define fp128 @cos(fp128 %x) nounwind strictfp {
; ANDROID-LABEL: cos:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq cosl@PLT
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: cos:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq cosf128@PLT
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: cos:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $52, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, (%esp)
; X86-NEXT:    calll cosf128
; X86-NEXT:    subl $4, %esp
; X86-NEXT:    movaps {{[0-9]+}}(%esp), %xmm0
; X86-NEXT:    movaps %xmm0, (%esi)
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    addl $52, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    retl $4
;
; WIN-LABEL: cos:
; WIN:       # %bb.0: # %entry
; WIN-NEXT:    subq $56, %rsp
; WIN-NEXT:    movaps (%rcx), %xmm0
; WIN-NEXT:    movaps %xmm0, {{[0-9]+}}(%rsp)
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; WIN-NEXT:    callq cosl
; WIN-NEXT:    addq $56, %rsp
; WIN-NEXT:    retq
;
; WIN-X86-LABEL: cos:
; WIN-X86:       # %bb.0: # %entry
; WIN-X86-NEXT:    pushl %ebp
; WIN-X86-NEXT:    movl %esp, %ebp
; WIN-X86-NEXT:    pushl %edi
; WIN-X86-NEXT:    pushl %esi
; WIN-X86-NEXT:    andl $-16, %esp
; WIN-X86-NEXT:    subl $48, %esp
; WIN-X86-NEXT:    movl 8(%ebp), %esi
; WIN-X86-NEXT:    movl 24(%ebp), %eax
; WIN-X86-NEXT:    movl 28(%ebp), %ecx
; WIN-X86-NEXT:    movl 32(%ebp), %edx
; WIN-X86-NEXT:    movl 36(%ebp), %edi
; WIN-X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl %eax, (%esp)
; WIN-X86-NEXT:    calll _cosl
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; WIN-X86-NEXT:    movl %edi, 8(%esi)
; WIN-X86-NEXT:    movl %edx, 12(%esi)
; WIN-X86-NEXT:    movl %eax, (%esi)
; WIN-X86-NEXT:    movl %ecx, 4(%esi)
; WIN-X86-NEXT:    movl %esi, %eax
; WIN-X86-NEXT:    leal -8(%ebp), %esp
; WIN-X86-NEXT:    popl %esi
; WIN-X86-NEXT:    popl %edi
; WIN-X86-NEXT:    popl %ebp
; WIN-X86-NEXT:    retl
entry:
  %cos = call fp128 @llvm.experimental.constrained.cos.f128(fp128 %x, metadata !"round.dynamic", metadata !"fpexcept.strict") #0
  ret fp128 %cos
}

define fp128 @cosh(fp128 %x) nounwind strictfp {
; ANDROID-LABEL: cosh:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq coshl@PLT
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: cosh:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq coshf128@PLT
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: cosh:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $52, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, (%esp)
; X86-NEXT:    calll coshf128
; X86-NEXT:    subl $4, %esp
; X86-NEXT:    movaps {{[0-9]+}}(%esp), %xmm0
; X86-NEXT:    movaps %xmm0, (%esi)
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    addl $52, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    retl $4
;
; WIN-LABEL: cosh:
; WIN:       # %bb.0: # %entry
; WIN-NEXT:    subq $56, %rsp
; WIN-NEXT:    movaps (%rcx), %xmm0
; WIN-NEXT:    movaps %xmm0, {{[0-9]+}}(%rsp)
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; WIN-NEXT:    callq coshl
; WIN-NEXT:    addq $56, %rsp
; WIN-NEXT:    retq
;
; WIN-X86-LABEL: cosh:
; WIN-X86:       # %bb.0: # %entry
; WIN-X86-NEXT:    pushl %ebp
; WIN-X86-NEXT:    movl %esp, %ebp
; WIN-X86-NEXT:    pushl %edi
; WIN-X86-NEXT:    pushl %esi
; WIN-X86-NEXT:    andl $-16, %esp
; WIN-X86-NEXT:    subl $48, %esp
; WIN-X86-NEXT:    movl 8(%ebp), %esi
; WIN-X86-NEXT:    movl 24(%ebp), %eax
; WIN-X86-NEXT:    movl 28(%ebp), %ecx
; WIN-X86-NEXT:    movl 32(%ebp), %edx
; WIN-X86-NEXT:    movl 36(%ebp), %edi
; WIN-X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl %eax, (%esp)
; WIN-X86-NEXT:    calll _coshl
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; WIN-X86-NEXT:    movl %edi, 8(%esi)
; WIN-X86-NEXT:    movl %edx, 12(%esi)
; WIN-X86-NEXT:    movl %eax, (%esi)
; WIN-X86-NEXT:    movl %ecx, 4(%esi)
; WIN-X86-NEXT:    movl %esi, %eax
; WIN-X86-NEXT:    leal -8(%ebp), %esp
; WIN-X86-NEXT:    popl %esi
; WIN-X86-NEXT:    popl %edi
; WIN-X86-NEXT:    popl %ebp
; WIN-X86-NEXT:    retl
entry:
  %cosh = call fp128 @llvm.experimental.constrained.cosh.f128(fp128 %x, metadata !"round.dynamic", metadata !"fpexcept.strict") #0
  ret fp128 %cosh
}

define fp128 @exp(fp128 %x) nounwind strictfp {
; ANDROID-LABEL: exp:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq expl@PLT
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: exp:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq expf128@PLT
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: exp:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $52, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, (%esp)
; X86-NEXT:    calll expf128
; X86-NEXT:    subl $4, %esp
; X86-NEXT:    movaps {{[0-9]+}}(%esp), %xmm0
; X86-NEXT:    movaps %xmm0, (%esi)
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    addl $52, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    retl $4
;
; WIN-LABEL: exp:
; WIN:       # %bb.0: # %entry
; WIN-NEXT:    subq $56, %rsp
; WIN-NEXT:    movaps (%rcx), %xmm0
; WIN-NEXT:    movaps %xmm0, {{[0-9]+}}(%rsp)
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; WIN-NEXT:    callq expl
; WIN-NEXT:    addq $56, %rsp
; WIN-NEXT:    retq
;
; WIN-X86-LABEL: exp:
; WIN-X86:       # %bb.0: # %entry
; WIN-X86-NEXT:    pushl %ebp
; WIN-X86-NEXT:    movl %esp, %ebp
; WIN-X86-NEXT:    pushl %edi
; WIN-X86-NEXT:    pushl %esi
; WIN-X86-NEXT:    andl $-16, %esp
; WIN-X86-NEXT:    subl $48, %esp
; WIN-X86-NEXT:    movl 8(%ebp), %esi
; WIN-X86-NEXT:    movl 24(%ebp), %eax
; WIN-X86-NEXT:    movl 28(%ebp), %ecx
; WIN-X86-NEXT:    movl 32(%ebp), %edx
; WIN-X86-NEXT:    movl 36(%ebp), %edi
; WIN-X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl %eax, (%esp)
; WIN-X86-NEXT:    calll _expl
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; WIN-X86-NEXT:    movl %edi, 8(%esi)
; WIN-X86-NEXT:    movl %edx, 12(%esi)
; WIN-X86-NEXT:    movl %eax, (%esi)
; WIN-X86-NEXT:    movl %ecx, 4(%esi)
; WIN-X86-NEXT:    movl %esi, %eax
; WIN-X86-NEXT:    leal -8(%ebp), %esp
; WIN-X86-NEXT:    popl %esi
; WIN-X86-NEXT:    popl %edi
; WIN-X86-NEXT:    popl %ebp
; WIN-X86-NEXT:    retl
entry:
  %exp = call fp128 @llvm.experimental.constrained.exp.f128(fp128 %x, metadata !"round.dynamic", metadata !"fpexcept.strict") #0
  ret fp128 %exp
}

define fp128 @exp2(fp128 %x) nounwind strictfp {
; ANDROID-LABEL: exp2:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq exp2l@PLT
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: exp2:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq exp2f128@PLT
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: exp2:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $52, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, (%esp)
; X86-NEXT:    calll exp2f128
; X86-NEXT:    subl $4, %esp
; X86-NEXT:    movaps {{[0-9]+}}(%esp), %xmm0
; X86-NEXT:    movaps %xmm0, (%esi)
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    addl $52, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    retl $4
;
; WIN-LABEL: exp2:
; WIN:       # %bb.0: # %entry
; WIN-NEXT:    subq $56, %rsp
; WIN-NEXT:    movaps (%rcx), %xmm0
; WIN-NEXT:    movaps %xmm0, {{[0-9]+}}(%rsp)
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; WIN-NEXT:    callq exp2l
; WIN-NEXT:    addq $56, %rsp
; WIN-NEXT:    retq
;
; WIN-X86-LABEL: exp2:
; WIN-X86:       # %bb.0: # %entry
; WIN-X86-NEXT:    pushl %ebp
; WIN-X86-NEXT:    movl %esp, %ebp
; WIN-X86-NEXT:    pushl %edi
; WIN-X86-NEXT:    pushl %esi
; WIN-X86-NEXT:    andl $-16, %esp
; WIN-X86-NEXT:    subl $48, %esp
; WIN-X86-NEXT:    movl 8(%ebp), %esi
; WIN-X86-NEXT:    movl 24(%ebp), %eax
; WIN-X86-NEXT:    movl 28(%ebp), %ecx
; WIN-X86-NEXT:    movl 32(%ebp), %edx
; WIN-X86-NEXT:    movl 36(%ebp), %edi
; WIN-X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl %eax, (%esp)
; WIN-X86-NEXT:    calll _exp2l
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; WIN-X86-NEXT:    movl %edi, 8(%esi)
; WIN-X86-NEXT:    movl %edx, 12(%esi)
; WIN-X86-NEXT:    movl %eax, (%esi)
; WIN-X86-NEXT:    movl %ecx, 4(%esi)
; WIN-X86-NEXT:    movl %esi, %eax
; WIN-X86-NEXT:    leal -8(%ebp), %esp
; WIN-X86-NEXT:    popl %esi
; WIN-X86-NEXT:    popl %edi
; WIN-X86-NEXT:    popl %ebp
; WIN-X86-NEXT:    retl
entry:
  %exp2 = call fp128 @llvm.experimental.constrained.exp2.f128(fp128 %x, metadata !"round.dynamic", metadata !"fpexcept.strict") #0
  ret fp128 %exp2
}

define fp128 @floor(fp128 %x) nounwind strictfp {
; ANDROID-LABEL: floor:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq floorl@PLT
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: floor:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq floorf128@PLT
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: floor:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $52, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, (%esp)
; X86-NEXT:    calll floorf128
; X86-NEXT:    subl $4, %esp
; X86-NEXT:    movaps {{[0-9]+}}(%esp), %xmm0
; X86-NEXT:    movaps %xmm0, (%esi)
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    addl $52, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    retl $4
;
; WIN-LABEL: floor:
; WIN:       # %bb.0: # %entry
; WIN-NEXT:    subq $56, %rsp
; WIN-NEXT:    movaps (%rcx), %xmm0
; WIN-NEXT:    movaps %xmm0, {{[0-9]+}}(%rsp)
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; WIN-NEXT:    callq floorl
; WIN-NEXT:    addq $56, %rsp
; WIN-NEXT:    retq
;
; WIN-X86-LABEL: floor:
; WIN-X86:       # %bb.0: # %entry
; WIN-X86-NEXT:    pushl %ebp
; WIN-X86-NEXT:    movl %esp, %ebp
; WIN-X86-NEXT:    pushl %edi
; WIN-X86-NEXT:    pushl %esi
; WIN-X86-NEXT:    andl $-16, %esp
; WIN-X86-NEXT:    subl $48, %esp
; WIN-X86-NEXT:    movl 8(%ebp), %esi
; WIN-X86-NEXT:    movl 24(%ebp), %eax
; WIN-X86-NEXT:    movl 28(%ebp), %ecx
; WIN-X86-NEXT:    movl 32(%ebp), %edx
; WIN-X86-NEXT:    movl 36(%ebp), %edi
; WIN-X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl %eax, (%esp)
; WIN-X86-NEXT:    calll _floorl
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; WIN-X86-NEXT:    movl %edi, 8(%esi)
; WIN-X86-NEXT:    movl %edx, 12(%esi)
; WIN-X86-NEXT:    movl %eax, (%esi)
; WIN-X86-NEXT:    movl %ecx, 4(%esi)
; WIN-X86-NEXT:    movl %esi, %eax
; WIN-X86-NEXT:    leal -8(%ebp), %esp
; WIN-X86-NEXT:    popl %esi
; WIN-X86-NEXT:    popl %edi
; WIN-X86-NEXT:    popl %ebp
; WIN-X86-NEXT:    retl
entry:
  %floor = call fp128 @llvm.experimental.constrained.floor.f128(fp128 %x, metadata !"fpexcept.strict") #0
  ret fp128 %floor
}

define fp128 @log(fp128 %x) nounwind strictfp {
; ANDROID-LABEL: log:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq logl@PLT
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: log:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq logf128@PLT
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: log:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $52, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, (%esp)
; X86-NEXT:    calll logf128
; X86-NEXT:    subl $4, %esp
; X86-NEXT:    movaps {{[0-9]+}}(%esp), %xmm0
; X86-NEXT:    movaps %xmm0, (%esi)
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    addl $52, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    retl $4
;
; WIN-LABEL: log:
; WIN:       # %bb.0: # %entry
; WIN-NEXT:    subq $56, %rsp
; WIN-NEXT:    movaps (%rcx), %xmm0
; WIN-NEXT:    movaps %xmm0, {{[0-9]+}}(%rsp)
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; WIN-NEXT:    callq logl
; WIN-NEXT:    addq $56, %rsp
; WIN-NEXT:    retq
;
; WIN-X86-LABEL: log:
; WIN-X86:       # %bb.0: # %entry
; WIN-X86-NEXT:    pushl %ebp
; WIN-X86-NEXT:    movl %esp, %ebp
; WIN-X86-NEXT:    pushl %edi
; WIN-X86-NEXT:    pushl %esi
; WIN-X86-NEXT:    andl $-16, %esp
; WIN-X86-NEXT:    subl $48, %esp
; WIN-X86-NEXT:    movl 8(%ebp), %esi
; WIN-X86-NEXT:    movl 24(%ebp), %eax
; WIN-X86-NEXT:    movl 28(%ebp), %ecx
; WIN-X86-NEXT:    movl 32(%ebp), %edx
; WIN-X86-NEXT:    movl 36(%ebp), %edi
; WIN-X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl %eax, (%esp)
; WIN-X86-NEXT:    calll _logl
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; WIN-X86-NEXT:    movl %edi, 8(%esi)
; WIN-X86-NEXT:    movl %edx, 12(%esi)
; WIN-X86-NEXT:    movl %eax, (%esi)
; WIN-X86-NEXT:    movl %ecx, 4(%esi)
; WIN-X86-NEXT:    movl %esi, %eax
; WIN-X86-NEXT:    leal -8(%ebp), %esp
; WIN-X86-NEXT:    popl %esi
; WIN-X86-NEXT:    popl %edi
; WIN-X86-NEXT:    popl %ebp
; WIN-X86-NEXT:    retl
entry:
  %log = call fp128 @llvm.experimental.constrained.log.f128(fp128 %x, metadata !"round.dynamic", metadata !"fpexcept.strict") #0
  ret fp128 %log
}

define fp128 @log10(fp128 %x) nounwind strictfp {
; ANDROID-LABEL: log10:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq log10l@PLT
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: log10:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq log10f128@PLT
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: log10:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $52, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, (%esp)
; X86-NEXT:    calll log10f128
; X86-NEXT:    subl $4, %esp
; X86-NEXT:    movaps {{[0-9]+}}(%esp), %xmm0
; X86-NEXT:    movaps %xmm0, (%esi)
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    addl $52, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    retl $4
;
; WIN-LABEL: log10:
; WIN:       # %bb.0: # %entry
; WIN-NEXT:    subq $56, %rsp
; WIN-NEXT:    movaps (%rcx), %xmm0
; WIN-NEXT:    movaps %xmm0, {{[0-9]+}}(%rsp)
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; WIN-NEXT:    callq log10l
; WIN-NEXT:    addq $56, %rsp
; WIN-NEXT:    retq
;
; WIN-X86-LABEL: log10:
; WIN-X86:       # %bb.0: # %entry
; WIN-X86-NEXT:    pushl %ebp
; WIN-X86-NEXT:    movl %esp, %ebp
; WIN-X86-NEXT:    pushl %edi
; WIN-X86-NEXT:    pushl %esi
; WIN-X86-NEXT:    andl $-16, %esp
; WIN-X86-NEXT:    subl $48, %esp
; WIN-X86-NEXT:    movl 8(%ebp), %esi
; WIN-X86-NEXT:    movl 24(%ebp), %eax
; WIN-X86-NEXT:    movl 28(%ebp), %ecx
; WIN-X86-NEXT:    movl 32(%ebp), %edx
; WIN-X86-NEXT:    movl 36(%ebp), %edi
; WIN-X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl %eax, (%esp)
; WIN-X86-NEXT:    calll _log10l
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; WIN-X86-NEXT:    movl %edi, 8(%esi)
; WIN-X86-NEXT:    movl %edx, 12(%esi)
; WIN-X86-NEXT:    movl %eax, (%esi)
; WIN-X86-NEXT:    movl %ecx, 4(%esi)
; WIN-X86-NEXT:    movl %esi, %eax
; WIN-X86-NEXT:    leal -8(%ebp), %esp
; WIN-X86-NEXT:    popl %esi
; WIN-X86-NEXT:    popl %edi
; WIN-X86-NEXT:    popl %ebp
; WIN-X86-NEXT:    retl
entry:
  %log10 = call fp128 @llvm.experimental.constrained.log10.f128(fp128 %x, metadata !"round.dynamic", metadata !"fpexcept.strict") #0
  ret fp128 %log10
}

define fp128 @log2(fp128 %x) nounwind strictfp {
; ANDROID-LABEL: log2:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq log2l@PLT
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: log2:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq log2f128@PLT
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: log2:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $52, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, (%esp)
; X86-NEXT:    calll log2f128
; X86-NEXT:    subl $4, %esp
; X86-NEXT:    movaps {{[0-9]+}}(%esp), %xmm0
; X86-NEXT:    movaps %xmm0, (%esi)
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    addl $52, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    retl $4
;
; WIN-LABEL: log2:
; WIN:       # %bb.0: # %entry
; WIN-NEXT:    subq $56, %rsp
; WIN-NEXT:    movaps (%rcx), %xmm0
; WIN-NEXT:    movaps %xmm0, {{[0-9]+}}(%rsp)
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; WIN-NEXT:    callq log2l
; WIN-NEXT:    addq $56, %rsp
; WIN-NEXT:    retq
;
; WIN-X86-LABEL: log2:
; WIN-X86:       # %bb.0: # %entry
; WIN-X86-NEXT:    pushl %ebp
; WIN-X86-NEXT:    movl %esp, %ebp
; WIN-X86-NEXT:    pushl %edi
; WIN-X86-NEXT:    pushl %esi
; WIN-X86-NEXT:    andl $-16, %esp
; WIN-X86-NEXT:    subl $48, %esp
; WIN-X86-NEXT:    movl 8(%ebp), %esi
; WIN-X86-NEXT:    movl 24(%ebp), %eax
; WIN-X86-NEXT:    movl 28(%ebp), %ecx
; WIN-X86-NEXT:    movl 32(%ebp), %edx
; WIN-X86-NEXT:    movl 36(%ebp), %edi
; WIN-X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl %eax, (%esp)
; WIN-X86-NEXT:    calll _log2l
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; WIN-X86-NEXT:    movl %edi, 8(%esi)
; WIN-X86-NEXT:    movl %edx, 12(%esi)
; WIN-X86-NEXT:    movl %eax, (%esi)
; WIN-X86-NEXT:    movl %ecx, 4(%esi)
; WIN-X86-NEXT:    movl %esi, %eax
; WIN-X86-NEXT:    leal -8(%ebp), %esp
; WIN-X86-NEXT:    popl %esi
; WIN-X86-NEXT:    popl %edi
; WIN-X86-NEXT:    popl %ebp
; WIN-X86-NEXT:    retl
entry:
  %log2 = call fp128 @llvm.experimental.constrained.log2.f128(fp128 %x, metadata !"round.dynamic", metadata !"fpexcept.strict") #0
  ret fp128 %log2
}

define fp128 @maxnum(fp128 %x, fp128 %y) nounwind strictfp {
; ANDROID-LABEL: maxnum:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq fmaxl@PLT
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: maxnum:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq fmaxf128@PLT
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: maxnum:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %ebp
; X86-NEXT:    pushl %ebx
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $76, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ebp, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ebx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, (%esp)
; X86-NEXT:    calll fmaxf128
; X86-NEXT:    subl $4, %esp
; X86-NEXT:    movaps {{[0-9]+}}(%esp), %xmm0
; X86-NEXT:    movaps %xmm0, (%esi)
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    addl $76, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    popl %ebx
; X86-NEXT:    popl %ebp
; X86-NEXT:    retl $4
;
; WIN-LABEL: maxnum:
; WIN:       # %bb.0: # %entry
; WIN-NEXT:    subq $72, %rsp
; WIN-NEXT:    movaps (%rcx), %xmm0
; WIN-NEXT:    movaps (%rdx), %xmm1
; WIN-NEXT:    movaps %xmm1, {{[0-9]+}}(%rsp)
; WIN-NEXT:    movaps %xmm0, {{[0-9]+}}(%rsp)
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rdx
; WIN-NEXT:    callq fmaxl
; WIN-NEXT:    addq $72, %rsp
; WIN-NEXT:    retq
;
; WIN-X86-LABEL: maxnum:
; WIN-X86:       # %bb.0: # %entry
; WIN-X86-NEXT:    pushl %ebp
; WIN-X86-NEXT:    movl %esp, %ebp
; WIN-X86-NEXT:    pushl %ebx
; WIN-X86-NEXT:    pushl %edi
; WIN-X86-NEXT:    pushl %esi
; WIN-X86-NEXT:    andl $-16, %esp
; WIN-X86-NEXT:    subl $80, %esp
; WIN-X86-NEXT:    movl 8(%ebp), %esi
; WIN-X86-NEXT:    movl 36(%ebp), %edi
; WIN-X86-NEXT:    movl 40(%ebp), %ebx
; WIN-X86-NEXT:    movl 44(%ebp), %edx
; WIN-X86-NEXT:    movl 48(%ebp), %ecx
; WIN-X86-NEXT:    movl 52(%ebp), %eax
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %ebx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl 32(%ebp), %eax
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl 28(%ebp), %eax
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl 24(%ebp), %eax
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl %eax, (%esp)
; WIN-X86-NEXT:    calll _fmaxl
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; WIN-X86-NEXT:    movl %edi, 8(%esi)
; WIN-X86-NEXT:    movl %edx, 12(%esi)
; WIN-X86-NEXT:    movl %eax, (%esi)
; WIN-X86-NEXT:    movl %ecx, 4(%esi)
; WIN-X86-NEXT:    movl %esi, %eax
; WIN-X86-NEXT:    leal -12(%ebp), %esp
; WIN-X86-NEXT:    popl %esi
; WIN-X86-NEXT:    popl %edi
; WIN-X86-NEXT:    popl %ebx
; WIN-X86-NEXT:    popl %ebp
; WIN-X86-NEXT:    retl
entry:
  %maxnum = call fp128 @llvm.experimental.constrained.maxnum.f128(fp128 %x, fp128 %y, metadata !"fpexcept.strict") #0
  ret fp128 %maxnum
}

define fp128 @minnum(fp128 %x, fp128 %y) nounwind strictfp {
; ANDROID-LABEL: minnum:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq fminl@PLT
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: minnum:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq fminf128@PLT
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: minnum:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %ebp
; X86-NEXT:    pushl %ebx
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $76, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ebp, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ebx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, (%esp)
; X86-NEXT:    calll fminf128
; X86-NEXT:    subl $4, %esp
; X86-NEXT:    movaps {{[0-9]+}}(%esp), %xmm0
; X86-NEXT:    movaps %xmm0, (%esi)
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    addl $76, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    popl %ebx
; X86-NEXT:    popl %ebp
; X86-NEXT:    retl $4
;
; WIN-LABEL: minnum:
; WIN:       # %bb.0: # %entry
; WIN-NEXT:    subq $72, %rsp
; WIN-NEXT:    movaps (%rcx), %xmm0
; WIN-NEXT:    movaps (%rdx), %xmm1
; WIN-NEXT:    movaps %xmm1, {{[0-9]+}}(%rsp)
; WIN-NEXT:    movaps %xmm0, {{[0-9]+}}(%rsp)
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rdx
; WIN-NEXT:    callq fminl
; WIN-NEXT:    addq $72, %rsp
; WIN-NEXT:    retq
;
; WIN-X86-LABEL: minnum:
; WIN-X86:       # %bb.0: # %entry
; WIN-X86-NEXT:    pushl %ebp
; WIN-X86-NEXT:    movl %esp, %ebp
; WIN-X86-NEXT:    pushl %ebx
; WIN-X86-NEXT:    pushl %edi
; WIN-X86-NEXT:    pushl %esi
; WIN-X86-NEXT:    andl $-16, %esp
; WIN-X86-NEXT:    subl $80, %esp
; WIN-X86-NEXT:    movl 8(%ebp), %esi
; WIN-X86-NEXT:    movl 36(%ebp), %edi
; WIN-X86-NEXT:    movl 40(%ebp), %ebx
; WIN-X86-NEXT:    movl 44(%ebp), %edx
; WIN-X86-NEXT:    movl 48(%ebp), %ecx
; WIN-X86-NEXT:    movl 52(%ebp), %eax
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %ebx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl 32(%ebp), %eax
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl 28(%ebp), %eax
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl 24(%ebp), %eax
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl %eax, (%esp)
; WIN-X86-NEXT:    calll _fminl
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; WIN-X86-NEXT:    movl %edi, 8(%esi)
; WIN-X86-NEXT:    movl %edx, 12(%esi)
; WIN-X86-NEXT:    movl %eax, (%esi)
; WIN-X86-NEXT:    movl %ecx, 4(%esi)
; WIN-X86-NEXT:    movl %esi, %eax
; WIN-X86-NEXT:    leal -12(%ebp), %esp
; WIN-X86-NEXT:    popl %esi
; WIN-X86-NEXT:    popl %edi
; WIN-X86-NEXT:    popl %ebx
; WIN-X86-NEXT:    popl %ebp
; WIN-X86-NEXT:    retl
entry:
  %minnum = call fp128 @llvm.experimental.constrained.minnum.f128(fp128 %x, fp128 %y, metadata !"fpexcept.strict") #0
  ret fp128 %minnum
}

define fp128 @nearbyint(fp128 %x) nounwind strictfp {
; ANDROID-LABEL: nearbyint:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq nearbyintl@PLT
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: nearbyint:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq nearbyintf128@PLT
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: nearbyint:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $52, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, (%esp)
; X86-NEXT:    calll nearbyintf128
; X86-NEXT:    subl $4, %esp
; X86-NEXT:    movaps {{[0-9]+}}(%esp), %xmm0
; X86-NEXT:    movaps %xmm0, (%esi)
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    addl $52, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    retl $4
;
; WIN-LABEL: nearbyint:
; WIN:       # %bb.0: # %entry
; WIN-NEXT:    subq $56, %rsp
; WIN-NEXT:    movaps (%rcx), %xmm0
; WIN-NEXT:    movaps %xmm0, {{[0-9]+}}(%rsp)
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; WIN-NEXT:    callq nearbyintl
; WIN-NEXT:    addq $56, %rsp
; WIN-NEXT:    retq
;
; WIN-X86-LABEL: nearbyint:
; WIN-X86:       # %bb.0: # %entry
; WIN-X86-NEXT:    pushl %ebp
; WIN-X86-NEXT:    movl %esp, %ebp
; WIN-X86-NEXT:    pushl %edi
; WIN-X86-NEXT:    pushl %esi
; WIN-X86-NEXT:    andl $-16, %esp
; WIN-X86-NEXT:    subl $48, %esp
; WIN-X86-NEXT:    movl 8(%ebp), %esi
; WIN-X86-NEXT:    movl 24(%ebp), %eax
; WIN-X86-NEXT:    movl 28(%ebp), %ecx
; WIN-X86-NEXT:    movl 32(%ebp), %edx
; WIN-X86-NEXT:    movl 36(%ebp), %edi
; WIN-X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl %eax, (%esp)
; WIN-X86-NEXT:    calll _nearbyintl
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; WIN-X86-NEXT:    movl %edi, 8(%esi)
; WIN-X86-NEXT:    movl %edx, 12(%esi)
; WIN-X86-NEXT:    movl %eax, (%esi)
; WIN-X86-NEXT:    movl %ecx, 4(%esi)
; WIN-X86-NEXT:    movl %esi, %eax
; WIN-X86-NEXT:    leal -8(%ebp), %esp
; WIN-X86-NEXT:    popl %esi
; WIN-X86-NEXT:    popl %edi
; WIN-X86-NEXT:    popl %ebp
; WIN-X86-NEXT:    retl
entry:
  %nearbyint = call fp128 @llvm.experimental.constrained.nearbyint.f128(fp128 %x, metadata !"round.dynamic", metadata !"fpexcept.strict") #0
  ret fp128 %nearbyint
}

define fp128 @pow(fp128 %x, fp128 %y) nounwind strictfp {
; ANDROID-LABEL: pow:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq powl@PLT
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: pow:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq powf128@PLT
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: pow:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %ebp
; X86-NEXT:    pushl %ebx
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $76, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ebp, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ebx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, (%esp)
; X86-NEXT:    calll powf128
; X86-NEXT:    subl $4, %esp
; X86-NEXT:    movaps {{[0-9]+}}(%esp), %xmm0
; X86-NEXT:    movaps %xmm0, (%esi)
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    addl $76, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    popl %ebx
; X86-NEXT:    popl %ebp
; X86-NEXT:    retl $4
;
; WIN-LABEL: pow:
; WIN:       # %bb.0: # %entry
; WIN-NEXT:    subq $72, %rsp
; WIN-NEXT:    movaps (%rcx), %xmm0
; WIN-NEXT:    movaps (%rdx), %xmm1
; WIN-NEXT:    movaps %xmm1, {{[0-9]+}}(%rsp)
; WIN-NEXT:    movaps %xmm0, {{[0-9]+}}(%rsp)
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rdx
; WIN-NEXT:    callq powl
; WIN-NEXT:    addq $72, %rsp
; WIN-NEXT:    retq
;
; WIN-X86-LABEL: pow:
; WIN-X86:       # %bb.0: # %entry
; WIN-X86-NEXT:    pushl %ebp
; WIN-X86-NEXT:    movl %esp, %ebp
; WIN-X86-NEXT:    pushl %ebx
; WIN-X86-NEXT:    pushl %edi
; WIN-X86-NEXT:    pushl %esi
; WIN-X86-NEXT:    andl $-16, %esp
; WIN-X86-NEXT:    subl $80, %esp
; WIN-X86-NEXT:    movl 8(%ebp), %esi
; WIN-X86-NEXT:    movl 36(%ebp), %edi
; WIN-X86-NEXT:    movl 40(%ebp), %ebx
; WIN-X86-NEXT:    movl 44(%ebp), %edx
; WIN-X86-NEXT:    movl 48(%ebp), %ecx
; WIN-X86-NEXT:    movl 52(%ebp), %eax
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %ebx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl 32(%ebp), %eax
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl 28(%ebp), %eax
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl 24(%ebp), %eax
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl %eax, (%esp)
; WIN-X86-NEXT:    calll _powl
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; WIN-X86-NEXT:    movl %edi, 8(%esi)
; WIN-X86-NEXT:    movl %edx, 12(%esi)
; WIN-X86-NEXT:    movl %eax, (%esi)
; WIN-X86-NEXT:    movl %ecx, 4(%esi)
; WIN-X86-NEXT:    movl %esi, %eax
; WIN-X86-NEXT:    leal -12(%ebp), %esp
; WIN-X86-NEXT:    popl %esi
; WIN-X86-NEXT:    popl %edi
; WIN-X86-NEXT:    popl %ebx
; WIN-X86-NEXT:    popl %ebp
; WIN-X86-NEXT:    retl
entry:
  %pow = call fp128 @llvm.experimental.constrained.pow.f128(fp128 %x, fp128 %y, metadata !"round.dynamic", metadata !"fpexcept.strict") #0
  ret fp128 %pow
}

define fp128 @powi(fp128 %x, i32 %y) nounwind strictfp {
; CHECK-LABEL: powi:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    pushq %rax
; CHECK-NEXT:    callq __powitf2@PLT
; CHECK-NEXT:    popq %rax
; CHECK-NEXT:    retq
;
; ANDROID-LABEL: powi:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq __powitf2@PLT
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: powi:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq __powitf2@PLT
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: powi:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %ebx
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $64, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; X86-NEXT:    movl %ebx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, (%esp)
; X86-NEXT:    calll __powitf2
; X86-NEXT:    subl $4, %esp
; X86-NEXT:    movaps {{[0-9]+}}(%esp), %xmm0
; X86-NEXT:    movaps %xmm0, (%esi)
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    addl $64, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    popl %ebx
; X86-NEXT:    retl $4
;
; WIN-LABEL: powi:
; WIN:       # %bb.0: # %entry
; WIN-NEXT:    subq $56, %rsp
; WIN-NEXT:    movaps (%rcx), %xmm0
; WIN-NEXT:    movaps %xmm0, {{[0-9]+}}(%rsp)
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; WIN-NEXT:    callq __powitf2
; WIN-NEXT:    addq $56, %rsp
; WIN-NEXT:    retq
;
; WIN-X86-LABEL: powi:
; WIN-X86:       # %bb.0: # %entry
; WIN-X86-NEXT:    pushl %ebp
; WIN-X86-NEXT:    movl %esp, %ebp
; WIN-X86-NEXT:    pushl %ebx
; WIN-X86-NEXT:    pushl %edi
; WIN-X86-NEXT:    pushl %esi
; WIN-X86-NEXT:    andl $-16, %esp
; WIN-X86-NEXT:    subl $80, %esp
; WIN-X86-NEXT:    movl 8(%ebp), %esi
; WIN-X86-NEXT:    movl 24(%ebp), %eax
; WIN-X86-NEXT:    movl 28(%ebp), %ecx
; WIN-X86-NEXT:    movl 32(%ebp), %edx
; WIN-X86-NEXT:    movl 36(%ebp), %edi
; WIN-X86-NEXT:    movl 40(%ebp), %ebx
; WIN-X86-NEXT:    movl %ebx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl %eax, (%esp)
; WIN-X86-NEXT:    calll ___powitf2
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; WIN-X86-NEXT:    movl %edi, 8(%esi)
; WIN-X86-NEXT:    movl %edx, 12(%esi)
; WIN-X86-NEXT:    movl %eax, (%esi)
; WIN-X86-NEXT:    movl %ecx, 4(%esi)
; WIN-X86-NEXT:    movl %esi, %eax
; WIN-X86-NEXT:    leal -12(%ebp), %esp
; WIN-X86-NEXT:    popl %esi
; WIN-X86-NEXT:    popl %edi
; WIN-X86-NEXT:    popl %ebx
; WIN-X86-NEXT:    popl %ebp
; WIN-X86-NEXT:    retl
entry:
  %powi = call fp128 @llvm.experimental.constrained.powi.f128(fp128 %x, i32 %y, metadata !"round.dynamic", metadata !"fpexcept.strict") #0
  ret fp128 %powi
}

define fp128 @rint(fp128 %x) nounwind strictfp {
; ANDROID-LABEL: rint:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq rintl@PLT
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: rint:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq rintf128@PLT
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: rint:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $52, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, (%esp)
; X86-NEXT:    calll rintf128
; X86-NEXT:    subl $4, %esp
; X86-NEXT:    movaps {{[0-9]+}}(%esp), %xmm0
; X86-NEXT:    movaps %xmm0, (%esi)
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    addl $52, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    retl $4
;
; WIN-LABEL: rint:
; WIN:       # %bb.0: # %entry
; WIN-NEXT:    subq $56, %rsp
; WIN-NEXT:    movaps (%rcx), %xmm0
; WIN-NEXT:    movaps %xmm0, {{[0-9]+}}(%rsp)
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; WIN-NEXT:    callq rintl
; WIN-NEXT:    addq $56, %rsp
; WIN-NEXT:    retq
;
; WIN-X86-LABEL: rint:
; WIN-X86:       # %bb.0: # %entry
; WIN-X86-NEXT:    pushl %ebp
; WIN-X86-NEXT:    movl %esp, %ebp
; WIN-X86-NEXT:    pushl %edi
; WIN-X86-NEXT:    pushl %esi
; WIN-X86-NEXT:    andl $-16, %esp
; WIN-X86-NEXT:    subl $48, %esp
; WIN-X86-NEXT:    movl 8(%ebp), %esi
; WIN-X86-NEXT:    movl 24(%ebp), %eax
; WIN-X86-NEXT:    movl 28(%ebp), %ecx
; WIN-X86-NEXT:    movl 32(%ebp), %edx
; WIN-X86-NEXT:    movl 36(%ebp), %edi
; WIN-X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl %eax, (%esp)
; WIN-X86-NEXT:    calll _rintl
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; WIN-X86-NEXT:    movl %edi, 8(%esi)
; WIN-X86-NEXT:    movl %edx, 12(%esi)
; WIN-X86-NEXT:    movl %eax, (%esi)
; WIN-X86-NEXT:    movl %ecx, 4(%esi)
; WIN-X86-NEXT:    movl %esi, %eax
; WIN-X86-NEXT:    leal -8(%ebp), %esp
; WIN-X86-NEXT:    popl %esi
; WIN-X86-NEXT:    popl %edi
; WIN-X86-NEXT:    popl %ebp
; WIN-X86-NEXT:    retl
entry:
  %rint = call fp128 @llvm.experimental.constrained.rint.f128(fp128 %x, metadata !"round.dynamic", metadata !"fpexcept.strict") #0
  ret fp128 %rint
}

define fp128 @round(fp128 %x) nounwind strictfp {
; ANDROID-LABEL: round:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq roundl@PLT
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: round:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq roundf128@PLT
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: round:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $52, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, (%esp)
; X86-NEXT:    calll roundf128
; X86-NEXT:    subl $4, %esp
; X86-NEXT:    movaps {{[0-9]+}}(%esp), %xmm0
; X86-NEXT:    movaps %xmm0, (%esi)
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    addl $52, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    retl $4
;
; WIN-LABEL: round:
; WIN:       # %bb.0: # %entry
; WIN-NEXT:    subq $56, %rsp
; WIN-NEXT:    movaps (%rcx), %xmm0
; WIN-NEXT:    movaps %xmm0, {{[0-9]+}}(%rsp)
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; WIN-NEXT:    callq roundl
; WIN-NEXT:    addq $56, %rsp
; WIN-NEXT:    retq
;
; WIN-X86-LABEL: round:
; WIN-X86:       # %bb.0: # %entry
; WIN-X86-NEXT:    pushl %ebp
; WIN-X86-NEXT:    movl %esp, %ebp
; WIN-X86-NEXT:    pushl %edi
; WIN-X86-NEXT:    pushl %esi
; WIN-X86-NEXT:    andl $-16, %esp
; WIN-X86-NEXT:    subl $48, %esp
; WIN-X86-NEXT:    movl 8(%ebp), %esi
; WIN-X86-NEXT:    movl 24(%ebp), %eax
; WIN-X86-NEXT:    movl 28(%ebp), %ecx
; WIN-X86-NEXT:    movl 32(%ebp), %edx
; WIN-X86-NEXT:    movl 36(%ebp), %edi
; WIN-X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl %eax, (%esp)
; WIN-X86-NEXT:    calll _roundl
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; WIN-X86-NEXT:    movl %edi, 8(%esi)
; WIN-X86-NEXT:    movl %edx, 12(%esi)
; WIN-X86-NEXT:    movl %eax, (%esi)
; WIN-X86-NEXT:    movl %ecx, 4(%esi)
; WIN-X86-NEXT:    movl %esi, %eax
; WIN-X86-NEXT:    leal -8(%ebp), %esp
; WIN-X86-NEXT:    popl %esi
; WIN-X86-NEXT:    popl %edi
; WIN-X86-NEXT:    popl %ebp
; WIN-X86-NEXT:    retl
entry:
  %round = call fp128 @llvm.experimental.constrained.round.f128(fp128 %x, metadata !"fpexcept.strict") #0
  ret fp128 %round
}

define fp128 @roundeven(fp128 %x) nounwind strictfp {
; ANDROID-LABEL: roundeven:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq roundevenl@PLT
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: roundeven:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq roundevenf128@PLT
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: roundeven:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $52, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, (%esp)
; X86-NEXT:    calll roundevenf128
; X86-NEXT:    subl $4, %esp
; X86-NEXT:    movaps {{[0-9]+}}(%esp), %xmm0
; X86-NEXT:    movaps %xmm0, (%esi)
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    addl $52, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    retl $4
;
; WIN-LABEL: roundeven:
; WIN:       # %bb.0: # %entry
; WIN-NEXT:    subq $56, %rsp
; WIN-NEXT:    movaps (%rcx), %xmm0
; WIN-NEXT:    movaps %xmm0, {{[0-9]+}}(%rsp)
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; WIN-NEXT:    callq roundevenl
; WIN-NEXT:    addq $56, %rsp
; WIN-NEXT:    retq
;
; WIN-X86-LABEL: roundeven:
; WIN-X86:       # %bb.0: # %entry
; WIN-X86-NEXT:    pushl %ebp
; WIN-X86-NEXT:    movl %esp, %ebp
; WIN-X86-NEXT:    pushl %edi
; WIN-X86-NEXT:    pushl %esi
; WIN-X86-NEXT:    andl $-16, %esp
; WIN-X86-NEXT:    subl $48, %esp
; WIN-X86-NEXT:    movl 8(%ebp), %esi
; WIN-X86-NEXT:    movl 24(%ebp), %eax
; WIN-X86-NEXT:    movl 28(%ebp), %ecx
; WIN-X86-NEXT:    movl 32(%ebp), %edx
; WIN-X86-NEXT:    movl 36(%ebp), %edi
; WIN-X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl %eax, (%esp)
; WIN-X86-NEXT:    calll _roundevenl
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; WIN-X86-NEXT:    movl %edi, 8(%esi)
; WIN-X86-NEXT:    movl %edx, 12(%esi)
; WIN-X86-NEXT:    movl %eax, (%esi)
; WIN-X86-NEXT:    movl %ecx, 4(%esi)
; WIN-X86-NEXT:    movl %esi, %eax
; WIN-X86-NEXT:    leal -8(%ebp), %esp
; WIN-X86-NEXT:    popl %esi
; WIN-X86-NEXT:    popl %edi
; WIN-X86-NEXT:    popl %ebp
; WIN-X86-NEXT:    retl
entry:
  %roundeven = call fp128 @llvm.experimental.constrained.roundeven.f128(fp128 %x, metadata !"fpexcept.strict") #0
  ret fp128 %roundeven
}

define fp128 @asin(fp128 %x) nounwind strictfp {
; ANDROID-LABEL: asin:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq asinl@PLT
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: asin:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq asinf128@PLT
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: asin:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $52, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, (%esp)
; X86-NEXT:    calll asinf128
; X86-NEXT:    subl $4, %esp
; X86-NEXT:    movaps {{[0-9]+}}(%esp), %xmm0
; X86-NEXT:    movaps %xmm0, (%esi)
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    addl $52, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    retl $4
;
; WIN-LABEL: asin:
; WIN:       # %bb.0: # %entry
; WIN-NEXT:    subq $56, %rsp
; WIN-NEXT:    movaps (%rcx), %xmm0
; WIN-NEXT:    movaps %xmm0, {{[0-9]+}}(%rsp)
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; WIN-NEXT:    callq asinl
; WIN-NEXT:    addq $56, %rsp
; WIN-NEXT:    retq
;
; WIN-X86-LABEL: asin:
; WIN-X86:       # %bb.0: # %entry
; WIN-X86-NEXT:    pushl %ebp
; WIN-X86-NEXT:    movl %esp, %ebp
; WIN-X86-NEXT:    pushl %edi
; WIN-X86-NEXT:    pushl %esi
; WIN-X86-NEXT:    andl $-16, %esp
; WIN-X86-NEXT:    subl $48, %esp
; WIN-X86-NEXT:    movl 8(%ebp), %esi
; WIN-X86-NEXT:    movl 24(%ebp), %eax
; WIN-X86-NEXT:    movl 28(%ebp), %ecx
; WIN-X86-NEXT:    movl 32(%ebp), %edx
; WIN-X86-NEXT:    movl 36(%ebp), %edi
; WIN-X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl %eax, (%esp)
; WIN-X86-NEXT:    calll _asinl
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; WIN-X86-NEXT:    movl %edi, 8(%esi)
; WIN-X86-NEXT:    movl %edx, 12(%esi)
; WIN-X86-NEXT:    movl %eax, (%esi)
; WIN-X86-NEXT:    movl %ecx, 4(%esi)
; WIN-X86-NEXT:    movl %esi, %eax
; WIN-X86-NEXT:    leal -8(%ebp), %esp
; WIN-X86-NEXT:    popl %esi
; WIN-X86-NEXT:    popl %edi
; WIN-X86-NEXT:    popl %ebp
; WIN-X86-NEXT:    retl
entry:
  %asin = call fp128 @llvm.experimental.constrained.asin.f128(fp128 %x, metadata !"round.dynamic", metadata !"fpexcept.strict") #0
  ret fp128 %asin
}

define fp128 @sin(fp128 %x) nounwind strictfp {
; ANDROID-LABEL: sin:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq sinl@PLT
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: sin:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq sinf128@PLT
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: sin:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $52, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, (%esp)
; X86-NEXT:    calll sinf128
; X86-NEXT:    subl $4, %esp
; X86-NEXT:    movaps {{[0-9]+}}(%esp), %xmm0
; X86-NEXT:    movaps %xmm0, (%esi)
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    addl $52, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    retl $4
;
; WIN-LABEL: sin:
; WIN:       # %bb.0: # %entry
; WIN-NEXT:    subq $56, %rsp
; WIN-NEXT:    movaps (%rcx), %xmm0
; WIN-NEXT:    movaps %xmm0, {{[0-9]+}}(%rsp)
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; WIN-NEXT:    callq sinl
; WIN-NEXT:    addq $56, %rsp
; WIN-NEXT:    retq
;
; WIN-X86-LABEL: sin:
; WIN-X86:       # %bb.0: # %entry
; WIN-X86-NEXT:    pushl %ebp
; WIN-X86-NEXT:    movl %esp, %ebp
; WIN-X86-NEXT:    pushl %edi
; WIN-X86-NEXT:    pushl %esi
; WIN-X86-NEXT:    andl $-16, %esp
; WIN-X86-NEXT:    subl $48, %esp
; WIN-X86-NEXT:    movl 8(%ebp), %esi
; WIN-X86-NEXT:    movl 24(%ebp), %eax
; WIN-X86-NEXT:    movl 28(%ebp), %ecx
; WIN-X86-NEXT:    movl 32(%ebp), %edx
; WIN-X86-NEXT:    movl 36(%ebp), %edi
; WIN-X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl %eax, (%esp)
; WIN-X86-NEXT:    calll _sinl
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; WIN-X86-NEXT:    movl %edi, 8(%esi)
; WIN-X86-NEXT:    movl %edx, 12(%esi)
; WIN-X86-NEXT:    movl %eax, (%esi)
; WIN-X86-NEXT:    movl %ecx, 4(%esi)
; WIN-X86-NEXT:    movl %esi, %eax
; WIN-X86-NEXT:    leal -8(%ebp), %esp
; WIN-X86-NEXT:    popl %esi
; WIN-X86-NEXT:    popl %edi
; WIN-X86-NEXT:    popl %ebp
; WIN-X86-NEXT:    retl
entry:
  %sin = call fp128 @llvm.experimental.constrained.sin.f128(fp128 %x, metadata !"round.dynamic", metadata !"fpexcept.strict") #0
  ret fp128 %sin
}

define fp128 @sinh(fp128 %x) nounwind strictfp {
; ANDROID-LABEL: sinh:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq sinhl@PLT
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: sinh:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq sinhf128@PLT
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: sinh:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $52, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, (%esp)
; X86-NEXT:    calll sinhf128
; X86-NEXT:    subl $4, %esp
; X86-NEXT:    movaps {{[0-9]+}}(%esp), %xmm0
; X86-NEXT:    movaps %xmm0, (%esi)
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    addl $52, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    retl $4
;
; WIN-LABEL: sinh:
; WIN:       # %bb.0: # %entry
; WIN-NEXT:    subq $56, %rsp
; WIN-NEXT:    movaps (%rcx), %xmm0
; WIN-NEXT:    movaps %xmm0, {{[0-9]+}}(%rsp)
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; WIN-NEXT:    callq sinhl
; WIN-NEXT:    addq $56, %rsp
; WIN-NEXT:    retq
;
; WIN-X86-LABEL: sinh:
; WIN-X86:       # %bb.0: # %entry
; WIN-X86-NEXT:    pushl %ebp
; WIN-X86-NEXT:    movl %esp, %ebp
; WIN-X86-NEXT:    pushl %edi
; WIN-X86-NEXT:    pushl %esi
; WIN-X86-NEXT:    andl $-16, %esp
; WIN-X86-NEXT:    subl $48, %esp
; WIN-X86-NEXT:    movl 8(%ebp), %esi
; WIN-X86-NEXT:    movl 24(%ebp), %eax
; WIN-X86-NEXT:    movl 28(%ebp), %ecx
; WIN-X86-NEXT:    movl 32(%ebp), %edx
; WIN-X86-NEXT:    movl 36(%ebp), %edi
; WIN-X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl %eax, (%esp)
; WIN-X86-NEXT:    calll _sinhl
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; WIN-X86-NEXT:    movl %edi, 8(%esi)
; WIN-X86-NEXT:    movl %edx, 12(%esi)
; WIN-X86-NEXT:    movl %eax, (%esi)
; WIN-X86-NEXT:    movl %ecx, 4(%esi)
; WIN-X86-NEXT:    movl %esi, %eax
; WIN-X86-NEXT:    leal -8(%ebp), %esp
; WIN-X86-NEXT:    popl %esi
; WIN-X86-NEXT:    popl %edi
; WIN-X86-NEXT:    popl %ebp
; WIN-X86-NEXT:    retl
entry:
  %sinh = call fp128 @llvm.experimental.constrained.sinh.f128(fp128 %x, metadata !"round.dynamic", metadata !"fpexcept.strict") #0
  ret fp128 %sinh
}

define fp128 @sqrt(fp128 %x) nounwind strictfp {
; ANDROID-LABEL: sqrt:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq sqrtl@PLT
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: sqrt:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq sqrtf128@PLT
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: sqrt:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $52, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, (%esp)
; X86-NEXT:    calll sqrtf128
; X86-NEXT:    subl $4, %esp
; X86-NEXT:    movaps {{[0-9]+}}(%esp), %xmm0
; X86-NEXT:    movaps %xmm0, (%esi)
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    addl $52, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    retl $4
;
; WIN-LABEL: sqrt:
; WIN:       # %bb.0: # %entry
; WIN-NEXT:    subq $56, %rsp
; WIN-NEXT:    movaps (%rcx), %xmm0
; WIN-NEXT:    movaps %xmm0, {{[0-9]+}}(%rsp)
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; WIN-NEXT:    callq sqrtl
; WIN-NEXT:    addq $56, %rsp
; WIN-NEXT:    retq
;
; WIN-X86-LABEL: sqrt:
; WIN-X86:       # %bb.0: # %entry
; WIN-X86-NEXT:    pushl %ebp
; WIN-X86-NEXT:    movl %esp, %ebp
; WIN-X86-NEXT:    pushl %edi
; WIN-X86-NEXT:    pushl %esi
; WIN-X86-NEXT:    andl $-16, %esp
; WIN-X86-NEXT:    subl $48, %esp
; WIN-X86-NEXT:    movl 8(%ebp), %esi
; WIN-X86-NEXT:    movl 24(%ebp), %eax
; WIN-X86-NEXT:    movl 28(%ebp), %ecx
; WIN-X86-NEXT:    movl 32(%ebp), %edx
; WIN-X86-NEXT:    movl 36(%ebp), %edi
; WIN-X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl %eax, (%esp)
; WIN-X86-NEXT:    calll _sqrtl
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; WIN-X86-NEXT:    movl %edi, 8(%esi)
; WIN-X86-NEXT:    movl %edx, 12(%esi)
; WIN-X86-NEXT:    movl %eax, (%esi)
; WIN-X86-NEXT:    movl %ecx, 4(%esi)
; WIN-X86-NEXT:    movl %esi, %eax
; WIN-X86-NEXT:    leal -8(%ebp), %esp
; WIN-X86-NEXT:    popl %esi
; WIN-X86-NEXT:    popl %edi
; WIN-X86-NEXT:    popl %ebp
; WIN-X86-NEXT:    retl
entry:
  %sqrt = call fp128 @llvm.experimental.constrained.sqrt.f128(fp128 %x, metadata !"round.dynamic", metadata !"fpexcept.strict") #0
  ret fp128 %sqrt
}

define fp128 @atan(fp128 %x) nounwind strictfp {
; ANDROID-LABEL: atan:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq atanl@PLT
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: atan:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq atanf128@PLT
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: atan:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $52, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, (%esp)
; X86-NEXT:    calll atanf128
; X86-NEXT:    subl $4, %esp
; X86-NEXT:    movaps {{[0-9]+}}(%esp), %xmm0
; X86-NEXT:    movaps %xmm0, (%esi)
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    addl $52, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    retl $4
;
; WIN-LABEL: atan:
; WIN:       # %bb.0: # %entry
; WIN-NEXT:    subq $56, %rsp
; WIN-NEXT:    movaps (%rcx), %xmm0
; WIN-NEXT:    movaps %xmm0, {{[0-9]+}}(%rsp)
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; WIN-NEXT:    callq atanl
; WIN-NEXT:    addq $56, %rsp
; WIN-NEXT:    retq
;
; WIN-X86-LABEL: atan:
; WIN-X86:       # %bb.0: # %entry
; WIN-X86-NEXT:    pushl %ebp
; WIN-X86-NEXT:    movl %esp, %ebp
; WIN-X86-NEXT:    pushl %edi
; WIN-X86-NEXT:    pushl %esi
; WIN-X86-NEXT:    andl $-16, %esp
; WIN-X86-NEXT:    subl $48, %esp
; WIN-X86-NEXT:    movl 8(%ebp), %esi
; WIN-X86-NEXT:    movl 24(%ebp), %eax
; WIN-X86-NEXT:    movl 28(%ebp), %ecx
; WIN-X86-NEXT:    movl 32(%ebp), %edx
; WIN-X86-NEXT:    movl 36(%ebp), %edi
; WIN-X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl %eax, (%esp)
; WIN-X86-NEXT:    calll _atanl
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; WIN-X86-NEXT:    movl %edi, 8(%esi)
; WIN-X86-NEXT:    movl %edx, 12(%esi)
; WIN-X86-NEXT:    movl %eax, (%esi)
; WIN-X86-NEXT:    movl %ecx, 4(%esi)
; WIN-X86-NEXT:    movl %esi, %eax
; WIN-X86-NEXT:    leal -8(%ebp), %esp
; WIN-X86-NEXT:    popl %esi
; WIN-X86-NEXT:    popl %edi
; WIN-X86-NEXT:    popl %ebp
; WIN-X86-NEXT:    retl
entry:
  %atan = call fp128 @llvm.experimental.constrained.atan.f128(fp128 %x, metadata !"round.dynamic", metadata !"fpexcept.strict") #0
  ret fp128 %atan
}

define fp128 @atan2(fp128 %x, fp128 %y) nounwind strictfp {
; ANDROID-LABEL: atan2:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq atan2l@PLT
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: atan2:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq atan2f128@PLT
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: atan2:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %ebp
; X86-NEXT:    pushl %ebx
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $76, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ebp, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ebx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, (%esp)
; X86-NEXT:    calll atan2f128
; X86-NEXT:    subl $4, %esp
; X86-NEXT:    movaps {{[0-9]+}}(%esp), %xmm0
; X86-NEXT:    movaps %xmm0, (%esi)
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    addl $76, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    popl %ebx
; X86-NEXT:    popl %ebp
; X86-NEXT:    retl $4
;
; WIN-LABEL: atan2:
; WIN:       # %bb.0: # %entry
; WIN-NEXT:    subq $72, %rsp
; WIN-NEXT:    movaps (%rcx), %xmm0
; WIN-NEXT:    movaps (%rdx), %xmm1
; WIN-NEXT:    movaps %xmm1, {{[0-9]+}}(%rsp)
; WIN-NEXT:    movaps %xmm0, {{[0-9]+}}(%rsp)
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rdx
; WIN-NEXT:    callq atan2l
; WIN-NEXT:    addq $72, %rsp
; WIN-NEXT:    retq
;
; WIN-X86-LABEL: atan2:
; WIN-X86:       # %bb.0: # %entry
; WIN-X86-NEXT:    pushl %ebp
; WIN-X86-NEXT:    movl %esp, %ebp
; WIN-X86-NEXT:    pushl %ebx
; WIN-X86-NEXT:    pushl %edi
; WIN-X86-NEXT:    pushl %esi
; WIN-X86-NEXT:    andl $-16, %esp
; WIN-X86-NEXT:    subl $80, %esp
; WIN-X86-NEXT:    movl 8(%ebp), %esi
; WIN-X86-NEXT:    movl 36(%ebp), %edi
; WIN-X86-NEXT:    movl 40(%ebp), %ebx
; WIN-X86-NEXT:    movl 44(%ebp), %edx
; WIN-X86-NEXT:    movl 48(%ebp), %ecx
; WIN-X86-NEXT:    movl 52(%ebp), %eax
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %ebx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl 32(%ebp), %eax
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl 28(%ebp), %eax
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl 24(%ebp), %eax
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl %eax, (%esp)
; WIN-X86-NEXT:    calll _atan2l
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; WIN-X86-NEXT:    movl %edi, 8(%esi)
; WIN-X86-NEXT:    movl %edx, 12(%esi)
; WIN-X86-NEXT:    movl %eax, (%esi)
; WIN-X86-NEXT:    movl %ecx, 4(%esi)
; WIN-X86-NEXT:    movl %esi, %eax
; WIN-X86-NEXT:    leal -12(%ebp), %esp
; WIN-X86-NEXT:    popl %esi
; WIN-X86-NEXT:    popl %edi
; WIN-X86-NEXT:    popl %ebx
; WIN-X86-NEXT:    popl %ebp
; WIN-X86-NEXT:    retl
entry:
  %atan2 = call fp128 @llvm.experimental.constrained.atan2.f128(fp128 %x, fp128 %y, metadata !"round.dynamic", metadata !"fpexcept.strict") #0
  ret fp128 %atan2
}

define fp128 @tan(fp128 %x) nounwind strictfp {
; ANDROID-LABEL: tan:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq tanl@PLT
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: tan:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq tanf128@PLT
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: tan:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $52, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, (%esp)
; X86-NEXT:    calll tanf128
; X86-NEXT:    subl $4, %esp
; X86-NEXT:    movaps {{[0-9]+}}(%esp), %xmm0
; X86-NEXT:    movaps %xmm0, (%esi)
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    addl $52, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    retl $4
;
; WIN-LABEL: tan:
; WIN:       # %bb.0: # %entry
; WIN-NEXT:    subq $56, %rsp
; WIN-NEXT:    movaps (%rcx), %xmm0
; WIN-NEXT:    movaps %xmm0, {{[0-9]+}}(%rsp)
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; WIN-NEXT:    callq tanl
; WIN-NEXT:    addq $56, %rsp
; WIN-NEXT:    retq
;
; WIN-X86-LABEL: tan:
; WIN-X86:       # %bb.0: # %entry
; WIN-X86-NEXT:    pushl %ebp
; WIN-X86-NEXT:    movl %esp, %ebp
; WIN-X86-NEXT:    pushl %edi
; WIN-X86-NEXT:    pushl %esi
; WIN-X86-NEXT:    andl $-16, %esp
; WIN-X86-NEXT:    subl $48, %esp
; WIN-X86-NEXT:    movl 8(%ebp), %esi
; WIN-X86-NEXT:    movl 24(%ebp), %eax
; WIN-X86-NEXT:    movl 28(%ebp), %ecx
; WIN-X86-NEXT:    movl 32(%ebp), %edx
; WIN-X86-NEXT:    movl 36(%ebp), %edi
; WIN-X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl %eax, (%esp)
; WIN-X86-NEXT:    calll _tanl
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; WIN-X86-NEXT:    movl %edi, 8(%esi)
; WIN-X86-NEXT:    movl %edx, 12(%esi)
; WIN-X86-NEXT:    movl %eax, (%esi)
; WIN-X86-NEXT:    movl %ecx, 4(%esi)
; WIN-X86-NEXT:    movl %esi, %eax
; WIN-X86-NEXT:    leal -8(%ebp), %esp
; WIN-X86-NEXT:    popl %esi
; WIN-X86-NEXT:    popl %edi
; WIN-X86-NEXT:    popl %ebp
; WIN-X86-NEXT:    retl
entry:
  %tan = call fp128 @llvm.experimental.constrained.tan.f128(fp128 %x, metadata !"round.dynamic", metadata !"fpexcept.strict") #0
  ret fp128 %tan
}

define fp128 @tanh(fp128 %x) nounwind strictfp {
; ANDROID-LABEL: tanh:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq tanhl@PLT
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: tanh:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq tanhf128@PLT
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: tanh:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $52, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, (%esp)
; X86-NEXT:    calll tanhf128
; X86-NEXT:    subl $4, %esp
; X86-NEXT:    movaps {{[0-9]+}}(%esp), %xmm0
; X86-NEXT:    movaps %xmm0, (%esi)
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    addl $52, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    retl $4
;
; WIN-LABEL: tanh:
; WIN:       # %bb.0: # %entry
; WIN-NEXT:    subq $56, %rsp
; WIN-NEXT:    movaps (%rcx), %xmm0
; WIN-NEXT:    movaps %xmm0, {{[0-9]+}}(%rsp)
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; WIN-NEXT:    callq tanhl
; WIN-NEXT:    addq $56, %rsp
; WIN-NEXT:    retq
;
; WIN-X86-LABEL: tanh:
; WIN-X86:       # %bb.0: # %entry
; WIN-X86-NEXT:    pushl %ebp
; WIN-X86-NEXT:    movl %esp, %ebp
; WIN-X86-NEXT:    pushl %edi
; WIN-X86-NEXT:    pushl %esi
; WIN-X86-NEXT:    andl $-16, %esp
; WIN-X86-NEXT:    subl $48, %esp
; WIN-X86-NEXT:    movl 8(%ebp), %esi
; WIN-X86-NEXT:    movl 24(%ebp), %eax
; WIN-X86-NEXT:    movl 28(%ebp), %ecx
; WIN-X86-NEXT:    movl 32(%ebp), %edx
; WIN-X86-NEXT:    movl 36(%ebp), %edi
; WIN-X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl %eax, (%esp)
; WIN-X86-NEXT:    calll _tanhl
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; WIN-X86-NEXT:    movl %edi, 8(%esi)
; WIN-X86-NEXT:    movl %edx, 12(%esi)
; WIN-X86-NEXT:    movl %eax, (%esi)
; WIN-X86-NEXT:    movl %ecx, 4(%esi)
; WIN-X86-NEXT:    movl %esi, %eax
; WIN-X86-NEXT:    leal -8(%ebp), %esp
; WIN-X86-NEXT:    popl %esi
; WIN-X86-NEXT:    popl %edi
; WIN-X86-NEXT:    popl %ebp
; WIN-X86-NEXT:    retl
entry:
  %tanh = call fp128 @llvm.experimental.constrained.tanh.f128(fp128 %x, metadata !"round.dynamic", metadata !"fpexcept.strict") #0
  ret fp128 %tanh
}

define fp128 @trunc(fp128 %x) nounwind strictfp {
; ANDROID-LABEL: trunc:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq truncl@PLT
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: trunc:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq truncf128@PLT
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: trunc:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $52, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, (%esp)
; X86-NEXT:    calll truncf128
; X86-NEXT:    subl $4, %esp
; X86-NEXT:    movaps {{[0-9]+}}(%esp), %xmm0
; X86-NEXT:    movaps %xmm0, (%esi)
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    addl $52, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    retl $4
;
; WIN-LABEL: trunc:
; WIN:       # %bb.0: # %entry
; WIN-NEXT:    subq $56, %rsp
; WIN-NEXT:    movaps (%rcx), %xmm0
; WIN-NEXT:    movaps %xmm0, {{[0-9]+}}(%rsp)
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; WIN-NEXT:    callq truncl
; WIN-NEXT:    addq $56, %rsp
; WIN-NEXT:    retq
;
; WIN-X86-LABEL: trunc:
; WIN-X86:       # %bb.0: # %entry
; WIN-X86-NEXT:    pushl %ebp
; WIN-X86-NEXT:    movl %esp, %ebp
; WIN-X86-NEXT:    pushl %edi
; WIN-X86-NEXT:    pushl %esi
; WIN-X86-NEXT:    andl $-16, %esp
; WIN-X86-NEXT:    subl $48, %esp
; WIN-X86-NEXT:    movl 8(%ebp), %esi
; WIN-X86-NEXT:    movl 24(%ebp), %eax
; WIN-X86-NEXT:    movl 28(%ebp), %ecx
; WIN-X86-NEXT:    movl 32(%ebp), %edx
; WIN-X86-NEXT:    movl 36(%ebp), %edi
; WIN-X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl %eax, (%esp)
; WIN-X86-NEXT:    calll _truncl
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; WIN-X86-NEXT:    movl %edi, 8(%esi)
; WIN-X86-NEXT:    movl %edx, 12(%esi)
; WIN-X86-NEXT:    movl %eax, (%esi)
; WIN-X86-NEXT:    movl %ecx, 4(%esi)
; WIN-X86-NEXT:    movl %esi, %eax
; WIN-X86-NEXT:    leal -8(%ebp), %esp
; WIN-X86-NEXT:    popl %esi
; WIN-X86-NEXT:    popl %edi
; WIN-X86-NEXT:    popl %ebp
; WIN-X86-NEXT:    retl
entry:
  %trunc = call fp128 @llvm.experimental.constrained.trunc.f128(fp128 %x, metadata !"fpexcept.strict") #0
  ret fp128 %trunc
}

define i32 @lrint(fp128 %x) nounwind strictfp {
; ANDROID-LABEL: lrint:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq lrintl@PLT
; ANDROID-NEXT:    popq %rcx
; ANDROID-NEXT:    retq
;
; GNU-LABEL: lrint:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq lrintf128@PLT
; GNU-NEXT:    popq %rcx
; GNU-NEXT:    retq
;
; X86-LABEL: lrint:
; X86:       # %bb.0: # %entry
; X86-NEXT:    subl $12, %esp
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    calll lrintf128
; X86-NEXT:    addl $28, %esp
; X86-NEXT:    retl
;
; WIN-LABEL: lrint:
; WIN:       # %bb.0: # %entry
; WIN-NEXT:    subq $56, %rsp
; WIN-NEXT:    movaps (%rcx), %xmm0
; WIN-NEXT:    movaps %xmm0, {{[0-9]+}}(%rsp)
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; WIN-NEXT:    callq lrintl
; WIN-NEXT:    addq $56, %rsp
; WIN-NEXT:    retq
;
; WIN-X86-LABEL: lrint:
; WIN-X86:       # %bb.0: # %entry
; WIN-X86-NEXT:    pushl %ebp
; WIN-X86-NEXT:    movl %esp, %ebp
; WIN-X86-NEXT:    andl $-16, %esp
; WIN-X86-NEXT:    subl $16, %esp
; WIN-X86-NEXT:    pushl 20(%ebp)
; WIN-X86-NEXT:    pushl 16(%ebp)
; WIN-X86-NEXT:    pushl 12(%ebp)
; WIN-X86-NEXT:    pushl 8(%ebp)
; WIN-X86-NEXT:    calll _lrintl
; WIN-X86-NEXT:    addl $16, %esp
; WIN-X86-NEXT:    movl %ebp, %esp
; WIN-X86-NEXT:    popl %ebp
; WIN-X86-NEXT:    retl
entry:
  %rint = call i32 @llvm.experimental.constrained.lrint.i32.f128(fp128 %x, metadata !"round.dynamic", metadata !"fpexcept.strict") #0
  ret i32 %rint
}

define i64 @llrint(fp128 %x) nounwind strictfp {
; ANDROID-LABEL: llrint:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq llrintl@PLT
; ANDROID-NEXT:    popq %rcx
; ANDROID-NEXT:    retq
;
; GNU-LABEL: llrint:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq llrintf128@PLT
; GNU-NEXT:    popq %rcx
; GNU-NEXT:    retq
;
; X86-LABEL: llrint:
; X86:       # %bb.0: # %entry
; X86-NEXT:    subl $12, %esp
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    calll llrintf128
; X86-NEXT:    addl $28, %esp
; X86-NEXT:    retl
;
; WIN-LABEL: llrint:
; WIN:       # %bb.0: # %entry
; WIN-NEXT:    subq $56, %rsp
; WIN-NEXT:    movaps (%rcx), %xmm0
; WIN-NEXT:    movaps %xmm0, {{[0-9]+}}(%rsp)
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; WIN-NEXT:    callq llrintl
; WIN-NEXT:    addq $56, %rsp
; WIN-NEXT:    retq
;
; WIN-X86-LABEL: llrint:
; WIN-X86:       # %bb.0: # %entry
; WIN-X86-NEXT:    pushl %ebp
; WIN-X86-NEXT:    movl %esp, %ebp
; WIN-X86-NEXT:    andl $-16, %esp
; WIN-X86-NEXT:    subl $16, %esp
; WIN-X86-NEXT:    pushl 20(%ebp)
; WIN-X86-NEXT:    pushl 16(%ebp)
; WIN-X86-NEXT:    pushl 12(%ebp)
; WIN-X86-NEXT:    pushl 8(%ebp)
; WIN-X86-NEXT:    calll _llrintl
; WIN-X86-NEXT:    addl $16, %esp
; WIN-X86-NEXT:    movl %ebp, %esp
; WIN-X86-NEXT:    popl %ebp
; WIN-X86-NEXT:    retl
entry:
  %rint = call i64 @llvm.experimental.constrained.llrint.i64.f128(fp128 %x, metadata !"round.dynamic", metadata !"fpexcept.strict") #0
  ret i64 %rint
}

define i32 @lround(fp128 %x) nounwind strictfp {
; ANDROID-LABEL: lround:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq lroundl@PLT
; ANDROID-NEXT:    popq %rcx
; ANDROID-NEXT:    retq
;
; GNU-LABEL: lround:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq lroundf128@PLT
; GNU-NEXT:    popq %rcx
; GNU-NEXT:    retq
;
; X86-LABEL: lround:
; X86:       # %bb.0: # %entry
; X86-NEXT:    subl $12, %esp
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    calll lroundf128
; X86-NEXT:    addl $28, %esp
; X86-NEXT:    retl
;
; WIN-LABEL: lround:
; WIN:       # %bb.0: # %entry
; WIN-NEXT:    subq $56, %rsp
; WIN-NEXT:    movaps (%rcx), %xmm0
; WIN-NEXT:    movaps %xmm0, {{[0-9]+}}(%rsp)
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; WIN-NEXT:    callq lroundl
; WIN-NEXT:    addq $56, %rsp
; WIN-NEXT:    retq
;
; WIN-X86-LABEL: lround:
; WIN-X86:       # %bb.0: # %entry
; WIN-X86-NEXT:    pushl %ebp
; WIN-X86-NEXT:    movl %esp, %ebp
; WIN-X86-NEXT:    andl $-16, %esp
; WIN-X86-NEXT:    subl $16, %esp
; WIN-X86-NEXT:    pushl 20(%ebp)
; WIN-X86-NEXT:    pushl 16(%ebp)
; WIN-X86-NEXT:    pushl 12(%ebp)
; WIN-X86-NEXT:    pushl 8(%ebp)
; WIN-X86-NEXT:    calll _lroundl
; WIN-X86-NEXT:    addl $16, %esp
; WIN-X86-NEXT:    movl %ebp, %esp
; WIN-X86-NEXT:    popl %ebp
; WIN-X86-NEXT:    retl
entry:
  %round = call i32 @llvm.experimental.constrained.lround.i32.f128(fp128 %x, metadata !"fpexcept.strict") #0
  ret i32 %round
}

define i64 @llround(fp128 %x) nounwind strictfp {
; ANDROID-LABEL: llround:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq llroundl@PLT
; ANDROID-NEXT:    popq %rcx
; ANDROID-NEXT:    retq
;
; GNU-LABEL: llround:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq llroundf128@PLT
; GNU-NEXT:    popq %rcx
; GNU-NEXT:    retq
;
; X86-LABEL: llround:
; X86:       # %bb.0: # %entry
; X86-NEXT:    subl $12, %esp
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    calll llroundf128
; X86-NEXT:    addl $28, %esp
; X86-NEXT:    retl
;
; WIN-LABEL: llround:
; WIN:       # %bb.0: # %entry
; WIN-NEXT:    subq $56, %rsp
; WIN-NEXT:    movaps (%rcx), %xmm0
; WIN-NEXT:    movaps %xmm0, {{[0-9]+}}(%rsp)
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; WIN-NEXT:    callq llroundl
; WIN-NEXT:    addq $56, %rsp
; WIN-NEXT:    retq
;
; WIN-X86-LABEL: llround:
; WIN-X86:       # %bb.0: # %entry
; WIN-X86-NEXT:    pushl %ebp
; WIN-X86-NEXT:    movl %esp, %ebp
; WIN-X86-NEXT:    andl $-16, %esp
; WIN-X86-NEXT:    subl $16, %esp
; WIN-X86-NEXT:    pushl 20(%ebp)
; WIN-X86-NEXT:    pushl 16(%ebp)
; WIN-X86-NEXT:    pushl 12(%ebp)
; WIN-X86-NEXT:    pushl 8(%ebp)
; WIN-X86-NEXT:    calll _llroundl
; WIN-X86-NEXT:    addl $16, %esp
; WIN-X86-NEXT:    movl %ebp, %esp
; WIN-X86-NEXT:    popl %ebp
; WIN-X86-NEXT:    retl
entry:
  %round = call i64 @llvm.experimental.constrained.llround.i64.f128(fp128 %x, metadata !"fpexcept.strict") #0
  ret i64 %round
}

define i64 @cmp(i64 %a, i64 %b, fp128 %x, fp128 %y) #0 {
; CHECK-LABEL: cmp:
; CHECK:       # %bb.0:
; CHECK-NEXT:    pushq %r14
; CHECK-NEXT:    pushq %rbx
; CHECK-NEXT:    pushq %rax
; CHECK-NEXT:    movq %rsi, %rbx
; CHECK-NEXT:    movq %rdi, %r14
; CHECK-NEXT:    callq __eqtf2@PLT
; CHECK-NEXT:    testl %eax, %eax
; CHECK-NEXT:    cmovneq %rbx, %r14
; CHECK-NEXT:    movq %r14, %rax
; CHECK-NEXT:    addq $8, %rsp
; CHECK-NEXT:    popq %rbx
; CHECK-NEXT:    popq %r14
; CHECK-NEXT:    retq
;
; ANDROID-LABEL: cmp:
; ANDROID:       # %bb.0:
; ANDROID-NEXT:    pushq %r14
; ANDROID-NEXT:    pushq %rbx
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    movq %rsi, %rbx
; ANDROID-NEXT:    movq %rdi, %r14
; ANDROID-NEXT:    callq __eqtf2@PLT
; ANDROID-NEXT:    testl %eax, %eax
; ANDROID-NEXT:    cmovneq %rbx, %r14
; ANDROID-NEXT:    movq %r14, %rax
; ANDROID-NEXT:    addq $8, %rsp
; ANDROID-NEXT:    popq %rbx
; ANDROID-NEXT:    popq %r14
; ANDROID-NEXT:    retq
;
; GNU-LABEL: cmp:
; GNU:       # %bb.0:
; GNU-NEXT:    pushq %r14
; GNU-NEXT:    pushq %rbx
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    movq %rsi, %rbx
; GNU-NEXT:    movq %rdi, %r14
; GNU-NEXT:    callq __eqtf2@PLT
; GNU-NEXT:    testl %eax, %eax
; GNU-NEXT:    cmovneq %rbx, %r14
; GNU-NEXT:    movq %r14, %rax
; GNU-NEXT:    addq $8, %rsp
; GNU-NEXT:    popq %rbx
; GNU-NEXT:    popq %r14
; GNU-NEXT:    retq
;
; X86-LABEL: cmp:
; X86:       # %bb.0:
; X86-NEXT:    subl $12, %esp
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    calll __eqtf2
; X86-NEXT:    addl $32, %esp
; X86-NEXT:    testl %eax, %eax
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    leal {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    cmovel %eax, %ecx
; X86-NEXT:    movl (%ecx), %eax
; X86-NEXT:    movl 4(%ecx), %edx
; X86-NEXT:    addl $12, %esp
; X86-NEXT:    retl
;
; WIN-LABEL: cmp:
; WIN:       # %bb.0:
; WIN-NEXT:    pushq %rsi
; WIN-NEXT:    pushq %rdi
; WIN-NEXT:    subq $72, %rsp
; WIN-NEXT:    movq %rdx, %rsi
; WIN-NEXT:    movq %rcx, %rdi
; WIN-NEXT:    movaps (%r8), %xmm0
; WIN-NEXT:    movaps (%r9), %xmm1
; WIN-NEXT:    movaps %xmm1, {{[0-9]+}}(%rsp)
; WIN-NEXT:    movaps %xmm0, {{[0-9]+}}(%rsp)
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rdx
; WIN-NEXT:    callq __eqtf2
; WIN-NEXT:    testl %eax, %eax
; WIN-NEXT:    cmovneq %rsi, %rdi
; WIN-NEXT:    movq %rdi, %rax
; WIN-NEXT:    addq $72, %rsp
; WIN-NEXT:    popq %rdi
; WIN-NEXT:    popq %rsi
; WIN-NEXT:    retq
;
; WIN-X86-LABEL: cmp:
; WIN-X86:       # %bb.0:
; WIN-X86-NEXT:    pushl %ebp
; WIN-X86-NEXT:    movl %esp, %ebp
; WIN-X86-NEXT:    andl $-16, %esp
; WIN-X86-NEXT:    subl $16, %esp
; WIN-X86-NEXT:    pushl 52(%ebp)
; WIN-X86-NEXT:    pushl 48(%ebp)
; WIN-X86-NEXT:    pushl 44(%ebp)
; WIN-X86-NEXT:    pushl 40(%ebp)
; WIN-X86-NEXT:    pushl 36(%ebp)
; WIN-X86-NEXT:    pushl 32(%ebp)
; WIN-X86-NEXT:    pushl 28(%ebp)
; WIN-X86-NEXT:    pushl 24(%ebp)
; WIN-X86-NEXT:    calll ___eqtf2
; WIN-X86-NEXT:    addl $32, %esp
; WIN-X86-NEXT:    testl %eax, %eax
; WIN-X86-NEXT:    je LBB37_1
; WIN-X86-NEXT:  # %bb.2:
; WIN-X86-NEXT:    leal 16(%ebp), %ecx
; WIN-X86-NEXT:    jmp LBB37_3
; WIN-X86-NEXT:  LBB37_1:
; WIN-X86-NEXT:    leal 8(%ebp), %ecx
; WIN-X86-NEXT:  LBB37_3:
; WIN-X86-NEXT:    movl (%ecx), %eax
; WIN-X86-NEXT:    movl 4(%ecx), %edx
; WIN-X86-NEXT:    movl %ebp, %esp
; WIN-X86-NEXT:    popl %ebp
; WIN-X86-NEXT:    retl
  %cond = call i1 @llvm.experimental.constrained.fcmp.f128(
                                               fp128 %x, fp128 %y,
                                               metadata !"oeq",
                                               metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i64 %a, i64 %b
  ret i64 %res
}

define i64 @cmps(i64 %a, i64 %b, fp128 %x, fp128 %y) #0 {
; CHECK-LABEL: cmps:
; CHECK:       # %bb.0:
; CHECK-NEXT:    pushq %r14
; CHECK-NEXT:    pushq %rbx
; CHECK-NEXT:    pushq %rax
; CHECK-NEXT:    movq %rsi, %rbx
; CHECK-NEXT:    movq %rdi, %r14
; CHECK-NEXT:    callq __eqtf2@PLT
; CHECK-NEXT:    testl %eax, %eax
; CHECK-NEXT:    cmovneq %rbx, %r14
; CHECK-NEXT:    movq %r14, %rax
; CHECK-NEXT:    addq $8, %rsp
; CHECK-NEXT:    popq %rbx
; CHECK-NEXT:    popq %r14
; CHECK-NEXT:    retq
;
; ANDROID-LABEL: cmps:
; ANDROID:       # %bb.0:
; ANDROID-NEXT:    pushq %r14
; ANDROID-NEXT:    pushq %rbx
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    movq %rsi, %rbx
; ANDROID-NEXT:    movq %rdi, %r14
; ANDROID-NEXT:    callq __eqtf2@PLT
; ANDROID-NEXT:    testl %eax, %eax
; ANDROID-NEXT:    cmovneq %rbx, %r14
; ANDROID-NEXT:    movq %r14, %rax
; ANDROID-NEXT:    addq $8, %rsp
; ANDROID-NEXT:    popq %rbx
; ANDROID-NEXT:    popq %r14
; ANDROID-NEXT:    retq
;
; GNU-LABEL: cmps:
; GNU:       # %bb.0:
; GNU-NEXT:    pushq %r14
; GNU-NEXT:    pushq %rbx
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    movq %rsi, %rbx
; GNU-NEXT:    movq %rdi, %r14
; GNU-NEXT:    callq __eqtf2@PLT
; GNU-NEXT:    testl %eax, %eax
; GNU-NEXT:    cmovneq %rbx, %r14
; GNU-NEXT:    movq %r14, %rax
; GNU-NEXT:    addq $8, %rsp
; GNU-NEXT:    popq %rbx
; GNU-NEXT:    popq %r14
; GNU-NEXT:    retq
;
; X86-LABEL: cmps:
; X86:       # %bb.0:
; X86-NEXT:    subl $12, %esp
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    calll __eqtf2
; X86-NEXT:    addl $32, %esp
; X86-NEXT:    testl %eax, %eax
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    leal {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    cmovel %eax, %ecx
; X86-NEXT:    movl (%ecx), %eax
; X86-NEXT:    movl 4(%ecx), %edx
; X86-NEXT:    addl $12, %esp
; X86-NEXT:    retl
;
; WIN-LABEL: cmps:
; WIN:       # %bb.0:
; WIN-NEXT:    pushq %rsi
; WIN-NEXT:    pushq %rdi
; WIN-NEXT:    subq $72, %rsp
; WIN-NEXT:    movq %rdx, %rsi
; WIN-NEXT:    movq %rcx, %rdi
; WIN-NEXT:    movaps (%r8), %xmm0
; WIN-NEXT:    movaps (%r9), %xmm1
; WIN-NEXT:    movaps %xmm1, {{[0-9]+}}(%rsp)
; WIN-NEXT:    movaps %xmm0, {{[0-9]+}}(%rsp)
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rdx
; WIN-NEXT:    callq __eqtf2
; WIN-NEXT:    testl %eax, %eax
; WIN-NEXT:    cmovneq %rsi, %rdi
; WIN-NEXT:    movq %rdi, %rax
; WIN-NEXT:    addq $72, %rsp
; WIN-NEXT:    popq %rdi
; WIN-NEXT:    popq %rsi
; WIN-NEXT:    retq
;
; WIN-X86-LABEL: cmps:
; WIN-X86:       # %bb.0:
; WIN-X86-NEXT:    pushl %ebp
; WIN-X86-NEXT:    movl %esp, %ebp
; WIN-X86-NEXT:    andl $-16, %esp
; WIN-X86-NEXT:    subl $16, %esp
; WIN-X86-NEXT:    pushl 52(%ebp)
; WIN-X86-NEXT:    pushl 48(%ebp)
; WIN-X86-NEXT:    pushl 44(%ebp)
; WIN-X86-NEXT:    pushl 40(%ebp)
; WIN-X86-NEXT:    pushl 36(%ebp)
; WIN-X86-NEXT:    pushl 32(%ebp)
; WIN-X86-NEXT:    pushl 28(%ebp)
; WIN-X86-NEXT:    pushl 24(%ebp)
; WIN-X86-NEXT:    calll ___eqtf2
; WIN-X86-NEXT:    addl $32, %esp
; WIN-X86-NEXT:    testl %eax, %eax
; WIN-X86-NEXT:    je LBB38_1
; WIN-X86-NEXT:  # %bb.2:
; WIN-X86-NEXT:    leal 16(%ebp), %ecx
; WIN-X86-NEXT:    jmp LBB38_3
; WIN-X86-NEXT:  LBB38_1:
; WIN-X86-NEXT:    leal 8(%ebp), %ecx
; WIN-X86-NEXT:  LBB38_3:
; WIN-X86-NEXT:    movl (%ecx), %eax
; WIN-X86-NEXT:    movl 4(%ecx), %edx
; WIN-X86-NEXT:    movl %ebp, %esp
; WIN-X86-NEXT:    popl %ebp
; WIN-X86-NEXT:    retl
  %cond = call i1 @llvm.experimental.constrained.fcmps.f128(
                                               fp128 %x, fp128 %y,
                                               metadata !"oeq",
                                               metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i64 %a, i64 %b
  ret i64 %res
}

define i64 @cmp_ueq_q(i64 %a, i64 %b, fp128 %x, fp128 %y) #0 {
; CHECK-LABEL: cmp_ueq_q:
; CHECK:       # %bb.0:
; CHECK-NEXT:    pushq %rbp
; CHECK-NEXT:    pushq %r14
; CHECK-NEXT:    pushq %rbx
; CHECK-NEXT:    subq $32, %rsp
; CHECK-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; CHECK-NEXT:    movaps %xmm0, (%rsp) # 16-byte Spill
; CHECK-NEXT:    movq %rsi, %rbx
; CHECK-NEXT:    movq %rdi, %r14
; CHECK-NEXT:    callq __eqtf2@PLT
; CHECK-NEXT:    testl %eax, %eax
; CHECK-NEXT:    sete %bpl
; CHECK-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; CHECK-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; CHECK-NEXT:    callq __unordtf2@PLT
; CHECK-NEXT:    testl %eax, %eax
; CHECK-NEXT:    setne %al
; CHECK-NEXT:    orb %bpl, %al
; CHECK-NEXT:    cmoveq %rbx, %r14
; CHECK-NEXT:    movq %r14, %rax
; CHECK-NEXT:    addq $32, %rsp
; CHECK-NEXT:    popq %rbx
; CHECK-NEXT:    popq %r14
; CHECK-NEXT:    popq %rbp
; CHECK-NEXT:    retq
;
; ANDROID-LABEL: cmp_ueq_q:
; ANDROID:       # %bb.0:
; ANDROID-NEXT:    pushq %rbp
; ANDROID-NEXT:    pushq %r14
; ANDROID-NEXT:    pushq %rbx
; ANDROID-NEXT:    subq $32, %rsp
; ANDROID-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; ANDROID-NEXT:    movaps %xmm0, (%rsp) # 16-byte Spill
; ANDROID-NEXT:    movq %rsi, %rbx
; ANDROID-NEXT:    movq %rdi, %r14
; ANDROID-NEXT:    callq __eqtf2@PLT
; ANDROID-NEXT:    testl %eax, %eax
; ANDROID-NEXT:    sete %bpl
; ANDROID-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; ANDROID-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; ANDROID-NEXT:    callq __unordtf2@PLT
; ANDROID-NEXT:    testl %eax, %eax
; ANDROID-NEXT:    setne %al
; ANDROID-NEXT:    orb %bpl, %al
; ANDROID-NEXT:    cmoveq %rbx, %r14
; ANDROID-NEXT:    movq %r14, %rax
; ANDROID-NEXT:    addq $32, %rsp
; ANDROID-NEXT:    popq %rbx
; ANDROID-NEXT:    popq %r14
; ANDROID-NEXT:    popq %rbp
; ANDROID-NEXT:    retq
;
; GNU-LABEL: cmp_ueq_q:
; GNU:       # %bb.0:
; GNU-NEXT:    pushq %rbp
; GNU-NEXT:    pushq %r14
; GNU-NEXT:    pushq %rbx
; GNU-NEXT:    subq $32, %rsp
; GNU-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; GNU-NEXT:    movaps %xmm0, (%rsp) # 16-byte Spill
; GNU-NEXT:    movq %rsi, %rbx
; GNU-NEXT:    movq %rdi, %r14
; GNU-NEXT:    callq __eqtf2@PLT
; GNU-NEXT:    testl %eax, %eax
; GNU-NEXT:    sete %bpl
; GNU-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; GNU-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; GNU-NEXT:    callq __unordtf2@PLT
; GNU-NEXT:    testl %eax, %eax
; GNU-NEXT:    setne %al
; GNU-NEXT:    orb %bpl, %al
; GNU-NEXT:    cmoveq %rbx, %r14
; GNU-NEXT:    movq %r14, %rax
; GNU-NEXT:    addq $32, %rsp
; GNU-NEXT:    popq %rbx
; GNU-NEXT:    popq %r14
; GNU-NEXT:    popq %rbp
; GNU-NEXT:    retq
;
; X86-LABEL: cmp_ueq_q:
; X86:       # %bb.0:
; X86-NEXT:    pushl %ebp
; X86-NEXT:    pushl %ebx
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $12, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl %esi
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %ebp
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    calll __eqtf2
; X86-NEXT:    addl $32, %esp
; X86-NEXT:    testl %eax, %eax
; X86-NEXT:    sete %bl
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl %esi
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %ebp
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    calll __unordtf2
; X86-NEXT:    addl $32, %esp
; X86-NEXT:    orb %bl, %al
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    leal {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    cmovnel %eax, %ecx
; X86-NEXT:    movl (%ecx), %eax
; X86-NEXT:    movl 4(%ecx), %edx
; X86-NEXT:    addl $12, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    popl %ebx
; X86-NEXT:    popl %ebp
; X86-NEXT:    retl
;
; WIN-LABEL: cmp_ueq_q:
; WIN:       # %bb.0:
; WIN-NEXT:    pushq %rsi
; WIN-NEXT:    pushq %rdi
; WIN-NEXT:    pushq %rbx
; WIN-NEXT:    subq $128, %rsp
; WIN-NEXT:    movaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; WIN-NEXT:    movaps %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; WIN-NEXT:    movq %rdx, %rsi
; WIN-NEXT:    movq %rcx, %rdi
; WIN-NEXT:    movaps (%r8), %xmm6
; WIN-NEXT:    movaps (%r9), %xmm7
; WIN-NEXT:    movaps %xmm7, {{[0-9]+}}(%rsp)
; WIN-NEXT:    movaps %xmm6, {{[0-9]+}}(%rsp)
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rdx
; WIN-NEXT:    callq __eqtf2
; WIN-NEXT:    movaps %xmm7, {{[0-9]+}}(%rsp)
; WIN-NEXT:    movaps %xmm6, {{[0-9]+}}(%rsp)
; WIN-NEXT:    testl %eax, %eax
; WIN-NEXT:    sete %bl
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rdx
; WIN-NEXT:    callq __unordtf2
; WIN-NEXT:    testl %eax, %eax
; WIN-NEXT:    setne %al
; WIN-NEXT:    orb %bl, %al
; WIN-NEXT:    cmoveq %rsi, %rdi
; WIN-NEXT:    movq %rdi, %rax
; WIN-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Reload
; WIN-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; WIN-NEXT:    addq $128, %rsp
; WIN-NEXT:    popq %rbx
; WIN-NEXT:    popq %rdi
; WIN-NEXT:    popq %rsi
; WIN-NEXT:    retq
;
; WIN-X86-LABEL: cmp_ueq_q:
; WIN-X86:       # %bb.0:
; WIN-X86-NEXT:    pushl %ebp
; WIN-X86-NEXT:    movl %esp, %ebp
; WIN-X86-NEXT:    pushl %ebx
; WIN-X86-NEXT:    pushl %edi
; WIN-X86-NEXT:    pushl %esi
; WIN-X86-NEXT:    andl $-16, %esp
; WIN-X86-NEXT:    subl $16, %esp
; WIN-X86-NEXT:    movl 32(%ebp), %edi
; WIN-X86-NEXT:    movl 36(%ebp), %esi
; WIN-X86-NEXT:    pushl 52(%ebp)
; WIN-X86-NEXT:    pushl 48(%ebp)
; WIN-X86-NEXT:    pushl 44(%ebp)
; WIN-X86-NEXT:    pushl 40(%ebp)
; WIN-X86-NEXT:    pushl %esi
; WIN-X86-NEXT:    pushl %edi
; WIN-X86-NEXT:    pushl 28(%ebp)
; WIN-X86-NEXT:    pushl 24(%ebp)
; WIN-X86-NEXT:    calll ___eqtf2
; WIN-X86-NEXT:    addl $32, %esp
; WIN-X86-NEXT:    testl %eax, %eax
; WIN-X86-NEXT:    sete %bl
; WIN-X86-NEXT:    pushl 52(%ebp)
; WIN-X86-NEXT:    pushl 48(%ebp)
; WIN-X86-NEXT:    pushl 44(%ebp)
; WIN-X86-NEXT:    pushl 40(%ebp)
; WIN-X86-NEXT:    pushl %esi
; WIN-X86-NEXT:    pushl %edi
; WIN-X86-NEXT:    pushl 28(%ebp)
; WIN-X86-NEXT:    pushl 24(%ebp)
; WIN-X86-NEXT:    calll ___unordtf2
; WIN-X86-NEXT:    addl $32, %esp
; WIN-X86-NEXT:    orb %bl, %al
; WIN-X86-NEXT:    jne LBB39_1
; WIN-X86-NEXT:  # %bb.2:
; WIN-X86-NEXT:    leal 16(%ebp), %ecx
; WIN-X86-NEXT:    jmp LBB39_3
; WIN-X86-NEXT:  LBB39_1:
; WIN-X86-NEXT:    leal 8(%ebp), %ecx
; WIN-X86-NEXT:  LBB39_3:
; WIN-X86-NEXT:    movl (%ecx), %eax
; WIN-X86-NEXT:    movl 4(%ecx), %edx
; WIN-X86-NEXT:    leal -12(%ebp), %esp
; WIN-X86-NEXT:    popl %esi
; WIN-X86-NEXT:    popl %edi
; WIN-X86-NEXT:    popl %ebx
; WIN-X86-NEXT:    popl %ebp
; WIN-X86-NEXT:    retl
  %cond = call i1 @llvm.experimental.constrained.fcmp.f128(
                                               fp128 %x, fp128 %y,
                                               metadata !"ueq",
                                               metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i64 %a, i64 %b
  ret i64 %res
}

define i64 @cmp_one_q(i64 %a, i64 %b, fp128 %x, fp128 %y) #0 {
; CHECK-LABEL: cmp_one_q:
; CHECK:       # %bb.0:
; CHECK-NEXT:    pushq %rbp
; CHECK-NEXT:    pushq %r14
; CHECK-NEXT:    pushq %rbx
; CHECK-NEXT:    subq $32, %rsp
; CHECK-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; CHECK-NEXT:    movaps %xmm0, (%rsp) # 16-byte Spill
; CHECK-NEXT:    movq %rsi, %rbx
; CHECK-NEXT:    movq %rdi, %r14
; CHECK-NEXT:    callq __eqtf2@PLT
; CHECK-NEXT:    testl %eax, %eax
; CHECK-NEXT:    setne %bpl
; CHECK-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; CHECK-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; CHECK-NEXT:    callq __unordtf2@PLT
; CHECK-NEXT:    testl %eax, %eax
; CHECK-NEXT:    sete %al
; CHECK-NEXT:    testb %bpl, %al
; CHECK-NEXT:    cmoveq %rbx, %r14
; CHECK-NEXT:    movq %r14, %rax
; CHECK-NEXT:    addq $32, %rsp
; CHECK-NEXT:    popq %rbx
; CHECK-NEXT:    popq %r14
; CHECK-NEXT:    popq %rbp
; CHECK-NEXT:    retq
;
; ANDROID-LABEL: cmp_one_q:
; ANDROID:       # %bb.0:
; ANDROID-NEXT:    pushq %rbp
; ANDROID-NEXT:    pushq %r14
; ANDROID-NEXT:    pushq %rbx
; ANDROID-NEXT:    subq $32, %rsp
; ANDROID-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; ANDROID-NEXT:    movaps %xmm0, (%rsp) # 16-byte Spill
; ANDROID-NEXT:    movq %rsi, %rbx
; ANDROID-NEXT:    movq %rdi, %r14
; ANDROID-NEXT:    callq __eqtf2@PLT
; ANDROID-NEXT:    testl %eax, %eax
; ANDROID-NEXT:    setne %bpl
; ANDROID-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; ANDROID-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; ANDROID-NEXT:    callq __unordtf2@PLT
; ANDROID-NEXT:    testl %eax, %eax
; ANDROID-NEXT:    sete %al
; ANDROID-NEXT:    testb %bpl, %al
; ANDROID-NEXT:    cmoveq %rbx, %r14
; ANDROID-NEXT:    movq %r14, %rax
; ANDROID-NEXT:    addq $32, %rsp
; ANDROID-NEXT:    popq %rbx
; ANDROID-NEXT:    popq %r14
; ANDROID-NEXT:    popq %rbp
; ANDROID-NEXT:    retq
;
; GNU-LABEL: cmp_one_q:
; GNU:       # %bb.0:
; GNU-NEXT:    pushq %rbp
; GNU-NEXT:    pushq %r14
; GNU-NEXT:    pushq %rbx
; GNU-NEXT:    subq $32, %rsp
; GNU-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; GNU-NEXT:    movaps %xmm0, (%rsp) # 16-byte Spill
; GNU-NEXT:    movq %rsi, %rbx
; GNU-NEXT:    movq %rdi, %r14
; GNU-NEXT:    callq __eqtf2@PLT
; GNU-NEXT:    testl %eax, %eax
; GNU-NEXT:    setne %bpl
; GNU-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; GNU-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; GNU-NEXT:    callq __unordtf2@PLT
; GNU-NEXT:    testl %eax, %eax
; GNU-NEXT:    sete %al
; GNU-NEXT:    testb %bpl, %al
; GNU-NEXT:    cmoveq %rbx, %r14
; GNU-NEXT:    movq %r14, %rax
; GNU-NEXT:    addq $32, %rsp
; GNU-NEXT:    popq %rbx
; GNU-NEXT:    popq %r14
; GNU-NEXT:    popq %rbp
; GNU-NEXT:    retq
;
; X86-LABEL: cmp_one_q:
; X86:       # %bb.0:
; X86-NEXT:    pushl %ebp
; X86-NEXT:    pushl %ebx
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $12, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl %esi
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %ebp
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    calll __eqtf2
; X86-NEXT:    addl $32, %esp
; X86-NEXT:    testl %eax, %eax
; X86-NEXT:    setne %bl
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl %esi
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %ebp
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    calll __unordtf2
; X86-NEXT:    addl $32, %esp
; X86-NEXT:    testl %eax, %eax
; X86-NEXT:    sete %al
; X86-NEXT:    testb %bl, %al
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    leal {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    cmovnel %eax, %ecx
; X86-NEXT:    movl (%ecx), %eax
; X86-NEXT:    movl 4(%ecx), %edx
; X86-NEXT:    addl $12, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    popl %ebx
; X86-NEXT:    popl %ebp
; X86-NEXT:    retl
;
; WIN-LABEL: cmp_one_q:
; WIN:       # %bb.0:
; WIN-NEXT:    pushq %rsi
; WIN-NEXT:    pushq %rdi
; WIN-NEXT:    pushq %rbx
; WIN-NEXT:    subq $128, %rsp
; WIN-NEXT:    movaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; WIN-NEXT:    movaps %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; WIN-NEXT:    movq %rdx, %rsi
; WIN-NEXT:    movq %rcx, %rdi
; WIN-NEXT:    movaps (%r8), %xmm6
; WIN-NEXT:    movaps (%r9), %xmm7
; WIN-NEXT:    movaps %xmm7, {{[0-9]+}}(%rsp)
; WIN-NEXT:    movaps %xmm6, {{[0-9]+}}(%rsp)
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rdx
; WIN-NEXT:    callq __eqtf2
; WIN-NEXT:    movaps %xmm7, {{[0-9]+}}(%rsp)
; WIN-NEXT:    movaps %xmm6, {{[0-9]+}}(%rsp)
; WIN-NEXT:    testl %eax, %eax
; WIN-NEXT:    setne %bl
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rdx
; WIN-NEXT:    callq __unordtf2
; WIN-NEXT:    testl %eax, %eax
; WIN-NEXT:    sete %al
; WIN-NEXT:    testb %bl, %al
; WIN-NEXT:    cmoveq %rsi, %rdi
; WIN-NEXT:    movq %rdi, %rax
; WIN-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Reload
; WIN-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; WIN-NEXT:    addq $128, %rsp
; WIN-NEXT:    popq %rbx
; WIN-NEXT:    popq %rdi
; WIN-NEXT:    popq %rsi
; WIN-NEXT:    retq
;
; WIN-X86-LABEL: cmp_one_q:
; WIN-X86:       # %bb.0:
; WIN-X86-NEXT:    pushl %ebp
; WIN-X86-NEXT:    movl %esp, %ebp
; WIN-X86-NEXT:    pushl %ebx
; WIN-X86-NEXT:    pushl %edi
; WIN-X86-NEXT:    pushl %esi
; WIN-X86-NEXT:    andl $-16, %esp
; WIN-X86-NEXT:    subl $16, %esp
; WIN-X86-NEXT:    movl 32(%ebp), %edi
; WIN-X86-NEXT:    movl 36(%ebp), %esi
; WIN-X86-NEXT:    pushl 52(%ebp)
; WIN-X86-NEXT:    pushl 48(%ebp)
; WIN-X86-NEXT:    pushl 44(%ebp)
; WIN-X86-NEXT:    pushl 40(%ebp)
; WIN-X86-NEXT:    pushl %esi
; WIN-X86-NEXT:    pushl %edi
; WIN-X86-NEXT:    pushl 28(%ebp)
; WIN-X86-NEXT:    pushl 24(%ebp)
; WIN-X86-NEXT:    calll ___eqtf2
; WIN-X86-NEXT:    addl $32, %esp
; WIN-X86-NEXT:    testl %eax, %eax
; WIN-X86-NEXT:    setne %bl
; WIN-X86-NEXT:    pushl 52(%ebp)
; WIN-X86-NEXT:    pushl 48(%ebp)
; WIN-X86-NEXT:    pushl 44(%ebp)
; WIN-X86-NEXT:    pushl 40(%ebp)
; WIN-X86-NEXT:    pushl %esi
; WIN-X86-NEXT:    pushl %edi
; WIN-X86-NEXT:    pushl 28(%ebp)
; WIN-X86-NEXT:    pushl 24(%ebp)
; WIN-X86-NEXT:    calll ___unordtf2
; WIN-X86-NEXT:    addl $32, %esp
; WIN-X86-NEXT:    testl %eax, %eax
; WIN-X86-NEXT:    sete %al
; WIN-X86-NEXT:    testb %bl, %al
; WIN-X86-NEXT:    jne LBB40_1
; WIN-X86-NEXT:  # %bb.2:
; WIN-X86-NEXT:    leal 16(%ebp), %ecx
; WIN-X86-NEXT:    jmp LBB40_3
; WIN-X86-NEXT:  LBB40_1:
; WIN-X86-NEXT:    leal 8(%ebp), %ecx
; WIN-X86-NEXT:  LBB40_3:
; WIN-X86-NEXT:    movl (%ecx), %eax
; WIN-X86-NEXT:    movl 4(%ecx), %edx
; WIN-X86-NEXT:    leal -12(%ebp), %esp
; WIN-X86-NEXT:    popl %esi
; WIN-X86-NEXT:    popl %edi
; WIN-X86-NEXT:    popl %ebx
; WIN-X86-NEXT:    popl %ebp
; WIN-X86-NEXT:    retl
  %cond = call i1 @llvm.experimental.constrained.fcmp.f128(
                                               fp128 %x, fp128 %y,
                                               metadata !"one",
                                               metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i64 %a, i64 %b
  ret i64 %res
}

attributes #0 = { nounwind strictfp }

declare fp128 @llvm.experimental.constrained.fadd.f128(fp128, fp128, metadata, metadata)
declare fp128 @llvm.experimental.constrained.fsub.f128(fp128, fp128, metadata, metadata)
declare fp128 @llvm.experimental.constrained.fmul.f128(fp128, fp128, metadata, metadata)
declare fp128 @llvm.experimental.constrained.fdiv.f128(fp128, fp128, metadata, metadata)
declare fp128 @llvm.experimental.constrained.fma.f128(fp128, fp128, fp128, metadata, metadata)
declare fp128 @llvm.experimental.constrained.frem.f128(fp128, fp128, metadata, metadata)
declare fp128 @llvm.experimental.constrained.ceil.f128(fp128, metadata)
declare fp128 @llvm.experimental.constrained.acos.f128(fp128, metadata, metadata)
declare fp128 @llvm.experimental.constrained.cos.f128(fp128, metadata, metadata)
declare fp128 @llvm.experimental.constrained.cosh.f128(fp128, metadata, metadata)
declare fp128 @llvm.experimental.constrained.exp.f128(fp128, metadata, metadata)
declare fp128 @llvm.experimental.constrained.exp2.f128(fp128, metadata, metadata)
declare fp128 @llvm.experimental.constrained.floor.f128(fp128, metadata)
declare fp128 @llvm.experimental.constrained.log.f128(fp128, metadata, metadata)
declare fp128 @llvm.experimental.constrained.log10.f128(fp128, metadata, metadata)
declare fp128 @llvm.experimental.constrained.log2.f128(fp128, metadata, metadata)
declare fp128 @llvm.experimental.constrained.maxnum.f128(fp128, fp128, metadata)
declare fp128 @llvm.experimental.constrained.minnum.f128(fp128, fp128, metadata)
declare fp128 @llvm.experimental.constrained.nearbyint.f128(fp128, metadata, metadata)
declare fp128 @llvm.experimental.constrained.pow.f128(fp128, fp128, metadata, metadata)
declare fp128 @llvm.experimental.constrained.powi.f128(fp128, i32, metadata, metadata)
declare fp128 @llvm.experimental.constrained.rint.f128(fp128, metadata, metadata)
declare fp128 @llvm.experimental.constrained.round.f128(fp128, metadata)
declare fp128 @llvm.experimental.constrained.roundeven.f128(fp128, metadata)
declare fp128 @llvm.experimental.constrained.asin.f128(fp128, metadata, metadata)
declare fp128 @llvm.experimental.constrained.sin.f128(fp128, metadata, metadata)
declare fp128 @llvm.experimental.constrained.sinh.f128(fp128, metadata, metadata)
declare fp128 @llvm.experimental.constrained.sqrt.f128(fp128, metadata, metadata)
declare fp128 @llvm.experimental.constrained.atan.f128(fp128, metadata, metadata)
declare fp128 @llvm.experimental.constrained.atan2.f128(fp128, fp128, metadata, metadata)
declare fp128 @llvm.experimental.constrained.tan.f128(fp128, metadata, metadata)
declare fp128 @llvm.experimental.constrained.tanh.f128(fp128, metadata, metadata)
declare fp128 @llvm.experimental.constrained.trunc.f128(fp128, metadata)
declare i32 @llvm.experimental.constrained.lrint.i32.f128(fp128, metadata, metadata)
declare i64 @llvm.experimental.constrained.llrint.i64.f128(fp128, metadata, metadata)
declare i32 @llvm.experimental.constrained.lround.i32.f128(fp128, metadata)
declare i64 @llvm.experimental.constrained.llround.i64.f128(fp128, metadata)
declare i1 @llvm.experimental.constrained.fcmp.f128(fp128, fp128, metadata, metadata)
declare i1 @llvm.experimental.constrained.fcmps.f128(fp128, fp128, metadata, metadata)
