; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs -mcpu=sapphirerapids -mattr=+false-deps-getmant -mtriple=x86_64-unknown-unknown < %s | FileCheck %s --check-prefixes=ENABLE
; RUN: llc -verify-machineinstrs -mcpu=sapphirerapids -mattr=-false-deps-getmant -mtriple=x86_64-unknown-unknown < %s | FileCheck %s --check-prefixes=DISABLE

define <4 x float> @getmantps_mem_128(ptr %p0) {
; ENABLE-LABEL: getmantps_mem_128:
; ENABLE:       # %bb.0:
; ENABLE-NEXT:    #APP
; ENABLE-NEXT:    nop
; ENABLE-NEXT:    #NO_APP
; ENABLE-NEXT:    vxorps %xmm0, %xmm0, %xmm0
; ENABLE-NEXT:    vgetmantps $88, (%rdi), %xmm0
; ENABLE-NEXT:    retq
;
; DISABLE-LABEL: getmantps_mem_128:
; DISABLE:       # %bb.0:
; DISABLE-NEXT:    #APP
; DISABLE-NEXT:    nop
; DISABLE-NEXT:    #NO_APP
; DISABLE-NEXT:    vgetmantps $88, (%rdi), %xmm0
; DISABLE-NEXT:    retq
  %1 = tail call <2 x i64> asm sideeffect "nop", "=x,~{xmm1},~{xmm2},~{xmm3},~{xmm4},~{xmm5},~{xmm6},~{xmm7},~{xmm8},~{xmm9},~{xmm10},~{xmm11},~{xmm12},~{xmm13},~{xmm14},~{xmm15},~{xmm16},~{xmm17},~{xmm18},~{xmm19},~{xmm20},~{xmm21},~{xmm22},~{xmm23},~{xmm24},~{xmm25},~{xmm26},~{xmm27},~{xmm28},~{xmm29},~{xmm30},~{xmm31},~{flags}"()
  %a0 = load <4 x float>, ptr %p0, align 64
  %2 = call <4 x float> @llvm.x86.avx512.mask.getmant.ps.128(<4 x float> %a0, i32 88, <4 x float> undef, i8 -1)
  ret <4 x float> %2
}

define <4 x float> @getmantps_broadcast_128(ptr %p0) {
; ENABLE-LABEL: getmantps_broadcast_128:
; ENABLE:       # %bb.0:
; ENABLE-NEXT:    #APP
; ENABLE-NEXT:    nop
; ENABLE-NEXT:    #NO_APP
; ENABLE-NEXT:    vxorps %xmm0, %xmm0, %xmm0
; ENABLE-NEXT:    vgetmantps $88, (%rdi){1to4}, %xmm0
; ENABLE-NEXT:    retq
;
; DISABLE-LABEL: getmantps_broadcast_128:
; DISABLE:       # %bb.0:
; DISABLE-NEXT:    #APP
; DISABLE-NEXT:    nop
; DISABLE-NEXT:    #NO_APP
; DISABLE-NEXT:    vgetmantps $88, (%rdi){1to4}, %xmm0
; DISABLE-NEXT:    retq
  %1 = tail call <2 x i64> asm sideeffect "nop", "=x,~{xmm1},~{xmm2},~{xmm3},~{xmm4},~{xmm5},~{xmm6},~{xmm7},~{xmm8},~{xmm9},~{xmm10},~{xmm11},~{xmm12},~{xmm13},~{xmm14},~{xmm15},~{xmm16},~{xmm17},~{xmm18},~{xmm19},~{xmm20},~{xmm21},~{xmm22},~{xmm23},~{xmm24},~{xmm25},~{xmm26},~{xmm27},~{xmm28},~{xmm29},~{xmm30},~{xmm31},~{flags}"()
  %v0 = load float, ptr %p0, align 4
  %t0 = insertelement <4 x float> undef, float %v0, i64 0
  %a0 = shufflevector <4 x float> %t0, <4 x float> undef, <4 x i32> zeroinitializer
  %2 = call <4 x float> @llvm.x86.avx512.mask.getmant.ps.128(<4 x float> %a0, i32 88, <4 x float> undef, i8 -1)
  ret <4 x float> %2
}

declare <4 x float> @llvm.x86.avx512.mask.getmant.ps.128(<4 x float>, i32, <4 x float>, i8)

define <8 x float> @getmantps_mem_256(ptr %p0) {
; ENABLE-LABEL: getmantps_mem_256:
; ENABLE:       # %bb.0:
; ENABLE-NEXT:    #APP
; ENABLE-NEXT:    nop
; ENABLE-NEXT:    #NO_APP
; ENABLE-NEXT:    vxorps %xmm0, %xmm0, %xmm0
; ENABLE-NEXT:    vgetmantps $88, (%rdi), %ymm0
; ENABLE-NEXT:    retq
;
; DISABLE-LABEL: getmantps_mem_256:
; DISABLE:       # %bb.0:
; DISABLE-NEXT:    #APP
; DISABLE-NEXT:    nop
; DISABLE-NEXT:    #NO_APP
; DISABLE-NEXT:    vgetmantps $88, (%rdi), %ymm0
; DISABLE-NEXT:    retq
  %1 = tail call <2 x i64> asm sideeffect "nop", "=x,~{xmm1},~{xmm2},~{xmm3},~{xmm4},~{xmm5},~{xmm6},~{xmm7},~{xmm8},~{xmm9},~{xmm10},~{xmm11},~{xmm12},~{xmm13},~{xmm14},~{xmm15},~{xmm16},~{xmm17},~{xmm18},~{xmm19},~{xmm20},~{xmm21},~{xmm22},~{xmm23},~{xmm24},~{xmm25},~{xmm26},~{xmm27},~{xmm28},~{xmm29},~{xmm30},~{xmm31},~{flags}"()
  %a0 = load <8 x float>, ptr %p0, align 64
  %2 = call <8 x float> @llvm.x86.avx512.mask.getmant.ps.256(<8 x float> %a0, i32 88, <8 x float> undef, i8 -1)
  ret <8 x float> %2
}

define <8 x float> @getmantps_broadcast_256(ptr %p0) {
; ENABLE-LABEL: getmantps_broadcast_256:
; ENABLE:       # %bb.0:
; ENABLE-NEXT:    #APP
; ENABLE-NEXT:    nop
; ENABLE-NEXT:    #NO_APP
; ENABLE-NEXT:    vxorps %xmm0, %xmm0, %xmm0
; ENABLE-NEXT:    vgetmantps $88, (%rdi){1to8}, %ymm0
; ENABLE-NEXT:    retq
;
; DISABLE-LABEL: getmantps_broadcast_256:
; DISABLE:       # %bb.0:
; DISABLE-NEXT:    #APP
; DISABLE-NEXT:    nop
; DISABLE-NEXT:    #NO_APP
; DISABLE-NEXT:    vgetmantps $88, (%rdi){1to8}, %ymm0
; DISABLE-NEXT:    retq
  %1 = tail call <2 x i64> asm sideeffect "nop", "=x,~{xmm1},~{xmm2},~{xmm3},~{xmm4},~{xmm5},~{xmm6},~{xmm7},~{xmm8},~{xmm9},~{xmm10},~{xmm11},~{xmm12},~{xmm13},~{xmm14},~{xmm15},~{xmm16},~{xmm17},~{xmm18},~{xmm19},~{xmm20},~{xmm21},~{xmm22},~{xmm23},~{xmm24},~{xmm25},~{xmm26},~{xmm27},~{xmm28},~{xmm29},~{xmm30},~{xmm31},~{flags}"()
  %v0 = load float, ptr %p0, align 4
  %t0 = insertelement <8 x float> undef, float %v0, i64 0
  %a0 = shufflevector <8 x float> %t0, <8 x float> undef, <8 x i32> zeroinitializer
  %2 = call <8 x float> @llvm.x86.avx512.mask.getmant.ps.256(<8 x float> %a0, i32 88, <8 x float> undef, i8 -1)
  ret <8 x float> %2
}

declare <8 x float> @llvm.x86.avx512.mask.getmant.ps.256(<8 x float>, i32, <8 x float>, i8)

define <16 x float> @getmantps_mem_512(ptr %p0) {
; ENABLE-LABEL: getmantps_mem_512:
; ENABLE:       # %bb.0:
; ENABLE-NEXT:    #APP
; ENABLE-NEXT:    nop
; ENABLE-NEXT:    #NO_APP
; ENABLE-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; ENABLE-NEXT:    vgetmantps $88, (%rdi), %zmm0
; ENABLE-NEXT:    retq
;
; DISABLE-LABEL: getmantps_mem_512:
; DISABLE:       # %bb.0:
; DISABLE-NEXT:    #APP
; DISABLE-NEXT:    nop
; DISABLE-NEXT:    #NO_APP
; DISABLE-NEXT:    vgetmantps $88, (%rdi), %zmm0
; DISABLE-NEXT:    retq
  %1 = tail call <2 x i64> asm sideeffect "nop", "=x,~{xmm1},~{xmm2},~{xmm3},~{xmm4},~{xmm5},~{xmm6},~{xmm7},~{xmm8},~{xmm9},~{xmm10},~{xmm11},~{xmm12},~{xmm13},~{xmm14},~{xmm15},~{xmm16},~{xmm17},~{xmm18},~{xmm19},~{xmm20},~{xmm21},~{xmm22},~{xmm23},~{xmm24},~{xmm25},~{xmm26},~{xmm27},~{xmm28},~{xmm29},~{xmm30},~{xmm31},~{flags}"()
  %a0 = load <16 x float>, ptr %p0, align 64
  %2 = call <16 x float> @llvm.x86.avx512.mask.getmant.ps.512(<16 x float> %a0, i32 88, <16 x float> undef, i16 -1, i32 4)
  ret <16 x float> %2
}

define <16 x float> @getmantps_broadcast_512(ptr %p0) {
; ENABLE-LABEL: getmantps_broadcast_512:
; ENABLE:       # %bb.0:
; ENABLE-NEXT:    #APP
; ENABLE-NEXT:    nop
; ENABLE-NEXT:    #NO_APP
; ENABLE-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; ENABLE-NEXT:    vgetmantps $88, (%rdi){1to16}, %zmm0
; ENABLE-NEXT:    retq
;
; DISABLE-LABEL: getmantps_broadcast_512:
; DISABLE:       # %bb.0:
; DISABLE-NEXT:    #APP
; DISABLE-NEXT:    nop
; DISABLE-NEXT:    #NO_APP
; DISABLE-NEXT:    vgetmantps $88, (%rdi){1to16}, %zmm0
; DISABLE-NEXT:    retq
  %1 = tail call <2 x i64> asm sideeffect "nop", "=x,~{xmm1},~{xmm2},~{xmm3},~{xmm4},~{xmm5},~{xmm6},~{xmm7},~{xmm8},~{xmm9},~{xmm10},~{xmm11},~{xmm12},~{xmm13},~{xmm14},~{xmm15},~{xmm16},~{xmm17},~{xmm18},~{xmm19},~{xmm20},~{xmm21},~{xmm22},~{xmm23},~{xmm24},~{xmm25},~{xmm26},~{xmm27},~{xmm28},~{xmm29},~{xmm30},~{xmm31},~{flags}"()
  %v0 = load float, ptr %p0, align 4
  %t0 = insertelement <16 x float> undef, float %v0, i64 0
  %a0 = shufflevector <16 x float> %t0, <16 x float> undef, <16 x i32> zeroinitializer
  %2 = call <16 x float> @llvm.x86.avx512.mask.getmant.ps.512(<16 x float> %a0, i32 88, <16 x float> undef, i16 -1, i32 4)
  ret <16 x float> %2
}

declare <16 x float> @llvm.x86.avx512.mask.getmant.ps.512(<16 x float>, i32, <16 x float>, i16, i32)


define <2 x double> @getmantpd_mem_128(ptr %p0) {
; ENABLE-LABEL: getmantpd_mem_128:
; ENABLE:       # %bb.0:
; ENABLE-NEXT:    #APP
; ENABLE-NEXT:    nop
; ENABLE-NEXT:    #NO_APP
; ENABLE-NEXT:    vxorps %xmm0, %xmm0, %xmm0
; ENABLE-NEXT:    vgetmantpd $88, (%rdi), %xmm0
; ENABLE-NEXT:    retq
;
; DISABLE-LABEL: getmantpd_mem_128:
; DISABLE:       # %bb.0:
; DISABLE-NEXT:    #APP
; DISABLE-NEXT:    nop
; DISABLE-NEXT:    #NO_APP
; DISABLE-NEXT:    vgetmantpd $88, (%rdi), %xmm0
; DISABLE-NEXT:    retq
  %1 = tail call <2 x i64> asm sideeffect "nop", "=x,~{xmm1},~{xmm2},~{xmm3},~{xmm4},~{xmm5},~{xmm6},~{xmm7},~{xmm8},~{xmm9},~{xmm10},~{xmm11},~{xmm12},~{xmm13},~{xmm14},~{xmm15},~{xmm16},~{xmm17},~{xmm18},~{xmm19},~{xmm20},~{xmm21},~{xmm22},~{xmm23},~{xmm24},~{xmm25},~{xmm26},~{xmm27},~{xmm28},~{xmm29},~{xmm30},~{xmm31},~{flags}"()
  %a0 = load <2 x double>, ptr %p0, align 64
  %2 = call <2 x double> @llvm.x86.avx512.mask.getmant.pd.128(<2 x double> %a0, i32 88, <2 x double> undef, i8 -1)
  ret <2 x double> %2
}

define <2 x double> @getmantpd_broadcast_128(ptr %p0) {
; ENABLE-LABEL: getmantpd_broadcast_128:
; ENABLE:       # %bb.0:
; ENABLE-NEXT:    #APP
; ENABLE-NEXT:    nop
; ENABLE-NEXT:    #NO_APP
; ENABLE-NEXT:    vxorps %xmm0, %xmm0, %xmm0
; ENABLE-NEXT:    vgetmantpd $88, (%rdi){1to2}, %xmm0
; ENABLE-NEXT:    retq
;
; DISABLE-LABEL: getmantpd_broadcast_128:
; DISABLE:       # %bb.0:
; DISABLE-NEXT:    #APP
; DISABLE-NEXT:    nop
; DISABLE-NEXT:    #NO_APP
; DISABLE-NEXT:    vgetmantpd $88, (%rdi){1to2}, %xmm0
; DISABLE-NEXT:    retq
  %1 = tail call <2 x i64> asm sideeffect "nop", "=x,~{xmm1},~{xmm2},~{xmm3},~{xmm4},~{xmm5},~{xmm6},~{xmm7},~{xmm8},~{xmm9},~{xmm10},~{xmm11},~{xmm12},~{xmm13},~{xmm14},~{xmm15},~{xmm16},~{xmm17},~{xmm18},~{xmm19},~{xmm20},~{xmm21},~{xmm22},~{xmm23},~{xmm24},~{xmm25},~{xmm26},~{xmm27},~{xmm28},~{xmm29},~{xmm30},~{xmm31},~{flags}"()
  %v0 = load double, ptr %p0, align 4
  %t0 = insertelement <2 x double> undef, double %v0, i64 0
  %a0 = shufflevector <2 x double> %t0, <2 x double> undef, <2 x i32> zeroinitializer
  %2 = call <2 x double> @llvm.x86.avx512.mask.getmant.pd.128(<2 x double> %a0, i32 88, <2 x double> undef, i8 -1)
  ret <2 x double> %2
}

declare <2 x double> @llvm.x86.avx512.mask.getmant.pd.128(<2 x double>, i32, <2 x double>, i8)

define <4 x double> @getmantpd_mem_256(ptr %p0) {
; ENABLE-LABEL: getmantpd_mem_256:
; ENABLE:       # %bb.0:
; ENABLE-NEXT:    #APP
; ENABLE-NEXT:    nop
; ENABLE-NEXT:    #NO_APP
; ENABLE-NEXT:    vxorps %xmm0, %xmm0, %xmm0
; ENABLE-NEXT:    vgetmantpd $88, (%rdi), %ymm0
; ENABLE-NEXT:    retq
;
; DISABLE-LABEL: getmantpd_mem_256:
; DISABLE:       # %bb.0:
; DISABLE-NEXT:    #APP
; DISABLE-NEXT:    nop
; DISABLE-NEXT:    #NO_APP
; DISABLE-NEXT:    vgetmantpd $88, (%rdi), %ymm0
; DISABLE-NEXT:    retq
  %1 = tail call <2 x i64> asm sideeffect "nop", "=x,~{xmm1},~{xmm2},~{xmm3},~{xmm4},~{xmm5},~{xmm6},~{xmm7},~{xmm8},~{xmm9},~{xmm10},~{xmm11},~{xmm12},~{xmm13},~{xmm14},~{xmm15},~{xmm16},~{xmm17},~{xmm18},~{xmm19},~{xmm20},~{xmm21},~{xmm22},~{xmm23},~{xmm24},~{xmm25},~{xmm26},~{xmm27},~{xmm28},~{xmm29},~{xmm30},~{xmm31},~{flags}"()
  %a0 = load <4 x double>, ptr %p0, align 64
  %2 = call <4 x double> @llvm.x86.avx512.mask.getmant.pd.256(<4 x double> %a0, i32 88, <4 x double> undef, i8 -1)
  ret <4 x double> %2
}

define <4 x double> @getmantpd_broadcast_256(ptr %p0) {
; ENABLE-LABEL: getmantpd_broadcast_256:
; ENABLE:       # %bb.0:
; ENABLE-NEXT:    #APP
; ENABLE-NEXT:    nop
; ENABLE-NEXT:    #NO_APP
; ENABLE-NEXT:    vxorps %xmm0, %xmm0, %xmm0
; ENABLE-NEXT:    vgetmantpd $88, (%rdi){1to4}, %ymm0
; ENABLE-NEXT:    retq
;
; DISABLE-LABEL: getmantpd_broadcast_256:
; DISABLE:       # %bb.0:
; DISABLE-NEXT:    #APP
; DISABLE-NEXT:    nop
; DISABLE-NEXT:    #NO_APP
; DISABLE-NEXT:    vgetmantpd $88, (%rdi){1to4}, %ymm0
; DISABLE-NEXT:    retq
  %1 = tail call <2 x i64> asm sideeffect "nop", "=x,~{xmm1},~{xmm2},~{xmm3},~{xmm4},~{xmm5},~{xmm6},~{xmm7},~{xmm8},~{xmm9},~{xmm10},~{xmm11},~{xmm12},~{xmm13},~{xmm14},~{xmm15},~{xmm16},~{xmm17},~{xmm18},~{xmm19},~{xmm20},~{xmm21},~{xmm22},~{xmm23},~{xmm24},~{xmm25},~{xmm26},~{xmm27},~{xmm28},~{xmm29},~{xmm30},~{xmm31},~{flags}"()
  %v0 = load double, ptr %p0, align 4
  %t0 = insertelement <4 x double> undef, double %v0, i64 0
  %a0 = shufflevector <4 x double> %t0, <4 x double> undef, <4 x i32> zeroinitializer
  %2 = call <4 x double> @llvm.x86.avx512.mask.getmant.pd.256(<4 x double> %a0, i32 88, <4 x double> undef, i8 -1)
  ret <4 x double> %2
}

declare <4 x double> @llvm.x86.avx512.mask.getmant.pd.256(<4 x double>, i32, <4 x double>, i8)

define <8 x double> @getmantpd_mem_512(ptr %p0) {
; ENABLE-LABEL: getmantpd_mem_512:
; ENABLE:       # %bb.0:
; ENABLE-NEXT:    #APP
; ENABLE-NEXT:    nop
; ENABLE-NEXT:    #NO_APP
; ENABLE-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; ENABLE-NEXT:    vgetmantpd $88, (%rdi), %zmm0
; ENABLE-NEXT:    retq
;
; DISABLE-LABEL: getmantpd_mem_512:
; DISABLE:       # %bb.0:
; DISABLE-NEXT:    #APP
; DISABLE-NEXT:    nop
; DISABLE-NEXT:    #NO_APP
; DISABLE-NEXT:    vgetmantpd $88, (%rdi), %zmm0
; DISABLE-NEXT:    retq
  %1 = tail call <2 x i64> asm sideeffect "nop", "=x,~{xmm1},~{xmm2},~{xmm3},~{xmm4},~{xmm5},~{xmm6},~{xmm7},~{xmm8},~{xmm9},~{xmm10},~{xmm11},~{xmm12},~{xmm13},~{xmm14},~{xmm15},~{xmm16},~{xmm17},~{xmm18},~{xmm19},~{xmm20},~{xmm21},~{xmm22},~{xmm23},~{xmm24},~{xmm25},~{xmm26},~{xmm27},~{xmm28},~{xmm29},~{xmm30},~{xmm31},~{flags}"()
  %a0 = load <8 x double>, ptr %p0, align 64
  %2 = call <8 x double> @llvm.x86.avx512.mask.getmant.pd.512(<8 x double> %a0, i32 88, <8 x double> undef, i8 -1, i32 4)
  ret <8 x double> %2
}

define <8 x double> @getmantpd_broadcast_512(ptr %p0) {
; ENABLE-LABEL: getmantpd_broadcast_512:
; ENABLE:       # %bb.0:
; ENABLE-NEXT:    #APP
; ENABLE-NEXT:    nop
; ENABLE-NEXT:    #NO_APP
; ENABLE-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; ENABLE-NEXT:    vgetmantpd $88, (%rdi){1to8}, %zmm0
; ENABLE-NEXT:    retq
;
; DISABLE-LABEL: getmantpd_broadcast_512:
; DISABLE:       # %bb.0:
; DISABLE-NEXT:    #APP
; DISABLE-NEXT:    nop
; DISABLE-NEXT:    #NO_APP
; DISABLE-NEXT:    vgetmantpd $88, (%rdi){1to8}, %zmm0
; DISABLE-NEXT:    retq
  %1 = tail call <2 x i64> asm sideeffect "nop", "=x,~{xmm1},~{xmm2},~{xmm3},~{xmm4},~{xmm5},~{xmm6},~{xmm7},~{xmm8},~{xmm9},~{xmm10},~{xmm11},~{xmm12},~{xmm13},~{xmm14},~{xmm15},~{xmm16},~{xmm17},~{xmm18},~{xmm19},~{xmm20},~{xmm21},~{xmm22},~{xmm23},~{xmm24},~{xmm25},~{xmm26},~{xmm27},~{xmm28},~{xmm29},~{xmm30},~{xmm31},~{flags}"()
  %v0 = load double, ptr %p0, align 4
  %t0 = insertelement <8 x double> undef, double %v0, i64 0
  %a0 = shufflevector <8 x double> %t0, <8 x double> undef, <8 x i32> zeroinitializer
  %2 = call <8 x double> @llvm.x86.avx512.mask.getmant.pd.512(<8 x double> %a0, i32 88, <8 x double> undef, i8 -1, i32 4)
  ret <8 x double> %2
}

declare <8 x double> @llvm.x86.avx512.mask.getmant.pd.512(<8 x double>, i32, <8 x double>, i8, i32)

define <8 x half> @getmantsh(<8 x half> %a0, <8 x half> %a1) {
; ENABLE-LABEL: getmantsh:
; ENABLE:       # %bb.0:
; ENABLE-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; ENABLE-NEXT:    #APP
; ENABLE-NEXT:    nop
; ENABLE-NEXT:    #NO_APP
; ENABLE-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; ENABLE-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; ENABLE-NEXT:    vgetmantsh $11, %xmm2, %xmm0, %xmm1
; ENABLE-NEXT:    vaddph %xmm2, %xmm0, %xmm0
; ENABLE-NEXT:    vaddph %xmm0, %xmm1, %xmm0
; ENABLE-NEXT:    retq
;
; DISABLE-LABEL: getmantsh:
; DISABLE:       # %bb.0:
; DISABLE-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; DISABLE-NEXT:    #APP
; DISABLE-NEXT:    nop
; DISABLE-NEXT:    #NO_APP
; DISABLE-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; DISABLE-NEXT:    vgetmantsh $11, %xmm2, %xmm0, %xmm1
; DISABLE-NEXT:    vaddph %xmm2, %xmm0, %xmm0
; DISABLE-NEXT:    vaddph %xmm0, %xmm1, %xmm0
; DISABLE-NEXT:    retq
  %1 = tail call <2 x i64> asm sideeffect "nop", "=x,~{xmm2},~{xmm3},~{xmm4},~{xmm5},~{xmm6},~{xmm7},~{xmm8},~{xmm9},~{xmm10},~{xmm11},~{xmm12},~{xmm13},~{xmm14},~{xmm15},~{xmm16},~{xmm17},~{xmm18},~{xmm19},~{xmm20},~{xmm21},~{xmm22},~{xmm23},~{xmm24},~{xmm25},~{xmm26},~{xmm27},~{xmm28},~{xmm29},~{xmm30},~{xmm31},~{flags}"()
  %2 = call <8 x half> @llvm.x86.avx512fp16.mask.getmant.sh(<8 x half> %a0, <8 x half> %a1, i32 11, <8 x half> undef, i8 -1, i32 4)
  %t = fadd <8 x half> %a0, %a1
  %res = fadd <8 x half> %2, %t
  ret <8 x half> %res
}

define <8 x half> @getmantsh_mem(<8 x half> %a0, ptr %p1) {
; ENABLE-LABEL: getmantsh_mem:
; ENABLE:       # %bb.0:
; ENABLE-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; ENABLE-NEXT:    #APP
; ENABLE-NEXT:    nop
; ENABLE-NEXT:    #NO_APP
; ENABLE-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; ENABLE-NEXT:    vxorps %xmm0, %xmm0, %xmm0
; ENABLE-NEXT:    vgetmantsh $11, (%rdi), %xmm1, %xmm0
; ENABLE-NEXT:    vaddph %xmm1, %xmm0, %xmm0
; ENABLE-NEXT:    retq
;
; DISABLE-LABEL: getmantsh_mem:
; DISABLE:       # %bb.0:
; DISABLE-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; DISABLE-NEXT:    #APP
; DISABLE-NEXT:    nop
; DISABLE-NEXT:    #NO_APP
; DISABLE-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; DISABLE-NEXT:    vgetmantsh $11, (%rdi), %xmm1, %xmm0
; DISABLE-NEXT:    vaddph %xmm1, %xmm0, %xmm0
; DISABLE-NEXT:    retq
  %1 = tail call <2 x i64> asm sideeffect "nop", "=x,~{xmm1},~{xmm2},~{xmm3},~{xmm4},~{xmm5},~{xmm6},~{xmm7},~{xmm8},~{xmm9},~{xmm10},~{xmm11},~{xmm12},~{xmm13},~{xmm14},~{xmm15},~{xmm16},~{xmm17},~{xmm18},~{xmm19},~{xmm20},~{xmm21},~{xmm22},~{xmm23},~{xmm24},~{xmm25},~{xmm26},~{xmm27},~{xmm28},~{xmm29},~{xmm30},~{xmm31},~{flags}"()
  %a1 = load <8 x half>, ptr %p1, align 64
  %2 = call <8 x half> @llvm.x86.avx512fp16.mask.getmant.sh(<8 x half> %a0, <8 x half> %a1, i32 11, <8 x half> undef, i8 -1, i32 4)
  %res = fadd <8 x half> %2, %a0
  ret <8 x half> %res
}

define <8 x half> @getmantsh_maskz(<8 x half> %a0, <8 x half> %a1, ptr %mask) {
; ENABLE-LABEL: getmantsh_maskz:
; ENABLE:       # %bb.0:
; ENABLE-NEXT:    #APP
; ENABLE-NEXT:    nop
; ENABLE-NEXT:    #NO_APP
; ENABLE-NEXT:    kmovb (%rdi), %k1
; ENABLE-NEXT:    vxorps %xmm2, %xmm2, %xmm2
; ENABLE-NEXT:    vgetmantsh $11, %xmm1, %xmm0, %xmm2 {%k1} {z}
; ENABLE-NEXT:    vaddph %xmm1, %xmm0, %xmm0
; ENABLE-NEXT:    vaddph %xmm0, %xmm2, %xmm0
; ENABLE-NEXT:    retq
;
; DISABLE-LABEL: getmantsh_maskz:
; DISABLE:       # %bb.0:
; DISABLE-NEXT:    #APP
; DISABLE-NEXT:    nop
; DISABLE-NEXT:    #NO_APP
; DISABLE-NEXT:    kmovb (%rdi), %k1
; DISABLE-NEXT:    vgetmantsh $11, %xmm1, %xmm0, %xmm2 {%k1} {z}
; DISABLE-NEXT:    vaddph %xmm1, %xmm0, %xmm0
; DISABLE-NEXT:    vaddph %xmm0, %xmm2, %xmm0
; DISABLE-NEXT:    retq
  %1 = tail call <2 x i64> asm sideeffect "nop", "=x,~{xmm3},~{xmm4},~{xmm5},~{xmm6},~{xmm7},~{xmm8},~{xmm9},~{xmm10},~{xmm11},~{xmm12},~{xmm13},~{xmm14},~{xmm15},~{xmm16},~{xmm17},~{xmm18},~{xmm19},~{xmm20},~{xmm21},~{xmm22},~{xmm23},~{xmm24},~{xmm25},~{xmm26},~{xmm27},~{xmm28},~{xmm29},~{xmm30},~{xmm31},~{flags}"()
  %2 = load i8, ptr %mask
  %3 = call <8 x half> @llvm.x86.avx512fp16.mask.getmant.sh(<8 x half> %a0, <8 x half> %a1, i32 11, <8 x half> zeroinitializer, i8 %2, i32 4)
  %t = fadd <8 x half> %a0, %a1
  %res = fadd <8 x half> %3, %t
  ret <8 x half> %res
}

declare <8 x half> @llvm.x86.avx512fp16.mask.getmant.sh(<8 x half>, <8 x half>, i32, <8 x half>, i8, i32)

define <4 x float> @getmantss(<4 x float> %a0, <4 x float> %a1) {
; ENABLE-LABEL: getmantss:
; ENABLE:       # %bb.0:
; ENABLE-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; ENABLE-NEXT:    #APP
; ENABLE-NEXT:    nop
; ENABLE-NEXT:    #NO_APP
; ENABLE-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; ENABLE-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; ENABLE-NEXT:    vgetmantss $11, %xmm2, %xmm0, %xmm1
; ENABLE-NEXT:    vaddps %xmm2, %xmm0, %xmm0
; ENABLE-NEXT:    vaddps %xmm0, %xmm1, %xmm0
; ENABLE-NEXT:    retq
;
; DISABLE-LABEL: getmantss:
; DISABLE:       # %bb.0:
; DISABLE-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; DISABLE-NEXT:    #APP
; DISABLE-NEXT:    nop
; DISABLE-NEXT:    #NO_APP
; DISABLE-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; DISABLE-NEXT:    vgetmantss $11, %xmm2, %xmm0, %xmm1
; DISABLE-NEXT:    vaddps %xmm2, %xmm0, %xmm0
; DISABLE-NEXT:    vaddps %xmm0, %xmm1, %xmm0
; DISABLE-NEXT:    retq
  %1 = tail call <2 x i64> asm sideeffect "nop", "=x,~{xmm2},~{xmm3},~{xmm4},~{xmm5},~{xmm6},~{xmm7},~{xmm8},~{xmm9},~{xmm10},~{xmm11},~{xmm12},~{xmm13},~{xmm14},~{xmm15},~{xmm16},~{xmm17},~{xmm18},~{xmm19},~{xmm20},~{xmm21},~{xmm22},~{xmm23},~{xmm24},~{xmm25},~{xmm26},~{xmm27},~{xmm28},~{xmm29},~{xmm30},~{xmm31},~{flags}"()
  %2 = call <4 x float> @llvm.x86.avx512.mask.getmant.ss(<4 x float> %a0, <4 x float> %a1, i32 11, <4 x float> undef, i8 -1, i32 4)
  %t = fadd <4 x float> %a0, %a1
  %res = fadd <4 x float> %2, %t
  ret <4 x float> %res
}

define <4 x float> @getmantss_mem(<4 x float> %a0, ptr %p1) {
; ENABLE-LABEL: getmantss_mem:
; ENABLE:       # %bb.0:
; ENABLE-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; ENABLE-NEXT:    #APP
; ENABLE-NEXT:    nop
; ENABLE-NEXT:    #NO_APP
; ENABLE-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; ENABLE-NEXT:    vxorps %xmm0, %xmm0, %xmm0
; ENABLE-NEXT:    vgetmantss $11, (%rdi), %xmm1, %xmm0
; ENABLE-NEXT:    vaddps %xmm1, %xmm0, %xmm0
; ENABLE-NEXT:    retq
;
; DISABLE-LABEL: getmantss_mem:
; DISABLE:       # %bb.0:
; DISABLE-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; DISABLE-NEXT:    #APP
; DISABLE-NEXT:    nop
; DISABLE-NEXT:    #NO_APP
; DISABLE-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; DISABLE-NEXT:    vgetmantss $11, (%rdi), %xmm1, %xmm0
; DISABLE-NEXT:    vaddps %xmm1, %xmm0, %xmm0
; DISABLE-NEXT:    retq
  %1 = tail call <2 x i64> asm sideeffect "nop", "=x,~{xmm1},~{xmm2},~{xmm3},~{xmm4},~{xmm5},~{xmm6},~{xmm7},~{xmm8},~{xmm9},~{xmm10},~{xmm11},~{xmm12},~{xmm13},~{xmm14},~{xmm15},~{xmm16},~{xmm17},~{xmm18},~{xmm19},~{xmm20},~{xmm21},~{xmm22},~{xmm23},~{xmm24},~{xmm25},~{xmm26},~{xmm27},~{xmm28},~{xmm29},~{xmm30},~{xmm31},~{flags}"()
  %a1 = load <4 x float>, ptr %p1, align 64
  %2 = call <4 x float> @llvm.x86.avx512.mask.getmant.ss(<4 x float> %a0, <4 x float> %a1, i32 11, <4 x float> undef, i8 -1, i32 4)
  %res = fadd <4 x float> %2, %a0
  ret <4 x float> %res
}

define <4 x float> @getmantss_maskz(<4 x float> %a0, <4 x float> %a1, ptr %mask) {
; ENABLE-LABEL: getmantss_maskz:
; ENABLE:       # %bb.0:
; ENABLE-NEXT:    #APP
; ENABLE-NEXT:    nop
; ENABLE-NEXT:    #NO_APP
; ENABLE-NEXT:    kmovb (%rdi), %k1
; ENABLE-NEXT:    vxorps %xmm2, %xmm2, %xmm2
; ENABLE-NEXT:    vgetmantss $11, %xmm1, %xmm0, %xmm2 {%k1} {z}
; ENABLE-NEXT:    vaddps %xmm1, %xmm0, %xmm0
; ENABLE-NEXT:    vaddps %xmm0, %xmm2, %xmm0
; ENABLE-NEXT:    retq
;
; DISABLE-LABEL: getmantss_maskz:
; DISABLE:       # %bb.0:
; DISABLE-NEXT:    #APP
; DISABLE-NEXT:    nop
; DISABLE-NEXT:    #NO_APP
; DISABLE-NEXT:    kmovb (%rdi), %k1
; DISABLE-NEXT:    vgetmantss $11, %xmm1, %xmm0, %xmm2 {%k1} {z}
; DISABLE-NEXT:    vaddps %xmm1, %xmm0, %xmm0
; DISABLE-NEXT:    vaddps %xmm0, %xmm2, %xmm0
; DISABLE-NEXT:    retq
  %1 = tail call <2 x i64> asm sideeffect "nop", "=x,~{xmm3},~{xmm4},~{xmm5},~{xmm6},~{xmm7},~{xmm8},~{xmm9},~{xmm10},~{xmm11},~{xmm12},~{xmm13},~{xmm14},~{xmm15},~{xmm16},~{xmm17},~{xmm18},~{xmm19},~{xmm20},~{xmm21},~{xmm22},~{xmm23},~{xmm24},~{xmm25},~{xmm26},~{xmm27},~{xmm28},~{xmm29},~{xmm30},~{xmm31},~{flags}"()
  %2 = load i8, ptr %mask
  %3 = call <4 x float> @llvm.x86.avx512.mask.getmant.ss(<4 x float> %a0, <4 x float> %a1, i32 11, <4 x float> zeroinitializer, i8 %2, i32 4)
  %t = fadd <4 x float> %a0, %a1
  %res = fadd <4 x float> %3, %t
  ret <4 x float> %res
}

declare <4 x float> @llvm.x86.avx512.mask.getmant.ss(<4 x float>, <4 x float>, i32, <4 x float>, i8, i32)

define <2 x double> @getmantsd(<2 x double> %a0, <2 x double> %a1) {
; ENABLE-LABEL: getmantsd:
; ENABLE:       # %bb.0:
; ENABLE-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; ENABLE-NEXT:    #APP
; ENABLE-NEXT:    nop
; ENABLE-NEXT:    #NO_APP
; ENABLE-NEXT:    vmovapd {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; ENABLE-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; ENABLE-NEXT:    vgetmantsd $11, %xmm2, %xmm0, %xmm1
; ENABLE-NEXT:    vaddpd %xmm2, %xmm0, %xmm0
; ENABLE-NEXT:    vaddpd %xmm0, %xmm1, %xmm0
; ENABLE-NEXT:    retq
;
; DISABLE-LABEL: getmantsd:
; DISABLE:       # %bb.0:
; DISABLE-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; DISABLE-NEXT:    #APP
; DISABLE-NEXT:    nop
; DISABLE-NEXT:    #NO_APP
; DISABLE-NEXT:    vmovapd {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; DISABLE-NEXT:    vgetmantsd $11, %xmm2, %xmm0, %xmm1
; DISABLE-NEXT:    vaddpd %xmm2, %xmm0, %xmm0
; DISABLE-NEXT:    vaddpd %xmm0, %xmm1, %xmm0
; DISABLE-NEXT:    retq
  %1 = tail call <2 x i64> asm sideeffect "nop", "=x,~{xmm2},~{xmm3},~{xmm4},~{xmm5},~{xmm6},~{xmm7},~{xmm8},~{xmm9},~{xmm10},~{xmm11},~{xmm12},~{xmm13},~{xmm14},~{xmm15},~{xmm16},~{xmm17},~{xmm18},~{xmm19},~{xmm20},~{xmm21},~{xmm22},~{xmm23},~{xmm24},~{xmm25},~{xmm26},~{xmm27},~{xmm28},~{xmm29},~{xmm30},~{xmm31},~{flags}"()
  %2 = call <2 x double> @llvm.x86.avx512.mask.getmant.sd(<2 x double> %a0, <2 x double> %a1, i32 11, <2 x double> undef, i8 -1, i32 4)
  %t = fadd <2 x double> %a0, %a1
  %res = fadd <2 x double> %2, %t
  ret <2 x double> %res
}

define <2 x double> @getmantsd_mem(<2 x double> %a0, ptr %p1) {
; ENABLE-LABEL: getmantsd_mem:
; ENABLE:       # %bb.0:
; ENABLE-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; ENABLE-NEXT:    #APP
; ENABLE-NEXT:    nop
; ENABLE-NEXT:    #NO_APP
; ENABLE-NEXT:    vmovapd {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; ENABLE-NEXT:    vxorps %xmm0, %xmm0, %xmm0
; ENABLE-NEXT:    vgetmantsd $11, (%rdi), %xmm1, %xmm0
; ENABLE-NEXT:    vaddpd %xmm1, %xmm0, %xmm0
; ENABLE-NEXT:    retq
;
; DISABLE-LABEL: getmantsd_mem:
; DISABLE:       # %bb.0:
; DISABLE-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; DISABLE-NEXT:    #APP
; DISABLE-NEXT:    nop
; DISABLE-NEXT:    #NO_APP
; DISABLE-NEXT:    vmovapd {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; DISABLE-NEXT:    vgetmantsd $11, (%rdi), %xmm1, %xmm0
; DISABLE-NEXT:    vaddpd %xmm1, %xmm0, %xmm0
; DISABLE-NEXT:    retq
  %1 = tail call <2 x i64> asm sideeffect "nop", "=x,~{xmm1},~{xmm2},~{xmm3},~{xmm4},~{xmm5},~{xmm6},~{xmm7},~{xmm8},~{xmm9},~{xmm10},~{xmm11},~{xmm12},~{xmm13},~{xmm14},~{xmm15},~{xmm16},~{xmm17},~{xmm18},~{xmm19},~{xmm20},~{xmm21},~{xmm22},~{xmm23},~{xmm24},~{xmm25},~{xmm26},~{xmm27},~{xmm28},~{xmm29},~{xmm30},~{xmm31},~{flags}"()
  %a1 = load <2 x double>, ptr %p1, align 64
  %2 = call <2 x double> @llvm.x86.avx512.mask.getmant.sd(<2 x double> %a0, <2 x double> %a1, i32 11, <2 x double> undef, i8 -1, i32 4)
  %res = fadd <2 x double> %2, %a0
  ret <2 x double> %res
}

define <2 x double> @getmantsd_maskz(<2 x double> %a0, <2 x double> %a1, ptr %mask) {
; ENABLE-LABEL: getmantsd_maskz:
; ENABLE:       # %bb.0:
; ENABLE-NEXT:    #APP
; ENABLE-NEXT:    nop
; ENABLE-NEXT:    #NO_APP
; ENABLE-NEXT:    kmovb (%rdi), %k1
; ENABLE-NEXT:    vxorps %xmm2, %xmm2, %xmm2
; ENABLE-NEXT:    vgetmantsd $11, %xmm1, %xmm0, %xmm2 {%k1} {z}
; ENABLE-NEXT:    vaddpd %xmm1, %xmm0, %xmm0
; ENABLE-NEXT:    vaddpd %xmm0, %xmm2, %xmm0
; ENABLE-NEXT:    retq
;
; DISABLE-LABEL: getmantsd_maskz:
; DISABLE:       # %bb.0:
; DISABLE-NEXT:    #APP
; DISABLE-NEXT:    nop
; DISABLE-NEXT:    #NO_APP
; DISABLE-NEXT:    kmovb (%rdi), %k1
; DISABLE-NEXT:    vgetmantsd $11, %xmm1, %xmm0, %xmm2 {%k1} {z}
; DISABLE-NEXT:    vaddpd %xmm1, %xmm0, %xmm0
; DISABLE-NEXT:    vaddpd %xmm0, %xmm2, %xmm0
; DISABLE-NEXT:    retq
  %1 = tail call <2 x i64> asm sideeffect "nop", "=x,~{xmm3},~{xmm4},~{xmm5},~{xmm6},~{xmm7},~{xmm8},~{xmm9},~{xmm10},~{xmm11},~{xmm12},~{xmm13},~{xmm14},~{xmm15},~{xmm16},~{xmm17},~{xmm18},~{xmm19},~{xmm20},~{xmm21},~{xmm22},~{xmm23},~{xmm24},~{xmm25},~{xmm26},~{xmm27},~{xmm28},~{xmm29},~{xmm30},~{xmm31},~{flags}"()
  %2 = load i8, ptr %mask
  %3 = call <2 x double> @llvm.x86.avx512.mask.getmant.sd(<2 x double> %a0, <2 x double> %a1, i32 11, <2 x double> zeroinitializer, i8 %2, i32 4)
  %t = fadd <2 x double> %a0, %a1
  %res = fadd <2 x double> %3, %t
  ret <2 x double> %res
}

declare <2 x double> @llvm.x86.avx512.mask.getmant.sd(<2 x double>, <2 x double>, i32, <2 x double>, i8, i32)
