; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=aarch64-linux-gnu -mattr=+sve < %s | FileCheck %s

define <vscale x 2 x i64> @sti64ldi64(ptr nocapture %P, <vscale x 2 x i64> %v) {
; CHECK-LABEL: sti64ldi64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    str z0, [x0, #1, mul vl]
; CHECK-NEXT:    ret
entry:
  %arrayidx0 = getelementptr inbounds <vscale x 2 x i64>, ptr %P, i64 1
  store <vscale x 2 x i64> %v, ptr %arrayidx0
  %arrayidx1 = getelementptr inbounds <vscale x 2 x i64>, ptr %P, i64 1
  %0 = load <vscale x 2 x i64>, ptr %arrayidx1
  ret <vscale x 2 x i64> %0
}

define <vscale x 2 x double> @stf64ldf64(ptr nocapture %P, <vscale x 2 x double> %v) {
; CHECK-LABEL: stf64ldf64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    str z0, [x0, #1, mul vl]
; CHECK-NEXT:    ret
entry:
  %arrayidx0 = getelementptr inbounds <vscale x 2 x double>, ptr %P, i64 1
  store <vscale x 2 x double> %v, ptr %arrayidx0
  %arrayidx1 = getelementptr inbounds <vscale x 2 x double>, ptr %P, i64 1
  %0 = load <vscale x 2 x double>, ptr %arrayidx1
  ret <vscale x 2 x double> %0
}

define <vscale x 2 x i64> @sti32ldi32ext(ptr nocapture %P, <vscale x 2 x i64> %v) {
; CHECK-LABEL: sti32ldi32ext:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    mov z1.d, z0.d
; CHECK-NEXT:    sxtw z0.d, p0/m, z0.d
; CHECK-NEXT:    st1w { z1.d }, p0, [x0]
; CHECK-NEXT:    ret
entry:
  %0 = trunc <vscale x 2 x i64> %v to <vscale x 2 x i32>
  store <vscale x 2 x i32> %0, ptr %P
  %1 = load <vscale x 2 x i32>, ptr %P
  %2 = sext <vscale x 2 x i32> %1 to <vscale x 2 x i64>
  ret <vscale x 2 x i64> %2
}

define <2 x i64> @sti64ldfixedi64(ptr nocapture %P, <vscale x 2 x i64> %v) {
; CHECK-LABEL: sti64ldfixedi64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    rdvl x8, #1
; CHECK-NEXT:    str z0, [x0, #1, mul vl]
; CHECK-NEXT:    ldr q0, [x0, x8]
; CHECK-NEXT:    ret
entry:
  %arrayidx0 = getelementptr inbounds <vscale x 2 x i64>, ptr %P, i64 1
  store <vscale x 2 x i64> %v, ptr %arrayidx0
  %arrayidx1 = bitcast ptr %arrayidx0 to ptr
  %0 = load <2 x i64>, ptr %arrayidx1
  ret <2 x i64> %0
}

define <vscale x 4 x i32> @sti64ldi32(ptr nocapture %P, <vscale x 2 x i64> %v) {
; CHECK-LABEL: sti64ldi32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    str z0, [x0, #1, mul vl]
; CHECK-NEXT:    ldr z0, [x0, #1, mul vl]
; CHECK-NEXT:    ret
entry:
  %0 = bitcast ptr %P to ptr
  %arrayidx0 = getelementptr inbounds <vscale x 2 x i64>, ptr %P, i64 1
  store <vscale x 2 x i64> %v, ptr %arrayidx0
  %arrayidx1 = getelementptr inbounds <vscale x 4 x i32>, ptr %0, i64 1
  %1 = load <vscale x 4 x i32>, ptr %arrayidx1
  ret <vscale x 4 x i32> %1
}

define <vscale x 2 x i64> @stf64ldi64(ptr nocapture %P, <vscale x 2 x double> %v) {
; CHECK-LABEL: stf64ldi64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    str z0, [x0, #1, mul vl]
; CHECK-NEXT:    ldr z0, [x0, #1, mul vl]
; CHECK-NEXT:    ret
entry:
  %0 = bitcast ptr %P to ptr
  %arrayidx0 = getelementptr inbounds <vscale x 2 x double>, ptr %P, i64 1
  store <vscale x 2 x double> %v, ptr %arrayidx0
  %arrayidx1 = getelementptr inbounds <vscale x 2 x i64>, ptr %0, i64 1
  %1 = load <vscale x 2 x i64>, ptr %arrayidx1
  ret <vscale x 2 x i64> %1
}
