;; NOTE: Assertions have been generated by update_lit_checks.py and should not be edited.
;; RUN: wasm-opt %s --remove-unused-brs -all --shrink-level=1 -S -o - \
;; RUN:   | filecheck %s

(module
  ;; CHECK:      (import "a" "b" (func $none (type $1)))
  (import "a" "b" (func $none))

  ;; CHECK:      (func $join-br_ifs (type $0) (param $x i32) (param $y i32)
  ;; CHECK-NEXT:  (block $out
  ;; CHECK-NEXT:   (@metadata.code.branch_hint "\01")
  ;; CHECK-NEXT:   (br_if $out
  ;; CHECK-NEXT:    (i32.or
  ;; CHECK-NEXT:     (local.get $x)
  ;; CHECK-NEXT:     (local.get $y)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (call $none)
  ;; CHECK-NEXT:   (br_if $out
  ;; CHECK-NEXT:    (local.get $y)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $join-br_ifs (param $x i32) (param $y i32)
    ;; The br_ifs will be joined into a single one. The hint should propagate,
    ;; as it matches.
    (block $out
      (@metadata.code.branch_hint "\01")
      (br_if $out
        (local.get $x)
      )
      (@metadata.code.branch_hint "\01")
      (br_if $out
        (local.get $y)
      )
      ;; Extra code so that the entire testcase does not get optimized out as
      ;; trivial.
      (call $none)
      (br_if $out
        (local.get $y)
      )
    )
  )

  ;; CHECK:      (func $join-br_ifs-0 (type $0) (param $x i32) (param $y i32)
  ;; CHECK-NEXT:  (block $out
  ;; CHECK-NEXT:   (@metadata.code.branch_hint "\00")
  ;; CHECK-NEXT:   (br_if $out
  ;; CHECK-NEXT:    (i32.or
  ;; CHECK-NEXT:     (local.get $x)
  ;; CHECK-NEXT:     (local.get $y)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (call $none)
  ;; CHECK-NEXT:   (br_if $out
  ;; CHECK-NEXT:    (local.get $y)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $join-br_ifs-0 (param $x i32) (param $y i32)
    ;; The hints once more match, but now are 0. We still propagate.
    (block $out
      (@metadata.code.branch_hint "\00")
      (br_if $out
        (local.get $x)
      )
      (@metadata.code.branch_hint "\00")
      (br_if $out
        (local.get $y)
      )

      (call $none)
      (br_if $out
        (local.get $y)
      )
    )
  )

  ;; CHECK:      (func $join-br_ifs-no (type $0) (param $x i32) (param $y i32)
  ;; CHECK-NEXT:  (block $out
  ;; CHECK-NEXT:   (br_if $out
  ;; CHECK-NEXT:    (i32.or
  ;; CHECK-NEXT:     (local.get $x)
  ;; CHECK-NEXT:     (local.get $y)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (call $none)
  ;; CHECK-NEXT:   (br_if $out
  ;; CHECK-NEXT:    (local.get $y)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $join-br_ifs-no (param $x i32) (param $y i32)
    ;; One is missing a hint, so we clear the hint.
    (block $out
      (@metadata.code.branch_hint "\00")
      (br_if $out
        (local.get $x)
      )
      (br_if $out
        (local.get $y)
      )

      (call $none)
      (br_if $out
        (local.get $y)
      )
    )
  )

  ;; CHECK:      (func $join-br_ifs-no-flip (type $0) (param $x i32) (param $y i32)
  ;; CHECK-NEXT:  (block $out
  ;; CHECK-NEXT:   (br_if $out
  ;; CHECK-NEXT:    (i32.or
  ;; CHECK-NEXT:     (local.get $x)
  ;; CHECK-NEXT:     (local.get $y)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (call $none)
  ;; CHECK-NEXT:   (br_if $out
  ;; CHECK-NEXT:    (local.get $y)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $join-br_ifs-no-flip (param $x i32) (param $y i32)
    ;; The other one is missing the hint, so we clear the hint.
    (block $out
      (br_if $out
        (local.get $x)
      )
      (@metadata.code.branch_hint "\00")
      (br_if $out
        (local.get $y)
      )

      (call $none)
      (br_if $out
        (local.get $y)
      )
    )
  )

  ;; CHECK:      (func $join-br_ifs-yes-one (type $0) (param $x i32) (param $y i32)
  ;; CHECK-NEXT:  (block $out
  ;; CHECK-NEXT:   (@metadata.code.branch_hint "\01")
  ;; CHECK-NEXT:   (br_if $out
  ;; CHECK-NEXT:    (i32.or
  ;; CHECK-NEXT:     (local.get $x)
  ;; CHECK-NEXT:     (local.get $y)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (call $none)
  ;; CHECK-NEXT:   (br_if $out
  ;; CHECK-NEXT:    (local.get $y)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $join-br_ifs-yes-one (param $x i32) (param $y i32)
    ;; One has a 1 hint, so we can use that.
    (block $out
      (@metadata.code.branch_hint "\01")
      (br_if $out
        (local.get $x)
      )
      (br_if $out
        (local.get $y)
      )

      (call $none)
      (br_if $out
        (local.get $y)
      )
    )
  )

  ;; CHECK:      (func $join-br_ifs-yes-other (type $0) (param $x i32) (param $y i32)
  ;; CHECK-NEXT:  (block $out
  ;; CHECK-NEXT:   (@metadata.code.branch_hint "\01")
  ;; CHECK-NEXT:   (br_if $out
  ;; CHECK-NEXT:    (i32.or
  ;; CHECK-NEXT:     (local.get $x)
  ;; CHECK-NEXT:     (local.get $y)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (call $none)
  ;; CHECK-NEXT:   (br_if $out
  ;; CHECK-NEXT:    (local.get $y)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $join-br_ifs-yes-other (param $x i32) (param $y i32)
    ;; As above, but the other has the 1, which we can still use.
    (block $out
      (br_if $out
        (local.get $x)
      )
      (@metadata.code.branch_hint "\01")
      (br_if $out
        (local.get $y)
      )

      (call $none)
      (br_if $out
        (local.get $y)
      )
    )
  )

  ;; CHECK:      (func $join-br_ifs-mismatch (type $0) (param $x i32) (param $y i32)
  ;; CHECK-NEXT:  (block $out
  ;; CHECK-NEXT:   (@metadata.code.branch_hint "\01")
  ;; CHECK-NEXT:   (br_if $out
  ;; CHECK-NEXT:    (i32.or
  ;; CHECK-NEXT:     (local.get $x)
  ;; CHECK-NEXT:     (local.get $y)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (call $none)
  ;; CHECK-NEXT:   (br_if $out
  ;; CHECK-NEXT:    (local.get $y)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $join-br_ifs-mismatch (param $x i32) (param $y i32)
    ;; The hints do not match, but we can still use the 1 hint.
    (block $out
      (@metadata.code.branch_hint "\00")
      (br_if $out
        (local.get $x)
      )
      (@metadata.code.branch_hint "\01")
      (br_if $out
        (local.get $y)
      )

      (call $none)
      (br_if $out
        (local.get $y)
      )
    )
  )
)
