;; NOTE: Assertions have been generated by update_lit_checks.py --all-items and should not be edited.
;; RUN: wasm-ctor-eval %s --ctors=test --quiet -all -S -o - | filecheck %s

;; We will execute the arrays here when we try to precompute them. Each such
;; computation should be done once, so that we preserve identity (which other
;; tests handle). We should handle that without repeated work: once we compute a
;; thing, we can reuse that computation. If we do not, this test will still
;; pass, but it will take many minutes to run (exponential time), hopefully
;; timing out the bots. With the optimization, it takes only ms.

(module
  (type $array (sub (shared (array (ref null $array)))))

  ;; CHECK:      (type $0 (func (param f32)))

  ;; CHECK:      (type $1 (func))

  ;; CHECK:      (import "" "" (func $imported (type $0) (param f32)))
  (import "" "" (func $imported (param f32)))

  (func $test (export "test")
    (local $local (ref $array))
    (local.set $local
      (array.new $array
        (array.new $array
          (array.new $array
            (array.new $array
              (array.new $array
                (array.new_default $array
                  (i32.const 0)
                )
                (i32.const 100)
              )
              (i32.const 100)
            )
            (i32.const 100)
          )
          (i32.const 100)
        )
        (i32.const 100)
      )
    )
    (call $imported
      (f32.const 0)
    )
  )
)
;; CHECK:      (export "test" (func $test_2))

;; CHECK:      (func $test_2 (type $1)
;; CHECK-NEXT:  (call $imported
;; CHECK-NEXT:   (f32.const 0)
;; CHECK-NEXT:  )
;; CHECK-NEXT: )
