#ifndef _CEGOADMMON_H_INCLUDED_
#define _CEGOADMMON_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoAdmMon.h  
// ---------------
// Cego admin monitor interface definition
//
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2019 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoAdmMon
// 
// Description: Description: Cursor based administration database administration frontend
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

#include <ctype.h>
#include <string.h>

#include <lfcbase/Chain.h>
#include <lfcbase/ListT.h>
#include <lfcbase/Datetime.h>
#include <lfcbase/SigHandler.h>
#include <lfcbase/Monitor.h>

#include "CegoAdminHandler.h"

class CegoAdmMon : public Monitor {
    
public:
    
    CegoAdmMon(CegoAdminHandler *pAH);
    ~CegoAdmMon();
    
    void showMonitor();

private:

    void showPool();
    void showDBThread();
    void showLastThreadAction(int threadId);
	
    void showAdmThread();
    void showLogThread();

    void showTableSet();
    void showTableSetInfo(const Chain& tableSet);
    void showTableSetDefineMask();
    int showTableSetActionMenu(const Chain& tsStatus);
    void showTableSetAddFile(const Chain& tableSet);
    void showTableSetFileInfo(const Chain& tableSet);
    void showTableSetBackupInfo(const Chain& tableSet);
    
    void showTableSetAddArchlog(const Chain& tableSet);
    void showTableSetListArchlog(const Chain& tableSet);
    void showTableSetRemoveArchlog(const Chain& tableSet);
    void showTableSetToggleArchlog(const Chain& tableSet);
    void showTableSetRestore(const Chain& tableSet);
    
    void performTableSetAction(const Chain& tableset, int action);
    void showTableSetHelp();
    
    void showUser();
    void showUserAddMask();
    void showRoleAssignMask(const Chain& userName, const ListT<Chain>& userRoleList);
    void showRoleRemoveMask(const Chain& userName, const ListT<Chain>& userRoleList);
    void showUserChangePwd(const Chain& userName);
    int showUserActionMenu();

    void showRole();
    void showRoleAddMask();
    int showRoleActionMenu();
    void showRolePermListMask(const Chain& role);
    void showRolePermSetMask(const Chain& role);
    void showRolePermRemoveMask(const Chain& role);
    void showRefreshMenu();

    ListT<Chain> roleString2List(const Chain& roleString);
    
    CegoAdminHandler* _pAH;

    int _refInterval;
};

#endif














