/**
 * @license
 * Copyright 2025 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import { describe, it, expect } from 'vitest';
import { installCommand } from './install.js';
import yargs from 'yargs';
describe('extensions install command', () => {
    it('should fail if no source is provided', () => {
        const validationParser = yargs([])
            .locale('en')
            .command(installCommand)
            .fail(false);
        expect(() => validationParser.parse('install')).toThrow('Either a git URL --source or a --path must be provided.');
    });
    it('should fail if both git source and local path are provided', () => {
        const validationParser = yargs([])
            .locale('en')
            .command(installCommand)
            .fail(false);
        expect(() => validationParser.parse('install --source some-url --path /some/path')).toThrow('Arguments source and path are mutually exclusive');
    });
});
//# sourceMappingURL=install.test.js.map