/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.system;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;

public class Parser {
    private FileReader file;
    private BufferedReader bf;
    private String[] lineTokens;
    private int index;

    public Parser(String string) throws FileNotFoundException {
        this.file = new FileReader(string);
        this.bf = new BufferedReader(this.file);
        this.lineTokens = new String[0];
        this.index = 0;
    }

    public void close() throws IOException {
        if (this.file != null) {
            this.file.close();
        }
        this.bf = null;
    }

    public String getNextToken() throws IOException {
        String string;
        while (true) {
            if ((string = this.fetchNextToken()) == null) {
                return null;
            }
            if (!string.equals("/*")) break;
            do {
                if ((string = this.fetchNextToken()) != null) continue;
                return null;
            } while (!string.equals("*/"));
        }
        return string;
    }

    public boolean peekNextToken(String string) throws IOException {
        String string2;
        while (true) {
            if ((string2 = this.fetchNextToken()) == null) {
                return false;
            }
            if (!string2.equals("/*")) break;
            do {
                if ((string2 = this.fetchNextToken()) != null) continue;
                return false;
            } while (!string2.equals("*/"));
        }
        if (string2.equals(string)) {
            return true;
        }
        --this.index;
        return false;
    }

    private String fetchNextToken() throws IOException {
        if (this.bf == null) {
            return null;
        }
        do {
            if (this.index >= this.lineTokens.length) continue;
            return this.lineTokens[this.index++];
        } while (this.getNextLine());
        return null;
    }

    private boolean getNextLine() throws IOException {
        String string = this.bf.readLine();
        if (string == null) {
            return false;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = new String();
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (string2.length() == 0 && (c == '%' || c == '#')) break;
            boolean bl2 = c == '\"';
            if (!(bl2 || !(bl ^= bl2) && Character.isWhitespace(c))) {
                string2 = string2 + c;
                continue;
            }
            if (string2.length() <= 0) continue;
            arrayList.add(string2);
            string2 = new String();
        }
        if (string2.length() > 0) {
            arrayList.add(string2);
        }
        this.lineTokens = arrayList.toArray(new String[0]);
        this.index = 0;
        return true;
    }

    public String getNextCodeBlock() throws ParserException, IOException {
        String string = new String();
        this.checkNextToken("<code>");
        while (true) {
            String string2;
            try {
                string2 = this.bf.readLine();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return null;
            }
            if (string2.trim().equals("</code>")) {
                return string;
            }
            string = string + string2;
            string = string + "\n";
        }
    }

    public boolean getNextBoolean() throws IOException {
        return Boolean.valueOf(this.getNextToken());
    }

    public int getNextInt() throws IOException {
        return Integer.parseInt(this.getNextToken());
    }

    public float getNextFloat() throws IOException {
        return Float.parseFloat(this.getNextToken());
    }

    public void checkNextToken(String string) throws ParserException, IOException {
        String string2 = this.getNextToken();
        if (!string.equals(string2)) {
            this.close();
            throw new ParserException(string, string2);
        }
    }

    public static class ParserException
    extends Exception {
        private ParserException(String string, String string2) {
            super(String.format("Expecting %s found %s", string, string2));
        }
    }
}

