/**
 * SECTION:presence-details
 * @short_description: Interface exposing a <link linkend="FolksPersona"><type>FolksPersona</type></link>&apos;s or <link linkend="FolksIndividual"><type>FolksIndividual</type></link>&apos;s presence; their current availability, such as for chatting.
 * 
 * <para>If the <link linkend="FolksBackend"><type>FolksBackend</type></link> providing the <link linkend="FolksPersona"><type>FolksPersona</type></link> doesn&apos;t support presence, the <link linkend="FolksPersona"><type>FolksPersona</type></link>&apos;s <code>presence_type</code> will be set to <link linkend="FOLKS-PRESENCE-TYPE-UNSET"><type>FOLKS_PRESENCE_TYPE_UNSET</type></link> and their <code>presence_message</code> will be an empty string.</para>
 */
/**
 * FolksPresenceType:
 * @FOLKS_PRESENCE_TYPE_UNSET: never set
 * @FOLKS_PRESENCE_TYPE_OFFLINE: offline
 * @FOLKS_PRESENCE_TYPE_AVAILABLE: available
 * @FOLKS_PRESENCE_TYPE_AWAY: away from keyboard
 * @FOLKS_PRESENCE_TYPE_EXTENDED_AWAY: away from keyboard for an extended period of time
 * @FOLKS_PRESENCE_TYPE_HIDDEN: also known as &quot;invisible&quot; or &quot;appear offline&quot;
 * @FOLKS_PRESENCE_TYPE_BUSY: at keyboard, but too busy to chat
 * @FOLKS_PRESENCE_TYPE_UNKNOWN: presence not received from server
 * @FOLKS_PRESENCE_TYPE_ERROR: an error occurred with fetching the presence
 * 
 * The possible presence states an object implementing <link linkend="FolksPresenceDetails"><type>FolksPresenceDetails</type></link> could be in.
 * 
 * <para>These closely follow the <ulink url="http://telepathy.freedesktop.org/spec/Connection_Interface_Simple_Presence.html#Connection_Presence_Type">SimplePresence</ulink> interface in the Telepathy specification.</para>
 */
/**
 * folks_presence_details_is_online:
 * @self: the <link linkend="FolksPresenceDetails"><type>FolksPresenceDetails</type></link> instance
 * 
 * Whether the contact is online.
 * 
 * <para>This will be <code>true</code> if the contact&apos;s presence type is higher than <link linkend="FOLKS-PRESENCE-TYPE-OFFLINE"><type>FOLKS_PRESENCE_TYPE_OFFLINE</type></link>, as determined by <link linkend="folks-presence-details-typecmp"><function>folks_presence_details_typecmp()</function></link>.</para>
 * 
 * Returns: <para><code>true</code> if the contact is online, <code>false</code> otherwise </para>
 */
/**
 * FolksPresenceDetails:presence-type:
 * 
 * The contact&apos;s presence type.
 * 
 * <para>Each contact can have one and only one presence type at any one time, representing their availability for communication. The default presence type is <link linkend="FOLKS-PRESENCE-TYPE-UNSET"><type>FOLKS_PRESENCE_TYPE_UNSET</type></link>.</para>
 */
/**
 * folks_presence_details_get_presence_type:
 * @self: the <link linkend="FolksPresenceDetails"><type>FolksPresenceDetails</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksPresenceDetails--presence-type"><type>"presence-type"</type></link> property.
 * 
 * The contact&apos;s presence type.
 * 
 * <para>Each contact can have one and only one presence type at any one time, representing their availability for communication. The default presence type is <link linkend="FOLKS-PRESENCE-TYPE-UNSET"><type>FOLKS_PRESENCE_TYPE_UNSET</type></link>.</para>
 * 
 * Returns: the value of the <link linkend="FolksPresenceDetails--presence-type"><type>"presence-type"</type></link> property
 */
/**
 * folks_presence_details_set_presence_type:
 * @self: the <link linkend="FolksPresenceDetails"><type>FolksPresenceDetails</type></link> instance to modify
 * @value: the new value of the <link linkend="FolksPresenceDetails--presence-type"><type>"presence-type"</type></link> property
 * 
 * Set the value of the <link linkend="FolksPresenceDetails--presence-type"><type>"presence-type"</type></link> property to @value.
 * 
 * The contact&apos;s presence type.
 * 
 * <para>Each contact can have one and only one presence type at any one time, representing their availability for communication. The default presence type is <link linkend="FOLKS-PRESENCE-TYPE-UNSET"><type>FOLKS_PRESENCE_TYPE_UNSET</type></link>.</para>
 */
/**
 * FolksPresenceDetails:presence-message:
 * 
 * The contact&apos;s presence message.
 * 
 * <para>This is a short message written by the contact to add detail to their presence type (<link linkend="FolksPresenceDetails--presence-type"><type>"presence-type"</type></link>). If the contact hasn&apos;t set a message, it will be an empty string.</para>
 */
/**
 * folks_presence_details_get_presence_message:
 * @self: the <link linkend="FolksPresenceDetails"><type>FolksPresenceDetails</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksPresenceDetails--presence-message"><type>"presence-message"</type></link> property.
 * 
 * The contact&apos;s presence message.
 * 
 * <para>This is a short message written by the contact to add detail to their presence type (<link linkend="FolksPresenceDetails--presence-type"><type>"presence-type"</type></link>). If the contact hasn&apos;t set a message, it will be an empty string.</para>
 * 
 * Returns: the value of the <link linkend="FolksPresenceDetails--presence-message"><type>"presence-message"</type></link> property
 */
/**
 * folks_presence_details_set_presence_message:
 * @self: the <link linkend="FolksPresenceDetails"><type>FolksPresenceDetails</type></link> instance to modify
 * @value: the new value of the <link linkend="FolksPresenceDetails--presence-message"><type>"presence-message"</type></link> property
 * 
 * Set the value of the <link linkend="FolksPresenceDetails--presence-message"><type>"presence-message"</type></link> property to @value.
 * 
 * The contact&apos;s presence message.
 * 
 * <para>This is a short message written by the contact to add detail to their presence type (<link linkend="FolksPresenceDetails--presence-type"><type>"presence-type"</type></link>). If the contact hasn&apos;t set a message, it will be an empty string.</para>
 */
/**
 * FolksPresenceDetails:client-types:
 * @result_length1: return location for the length of the property's value
 * @value_length1: length of the property's new value
 * 
 * The contact&apos;s client types.
 * 
 * <para>One can connect to instant messaging networks on a huge variety of devices, from PCs, to phones to consoles. The client types are represented in strings, using the values <ulink url="http://xmpp.org/registrar/disco-categories.html#client">documented by the XMPP registrar</ulink></para>
 *
 * Since: 0.9.5
 */
/**
 * folks_presence_details_get_client_types:
 * @self: the <link linkend="FolksPresenceDetails"><type>FolksPresenceDetails</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksPresenceDetails--client-types"><type>"client-types"</type></link> property.
 * 
 * The contact&apos;s client types.
 * 
 * <para>One can connect to instant messaging networks on a huge variety of devices, from PCs, to phones to consoles. The client types are represented in strings, using the values <ulink url="http://xmpp.org/registrar/disco-categories.html#client">documented by the XMPP registrar</ulink></para>
 * 
 * Returns: the value of the <link linkend="FolksPresenceDetails--client-types"><type>"client-types"</type></link> property
 *
 * Since: 0.9.5
 */
/**
 * folks_presence_details_set_client_types:
 * @self: the <link linkend="FolksPresenceDetails"><type>FolksPresenceDetails</type></link> instance to modify
 * @value: the new value of the <link linkend="FolksPresenceDetails--client-types"><type>"client-types"</type></link> property
 * 
 * Set the value of the <link linkend="FolksPresenceDetails--client-types"><type>"client-types"</type></link> property to @value.
 * 
 * The contact&apos;s client types.
 * 
 * <para>One can connect to instant messaging networks on a huge variety of devices, from PCs, to phones to consoles. The client types are represented in strings, using the values <ulink url="http://xmpp.org/registrar/disco-categories.html#client">documented by the XMPP registrar</ulink></para>
 *
 * Since: 0.9.5
 */
/**
 * FolksPresenceDetails:presence-status:
 * 
 * The contact&apos;s detailed presence status.
 * 
 * <para>This is a more detailed representation of the contact&apos;s presence than <link linkend="FolksPresenceDetails--presence-type"><type>"presence-type"</type></link>. It may be empty, or one of a well-known set of strings, as defined in the Telepathy specification: <ulink url="http://telepathy.freedesktop.org/spec/Connection_Interface_Simple_Presence.html#description">Telepathy Specification</ulink></para>
 *
 * Since: 0.6.0
 */
/**
 * folks_presence_details_get_presence_status:
 * @self: the <link linkend="FolksPresenceDetails"><type>FolksPresenceDetails</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksPresenceDetails--presence-status"><type>"presence-status"</type></link> property.
 * 
 * The contact&apos;s detailed presence status.
 * 
 * <para>This is a more detailed representation of the contact&apos;s presence than <link linkend="FolksPresenceDetails--presence-type"><type>"presence-type"</type></link>. It may be empty, or one of a well-known set of strings, as defined in the Telepathy specification: <ulink url="http://telepathy.freedesktop.org/spec/Connection_Interface_Simple_Presence.html#description">Telepathy Specification</ulink></para>
 * 
 * Returns: the value of the <link linkend="FolksPresenceDetails--presence-status"><type>"presence-status"</type></link> property
 *
 * Since: 0.6.0
 */
/**
 * folks_presence_details_set_presence_status:
 * @self: the <link linkend="FolksPresenceDetails"><type>FolksPresenceDetails</type></link> instance to modify
 * @value: the new value of the <link linkend="FolksPresenceDetails--presence-status"><type>"presence-status"</type></link> property
 * 
 * Set the value of the <link linkend="FolksPresenceDetails--presence-status"><type>"presence-status"</type></link> property to @value.
 * 
 * The contact&apos;s detailed presence status.
 * 
 * <para>This is a more detailed representation of the contact&apos;s presence than <link linkend="FolksPresenceDetails--presence-type"><type>"presence-type"</type></link>. It may be empty, or one of a well-known set of strings, as defined in the Telepathy specification: <ulink url="http://telepathy.freedesktop.org/spec/Connection_Interface_Simple_Presence.html#description">Telepathy Specification</ulink></para>
 *
 * Since: 0.6.0
 */
/**
 * folks_presence_details_get_default_message_from_type:
 * @type: (in): &nbsp;.  <para>a <link linkend="FolksPresenceType"><type>FolksPresenceType</type></link> for which to retrieve a translated display string </para>
 * 
 * The default message for a presence type.
 * 
 * Returns: (transfer none): <para>a default translated display string for the given <link linkend="FolksPresenceType"><type>FolksPresenceType</type></link> </para>
 *
 * Since: 0.7.1
 */
/**
 * folks_presence_details_typecmp:
 * @type_a: (in): &nbsp;.  <para>the first <link linkend="FolksPresenceType"><type>FolksPresenceType</type></link> to compare </para>
 * @type_b: (in): &nbsp;.  <para>the second <link linkend="FolksPresenceType"><type>FolksPresenceType</type></link> to compare </para>
 * 
 * Compare two <link linkend="FolksPresenceType"><type>FolksPresenceType</type></link>s.
 * 
 * <para><code>0</code> will be returned if the types are equal, a positive number will be returned if <code>type_a</code> is more available than <code>type_b</code>, and a negative number will be returned if the opposite is true.</para>
 * 
 * Returns: <para>a number representing the similarity of the two types </para>
 *
 * Since: 0.1.11
 */
/**
 * FolksPresenceDetails:
 * 
 * Interface exposing a <link linkend="FolksPersona"><type>FolksPersona</type></link>&apos;s or <link linkend="FolksIndividual"><type>FolksIndividual</type></link>&apos;s presence; their current availability, such as for chatting.
 * 
 * <para>If the <link linkend="FolksBackend"><type>FolksBackend</type></link> providing the <link linkend="FolksPersona"><type>FolksPersona</type></link> doesn&apos;t support presence, the <link linkend="FolksPersona"><type>FolksPersona</type></link>&apos;s <code>presence_type</code> will be set to <link linkend="FOLKS-PRESENCE-TYPE-UNSET"><type>FOLKS_PRESENCE_TYPE_UNSET</type></link> and their <code>presence_message</code> will be an empty string.</para>
 */
/**
 * FolksPresenceDetailsIface:
 * @get_presence_type: getter method for the abstract property <link linkend="FolksPresenceDetails--presence-type"><type>"presence-type"</type></link>
 * @set_presence_type: setter method for the abstract property <link linkend="FolksPresenceDetails--presence-type"><type>"presence-type"</type></link>
 * @get_presence_message: getter method for the abstract property <link linkend="FolksPresenceDetails--presence-message"><type>"presence-message"</type></link>
 * @set_presence_message: setter method for the abstract property <link linkend="FolksPresenceDetails--presence-message"><type>"presence-message"</type></link>
 * @get_client_types: getter method for the abstract property <link linkend="FolksPresenceDetails--client-types"><type>"client-types"</type></link>
 * @set_client_types: setter method for the abstract property <link linkend="FolksPresenceDetails--client-types"><type>"client-types"</type></link>
 * @get_presence_status: getter method for the abstract property <link linkend="FolksPresenceDetails--presence-status"><type>"presence-status"</type></link>
 * @set_presence_status: setter method for the abstract property <link linkend="FolksPresenceDetails--presence-status"><type>"presence-status"</type></link>
 * @parent_iface: the parent interface structure
 * 
 * Interface for creating <link linkend="FolksPresenceDetails"><type>FolksPresenceDetails</type></link> implementations.
 */
