/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.view;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.extension.AbstractPanel;
import org.parosproxy.paros.extension.ViewDelegate;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.OptionsParam;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.view.AbstractParamPanel;
import org.parosproxy.paros.view.MainFrame;
import org.parosproxy.paros.view.MainPopupMenu;
import org.parosproxy.paros.view.OptionsDialog;
import org.parosproxy.paros.view.OutputPanel;
import org.parosproxy.paros.view.SessionDialog;
import org.parosproxy.paros.view.SessionGeneralPanel;
import org.parosproxy.paros.view.SiteMapPanel;
import org.parosproxy.paros.view.WaitMessageDialog;
import org.parosproxy.paros.view.WorkbenchPanel;
import org.zaproxy.zap.control.AddOn;
import org.zaproxy.zap.extension.help.ExtensionHelp;
import org.zaproxy.zap.extension.httppanel.HttpPanelRequest;
import org.zaproxy.zap.extension.httppanel.HttpPanelResponse;
import org.zaproxy.zap.extension.httppanel.Message;
import org.zaproxy.zap.extension.keyboard.ExtensionKeyboard;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.utils.DisplayUtils;
import org.zaproxy.zap.utils.ZapHtmlLabel;
import org.zaproxy.zap.utils.ZapLabel;
import org.zaproxy.zap.view.AbstractContextPropertiesPanel;
import org.zaproxy.zap.view.ContextExcludePanel;
import org.zaproxy.zap.view.ContextGeneralPanel;
import org.zaproxy.zap.view.ContextIncludePanel;
import org.zaproxy.zap.view.ContextListPanel;
import org.zaproxy.zap.view.ContextPanelFactory;
import org.zaproxy.zap.view.ContextStructurePanel;
import org.zaproxy.zap.view.ContextTechnologyPanel;
import org.zaproxy.zap.view.SessionExcludeFromProxyPanel;
import org.zaproxy.zap.view.SessionExcludeFromScanPanel;
import org.zaproxy.zap.view.SessionExcludeFromSpiderPanel;
import org.zaproxy.zap.view.SplashScreen;
import org.zaproxy.zap.view.StatusUI;
import org.zaproxy.zap.view.ZapMenuItem;
import org.zaproxy.zap.view.messagelocation.MessageLocationHighlightRenderersEditors;
import org.zaproxy.zap.view.messagelocation.TextMessageLocationHighlight;
import org.zaproxy.zap.view.messagelocation.TextMessageLocationHighlightEditor;
import org.zaproxy.zap.view.messagelocation.TextMessageLocationHighlightRenderer;

public class View
implements ViewDelegate {
    public static final int DISPLAY_OPTION_ICONNAMES = 0;
    public static final int DISPLAY_OPTION_ONLYICONS = 1;
    private static View view = null;
    private static boolean daemon = false;
    private SessionDialog sessionDialog = null;
    private OptionsDialog optionsDialog = null;
    private MainFrame mainFrame = null;
    private HttpPanelRequest requestPanel = null;
    private HttpPanelResponse responsePanel = null;
    private SiteMapPanel siteMapPanel = null;
    private OutputPanel outputPanel;
    private Vector<JMenuItem> popupList = new Vector();
    private JMenu menuShowTabs = null;
    private JCheckBox rememberCheckbox = null;
    private JCheckBox dontPromptCheckbox = null;
    private List<AbstractContextPropertiesPanel> contextPanels = new ArrayList<AbstractContextPropertiesPanel>();
    private List<ContextPanelFactory> contextPanelFactories = new ArrayList<ContextPanelFactory>();
    private Map<ContextPanelFactory, List<AbstractContextPropertiesPanel>> contextPanelFactoriesPanels = new HashMap<ContextPanelFactory, List<AbstractContextPropertiesPanel>>();
    private static final Logger LOGGER = LogManager.getLogger(View.class);
    private SplashScreen splashScreen = null;
    private Map<AddOn.Status, StatusUI> statusMap = new HashMap<AddOn.Status, StatusUI>();
    private boolean postInitialisation;
    private KeyStroke defaultDeleteKeyStroke;
    private boolean canGetFocus = true;

    @Override
    public MainFrame getMainFrame() {
        return this.mainFrame;
    }

    public void init() {
        OptionsParam options = Model.getSingleton().getOptionsParam();
        this.mainFrame = new MainFrame(options, this.getRequestPanel(), this.getResponsePanel());
        this.mainFrame.getWorkbench().addPanel(View.getSingleton().getSiteTreePanel(), WorkbenchPanel.PanelType.SELECT);
        MessageLocationHighlightRenderersEditors.getInstance().addEditor(TextMessageLocationHighlight.class, new TextMessageLocationHighlightEditor());
        MessageLocationHighlightRenderersEditors.getInstance().addRenderer(TextMessageLocationHighlight.class, new TextMessageLocationHighlightRenderer());
        for (AddOn.Status status : AddOn.Status.values()) {
            String i18nKey = "cfu.status." + status.toString();
            String statusString = Constant.messages.containsKey(i18nKey) ? Constant.messages.getString(i18nKey) : status.toString();
            this.statusMap.put(status, new StatusUI(status, statusString));
        }
    }

    public void postInit() {
        this.setOutputPanel(this.getOutputPanel());
        this.refreshTabViewMenus();
        JMenuItem showAllMenu = new JMenuItem(Constant.messages.getString("menu.view.tabs.show"));
        showAllMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                View.this.showAllTabs();
            }
        });
        this.mainFrame.getMainMenuBar().getMenuView().add(showAllMenu);
        JMenuItem hideAllMenu = new JMenuItem(Constant.messages.getString("menu.view.tabs.hide"));
        hideAllMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                View.this.hideAllTabs();
            }
        });
        this.mainFrame.getMainMenuBar().getMenuView().add(hideAllMenu);
        JMenuItem pinAllMenu = new JMenuItem(Constant.messages.getString("menu.view.tabs.pin"));
        pinAllMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                View.this.pinAllTabs();
            }
        });
        this.mainFrame.getMainMenuBar().getMenuView().add(pinAllMenu);
        JMenuItem unpinAllMenu = new JMenuItem(Constant.messages.getString("menu.view.tabs.unpin"));
        unpinAllMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                View.this.unpinAllTabs();
            }
        });
        this.mainFrame.getMainMenuBar().getMenuView().add(unpinAllMenu);
        this.postInitialisation = true;
    }

    @Override
    public KeyStroke getDefaultDeleteKeyStroke() {
        if (this.defaultDeleteKeyStroke == null) {
            this.defaultDeleteKeyStroke = KeyStroke.getKeyStroke(127, 0, false);
        }
        return this.defaultDeleteKeyStroke;
    }

    public void refreshTabViewMenus() {
        if (this.menuShowTabs == null) {
            this.menuShowTabs = new JMenu(Constant.messages.getString("menu.view.showtab"));
            this.mainFrame.getMainMenuBar().getMenuView().add(this.menuShowTabs);
        } else {
            this.menuShowTabs.removeAll();
        }
        ExtensionKeyboard extKey = Control.getSingleton().getExtensionLoader().getExtension(ExtensionKeyboard.class);
        for (AbstractPanel panel : this.getWorkbench().getSortedPanels(WorkbenchPanel.PanelType.SELECT)) {
            this.registerMenu(extKey, panel);
        }
        this.menuShowTabs.addSeparator();
        for (AbstractPanel panel : this.getWorkbench().getSortedPanels(WorkbenchPanel.PanelType.WORK)) {
            this.registerMenu(extKey, panel);
        }
        this.menuShowTabs.addSeparator();
        for (AbstractPanel panel : this.getWorkbench().getSortedPanels(WorkbenchPanel.PanelType.STATUS)) {
            this.registerMenu(extKey, panel);
        }
    }

    private void registerMenu(ExtensionKeyboard extKey, final AbstractPanel ap) {
        ZapMenuItem tabMenu = new ZapMenuItem(ap.getClass().getName(), Constant.messages.getString("menu.view.tab", ap.getName()), ap.getDefaultAccelerator());
        tabMenu.setMnemonic(ap.getMnemonic());
        if (ap.getIcon() != null) {
            tabMenu.setIcon(DisplayUtils.getScaledIcon(ap.getIcon()));
        }
        tabMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                View.this.getWorkbench().showPanel(ap);
            }
        });
        this.menuShowTabs.add(tabMenu);
        if (extKey != null) {
            extKey.registerMenuItem(tabMenu);
        }
    }

    public void showAllTabs() {
        this.getWorkbench().setPanelsVisible(true);
    }

    public void hideAllTabs() {
        this.getWorkbench().setPanelsVisible(false);
    }

    public void pinAllTabs() {
        this.getWorkbench().pinVisiblePanels();
    }

    public void unpinAllTabs() {
        this.getWorkbench().unpinVisiblePanels();
    }

    public void showSplashScreen() {
        if (Model.getSingleton().getOptionsParam().getViewParam().isShowSplashScreen()) {
            this.splashScreen = new SplashScreen();
        }
    }

    public void hideSplashScreen() {
        if (this.splashScreen != null) {
            this.splashScreen.close();
            this.splashScreen = null;
        }
    }

    public void setSplashScreenLoadingCompletion(double percentage) {
        if (this.splashScreen != null) {
            this.splashScreen.setLoadingCompletion(percentage);
        }
    }

    public void addSplashScreenLoadingCompletion(double percentage) {
        if (this.splashScreen != null) {
            this.splashScreen.addLoadingCompletion(percentage);
        }
    }

    @Override
    public int showConfirmDialog(String msg) {
        return this.showConfirmDialog((Window)this.getMainFrame(), msg);
    }

    public int showConfirmDialog(ZapHtmlLabel label) {
        return this.showConfirmDialog((Window)this.getMainFrame(), label);
    }

    public int showConfirmDialog(JPanel parent, String msg) {
        return JOptionPane.showConfirmDialog(parent, msg, "ZAP", 2);
    }

    public int showConfirmDialog(JPanel parent, ZapHtmlLabel label) {
        return JOptionPane.showConfirmDialog(parent, label, "ZAP", 2);
    }

    public int showConfirmDialog(Window parent, String msg) {
        return JOptionPane.showConfirmDialog(parent, msg, "ZAP", 2);
    }

    public int showConfirmDialog(Window parent, ZapHtmlLabel label) {
        return JOptionPane.showConfirmDialog(parent, label, "ZAP", 2);
    }

    @Override
    public int showYesNoCancelDialog(String msg) {
        return this.showYesNoCancelDialog((Window)this.getMainFrame(), msg);
    }

    public int showYesNoCancelDialog(ZapHtmlLabel label) {
        return this.showYesNoCancelDialog((Window)this.getMainFrame(), label);
    }

    public int showYesNoCancelDialog(JPanel parent, String msg) {
        return JOptionPane.showConfirmDialog(parent, msg, "ZAP", 1);
    }

    public int showYesNoCancelDialog(JPanel parent, ZapHtmlLabel label) {
        return JOptionPane.showConfirmDialog(parent, label, "ZAP", 1);
    }

    public int showYesNoCancelDialog(Window parent, String msg) {
        return JOptionPane.showConfirmDialog(parent, msg, "ZAP", 1);
    }

    public int showYesNoCancelDialog(Window parent, ZapHtmlLabel label) {
        return JOptionPane.showConfirmDialog(parent, label, "ZAP", 1);
    }

    @Override
    public void showWarningDialog(String msg) {
        this.showWarningDialog((Window)this.getMainFrame(), msg);
    }

    public void showWarningDialog(ZapHtmlLabel label) {
        this.showWarningDialog((Window)this.getMainFrame(), label);
    }

    public void showWarningDialog(JPanel parent, String msg) {
        JOptionPane.showMessageDialog(parent, new ZapLabel(msg), "ZAP", 2);
    }

    public void showWarningDialog(JPanel parent, ZapHtmlLabel label) {
        JOptionPane.showMessageDialog(parent, label, "ZAP", 2);
    }

    public void showWarningDialog(Window parent, String msg) {
        JOptionPane.showMessageDialog(parent, new ZapLabel(msg), "ZAP", 2);
    }

    public void showWarningDialog(Window parent, ZapHtmlLabel label) {
        JOptionPane.showMessageDialog(parent, label, "ZAP", 2);
    }

    @Override
    public void showMessageDialog(String msg) {
        this.showMessageDialog((Window)this.getMainFrame(), msg);
    }

    public void showMessageDialog(ZapHtmlLabel label) {
        this.showMessageDialog((Window)this.getMainFrame(), label);
    }

    public void showMessageDialog(JPanel parent, String msg) {
        JOptionPane.showMessageDialog(parent, new ZapLabel(msg), "ZAP", 1);
    }

    public void showMessageDialog(JPanel parent, ZapHtmlLabel label) {
        JOptionPane.showMessageDialog(parent, label, "ZAP", 1);
    }

    public void showMessageDialog(Window parent, String msg) {
        JOptionPane.showMessageDialog(parent, new ZapLabel(msg), "ZAP", 1);
    }

    public void showMessageDialog(Window parent, ZapHtmlLabel label) {
        JOptionPane.showMessageDialog(parent, label, "ZAP", 1);
    }

    private JCheckBox getRememberCheckbox() {
        if (this.rememberCheckbox == null) {
            this.rememberCheckbox = new JCheckBox(Constant.messages.getString("view.dialog.remember"));
        }
        return this.rememberCheckbox;
    }

    public boolean isRememberLastDialogChosen() {
        return this.getRememberCheckbox().isSelected();
    }

    public int showYesNoRememberDialog(Window parent, String msg) {
        this.getRememberCheckbox().setSelected(false);
        return JOptionPane.showConfirmDialog(parent, new Object[]{msg + "\n", this.getRememberCheckbox()}, "ZAP", 0);
    }

    public int showYesNoDialog(Window parent, Object[] objs) {
        return JOptionPane.showConfirmDialog(parent, objs, "ZAP", 0);
    }

    private JCheckBox getDontPromptCheckbox() {
        if (this.dontPromptCheckbox == null) {
            this.dontPromptCheckbox = new JCheckBox(Constant.messages.getString("view.dialog.dontPrompt"));
        }
        return this.dontPromptCheckbox;
    }

    public boolean isDontPromptLastDialogChosen() {
        return this.getDontPromptCheckbox().isSelected();
    }

    public int showConfirmDontPromptDialog(Window parent, String msg) {
        this.getDontPromptCheckbox().setSelected(false);
        return JOptionPane.showConfirmDialog(parent, new Object[]{msg + "\n", this.getDontPromptCheckbox()}, "ZAP", 2);
    }

    public void showWarningDontPromptDialog(Window parent, String msg) {
        this.getDontPromptCheckbox().setSelected(false);
        JOptionPane.showMessageDialog(parent, new Object[]{msg + "\n", this.getDontPromptCheckbox()}, "ZAP", 2);
    }

    public void showWarningDontPromptDialog(String msg) {
        this.showWarningDontPromptDialog(this.getMainFrame(), msg);
    }

    public static synchronized View getSingleton() {
        if (view == null) {
            if (daemon) {
                Exception e = new Exception("Attempting to initialise View in daemon mode");
                LOGGER.error(e.getMessage(), (Throwable)e);
                return null;
            }
            LOGGER.info("Initialising View");
            view = new View();
            view.init();
        }
        return view;
    }

    public static boolean isInitialised() {
        return view != null;
    }

    public static void setDaemon(boolean daemon) {
        View.daemon = daemon;
    }

    @Override
    public SiteMapPanel getSiteTreePanel() {
        if (this.siteMapPanel == null) {
            this.siteMapPanel = new SiteMapPanel();
        }
        return this.siteMapPanel;
    }

    @Override
    public OutputPanel getOutputPanel() {
        if (this.outputPanel == null) {
            this.outputPanel = new OutputPanel();
            ExtensionHelp.enableHelpKey(this.outputPanel, "ui.tabs.output");
        }
        return this.outputPanel;
    }

    @Override
    public void setOutputPanel(OutputPanel outputPanel) {
        if (this.outputPanel != null) {
            this.mainFrame.getWorkbench().removePanel(this.outputPanel, WorkbenchPanel.PanelType.STATUS);
        }
        this.outputPanel = outputPanel;
        this.mainFrame.getWorkbench().addPanel(this.getOutputPanel(), WorkbenchPanel.PanelType.STATUS);
    }

    @Override
    public HttpPanelRequest getRequestPanel() {
        if (this.requestPanel == null) {
            this.requestPanel = new HttpPanelRequest(false, "view.main.");
            this.requestPanel.setIcon(new ImageIcon(View.class.getResource("/resource/icon/16/105.png")));
            this.requestPanel.setName(Constant.messages.getString("http.panel.request.title"));
            this.requestPanel.setEnableViewSelect(true);
            this.requestPanel.loadConfig(Model.getSingleton().getOptionsParam().getConfig());
            this.requestPanel.setDefaultAccelerator(this.getMenuShortcutKeyStroke(82, 64, false));
            this.requestPanel.setMnemonic(Constant.messages.getChar("http.panel.request.mnemonic"));
        }
        return this.requestPanel;
    }

    @Override
    public HttpPanelResponse getResponsePanel() {
        if (this.responsePanel == null) {
            this.responsePanel = new HttpPanelResponse(false, "view.main.");
            this.responsePanel.setIcon(new ImageIcon(View.class.getResource("/resource/icon/16/106.png")));
            this.responsePanel.setName(Constant.messages.getString("http.panel.response.title"));
            this.responsePanel.setEnableViewSelect(false);
            this.responsePanel.loadConfig(Model.getSingleton().getOptionsParam().getConfig());
            this.responsePanel.setDefaultAccelerator(this.getMenuShortcutKeyStroke(82, 576, false));
            this.responsePanel.setMnemonic(Constant.messages.getChar("http.panel.response.mnemonic"));
        }
        return this.responsePanel;
    }

    @Override
    public SessionDialog getSessionDialog() {
        if (this.sessionDialog == null) {
            String[] ROOT = new String[]{};
            String propertiesTitle = Constant.messages.getString("session.properties.title");
            String dialogTitle = Constant.messages.getString("session.dialog.title");
            this.sessionDialog = new SessionDialog((Frame)this.getMainFrame(), true, propertiesTitle, dialogTitle);
            this.sessionDialog.addParamPanel(ROOT, new SessionGeneralPanel(), false);
            this.sessionDialog.addParamPanel(ROOT, new SessionExcludeFromProxyPanel(), false);
            this.sessionDialog.addParamPanel(ROOT, new SessionExcludeFromScanPanel(), false);
            this.sessionDialog.addParamPanel(ROOT, new SessionExcludeFromSpiderPanel(), false);
            this.sessionDialog.addParamPanel(ROOT, new ContextListPanel(), false);
        }
        return this.sessionDialog;
    }

    public void showSessionDialog(Session session, String panel) {
        this.showSessionDialog(session, panel, true, null);
    }

    public void showSessionDialog(Session session, String panel, boolean recreateUISharedContexts) {
        this.showSessionDialog(session, panel, recreateUISharedContexts, null);
    }

    public void showSessionDialog(Session session, String panel, boolean recreateUISharedContexts, Runnable postInitRunnable) {
        if (this.sessionDialog == null) {
            this.getSessionDialog();
        }
        if (recreateUISharedContexts) {
            this.sessionDialog.recreateUISharedContexts(session);
        }
        this.sessionDialog.initParam(session);
        if (postInitRunnable != null) {
            postInitRunnable.run();
        }
        this.sessionDialog.setTitle(Constant.messages.getString("session.properties.title"));
        this.sessionDialog.showDialog(false, panel);
    }

    public void addContext(Context c) {
        boolean expandContextNode = this.contextPanels.isEmpty();
        this.getSessionDialog().createUISharedContext(c);
        String contextsNodeName = Constant.messages.getString("context.list");
        ContextGeneralPanel contextGenPanel = new ContextGeneralPanel(c.getName(), c.getId());
        contextGenPanel.setSessionDialog(this.getSessionDialog());
        this.getSessionDialog().addParamPanel(new String[]{contextsNodeName}, contextGenPanel, false);
        this.contextPanels.add(contextGenPanel);
        String[] contextPanelPath = new String[]{contextsNodeName, contextGenPanel.getName()};
        ContextIncludePanel contextIncPanel = new ContextIncludePanel(c);
        contextIncPanel.setSessionDialog(this.getSessionDialog());
        this.getSessionDialog().addParamPanel(contextPanelPath, contextIncPanel, false);
        this.contextPanels.add(contextIncPanel);
        ContextExcludePanel contextExcPanel = new ContextExcludePanel(c);
        contextExcPanel.setSessionDialog(this.getSessionDialog());
        this.getSessionDialog().addParamPanel(contextPanelPath, contextExcPanel, false);
        this.contextPanels.add(contextExcPanel);
        ContextStructurePanel contextStructPanel = new ContextStructurePanel(c);
        contextStructPanel.setSessionDialog(this.getSessionDialog());
        this.getSessionDialog().addParamPanel(contextPanelPath, contextStructPanel, false);
        this.contextPanels.add(contextStructPanel);
        ContextTechnologyPanel contextTechPanel = new ContextTechnologyPanel(c);
        contextTechPanel.setSessionDialog(this.getSessionDialog());
        this.getSessionDialog().addParamPanel(contextPanelPath, contextTechPanel, false);
        this.contextPanels.add(contextTechPanel);
        for (ContextPanelFactory cpf : this.contextPanelFactories) {
            this.addPanelForContext(c, cpf, contextPanelPath);
        }
        this.getSiteTreePanel().reloadContextTree();
        if (expandContextNode) {
            this.getSessionDialog().expandParamPanelNode(contextGenPanel.getName());
        }
    }

    private void addPanelForContext(Context context, ContextPanelFactory contextPanelFactory, String[] panelPath) {
        AbstractContextPropertiesPanel panel = contextPanelFactory.getContextPanel(context);
        panel.setSessionDialog(this.getSessionDialog());
        this.getSessionDialog().addParamPanel(panelPath, panel, false);
        this.contextPanels.add(panel);
        List<AbstractContextPropertiesPanel> panels = this.contextPanelFactoriesPanels.get(contextPanelFactory);
        if (panels == null) {
            panels = new ArrayList<AbstractContextPropertiesPanel>();
            this.contextPanelFactoriesPanels.put(contextPanelFactory, panels);
        }
        panels.add(panel);
    }

    public void renameContext(Context c) {
        ContextGeneralPanel ctxPanel = this.getContextGeneralPanel(c);
        if (ctxPanel != null) {
            this.getSessionDialog().renamePanel(ctxPanel, c.getId() + ":" + c.getName());
        }
        this.getSiteTreePanel().reloadContextTree();
    }

    private ContextGeneralPanel getContextGeneralPanel(Context context) {
        for (AbstractParamPanel abstractParamPanel : this.contextPanels) {
            ContextGeneralPanel contextGeneralPanel;
            if (!(abstractParamPanel instanceof ContextGeneralPanel) || (contextGeneralPanel = (ContextGeneralPanel)abstractParamPanel).getContextId() != context.getId()) continue;
            return contextGeneralPanel;
        }
        return null;
    }

    public void changeContext(Context c) {
        this.getSiteTreePanel().contextChanged(c);
    }

    @Override
    public void addContextPanelFactory(ContextPanelFactory contextPanelFactory) {
        if (contextPanelFactory == null) {
            throw new IllegalArgumentException("Parameter contextPanelFactory must not be null.");
        }
        this.contextPanelFactories.add(contextPanelFactory);
        if (this.postInitialisation) {
            String contextsNodeName = Constant.messages.getString("context.list");
            for (Context context : Model.getSingleton().getSession().getContexts()) {
                ContextGeneralPanel contextGeneralPanel = this.getContextGeneralPanel(context);
                if (contextGeneralPanel == null) continue;
                this.addPanelForContext(context, contextPanelFactory, new String[]{contextsNodeName, contextGeneralPanel.getName()});
            }
        }
    }

    @Override
    public void removeContextPanelFactory(ContextPanelFactory contextPanelFactory) {
        if (contextPanelFactory == null) {
            throw new IllegalArgumentException("Parameter contextPanelFactory must not be null.");
        }
        if (this.contextPanelFactories.remove(contextPanelFactory)) {
            contextPanelFactory.discardContexts();
            List<AbstractContextPropertiesPanel> panels = this.contextPanelFactoriesPanels.remove(contextPanelFactory);
            if (panels != null) {
                for (AbstractContextPropertiesPanel panel : panels) {
                    this.getSessionDialog().removeParamPanel(panel);
                }
                this.contextPanels.removeAll(panels);
            }
        }
    }

    public void deleteContext(Context c) {
        ArrayList<AbstractContextPropertiesPanel> removedPanels = new ArrayList<AbstractContextPropertiesPanel>();
        Iterator<AbstractContextPropertiesPanel> it = this.contextPanels.iterator();
        while (it.hasNext()) {
            AbstractContextPropertiesPanel panel = it.next();
            if (panel.getContextId() != c.getId()) continue;
            this.getSessionDialog().removeParamPanel(panel);
            it.remove();
            removedPanels.add(panel);
        }
        for (ContextPanelFactory cpf : this.contextPanelFactories) {
            cpf.discardContext(c);
            List<AbstractContextPropertiesPanel> panels = this.contextPanelFactoriesPanels.get(cpf);
            if (panels == null) continue;
            panels.removeAll(removedPanels);
        }
        this.getSiteTreePanel().reloadContextTree();
    }

    public void discardContexts() {
        for (AbstractParamPanel abstractParamPanel : this.contextPanels) {
            this.getSessionDialog().removeParamPanel(abstractParamPanel);
        }
        for (ContextPanelFactory contextPanelFactory : this.contextPanelFactories) {
            contextPanelFactory.discardContexts();
            this.contextPanelFactoriesPanels.remove(contextPanelFactory);
        }
        this.contextPanels.clear();
        this.getSiteTreePanel().reloadContextTree();
    }

    @Override
    public OptionsDialog getOptionsDialog() {
        return this.getOptionsDialog(null);
    }

    public OptionsDialog getOptionsDialog(String title) {
        if (this.optionsDialog == null) {
            this.optionsDialog = new OptionsDialog((Frame)this.getMainFrame(), true, title);
        }
        this.optionsDialog.setTitle(title);
        return this.optionsDialog;
    }

    public WorkbenchPanel getWorkbench() {
        return this.mainFrame.getWorkbench();
    }

    @Override
    public MainPopupMenu getPopupMenu() {
        MainPopupMenu popup = new MainPopupMenu(this.popupList, this);
        return popup;
    }

    public Vector<JMenuItem> getPopupList() {
        return this.popupList;
    }

    @Override
    public WaitMessageDialog getWaitMessageDialog(String s) {
        WaitMessageDialog dialog = new WaitMessageDialog((Frame)this.getMainFrame(), true);
        dialog.setText(s);
        dialog.centreDialog();
        return dialog;
    }

    public WaitMessageDialog getWaitMessageDialog(JFrame parent, String s) {
        WaitMessageDialog dialog = new WaitMessageDialog((Frame)parent, true);
        dialog.setText(s);
        dialog.centreDialog();
        return dialog;
    }

    public void addMainToolbarButton(JButton button) {
        this.getMainFrame().getMainToolbarPanel().addButton(button);
    }

    public void addMainToolbarSeparator() {
        this.getMainFrame().getMainToolbarPanel().addSeparator();
    }

    public void addMainToolbarButton(JToggleButton button) {
        this.getMainFrame().getMainToolbarPanel().addButton(button);
    }

    public void removeMainToolbarButton(JButton button) {
        this.getMainFrame().getMainToolbarPanel().removeButton(button);
    }

    public void removeMainToolbarButton(JToggleButton button) {
        this.getMainFrame().getMainToolbarPanel().removeButton(button);
    }

    public void addMainToolbarSeparator(JToolBar.Separator separator) {
        this.getMainFrame().getMainToolbarPanel().addSeparator(separator);
    }

    public void removeMainToolbarSeparator(JToolBar.Separator separator) {
        this.getMainFrame().getMainToolbarPanel().removeSeparator(separator);
    }

    public Component getSplashScreen() {
        return this.splashScreen;
    }

    public StatusUI getStatusUI(AddOn.Status status) {
        return this.statusMap.get((Object)status);
    }

    public void setMainToolbarVisible(boolean visible) {
        this.getMainFrame().setMainToolbarVisible(visible);
    }

    @Override
    public void displayMessage(Message message) {
        if (message == null) {
            this.getRequestPanel().clearView(true);
            this.getResponsePanel().clearView(false);
            return;
        }
        if (!(message instanceof HttpMessage)) {
            LOGGER.warn("Unable to display message: {}", (Object)message.getClass().getCanonicalName());
            return;
        }
        HttpMessage httpMessage = (HttpMessage)message;
        if (httpMessage.getRequestHeader().isEmpty()) {
            this.getRequestPanel().clearView(true);
        } else {
            this.getRequestPanel().setMessage(httpMessage);
        }
        if (httpMessage.getResponseHeader().isEmpty()) {
            this.getResponsePanel().clearView(false);
        } else {
            this.getResponsePanel().setMessage(httpMessage, true);
        }
    }

    public boolean isCanGetFocus() {
        return this.canGetFocus;
    }

    public void setCanGetFocus(boolean canGetFocus) {
        this.canGetFocus = canGetFocus;
    }
}

