/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.DnsOptionsSpecification;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.IpAddressType;
import software.amazon.awssdk.services.ec2.model.SubnetConfiguration;
import software.amazon.awssdk.services.ec2.model.SubnetConfigurationsListCopier;
import software.amazon.awssdk.services.ec2.model.VpcEndpointRouteTableIdListCopier;
import software.amazon.awssdk.services.ec2.model.VpcEndpointSecurityGroupIdListCopier;
import software.amazon.awssdk.services.ec2.model.VpcEndpointSubnetIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyVpcEndpointRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ModifyVpcEndpointRequest> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(ModifyVpcEndpointRequest.getter(ModifyVpcEndpointRequest::dryRun)).setter(ModifyVpcEndpointRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final SdkField<String> VPC_ENDPOINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcEndpointId").getter(ModifyVpcEndpointRequest.getter(ModifyVpcEndpointRequest::vpcEndpointId)).setter(ModifyVpcEndpointRequest.setter(Builder::vpcEndpointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpointId").unmarshallLocationName("VpcEndpointId").build()}).build();
    private static final SdkField<Boolean> RESET_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ResetPolicy").getter(ModifyVpcEndpointRequest.getter(ModifyVpcEndpointRequest::resetPolicy)).setter(ModifyVpcEndpointRequest.setter(Builder::resetPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResetPolicy").unmarshallLocationName("ResetPolicy").build()}).build();
    private static final SdkField<String> POLICY_DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyDocument").getter(ModifyVpcEndpointRequest.getter(ModifyVpcEndpointRequest::policyDocument)).setter(ModifyVpcEndpointRequest.setter(Builder::policyDocument)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyDocument").unmarshallLocationName("PolicyDocument").build()}).build();
    private static final SdkField<List<String>> ADD_ROUTE_TABLE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AddRouteTableIds").getter(ModifyVpcEndpointRequest.getter(ModifyVpcEndpointRequest::addRouteTableIds)).setter(ModifyVpcEndpointRequest.setter(Builder::addRouteTableIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddRouteTableId").unmarshallLocationName("AddRouteTableId").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<String>> REMOVE_ROUTE_TABLE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RemoveRouteTableIds").getter(ModifyVpcEndpointRequest.getter(ModifyVpcEndpointRequest::removeRouteTableIds)).setter(ModifyVpcEndpointRequest.setter(Builder::removeRouteTableIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveRouteTableId").unmarshallLocationName("RemoveRouteTableId").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ADD_SUBNET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AddSubnetIds").getter(ModifyVpcEndpointRequest.getter(ModifyVpcEndpointRequest::addSubnetIds)).setter(ModifyVpcEndpointRequest.setter(Builder::addSubnetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddSubnetId").unmarshallLocationName("AddSubnetId").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<String>> REMOVE_SUBNET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RemoveSubnetIds").getter(ModifyVpcEndpointRequest.getter(ModifyVpcEndpointRequest::removeSubnetIds)).setter(ModifyVpcEndpointRequest.setter(Builder::removeSubnetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveSubnetId").unmarshallLocationName("RemoveSubnetId").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ADD_SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AddSecurityGroupIds").getter(ModifyVpcEndpointRequest.getter(ModifyVpcEndpointRequest::addSecurityGroupIds)).setter(ModifyVpcEndpointRequest.setter(Builder::addSecurityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddSecurityGroupId").unmarshallLocationName("AddSecurityGroupId").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<String>> REMOVE_SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RemoveSecurityGroupIds").getter(ModifyVpcEndpointRequest.getter(ModifyVpcEndpointRequest::removeSecurityGroupIds)).setter(ModifyVpcEndpointRequest.setter(Builder::removeSecurityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveSecurityGroupId").unmarshallLocationName("RemoveSecurityGroupId").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> IP_ADDRESS_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpAddressType").getter(ModifyVpcEndpointRequest.getter(ModifyVpcEndpointRequest::ipAddressTypeAsString)).setter(ModifyVpcEndpointRequest.setter(Builder::ipAddressType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddressType").unmarshallLocationName("IpAddressType").build()}).build();
    private static final SdkField<DnsOptionsSpecification> DNS_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DnsOptions").getter(ModifyVpcEndpointRequest.getter(ModifyVpcEndpointRequest::dnsOptions)).setter(ModifyVpcEndpointRequest.setter(Builder::dnsOptions)).constructor(DnsOptionsSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsOptions").unmarshallLocationName("DnsOptions").build()}).build();
    private static final SdkField<Boolean> PRIVATE_DNS_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("PrivateDnsEnabled").getter(ModifyVpcEndpointRequest.getter(ModifyVpcEndpointRequest::privateDnsEnabled)).setter(ModifyVpcEndpointRequest.setter(Builder::privateDnsEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateDnsEnabled").unmarshallLocationName("PrivateDnsEnabled").build()}).build();
    private static final SdkField<List<SubnetConfiguration>> SUBNET_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SubnetConfigurations").getter(ModifyVpcEndpointRequest.getter(ModifyVpcEndpointRequest::subnetConfigurations)).setter(ModifyVpcEndpointRequest.setter(Builder::subnetConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetConfiguration").unmarshallLocationName("SubnetConfiguration").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SubnetConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD, VPC_ENDPOINT_ID_FIELD, RESET_POLICY_FIELD, POLICY_DOCUMENT_FIELD, ADD_ROUTE_TABLE_IDS_FIELD, REMOVE_ROUTE_TABLE_IDS_FIELD, ADD_SUBNET_IDS_FIELD, REMOVE_SUBNET_IDS_FIELD, ADD_SECURITY_GROUP_IDS_FIELD, REMOVE_SECURITY_GROUP_IDS_FIELD, IP_ADDRESS_TYPE_FIELD, DNS_OPTIONS_FIELD, PRIVATE_DNS_ENABLED_FIELD, SUBNET_CONFIGURATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ModifyVpcEndpointRequest.memberNameToFieldInitializer();
    private final Boolean dryRun;
    private final String vpcEndpointId;
    private final Boolean resetPolicy;
    private final String policyDocument;
    private final List<String> addRouteTableIds;
    private final List<String> removeRouteTableIds;
    private final List<String> addSubnetIds;
    private final List<String> removeSubnetIds;
    private final List<String> addSecurityGroupIds;
    private final List<String> removeSecurityGroupIds;
    private final String ipAddressType;
    private final DnsOptionsSpecification dnsOptions;
    private final Boolean privateDnsEnabled;
    private final List<SubnetConfiguration> subnetConfigurations;

    private ModifyVpcEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.vpcEndpointId = builder.vpcEndpointId;
        this.resetPolicy = builder.resetPolicy;
        this.policyDocument = builder.policyDocument;
        this.addRouteTableIds = builder.addRouteTableIds;
        this.removeRouteTableIds = builder.removeRouteTableIds;
        this.addSubnetIds = builder.addSubnetIds;
        this.removeSubnetIds = builder.removeSubnetIds;
        this.addSecurityGroupIds = builder.addSecurityGroupIds;
        this.removeSecurityGroupIds = builder.removeSecurityGroupIds;
        this.ipAddressType = builder.ipAddressType;
        this.dnsOptions = builder.dnsOptions;
        this.privateDnsEnabled = builder.privateDnsEnabled;
        this.subnetConfigurations = builder.subnetConfigurations;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final String vpcEndpointId() {
        return this.vpcEndpointId;
    }

    public final Boolean resetPolicy() {
        return this.resetPolicy;
    }

    public final String policyDocument() {
        return this.policyDocument;
    }

    public final boolean hasAddRouteTableIds() {
        return this.addRouteTableIds != null && !(this.addRouteTableIds instanceof SdkAutoConstructList);
    }

    public final List<String> addRouteTableIds() {
        return this.addRouteTableIds;
    }

    public final boolean hasRemoveRouteTableIds() {
        return this.removeRouteTableIds != null && !(this.removeRouteTableIds instanceof SdkAutoConstructList);
    }

    public final List<String> removeRouteTableIds() {
        return this.removeRouteTableIds;
    }

    public final boolean hasAddSubnetIds() {
        return this.addSubnetIds != null && !(this.addSubnetIds instanceof SdkAutoConstructList);
    }

    public final List<String> addSubnetIds() {
        return this.addSubnetIds;
    }

    public final boolean hasRemoveSubnetIds() {
        return this.removeSubnetIds != null && !(this.removeSubnetIds instanceof SdkAutoConstructList);
    }

    public final List<String> removeSubnetIds() {
        return this.removeSubnetIds;
    }

    public final boolean hasAddSecurityGroupIds() {
        return this.addSecurityGroupIds != null && !(this.addSecurityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> addSecurityGroupIds() {
        return this.addSecurityGroupIds;
    }

    public final boolean hasRemoveSecurityGroupIds() {
        return this.removeSecurityGroupIds != null && !(this.removeSecurityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> removeSecurityGroupIds() {
        return this.removeSecurityGroupIds;
    }

    public final IpAddressType ipAddressType() {
        return IpAddressType.fromValue(this.ipAddressType);
    }

    public final String ipAddressTypeAsString() {
        return this.ipAddressType;
    }

    public final DnsOptionsSpecification dnsOptions() {
        return this.dnsOptions;
    }

    public final Boolean privateDnsEnabled() {
        return this.privateDnsEnabled;
    }

    public final boolean hasSubnetConfigurations() {
        return this.subnetConfigurations != null && !(this.subnetConfigurations instanceof SdkAutoConstructList);
    }

    public final List<SubnetConfiguration> subnetConfigurations() {
        return this.subnetConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resetPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyDocument());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAddRouteTableIds() ? this.addRouteTableIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRemoveRouteTableIds() ? this.removeRouteTableIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAddSubnetIds() ? this.addSubnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRemoveSubnetIds() ? this.removeSubnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAddSecurityGroupIds() ? this.addSecurityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRemoveSecurityGroupIds() ? this.removeSecurityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddressTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateDnsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnetConfigurations() ? this.subnetConfigurations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyVpcEndpointRequest)) {
            return false;
        }
        ModifyVpcEndpointRequest other = (ModifyVpcEndpointRequest)((Object)obj);
        return Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.vpcEndpointId(), other.vpcEndpointId()) && Objects.equals(this.resetPolicy(), other.resetPolicy()) && Objects.equals(this.policyDocument(), other.policyDocument()) && this.hasAddRouteTableIds() == other.hasAddRouteTableIds() && Objects.equals(this.addRouteTableIds(), other.addRouteTableIds()) && this.hasRemoveRouteTableIds() == other.hasRemoveRouteTableIds() && Objects.equals(this.removeRouteTableIds(), other.removeRouteTableIds()) && this.hasAddSubnetIds() == other.hasAddSubnetIds() && Objects.equals(this.addSubnetIds(), other.addSubnetIds()) && this.hasRemoveSubnetIds() == other.hasRemoveSubnetIds() && Objects.equals(this.removeSubnetIds(), other.removeSubnetIds()) && this.hasAddSecurityGroupIds() == other.hasAddSecurityGroupIds() && Objects.equals(this.addSecurityGroupIds(), other.addSecurityGroupIds()) && this.hasRemoveSecurityGroupIds() == other.hasRemoveSecurityGroupIds() && Objects.equals(this.removeSecurityGroupIds(), other.removeSecurityGroupIds()) && Objects.equals(this.ipAddressTypeAsString(), other.ipAddressTypeAsString()) && Objects.equals(this.dnsOptions(), other.dnsOptions()) && Objects.equals(this.privateDnsEnabled(), other.privateDnsEnabled()) && this.hasSubnetConfigurations() == other.hasSubnetConfigurations() && Objects.equals(this.subnetConfigurations(), other.subnetConfigurations());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyVpcEndpointRequest").add("DryRun", (Object)this.dryRun()).add("VpcEndpointId", (Object)this.vpcEndpointId()).add("ResetPolicy", (Object)this.resetPolicy()).add("PolicyDocument", (Object)this.policyDocument()).add("AddRouteTableIds", this.hasAddRouteTableIds() ? this.addRouteTableIds() : null).add("RemoveRouteTableIds", this.hasRemoveRouteTableIds() ? this.removeRouteTableIds() : null).add("AddSubnetIds", this.hasAddSubnetIds() ? this.addSubnetIds() : null).add("RemoveSubnetIds", this.hasRemoveSubnetIds() ? this.removeSubnetIds() : null).add("AddSecurityGroupIds", this.hasAddSecurityGroupIds() ? this.addSecurityGroupIds() : null).add("RemoveSecurityGroupIds", this.hasRemoveSecurityGroupIds() ? this.removeSecurityGroupIds() : null).add("IpAddressType", (Object)this.ipAddressTypeAsString()).add("DnsOptions", (Object)this.dnsOptions()).add("PrivateDnsEnabled", (Object)this.privateDnsEnabled()).add("SubnetConfigurations", this.hasSubnetConfigurations() ? this.subnetConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "VpcEndpointId": {
                return Optional.ofNullable(clazz.cast(this.vpcEndpointId()));
            }
            case "ResetPolicy": {
                return Optional.ofNullable(clazz.cast(this.resetPolicy()));
            }
            case "PolicyDocument": {
                return Optional.ofNullable(clazz.cast(this.policyDocument()));
            }
            case "AddRouteTableIds": {
                return Optional.ofNullable(clazz.cast(this.addRouteTableIds()));
            }
            case "RemoveRouteTableIds": {
                return Optional.ofNullable(clazz.cast(this.removeRouteTableIds()));
            }
            case "AddSubnetIds": {
                return Optional.ofNullable(clazz.cast(this.addSubnetIds()));
            }
            case "RemoveSubnetIds": {
                return Optional.ofNullable(clazz.cast(this.removeSubnetIds()));
            }
            case "AddSecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.addSecurityGroupIds()));
            }
            case "RemoveSecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.removeSecurityGroupIds()));
            }
            case "IpAddressType": {
                return Optional.ofNullable(clazz.cast(this.ipAddressTypeAsString()));
            }
            case "DnsOptions": {
                return Optional.ofNullable(clazz.cast(this.dnsOptions()));
            }
            case "PrivateDnsEnabled": {
                return Optional.ofNullable(clazz.cast(this.privateDnsEnabled()));
            }
            case "SubnetConfigurations": {
                return Optional.ofNullable(clazz.cast(this.subnetConfigurations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("VpcEndpointId", VPC_ENDPOINT_ID_FIELD);
        map.put("ResetPolicy", RESET_POLICY_FIELD);
        map.put("PolicyDocument", POLICY_DOCUMENT_FIELD);
        map.put("AddRouteTableId", ADD_ROUTE_TABLE_IDS_FIELD);
        map.put("RemoveRouteTableId", REMOVE_ROUTE_TABLE_IDS_FIELD);
        map.put("AddSubnetId", ADD_SUBNET_IDS_FIELD);
        map.put("RemoveSubnetId", REMOVE_SUBNET_IDS_FIELD);
        map.put("AddSecurityGroupId", ADD_SECURITY_GROUP_IDS_FIELD);
        map.put("RemoveSecurityGroupId", REMOVE_SECURITY_GROUP_IDS_FIELD);
        map.put("IpAddressType", IP_ADDRESS_TYPE_FIELD);
        map.put("DnsOptions", DNS_OPTIONS_FIELD);
        map.put("PrivateDnsEnabled", PRIVATE_DNS_ENABLED_FIELD);
        map.put("SubnetConfiguration", SUBNET_CONFIGURATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyVpcEndpointRequest, T> g) {
        return obj -> g.apply((ModifyVpcEndpointRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private Boolean dryRun;
        private String vpcEndpointId;
        private Boolean resetPolicy;
        private String policyDocument;
        private List<String> addRouteTableIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> removeRouteTableIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> addSubnetIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> removeSubnetIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> addSecurityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> removeSecurityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private String ipAddressType;
        private DnsOptionsSpecification dnsOptions;
        private Boolean privateDnsEnabled;
        private List<SubnetConfiguration> subnetConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyVpcEndpointRequest model) {
            super(model);
            this.dryRun(model.dryRun);
            this.vpcEndpointId(model.vpcEndpointId);
            this.resetPolicy(model.resetPolicy);
            this.policyDocument(model.policyDocument);
            this.addRouteTableIds(model.addRouteTableIds);
            this.removeRouteTableIds(model.removeRouteTableIds);
            this.addSubnetIds(model.addSubnetIds);
            this.removeSubnetIds(model.removeSubnetIds);
            this.addSecurityGroupIds(model.addSecurityGroupIds);
            this.removeSecurityGroupIds(model.removeSecurityGroupIds);
            this.ipAddressType(model.ipAddressType);
            this.dnsOptions(model.dnsOptions);
            this.privateDnsEnabled(model.privateDnsEnabled);
            this.subnetConfigurations(model.subnetConfigurations);
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getVpcEndpointId() {
            return this.vpcEndpointId;
        }

        public final void setVpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
        }

        @Override
        public final Builder vpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
            return this;
        }

        public final Boolean getResetPolicy() {
            return this.resetPolicy;
        }

        public final void setResetPolicy(Boolean resetPolicy) {
            this.resetPolicy = resetPolicy;
        }

        @Override
        public final Builder resetPolicy(Boolean resetPolicy) {
            this.resetPolicy = resetPolicy;
            return this;
        }

        public final String getPolicyDocument() {
            return this.policyDocument;
        }

        public final void setPolicyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
        }

        @Override
        public final Builder policyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        public final Collection<String> getAddRouteTableIds() {
            if (this.addRouteTableIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.addRouteTableIds;
        }

        public final void setAddRouteTableIds(Collection<String> addRouteTableIds) {
            this.addRouteTableIds = VpcEndpointRouteTableIdListCopier.copy(addRouteTableIds);
        }

        @Override
        public final Builder addRouteTableIds(Collection<String> addRouteTableIds) {
            this.addRouteTableIds = VpcEndpointRouteTableIdListCopier.copy(addRouteTableIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addRouteTableIds(String ... addRouteTableIds) {
            this.addRouteTableIds(Arrays.asList(addRouteTableIds));
            return this;
        }

        public final Collection<String> getRemoveRouteTableIds() {
            if (this.removeRouteTableIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.removeRouteTableIds;
        }

        public final void setRemoveRouteTableIds(Collection<String> removeRouteTableIds) {
            this.removeRouteTableIds = VpcEndpointRouteTableIdListCopier.copy(removeRouteTableIds);
        }

        @Override
        public final Builder removeRouteTableIds(Collection<String> removeRouteTableIds) {
            this.removeRouteTableIds = VpcEndpointRouteTableIdListCopier.copy(removeRouteTableIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeRouteTableIds(String ... removeRouteTableIds) {
            this.removeRouteTableIds(Arrays.asList(removeRouteTableIds));
            return this;
        }

        public final Collection<String> getAddSubnetIds() {
            if (this.addSubnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.addSubnetIds;
        }

        public final void setAddSubnetIds(Collection<String> addSubnetIds) {
            this.addSubnetIds = VpcEndpointSubnetIdListCopier.copy(addSubnetIds);
        }

        @Override
        public final Builder addSubnetIds(Collection<String> addSubnetIds) {
            this.addSubnetIds = VpcEndpointSubnetIdListCopier.copy(addSubnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addSubnetIds(String ... addSubnetIds) {
            this.addSubnetIds(Arrays.asList(addSubnetIds));
            return this;
        }

        public final Collection<String> getRemoveSubnetIds() {
            if (this.removeSubnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.removeSubnetIds;
        }

        public final void setRemoveSubnetIds(Collection<String> removeSubnetIds) {
            this.removeSubnetIds = VpcEndpointSubnetIdListCopier.copy(removeSubnetIds);
        }

        @Override
        public final Builder removeSubnetIds(Collection<String> removeSubnetIds) {
            this.removeSubnetIds = VpcEndpointSubnetIdListCopier.copy(removeSubnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeSubnetIds(String ... removeSubnetIds) {
            this.removeSubnetIds(Arrays.asList(removeSubnetIds));
            return this;
        }

        public final Collection<String> getAddSecurityGroupIds() {
            if (this.addSecurityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.addSecurityGroupIds;
        }

        public final void setAddSecurityGroupIds(Collection<String> addSecurityGroupIds) {
            this.addSecurityGroupIds = VpcEndpointSecurityGroupIdListCopier.copy(addSecurityGroupIds);
        }

        @Override
        public final Builder addSecurityGroupIds(Collection<String> addSecurityGroupIds) {
            this.addSecurityGroupIds = VpcEndpointSecurityGroupIdListCopier.copy(addSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addSecurityGroupIds(String ... addSecurityGroupIds) {
            this.addSecurityGroupIds(Arrays.asList(addSecurityGroupIds));
            return this;
        }

        public final Collection<String> getRemoveSecurityGroupIds() {
            if (this.removeSecurityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.removeSecurityGroupIds;
        }

        public final void setRemoveSecurityGroupIds(Collection<String> removeSecurityGroupIds) {
            this.removeSecurityGroupIds = VpcEndpointSecurityGroupIdListCopier.copy(removeSecurityGroupIds);
        }

        @Override
        public final Builder removeSecurityGroupIds(Collection<String> removeSecurityGroupIds) {
            this.removeSecurityGroupIds = VpcEndpointSecurityGroupIdListCopier.copy(removeSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeSecurityGroupIds(String ... removeSecurityGroupIds) {
            this.removeSecurityGroupIds(Arrays.asList(removeSecurityGroupIds));
            return this;
        }

        public final String getIpAddressType() {
            return this.ipAddressType;
        }

        public final void setIpAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
        }

        @Override
        public final Builder ipAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
            return this;
        }

        @Override
        public final Builder ipAddressType(IpAddressType ipAddressType) {
            this.ipAddressType(ipAddressType == null ? null : ipAddressType.toString());
            return this;
        }

        public final DnsOptionsSpecification.Builder getDnsOptions() {
            return this.dnsOptions != null ? this.dnsOptions.toBuilder() : null;
        }

        public final void setDnsOptions(DnsOptionsSpecification.BuilderImpl dnsOptions) {
            this.dnsOptions = dnsOptions != null ? dnsOptions.build() : null;
        }

        @Override
        public final Builder dnsOptions(DnsOptionsSpecification dnsOptions) {
            this.dnsOptions = dnsOptions;
            return this;
        }

        public final Boolean getPrivateDnsEnabled() {
            return this.privateDnsEnabled;
        }

        public final void setPrivateDnsEnabled(Boolean privateDnsEnabled) {
            this.privateDnsEnabled = privateDnsEnabled;
        }

        @Override
        public final Builder privateDnsEnabled(Boolean privateDnsEnabled) {
            this.privateDnsEnabled = privateDnsEnabled;
            return this;
        }

        public final List<SubnetConfiguration.Builder> getSubnetConfigurations() {
            List<SubnetConfiguration.Builder> result = SubnetConfigurationsListCopier.copyToBuilder(this.subnetConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubnetConfigurations(Collection<SubnetConfiguration.BuilderImpl> subnetConfigurations) {
            this.subnetConfigurations = SubnetConfigurationsListCopier.copyFromBuilder(subnetConfigurations);
        }

        @Override
        public final Builder subnetConfigurations(Collection<SubnetConfiguration> subnetConfigurations) {
            this.subnetConfigurations = SubnetConfigurationsListCopier.copy(subnetConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetConfigurations(SubnetConfiguration ... subnetConfigurations) {
            this.subnetConfigurations(Arrays.asList(subnetConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetConfigurations(Consumer<SubnetConfiguration.Builder> ... subnetConfigurations) {
            this.subnetConfigurations(Stream.of(subnetConfigurations).map(c -> (SubnetConfiguration)((SubnetConfiguration.Builder)SubnetConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyVpcEndpointRequest build() {
            return new ModifyVpcEndpointRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyVpcEndpointRequest> {
        public Builder dryRun(Boolean var1);

        public Builder vpcEndpointId(String var1);

        public Builder resetPolicy(Boolean var1);

        public Builder policyDocument(String var1);

        public Builder addRouteTableIds(Collection<String> var1);

        public Builder addRouteTableIds(String ... var1);

        public Builder removeRouteTableIds(Collection<String> var1);

        public Builder removeRouteTableIds(String ... var1);

        public Builder addSubnetIds(Collection<String> var1);

        public Builder addSubnetIds(String ... var1);

        public Builder removeSubnetIds(Collection<String> var1);

        public Builder removeSubnetIds(String ... var1);

        public Builder addSecurityGroupIds(Collection<String> var1);

        public Builder addSecurityGroupIds(String ... var1);

        public Builder removeSecurityGroupIds(Collection<String> var1);

        public Builder removeSecurityGroupIds(String ... var1);

        public Builder ipAddressType(String var1);

        public Builder ipAddressType(IpAddressType var1);

        public Builder dnsOptions(DnsOptionsSpecification var1);

        default public Builder dnsOptions(Consumer<DnsOptionsSpecification.Builder> dnsOptions) {
            return this.dnsOptions((DnsOptionsSpecification)((DnsOptionsSpecification.Builder)DnsOptionsSpecification.builder().applyMutation(dnsOptions)).build());
        }

        public Builder privateDnsEnabled(Boolean var1);

        public Builder subnetConfigurations(Collection<SubnetConfiguration> var1);

        public Builder subnetConfigurations(SubnetConfiguration ... var1);

        public Builder subnetConfigurations(Consumer<SubnetConfiguration.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

