/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml.processing.core.parsers.saml.assertion;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import org.keycloak.dom.saml.v2.assertion.AttributeType;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.util.StaxParserUtil;
import org.keycloak.saml.processing.core.parsers.saml.assertion.AbstractStaxSamlAssertionParser;
import org.keycloak.saml.processing.core.parsers.saml.assertion.SAMLAssertionQNames;
import org.keycloak.saml.processing.core.parsers.saml.assertion.SAMLAttributeValueParser;

public class SAMLAttributeParser
extends AbstractStaxSamlAssertionParser<AttributeType> {
    private static final SAMLAttributeParser INSTANCE = new SAMLAttributeParser();
    private static final Set<QName> DEFAULT_KNOWN_ATTRIBUTE_NAMES = new HashSet<QName>(Arrays.asList(SAMLAssertionQNames.ATTR_NAME.getQName(), SAMLAssertionQNames.ATTR_FRIENDLY_NAME.getQName(), SAMLAssertionQNames.ATTR_NAME_FORMAT.getQName()));

    private SAMLAttributeParser() {
        super(SAMLAssertionQNames.ATTRIBUTE);
    }

    public static SAMLAttributeParser getInstance() {
        return INSTANCE;
    }

    @Override
    protected AttributeType instantiateElement(XMLEventReader xmlEventReader, StartElement element) throws ParsingException {
        String name = StaxParserUtil.getRequiredAttributeValue(element, SAMLAssertionQNames.ATTR_NAME);
        AttributeType attribute = new AttributeType(name);
        attribute.setFriendlyName(StaxParserUtil.getAttributeValue(element, SAMLAssertionQNames.ATTR_FRIENDLY_NAME));
        attribute.setNameFormat(StaxParserUtil.getAttributeValue(element, SAMLAssertionQNames.ATTR_NAME_FORMAT));
        attribute.getOtherAttributes().putAll(SAMLAttributeParser.collectUnknownAttributesFrom(element));
        return attribute;
    }

    private static Map<QName, String> collectUnknownAttributesFrom(StartElement element) {
        HashMap<QName, String> otherAttributes = new HashMap<QName, String>();
        Iterator<Attribute> attributes = element.getAttributes();
        while (attributes.hasNext()) {
            Attribute currentAttribute = attributes.next();
            QName attributeQName = currentAttribute.getName();
            if (attributeQName == null || DEFAULT_KNOWN_ATTRIBUTE_NAMES.contains(attributeQName)) continue;
            String attributeValue = currentAttribute.getValue();
            otherAttributes.put(attributeQName, attributeValue);
            if (!LOGGER.isTraceEnabled()) continue;
            LOGGER.trace(String.format("Adding attribute %s with value %s", attributeQName, attributeValue));
        }
        return otherAttributes;
    }

    @Override
    protected void processSubElement(XMLEventReader xmlEventReader, AttributeType target, SAMLAssertionQNames element, StartElement elementDetail) throws ParsingException {
        switch (element) {
            case ATTRIBUTE_VALUE: {
                target.addAttributeValue(SAMLAttributeValueParser.getInstance().parse(xmlEventReader));
                break;
            }
            default: {
                throw LOGGER.parserUnknownTag(StaxParserUtil.getElementName(elementDetail), elementDetail.getLocation());
            }
        }
    }
}

