/*
 * Decompiled with CFR 0.152.
 */
package net.sf.juife;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public abstract class EnhancedDialog
extends JDialog {
    private boolean cancelled = true;

    public EnhancedDialog(Dialog owner) {
        this(owner, "");
    }

    public EnhancedDialog(Dialog owner, String title) {
        this(owner, title, true);
    }

    public EnhancedDialog(Dialog owner, String title, boolean modal) {
        super(owner, title, modal);
        this.initEnhancedDialog();
    }

    public EnhancedDialog(Frame owner) {
        this(owner, "");
    }

    public EnhancedDialog(Frame owner, String title) {
        this(owner, title, true);
    }

    public EnhancedDialog(Frame owner, String title, boolean modal) {
        super(owner, title, modal);
        this.initEnhancedDialog();
    }

    protected abstract void onOk();

    protected abstract void onCancel();

    private void initEnhancedDialog() {
        this.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "Applying...");
        this.getRootPane().getActionMap().put("Applying...", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EnhancedDialog.this.setCancelled(false);
                EnhancedDialog.this.onOk();
            }
        });
        this.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "Canceling...");
        this.getRootPane().getActionMap().put("Canceling...", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EnhancedDialog.this.setCancelled(true);
                EnhancedDialog.this.onCancel();
            }
        });
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                EnhancedDialog.this.setCancelled(true);
                EnhancedDialog.this.onCancel();
            }
        });
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean b) {
        this.cancelled = b;
    }

    public void makeVisible(final boolean b) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.setVisible(b);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        EnhancedDialog.this.setVisible(b);
                    }
                });
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
    }
}

