/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project.artifact;

import java.util.Collections;
import java.util.List;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.artifact.ArtifactWithDependencies;

public class ProjectArtifact
extends DefaultArtifact
implements ArtifactWithDependencies {
    private MavenProject project;

    public ProjectArtifact(MavenProject project2) {
        super(project2.getGroupId(), project2.getArtifactId(), project2.getVersion(), null, "pom", null, (ArtifactHandler)new PomArtifactHandler());
        this.project = project2;
        this.setFile(project2.getFile());
        this.setResolved(true);
    }

    public MavenProject getProject() {
        return this.project;
    }

    @Override
    public List<Dependency> getDependencies() {
        return this.project.getDependencies();
    }

    @Override
    public List<Dependency> getManagedDependencies() {
        DependencyManagement depMngt = this.project.getDependencyManagement();
        return depMngt != null ? Collections.unmodifiableList(depMngt.getDependencies()) : Collections.emptyList();
    }

    static class PomArtifactHandler
    implements ArtifactHandler {
        PomArtifactHandler() {
        }

        @Override
        public String getClassifier() {
            return null;
        }

        @Override
        public String getDirectory() {
            return null;
        }

        @Override
        public String getExtension() {
            return "pom";
        }

        @Override
        public String getLanguage() {
            return "none";
        }

        @Override
        public String getPackaging() {
            return "pom";
        }

        @Override
        public boolean isAddedToClasspath() {
            return false;
        }

        @Override
        public boolean isIncludesDependencies() {
            return false;
        }
    }
}

