﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/guardduty/GuardDuty_EXPORTS.h>
#include <aws/guardduty/model/FeatureStatus.h>
#include <aws/guardduty/model/MemberAdditionalConfiguration.h>
#include <aws/guardduty/model/OrgFeature.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace GuardDuty {
namespace Model {

/**
 * <p>Contains information about the features for the member account.</p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/MemberFeaturesConfiguration">AWS
 * API Reference</a></p>
 */
class MemberFeaturesConfiguration {
 public:
  AWS_GUARDDUTY_API MemberFeaturesConfiguration() = default;
  AWS_GUARDDUTY_API MemberFeaturesConfiguration(Aws::Utils::Json::JsonView jsonValue);
  AWS_GUARDDUTY_API MemberFeaturesConfiguration& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_GUARDDUTY_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The name of the feature.</p>
   */
  inline OrgFeature GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  inline void SetName(OrgFeature value) {
    m_nameHasBeenSet = true;
    m_name = value;
  }
  inline MemberFeaturesConfiguration& WithName(OrgFeature value) {
    SetName(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The status of the feature.</p>
   */
  inline FeatureStatus GetStatus() const { return m_status; }
  inline bool StatusHasBeenSet() const { return m_statusHasBeenSet; }
  inline void SetStatus(FeatureStatus value) {
    m_statusHasBeenSet = true;
    m_status = value;
  }
  inline MemberFeaturesConfiguration& WithStatus(FeatureStatus value) {
    SetStatus(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Additional configuration of the feature for the member account.</p>
   */
  inline const Aws::Vector<MemberAdditionalConfiguration>& GetAdditionalConfiguration() const { return m_additionalConfiguration; }
  inline bool AdditionalConfigurationHasBeenSet() const { return m_additionalConfigurationHasBeenSet; }
  template <typename AdditionalConfigurationT = Aws::Vector<MemberAdditionalConfiguration>>
  void SetAdditionalConfiguration(AdditionalConfigurationT&& value) {
    m_additionalConfigurationHasBeenSet = true;
    m_additionalConfiguration = std::forward<AdditionalConfigurationT>(value);
  }
  template <typename AdditionalConfigurationT = Aws::Vector<MemberAdditionalConfiguration>>
  MemberFeaturesConfiguration& WithAdditionalConfiguration(AdditionalConfigurationT&& value) {
    SetAdditionalConfiguration(std::forward<AdditionalConfigurationT>(value));
    return *this;
  }
  template <typename AdditionalConfigurationT = MemberAdditionalConfiguration>
  MemberFeaturesConfiguration& AddAdditionalConfiguration(AdditionalConfigurationT&& value) {
    m_additionalConfigurationHasBeenSet = true;
    m_additionalConfiguration.emplace_back(std::forward<AdditionalConfigurationT>(value));
    return *this;
  }
  ///@}
 private:
  OrgFeature m_name{OrgFeature::NOT_SET};

  FeatureStatus m_status{FeatureStatus::NOT_SET};

  Aws::Vector<MemberAdditionalConfiguration> m_additionalConfiguration;
  bool m_nameHasBeenSet = false;
  bool m_statusHasBeenSet = false;
  bool m_additionalConfigurationHasBeenSet = false;
};

}  // namespace Model
}  // namespace GuardDuty
}  // namespace Aws
