/*
 * Decompiled with CFR 0.152.
 */
package xsbt.boot.internal.shaded.coursier.internal;

import java.io.File;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.security.MessageDigest;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import xsbt.boot.internal.shaded.coursier.cache.CacheLocks$;
import xsbt.boot.internal.shaded.coursier.core.Classifier;
import xsbt.boot.internal.shaded.coursier.core.Dependency;
import xsbt.boot.internal.shaded.coursier.core.Module;
import xsbt.boot.internal.shaded.coursier.core.Repository;
import xsbt.boot.internal.shaded.coursier.core.Type;
import xsbt.boot.internal.shaded.coursier.params.ResolutionParams;
import xsbt.boot.internal.shaded.coursier.paths.CachePath;

public final class FetchCache
implements Serializable,
Product {
    private final Path base;

    @Override
    public final Iterator<Object> productIterator() {
        return Product.productIterator$(this);
    }

    public final Path base() {
        return this.base;
    }

    /*
     * WARNING - void declaration
     */
    public final Path dir(Key key) {
        void var1_1;
        return this.base().resolve(new StringBuilder(1).append(StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(key.sha1()), 2)).append("/").append(StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(var1_1.sha1()), 2)).toString());
    }

    /*
     * WARNING - void declaration
     */
    public final Path resultFile(Key key) {
        void var1_1;
        return this.dir((Key)var1_1).resolve("artifacts");
    }

    /*
     * WARNING - void declaration
     */
    public final Option<Seq<File>> read(Key key) {
        Path resultFile0 = this.resultFile(key);
        if (Files.isRegularFile(resultFile0, new LinkOption[0])) {
            Vector artifacts2 = StringOps$.MODULE$.linesIterator$extension(Predef$.MODULE$.augmentString(new String(Files.readAllBytes(resultFile0), StandardCharsets.UTF_8))).map((Function1<String, String> & Serializable)x$1 -> x$1.trim()).filter((Function1<String, Object> & Serializable)x$2 -> BoxesRunTime.boxToBoolean(FetchCache.$anonfun$read$2(x$2))).map((Function1<String, Path> & Serializable)x$3 -> Paths.get(x$3, new String[0])).toVector();
            if (artifacts2.forall((Function1<Path, Object> & Serializable)x$4 -> BoxesRunTime.boxToBoolean(FetchCache.$anonfun$read$4(x$4)))) {
                void var1_1;
                return new Some<Object>(var1_1.map((Function1<Path, File> & Serializable)x$5 -> x$5.toFile()));
            }
            return None$.MODULE$;
        }
        return None$.MODULE$;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean write(Key key, Seq<File> artifacts2) {
        void var1_1;
        void var2_2;
        void var3_3;
        Path resultFile0 = this.resultFile(key);
        Path tmpFile = CachePath.temporaryFile(resultFile0.toFile()).toPath();
        return BoxesRunTime.unboxToBoolean(CacheLocks$.MODULE$.withLockOr(this.base().toFile(), resultFile0.toFile(), () -> FetchCache.$anonfun$write$2((Path)var3_3, (Seq)var2_2, (Path)var1_1), (Function0<Some> & Serializable)() -> new Some<Boolean>(BoxesRunTime.boxToBoolean(false))));
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_1;
        StringBuilder b = new StringBuilder("FetchCache(");
        b.append(String.valueOf(this.base()));
        b.append(")");
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean canEqual(Object obj) {
        void var1_1;
        return obj != null && var1_1 instanceof FetchCache;
    }

    public final boolean equals(Object obj) {
        block3: {
            block2: {
                Path path;
                if (this == obj) break block2;
                if (!this.canEqual(obj)) break block3;
                FetchCache other = (FetchCache)obj;
                Path path2 = this.base();
                path = ((FetchCache)((Object)path)).base();
                if (path2 != null ? !((Object)path2).equals(path) : path != null) break block3;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final int hashCode() {
        void var1_1;
        int code = 17 + Statics.anyHash("FetchCache");
        code = code * 37 + Statics.anyHash(this.base());
        return (int)(var1_1 * 37);
    }

    @Override
    public final String productPrefix() {
        return "FetchCache";
    }

    @Override
    public final int productArity() {
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Object productElement(int n) {
        void var1_1;
        switch (n) {
            case 0: {
                return this.base();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString((int)var1_1));
    }

    public static final /* synthetic */ boolean $anonfun$read$2(String x$2) {
        String string;
        return StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(string));
    }

    public static final /* synthetic */ boolean $anonfun$read$4(Path x$4) {
        return Files.isRegularFile(x$4, new LinkOption[0]);
    }

    /*
     * WARNING - void declaration
     */
    private static final void doWrite$1(Path tmpFile$1, Seq artifacts$1, Path resultFile0$1) {
        void var2_2;
        Path path;
        void var1_1;
        Files.write(tmpFile$1, ((IterableOnceOps)var1_1.map((Function1<File, String> & Serializable)x$6 -> x$6.getAbsolutePath())).mkString("\n").getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        Files.move(path, (Path)var2_2, StandardCopyOption.ATOMIC_MOVE);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ boolean $anonfun$write$2(Path tmpFile$1, Seq artifacts$1, Path resultFile0$1) {
        void var2_2;
        void var1_1;
        FetchCache.doWrite$1(tmpFile$1, (Seq)var1_1, (Path)var2_2);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public FetchCache(Path base) {
        void var1_1;
        this.base = var1_1;
        Product.$init$(this);
    }

    public static final class Key
    implements Serializable,
    Product {
        private String repr;
        private String sha1;
        private final Seq<Dependency> dependencies;
        private final Seq<Repository> repositories;
        private final ResolutionParams resolutionParams;
        private final Seq<Tuple2<Module, String>> forceVersion;
        private final Seq<Tuple2<String, String>> properties;
        private final Seq<Tuple2<String, String>> forcedProperties;
        private final Seq<String> profiles;
        private final String cacheLocation;
        private final Seq<Classifier> classifiers;
        private final Option<Object> mainArtifacts;
        private final Option<Seq<Type>> artifactTypesOpt;
        private volatile byte bitmap$0;

        public final Seq<Dependency> dependencies() {
            return this.dependencies;
        }

        public final Seq<Repository> repositories() {
            return this.repositories;
        }

        public final ResolutionParams resolutionParams() {
            return this.resolutionParams;
        }

        public final Seq<Tuple2<Module, String>> forceVersion() {
            return this.forceVersion;
        }

        public final Seq<Tuple2<String, String>> properties() {
            return this.properties;
        }

        public final Seq<Tuple2<String, String>> forcedProperties() {
            return this.forcedProperties;
        }

        public final Seq<String> profiles() {
            return this.profiles;
        }

        public final String cacheLocation() {
            return this.cacheLocation;
        }

        public final Seq<Classifier> classifiers() {
            return this.classifiers;
        }

        public final Option<Object> mainArtifacts() {
            return this.mainArtifacts;
        }

        public final Option<Seq<Type>> artifactTypesOpt() {
            return this.artifactTypesOpt;
        }

        private String repr$lzycompute() {
            Key key = this;
            synchronized (key) {
                if ((byte)(this.bitmap$0 & 1) == 0) {
                    this.repr = this.productIterator().mkString("(", ", ", ")");
                    this.bitmap$0 = (byte)(this.bitmap$0 | 1);
                }
            }
            return this.repr;
        }

        public final String repr() {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                return this.repr$lzycompute();
            }
            return this.repr;
        }

        private String sha1$lzycompute() {
            Key key = this;
            synchronized (key) {
                if ((byte)(this.bitmap$0 & 2) == 0) {
                    MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
                    byte[] b = messageDigest.digest(this.repr().getBytes(StandardCharsets.UTF_8));
                    String s = new BigInteger(1, b).toString(16);
                    this.sha1 = new StringBuilder(0).append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("0"), 40 - s.length())).append((String)((Object)messageDigest)).toString();
                    this.bitmap$0 = (byte)(this.bitmap$0 | 2);
                }
            }
            return this.sha1;
        }

        public final String sha1() {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                return this.sha1$lzycompute();
            }
            return this.sha1;
        }

        @Override
        public final String productPrefix() {
            return "Key";
        }

        @Override
        public final int productArity() {
            return 11;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Object productElement(int x$1) {
            void var1_1;
            switch (x$1) {
                case 0: {
                    return this.dependencies();
                }
                case 1: {
                    return this.repositories();
                }
                case 2: {
                    return this.resolutionParams();
                }
                case 3: {
                    return this.forceVersion();
                }
                case 4: {
                    return this.properties();
                }
                case 5: {
                    return this.forcedProperties();
                }
                case 6: {
                    return this.profiles();
                }
                case 7: {
                    return this.cacheLocation();
                }
                case 8: {
                    return this.classifiers();
                }
                case 9: {
                    return this.mainArtifacts();
                }
                case 10: {
                    return this.artifactTypesOpt();
                }
            }
            return Statics.ioobe((int)var1_1);
        }

        @Override
        public final Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator(this);
        }

        public final int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        public final String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        public final boolean equals(Object x$1) {
            block3: {
                block2: {
                    Product product;
                    if (this == x$1) break block2;
                    IterableOnce<Object> iterableOnce = x$1;
                    if (!(iterableOnce instanceof Key)) break block3;
                    product = product;
                    Seq<Dependency> seq = this.dependencies();
                    iterableOnce = product.dependencies();
                    if (seq != null ? !seq.equals(iterableOnce) : iterableOnce != null) break block3;
                    Seq<Repository> seq2 = this.repositories();
                    iterableOnce = product.repositories();
                    if (seq2 != null ? !seq2.equals(iterableOnce) : iterableOnce != null) break block3;
                    ResolutionParams resolutionParams = this.resolutionParams();
                    iterableOnce = product.resolutionParams();
                    if (resolutionParams != null ? !((Object)resolutionParams).equals(iterableOnce) : iterableOnce != null) break block3;
                    Seq<Tuple2<Module, String>> seq3 = this.forceVersion();
                    iterableOnce = product.forceVersion();
                    if (seq3 != null ? !seq3.equals(iterableOnce) : iterableOnce != null) break block3;
                    Seq<Tuple2<String, String>> seq4 = this.properties();
                    iterableOnce = product.properties();
                    if (seq4 != null ? !seq4.equals(iterableOnce) : iterableOnce != null) break block3;
                    Seq<Tuple2<String, String>> seq5 = this.forcedProperties();
                    iterableOnce = product.forcedProperties();
                    if (seq5 != null ? !seq5.equals(iterableOnce) : iterableOnce != null) break block3;
                    Seq<String> seq6 = this.profiles();
                    iterableOnce = product.profiles();
                    if (seq6 != null ? !seq6.equals(iterableOnce) : iterableOnce != null) break block3;
                    String string = this.cacheLocation();
                    iterableOnce = product.cacheLocation();
                    if (string != null ? !string.equals(iterableOnce) : iterableOnce != null) break block3;
                    Seq<Classifier> seq7 = this.classifiers();
                    iterableOnce = product.classifiers();
                    if (seq7 != null ? !seq7.equals(iterableOnce) : iterableOnce != null) break block3;
                    Option<Object> option = this.mainArtifacts();
                    iterableOnce = product.mainArtifacts();
                    if (option != null ? !option.equals(iterableOnce) : iterableOnce != null) break block3;
                    Option<Seq<Type>> option2 = this.artifactTypesOpt();
                    product = product.artifactTypesOpt();
                    if (option2 != null ? !option2.equals(product) : product != null) break block3;
                }
                return true;
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        public Key(Seq<Dependency> dependencies, Seq<Repository> repositories, ResolutionParams resolutionParams, Seq<Tuple2<Module, String>> forceVersion, Seq<Tuple2<String, String>> properties, Seq<Tuple2<String, String>> forcedProperties, Seq<String> profiles, String cacheLocation, Seq<Classifier> classifiers, Option<Object> mainArtifacts, Option<Seq<Type>> artifactTypesOpt) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.dependencies = var1_1;
            this.repositories = var2_2;
            this.resolutionParams = var3_3;
            this.forceVersion = forceVersion;
            this.properties = properties;
            this.forcedProperties = forcedProperties;
            this.profiles = profiles;
            this.cacheLocation = cacheLocation;
            this.classifiers = classifiers;
            this.mainArtifacts = mainArtifacts;
            this.artifactTypesOpt = artifactTypesOpt;
            Product.$init$(this);
        }
    }
}

