/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.notifications.core.repackage.com.amazonaws.http.apache.client.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.opensearch.notifications.core.repackage.com.amazonaws.util.CRC32ChecksumCalculatingInputStream;
import org.opensearch.notifications.core.repackage.com.amazonaws.util.IOUtils;
import org.opensearch.notifications.core.repackage.org.apache.http.Header;
import org.opensearch.notifications.core.repackage.org.apache.http.HttpEntity;
import org.opensearch.notifications.core.repackage.org.apache.http.HttpException;
import org.opensearch.notifications.core.repackage.org.apache.http.HttpResponse;
import org.opensearch.notifications.core.repackage.org.apache.http.HttpResponseInterceptor;
import org.opensearch.notifications.core.repackage.org.apache.http.entity.HttpEntityWrapper;
import org.opensearch.notifications.core.repackage.org.apache.http.protocol.HttpContext;

public class CRC32ChecksumResponseInterceptor
implements HttpResponseInterceptor {
    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        HttpEntity entity = response.getEntity();
        Header[] headers = response.getHeaders("x-amz-crc32");
        if (entity == null || headers == null || headers.length == 0) {
            return;
        }
        HttpEntityWrapper crc32ResponseEntity = new HttpEntityWrapper(entity){
            private final InputStream content;
            {
                this.content = new CRC32ChecksumCalculatingInputStream(this.wrappedEntity.getContent());
            }

            public InputStream getContent() throws IOException {
                return this.content;
            }

            public void writeTo(OutputStream outstream) throws IOException {
                try {
                    IOUtils.copy(this.getContent(), outstream);
                }
                finally {
                    this.getContent().close();
                }
            }
        };
        response.setEntity((HttpEntity)crc32ResponseEntity);
        context.setAttribute(CRC32ChecksumCalculatingInputStream.class.getName(), (Object)crc32ResponseEntity.getContent());
    }
}

