/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.purgatory;

import java.util.concurrent.locks.ReentrantLock;
import org.apache.kafka.server.util.timer.TimerTask;

public abstract class DelayedOperation
extends TimerTask {
    private volatile boolean completed = false;
    protected final ReentrantLock lock = new ReentrantLock();

    public DelayedOperation(long delayMs) {
        super(delayMs);
    }

    public boolean forceComplete() {
        if (this.completed) {
            return false;
        }
        this.lock.lock();
        try {
            if (!this.completed) {
                this.completed = true;
                this.cancel();
                this.onComplete();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public abstract void onExpiration();

    public abstract void onComplete();

    public abstract boolean tryComplete();

    boolean safeTryCompleteOrElse(Action action) {
        this.lock.lock();
        try {
            if (this.tryComplete()) {
                boolean bl = true;
                return bl;
            }
            action.apply();
            boolean bl = this.tryComplete();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    boolean safeTryComplete() {
        this.lock.lock();
        try {
            if (this.isCompleted()) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this.tryComplete();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void run() {
        if (this.forceComplete()) {
            this.onExpiration();
        }
    }

    @FunctionalInterface
    public static interface Action {
        public void apply();
    }
}

