/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.build;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Consumer;
import org.gradle.execution.MultipleBuildFailures;
import org.gradle.internal.Cast;
import org.jspecify.annotations.Nullable;

public abstract class ExecutionResult<T> {
    private static final Success<Void> SUCCESS = new Success<Void>(){

        @Override
        public Void getValue() {
            return null;
        }
    };

    public abstract T getValue();

    public abstract List<Throwable> getFailures();

    public abstract RuntimeException getFailure();

    public abstract RuntimeException getFailureOrNull();

    public abstract T getValueOrRethrow();

    public abstract void rethrow();

    public abstract ExecutionResult<T> withFailures(ExecutionResult<Void> var1);

    public abstract <S> ExecutionResult<S> asFailure();

    public static <T> ExecutionResult<T> succeeded(final T value) {
        return new Success<T>(){

            @Override
            public T getValue() {
                return value;
            }
        };
    }

    public static ExecutionResult<Void> succeeded() {
        return SUCCESS;
    }

    public static ExecutionResult<Void> maybeFailing(Runnable action) {
        try {
            action.run();
            return SUCCESS;
        }
        catch (Throwable t) {
            return ExecutionResult.failed(t);
        }
    }

    public static <T> ExecutionResult<T> failed(Throwable failure) {
        return new Failure((ImmutableList<Throwable>)ImmutableList.of((Object)failure));
    }

    public static ExecutionResult<Void> maybeFailed(List<? extends Throwable> failures) {
        if (failures.isEmpty()) {
            return SUCCESS;
        }
        return new Failure<Void>((ImmutableList<Throwable>)ImmutableList.copyOf(failures));
    }

    public static ExecutionResult<Void> maybeFailed(@Nullable Throwable failure) {
        if (failure == null) {
            return SUCCESS;
        }
        return new Failure<Void>((ImmutableList<Throwable>)ImmutableList.of((Object)failure));
    }

    public static <T> ExecutionResult<Void> forEach(Iterable<T> items, Consumer<? super T> action) {
        ArrayList<Throwable> failures = null;
        for (T item : items) {
            try {
                action.accept(item);
            }
            catch (Throwable t) {
                if (failures == null) {
                    failures = new ArrayList<Throwable>();
                }
                failures.add(t);
            }
        }
        if (failures == null) {
            return ExecutionResult.succeeded();
        }
        return ExecutionResult.maybeFailed(failures);
    }

    private static abstract class Success<T>
    extends ExecutionResult<T> {
        private Success() {
        }

        @Override
        public List<Throwable> getFailures() {
            return Collections.emptyList();
        }

        @Override
        public ExecutionResult<T> withFailures(ExecutionResult<Void> otherResult) {
            if (otherResult.getFailures().isEmpty()) {
                return this;
            }
            return otherResult.asFailure();
        }

        @Override
        public T getValueOrRethrow() {
            return this.getValue();
        }

        @Override
        public void rethrow() {
        }

        @Override
        public RuntimeException getFailureOrNull() {
            return null;
        }

        @Override
        public RuntimeException getFailure() {
            throw new IllegalArgumentException("Cannot get the failure of a successful result.");
        }

        @Override
        public <S> ExecutionResult<S> asFailure() {
            throw new IllegalArgumentException("Cannot cast a successful result to a failed result.");
        }
    }

    private static class Failure<T>
    extends ExecutionResult<T> {
        private final ImmutableList<Throwable> failures;

        public Failure(ImmutableList<Throwable> failures) {
            this.failures = failures;
        }

        @Override
        public T getValue() {
            throw new IllegalArgumentException("Cannot get the value of a failed result.");
        }

        @Override
        public T getValueOrRethrow() {
            this.rethrow();
            return null;
        }

        @Override
        public List<Throwable> getFailures() {
            return this.failures;
        }

        @Override
        public RuntimeException getFailureOrNull() {
            return this.getFailure();
        }

        @Override
        public RuntimeException getFailure() {
            if (this.failures.size() == 1 && this.failures.get(0) instanceof RuntimeException) {
                return (RuntimeException)this.failures.get(0);
            }
            return new MultipleBuildFailures((Collection<? extends Throwable>)this.failures);
        }

        @Override
        public void rethrow() {
            throw this.getFailure();
        }

        @Override
        public ExecutionResult<T> withFailures(ExecutionResult<Void> otherResult) {
            if (otherResult.getFailures().isEmpty()) {
                return this;
            }
            LinkedHashSet<Throwable> mergedFailures = new LinkedHashSet<Throwable>();
            mergedFailures.addAll((Collection<Throwable>)this.failures);
            mergedFailures.addAll(otherResult.getFailures());
            return new Failure<T>((ImmutableList<Throwable>)ImmutableList.copyOf(mergedFailures));
        }

        @Override
        public <S> ExecutionResult<S> asFailure() {
            return (ExecutionResult)Cast.uncheckedCast((Object)this);
        }
    }
}

