/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.impl.model.url;

import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.intro.impl.IntroPlugin;
import org.eclipse.ui.internal.intro.impl.model.AbstractIntroPage;
import org.eclipse.ui.internal.intro.impl.model.IntroModelRoot;
import org.eclipse.ui.internal.intro.impl.model.IntroPartPresentation;
import org.eclipse.ui.internal.intro.impl.model.url.IntroURL;
import org.eclipse.ui.internal.intro.impl.presentations.BrowserIntroPartImplementation;
import org.eclipse.ui.internal.intro.impl.util.Log;

public class ShowHelpURLHandler {
    private IntroURL introURL = null;

    ShowHelpURLHandler(IntroURL url) {
        this.introURL = url;
    }

    public boolean showHelpTopic(String href, String embed, String embedTarget) {
        boolean isEmbedded;
        if (href == null) {
            return false;
        }
        boolean bl = isEmbedded = embed != null && embed.equals("true");
        if (!isEmbedded) {
            isEmbedded = embedTarget != null;
        }
        IntroPartPresentation presentation = IntroPlugin.getDefault().getIntroModelRoot().getPresentation();
        String presentationStyle = presentation.getImplementationKind();
        if (isEmbedded && presentationStyle.equals("html")) {
            BrowserIntroPartImplementation impl = (BrowserIntroPartImplementation)presentation.getIntroPartImplementation();
            href = PlatformUI.getWorkbench().getHelpSystem().resolve(href, true).toExternalForm();
            if (embedTarget == null) {
                return impl.getBrowser().setUrl(href);
            }
            IntroModelRoot model = IntroPlugin.getDefault().getIntroModelRoot();
            return this.handleEmbedURLInDiv(href, embedTarget, model.getCurrentPage());
        }
        PlatformUI.getWorkbench().getHelpSystem().displayHelpResource(href);
        return true;
    }

    private boolean handleEmbedURLInDiv(String href, String embedTarget, AbstractIntroPage currentPage) {
        IntroModelRoot model = (IntroModelRoot)currentPage.getParentPage().getParent();
        String currentPageId = null;
        currentPageId = currentPage.isIFramePage() ? currentPage.getUnmangledId() : currentPage.getId();
        String mangledPageId = currentPageId + "_WITH_IFRAME";
        boolean standby = IntroPlugin.isIntroStandby();
        String standbyAsString = standby ? "true" : "false";
        AbstractIntroPage pageWithIFrame = (AbstractIntroPage)model.findChild(mangledPageId, 12);
        if (pageWithIFrame != null) {
            pageWithIFrame.setIFrameURL(href);
            return this.introURL.showPage(mangledPageId, standbyAsString);
        }
        AbstractIntroPage clonedPage = null;
        try {
            clonedPage = (AbstractIntroPage)currentPage.clone();
        }
        catch (CloneNotSupportedException ex) {
            Log.error("Failed to clone Intro page: " + currentPage.getId(), ex);
            return false;
        }
        boolean canInjectFrame = clonedPage.injectIFrame(href, embedTarget);
        if (!canInjectFrame) {
            return false;
        }
        clonedPage.setId(mangledPageId);
        model.addChild(clonedPage);
        return this.introURL.showPage(clonedPage.getId(), standbyAsString);
    }
}

