/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchSite;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBInfoUtils;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseFolder;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectReference;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableColumn;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.properties.PropertyCollector;
import org.jkiss.dbeaver.ui.BaseThemeSettings;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.SubEditorSite;
import org.jkiss.dbeaver.ui.navigator.itemlist.ItemListControl;
import org.jkiss.utils.CommonUtils;

public class ObjectInformationView {
    private static final Log log = Log.getLog(ObjectInformationView.class);
    private Composite infoComposite;
    private Object input;
    private Composite tableComposite;
    private Composite mainComposite;
    private ItemListControl itemListControl;

    @NotNull
    public Control createContent(@NotNull Composite parent) {
        GridData mainGridData = new GridData(1808);
        this.mainComposite = UIUtils.createPlaceholder((Composite)parent, (int)1);
        this.mainComposite.setLayoutData((Object)mainGridData);
        GridData infoGridData = new GridData(768);
        this.infoComposite = UIUtils.createPlaceholder((Composite)this.mainComposite, (int)1);
        this.infoComposite.setLayoutData((Object)infoGridData);
        this.tableComposite = UIUtils.createPlaceholder((Composite)this.mainComposite, (int)1);
        this.tableComposite.setLayoutData((Object)mainGridData);
        return this.mainComposite;
    }

    public boolean hasContents() {
        return this.input != null;
    }

    public void setInput(@NotNull Object input) {
        this.input = input;
        if (input instanceof DBPNamedObject) {
            DBPNamedObject namedObject = (DBPNamedObject)input;
            if (!this.infoComposite.isDisposed() && !this.tableComposite.isDisposed()) {
                this.createMetadataFields(namedObject);
                if (input instanceof DBSTable) {
                    DBSTable table = (DBSTable)input;
                    this.createTreeControl(table);
                }
            }
        }
    }

    private void createMetadataFields(final @NotNull DBPNamedObject input) {
        GridLayout layout = new GridLayout(1, true);
        layout.marginTop = 0;
        layout.marginBottom = 5;
        layout.marginLeft = 5;
        layout.marginRight = 5;
        final Composite metadataComposite = new Composite(this.infoComposite, 0);
        metadataComposite.setLayout((Layout)layout);
        metadataComposite.setLayoutData((Object)new GridData(768));
        final DBPNamedObject[] targetObject = new DBPNamedObject[]{input};
        AbstractJob resolveObject = new AbstractJob("Resolving object"){

            protected IStatus run(DBRProgressMonitor monitor) {
                if (input instanceof DBSObjectReference) {
                    DBSObjectReference objectReference = (DBSObjectReference)input;
                    try {
                        targetObject[0] = objectReference.resolveObject(monitor);
                    }
                    catch (DBException e) {
                        log.error((Object)"Error resolving object", (Throwable)e);
                        return Status.CANCEL_STATUS;
                    }
                }
                return Status.OK_STATUS;
            }
        };
        resolveObject.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (!event.getResult().isOK()) {
                    return;
                }
                UIUtils.syncExec(() -> {
                    if (!(metadataComposite.isDisposed() || ObjectInformationView.this.infoComposite.isDisposed() || ObjectInformationView.this.mainComposite.isDisposed())) {
                        PropertyCollector collector = new PropertyCollector((Object)targetObject[0], false);
                        collector.collectProperties();
                        int maxWidth = 0;
                        GC gc = new GC((Drawable)metadataComposite);
                        try {
                            gc.setFont(BaseThemeSettings.instance.baseFontBold);
                            DBPPropertyDescriptor[] dBPPropertyDescriptorArray = collector.getProperties();
                            int n = dBPPropertyDescriptorArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                DBPPropertyDescriptor descriptor = dBPPropertyDescriptorArray[n2];
                                String propertyString = DBInfoUtils.getPropertyString((PropertyCollector)collector, (DBPPropertyDescriptor)descriptor);
                                if (!CommonUtils.isEmpty((String)propertyString) && descriptor.hasFeature("viewable")) {
                                    Composite placeholder = UIUtils.createPlaceholder((Composite)metadataComposite, (int)2);
                                    placeholder.setLayoutData((Object)new GridData(32));
                                    Label label = new Label(placeholder, 8);
                                    label.setText(descriptor.getDisplayName() + ":");
                                    label.setFont(BaseThemeSettings.instance.baseFontBold);
                                    Text valueText = new Text(placeholder, 8);
                                    valueText.setText(propertyString);
                                    maxWidth = Math.max(maxWidth, gc.stringExtent((String)label.getText()).x + gc.stringExtent((String)valueText.getText()).x);
                                }
                                ++n2;
                            }
                        }
                        finally {
                            gc.dispose();
                        }
                        int extraWidth = maxWidth;
                        ObjectInformationView.this.infoComposite.layout(true, true);
                        ObjectInformationView.this.mainComposite.layout(true, true);
                        UIUtils.asyncExec(() -> {
                            Shell shell = ObjectInformationView.this.mainComposite.getShell();
                            Point sz = shell.getMinimumSize();
                            shell.setMinimumSize(sz.x + extraWidth, sz.y + composite.getSize().y);
                            ObjectInformationView.this.mainComposite.getShell().layout(true, true);
                        });
                    }
                });
            }
        });
        resolveObject.schedule();
    }

    private void createTreeControl(@NotNull DBSTable input) {
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 0;
        gridData.verticalSpan = 0;
        SubEditorSite subSite = new SubEditorSite(UIUtils.getActiveWorkbenchWindow().getActivePage().getActivePart().getSite());
        final DBNDatabaseNode node = DBWorkbench.getPlatform().getNavigatorModel().findNode((DBSObject)input);
        this.itemListControl = new ItemListControl(this.tableComposite, 0, (IWorkbenchSite)subSite, (DBNNode)node, null){

            @NotNull
            protected String getListConfigId(List<Class<?>> classList) {
                return "Suggestion/" + super.getListConfigId(classList);
            }
        };
        this.itemListControl.setLayoutData((Object)gridData);
        final Object[] columnNodes = new Object[1];
        AbstractJob abstractJob = new AbstractJob("Populating table tip columns"){

            protected IStatus run(DBRProgressMonitor monitor) {
                monitor.beginTask("Load table columns", 1);
                try {
                    try {
                        columnNodes[0] = ObjectInformationView.this.getColumnNodes(monitor, (DBNNode)node);
                    }
                    catch (DBException e) {
                        log.error((Object)"Error reading table columns", (Throwable)e);
                        IStatus iStatus = Status.CANCEL_STATUS;
                        monitor.done();
                        return iStatus;
                    }
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        abstractJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (!event.getResult().isOK()) {
                    return;
                }
                UIUtils.syncExec(() -> {
                    if (ObjectInformationView.this.itemListControl != null && !ObjectInformationView.this.itemListControl.isDisposed()) {
                        Collection columnNodeList = (Collection)columnNodes[0];
                        if (CommonUtils.isEmpty((Collection)columnNodeList)) {
                            ObjectInformationView.this.itemListControl.dispose();
                        } else {
                            ObjectInformationView.this.itemListControl.appendListData(columnNodeList);
                            int i = 0;
                            while (i < ObjectInformationView.this.itemListControl.getColumnController().getColumnsCount()) {
                                ObjectInformationView.this.itemListControl.getColumnController().setIsColumnVisible(i, false);
                                ++i;
                            }
                            ObjectInformationView.this.itemListControl.setIsColumnVisibleById("ordinalPosition", true);
                            ObjectInformationView.this.itemListControl.setIsColumnVisibleById("name", true);
                            ObjectInformationView.this.itemListControl.setIsColumnVisibleById("fullTypeName", true);
                            ObjectInformationView.this.itemListControl.setIsColumnVisibleById("identity", true);
                            ObjectInformationView.this.itemListControl.setIsColumnVisibleById("description", true);
                            ObjectInformationView.this.itemListControl.getColumnController().createColumns(false);
                            ObjectInformationView.this.itemListControl.getItemsViewer().refresh();
                            ObjectInformationView.this.itemListControl.getColumnController().autoSizeColumns();
                        }
                        ObjectInformationView.this.tableComposite.layout(true, true);
                        UIUtils.asyncExec(() -> {
                            Shell shell = ObjectInformationView.this.tableComposite.getShell();
                            Point sz = shell.getMinimumSize();
                            int extraHeight = ((Table)ObjectInformationView.this.itemListControl.getItemsViewer().getControl()).getHeaderHeight();
                            shell.setMinimumSize(sz.x, Math.min(sz.y + UIUtils.getFontHeight((Font)BaseThemeSettings.instance.baseFontBold) * columnNodeList.size() + extraHeight, 600));
                            ObjectInformationView.this.tableComposite.getShell().layout(true, true);
                        });
                    }
                });
            }
        });
        abstractJob.schedule();
    }

    @NotNull
    private Collection<DBNNode> getColumnNodes(@NotNull DBRProgressMonitor monitor, @Nullable DBNNode node) throws DBException {
        if (node == null) {
            return Collections.emptyList();
        }
        ArrayList<DBNNode> children = new ArrayList<DBNNode>();
        DBNNode[] dBNNodeArray = node.getChildren(monitor);
        int n = dBNNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            DBNNode child = dBNNodeArray[n2];
            if (child instanceof DBNDatabaseFolder) {
                DBNDatabaseFolder databaseFolder = (DBNDatabaseFolder)child;
                Class childrenClass = databaseFolder.getChildrenClass();
                if (childrenClass != null && DBSTableColumn.class.isAssignableFrom(childrenClass)) {
                    if (this.itemListControl != null && !this.itemListControl.isDisposed()) {
                        this.itemListControl.setRootNode(child);
                    }
                    DBNNode[] folderChildren = child.getChildren(monitor);
                    children.addAll(List.of(folderChildren));
                }
            } else {
                children.add(child);
            }
            ++n2;
        }
        return children;
    }
}

