import type * as Models from "../../../models";
import type { BroadcastAddress } from "../../../zspec/enums";
import * as Zcl from "../../../zspec/zcl";
import * as Zdo from "../../../zspec/zdo";
import type * as ZdoTypes from "../../../zspec/zdo/definition/tstypes";
import Adapter from "../../adapter";
import type * as Events from "../../events";
import type { AdapterOptions, CoordinatorVersion, NetworkOptions, NetworkParameters, SerialPortOptions, StartResult } from "../../tstype";
export declare class ZStackAdapter extends Adapter {
    private deviceAnnounceRouteDiscoveryDebouncers;
    private znp;
    private adapterManager;
    private transactionID;
    private version;
    private closing;
    private queue;
    private supportsLED?;
    private interpanLock;
    private interpanEndpointRegistered;
    private waitress;
    constructor(networkOptions: NetworkOptions, serialPortOptions: SerialPortOptions, backupPath: string, adapterOptions: AdapterOptions);
    /**
     * Adapter methods
     */
    start(): Promise<StartResult>;
    stop(): Promise<void>;
    getCoordinatorIEEE(): Promise<string>;
    getCoordinatorVersion(): Promise<CoordinatorVersion>;
    permitJoin(seconds: number, networkAddress?: number): Promise<void>;
    reset(type: "soft" | "hard"): Promise<void>;
    private setLED;
    private requestNetworkAddress;
    private supportsAssocRemove;
    private supportsAssocAdd;
    private discoverRoute;
    sendZdo(ieeeAddress: string, networkAddress: number, clusterId: Zdo.ClusterId, payload: Buffer, disableResponse: true): Promise<void>;
    sendZdo<K extends keyof ZdoTypes.RequestToResponseMap>(ieeeAddress: string, networkAddress: number, clusterId: K, payload: Buffer, disableResponse: false): Promise<ZdoTypes.RequestToResponseMap[K]>;
    private sendZdoInternal;
    sendZclFrameToEndpoint(ieeeAddr: string, networkAddress: number, endpoint: number, zclFrame: Zcl.Frame, timeout: number, disableResponse: boolean, disableRecovery: boolean, sourceEndpoint?: number): Promise<Events.ZclPayload | undefined>;
    private sendZclFrameToEndpointInternal;
    sendZclFrameToGroup(groupID: number, zclFrame: Zcl.Frame, sourceEndpoint?: number): Promise<void>;
    sendZclFrameToAll(endpoint: number, zclFrame: Zcl.Frame, sourceEndpoint: number, destination: BroadcastAddress): Promise<void>;
    addInstallCode(ieeeAddress: string, key: Buffer, hashed: boolean): Promise<void>;
    /**
     * Event handlers
     */
    onZnpClose(): void;
    private onZnpRecieved;
    getNetworkParameters(): Promise<NetworkParameters>;
    supportsBackup(): Promise<boolean>;
    backup(ieeeAddressesInDatabase: string[]): Promise<Models.Backup>;
    setChannelInterPAN(channel: number): Promise<void>;
    sendZclFrameInterPANToIeeeAddr(zclFrame: Zcl.Frame, ieeeAddr: string): Promise<void>;
    sendZclFrameInterPANBroadcast(zclFrame: Zcl.Frame, timeout: number): Promise<Events.ZclPayload>;
    restoreChannelInterPAN(): Promise<void>;
    private waitForInternal;
    waitFor(networkAddress: number | undefined, endpoint: number, frameType: Zcl.FrameType, direction: Zcl.Direction, transactionSequenceNumber: number | undefined, clusterID: number, commandIdentifier: number, timeout: number): {
        promise: Promise<Events.ZclPayload>;
        cancel: () => void;
    };
    /**
     * Private methods
     */
    private dataRequest;
    private dataRequestExtended;
    private nextTransactionID;
    private toAddressString;
    private waitressTimeoutFormatter;
    private waitressValidator;
    private checkInterpanLock;
}
//# sourceMappingURL=zStackAdapter.d.ts.map