/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.overseer;

import java.lang.invoke.MethodHandles;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.solr.client.solrj.cloud.DistribStateManager;
import org.apache.solr.client.solrj.cloud.SolrCloudManager;
import org.apache.solr.client.solrj.request.CollectionAdminRequest;
import org.apache.solr.cloud.overseer.ReplicaMutator;
import org.apache.solr.cloud.overseer.SliceMutator;
import org.apache.solr.cloud.overseer.ZkStateWriter;
import org.apache.solr.cloud.overseer.ZkWriteCommand;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.DocRouter;
import org.apache.solr.common.cloud.PerReplicaStates;
import org.apache.solr.common.cloud.PerReplicaStatesOps;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionMutator {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected final SolrCloudManager cloudManager;
    protected final DistribStateManager stateManager;
    protected final SolrZkClient zkClient;

    public CollectionMutator(SolrCloudManager cloudManager) {
        this.cloudManager = cloudManager;
        this.stateManager = cloudManager.getDistribStateManager();
        this.zkClient = SliceMutator.getZkClient(cloudManager);
    }

    public ZkWriteCommand createShard(ClusterState clusterState, ZkNodeProps message) {
        String collectionName = message.getStr("collection");
        if (!CollectionMutator.checkCollectionKeyExistence(message)) {
            return ZkStateWriter.NO_OP;
        }
        String shardId = message.getStr("shard");
        DocCollection collection = clusterState.getCollection(collectionName);
        Slice slice = collection.getSlice(shardId);
        if (slice == null) {
            Map replicas = Collections.emptyMap();
            HashMap<String, String> sliceProps = new HashMap<String, String>();
            String shardRange = message.getStr("shard_range");
            String shardState = message.getStr("shard_state");
            String shardParent = message.getStr("shard_parent");
            String shardParentZkSession = message.getStr("shard_parent_zk_session");
            String shardParentNode = message.getStr("shard_parent_node");
            sliceProps.put("range", shardRange);
            sliceProps.put("state", shardState);
            if (shardParent != null) {
                sliceProps.put("parent", shardParent);
            }
            if (shardParentZkSession != null) {
                sliceProps.put("shard_parent_zk_session", shardParentZkSession);
            }
            if (shardParentNode != null) {
                sliceProps.put("shard_parent_node", shardParentNode);
            }
            collection = CollectionMutator.updateSlice(collectionName, collection, new Slice(shardId, replicas, sliceProps, collectionName));
            return new ZkWriteCommand(collectionName, collection);
        }
        log.error("Unable to create Shard: {} because it already exists in collection: {}", (Object)shardId, (Object)collectionName);
        return ZkStateWriter.NO_OP;
    }

    public ZkWriteCommand deleteShard(ClusterState clusterState, ZkNodeProps message) {
        String sliceId = message.getStr("shard");
        String collection = message.getStr("collection");
        if (!CollectionMutator.checkCollectionKeyExistence(message)) {
            return ZkStateWriter.NO_OP;
        }
        log.info("Removing collection: {} shard: {}  from clusterstate", (Object)collection, (Object)sliceId);
        DocCollection coll = clusterState.getCollection(collection);
        LinkedHashMap newSlices = new LinkedHashMap(coll.getSlicesMap());
        newSlices.remove(sliceId);
        DocCollection newCollection = coll.copyWithSlices(newSlices);
        return new ZkWriteCommand(collection, newCollection);
    }

    public ZkWriteCommand modifyCollection(ClusterState clusterState, ZkNodeProps message) {
        if (!CollectionMutator.checkCollectionKeyExistence(message)) {
            return ZkStateWriter.NO_OP;
        }
        DocCollection coll = clusterState.getCollection(message.getStr("collection"));
        Map props = coll.shallowCopy();
        boolean hasAnyOps = false;
        PerReplicaStatesOps replicaOps = null;
        for (String prop : CollectionAdminRequest.MODIFIABLE_COLLECTION_PROPERTIES) {
            if (prop.equals("perReplicaState")) {
                String val = message.getStr("perReplicaState");
                if (val == null) continue;
                boolean enable = Boolean.parseBoolean(val);
                if (enable == coll.isPerReplicaState()) {
                    log.error("trying to set perReplicaState to {} from {}", (Object)val, (Object)coll.isPerReplicaState());
                    continue;
                }
                PerReplicaStates prs = PerReplicaStatesOps.fetch((String)coll.getZNode(), (SolrZkClient)this.zkClient, null);
                PerReplicaStatesOps perReplicaStatesOps = replicaOps = enable ? PerReplicaStatesOps.enable((DocCollection)coll, (PerReplicaStates)prs) : PerReplicaStatesOps.disable((PerReplicaStates)prs);
                if (!enable) {
                    coll = CollectionMutator.updateReplicas(coll, prs);
                }
            }
            if (!message.containsKey(prop)) continue;
            hasAnyOps = true;
            if (message.get(prop) == null) {
                props.remove(prop);
            } else if (prop.equals("collection.configName")) {
                props.put("configName", message.get(prop));
            } else {
                props.put(prop, message.get(prop));
            }
            if (!prop.equals("replicationFactor")) continue;
            props.put("nrtReplicas", message.get("replicationFactor"));
        }
        for (String prop : message.keySet()) {
            if (!prop.startsWith(CollectionAdminRequest.PROPERTY_PREFIX)) continue;
            hasAnyOps = true;
            if (message.get(prop) == null) {
                props.remove(prop);
                continue;
            }
            props.put(prop, message.get(prop));
        }
        if (!hasAnyOps) {
            return ZkStateWriter.NO_OP;
        }
        DocCollection collection = DocCollection.create((String)coll.getName(), (Map)coll.getSlicesMap(), (Map)props, (DocRouter)coll.getRouter(), (int)coll.getZNodeVersion(), (Instant)coll.getCreationTime(), (DocCollection.PrsSupplier)this.stateManager.getPrsSupplier(coll.getName()));
        if (replicaOps == null) {
            return new ZkWriteCommand(coll.getName(), collection);
        }
        return new ZkWriteCommand(coll.getName(), collection, replicaOps, true);
    }

    public static DocCollection updateReplicas(DocCollection coll, PerReplicaStates prs) {
        LinkedHashMap modifiedSlices = new LinkedHashMap();
        coll.forEachReplica((s, replica) -> {
            PerReplicaStates.State prsState = (PerReplicaStates.State)prs.states.get(replica.getName());
            if (prsState != null) {
                Slice slice;
                if (prsState.state != replica.getState()) {
                    slice = modifiedSlices.getOrDefault(replica.getShard(), coll.getSlice(replica.getShard()));
                    replica = ReplicaMutator.setState(replica, prsState.state.toString());
                    modifiedSlices.put(replica.getShard(), slice.copyWith(replica));
                }
                if (prsState.isLeader.booleanValue() != replica.isLeader()) {
                    slice = modifiedSlices.getOrDefault(replica.getShard(), coll.getSlice(replica.getShard()));
                    replica = prsState.isLeader != false ? ReplicaMutator.setLeader(replica) : ReplicaMutator.unsetLeader(replica);
                    modifiedSlices.put(replica.getShard(), slice.copyWith(replica));
                }
            }
        });
        if (!modifiedSlices.isEmpty()) {
            LinkedHashMap slices = new LinkedHashMap(coll.getSlicesMap());
            slices.putAll(modifiedSlices);
            return coll.copyWithSlices(slices);
        }
        return coll;
    }

    public static DocCollection updateSlice(String collectionName, DocCollection collection, Slice slice) {
        LinkedHashMap<String, Slice> slices = new LinkedHashMap<String, Slice>(collection.getSlicesMap());
        slices.put(slice.getName(), slice);
        return collection.copyWithSlices(slices);
    }

    static boolean checkCollectionKeyExistence(ZkNodeProps message) {
        return CollectionMutator.checkKeyExistence(message, "collection");
    }

    static boolean checkKeyExistence(ZkNodeProps message, String key) {
        String value = message.getStr(key);
        if (value == null || value.trim().length() == 0) {
            log.error("Skipping invalid Overseer message because it has no {} specified '{}'", (Object)key, (Object)message);
            return false;
        }
        return true;
    }
}

