/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal.db;

import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.exception.WarningFactory;
import com.ibm.db2.cmx.runtime.internal.StaticProfileConstants;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class ConnectionInfoHelper {
    public static String getConnectionSchema(Connection connection, StaticProfileConstants.DBInfo dBInfo) throws SQLException {
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            String string;
            String string2 = null;
            if (null == dBInfo) {
                dBInfo = new StaticProfileConstants.DBInfo(connection.getMetaData());
            }
            if (null != (string = dBInfo.databaseType_.isDB2() || StaticProfileConstants.DatabaseType.Derby == dBInfo.databaseType_ ? "SELECT CURRENT SCHEMA FROM SYSIBM.SYSDUMMY1 WITH UR FOR READ ONLY" : (StaticProfileConstants.DatabaseType.Oracle == dBInfo.databaseType_ ? "SELECT sys_context('USERENV', 'CURRENT_SCHEMA') FROM DUAL" : null))) {
                statement = connection.prepareStatement(string);
                resultSet = statement.executeQuery();
                if (resultSet.next()) {
                    string2 = resultSet.getString(1);
                }
                if (null == string2) {
                    WarningFactory.createPureQueryWarningForRuntimeLogOnly(Messages.getText("WARN_SCHEMA_NOT_FOUND_BY_SELECT", "CURRENT SCHEMA", string), 11150, ConnectionInfoHelper.class, "getConnectionSchema");
                }
                if (resultSet.next()) {
                    WarningFactory.createPureQueryWarningForRuntimeLogOnly(Messages.getText("WARN_MULTIPLE_SCHEMAS_FOUND_BY_SELECT", "CURRENT SCHEMA", string2, resultSet.getString(1), string), 11151, ConnectionInfoHelper.class, "getConnectionSchema");
                }
            }
            if (null == string2) {
                string2 = connection.getMetaData().getUserName();
            }
            String string3 = string2;
            return string3;
        }
        catch (Throwable throwable) {
            throw ExceptionFactory.createDataSQLExceptionForRuntimeOnly(Messages.getText("MSG_CANNOT_DETERMINE_SPECIAL_REGISTER_VALUE", "CURRENT SCHEMA"), throwable, 11152);
        }
        finally {
            try {
                if (null != statement) {
                    statement.close();
                }
            }
            catch (Throwable throwable) {}
        }
    }

    public static void setConnectionSchema(Connection connection, StaticProfileConstants.DBInfo dBInfo, String string) throws SQLException {
        if (string != null && connection != null) {
            boolean bl2;
            String string2;
            if (null == dBInfo) {
                dBInfo = new StaticProfileConstants.DBInfo(connection.getMetaData());
            }
            if (dBInfo.databaseType_.isDB2() || StaticProfileConstants.DatabaseType.Derby == dBInfo.databaseType_) {
                string2 = "SET CURRENT SCHEMA = ?";
                bl2 = true;
            } else if (StaticProfileConstants.DatabaseType.Oracle == dBInfo.databaseType_) {
                string2 = "alter session set current_schema = \"" + string + "\"";
                bl2 = false;
            } else {
                string2 = null;
                bl2 = false;
            }
            if (null != string2) {
                PreparedStatement preparedStatement = null;
                try {
                    preparedStatement = connection.prepareStatement(string2);
                    if (bl2) {
                        preparedStatement.setString(1, string);
                    }
                    preparedStatement.executeUpdate();
                }
                catch (Throwable throwable) {
                    throw ExceptionFactory.createDataSQLExceptionForRuntimeOnly(Messages.getText("ERR_SET_SPECIAL_REGISTER_VALUE_FAILED", "CURRENT SCHEMA", string, string2), throwable, 11153);
                }
                finally {
                    if (null != preparedStatement) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable) {}
                    }
                }
            }
            throw ExceptionFactory.createDataSQLExceptionForRuntimeOnly(Messages.getText("ERR_SET_SPECIAL_REGISTER_VALUE_UNSUPPORTED_FOR_DB", "CURRENT SCHEMA", string, dBInfo.databaseProductName_, dBInfo.databaseProductVersion_), null, 11154);
        }
    }
}

