# This file has been autogenerated by the pywayland scanner

# Copyright 2016 The Chromium Authors.
# Copyright 2017 Intel Corporation
# Copyright 2018 Collabora, Ltd
# Copyright 2021 Simon Ser
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

from __future__ import annotations

import enum

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)

from ..wayland import WlSurface
from .wp_linux_drm_syncobj_surface_v1 import WpLinuxDrmSyncobjSurfaceV1
from .wp_linux_drm_syncobj_timeline_v1 import WpLinuxDrmSyncobjTimelineV1


class WpLinuxDrmSyncobjManagerV1(Interface):
    """Global for providing explicit synchronization

    This global is a factory interface, allowing clients to request explicit
    synchronization for buffers on a per-surface basis.

    See
    :class:`~pywayland.protocol.linux_drm_syncobj_v1.WpLinuxDrmSyncobjSurfaceV1`
    for more information.
    """

    name = "wp_linux_drm_syncobj_manager_v1"
    version = 1

    class error(enum.IntEnum):
        surface_exists = 0
        invalid_timeline = 1


class WpLinuxDrmSyncobjManagerV1Proxy(Proxy[WpLinuxDrmSyncobjManagerV1]):
    interface = WpLinuxDrmSyncobjManagerV1

    @WpLinuxDrmSyncobjManagerV1.request()
    def destroy(self) -> None:
        """Destroy explicit synchronization factory object

        Destroy this explicit synchronization factory object. Other objects
        shall not be affected by this request.
        """
        self._marshal(0)
        self._destroy()

    @WpLinuxDrmSyncobjManagerV1.request(
        Argument(ArgumentType.NewId, interface=WpLinuxDrmSyncobjSurfaceV1),
        Argument(ArgumentType.Object, interface=WlSurface),
    )
    def get_surface(self, surface: WlSurface) -> Proxy[WpLinuxDrmSyncobjSurfaceV1]:
        """Extend surface interface for explicit synchronization

        Instantiate an interface extension for the given
        :class:`~pywayland.protocol.wayland.WlSurface` to provide explicit
        synchronization.

        If the given :class:`~pywayland.protocol.wayland.WlSurface` already has
        an explicit synchronization object associated, the surface_exists
        protocol error is raised.

        Graphics APIs, like EGL or Vulkan, that manage the buffer queue and
        commits of a :class:`~pywayland.protocol.wayland.WlSurface` themselves,
        are likely to be using this extension internally. If a client is using
        such an API for a :class:`~pywayland.protocol.wayland.WlSurface`, it
        should not directly use this extension on that surface, to avoid
        raising a surface_exists protocol error.

        :param surface:
            the surface
        :type surface:
            :class:`~pywayland.protocol.wayland.WlSurface`
        :returns:
            :class:`~pywayland.protocol.linux_drm_syncobj_v1.WpLinuxDrmSyncobjSurfaceV1`
            -- the new synchronization surface object id
        """
        id = self._marshal_constructor(1, WpLinuxDrmSyncobjSurfaceV1, surface)
        return id

    @WpLinuxDrmSyncobjManagerV1.request(
        Argument(ArgumentType.NewId, interface=WpLinuxDrmSyncobjTimelineV1),
        Argument(ArgumentType.FileDescriptor),
    )
    def import_timeline(self, fd: int) -> Proxy[WpLinuxDrmSyncobjTimelineV1]:
        """Import a drm syncobj timeline

        Import a DRM synchronization object timeline.

        If the FD cannot be imported, the invalid_timeline error is raised.

        :param fd:
            drm_syncobj file descriptor
        :type fd:
            `ArgumentType.FileDescriptor`
        :returns:
            :class:`~pywayland.protocol.linux_drm_syncobj_v1.WpLinuxDrmSyncobjTimelineV1`
        """
        id = self._marshal_constructor(2, WpLinuxDrmSyncobjTimelineV1, fd)
        return id


class WpLinuxDrmSyncobjManagerV1Resource(Resource):
    interface = WpLinuxDrmSyncobjManagerV1


class WpLinuxDrmSyncobjManagerV1Global(Global):
    interface = WpLinuxDrmSyncobjManagerV1


WpLinuxDrmSyncobjManagerV1._gen_c()
WpLinuxDrmSyncobjManagerV1.proxy_class = WpLinuxDrmSyncobjManagerV1Proxy
WpLinuxDrmSyncobjManagerV1.resource_class = WpLinuxDrmSyncobjManagerV1Resource
WpLinuxDrmSyncobjManagerV1.global_class = WpLinuxDrmSyncobjManagerV1Global
