/*
 * Decompiled with CFR 0.152.
 */
package AwsKmsKeyring_Compile;

import Actions_Compile.Action;
import Actions_Compile.ActionWithResult;
import AwsArnParsing_Compile.AwsKmsIdentifierString;
import AwsKmsKeyring_Compile.KmsUnwrapInfo;
import MaterialWrapping_Compile.UnwrapInput;
import MaterialWrapping_Compile.UnwrapMaterial;
import MaterialWrapping_Compile.UnwrapOutput;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import Wrappers_Compile.__default;
import dafny.DafnyMap;
import dafny.DafnySequence;
import dafny.TypeDescriptor;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error;
import software.amazon.cryptography.services.kms.internaldafny.types.DecryptRequest;
import software.amazon.cryptography.services.kms.internaldafny.types.DecryptResponse;
import software.amazon.cryptography.services.kms.internaldafny.types.EncryptionAlgorithmSpec;
import software.amazon.cryptography.services.kms.internaldafny.types.GrantTokenList;
import software.amazon.cryptography.services.kms.internaldafny.types.GrantTokenType;
import software.amazon.cryptography.services.kms.internaldafny.types.IKMSClient;
import software.amazon.cryptography.services.kms.internaldafny.types.RecipientInfo;

public class KmsUnwrapKeyMaterial
implements UnwrapMaterial<KmsUnwrapInfo>,
ActionWithResult<UnwrapInput, UnwrapOutput<KmsUnwrapInfo>, Error>,
Action<UnwrapInput, Result<UnwrapOutput<KmsUnwrapInfo>, Error>> {
    public IKMSClient _client = null;
    public DafnySequence<? extends DafnySequence<? extends Character>> _grantTokens = DafnySequence.empty(GrantTokenType._typeDescriptor());
    public DafnySequence<? extends Character> _awsKmsKey = DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR);
    private static final TypeDescriptor<KmsUnwrapKeyMaterial> _TYPE = TypeDescriptor.referenceWithInitializer(KmsUnwrapKeyMaterial.class, () -> null);

    public void __ctor(IKMSClient client, DafnySequence<? extends Character> awsKmsKey, DafnySequence<? extends DafnySequence<? extends Character>> grantTokens) {
        this._client = client;
        this._awsKmsKey = awsKmsKey;
        this._grantTokens = grantTokens;
    }

    @Override
    public Result<UnwrapOutput<KmsUnwrapInfo>, Error> Invoke(UnwrapInput input) {
        Result<DecryptResponse, software.amazon.cryptography.services.kms.internaldafny.types.Error> _out0;
        Result<UnwrapOutput<KmsUnwrapInfo>, Error> res = Result.Default(UnwrapOutput._typeDescriptor(KmsUnwrapInfo._typeDescriptor()), Error._typeDescriptor(), UnwrapOutput.Default(KmsUnwrapInfo._typeDescriptor(), KmsUnwrapInfo.Default()));
        Outcome<Error> _0_valueOrError0 = Outcome.Default(Error._typeDescriptor());
        _0_valueOrError0 = __default.Need(Error._typeDescriptor(), software.amazon.cryptography.services.kms.internaldafny.types.__default.IsValid__CiphertextType(input.dtor_wrappedMaterial()), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Ciphertext length invalid")));
        if (_0_valueOrError0.IsFailure(Error._typeDescriptor())) {
            res = _0_valueOrError0.PropagateFailure(Error._typeDescriptor(), UnwrapOutput._typeDescriptor(KmsUnwrapInfo._typeDescriptor()));
            return res;
        }
        Result<DafnyMap, Error> _1_valueOrError1 = Result.Default(DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor(), DafnyMap.empty());
        _1_valueOrError1 = AwsKmsUtils_Compile.__default.StringifyEncryptionContext(input.dtor_encryptionContext());
        if (_1_valueOrError1.IsFailure((TypeDescriptor<DafnyMap>)DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor())) {
            res = _1_valueOrError1.PropagateFailure((TypeDescriptor<DafnyMap>)DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor(), UnwrapOutput._typeDescriptor(KmsUnwrapInfo._typeDescriptor()));
            return res;
        }
        DafnyMap _2_stringifiedEncCtx = _1_valueOrError1.Extract((TypeDescriptor<DafnyMap>)DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor());
        DecryptRequest _3_decryptRequest = DecryptRequest.create(input.dtor_wrappedMaterial(), Option.create_Some(DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), _2_stringifiedEncCtx), Option.create_Some(GrantTokenList._typeDescriptor(), this.grantTokens()), Option.create_Some(AwsKmsIdentifierString._typeDescriptor(), this.awsKmsKey()), Option.create_None(EncryptionAlgorithmSpec._typeDescriptor()), Option.create_None(RecipientInfo._typeDescriptor()), Option.create_None(TypeDescriptor.BOOLEAN));
        Result<DecryptResponse, software.amazon.cryptography.services.kms.internaldafny.types.Error> _4_maybeDecryptResponse = _out0 = this.client().Decrypt(_3_decryptRequest);
        Result<DecryptResponse, Error> _5_valueOrError2 = Result.Default(DecryptResponse._typeDescriptor(), Error._typeDescriptor(), DecryptResponse.Default());
        _5_valueOrError2 = _4_maybeDecryptResponse.MapFailure(DecryptResponse._typeDescriptor(), software.amazon.cryptography.services.kms.internaldafny.types.Error._typeDescriptor(), Error._typeDescriptor(), _6_e_boxed0 -> {
            software.amazon.cryptography.services.kms.internaldafny.types.Error _6_e = _6_e_boxed0;
            return Error.create_ComAmazonawsKms(_6_e);
        });
        if (_5_valueOrError2.IsFailure(DecryptResponse._typeDescriptor(), Error._typeDescriptor())) {
            res = _5_valueOrError2.PropagateFailure(DecryptResponse._typeDescriptor(), Error._typeDescriptor(), UnwrapOutput._typeDescriptor(KmsUnwrapInfo._typeDescriptor()));
            return res;
        }
        DecryptResponse _7_decryptResponse = _5_valueOrError2.Extract(DecryptResponse._typeDescriptor(), Error._typeDescriptor());
        Outcome<Error> _8_valueOrError3 = Outcome.Default(Error._typeDescriptor());
        _8_valueOrError3 = __default.Need(Error._typeDescriptor(), _7_decryptResponse.dtor_KeyId().is_Some() && _7_decryptResponse.dtor_KeyId().dtor_value().equals(this.awsKmsKey()) && _7_decryptResponse.dtor_Plaintext().is_Some() && (long)AlgorithmSuites_Compile.__default.GetEncryptKeyLength(input.dtor_algorithmSuite()) == (long)_7_decryptResponse.dtor_Plaintext().dtor_value().cardinalityInt(), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid response from KMS Decrypt")));
        if (_8_valueOrError3.IsFailure(Error._typeDescriptor())) {
            res = _8_valueOrError3.PropagateFailure(Error._typeDescriptor(), UnwrapOutput._typeDescriptor(KmsUnwrapInfo._typeDescriptor()));
            return res;
        }
        UnwrapOutput<KmsUnwrapInfo> _9_output = UnwrapOutput.create(KmsUnwrapInfo._typeDescriptor(), _7_decryptResponse.dtor_Plaintext().dtor_value(), KmsUnwrapInfo.create());
        res = Result.create_Success(UnwrapOutput._typeDescriptor(KmsUnwrapInfo._typeDescriptor()), Error._typeDescriptor(), _9_output);
        return res;
    }

    public IKMSClient client() {
        return this._client;
    }

    public DafnySequence<? extends DafnySequence<? extends Character>> grantTokens() {
        return this._grantTokens;
    }

    public DafnySequence<? extends Character> awsKmsKey() {
        return this._awsKmsKey;
    }

    public static TypeDescriptor<KmsUnwrapKeyMaterial> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "AwsKmsKeyring.KmsUnwrapKeyMaterial";
    }
}

