/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.startree.filter.provider;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.opensearch.index.compositeindex.datacube.startree.index.StarTreeValues;
import org.opensearch.index.compositeindex.datacube.startree.utils.iterator.SortedSetStarTreeValuesIterator;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.search.startree.filter.DimensionFilter;
import org.opensearch.search.startree.filter.ExactMatchDimFilter;
import org.opensearch.search.startree.filter.RangeMatchDimFilter;
import org.opensearch.search.startree.filter.provider.DimensionFilterMapper;
import org.opensearch.search.startree.filter.provider.StarTreeRangeQuery;

abstract class OrdinalFieldMapper
implements DimensionFilterMapper {
    OrdinalFieldMapper() {
    }

    abstract Object parseRawField(String var1, Object var2, MappedFieldType var3) throws IllegalArgumentException;

    @Override
    public DimensionFilter getExactMatchFilter(MappedFieldType mappedFieldType, List<Object> rawValues) {
        ArrayList<Object> convertedValues = new ArrayList<Object>(rawValues.size());
        for (Object rawValue : rawValues) {
            convertedValues.add(this.parseRawField(mappedFieldType.name(), rawValue, mappedFieldType));
        }
        return new ExactMatchDimFilter(mappedFieldType.name(), convertedValues);
    }

    @Override
    public DimensionFilter getRangeMatchFilter(MappedFieldType mappedFieldType, StarTreeRangeQuery rangeQuery) {
        return new RangeMatchDimFilter(mappedFieldType.name(), this.parseRawField(mappedFieldType.name(), rangeQuery.from(), mappedFieldType), this.parseRawField(mappedFieldType.name(), rangeQuery.to(), mappedFieldType), rangeQuery.includeLower(), rangeQuery.includeUpper());
    }

    @Override
    public Optional<Long> getMatchingOrdinal(String dimensionName, Object value, StarTreeValues starTreeValues, DimensionFilter.MatchType matchType) {
        SortedSetStarTreeValuesIterator sortedSetIterator = (SortedSetStarTreeValuesIterator)starTreeValues.getDimensionValuesIterator(dimensionName);
        try {
            if (matchType == DimensionFilter.MatchType.EXACT) {
                long ordinal = sortedSetIterator.lookupTerm((BytesRef)value);
                return ordinal >= 0L ? Optional.of(ordinal) : Optional.empty();
            }
            TermsEnum termsEnum = sortedSetIterator.termsEnum();
            TermsEnum.SeekStatus seekStatus = termsEnum.seekCeil((BytesRef)value);
            switch (matchType) {
                case GTE: {
                    return seekStatus == TermsEnum.SeekStatus.END ? Optional.empty() : Optional.of(termsEnum.ord());
                }
                case GT: {
                    return switch (seekStatus) {
                        default -> throw new MatchException(null, null);
                        case TermsEnum.SeekStatus.END -> Optional.empty();
                        case TermsEnum.SeekStatus.FOUND -> {
                            if (termsEnum.ord() + 1L < sortedSetIterator.getValueCount()) {
                                yield Optional.of(termsEnum.ord() + 1L);
                            }
                            yield Optional.empty();
                        }
                        case TermsEnum.SeekStatus.NOT_FOUND -> Optional.of(termsEnum.ord());
                    };
                }
                case LTE: {
                    if (seekStatus == TermsEnum.SeekStatus.NOT_FOUND) {
                        return termsEnum.ord() - 1L >= 0L ? Optional.of(termsEnum.ord() - 1L) : Optional.empty();
                    }
                    return Optional.of(termsEnum.ord());
                }
                case LT: {
                    if (seekStatus == TermsEnum.SeekStatus.END) {
                        return Optional.of(termsEnum.ord());
                    }
                    return termsEnum.ord() - 1L >= 0L ? Optional.of(termsEnum.ord() - 1L) : Optional.empty();
                }
            }
            throw new IllegalStateException("unexpected matchType " + String.valueOf((Object)matchType));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int compareValues(Object v1, Object v2) {
        if (!(v1 instanceof BytesRef) || !(v2 instanceof BytesRef)) {
            throw new IllegalArgumentException("Expected BytesRef values for comparison");
        }
        return ((BytesRef)v1).compareTo((BytesRef)v2);
    }
}

