#!/bin/sh -eE

if [ ! -d "${HPCX_DIR}" ]; then
    cat <<"EOF"

Error: no hpcx environment loaded

Please load hpcx environment from module or shell script and rerun this script
Refer to README.txt file for more info

Example:

% module use $HPCX_DIR/modulefiles
% module load hpcx

-or-

% source $HPCX_DIR/hpcx_init.sh
% load_hpcx

EOF
    exit 1
fi

if [ ! -w "${HPCX_DIR}" ]; then
    echo "ERROR: ${HPCX_DIR} is not writable for user $USER, please fix and re-run"
    exit 1
fi

# shellcheck disable=SC2044
for LA_FILE in $(find "${HPCX_DIR}/" -name "*.la" -print); do
    LA_DIR=$(dirname "${LA_FILE}")
    sed -i -e "s,^libdir=.*,libdir='${LA_DIR}',g" "${LA_FILE}"
done

# shellcheck disable=SC2044
for PC_FILE in $(find "${HPCX_DIR}/" -name "*.pc" -print); do
    sed -i -e "s,^hpcx_home=.*,hpcx_home=${HPCX_DIR},g" "${PC_FILE}"
done

exit 0
