local function choose( t ) return t[rnd.rnd(1,#t)] end
local function rnd_colour() return 'rgb('..rnd.rnd(0,255)..', '..rnd.rnd(0,255)..', '..rnd.rnd(0,255)..')' end
--local clothes_colour = { '#656565', '#BEBEBE', '#D78331', '#626769', '#4F9998', '#B9E0EB', '#3F3131', '#3A683B', '#304B72' }
local skin_colour = { '#F7C4C4', '#E6C7B8', '#c89393', '#B19878', '#975e5e', '#5e4024' }
local metal_colour = { '#5A6266', '#dc970f', '#aaa59c', '#995607', '#494C47' }
local eye_colour = { '#97CDEF', '#662e18', '#67b974', '#d6a568', '#7A5529', '#FF00FF' }
local hair_colour = { '#513928', '#b2a295', '#a99427', '#341f1f', '#8FB383', '#C31C1C', '#8FB383', '#C31C1C', rnd_colour() }
local nails_colour = { '#8FB383', '#C31C1C', rnd_colour() }
local lips_colour = { "#4F1B3F", "#E2AFAF", rnd_colour()}
local hair_svgs = {
   { back = false,                  mid = false,                    front = false, },
   { back = false,                  mid = "head_hair_mid_ver1.svg", front = false, },
   { back = "hair_back_ver2.svg",   mid = false,                    front = "hair_front_ver2.svg", },
   { back = "hair_back_ver3.svg",   mid = "head_hair_mid_ver3.svg", front = "hair_front_ver3.svg", },
   { back = "hair_back_ver4.svg",   mid = "head_hair_mid_ver4.svg", front = "hair_front_ver4.svg", },
}
local clothes_svgs = {
   {
      back = false,
      mid = "clothes_ver1.svg",
      front = false,
   }, {
      back = "hand_left_clothes_ver2.svg",
      mid = "clothes_ver2.svg",
      front = "hand_right_clothes_ver2.svg",
   }, {
      back = "hand_left_clothes_ver3.svg",
      mid = "clothes_ver3.svg",
      front = "hand_right_clothes_ver3.svg",
   }, {
      back = "hand_left_clothes_ver4.svg",
      mid = "clothes_ver4.svg",
      front = "hand_right_clothes_ver4.svg",
   },{
      back = false,
      mid = "clothes_ver5.svg",
      front = false,
   },{
      back = false,
      mid = "clothes_ver6.svg",
      front = false,
   }
}
return function ()
   local hair = choose(hair_svgs)
   local clothes = choose(clothes_svgs)
   local skin_index = rnd.rnd(1,#skin_colour)

   return {
      portraitview = {
         --Viewport is reference to the image coordinates
         viewxs = 150,
         viewys = 30,
         viewxe = 600,
         viewye = 450,
         -- Width and height are final render
         width  = 400,
         height = 300,
      },
      replace = {
         {"#aaaaaa", skin_colour[skin_index]}, -- skin
         {"#aaaaa0", "#F7C4C4"}, -- palm
         {"#cccccc", choose(hair_colour)}, -- hair
         {"#bbbbbb", choose(eye_colour)}, -- eye colour
         {"#ff0000", rnd_colour()}, -- clothes main
         {"#00ff00", rnd_colour()}, -- clothes secondary
         {"#0000ff", rnd_colour()}, -- clothes trim
         {"#0ffff0", choose(metal_colour)}, -- clothes metal
         {"#f0000f", choose(metal_colour)}, -- clothes dmetal
         {"#ababab", choose(lips_colour)}, -- lips
         {"#abcabc", choose(nails_colour)}, -- nails
      },
      hair.back,
      choose{
         "hand_left_base.svg",
      },
      clothes.back,
      choose{
         false,
         "hand_left_accessories_ver1.svg",
         "hand_left_accessories_ver2.svg",
      },
      choose{
         "body.svg",
      },
      clothes.mid,
      choose{
         "hand_right_base.svg",
      },
      choose{
         "hand_right_accessories_ver1.svg",
         "hand_right_accessories_ver2.svg",
      },
      clothes.front,
      choose{
         "head_base_ver1.svg",
         "head_base_ver2.svg",
         "head_base_ver3.svg",
      },
     choose{
         "head_mouth_ver1.svg",
         "head_mouth_ver2.svg",
         "head_mouth_ver3.svg",
      },
      choose{
         "head_nose_ver1.svg",
         "head_nose_ver2.svg",
         "head_nose_ver3.svg",
      },
      choose{
         "head_eyes_ver1.svg",
         "head_eyes_ver2.svg",
         "head_eyes_ver3.svg",
      },
     choose{
         "head_brows_holder_ver1.svg",
         "head_brows_holder_ver2.svg",
         "head_brows_holder_ver3.svg",
         "head_brows_holder_ver4.svg",
      },
      hair.mid,
     choose{
         "head_ears_ver1.svg",
      },
      hair.front,
   }
end
