/*
 * Decompiled with CFR 0.152.
 */
package raven.toast.ui;

import com.formdev.flatlaf.extras.FlatSVGIcon;
import java.awt.Color;
import java.awt.Cursor;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.JWindow;
import javax.swing.UIManager;
import raven.toast.Notifications;
import raven.toast.ui.ToastPanelUI;

public class ToastNotificationPanel
extends JPanel {
    protected JWindow window;
    protected JLabel labelIcon;
    protected JTextPane textPane;
    private Notifications.Type type;

    public ToastNotificationPanel() {
        this.installDefault();
    }

    private void installPropertyStyle() {
        String key = this.getKey();
        String outlineColor = this.toTextColor(this.getDefaultColor());
        String outline = this.convertsKey(key, "outlineColor", outlineColor);
        this.putClientProperty("FlatLaf.style", "background:" + this.convertsKey(key, "background", "$Panel.background") + ";outlineColor:" + outline + ";effectColor:" + this.convertsKey(key, "effectColor", outline));
        this.textPane.putClientProperty("FlatLaf.style", "foreground:" + this.convertsKey(this.getKey(), "foreground", "$TextPane.foreground") + ";");
    }

    private String convertsKey(String key, String value, String defaultValue) {
        return "if($Toast." + key + "." + value + ", $Toast." + key + "." + value + ", if($Toast." + value + ", $Toast." + value + ", " + defaultValue + "))";
    }

    @Override
    public void updateUI() {
        this.setUI(new ToastPanelUI());
        this.removeDialogBackground();
    }

    private void removeDialogBackground() {
        if (this.window != null) {
            Color bg = this.getBackground();
            this.window.setBackground(new Color(bg.getRed(), bg.getGreen(), bg.getBlue(), 0));
            this.window.setSize(this.getPreferredSize());
        }
    }

    private void installDefault() {
        this.labelIcon = new JLabel();
        this.textPane = new JTextPane();
        this.textPane.setText("Hello!\nToast Notification");
        this.textPane.setOpaque(false);
        this.textPane.setFocusable(false);
        this.textPane.setCursor(Cursor.getDefaultCursor());
        this.putClientProperty("Toast.icon", this.labelIcon);
        this.putClientProperty("Toast.component", this.textPane);
    }

    public void set(Notifications.Type type, String message) {
        this.type = type;
        this.labelIcon.setIcon(this.getDefaultIcon());
        this.textPane.setText(message);
        this.installPropertyStyle();
    }

    public void setDialog(JWindow window) {
        this.window = window;
        this.removeDialogBackground();
    }

    public Color getDefaultColor() {
        if (this.type == Notifications.Type.SUCCESS) {
            return Color.decode("#2e7d32");
        }
        if (this.type == Notifications.Type.INFO) {
            return Color.decode("#0288d1");
        }
        if (this.type == Notifications.Type.WARNING) {
            return Color.decode("#ed6c02");
        }
        return Color.decode("#d32f2f");
    }

    private String toTextColor(Color color) {
        return "rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")";
    }

    public Icon getDefaultIcon() {
        String key = this.getKey();
        Icon icon = UIManager.getIcon("Toast." + key + ".icon");
        if (icon != null) {
            return icon;
        }
        FlatSVGIcon svgIcon = new FlatSVGIcon(this.getClass().getResource("/raven/toast/svg/" + key + ".svg"));
        FlatSVGIcon.ColorFilter colorFilter = new FlatSVGIcon.ColorFilter();
        colorFilter.add(new Color(150, 150, 150), this.getDefaultColor());
        svgIcon.setColorFilter(colorFilter);
        return svgIcon;
    }

    public String getKey() {
        if (this.type == Notifications.Type.SUCCESS) {
            return "success";
        }
        if (this.type == Notifications.Type.INFO) {
            return "info";
        }
        if (this.type == Notifications.Type.WARNING) {
            return "warning";
        }
        return "error";
    }
}

