/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jandex;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.ImmutableArrayList;
import org.jboss.jandex.Type;
import org.jboss.jandex.TypeInterning;

public class ParameterizedType
extends Type {
    private final Type[] arguments;
    private final Type owner;
    private int hash;

    public static ParameterizedType create(DotName name, Type ... arguments) {
        return new ParameterizedType(name, arguments, null);
    }

    public static ParameterizedType create(String name, Type ... arguments) {
        return ParameterizedType.create(DotName.createSimple(name), arguments);
    }

    public static ParameterizedType create(Class<?> clazz, Type ... arguments) {
        return ParameterizedType.create(DotName.createSimple(clazz.getName()), arguments);
    }

    public static ParameterizedType create(DotName name, Type[] arguments, Type owner) {
        return new ParameterizedType(name, arguments, owner);
    }

    public static ParameterizedType create(String name, Type[] arguments, Type owner) {
        return ParameterizedType.create(DotName.createSimple(name), arguments, owner);
    }

    public static ParameterizedType create(Class<?> clazz, Type[] arguments, Type owner) {
        return ParameterizedType.create(DotName.createSimple(clazz.getName()), arguments, owner);
    }

    public static Builder builder(DotName name) {
        return new Builder(name);
    }

    public static Builder builder(Class<?> clazz) {
        return ParameterizedType.builder(DotName.createSimple(clazz.getName()));
    }

    ParameterizedType(DotName name, Type[] arguments, Type owner) {
        this(name, arguments, owner, null);
    }

    ParameterizedType(DotName name, Type[] arguments, Type owner, AnnotationInstance[] annotations) {
        super(name, annotations);
        this.arguments = arguments == null ? EMPTY_ARRAY : arguments;
        this.owner = owner;
    }

    public List<Type> arguments() {
        return new ImmutableArrayList<Type>(this.arguments);
    }

    Type[] argumentsArray() {
        return this.arguments;
    }

    public Type owner() {
        return this.owner;
    }

    @Override
    public Type.Kind kind() {
        return Type.Kind.PARAMETERIZED_TYPE;
    }

    @Override
    public ParameterizedType asParameterizedType() {
        return this;
    }

    @Override
    ParameterizedType copyType(AnnotationInstance[] newAnnotations) {
        return new ParameterizedType(this.name(), this.arguments, this.owner, newAnnotations);
    }

    @Override
    Type withoutAnnotations() {
        Type[] newArguments = new Type[this.arguments.length];
        for (int i = 0; i < this.arguments.length; ++i) {
            newArguments[i] = this.arguments[i].withoutAnnotations();
        }
        return new ParameterizedType(this.name(), newArguments, this.owner, null);
    }

    ParameterizedType copyType(Type[] arguments) {
        return new ParameterizedType(this.name(), arguments, this.owner, this.annotationArray());
    }

    ParameterizedType copyType(int argumentIndex, Type argument) {
        if (argumentIndex > this.arguments.length) {
            throw new IllegalArgumentException("Type argument index outside of bounds");
        }
        Type[] arguments = (Type[])this.arguments.clone();
        arguments[argumentIndex] = argument;
        return new ParameterizedType(this.name(), arguments, this.owner, this.annotationArray());
    }

    ParameterizedType copyType(Type owner) {
        return new ParameterizedType(this.name(), this.arguments, owner, this.annotationArray());
    }

    @Override
    String toString(boolean simple) {
        StringBuilder builder = new StringBuilder();
        if (this.owner != null) {
            builder.append(this.owner);
            builder.append('.');
            this.appendAnnotations(builder);
            builder.append(this.name().local());
        } else {
            String packagePrefix = this.name().packagePrefix();
            if (packagePrefix != null) {
                builder.append(packagePrefix).append('.');
            }
            this.appendAnnotations(builder);
            builder.append(this.name().withoutPackagePrefix());
        }
        if (this.arguments.length > 0) {
            builder.append('<');
            builder.append(this.arguments[0].toString(true));
            for (int i = 1; i < this.arguments.length; ++i) {
                builder.append(", ").append(this.arguments[i].toString(true));
            }
            builder.append('>');
        }
        return builder.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        ParameterizedType other = (ParameterizedType)o;
        return (this.owner == other.owner || this.owner != null && this.owner.equals(other.owner)) && Arrays.equals(this.arguments, other.arguments);
    }

    @Override
    public int hashCode() {
        int hash = this.hash;
        if (hash != 0) {
            return hash;
        }
        hash = super.hashCode();
        hash = 31 * hash + Arrays.hashCode(this.arguments);
        this.hash = hash = 31 * hash + (this.owner != null ? this.owner.hashCode() : 0);
        return this.hash;
    }

    @Override
    boolean internEquals(Object o) {
        if (this == o) {
            return true;
        }
        if (!super.internEquals(o)) {
            return false;
        }
        ParameterizedType other = (ParameterizedType)o;
        return (this.owner == other.owner || this.owner != null && this.owner.internEquals(other.owner)) && TypeInterning.arrayEquals(this.arguments, other.arguments);
    }

    @Override
    int internHashCode() {
        int hash = super.internHashCode();
        hash = 31 * hash + TypeInterning.arrayHashCode(this.arguments);
        hash = 31 * hash + (this.owner != null ? this.owner.internHashCode() : 0);
        return hash;
    }

    public static final class Builder
    extends Type.Builder<Builder> {
        private List<Type> arguments = new ArrayList<Type>();
        private Type owner;

        Builder(DotName name) {
            super(name);
        }

        public Builder addArgument(Type argument) {
            this.arguments.add(Objects.requireNonNull(argument));
            return this;
        }

        public Builder addArgument(Class<?> clazz) {
            return this.addArgument(ClassType.create(clazz));
        }

        public Builder setOwner(Type owner) {
            this.owner = Objects.requireNonNull(owner);
            return this;
        }

        public ParameterizedType build() {
            return new ParameterizedType(this.name, this.arguments.isEmpty() ? Type.EMPTY_ARRAY : this.arguments.toArray(Type.EMPTY_ARRAY), this.owner, this.annotationsArray());
        }
    }
}

