/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.remote;

import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.util.concurrent.BlockingManager;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.infinispan.util.InfinispanUtils;
import org.keycloak.marshalling.Marshalling;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.UserLoginFailureProvider;
import org.keycloak.models.UserLoginFailureProviderFactory;
import org.keycloak.models.UserModel;
import org.keycloak.models.sessions.infinispan.changes.remote.remover.query.ByRealmIdQueryConditionalRemover;
import org.keycloak.models.sessions.infinispan.changes.remote.updater.UpdaterFactory;
import org.keycloak.models.sessions.infinispan.changes.remote.updater.loginfailures.LoginFailuresUpdater;
import org.keycloak.models.sessions.infinispan.entities.LoginFailureEntity;
import org.keycloak.models.sessions.infinispan.entities.LoginFailureKey;
import org.keycloak.models.sessions.infinispan.remote.RemoteUserLoginFailureProvider;
import org.keycloak.models.sessions.infinispan.remote.transaction.LoginFailureChangeLogTransaction;
import org.keycloak.models.sessions.infinispan.remote.transaction.RemoteChangeLogTransaction;
import org.keycloak.models.sessions.infinispan.transaction.InfinispanTransactionProvider;
import org.keycloak.provider.EnvironmentDependentProviderFactory;
import org.keycloak.provider.Provider;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;
import org.keycloak.provider.ServerInfoAwareProviderFactory;

public class RemoteUserLoginFailureProviderFactory
implements UserLoginFailureProviderFactory<RemoteUserLoginFailureProvider>,
UpdaterFactory<LoginFailureKey, LoginFailureEntity, LoginFailuresUpdater>,
EnvironmentDependentProviderFactory,
RemoteChangeLogTransaction.SharedState<LoginFailureKey, LoginFailureEntity>,
ServerInfoAwareProviderFactory {
    private static final Logger log = Logger.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROTO_ENTITY = Marshalling.protoEntity(LoginFailureEntity.class);
    private volatile RemoteCache<LoginFailureKey, LoginFailureEntity> cache;
    private volatile BlockingManager blockingManager;
    private volatile int maxRetries = 10;
    private volatile int backOffBaseTimeMillis = 10;

    public RemoteUserLoginFailureProvider create(KeycloakSession session) {
        return new RemoteUserLoginFailureProvider(this.createAndEnlistTransaction(session));
    }

    public void init(Config.Scope config) {
        this.maxRetries = InfinispanUtils.getMaxRetries(config);
        this.backOffBaseTimeMillis = InfinispanUtils.getRetryBaseTimeMillis(config);
    }

    public void postInit(KeycloakSessionFactory factory) {
        try (KeycloakSession session = factory.create();){
            InfinispanConnectionProvider provider = (InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class);
            this.cache = provider.getRemoteCache("loginFailures");
            this.blockingManager = provider.getBlockingManager();
        }
        factory.register(event -> {
            if (event instanceof UserModel.UserRemovedEvent) {
                UserModel.UserRemovedEvent userRemovedEvent = (UserModel.UserRemovedEvent)event;
                UserLoginFailureProvider provider = (UserLoginFailureProvider)userRemovedEvent.getKeycloakSession().getProvider(UserLoginFailureProvider.class, this.getId());
                provider.removeUserLoginFailure(userRemovedEvent.getRealm(), userRemovedEvent.getUser().getId());
            }
        });
        log.debugf("Post Init. Cache=%s", (Object)this.cache.getName());
    }

    public void close() {
        this.cache = null;
    }

    public String getId() {
        return "remote";
    }

    public int order() {
        return 1;
    }

    public boolean isSupported(Config.Scope config) {
        return InfinispanUtils.isRemoteInfinispan();
    }

    public List<ProviderConfigProperty> getConfigMetadata() {
        ProviderConfigurationBuilder builder = ProviderConfigurationBuilder.create();
        InfinispanUtils.configureMaxRetries(builder);
        InfinispanUtils.configureRetryBaseTime(builder);
        return builder.build();
    }

    public Map<String, String> getOperationalInfo() {
        HashMap<String, String> map = new HashMap<String, String>();
        InfinispanUtils.maxRetriesToOperationalInfo(map, this.maxRetries);
        InfinispanUtils.retryBaseTimeMillisToOperationalInfo(map, this.backOffBaseTimeMillis);
        return map;
    }

    public Set<Class<? extends Provider>> dependsOn() {
        return Set.of(InfinispanTransactionProvider.class);
    }

    @Override
    public LoginFailuresUpdater create(LoginFailureKey key, LoginFailureEntity entity) {
        return LoginFailuresUpdater.create(key, entity);
    }

    @Override
    public LoginFailuresUpdater wrapFromCache(LoginFailureKey key, LoginFailureEntity value, long version) {
        return LoginFailuresUpdater.wrap(key, value, version);
    }

    @Override
    public LoginFailuresUpdater deleted(LoginFailureKey key) {
        return LoginFailuresUpdater.delete(key);
    }

    @Override
    public RemoteCache<LoginFailureKey, LoginFailureEntity> cache() {
        return this.cache;
    }

    @Override
    public int maxRetries() {
        return this.maxRetries;
    }

    @Override
    public int backOffBaseTimeMillis() {
        return this.backOffBaseTimeMillis;
    }

    @Override
    public BlockingManager blockingManager() {
        return this.blockingManager;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = Math.max(0, maxRetries);
    }

    private LoginFailureChangeLogTransaction createAndEnlistTransaction(KeycloakSession session) {
        InfinispanTransactionProvider provider = (InfinispanTransactionProvider)session.getProvider(InfinispanTransactionProvider.class);
        LoginFailureChangeLogTransaction tx = new LoginFailureChangeLogTransaction(this, this, new ByRealmIdQueryConditionalRemover<LoginFailureKey, LoginFailureEntity>(PROTO_ENTITY));
        provider.registerTransaction(tx);
        return tx;
    }
}

